"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataset = void 0;

const getDataset = async bpfs => {
  const intents = await bpfs.directoryListing('./intents', '*.json');
  const entities = await bpfs.directoryListing('./entities', '*.json');
  const botfile = await bpfs.readFileAsObject('.', 'bot.config.json');
  return {
    defaultLanguage: botfile.defaultLanguage,
    otherLanguages: (botfile.languages || []).filter(lang => lang !== botfile.defaultLanguage),
    intents: await Promise.map(intents, file => bpfs.readFileAsObject('./intents', file)),
    entities: await Promise.map(entities, file => bpfs.readFileAsObject('./entities', file))
  };
};

exports.getDataset = getDataset;
//# sourceMappingURL=dataset.js.map