const { default: defaultResolver } = require('jest-resolve/build/defaultResolver')

const nativeExtensions = [
  'node_sqlite3.node',
  'fse.node',
  'crfsuite.node',
  'fasttext.node',
  'node-svm.node',
  'sentencepiece.node'
]

module.exports = (name, options) => {
  // a popular convention among "isomorphic" libraries is to name their different implementation lib.browser.js and lib.node.js
  // requiring ./lib.node would fail without the native ext check
  if (nativeExtensions.some(next => name.includes(next))) {
    try {
      return global.rewire(name)
    } catch (err) {
      return defaultResolver(name, options)
    }
  }

  return defaultResolver(name, options)
}
