// Code generated by Wire. DO NOT EDIT.

//go:generate wire
//+build !wireinject

package standalone

import (
	"context"
	"github.com/aquasecurity/fanal/analyzer"
	"github.com/aquasecurity/fanal/cache"
	"github.com/aquasecurity/fanal/extractor/docker"
	"github.com/aquasecurity/trivy-db/pkg/db"
	"github.com/aquasecurity/trivy/pkg/detector/library"
	"github.com/aquasecurity/trivy/pkg/detector/ospkg"
	"github.com/aquasecurity/trivy/pkg/scanner"
	"github.com/aquasecurity/trivy/pkg/scanner/local"
	"github.com/aquasecurity/trivy/pkg/types"
	"github.com/aquasecurity/trivy/pkg/vulnerability"
	"time"
)

// Injectors from inject.go:

func initializeDockerScanner(ctx context.Context, imageName string, layerCache cache.ImageCache, localImageCache cache.LocalImageCache, timeout time.Duration) (scanner.Scanner, func(), error) {
	applier := analyzer.NewApplier(localImageCache)
	detector := ospkg.Detector{}
	driverFactory := library.DriverFactory{}
	libraryDetector := library.NewDetector(driverFactory)
	localScanner := local.NewScanner(applier, detector, libraryDetector)
	dockerOption, err := types.GetDockerOption(timeout)
	if err != nil {
		return scanner.Scanner{}, nil, err
	}
	extractor, cleanup, err := docker.NewDockerExtractor(ctx, imageName, dockerOption)
	if err != nil {
		return scanner.Scanner{}, nil, err
	}
	config := analyzer.New(extractor, layerCache)
	scannerScanner := scanner.NewScanner(localScanner, config)
	return scannerScanner, func() {
		cleanup()
	}, nil
}

func initializeArchiveScanner(ctx context.Context, filePath string, layerCache cache.ImageCache, localImageCache cache.LocalImageCache, timeout time.Duration) (scanner.Scanner, func(), error) {
	applier := analyzer.NewApplier(localImageCache)
	detector := ospkg.Detector{}
	driverFactory := library.DriverFactory{}
	libraryDetector := library.NewDetector(driverFactory)
	localScanner := local.NewScanner(applier, detector, libraryDetector)
	dockerOption, err := types.GetDockerOption(timeout)
	if err != nil {
		return scanner.Scanner{}, nil, err
	}
	extractor, cleanup, err := docker.NewDockerArchiveExtractor(ctx, filePath, dockerOption)
	if err != nil {
		return scanner.Scanner{}, nil, err
	}
	config := analyzer.New(extractor, layerCache)
	scannerScanner := scanner.NewScanner(localScanner, config)
	return scannerScanner, func() {
		cleanup()
	}, nil
}

func initializeVulnerabilityClient() vulnerability.Client {
	config := db.Config{}
	client := vulnerability.NewClient(config)
	return client
}
