// Code generated by Wire. DO NOT EDIT.

//go:generate wire
//+build !wireinject

package server

import (
	"github.com/aquasecurity/trivy-db/pkg/db"
	db2 "github.com/aquasecurity/trivy/pkg/db"
	library2 "github.com/aquasecurity/trivy/pkg/detector/library"
	ospkg2 "github.com/aquasecurity/trivy/pkg/detector/ospkg"
	"github.com/aquasecurity/trivy/pkg/github"
	"github.com/aquasecurity/trivy/pkg/indicator"
	"github.com/aquasecurity/trivy/pkg/rpc/server/library"
	"github.com/aquasecurity/trivy/pkg/rpc/server/ospkg"
	"github.com/aquasecurity/trivy/pkg/vulnerability"
	"k8s.io/utils/clock"
)

// Injectors from inject.go:

func initializeOspkgServer() *ospkg.Server {
	detector := ospkg2.Detector{}
	config := db.Config{}
	client := vulnerability.NewClient(config)
	server := ospkg.NewServer(detector, client)
	return server
}

func initializeLibServer() *library.Server {
	driverFactory := library2.DriverFactory{}
	detector := library2.NewDetector(driverFactory)
	config := db.Config{}
	client := vulnerability.NewClient(config)
	server := library.NewServer(detector, client)
	return server
}

func initializeDBWorker(quiet bool) dbWorker {
	config := db.Config{}
	client := github.NewClient()
	progressBar := indicator.NewProgressBar(quiet)
	realClock := clock.RealClock{}
	dbClient := db2.NewClient(config, client, progressBar, realClock)
	serverDbWorker := newDBWorker(dbClient)
	return serverDbWorker
}
