// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may
// not use this file except in compliance with the License. A copy of the
// License is located at
//
// 	http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
// express or implied. See the License for the specific language governing
// permissions and limitations under the License.

package operations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"

	client_models "github.com/firecracker-microvm/firecracker-go-sdk/client/models"
)

// NewPutLoggerParams creates a new PutLoggerParams object
// with the default values initialized.
func NewPutLoggerParams() *PutLoggerParams {
	var ()
	return &PutLoggerParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewPutLoggerParamsWithTimeout creates a new PutLoggerParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewPutLoggerParamsWithTimeout(timeout time.Duration) *PutLoggerParams {
	var ()
	return &PutLoggerParams{

		timeout: timeout,
	}
}

// NewPutLoggerParamsWithContext creates a new PutLoggerParams object
// with the default values initialized, and the ability to set a context for a request
func NewPutLoggerParamsWithContext(ctx context.Context) *PutLoggerParams {
	var ()
	return &PutLoggerParams{

		Context: ctx,
	}
}

// NewPutLoggerParamsWithHTTPClient creates a new PutLoggerParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewPutLoggerParamsWithHTTPClient(client *http.Client) *PutLoggerParams {
	var ()
	return &PutLoggerParams{
		HTTPClient: client,
	}
}

/*PutLoggerParams contains all the parameters to send to the API endpoint
for the put logger operation typically these are written to a http.Request
*/
type PutLoggerParams struct {

	/*Body
	  Logging system description

	*/
	Body *client_models.Logger

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the put logger params
func (o *PutLoggerParams) WithTimeout(timeout time.Duration) *PutLoggerParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the put logger params
func (o *PutLoggerParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the put logger params
func (o *PutLoggerParams) WithContext(ctx context.Context) *PutLoggerParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the put logger params
func (o *PutLoggerParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the put logger params
func (o *PutLoggerParams) WithHTTPClient(client *http.Client) *PutLoggerParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the put logger params
func (o *PutLoggerParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the put logger params
func (o *PutLoggerParams) WithBody(body *client_models.Logger) *PutLoggerParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the put logger params
func (o *PutLoggerParams) SetBody(body *client_models.Logger) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *PutLoggerParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
