// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may
// not use this file except in compliance with the License. A copy of the
// License is located at
//
// 	http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
// express or implied. See the License for the specific language governing
// permissions and limitations under the License.

package client_models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Vsock vsock
// swagger:model Vsock
type Vsock struct {

	// Guest Vsock CID
	// Minimum: 3
	GuestCid int64 `json:"guest_cid,omitempty"`

	// id
	// Required: true
	ID *string `json:"id"`
}

// Validate validates this vsock
func (m *Vsock) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateGuestCid(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Vsock) validateGuestCid(formats strfmt.Registry) error {

	if swag.IsZero(m.GuestCid) { // not required
		return nil
	}

	if err := validate.MinimumInt("guest_cid", "body", int64(m.GuestCid), 3, false); err != nil {
		return err
	}

	return nil
}

func (m *Vsock) validateID(formats strfmt.Registry) error {

	if err := validate.Required("id", "body", m.ID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Vsock) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Vsock) UnmarshalBinary(b []byte) error {
	var res Vsock
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
