# v0.4.2

The second patch release for the `v0.4.x` release stream.
If you want to have a look, here are changes for versions [v0.4.0](https://github.com/weaveworks/ignite/blob/master/CHANGELOG.md#v040)
and [v0.4.1](https://github.com/weaveworks/ignite/blob/master/CHANGELOG.md#v041).

In this release, we had 5 PRs from 3 community contributors, thank you for your amazing work :tada:!
We hope to see this trend continue, all help is very welcome to this community-driven project!

## New Features / UX Improvements

 - Flannel is now usable with the Ignite kernel thanks to adding the VXLAN kernel module ([#154](https://github.com/weaveworks/ignite/pull/154), [@curx](https://github.com/curx))
 - HAProxy checking for Kubernetes API `/healthz` endpoint ([#156](https://github.com/weaveworks/ignite/pull/156), [@curx](https://github.com/curx))
 - Allow unmarshaling unquoted UIDs from JSON for convenience ([#178](https://github.com/weaveworks/ignite/pull/178), [@twelho](https://github.com/twelho))
 - The VM images based on `Ubuntu`, `CentOS` and `Amazon Linux` can now be built on top of a specific release ([#193](https://github.com/weaveworks/ignite/pull/193), [@twelho](https://github.com/twelho))


## Bugfixes

 - Import only `/boot` and `/lib` from kernel OCI images, don't overwrite e.g. `/etc/resolv.conf` ([#168](https://github.com/weaveworks/ignite/pull/168), [@twelho](https://github.com/twelho))
 - The creation timestamp can now be omitted from specification files, it will be added automatically ([#174](https://github.com/weaveworks/ignite/pull/174), [@twelho](https://github.com/twelho))
 - List all VMs instead of just running ones when calling `ignite vm ls/list` ([#179](https://github.com/weaveworks/ignite/pull/179), [@twelho](https://github.com/twelho))
 - More robust kernel version checking if e.g. the `strings` binary is not available ([#189](https://github.com/weaveworks/ignite/pull/189), [@twelho](https://github.com/twelho))


## Docs improvements

 - Fix formatting in `README.md` ([#166](https://github.com/weaveworks/ignite/pull/166), [@sftim](https://github.com/sftim))
 - Fix link to `CentOS` image in `README.md` ([#161](https://github.com/weaveworks/ignite/pull/161), [@akshaychhajed](https://github.com/akshaychhajed))
 - Added `loop` kernel module dependency to `docs/dependencies.md` ([#155](https://github.com/weaveworks/ignite/pull/155), [@curx](https://github.com/curx))
 - Clarify usage on `Ubuntu` and `CentOS`, embed links to [Joe Beda](https://twitter.com/jbeda)'s TGIK recording ([#175](https://github.com/weaveworks/ignite/pull/175), [@luxas](https://github.com/luxas))
 - Added a brand new `FAQ`! Check it out at [FAQ.md](../FAQ.md)! ([#197](https://github.com/weaveworks/ignite/pull/197), [@luxas](https://github.com/luxas))


## Trying it out / Next Steps!

In short:

```bash
export VERSION=v0.4.2
curl -fLo ignite https://github.com/weaveworks/ignite/releases/download/${VERSION}/ignite
chmod +x ignite
sudo mv ignite /usr/local/bin
```

A more throughout installation guide is available here: <https://github.com/weaveworks/ignite/blob/master/docs/installation.md>