# Developer documentation

Ignite is a Go project using well-known libraries like:

 - github.com/spf13/cobra
 - github.com/spf13/pflag
 - k8s.io/apimachinery
 - sigs.k8s.io/yaml
 - github.com/firecracker-microvm/firecracker-go-sdk

and so on.

It uses Go modules as the vendoring mechanism.

## Build from source

The only build requirement is Docker.

To build `ignite`, `ignited` and `ignite-spawn` for all supported architectures, run:
```console
make build-all
```

To only build for a specific architecture, append the architecture to the command:
```console
make build-all-amd64
make build-all-arm64
```

## Pre-commit tidying

Before committing, please run this make target to (re)generate
autogenerated content and tidy your local environment:

```console
make autogen tidy
```

## Building reference OS images

```console
make -C images WHAT=ubuntu
make -C images WHAT=centos
```
