# Run Ignite VMs declaratively

Flags can be convenient for simple use, but have many limitations.
For more advanced use cases, and to allow GitOps flows, there is
another way: telling Ignite what to do _declaratively_, using a file containing
an API object.

The first commands to support this feature are `ignite run` and `ignite create`.
Here's an example API object file contents: 

```yaml
apiVersion: ignite.weave.works/v1alpha2
kind: VM
metadata:
  name: my-vm
spec:
  image:
    oci: weaveworks/ignite-ubuntu
  cpus: 2
  diskSize: 3GB
  memory: 800MB
```

This API object specifies a need for 2 vCPUs, 800 MB of RAM and 3 GB of disk space.

We can tell Ignite to make this happen by simply running:

```console
$ ignite run --config my-vm.yaml
```

The full reference format for the `VM` kind is as follows:

```yaml
apiVersion: ignite.weave.works/v1alpha2
kind: VM
metadata:
  # Automatically set when the object is created
  created: [RFC3339-formatted date]
  # Required, the name of the VM
  name: [string]
  # Optional, autogenerated if not specified
  uid: [16-char hex UID]
  # Optional, a string-string map with label keys and values
  labels:
    foo: bar
  # Optional, a string-string map with annotation keys and values
  annotations:
    foo: bar
spec:
  # Optional, how many vCPUs should be allocated for the VM
  # Default: 1
  cpus: [uint64]
  # Optional, how much RAM should be allocated for the VM
  # Default: 512MB
  memory: [size]
  # Optional, how much free writable space the VM should have at runtime
  # Default: 4GB
  diskSize: [size]

  image:
    # Required, what OCI image to use as the VM's rootfs
    # For example: weaveworks/ignite-ubuntu:latest
    oci: [OCI image reference]
  kernel:
    # Optional, the kernel command line for the VM
    # Default: "console=ttyS0 reboot=k panic=1 pci=off ip=dhcp"
    cmdLine: [string]
    # Required, what OCI image to get the kernel binary (and optionally modules) from
    # Default: weaveworks/ignite-kernel:4.19.47
    oci:  [OCI image reference]
  
  network:
    # Optional, an array of port mappings that map ports bound to the VM to the host
    # Default: unset, no port mappings
    ports:
    # This example maps UDP port 0.0.0.0:6443 inside the VM to 10.0.0.2:443 on the physical host
    - hostPort: 433
      vmPort: 6443
      # Optional, specify an address to bind to on the host
      # Default: 0.0.0.0, any address
      bindAddress: 10.0.0.2
      # Optional, specify a protocol for the port mapping (tcp or udp)
      # Default: tcp
      protocol: udp

  storage:
    # Optional, an array of mountPath and name pairs,
    # set the mount points for named volumes inside the VM.
    # Names must match configured named volumes.
    # Default: unset, no mount points
    volumeMounts:
    - mountPath: /mnt
      name: volume0
    # Optional, an array of blockDevice and name pairs,
    # expose block devices on the host inside the VM.
    # The blockDevice path must point to a block device formatted
    # with a filesystem providing an UUID (such as ext4 or xfs).
    # Default: unset, no volume forwarding
    volumes:
    - blockDevice:
        path: /dev/sdb1
      name: volume0

  # Optional, an array of files/directories to copy into the VM on creation
  # Default: unset, nothing will be copied
  copyFiles:
  # This example copies a Kubernetes KubeConfig file from /etc/kubernetes/admin.conf
  # on the host to /home/user/.kube/config inside the VM
  - hostPath: /etc/kubernetes/admin.conf
    vmPath: /home/user/.kube/config
  
  # Optional, provides automation to easily access your VM with the "ignite ssh" command
  # If "ssh: true" is set, Ignite will generate an SSH key and copy the
  # public key into the VM. This allows for automatic "ignite ssh" logins.
  # Alternatively: specify a path to a public key to put in /root/.ssh/authorized_keys in the VM.
  # Default: unset, no actions regarding SSH automation
  ssh: [true, or public key path]
```

You can find the full API reference in the
[api/](https://github.com/weaveworks/ignite/tree/master/api) subfolder of the project.
