# Contributing

We highly value and encourage contributions from the community!

Ignite is [Apache 2.0 licensed](LICENSE) and accepts contributions via GitHub Pull Requests.This document outlines some of the conventions on development workflow, commit message formatting, contact points and other resources to make it easier to get your contribution accepted.

We gratefully welcome improvements to documentation as well as to code.

## Community and Access

Join [weaveworks-ignite@googlegroups.com](https://groups.google.com/forum/#!forum/weaveworks-ignite) for calendar invites to calls and edit access to community documents.
You can ask questions and discuss features on the [#ignite](https://weave-community.slack.com/messages/ignite/) slack channel.

We also hope to see you at our [developer meetings](https://docs.google.com/document/d/1fv8_WD6qXfvlIq7Bb5raCGyBvc42dNF-l8uaoZzoUYI/edit).

## Guidelines

If you have a feature suggestion or found a bug, head over to [GitHub issues](https://github.com/weaveworks/ignite/issues)
and see if there's an open issue matching your description. If not feel free to open a new issue and add short description:
 - In case of a bug, be sure to include the steps you performed and what Ignite responded so it's easy for others to reproduce
 - If you have a feature suggestion, describe it in moderate detail and include some potential uses you see for the feature.
   We prioritize the features to be implemented based on their usefulness/popularity. Of course if you want to start contributing
   yourself, go ahead! We'll be more than happy to review your pull requests.

The maintainers will add the correct labels/milestones to the issue for you.

### Contributing your code

The process to contribute code to Ignite is very straight forward.
1. Go to the project on [GitHub](https://github.com/weaveworks/ignite) and click the `Fork` button in the top-right corner.
   This will create your own copy of the repository in your personal account.
1. Using standard `git` workflow, `clone` your fork, make your changes and then `commit` and `push` them to _your_ repository.
1. Run `make autogen tidy`, then `commit` and `push` the changes. Just put `make autogen tidy` as the commit message.
   This (re)generates any new/changed autogenerated content and cleans up the code's formatting.
1. Go back to [GitHub](https://github.com/weaveworks/ignite), select `Pull requests` from the top bar and click
   `New pull request` to the right. Select the `compare across forks` link. This will show repositories in addition to branches.
1. From the `head repository` dropdown, select your forked repository. If you made a new branch, select it in the `compare` dropdown.
   You should always target `weaveworks/ignite` and `master` as the base repository and branch.
1. With your changes visible, click `Create pull request`. Give it a short, descriptive title and write a comment describing your changes.
   Click `Create pull request`.

That's it! Maintainers follow pull requests closely and will add the correct labels and milestones.
After a maintainer's review small changes/improvements could be requested, don't worry, feedback can
be easily addressed by performing the requested changes and doing a `commit` and `push`. Your new
changes will automatically be added to the pull request. (Don't forget to add a new `make autogen tidy`
commit if needed.)

We also have Continuous Integration (CI) set up (powered by [CircleCI](https://circleci.com/)) that will build the code
and verify it compiles and passes all tests successfully. If your changes didn't pass CI, you can click
`Details` to go and check why it happened. To integrate your changes, we require CI to pass.

If you have any questions or need help, don't hesitate to ask on our [mailing list](https://groups.google.com/forum/#!forum/weaveworks-ignite)
or the [#ignite](https://weave-community.slack.com/messages/ignite/) slack channel. Have fun contributing!

## Make targets

To compile the `ignite`, `ignited` and `ignite-spawn` binaries, run
```console
make build-all-amd64
```

`ignite`, `ignited` and `ignite-spawn` are also Make targets if you only need to build specific ones.
Building `ignite-spawn` binary using either way also automatically packages it in its Docker container,
and tags it as `weaveworks/ignite:dev` for development.

To (re)generate autogenerated content in case your changes require it:
```console
make autogen
```

Before submitting a PR:
```console
make autogen tidy
```
This will clean up the code (run e.g. `gofmt`) in addition
to making sure all autogenerated content is up to date.

Other targets:
- Install the `ignite` and `ignited` binaries: `make install`
- Generate dependency graph: `make graph`
  - Depends on `sfdp` (usually found in the `graphviz` package)
- Push the `weaveworks/ignite` Docker image: `make image-push`
