// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may
// not use this file except in compliance with the License. A copy of the
// License is located at
//
// 	http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
// express or implied. See the License for the specific language governing
// permissions and limitations under the License.

package operations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"
	"time"

	"golang.org/x/net/context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"
)

// NewPatchMmdsParams creates a new PatchMmdsParams object
// with the default values initialized.
func NewPatchMmdsParams() *PatchMmdsParams {
	var ()
	return &PatchMmdsParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewPatchMmdsParamsWithTimeout creates a new PatchMmdsParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewPatchMmdsParamsWithTimeout(timeout time.Duration) *PatchMmdsParams {
	var ()
	return &PatchMmdsParams{

		timeout: timeout,
	}
}

// NewPatchMmdsParamsWithContext creates a new PatchMmdsParams object
// with the default values initialized, and the ability to set a context for a request
func NewPatchMmdsParamsWithContext(ctx context.Context) *PatchMmdsParams {
	var ()
	return &PatchMmdsParams{

		Context: ctx,
	}
}

// NewPatchMmdsParamsWithHTTPClient creates a new PatchMmdsParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewPatchMmdsParamsWithHTTPClient(client *http.Client) *PatchMmdsParams {
	var ()
	return &PatchMmdsParams{
		HTTPClient: client,
	}
}

/*PatchMmdsParams contains all the parameters to send to the API endpoint
for the patch mmds operation typically these are written to a http.Request
*/
type PatchMmdsParams struct {

	/*Body
	  The MMDS data store patch JSON.

	*/
	Body interface{}

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the patch mmds params
func (o *PatchMmdsParams) WithTimeout(timeout time.Duration) *PatchMmdsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the patch mmds params
func (o *PatchMmdsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the patch mmds params
func (o *PatchMmdsParams) WithContext(ctx context.Context) *PatchMmdsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the patch mmds params
func (o *PatchMmdsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the patch mmds params
func (o *PatchMmdsParams) WithHTTPClient(client *http.Client) *PatchMmdsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the patch mmds params
func (o *PatchMmdsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the patch mmds params
func (o *PatchMmdsParams) WithBody(body interface{}) *PatchMmdsParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the patch mmds params
func (o *PatchMmdsParams) SetBody(body interface{}) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *PatchMmdsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
