// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may
// not use this file except in compliance with the License. A copy of the
// License is located at
//
// 	http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
// express or implied. See the License for the specific language governing
// permissions and limitations under the License.

package operations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"

	client_models "github.com/firecracker-microvm/firecracker-go-sdk/client/models"
)

// PatchGuestDriveByIDReader is a Reader for the PatchGuestDriveByID structure.
type PatchGuestDriveByIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PatchGuestDriveByIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {

	case 204:
		result := NewPatchGuestDriveByIDNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil

	case 400:
		result := NewPatchGuestDriveByIDBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result

	default:
		result := NewPatchGuestDriveByIDDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPatchGuestDriveByIDNoContent creates a PatchGuestDriveByIDNoContent with default headers values
func NewPatchGuestDriveByIDNoContent() *PatchGuestDriveByIDNoContent {
	return &PatchGuestDriveByIDNoContent{}
}

/*PatchGuestDriveByIDNoContent handles this case with default header values.

Drive updated
*/
type PatchGuestDriveByIDNoContent struct {
}

func (o *PatchGuestDriveByIDNoContent) Error() string {
	return fmt.Sprintf("[PATCH /drives/{drive_id}][%d] patchGuestDriveByIdNoContent ", 204)
}

func (o *PatchGuestDriveByIDNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewPatchGuestDriveByIDBadRequest creates a PatchGuestDriveByIDBadRequest with default headers values
func NewPatchGuestDriveByIDBadRequest() *PatchGuestDriveByIDBadRequest {
	return &PatchGuestDriveByIDBadRequest{}
}

/*PatchGuestDriveByIDBadRequest handles this case with default header values.

Drive cannot be updated due to bad input
*/
type PatchGuestDriveByIDBadRequest struct {
	Payload *client_models.Error
}

func (o *PatchGuestDriveByIDBadRequest) Error() string {
	return fmt.Sprintf("[PATCH /drives/{drive_id}][%d] patchGuestDriveByIdBadRequest  %+v", 400, o.Payload)
}

func (o *PatchGuestDriveByIDBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(client_models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPatchGuestDriveByIDDefault creates a PatchGuestDriveByIDDefault with default headers values
func NewPatchGuestDriveByIDDefault(code int) *PatchGuestDriveByIDDefault {
	return &PatchGuestDriveByIDDefault{
		_statusCode: code,
	}
}

/*PatchGuestDriveByIDDefault handles this case with default header values.

Internal server error.
*/
type PatchGuestDriveByIDDefault struct {
	_statusCode int

	Payload *client_models.Error
}

// Code gets the status code for the patch guest drive by ID default response
func (o *PatchGuestDriveByIDDefault) Code() int {
	return o._statusCode
}

func (o *PatchGuestDriveByIDDefault) Error() string {
	return fmt.Sprintf("[PATCH /drives/{drive_id}][%d] patchGuestDriveByID default  %+v", o._statusCode, o.Payload)
}

func (o *PatchGuestDriveByIDDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(client_models.Error)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
