// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may
// not use this file except in compliance with the License. A copy of the
// License is located at
//
// 	http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
// express or implied. See the License for the specific language governing
// permissions and limitations under the License.

package client_models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PartialNetworkInterface Defines a partial network interface structure, used to update the rate limiters for that interface, after microvm start.
// swagger:model PartialNetworkInterface
type PartialNetworkInterface struct {

	// iface id
	// Required: true
	IfaceID *string `json:"iface_id"`

	// rx rate limiter
	RxRateLimiter *RateLimiter `json:"rx_rate_limiter,omitempty"`

	// tx rate limiter
	TxRateLimiter *RateLimiter `json:"tx_rate_limiter,omitempty"`
}

// Validate validates this partial network interface
func (m *PartialNetworkInterface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIfaceID(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRxRateLimiter(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTxRateLimiter(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PartialNetworkInterface) validateIfaceID(formats strfmt.Registry) error {

	if err := validate.Required("iface_id", "body", m.IfaceID); err != nil {
		return err
	}

	return nil
}

func (m *PartialNetworkInterface) validateRxRateLimiter(formats strfmt.Registry) error {

	if swag.IsZero(m.RxRateLimiter) { // not required
		return nil
	}

	if m.RxRateLimiter != nil {
		if err := m.RxRateLimiter.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rx_rate_limiter")
			}
			return err
		}
	}

	return nil
}

func (m *PartialNetworkInterface) validateTxRateLimiter(formats strfmt.Registry) error {

	if swag.IsZero(m.TxRateLimiter) { // not required
		return nil
	}

	if m.TxRateLimiter != nil {
		if err := m.TxRateLimiter.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("tx_rate_limiter")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *PartialNetworkInterface) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PartialNetworkInterface) UnmarshalBinary(b []byte) error {
	var res PartialNetworkInterface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
