// +build !ignore_autogenerated

// Code generated by openapi-gen. DO NOT EDIT.

// This file was autogenerated by openapi-gen. Do not edit it manually!

package openapi

import (
	spec "github.com/go-openapi/spec"
	common "k8s.io/kube-openapi/pkg/common"
)

func GetOpenAPIDefinitions(ref common.ReferenceCallback) map[string]common.OpenAPIDefinition {
	return map[string]common.OpenAPIDefinition{
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.FileMapping":       schema_pkg_apis_ignite_v1alpha1_FileMapping(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.Image":             schema_pkg_apis_ignite_v1alpha1_Image(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.ImageSpec":         schema_pkg_apis_ignite_v1alpha1_ImageSpec(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.ImageStatus":       schema_pkg_apis_ignite_v1alpha1_ImageStatus(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.Kernel":            schema_pkg_apis_ignite_v1alpha1_Kernel(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.KernelSpec":        schema_pkg_apis_ignite_v1alpha1_KernelSpec(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.KernelStatus":      schema_pkg_apis_ignite_v1alpha1_KernelStatus(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.OCIImageClaim":     schema_pkg_apis_ignite_v1alpha1_OCIImageClaim(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.OCIImageSource":    schema_pkg_apis_ignite_v1alpha1_OCIImageSource(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.Pool":              schema_pkg_apis_ignite_v1alpha1_Pool(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.PoolDevice":        schema_pkg_apis_ignite_v1alpha1_PoolDevice(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.PoolSpec":          schema_pkg_apis_ignite_v1alpha1_PoolSpec(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.PoolStatus":        schema_pkg_apis_ignite_v1alpha1_PoolStatus(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.SSH":               schema_pkg_apis_ignite_v1alpha1_SSH(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.VM":                schema_pkg_apis_ignite_v1alpha1_VM(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.VMImageSpec":       schema_pkg_apis_ignite_v1alpha1_VMImageSpec(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.VMKernelSpec":      schema_pkg_apis_ignite_v1alpha1_VMKernelSpec(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.VMNetworkSpec":     schema_pkg_apis_ignite_v1alpha1_VMNetworkSpec(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.VMSpec":            schema_pkg_apis_ignite_v1alpha1_VMSpec(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.VMStatus":          schema_pkg_apis_ignite_v1alpha1_VMStatus(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.BlockDeviceVolume": schema_pkg_apis_ignite_v1alpha2_BlockDeviceVolume(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.FileMapping":       schema_pkg_apis_ignite_v1alpha2_FileMapping(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.Image":             schema_pkg_apis_ignite_v1alpha2_Image(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.ImageSpec":         schema_pkg_apis_ignite_v1alpha2_ImageSpec(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.ImageStatus":       schema_pkg_apis_ignite_v1alpha2_ImageStatus(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.Kernel":            schema_pkg_apis_ignite_v1alpha2_Kernel(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.KernelSpec":        schema_pkg_apis_ignite_v1alpha2_KernelSpec(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.KernelStatus":      schema_pkg_apis_ignite_v1alpha2_KernelStatus(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.OCIImageSource":    schema_pkg_apis_ignite_v1alpha2_OCIImageSource(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.Pool":              schema_pkg_apis_ignite_v1alpha2_Pool(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.PoolDevice":        schema_pkg_apis_ignite_v1alpha2_PoolDevice(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.PoolSpec":          schema_pkg_apis_ignite_v1alpha2_PoolSpec(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.PoolStatus":        schema_pkg_apis_ignite_v1alpha2_PoolStatus(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.Runtime":           schema_pkg_apis_ignite_v1alpha2_Runtime(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.SSH":               schema_pkg_apis_ignite_v1alpha2_SSH(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.VM":                schema_pkg_apis_ignite_v1alpha2_VM(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.VMImageSpec":       schema_pkg_apis_ignite_v1alpha2_VMImageSpec(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.VMKernelSpec":      schema_pkg_apis_ignite_v1alpha2_VMKernelSpec(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.VMNetworkSpec":     schema_pkg_apis_ignite_v1alpha2_VMNetworkSpec(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.VMSpec":            schema_pkg_apis_ignite_v1alpha2_VMSpec(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.VMStatus":          schema_pkg_apis_ignite_v1alpha2_VMStatus(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.VMStorageSpec":     schema_pkg_apis_ignite_v1alpha2_VMStorageSpec(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.Volume":            schema_pkg_apis_ignite_v1alpha2_Volume(ref),
		"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.VolumeMount":       schema_pkg_apis_ignite_v1alpha2_VolumeMount(ref),
		"github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.APIType":             schema_pkg_apis_meta_v1alpha1_APIType(ref),
		"github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.DMID":                schema_pkg_apis_meta_v1alpha1_DMID(ref),
		"github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.OCIContentID":        schema_pkg_apis_meta_v1alpha1_OCIContentID(ref),
		"github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.ObjectMeta":          schema_pkg_apis_meta_v1alpha1_ObjectMeta(ref),
		"github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.PortMapping":         schema_pkg_apis_meta_v1alpha1_PortMapping(ref),
		"github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Size":                schema_pkg_apis_meta_v1alpha1_Size(ref),
		"github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Time":                schema_pkg_apis_meta_v1alpha1_Time(ref),
		"github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.TypeMeta":            schema_pkg_apis_meta_v1alpha1_TypeMeta(ref),
	}
}

func schema_pkg_apis_ignite_v1alpha1_FileMapping(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "FileMapping defines mappings between files on the host and VM",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"hostPath": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"vmPath": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"hostPath", "vmPath"},
			},
		},
	}
}

func schema_pkg_apis_ignite_v1alpha1_Image(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Image represents a cached OCI image ready to be used with Ignite",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.TypeMeta"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "meta.ObjectMeta is also embedded into the struct, and defines the human-readable name, and the machine-readable ID Name is available at the .metadata.name JSON path ID is available at the .metadata.uid JSON path (the Go type is k8s.io/apimachinery/pkg/types.UID, which is only a typed string)",
							Ref:         ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.ImageSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.ImageStatus"),
						},
					},
				},
				Required: []string{"TypeMeta", "metadata", "spec", "status"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.ImageSpec", "github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.ImageStatus", "github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.ObjectMeta", "k8s.io/apimachinery/pkg/apis/meta/v1.TypeMeta"},
	}
}

func schema_pkg_apis_ignite_v1alpha1_ImageSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ImageSpec declares what the image contains",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ociClaim": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.OCIImageClaim"),
						},
					},
				},
				Required: []string{"ociClaim"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.OCIImageClaim"},
	}
}

func schema_pkg_apis_ignite_v1alpha1_ImageStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ImageStatus defines the status of the image",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ociSource": {
						SchemaProps: spec.SchemaProps{
							Description: "OCISource contains the information about how this OCI image was imported",
							Ref:         ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.OCIImageSource"),
						},
					},
				},
				Required: []string{"ociSource"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.OCIImageSource"},
	}
}

func schema_pkg_apis_ignite_v1alpha1_Kernel(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Kernel is a serializable object that caches information about imported kernels This file is stored in /var/lib/firecracker/kernels/{oci-image-digest}/metadata.json",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.TypeMeta"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "meta.ObjectMeta is also embedded into the struct, and defines the human-readable name, and the machine-readable ID Name is available at the .metadata.name JSON path ID is available at the .metadata.uid JSON path (the Go type is k8s.io/apimachinery/pkg/types.UID, which is only a typed string)",
							Ref:         ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.KernelSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.KernelStatus"),
						},
					},
				},
				Required: []string{"TypeMeta", "metadata", "spec", "status"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.KernelSpec", "github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.KernelStatus", "github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.ObjectMeta", "k8s.io/apimachinery/pkg/apis/meta/v1.TypeMeta"},
	}
}

func schema_pkg_apis_ignite_v1alpha1_KernelSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KernelSpec describes the properties of a kernel",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ociClaim": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.OCIImageClaim"),
						},
					},
				},
				Required: []string{"ociClaim"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.OCIImageClaim"},
	}
}

func schema_pkg_apis_ignite_v1alpha1_KernelStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KernelStatus describes the status of a kernel",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"version": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"ociSource": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.OCIImageSource"),
						},
					},
				},
				Required: []string{"version", "ociSource"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.OCIImageSource"},
	}
}

func schema_pkg_apis_ignite_v1alpha1_OCIImageClaim(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "OCIImageClaim defines a claim for importing an OCI image",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type defines how the image should be imported",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"ref": {
						SchemaProps: spec.SchemaProps{
							Description: "Ref defines the reference to use when talking to the backend. This is most commonly the image name, followed by a tag. Other supported ways are $registry/$user/$image@sha256:$digest This ref is also used as ObjectMeta.Name for kinds Images and Kernels",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"type", "ref"},
			},
		},
	}
}

func schema_pkg_apis_ignite_v1alpha1_OCIImageSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "OCIImageSource specifies how the OCI image was imported. It is the status variant of OCIImageClaim",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"id": {
						SchemaProps: spec.SchemaProps{
							Description: "ID defines the source's ID (e.g. the Docker image ID)",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"size": {
						SchemaProps: spec.SchemaProps{
							Description: "Size defines the size of the source in bytes",
							Ref:         ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Size"),
						},
					},
					"repoDigests": {
						SchemaProps: spec.SchemaProps{
							Description: "RepoDigests defines the image name as it was when pulled from a repository, and the digest of the image The format is $registry/$user/$image@sha256:$digest This field is unpopulated if the image used as the source has never been pushed to or pulled from a registry",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"id", "size"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Size"},
	}
}

func schema_pkg_apis_ignite_v1alpha1_Pool(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Pool defines device mapper pool database This file is managed by the snapshotter part of Ignite, and the file (existing as a singleton) is present at /var/lib/firecracker/snapshotter/pool.json",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.TypeMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.PoolSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.PoolStatus"),
						},
					},
				},
				Required: []string{"TypeMeta", "spec", "status"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.PoolSpec", "github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.PoolStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.TypeMeta"},
	}
}

func schema_pkg_apis_ignite_v1alpha1_PoolDevice(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PoolDevice defines one device in the pool",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"size": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Size"),
						},
					},
					"parent": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.DMID"),
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type specifies the type of the contents of the device",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadataPath": {
						SchemaProps: spec.SchemaProps{
							Description: "MetadataPath points to the JSON/YAML file with metadata about this device This is most often of the format /var/lib/firecracker/{type}/{id}/metadata.json",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"size", "parent", "type", "metadataPath"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.DMID", "github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Size"},
	}
}

func schema_pkg_apis_ignite_v1alpha1_PoolSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PoolSpec defines the Pool's specification",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metadataSize": {
						SchemaProps: spec.SchemaProps{
							Description: "MetadataSize specifies the size of the pool's metadata",
							Ref:         ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Size"),
						},
					},
					"dataSize": {
						SchemaProps: spec.SchemaProps{
							Description: "DataSize specifies the size of the pool's data",
							Ref:         ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Size"),
						},
					},
					"allocationSize": {
						SchemaProps: spec.SchemaProps{
							Description: "AllocationSize specifies the smallest size that can be allocated at a time",
							Ref:         ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Size"),
						},
					},
					"metadataPath": {
						SchemaProps: spec.SchemaProps{
							Description: "MetadataPath points to the file where device mapper stores all metadata information Defaults to constants.SNAPSHOTTER_METADATA_PATH",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"dataPath": {
						SchemaProps: spec.SchemaProps{
							Description: "DataPath points to the backing physical device or sparse file (to be loop mounted) for the pool Defaults to constants.SNAPSHOTTER_DATA_PATH",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"metadataSize", "dataSize", "allocationSize", "metadataPath", "dataPath"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Size"},
	}
}

func schema_pkg_apis_ignite_v1alpha1_PoolStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PoolStatus defines the Pool's current status",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"devices": {
						SchemaProps: spec.SchemaProps{
							Description: "The Devices array needs to contain pointers to accommodate \"holes\" in the mapping Where devices have been deleted, the pointer is nil",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.PoolDevice"),
									},
								},
							},
						},
					},
				},
				Required: []string{"devices"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.PoolDevice"},
	}
}

func schema_pkg_apis_ignite_v1alpha1_SSH(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SSH specifies different ways to connect via SSH to the VM SSH uses a custom marshaller/unmarshaller. If generate is true, it marshals to true (a JSON bool). If PublicKey is set, it marshals to that string.",
				Type:        []string{"object"},
			},
		},
	}
}

func schema_pkg_apis_ignite_v1alpha1_VM(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VM represents a virtual machine run by Firecracker These files are stored in /var/lib/firecracker/vm/{vm-id}/metadata.json",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.TypeMeta"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "meta.ObjectMeta is also embedded into the struct, and defines the human-readable name, and the machine-readable ID Name is available at the .metadata.name JSON path ID is available at the .metadata.uid JSON path (the Go type is k8s.io/apimachinery/pkg/types.UID, which is only a typed string)",
							Ref:         ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.VMSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.VMStatus"),
						},
					},
				},
				Required: []string{"TypeMeta", "metadata", "spec", "status"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.VMSpec", "github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.VMStatus", "github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.ObjectMeta", "k8s.io/apimachinery/pkg/apis/meta/v1.TypeMeta"},
	}
}

func schema_pkg_apis_ignite_v1alpha1_VMImageSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"ociClaim": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.OCIImageClaim"),
						},
					},
				},
				Required: []string{"ociClaim"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.OCIImageClaim"},
	}
}

func schema_pkg_apis_ignite_v1alpha1_VMKernelSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"ociClaim": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.OCIImageClaim"),
						},
					},
					"cmdLine": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"ociClaim"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.OCIImageClaim"},
	}
}

func schema_pkg_apis_ignite_v1alpha1_VMNetworkSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"mode": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"ports": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.PortMapping"),
									},
								},
							},
						},
					},
				},
				Required: []string{"mode"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.PortMapping"},
	}
}

func schema_pkg_apis_ignite_v1alpha1_VMSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VMSpec describes the configuration of a VM",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"image": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.VMImageSpec"),
						},
					},
					"kernel": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.VMKernelSpec"),
						},
					},
					"cpus": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"integer"},
							Format: "int64",
						},
					},
					"memory": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Size"),
						},
					},
					"diskSize": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Size"),
						},
					},
					"network": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.VMNetworkSpec"),
						},
					},
					"copyFiles": {
						SchemaProps: spec.SchemaProps{
							Description: "This will be done at either \"ignite start\" or \"ignite create\" time",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.FileMapping"),
									},
								},
							},
						},
					},
					"ssh": {
						SchemaProps: spec.SchemaProps{
							Description: "SSH specifies how the SSH setup should be done nil here means \"don't do anything special\" If SSH.Generate is set, Ignite will generate a new SSH key and copy it in to authorized_keys in the VM Specifying a path in SSH.Generate means \"use this public key\" If SSH.PublicKey is set, this struct will marshal as a string using that path If SSH.Generate is set, this struct will marshal as a bool => true",
							Ref:         ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.SSH"),
						},
					},
				},
				Required: []string{"image", "kernel", "cpus", "memory", "diskSize", "network"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.FileMapping", "github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.SSH", "github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.VMImageSpec", "github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.VMKernelSpec", "github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.VMNetworkSpec", "github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Size"},
	}
}

func schema_pkg_apis_ignite_v1alpha1_VMStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VMStatus defines the status of a VM",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"state": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"ipAddresses": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "byte",
									},
								},
							},
						},
					},
					"image": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.OCIImageSource"),
						},
					},
					"kernel": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.OCIImageSource"),
						},
					},
				},
				Required: []string{"state", "image", "kernel"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha1.OCIImageSource"},
	}
}

func schema_pkg_apis_ignite_v1alpha2_BlockDeviceVolume(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "BlockDeviceVolume defines a block device on the host",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"path": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"path"},
			},
		},
	}
}

func schema_pkg_apis_ignite_v1alpha2_FileMapping(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "FileMapping defines mappings between files on the host and VM",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"hostPath": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"vmPath": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"hostPath", "vmPath"},
			},
		},
	}
}

func schema_pkg_apis_ignite_v1alpha2_Image(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Image represents a cached OCI image ready to be used with Ignite",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.TypeMeta"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "meta.ObjectMeta is also embedded into the struct, and defines the human-readable name, and the machine-readable ID Name is available at the .metadata.name JSON path ID is available at the .metadata.uid JSON path (the Go type is k8s.io/apimachinery/pkg/types.UID, which is only a typed string)",
							Ref:         ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.ImageSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.ImageStatus"),
						},
					},
				},
				Required: []string{"TypeMeta", "metadata", "spec", "status"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.ImageSpec", "github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.ImageStatus", "github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.ObjectMeta", "k8s.io/apimachinery/pkg/apis/meta/v1.TypeMeta"},
	}
}

func schema_pkg_apis_ignite_v1alpha2_ImageSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ImageSpec declares what the image contains",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"oci": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"oci"},
			},
		},
	}
}

func schema_pkg_apis_ignite_v1alpha2_ImageStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ImageStatus defines the status of the image",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ociSource": {
						SchemaProps: spec.SchemaProps{
							Description: "OCISource contains the information about how this OCI image was imported",
							Ref:         ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.OCIImageSource"),
						},
					},
				},
				Required: []string{"ociSource"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.OCIImageSource"},
	}
}

func schema_pkg_apis_ignite_v1alpha2_Kernel(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Kernel is a serializable object that caches information about imported kernels This file is stored in /var/lib/firecracker/kernels/{oci-image-digest}/metadata.json",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.TypeMeta"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "meta.ObjectMeta is also embedded into the struct, and defines the human-readable name, and the machine-readable ID Name is available at the .metadata.name JSON path ID is available at the .metadata.uid JSON path (the Go type is k8s.io/apimachinery/pkg/types.UID, which is only a typed string)",
							Ref:         ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.KernelSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.KernelStatus"),
						},
					},
				},
				Required: []string{"TypeMeta", "metadata", "spec", "status"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.KernelSpec", "github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.KernelStatus", "github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.ObjectMeta", "k8s.io/apimachinery/pkg/apis/meta/v1.TypeMeta"},
	}
}

func schema_pkg_apis_ignite_v1alpha2_KernelSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KernelSpec describes the properties of a kernel",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"oci": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"oci"},
			},
		},
	}
}

func schema_pkg_apis_ignite_v1alpha2_KernelStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "KernelStatus describes the status of a kernel",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"version": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"ociSource": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.OCIImageSource"),
						},
					},
				},
				Required: []string{"version", "ociSource"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.OCIImageSource"},
	}
}

func schema_pkg_apis_ignite_v1alpha2_OCIImageSource(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "OCIImageSource specifies how the OCI image was imported. It is the status variant of OCIImageClaim",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"id": {
						SchemaProps: spec.SchemaProps{
							Description: "ID defines the source's content ID (e.g. the canonical OCI path or Docker image ID)",
							Ref:         ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.OCIContentID"),
						},
					},
					"size": {
						SchemaProps: spec.SchemaProps{
							Description: "Size defines the size of the source in bytes",
							Ref:         ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Size"),
						},
					},
				},
				Required: []string{"id", "size"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.OCIContentID", "github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Size"},
	}
}

func schema_pkg_apis_ignite_v1alpha2_Pool(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Pool defines device mapper pool database This file is managed by the snapshotter part of Ignite, and the file (existing as a singleton) is present at /var/lib/firecracker/snapshotter/pool.json",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.TypeMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.PoolSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.PoolStatus"),
						},
					},
				},
				Required: []string{"TypeMeta", "spec", "status"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.PoolSpec", "github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.PoolStatus", "k8s.io/apimachinery/pkg/apis/meta/v1.TypeMeta"},
	}
}

func schema_pkg_apis_ignite_v1alpha2_PoolDevice(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PoolDevice defines one device in the pool",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"size": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Size"),
						},
					},
					"parent": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.DMID"),
						},
					},
					"type": {
						SchemaProps: spec.SchemaProps{
							Description: "Type specifies the type of the contents of the device",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"metadataPath": {
						SchemaProps: spec.SchemaProps{
							Description: "MetadataPath points to the JSON/YAML file with metadata about this device This is most often of the format /var/lib/firecracker/{type}/{id}/metadata.json",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"size", "parent", "type", "metadataPath"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.DMID", "github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Size"},
	}
}

func schema_pkg_apis_ignite_v1alpha2_PoolSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PoolSpec defines the Pool's specification",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metadataSize": {
						SchemaProps: spec.SchemaProps{
							Description: "MetadataSize specifies the size of the pool's metadata",
							Ref:         ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Size"),
						},
					},
					"dataSize": {
						SchemaProps: spec.SchemaProps{
							Description: "DataSize specifies the size of the pool's data",
							Ref:         ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Size"),
						},
					},
					"allocationSize": {
						SchemaProps: spec.SchemaProps{
							Description: "AllocationSize specifies the smallest size that can be allocated at a time",
							Ref:         ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Size"),
						},
					},
					"metadataPath": {
						SchemaProps: spec.SchemaProps{
							Description: "MetadataPath points to the file where device mapper stores all metadata information Defaults to constants.SNAPSHOTTER_METADATA_PATH",
							Type:        []string{"string"},
							Format:      "",
						},
					},
					"dataPath": {
						SchemaProps: spec.SchemaProps{
							Description: "DataPath points to the backing physical device or sparse file (to be loop mounted) for the pool Defaults to constants.SNAPSHOTTER_DATA_PATH",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"metadataSize", "dataSize", "allocationSize", "metadataPath", "dataPath"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Size"},
	}
}

func schema_pkg_apis_ignite_v1alpha2_PoolStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PoolStatus defines the Pool's current status",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"devices": {
						SchemaProps: spec.SchemaProps{
							Description: "The Devices array needs to contain pointers to accommodate \"holes\" in the mapping Where devices have been deleted, the pointer is nil",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.PoolDevice"),
									},
								},
							},
						},
					},
				},
				Required: []string{"devices"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.PoolDevice"},
	}
}

func schema_pkg_apis_ignite_v1alpha2_Runtime(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Runtime specifies the VM's runtime information",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"id": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"id"},
			},
		},
	}
}

func schema_pkg_apis_ignite_v1alpha2_SSH(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "SSH specifies different ways to connect via SSH to the VM SSH uses a custom marshaller/unmarshaller. If generate is true, it marshals to true (a JSON bool). If PublicKey is set, it marshals to that string.",
				Type:        []string{"object"},
			},
		},
	}
}

func schema_pkg_apis_ignite_v1alpha2_VM(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VM represents a virtual machine run by Firecracker These files are stored in /var/lib/firecracker/vm/{vm-id}/metadata.json",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.TypeMeta"),
						},
					},
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Description: "meta.ObjectMeta is also embedded into the struct, and defines the human-readable name, and the machine-readable ID Name is available at the .metadata.name JSON path ID is available at the .metadata.uid JSON path (the Go type is k8s.io/apimachinery/pkg/types.UID, which is only a typed string)",
							Ref:         ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.ObjectMeta"),
						},
					},
					"spec": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.VMSpec"),
						},
					},
					"status": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.VMStatus"),
						},
					},
				},
				Required: []string{"TypeMeta", "metadata", "spec", "status"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.VMSpec", "github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.VMStatus", "github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.ObjectMeta", "k8s.io/apimachinery/pkg/apis/meta/v1.TypeMeta"},
	}
}

func schema_pkg_apis_ignite_v1alpha2_VMImageSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"oci": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"oci"},
			},
		},
	}
}

func schema_pkg_apis_ignite_v1alpha2_VMKernelSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"oci": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"cmdLine": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"oci"},
			},
		},
	}
}

func schema_pkg_apis_ignite_v1alpha2_VMNetworkSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"ports": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.PortMapping"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.PortMapping"},
	}
}

func schema_pkg_apis_ignite_v1alpha2_VMSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VMSpec describes the configuration of a VM",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"image": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.VMImageSpec"),
						},
					},
					"kernel": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.VMKernelSpec"),
						},
					},
					"cpus": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"integer"},
							Format: "int64",
						},
					},
					"memory": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Size"),
						},
					},
					"diskSize": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Size"),
						},
					},
					"network": {
						SchemaProps: spec.SchemaProps{
							Description: "Currently both will show in the JSON output as empty arrays. Making them pointers requires plenty of nil checks (as their contents are accessed directly) and is very risky for stability. APIMachinery potentially has a solution.",
							Ref:         ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.VMNetworkSpec"),
						},
					},
					"storage": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.VMStorageSpec"),
						},
					},
					"copyFiles": {
						SchemaProps: spec.SchemaProps{
							Description: "This will be done at either \"ignite start\" or \"ignite create\" time",
							Type:        []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.FileMapping"),
									},
								},
							},
						},
					},
					"ssh": {
						SchemaProps: spec.SchemaProps{
							Description: "SSH specifies how the SSH setup should be done nil here means \"don't do anything special\" If SSH.Generate is set, Ignite will generate a new SSH key and copy it in to authorized_keys in the VM Specifying a path in SSH.Generate means \"use this public key\" If SSH.PublicKey is set, this struct will marshal as a string using that path If SSH.Generate is set, this struct will marshal as a bool => true",
							Ref:         ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.SSH"),
						},
					},
				},
				Required: []string{"image", "kernel", "cpus", "memory", "diskSize"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.FileMapping", "github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.SSH", "github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.VMImageSpec", "github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.VMKernelSpec", "github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.VMNetworkSpec", "github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.VMStorageSpec", "github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Size"},
	}
}

func schema_pkg_apis_ignite_v1alpha2_VMStatus(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VMStatus defines the status of a VM",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"running": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"boolean"},
							Format: "",
						},
					},
					"runtime": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.Runtime"),
						},
					},
					"startTime": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Time"),
						},
					},
					"ipAddresses": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "byte",
									},
								},
							},
						},
					},
					"image": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.OCIImageSource"),
						},
					},
					"kernel": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.OCIImageSource"),
						},
					},
				},
				Required: []string{"running", "image", "kernel"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.OCIImageSource", "github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.Runtime", "github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Time"},
	}
}

func schema_pkg_apis_ignite_v1alpha2_VMStorageSpec(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VMStorageSpec defines the VM's Volumes and VolumeMounts",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"volumes": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.Volume"),
									},
								},
							},
						},
					},
					"volumeMounts": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"array"},
							Items: &spec.SchemaOrArray{
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.VolumeMount"),
									},
								},
							},
						},
					},
				},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.Volume", "github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.VolumeMount"},
	}
}

func schema_pkg_apis_ignite_v1alpha2_Volume(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Volume defines named storage volume",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"blockDevice": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.BlockDeviceVolume"),
						},
					},
				},
				Required: []string{"name"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/ignite/v1alpha2.BlockDeviceVolume"},
	}
}

func schema_pkg_apis_ignite_v1alpha2_VolumeMount(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "VolumeMount defines the mount point for a named volume inside a VM",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"mountPath": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"name", "mountPath"},
			},
		},
	}
}

func schema_pkg_apis_meta_v1alpha1_APIType(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "APIType is a struct implementing Object, used for unmarshalling unknown objects into this intermediate type where .Name, .UID, .Kind and .APIVersion become easily available",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"metadata": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.ObjectMeta"),
						},
					},
				},
				Required: []string{"metadata"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.ObjectMeta"},
	}
}

func schema_pkg_apis_meta_v1alpha1_DMID(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "DMID specifies the format for device mapper IDs",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"index": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"integer"},
							Format: "int32",
						},
					},
				},
				Required: []string{"index"},
			},
		},
	}
}

func schema_pkg_apis_meta_v1alpha1_OCIContentID(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"repoName": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"digest": {
						SchemaProps: spec.SchemaProps{
							Description: "Fully qualified image name, e.g. \"docker.io/library/node\" or blank if the image is local",
							Type:        []string{"string"},
							Format:      "",
						},
					},
				},
				Required: []string{"repoName", "digest"},
			},
		},
	}
}

func schema_pkg_apis_meta_v1alpha1_ObjectMeta(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "ObjectMeta have to be embedded into any serializable object. It provides the .GetName() and .GetUID() methods that help implement the Object interface",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"name": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"uid": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
					"created": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Time"),
						},
					},
					"labels": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
					"annotations": {
						SchemaProps: spec.SchemaProps{
							Type: []string{"object"},
							AdditionalProperties: &spec.SchemaOrBool{
								Allows: true,
								Schema: &spec.Schema{
									SchemaProps: spec.SchemaProps{
										Type:   []string{"string"},
										Format: "",
									},
								},
							},
						},
					},
				},
				Required: []string{"name", "created"},
			},
		},
		Dependencies: []string{
			"github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1.Time"},
	}
}

func schema_pkg_apis_meta_v1alpha1_PortMapping(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "PortMapping defines a port mapping between the VM and the host",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"bindAddress": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "byte",
						},
					},
					"hostPort": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"integer"},
							Format: "int64",
						},
					},
					"vmPort": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"integer"},
							Format: "int64",
						},
					},
					"protocol": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"string"},
							Format: "",
						},
					},
				},
				Required: []string{"hostPort", "vmPort"},
			},
		},
	}
}

func schema_pkg_apis_meta_v1alpha1_Size(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "Size specifies a common unit for data sizes",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"ByteSize": {
						SchemaProps: spec.SchemaProps{
							Type:   []string{"integer"},
							Format: "int64",
						},
					},
				},
				Required: []string{"ByteSize"},
			},
		},
	}
}

func schema_pkg_apis_meta_v1alpha1_Time(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Type: []string{"object"},
				Properties: map[string]spec.Schema{
					"Time": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.Time"),
						},
					},
				},
				Required: []string{"Time"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.Time"},
	}
}

func schema_pkg_apis_meta_v1alpha1_TypeMeta(ref common.ReferenceCallback) common.OpenAPIDefinition {
	return common.OpenAPIDefinition{
		Schema: spec.Schema{
			SchemaProps: spec.SchemaProps{
				Description: "TypeMeta is an alias for the k8s/apimachinery TypeMeta with some additional methods",
				Type:        []string{"object"},
				Properties: map[string]spec.Schema{
					"TypeMeta": {
						SchemaProps: spec.SchemaProps{
							Ref: ref("k8s.io/apimachinery/pkg/apis/meta/v1.TypeMeta"),
						},
					},
				},
				Required: []string{"TypeMeta"},
			},
		},
		Dependencies: []string{
			"k8s.io/apimachinery/pkg/apis/meta/v1.TypeMeta"},
	}
}
