/*
	Note: This file is autogenerated! Do not edit it manually!
	Edit client_vm_template.go instead, and run
	hack/generate-client.sh afterwards.
*/

package client

import (
	"fmt"

	log "github.com/sirupsen/logrus"
	api "github.com/weaveworks/ignite/pkg/apis/ignite"
	meta "github.com/weaveworks/ignite/pkg/apis/meta/v1alpha1"
	"github.com/weaveworks/ignite/pkg/storage"
	"github.com/weaveworks/ignite/pkg/storage/filterer"
	"k8s.io/apimachinery/pkg/runtime/schema"
)

// VMClient is an interface for accessing VM-specific API objects
type VMClient interface {
	// New returns a new VM
	New() *api.VM
	// Get returns the VM matching given UID from the storage
	Get(meta.UID) (*api.VM, error)
	// Set saves the given VM into persistent storage
	Set(*api.VM) error
	// Patch performs a strategic merge patch on the object with
	// the given UID, using the byte-encoded patch given
	Patch(meta.UID, []byte) error
	// Find returns the VM matching the given filter, filters can
	// match e.g. the Object's Name, UID or a specific property
	Find(filter filterer.BaseFilter) (*api.VM, error)
	// FindAll returns multiple VMs matching the given filter, filters can
	// match e.g. the Object's Name, UID or a specific property
	FindAll(filter filterer.BaseFilter) ([]*api.VM, error)
	// Delete deletes the VM with the given UID from the storage
	Delete(uid meta.UID) error
	// List returns a list of all VMs available
	List() ([]*api.VM, error)
}

// VMs returns the VMClient for the IgniteInternalClient instance
func (c *IgniteInternalClient) VMs() VMClient {
	if c.vmClient == nil {
		c.vmClient = newVMClient(c.storage, c.gv)
	}

	return c.vmClient
}

// vmClient is a struct implementing the VMClient interface
// It uses a shared storage instance passed from the Client together with its own Filterer
type vmClient struct {
	storage  storage.Storage
	filterer *filterer.Filterer
	gvk      schema.GroupVersionKind
}

// newVMClient builds the vmClient struct using the storage implementation and a new Filterer
func newVMClient(s storage.Storage, gv schema.GroupVersion) VMClient {
	return &vmClient{
		storage:  s,
		filterer: filterer.NewFilterer(s),
		gvk:      gv.WithKind(api.KindVM.Title()),
	}
}

// New returns a new Object of its kind
func (c *vmClient) New() *api.VM {
	log.Tracef("Client.New; GVK: %v", c.gvk)
	obj, err := c.storage.New(c.gvk)
	if err != nil {
		panic(fmt.Sprintf("Client.New must not return an error: %v", err))
	}
	return obj.(*api.VM)
}

// Find returns a single VM based on the given Filter
func (c *vmClient) Find(filter filterer.BaseFilter) (*api.VM, error) {
	log.Tracef("Client.Find; GVK: %v", c.gvk)
	object, err := c.filterer.Find(c.gvk, filter)
	if err != nil {
		return nil, err
	}

	return object.(*api.VM), nil
}

// FindAll returns multiple VMs based on the given Filter
func (c *vmClient) FindAll(filter filterer.BaseFilter) ([]*api.VM, error) {
	log.Tracef("Client.FindAll; GVK: %v", c.gvk)
	matches, err := c.filterer.FindAll(c.gvk, filter)
	if err != nil {
		return nil, err
	}

	results := make([]*api.VM, 0, len(matches))
	for _, item := range matches {
		results = append(results, item.(*api.VM))
	}

	return results, nil
}

// Get returns the VM matching given UID from the storage
func (c *vmClient) Get(uid meta.UID) (*api.VM, error) {
	log.Tracef("Client.Get; UID: %q, GVK: %v", uid, c.gvk)
	object, err := c.storage.Get(c.gvk, uid)
	if err != nil {
		return nil, err
	}

	return object.(*api.VM), nil
}

// Set saves the given VM into the persistent storage
func (c *vmClient) Set(vm *api.VM) error {
	log.Tracef("Client.Set; UID: %q, GVK: %v", vm.GetUID(), c.gvk)
	return c.storage.Set(c.gvk, vm)
}

// Patch performs a strategic merge patch on the object with
// the given UID, using the byte-encoded patch given
func (c *vmClient) Patch(uid meta.UID, patch []byte) error {
	return c.storage.Patch(c.gvk, uid, patch)
}

// Delete deletes the VM from the storage
func (c *vmClient) Delete(uid meta.UID) error {
	log.Tracef("Client.Delete; UID: %q, GVK: %v", uid, c.gvk)
	return c.storage.Delete(c.gvk, uid)
}

// List returns a list of all VMs available
func (c *vmClient) List() ([]*api.VM, error) {
	log.Tracef("Client.List; GVK: %v", c.gvk)
	list, err := c.storage.List(c.gvk)
	if err != nil {
		return nil, err
	}

	results := make([]*api.VM, 0, len(list))
	for _, item := range list {
		results = append(results, item.(*api.VM))
	}

	return results, nil
}
