version 1.0

task CollectColumns {
    input {
        Array[File]+ inputTables
        String outputPath
        Int? featureColumn
        Int? valueColumn
        Int? separator
        Array[String]? sampleNames
        Boolean header = false
        Array[String]? additionalAttributes
        File? referenceGtf
        String? featureAttribute

        String dockerImage = "quay.io/biocontainers/collect-columns:0.2.0--py_1"
    }

    command {
        set -e
        mkdir -p $(dirname ~{outputPath})
        collect-columns \
        ~{outputPath} \
        ~{sep=" " inputTables} \
        ~{"-f "  + featureColumn} \
        ~{"-c " + valueColumn} \
        ~{"-s " + separator} \
        ~{true="-n" false="" defined(sampleNames)} ~{sep=" " sampleNames} \
        ~{true="-H" false="" header} \
        ~{true="-a" false="" defined(additionalAttributes)} ~{sep=" " additionalAttributes} \
        ~{"-g " + referenceGtf} \
        ~{"-F " + featureAttribute}
    }

    output {
        File outputTable = outputPath
    }

    Int memoryGb = 4 + ceil(0.5 * length(inputTables))

    runtime {
        memory: "~{memoryGb}G"
        docker: dockerImage
    }
}