package com.thinkbiganalytics.metadata.rest.model.data;

/*-
 * #%L
 * thinkbig-metadata-rest-model
 * %%
 * Copyright (C) 2017 ThinkBig Analytics
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import java.util.ArrayList;
import java.util.List;

/**
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class DatasourceDefinitions {

    private List<DatasourceDefinition> definitions;

    public DatasourceDefinitions() {

    }

    public DatasourceDefinitions(List<DatasourceDefinition> definitions) {
        this.definitions = definitions;
    }

    public List<DatasourceDefinition> getDefinitions() {
        if (definitions == null) {
            definitions = new ArrayList<>();
        }
        return definitions;
    }

    public void setDefinitions(List<DatasourceDefinition> definitions) {
        this.definitions = definitions;
    }
}
