/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.v1;

import com.cloudera.api.DataView;
import com.cloudera.api.model.ApiCommand;
import com.cloudera.api.model.ApiCommandList;
import com.cloudera.api.model.ApiHdfsDisableHaArguments;
import com.cloudera.api.model.ApiHdfsFailoverArguments;
import com.cloudera.api.model.ApiHdfsHaArguments;
import com.cloudera.api.model.ApiMetricList;
import com.cloudera.api.model.ApiRoleNameList;
import com.cloudera.api.model.ApiRoleTypeList;
import com.cloudera.api.model.ApiService;
import com.cloudera.api.model.ApiServiceConfig;
import com.cloudera.api.model.ApiServiceList;
import com.cloudera.api.v1.ActivitiesResource;
import com.cloudera.api.v1.NameservicesResource;
import com.cloudera.api.v1.RoleCommandsResource;
import com.cloudera.api.v1.RolesResource;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface ServicesResource {
    @POST
    @Path(value="/")
    public ApiServiceList createServices(ApiServiceList var1);

    @DELETE
    @Path(value="/{serviceName}")
    public ApiService deleteService(@PathParam(value="serviceName") String var1);

    @GET
    @Path(value="/")
    public ApiServiceList readServices(@DefaultValue(value="summary") @QueryParam(value="view") DataView var1);

    @GET
    @Path(value="/{serviceName}")
    public ApiService readService(@PathParam(value="serviceName") String var1);

    @GET
    @Path(value="/{serviceName}/config")
    public ApiServiceConfig readServiceConfig(@PathParam(value="serviceName") String var1, @QueryParam(value="view") @DefaultValue(value="summary") DataView var2);

    @PUT
    @Path(value="/{serviceName}/config")
    public ApiServiceConfig updateServiceConfig(@PathParam(value="serviceName") String var1, @QueryParam(value="message") String var2, ApiServiceConfig var3);

    @GET
    @Path(value="/{serviceName}/roleTypes")
    public ApiRoleTypeList listRoleTypes(@PathParam(value="serviceName") String var1);

    @Deprecated
    @GET
    @Path(value="/{serviceName}/metrics")
    public ApiMetricList getMetrics(@PathParam(value="serviceName") String var1, @QueryParam(value="from") String var2, @QueryParam(value="to") @DefaultValue(value="now") String var3, @QueryParam(value="metrics") List<String> var4, @QueryParam(value="view") @DefaultValue(value="summary") DataView var5);

    @GET
    @Path(value="/{serviceName}/commands")
    public ApiCommandList listActiveCommands(@PathParam(value="serviceName") String var1, @QueryParam(value="view") @DefaultValue(value="summary") DataView var2);

    @Deprecated
    @POST
    @Path(value="/{serviceName}/commands/hdfsDisableAutoFailover")
    @Consumes(value={"text/plain", "application/json"})
    public ApiCommand hdfsDisableAutoFailoverCommand(@PathParam(value="serviceName") String var1, String var2);

    @Deprecated
    @POST
    @Path(value="/{serviceName}/commands/hdfsDisableHa")
    public ApiCommand hdfsDisableHaCommand(@PathParam(value="serviceName") String var1, ApiHdfsDisableHaArguments var2);

    @Deprecated
    @POST
    @Path(value="/{serviceName}/commands/hdfsEnableAutoFailover")
    public ApiCommand hdfsEnableAutoFailoverCommand(@PathParam(value="serviceName") String var1, ApiHdfsFailoverArguments var2);

    @Deprecated
    @POST
    @Path(value="/{serviceName}/commands/hdfsEnableHa")
    public ApiCommand hdfsEnableHaCommand(@PathParam(value="serviceName") String var1, ApiHdfsHaArguments var2);

    @POST
    @Path(value="/{serviceName}/commands/hdfsFailover")
    public ApiCommand hdfsFailoverCommand(@PathParam(value="serviceName") String var1, @QueryParam(value="force") @DefaultValue(value="false") boolean var2, ApiRoleNameList var3);

    @Deprecated
    @POST
    @Consumes
    @Path(value="/{serviceName}/commands/hueCreateHiveWarehouse")
    public ApiCommand createBeeswaxWarehouseCommand(@PathParam(value="serviceName") String var1);

    @POST
    @Consumes
    @Path(value="/{serviceName}/commands/hbaseCreateRoot")
    public ApiCommand createHBaseRootCommand(@PathParam(value="serviceName") String var1);

    @POST
    @Path(value="/{serviceName}/commands/decommission")
    public ApiCommand decommissionCommand(@PathParam(value="serviceName") String var1, ApiRoleNameList var2);

    @POST
    @Path(value="/{serviceName}/commands/deployClientConfig")
    public ApiCommand deployClientConfigCommand(@PathParam(value="serviceName") String var1, ApiRoleNameList var2);

    @POST
    @Path(value="/{serviceName}/commands/zooKeeperCleanup")
    public ApiCommand zooKeeperCleanupCommand(@PathParam(value="serviceName") String var1);

    @POST
    @Path(value="/{serviceName}/commands/zooKeeperInit")
    public ApiCommand zooKeeperInitCommand(@PathParam(value="serviceName") String var1);

    @POST
    @Consumes
    @Path(value="/{serviceName}/commands/start")
    public ApiCommand startCommand(@PathParam(value="serviceName") String var1);

    @POST
    @Consumes
    @Path(value="/{serviceName}/commands/stop")
    public ApiCommand stopCommand(@PathParam(value="serviceName") String var1);

    @POST
    @Consumes
    @Path(value="/{serviceName}/commands/restart")
    public ApiCommand restartCommand(@PathParam(value="serviceName") String var1);

    @Path(value="/{serviceName}/nameservices")
    public NameservicesResource getNameservicesResource(@PathParam(value="serviceName") String var1);

    @Path(value="/{serviceName}/roles")
    public RolesResource getRolesResource(@PathParam(value="serviceName") String var1);

    @Path(value="/{serviceName}/roleCommands")
    public RoleCommandsResource getRoleCommandsResource(@PathParam(value="serviceName") String var1);

    @Path(value="/{serviceName}/activities")
    public ActivitiesResource getActivitiesResource(@PathParam(value="serviceName") String var1);
}

