/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.model;

import com.cloudera.api.ApiUtils;
import com.cloudera.api.model.ApiHBaseSnapshotPolicyArguments;
import com.cloudera.api.model.ApiHdfsSnapshotPolicyArguments;
import com.cloudera.api.model.ApiSnapshotCommand;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="snapshotPolicy")
public class ApiSnapshotPolicy {
    private String name;
    private String description;
    private long hourlySnapshots;
    private long dailySnapshots;
    private long weeklySnapshots;
    private long monthlySnapshots;
    private long yearlySnapshots;
    private byte minuteOfHour;
    private byte hourOfDay;
    private byte dayOfWeek = 1;
    private byte dayOfMonth = 1;
    private byte monthOfYear = 1;
    List<Byte> hoursForHourlySnapshots;
    private boolean alertOnStart;
    private boolean alertOnSuccess;
    private boolean alertOnFail;
    private boolean alertOnAbort;
    private ApiHBaseSnapshotPolicyArguments hbaseArguments;
    private ApiHdfsSnapshotPolicyArguments hdfsArguments;
    private ApiSnapshotCommand lastCommand;
    private ApiSnapshotCommand lastSuccessfulCommand;

    public ApiSnapshotPolicy() {
    }

    public ApiSnapshotPolicy(String name, String description, long hourlySnapshots, long dailySnapshots, long weeklySnapshots, long monthlySnapshots, long yearlySnapshots) {
        this.name = name;
        this.description = description;
        this.hourlySnapshots = hourlySnapshots;
        this.dailySnapshots = dailySnapshots;
        this.weeklySnapshots = weeklySnapshots;
        this.monthlySnapshots = monthlySnapshots;
        this.yearlySnapshots = yearlySnapshots;
    }

    @XmlElement
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlElement
    public long getHourlySnapshots() {
        return this.hourlySnapshots;
    }

    public void setHourlySnapshots(long hourlySnapshots) {
        this.hourlySnapshots = hourlySnapshots;
    }

    @XmlElement
    public long getDailySnapshots() {
        return this.dailySnapshots;
    }

    public void setDailySnapshots(long dailySnapshots) {
        this.dailySnapshots = dailySnapshots;
    }

    @XmlElement
    public long getWeeklySnapshots() {
        return this.weeklySnapshots;
    }

    public void setWeeklySnapshots(long weeklySnapshots) {
        this.weeklySnapshots = weeklySnapshots;
    }

    @XmlElement
    public long getMonthlySnapshots() {
        return this.monthlySnapshots;
    }

    public void setMonthlySnapshots(long monthlySnapshots) {
        this.monthlySnapshots = monthlySnapshots;
    }

    @XmlElement
    public long getYearlySnapshots() {
        return this.yearlySnapshots;
    }

    public void setYearlySnapshots(long yearlySnapshots) {
        this.yearlySnapshots = yearlySnapshots;
    }

    @XmlElement
    public byte getMinuteOfHour() {
        return this.minuteOfHour;
    }

    public void setMinuteOfHour(byte minuteOfHour) {
        Preconditions.checkArgument((minuteOfHour >= 0 && minuteOfHour <= 59 ? 1 : 0) != 0, (Object)"Invalid minute of hour. Valid values are 0 to 59.");
        this.minuteOfHour = minuteOfHour;
    }

    @XmlElementWrapper
    public List<Byte> getHoursForHourlySnapshots() {
        return this.hoursForHourlySnapshots;
    }

    public void setHoursForHourlySnapshots(List<Byte> hours) {
        if (hours != null) {
            for (Byte hour : hours) {
                Preconditions.checkArgument((hour != null && hour >= 0 && hour <= 23 ? 1 : 0) != 0, (String)"Invalid hour of day (%s). Valid values are 0 to 23.", (Object[])new Object[]{hour});
            }
        }
        this.hoursForHourlySnapshots = hours;
    }

    @XmlElement
    public byte getHourOfDay() {
        return this.hourOfDay;
    }

    public void setHourOfDay(byte hourOfDay) {
        Preconditions.checkArgument((hourOfDay >= 0 && hourOfDay <= 23 ? 1 : 0) != 0, (Object)"Invalid hour of day. Valid values are 0 to 23.");
        this.hourOfDay = hourOfDay;
    }

    @XmlElement
    public byte getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(byte dayOfWeek) {
        Preconditions.checkArgument((dayOfWeek >= 1 && dayOfWeek <= 7 ? 1 : 0) != 0, (Object)"Invalid day of week. Valid values are 1 to 7.");
        this.dayOfWeek = dayOfWeek;
    }

    @XmlElement
    public byte getDayOfMonth() {
        return this.dayOfMonth;
    }

    public void setDayOfMonth(byte dayOfMonth) {
        Preconditions.checkArgument((dayOfMonth >= -30 && dayOfMonth <= 31 ? 1 : 0) != 0, (Object)"Invalid day of month. Value values are 1 to 31, or 0 to -30 to specify offset from last day of month.");
        this.dayOfMonth = dayOfMonth;
    }

    @XmlElement
    public byte getMonthOfYear() {
        return this.monthOfYear;
    }

    public void setMonthOfYear(byte monthOfYear) {
        Preconditions.checkArgument((monthOfYear >= 1 && monthOfYear <= 12 ? 1 : 0) != 0, (Object)"Invalid month. Valid values are 1 to 12.");
        this.monthOfYear = monthOfYear;
    }

    @XmlElement
    public boolean getAlertOnStart() {
        return this.alertOnStart;
    }

    public void setAlertOnStart(boolean alertOnStart) {
        this.alertOnStart = alertOnStart;
    }

    @XmlElement
    public boolean getAlertOnSuccess() {
        return this.alertOnSuccess;
    }

    public void setAlertOnSuccess(boolean alertOnSuccess) {
        this.alertOnSuccess = alertOnSuccess;
    }

    @XmlElement
    public boolean getAlertOnFail() {
        return this.alertOnFail;
    }

    public void setAlertOnFail(boolean alertOnFail) {
        this.alertOnFail = alertOnFail;
    }

    @XmlElement
    public boolean getAlertOnAbort() {
        return this.alertOnAbort;
    }

    public void setAlertOnAbort(boolean alertOnAbort) {
        this.alertOnAbort = alertOnAbort;
    }

    @XmlElement
    public ApiHBaseSnapshotPolicyArguments getHBaseArguments() {
        return this.hbaseArguments;
    }

    public void setHBaseArguments(ApiHBaseSnapshotPolicyArguments hbaseArguments) {
        this.hbaseArguments = hbaseArguments;
    }

    @XmlElement
    public ApiHdfsSnapshotPolicyArguments getHdfsArguments() {
        return this.hdfsArguments;
    }

    public void setHdfsArguments(ApiHdfsSnapshotPolicyArguments hdfsArguments) {
        this.hdfsArguments = hdfsArguments;
    }

    public ApiSnapshotCommand getLastCommand() {
        return this.lastCommand;
    }

    public void setLastCommand(ApiSnapshotCommand lastCommand) {
        this.lastCommand = lastCommand;
    }

    public ApiSnapshotCommand getLastSuccessfulCommand() {
        return this.lastSuccessfulCommand;
    }

    public void setLastSuccessfulCommand(ApiSnapshotCommand lastSuccessfulCommand) {
        this.lastSuccessfulCommand = lastSuccessfulCommand;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("description", (Object)this.description).add("hourlySnapshots", this.hourlySnapshots).add("dailySnapshots", this.dailySnapshots).add("weeklySnapshots", this.weeklySnapshots).add("monthlySnapshots", this.monthlySnapshots).add("yearlySnapshots", this.yearlySnapshots).add("minuteOfHour", (int)this.minuteOfHour).add("hourOfDay", (int)this.hourOfDay).add("dayOfWeek", (int)this.dayOfWeek).add("dayOfMonth", (int)this.dayOfMonth).add("monthOfYear", (int)this.monthOfYear).add("hoursForHourlySnapshots", this.hoursForHourlySnapshots).add("alertOnStart", this.alertOnStart).add("alertOnSuccess", this.alertOnSuccess).add("alertOnFail", this.alertOnFail).add("alertOnAbort", this.alertOnAbort).add("hbaseArguments", (Object)this.hbaseArguments).add("hdfsArguments", (Object)this.hdfsArguments).add("lastCommand", (Object)this.lastCommand).add("lastSuccessfulCommand", (Object)this.lastSuccessfulCommand).toString();
    }

    public boolean equals(Object o) {
        ApiSnapshotPolicy other = ApiUtils.baseEquals(this, o);
        return other != null && Objects.equal((Object)this.name, (Object)other.getName()) && Objects.equal((Object)this.description, (Object)other.getDescription()) && this.hourlySnapshots == other.getHourlySnapshots() && this.dailySnapshots == other.getDailySnapshots() && this.weeklySnapshots == other.getWeeklySnapshots() && this.monthlySnapshots == other.getMonthlySnapshots() && this.yearlySnapshots == other.getYearlySnapshots() && this.minuteOfHour == other.getMinuteOfHour() && this.hourOfDay == other.getHourOfDay() && this.dayOfWeek == other.getDayOfWeek() && this.dayOfMonth == other.getDayOfMonth() && this.monthOfYear == other.getMonthOfYear() && Objects.equal(this.hoursForHourlySnapshots, other.getHoursForHourlySnapshots()) && this.alertOnStart == other.getAlertOnStart() && this.alertOnSuccess == other.getAlertOnSuccess() && this.alertOnFail == other.getAlertOnFail() && this.alertOnAbort == other.getAlertOnAbort() && Objects.equal((Object)this.hbaseArguments, (Object)other.getHBaseArguments()) && Objects.equal((Object)this.hdfsArguments, (Object)other.getHdfsArguments()) && Objects.equal((Object)this.lastCommand, (Object)other.lastCommand) && Objects.equal((Object)this.lastSuccessfulCommand, (Object)other.lastSuccessfulCommand);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.description, this.hourlySnapshots, this.dailySnapshots, this.weeklySnapshots, this.monthlySnapshots, this.yearlySnapshots, this.minuteOfHour, this.hourOfDay, this.dayOfWeek, this.dayOfMonth, this.monthOfYear, this.hoursForHourlySnapshots, this.alertOnStart, this.alertOnSuccess, this.alertOnFail, this.alertOnAbort, this.hbaseArguments, this.hdfsArguments, this.lastCommand, this.lastSuccessfulCommand});
    }
}

