/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.model;

import com.cloudera.api.ApiUtils;
import com.cloudera.api.model.ApiClusterRef;
import com.cloudera.api.model.ApiConfigStalenessStatus;
import com.cloudera.api.model.ApiEntityType;
import com.cloudera.api.model.ApiHealthCheck;
import com.cloudera.api.model.ApiHealthSummary;
import com.cloudera.api.model.ApiReplicationSchedule;
import com.cloudera.api.model.ApiRole;
import com.cloudera.api.model.ApiRoleConfigGroup;
import com.cloudera.api.model.ApiServiceConfig;
import com.cloudera.api.model.ApiServiceState;
import com.cloudera.api.model.ApiSnapshotPolicy;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="service")
public class ApiService {
    private String name;
    private String type;
    private ApiClusterRef clusterRef;
    private String serviceUrl;
    private ApiServiceState serviceState;
    private ApiHealthSummary healthSummary;
    private List<ApiHealthCheck> healthChecks;
    private Boolean configStale;
    private ApiConfigStalenessStatus configStalenessStatus;
    private ApiConfigStalenessStatus clientConfigStalenessStatus;
    private Boolean maintenanceMode;
    private List<ApiEntityType> maintenanceOwners;
    private ApiServiceConfig config;
    private List<ApiRole> roles;
    private String displayName;
    private List<ApiRoleConfigGroup> roleConfigGroups;
    private List<ApiReplicationSchedule> replicationSchedules;
    private List<ApiSnapshotPolicy> snapshotPolicies;

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("clusterRef", (Object)this.clusterRef).add("serviceState", (Object)this.serviceState).add("healthSummary", (Object)this.healthSummary).add("config", (Object)this.config).add("roles", this.roles).toString();
    }

    public boolean equals(Object o) {
        ApiService that = ApiUtils.baseEquals(this, o);
        return this == that || that != null && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal((Object)this.clusterRef, (Object)that.clusterRef);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.type, this.clusterRef});
    }

    @XmlElement
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @XmlElement
    public ApiClusterRef getClusterRef() {
        return this.clusterRef;
    }

    public void setClusterRef(ApiClusterRef clusterRef) {
        this.clusterRef = clusterRef;
    }

    @XmlElement
    public ApiServiceState getServiceState() {
        return this.serviceState;
    }

    public void setServiceState(ApiServiceState serviceState) {
        this.serviceState = serviceState;
    }

    @XmlElement
    public ApiHealthSummary getHealthSummary() {
        return this.healthSummary;
    }

    public void setHealthSummary(ApiHealthSummary healthSummary) {
        this.healthSummary = healthSummary;
    }

    @Deprecated
    @XmlElement
    public Boolean getConfigStale() {
        return this.configStale;
    }

    public void setConfigStale(Boolean configStale) {
        this.configStale = configStale;
    }

    @XmlElement
    public ApiConfigStalenessStatus getConfigStalenessStatus() {
        return this.configStalenessStatus;
    }

    public void setConfigStalenessStatus(ApiConfigStalenessStatus configStalenessStatus) {
        this.configStalenessStatus = configStalenessStatus;
    }

    @XmlElement
    public ApiConfigStalenessStatus getClientConfigStalenessStatus() {
        return this.clientConfigStalenessStatus;
    }

    public void setClientConfigStalenessStatus(ApiConfigStalenessStatus clientConfigStalenessStatus) {
        this.clientConfigStalenessStatus = clientConfigStalenessStatus;
    }

    @XmlElementWrapper
    public List<ApiHealthCheck> getHealthChecks() {
        return this.healthChecks;
    }

    public void setHealthChecks(List<ApiHealthCheck> healthChecks) {
        this.healthChecks = healthChecks;
    }

    @XmlElement
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    @XmlElement
    public Boolean getMaintenanceMode() {
        return this.maintenanceMode;
    }

    public void setMaintenanceMode(Boolean maintenanceMode) {
        this.maintenanceMode = maintenanceMode;
    }

    @XmlElementWrapper(name="maintenanceOwners")
    public List<ApiEntityType> getMaintenanceOwners() {
        return this.maintenanceOwners;
    }

    public void setMaintenanceOwners(List<ApiEntityType> maintenanceOwners) {
        this.maintenanceOwners = Lists.newArrayList(maintenanceOwners);
    }

    @XmlElement
    public ApiServiceConfig getConfig() {
        return this.config;
    }

    public void setConfig(ApiServiceConfig config) {
        this.config = config;
    }

    @XmlElementWrapper(name="roles")
    public List<ApiRole> getRoles() {
        return this.roles;
    }

    public void setRoles(List<ApiRole> roles) {
        this.roles = roles;
    }

    @XmlElement
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @XmlElementWrapper
    public List<ApiRoleConfigGroup> getRoleConfigGroups() {
        return this.roleConfigGroups;
    }

    public void setRoleConfigGroups(List<ApiRoleConfigGroup> roleConfigGroups) {
        this.roleConfigGroups = roleConfigGroups;
    }

    @XmlElementWrapper
    public List<ApiReplicationSchedule> getReplicationSchedules() {
        return this.replicationSchedules;
    }

    public void setReplicationSchedules(List<ApiReplicationSchedule> replicationSchedules) {
        this.replicationSchedules = replicationSchedules;
    }

    @XmlElementWrapper
    public List<ApiSnapshotPolicy> getSnapshotPolicies() {
        return this.snapshotPolicies;
    }

    public void setSnapshotPolicies(List<ApiSnapshotPolicy> snapshotPolicies) {
        this.snapshotPolicies = snapshotPolicies;
    }
}

