/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.model;

import com.cloudera.api.ApiUtils;
import com.cloudera.api.model.ApiCommissionState;
import com.cloudera.api.model.ApiConfigList;
import com.cloudera.api.model.ApiConfigStalenessStatus;
import com.cloudera.api.model.ApiEntityType;
import com.cloudera.api.model.ApiHealthCheck;
import com.cloudera.api.model.ApiHealthSummary;
import com.cloudera.api.model.ApiHostRef;
import com.cloudera.api.model.ApiRoleConfigGroupRef;
import com.cloudera.api.model.ApiRoleState;
import com.cloudera.api.model.ApiServiceRef;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="role")
public class ApiRole {
    private String name;
    private String type;
    private ApiServiceRef serviceRef;
    private ApiHostRef hostRef;
    private String roleUrl;
    private ApiRoleState roleState;
    private ApiHealthSummary healthSummary;
    private List<ApiHealthCheck> healthChecks;
    private Boolean configStale;
    private ApiConfigStalenessStatus configStalenessStatus;
    private HaStatus haStatus;
    private Boolean maintenanceMode;
    private List<ApiEntityType> maintenanceOwners;
    private ApiCommissionState commissionState;
    private ApiConfigList config;
    private ApiRoleConfigGroupRef roleConfigGroupRef;
    private ZooKeeperServerMode zooKeeperServerMode;

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("serviceRef", (Object)this.serviceRef).add("hostRef", (Object)this.hostRef).add("roleState", (Object)this.roleState).add("healthSummary", (Object)this.healthSummary).add("healthChecks", this.healthChecks).add("commissionState", (Object)this.commissionState).add("roleConfigGroupRef", (Object)this.roleConfigGroupRef).toString();
    }

    public boolean equals(Object o) {
        ApiRole that = ApiUtils.baseEquals(this, o);
        return this == that || that != null && Objects.equal((Object)this.hostRef, (Object)that.hostRef) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.serviceRef, (Object)that.serviceRef) && Objects.equal((Object)this.roleConfigGroupRef, (Object)that.roleConfigGroupRef);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.serviceRef, this.hostRef, this.roleConfigGroupRef});
    }

    @XmlElement
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @XmlElement
    public ApiHostRef getHostRef() {
        return this.hostRef;
    }

    public void setHostRef(ApiHostRef hostRef) {
        this.hostRef = hostRef;
    }

    @XmlElement
    public ApiServiceRef getServiceRef() {
        return this.serviceRef;
    }

    public void setServiceRef(ApiServiceRef serviceRef) {
        this.serviceRef = serviceRef;
    }

    @XmlElement
    public ApiRoleState getRoleState() {
        return this.roleState;
    }

    public void setRoleState(ApiRoleState roleState) {
        this.roleState = roleState;
    }

    @XmlElement
    public ApiCommissionState getCommissionState() {
        return this.commissionState;
    }

    public void setCommissionState(ApiCommissionState commissionState) {
        this.commissionState = commissionState;
    }

    @XmlElement
    public ApiHealthSummary getHealthSummary() {
        return this.healthSummary;
    }

    public void setHealthSummary(ApiHealthSummary healthSummary) {
        this.healthSummary = healthSummary;
    }

    @Deprecated
    @XmlElement
    @JsonProperty(value="configStale")
    public Boolean getConfigStale() {
        return this.configStale;
    }

    public void setConfigStale(Boolean configStale) {
        this.configStale = configStale;
    }

    @XmlElement
    public ApiConfigStalenessStatus getConfigStalenessStatus() {
        return this.configStalenessStatus;
    }

    public void setConfigStalenessStatus(ApiConfigStalenessStatus configStalenessStatus) {
        this.configStalenessStatus = configStalenessStatus;
    }

    @XmlElementWrapper
    public List<ApiHealthCheck> getHealthChecks() {
        return this.healthChecks;
    }

    public void setHealthChecks(List<ApiHealthCheck> healthChecks) {
        this.healthChecks = healthChecks;
    }

    @XmlElement
    public HaStatus getHaStatus() {
        return this.haStatus;
    }

    public void setHaStatus(HaStatus haStatus) {
        this.haStatus = haStatus;
    }

    @XmlElement
    public String getRoleUrl() {
        return this.roleUrl;
    }

    public void setRoleUrl(String roleUrl) {
        this.roleUrl = roleUrl;
    }

    @XmlElement
    public Boolean getMaintenanceMode() {
        return this.maintenanceMode;
    }

    public void setMaintenanceMode(Boolean maintenanceMode) {
        this.maintenanceMode = maintenanceMode;
    }

    @XmlElementWrapper(name="maintenanceOwners")
    public List<ApiEntityType> getMaintenanceOwners() {
        return this.maintenanceOwners;
    }

    public void setMaintenanceOwners(List<ApiEntityType> maintenanceOwners) {
        this.maintenanceOwners = Lists.newArrayList(maintenanceOwners);
    }

    @XmlElement
    public ApiConfigList getConfig() {
        return this.config;
    }

    public void setConfig(ApiConfigList config) {
        this.config = config;
    }

    @XmlElement
    public ApiRoleConfigGroupRef getRoleConfigGroupRef() {
        return this.roleConfigGroupRef;
    }

    public void setRoleConfigGroupRef(ApiRoleConfigGroupRef roleConfigGroupRef) {
        this.roleConfigGroupRef = roleConfigGroupRef;
    }

    @XmlElement
    public ZooKeeperServerMode getZooKeeperServerMode() {
        return this.zooKeeperServerMode;
    }

    public void setZooKeeperServerMode(ZooKeeperServerMode zooKeeperServerMode) {
        this.zooKeeperServerMode = zooKeeperServerMode;
    }

    public static enum ZooKeeperServerMode {
        STANDALONE,
        REPLICATED_FOLLOWER,
        REPLICATED_LEADER,
        REPLICATED_LEADER_ELECTION,
        REPLICATED_OBSERVER,
        UNKNOWN;

    }

    public static enum HaStatus {
        ACTIVE,
        STANDBY,
        UNKNOWN;

    }
}

