/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.model;

import com.cloudera.api.ApiUtils;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;

abstract class ApiListBase<T>
implements Iterable<T> {
    public static final String ITEMS_ATTR = "items";
    protected List<T> values;

    public ApiListBase() {
        this.values = Lists.newArrayList();
    }

    public ApiListBase(List<T> values) {
        this.values = values;
    }

    public boolean add(T item) {
        return this.values.add(item);
    }

    @Override
    public Iterator<T> iterator() {
        return this.values.iterator();
    }

    public int size() {
        return this.values.size();
    }

    public T get(int index) {
        return this.values.get(index);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("values", this.values).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.values});
    }

    public boolean equals(Object o) {
        ApiListBase that = ApiUtils.baseEquals(this, o);
        return this == that || that != null && Objects.equal(this.values, that.values);
    }
}

