/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.model;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Arrays;

public enum ApiEventCategory {
    UNKNOWN,
    HEALTH_EVENT,
    LOG_EVENT,
    AUDIT_EVENT,
    ACTIVITY_EVENT,
    HBASE,
    SYSTEM;

    private static final String VALID_CATS;

    public static ApiEventCategory fromString(String category) {
        try {
            ApiEventCategory res = ApiEventCategory.valueOf(category.toUpperCase());
            if (res == UNKNOWN) {
                throw new IllegalArgumentException();
            }
            return res;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(category + " is not a valid event category. Supported category values: " + VALID_CATS);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Category cannot be null.");
        }
    }

    static {
        VALID_CATS = Joiner.on((String)", ").join((Iterable)Collections2.filter(Arrays.asList(ApiEventCategory.values()), (Predicate)new Predicate<ApiEventCategory>(){

            public boolean apply(ApiEventCategory input) {
                return input != UNKNOWN;
            }
        }));
    }
}

