/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.model;

import com.cloudera.api.ApiUtils;
import com.cloudera.api.model.ApiEventAttribute;
import com.cloudera.api.model.ApiEventCategory;
import com.cloudera.api.model.ApiEventSeverity;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="event")
@XmlType(propOrder={"id", "content", "timeOccurred", "timeReceived", "category", "severity", "alert", "attributes"})
public class ApiEvent {
    private String id;
    private Date timeOccurred;
    private Date timeReceived;
    private String content;
    private List<ApiEventAttribute> attributes;
    private ApiEventCategory category;
    private ApiEventSeverity severity;
    private boolean alert;

    public ApiEvent() {
    }

    public ApiEvent(String id, Date timeOccurred, Date timeReceived, ApiEventCategory category, ApiEventSeverity severity, String content, boolean alert, Map<String, List<String>> attrMap) {
        this.id = id;
        this.timeOccurred = timeOccurred;
        this.timeReceived = timeReceived;
        this.content = content;
        this.category = category;
        this.severity = severity;
        this.alert = alert;
        this.attributes = Lists.newArrayList();
        if (attrMap != null) {
            for (Map.Entry<String, List<String>> e : attrMap.entrySet()) {
                this.attributes.add(new ApiEventAttribute(e.getKey(), e.getValue()));
            }
        }
    }

    public boolean equals(Object o) {
        ApiEvent that = ApiUtils.baseEquals(this, o);
        return this == that || that != null && Objects.equal((Object)this.id, (Object)that.getId());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    @XmlElement
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlElement
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @XmlElement
    public Date getTimeOccurred() {
        return this.timeOccurred;
    }

    public void setTimeOccurred(Date timeOccurred) {
        this.timeOccurred = timeOccurred;
    }

    @XmlElement
    public Date getTimeReceived() {
        return this.timeReceived;
    }

    public void setTimeReceived(Date timeReceived) {
        this.timeReceived = timeReceived;
    }

    @XmlElement
    public ApiEventCategory getCategory() {
        return this.category;
    }

    public void setCategory(ApiEventCategory category) {
        this.category = category;
    }

    @XmlElement
    public ApiEventSeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(ApiEventSeverity severity) {
        this.severity = severity;
    }

    @XmlElement
    public boolean isAlert() {
        return this.alert;
    }

    public void setAlert(boolean alert) {
        this.alert = alert;
    }

    @XmlElementWrapper(name="attributes")
    public List<ApiEventAttribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<ApiEventAttribute> attributes) {
        this.attributes = attributes;
    }
}

