/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.model;

import com.cloudera.api.ApiUtils;
import com.cloudera.api.model.ApiClusterVersion;
import com.cloudera.api.model.ApiEntityType;
import com.cloudera.api.model.ApiParcel;
import com.cloudera.api.model.ApiService;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="cluster")
@XmlType(propOrder={"name", "displayName", "version", "fullVersion", "maintenanceMode", "maintenanceOwners", "services", "parcels", "clusterUrl"})
public class ApiCluster {
    private String name;
    private String displayName;
    private String clusterUrl;
    private ApiClusterVersion version;
    private String fullVersion;
    private Boolean maintenanceMode;
    private List<ApiEntityType> maintenanceOwners;
    private List<ApiService> services;
    private List<ApiParcel> parcels;

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("version", (Object)this.version).add("fullVersion", (Object)this.fullVersion).toString();
    }

    public boolean equals(Object o) {
        ApiCluster other = ApiUtils.baseEquals(this, o);
        return this == other || other != null && Objects.equal((Object)this.name, (Object)other.name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name});
    }

    @XmlElement
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @XmlElement
    public String getClusterUrl() {
        return this.clusterUrl;
    }

    public void setClusterUrl(String clusterUrl) {
        this.clusterUrl = clusterUrl;
    }

    @XmlElement
    public ApiClusterVersion getVersion() {
        return this.version;
    }

    public void setVersion(ApiClusterVersion version) {
        this.version = version;
    }

    @XmlElement
    public String getFullVersion() {
        return this.fullVersion;
    }

    public void setFullVersion(String fullVersion) {
        this.fullVersion = fullVersion;
    }

    @XmlElement
    public Boolean getMaintenanceMode() {
        return this.maintenanceMode;
    }

    public void setMaintenanceMode(Boolean maintenanceMode) {
        this.maintenanceMode = maintenanceMode;
    }

    @XmlElementWrapper(name="maintenanceOwners")
    public List<ApiEntityType> getMaintenanceOwners() {
        return this.maintenanceOwners;
    }

    public void setMaintenanceOwners(List<ApiEntityType> maintenanceOwners) {
        this.maintenanceOwners = Lists.newArrayList(maintenanceOwners);
    }

    @XmlElementWrapper(name="services")
    public List<ApiService> getServices() {
        return this.services;
    }

    public void setServices(List<ApiService> services) {
        this.services = services;
    }

    @XmlElementWrapper(name="parcels")
    public List<ApiParcel> getParcels() {
        return this.parcels;
    }

    public void setParcels(List<ApiParcel> parcels) {
        this.parcels = parcels;
    }
}

