/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.model;

import com.cloudera.api.ApiUtils;
import com.google.common.base.Objects;
import java.util.Date;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="audit")
@XmlType(propOrder={"timestamp", "service", "username", "impersonator", "ipAddress", "command", "resource", "operationText", "allowed", "serviceValues"})
public class ApiAudit {
    private String service;
    private String username;
    private String impersonator;
    private String command;
    private String ipAddress;
    private String resource;
    private boolean allowed;
    private Date timestamp;
    private String operationText;
    private Map<String, String> serviceValues;

    public ApiAudit() {
    }

    public ApiAudit(String service, String username, String impersonator, String command, String ipAddress, String resource, boolean allowed, Date timestamp, String operationText, Map<String, String> serviceValues) {
        this.service = service;
        this.username = username;
        this.impersonator = impersonator;
        this.command = command;
        this.ipAddress = ipAddress;
        this.resource = resource;
        this.allowed = allowed;
        this.timestamp = timestamp;
        this.operationText = operationText;
        this.serviceValues = serviceValues;
    }

    public boolean equals(Object o) {
        ApiAudit that = ApiUtils.baseEquals(this, o);
        return this == that || that != null && this.allowed == that.allowed && Objects.equal((Object)this.timestamp, (Object)that.timestamp) && Objects.equal((Object)this.username, (Object)that.username) && Objects.equal((Object)this.impersonator, (Object)that.impersonator) && Objects.equal((Object)this.service, (Object)that.service) && Objects.equal((Object)this.command, (Object)that.command) && Objects.equal((Object)this.ipAddress, (Object)that.ipAddress) && Objects.equal((Object)this.resource, (Object)that.resource) && Objects.equal((Object)this.operationText, (Object)that.operationText) && Objects.equal(this.getServiceValues(), that.getServiceValues());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.timestamp, this.username, this.impersonator, this.service, this.command, this.ipAddress, this.resource, this.allowed, this.operationText, this.serviceValues});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("service", (Object)this.service).add("username", (Object)this.username).add("impersonator", (Object)this.impersonator).add("command", (Object)this.command).add("ipAddress", (Object)this.ipAddress).add("resource", (Object)this.resource).add("allowed", this.allowed).add("timestamp", (Object)this.timestamp).add("operationText", (Object)this.operationText).add("serviceValues", this.serviceValues).toString();
    }

    @XmlElement
    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    @XmlElement
    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    @XmlElement
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String userName) {
        this.username = userName;
    }

    @XmlElement
    public String getImpersonator() {
        return this.impersonator;
    }

    public void setImpersonator(String impersonator) {
        this.impersonator = impersonator;
    }

    @XmlElement
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @XmlElement
    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    @XmlElement
    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    @XmlElement
    public boolean getAllowed() {
        return this.allowed;
    }

    public void setAllowed(boolean allowed) {
        this.allowed = allowed;
    }

    @XmlElement
    public String getOperationText() {
        return this.operationText;
    }

    public void setOperationText(String operationText) {
        this.operationText = operationText;
    }

    public Map<String, String> getServiceValues() {
        return this.serviceValues;
    }

    private void setServiceValues(Map<String, String> serviceValues) {
        this.serviceValues = serviceValues;
    }
}

