/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api;

import com.cloudera.api.ApiObjectMapper;
import com.cloudera.api.ApiRootResource;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.feature.LoggingFeature;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;

public class ClouderaManagerClientBuilder {
    public static final int DEFAULT_TCP_PORT = 7180;
    public static final long DEFAULT_CONNECTION_TIMEOUT = 0L;
    public static final TimeUnit DEFAULT_CONNECTION_TIMEOUT_UNITS = TimeUnit.MILLISECONDS;
    public static final long DEFAULT_RECEIVE_TIMEOUT = 0L;
    public static final TimeUnit DEFAULT_RECEIVE_TIMEOUT_UNITS = TimeUnit.MILLISECONDS;
    private URL baseUrl;
    private String hostname;
    private int port = 7180;
    private boolean enableTLS = false;
    private boolean enableLogging = false;
    private String username;
    private String password;
    private long connectionTimeout = 0L;
    private TimeUnit connectionTimeoutUnits = DEFAULT_CONNECTION_TIMEOUT_UNITS;
    private long receiveTimeout = 0L;
    private TimeUnit receiveTimeoutUnits = DEFAULT_RECEIVE_TIMEOUT_UNITS;
    private boolean validateCerts = true;
    private boolean validateCn = true;
    private TrustManager[] trustManagers = null;
    private static final LoadingCache<Class<?>, JAXRSClientFactoryBean> clientStaticResources = CacheBuilder.newBuilder().softValues().build(new CacheLoader<Class<?>, JAXRSClientFactoryBean>(){

        public JAXRSClientFactoryBean load(Class<?> proxyType) throws Exception {
            JAXRSClientFactoryBean clientFactoryBean = new JAXRSClientFactoryBean();
            clientFactoryBean.setResourceClass(proxyType);
            clientFactoryBean.setProvider((Object)new JacksonJsonProvider((ObjectMapper)new ApiObjectMapper()));
            return clientFactoryBean;
        }
    });

    public ClouderaManagerClientBuilder withBaseURL(URL baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public ClouderaManagerClientBuilder withHost(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public ClouderaManagerClientBuilder withPort(int port) {
        this.port = port;
        return this;
    }

    public ClouderaManagerClientBuilder enableTLS() {
        this.enableTLS = true;
        return this;
    }

    public ClouderaManagerClientBuilder enableLogging() {
        this.enableLogging = true;
        return this;
    }

    public ClouderaManagerClientBuilder withUsernamePassword(String username, String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    public ClouderaManagerClientBuilder withConnectionTimeout(long connectionTimeout, TimeUnit connectionTimeoutUnits) {
        this.connectionTimeout = connectionTimeout;
        this.connectionTimeoutUnits = connectionTimeoutUnits;
        return this;
    }

    public ClouderaManagerClientBuilder withReceiveTimeout(long receiveTimeout, TimeUnit receiveTimeoutUnits) {
        this.receiveTimeout = receiveTimeout;
        this.receiveTimeoutUnits = receiveTimeoutUnits;
        return this;
    }

    public ClouderaManagerClientBuilder disableTlsCertValidation() {
        this.validateCerts = false;
        return this;
    }

    public ClouderaManagerClientBuilder disableTlsCnValidation() {
        this.validateCn = false;
        return this;
    }

    @VisibleForTesting
    String generateAddress() {
        String apiRootPath = "api/";
        if (this.baseUrl != null) {
            return String.format("%s/%s", this.baseUrl.toExternalForm(), "api/");
        }
        if (this.hostname == null) {
            throw new IllegalArgumentException("hostname or full url must be set");
        }
        if (this.port <= 0) {
            throw new IllegalArgumentException(String.format("'%d' is not a valid port number", this.port));
        }
        String urlString = String.format("%s://%s:%d/%s", this.enableTLS ? "https" : "http", this.hostname, this.port, "api/");
        try {
            new URI(urlString);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid hostname", this.hostname), e);
        }
        return urlString;
    }

    public void setTrustManagers(TrustManager[] managers) {
        this.trustManagers = managers;
    }

    public ApiRootResource build() {
        return this.build(ApiRootResource.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T build(Class<T> proxyType) {
        String address = this.generateAddress();
        Class<ClouderaManagerClientBuilder> clazz = ClouderaManagerClientBuilder.class;
        synchronized (ClouderaManagerClientBuilder.class) {
            JAXRSClientFactoryBean bean = ClouderaManagerClientBuilder.cleanFactory((JAXRSClientFactoryBean)clientStaticResources.getUnchecked(proxyType));
            bean.setAddress(address);
            if (this.username != null) {
                bean.setUsername(this.username);
                bean.setPassword(this.password);
            }
            if (this.enableLogging) {
                bean.setFeatures(Arrays.asList(new LoggingFeature()));
            }
            Object rootResource = bean.create(proxyType, new Object[0]);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            boolean isTlsEnabled = address.startsWith("https://");
            ClientConfiguration config = WebClient.getConfig((Object)rootResource);
            HTTPConduit conduit = (HTTPConduit)config.getConduit();
            if (isTlsEnabled) {
                TLSClientParameters tlsParams = new TLSClientParameters();
                if (!this.validateCerts) {
                    tlsParams.setTrustManagers(new TrustManager[]{new AcceptAllTrustManager()});
                } else if (this.trustManagers != null) {
                    tlsParams.setTrustManagers(this.trustManagers);
                }
                tlsParams.setDisableCNCheck(!this.validateCn);
                conduit.setTlsClientParameters(tlsParams);
            }
            HTTPClientPolicy policy = conduit.getClient();
            policy.setConnectionTimeout(this.connectionTimeoutUnits.toMillis(this.connectionTimeout));
            policy.setReceiveTimeout(this.receiveTimeoutUnits.toMillis(this.receiveTimeout));
            return (T)rootResource;
        }
    }

    private static JAXRSClientFactoryBean cleanFactory(JAXRSClientFactoryBean bean) {
        bean.setUsername(null);
        bean.setPassword(null);
        bean.setFeatures(Arrays.asList(new AbstractFeature[0]));
        return bean;
    }

    public static void closeClient(ApiRootResource root) {
        ClientConfiguration config = WebClient.getConfig((Object)root);
        HTTPConduit conduit = config.getHttpConduit();
        if (conduit == null) {
            throw new IllegalArgumentException("Client is not using the HTTP transport");
        }
        conduit.close();
    }

    public static void clearCachedResources() {
        clientStaticResources.invalidateAll();
    }

    private static class AcceptAllTrustManager
    implements X509TrustManager {
        private AcceptAllTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

