/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public final class ApiUtils {
    private static final DateTimeFormatter DATE_TIME_PRINTER = ISODateTimeFormat.dateTime();
    private static final DateTimeFormatter DATE_TIME_PARSER = ISODateTimeFormat.dateTimeParser();
    private static final PeriodFormatter PERIOD_FORMATTER = ISOPeriodFormat.standard();
    public static final String DOT_SNAPSHOT_DIR = ".snapshot";

    public static Instant newInstantFromString(String value) {
        if (value.equalsIgnoreCase("now")) {
            return new Instant();
        }
        return new Instant(DATE_TIME_PARSER.parseMillis(value));
    }

    public static Date newDateFromString(String value) {
        return new Date(ApiUtils.newInstantFromString(value).getMillis());
    }

    public static Date newDateFromMillis(long millis) {
        return new Date(millis);
    }

    public static Period newPeriodFromString(String value) {
        return PERIOD_FORMATTER.parsePeriod(value);
    }

    public static String printDate(Date date) {
        return DATE_TIME_PRINTER.print((ReadableInstant)new Instant((Object)date));
    }

    public static String printDate(Instant instant) {
        return DATE_TIME_PRINTER.print((ReadableInstant)instant);
    }

    public static Date getFromDate(String fromString, Date toDate, Duration window) {
        Date fromDate = null;
        if (fromString != null) {
            fromDate = ApiUtils.newDateFromString(fromString);
            Preconditions.checkArgument((fromDate.getTime() < toDate.getTime() ? 1 : 0) != 0, (Object)"Invalid period specified: 'to' must be later than 'from'.");
        } else {
            Instant fromInstant = new Instant(toDate.getTime()).minus((ReadableDuration)window);
            fromDate = new Date(fromInstant.getMillis());
        }
        return fromDate;
    }

    public static <T> T baseEquals(T object, Object other) {
        if (object == other || other != null && object.getClass() == other.getClass()) {
            return (T)other;
        }
        return null;
    }

    public static void checkOffsetAndLimit(int offset, int limit) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"Offset should be greater or equal 0.");
        Preconditions.checkArgument((limit > 0 ? 1 : 0) != 0, (Object)"Limit should be greater than 0.");
    }

    private ApiUtils() {
    }
}

