/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="error")
@XmlType(propOrder={"message", "causes"})
public class ApiErrorMessage {
    private String message;
    private List<String> causes;

    public ApiErrorMessage() {
        this.message = null;
        this.causes = null;
    }

    public ApiErrorMessage(Throwable t) {
        this.message = t.getMessage();
        LinkedList causeMessages = Lists.newLinkedList();
        if (t.getCause() != null) {
            do {
                String errorMessage;
                if ((errorMessage = (t = t.getCause()).getMessage()) == null) continue;
                causeMessages.add(errorMessage);
            } while (t.getCause() != null);
        }
        this.causes = !causeMessages.isEmpty() ? causeMessages : null;
    }

    public ApiErrorMessage(String message) {
        this.message = message;
        this.causes = null;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).addValue((Object)this.message).toString();
    }

    @XmlElement
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @XmlElementWrapper
    public List<String> getCauses() {
        return this.causes;
    }

    public void setCauses(List<String> causes) {
        this.causes = causes;
    }
}

