/*-
 * #%L
 * thinkbig-ui-common
 * %%
 * Copyright (C) 2017 ThinkBig Analytics
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
angular.module("datalakeui.common").run(["$templateCache", function($templateCache) {$templateCache.put("js/shared/about-kylo/about.html","<md-dialog aria-label=\"About Kylo\" flex=\"35\"><md-dialog-content><p style=\"text-align:center\"><img src=\"/ui-common/img/kylo-logo-orange.png\" style=\"width:300px\"></p><p style=\"text-align:center\"><b>Version:</b> {{version}}</p><table cellpadding=\"10\"><tr><td><p style=\"text-align:justify; padding:10px\">The Kylo framework simplifies building, configuring, deploying and monitoring data pipelines. It enables data profiling, data discovery and data science. Businesses can quickly start leveraging value from their enterprise data lakes.<br><br>For enterprise support options, please visit <a href=\"https://www.thinkbiganalytics.com/kylo/\" target=\"_blank\">Think Big</a>.<br><br><textarea class=\"scrollabletextbox\" name=\"apache-licence\" readonly=\"true\" rows=\"7\" cols=\"55\" style=\"text-align:justify; color: black; background-color: #F6DDCC; padding:10px\">\nCopyright 2017 Teradata Corporation\n\nLicensed under the Apache License, Version 2.0 (the \"License\"); you may not use this file except in compliance with the License. You may obtain a copy of the License at\n\n  http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software distributed under the License is distributed on an \"AS IS\" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.\n          </textarea></p></td></tr></table></md-dialog-content><md-dialog-actions><md-button ng-click=\"cancel();\" class=\"md-primary\">Close</md-button></md-dialog-actions></md-dialog>");
    $templateCache.put("js/shared/card-filter-header/card-filter-header-template.html",
        "<div style=\"white-space: nowrap;margin-top:10px\" class=\"card-title\">{{::$cardFilterHeader.cardTitle}}</div><span flex=\"5\"></span><md-input-container flex style=\"margin-top:0px;margin-bottom:0px\"><label>Filter</label><input ng-model=\"$cardFilterHeader.filterModel\" ng-model-options=\"$cardFilterHeader.filterModelOptions\"></md-input-container><div layout=\"row\" layout-align=\"space-between center\"><md-button aria-label=\"Filter Help\" class=\"md-icon-button filter-help-button\" ng-click=\"$cardFilterHeader.showFilterHelpPanel($event)\" ng-if=\"$cardFilterHeader.renderHelp\"><ng-md-icon md-icon icon=\"help\" size=\"15\" style=\"fill:grey\"></ng-md-icon></md-button><tba-view-type-selection view-type=\"$cardFilterHeader.viewType\" style=\"margin-left:10px\"></tba-view-type-selection><tba-options-menu sort-options=\"$cardFilterHeader.sortOptions\" show-pagination=\"false\" menu-key=\"{{$cardFilterHeader.pageName}}\" selected-option=\"$cardFilterHeader.selectedOption\" opened-menu=\"$cardFilterHeader.menuOpen\" additional-options=\"$cardFilterHeader.additionalOptions\" selected-additional-option=\"$cardFilterHeader.selectedAdditionalOption\" show-view-type=\"false\" menu-icon=\"more_vert\"></tba-options-menu></div>");
$templateCache.put("js/shared/card-layout/card-layout-template.html","<section class=\"md-whiteframe-z1 {{::cardCss}}\"><div ng-transclude=\"header1\" class=\"card-toolbar {{::headerCss}}\"></div><md-content ng-transclude=\"body1\" class=\"card-layout-body {{::bodyCss}}\"></md-content></section>");
$templateCache.put("js/shared/kylo-options/kylo-options.html","<md-menu><md-button aria-label=\"Options\" class=\"md-icon-button\" style=\"margin-top:-10px\" ng-click=\"openMenu($mdOpenMenu, $event)\"><ng-md-icon icon=\"{{menuIcon}}\"></ng-md-icon></md-button><md-menu-content width=\"3\"><md-menu-item><header><md-icon style=\"margin-right: 16px\">account_circle</md-icon>{{username}}</header></md-menu-item><md-menu-item><md-button ng-click=\"logout()\">Logout</md-button></md-menu-item><md-menu-divider></md-menu-divider><md-menu-item layout=\"column\"><md-button ng-click=\"aboutKylo()\" md-prevent-menu-close=\"md-prevent-menu-close\"><span style=\"float:left\">About Kylo</span></md-button></md-menu-item></md-menu-content></md-menu>");
$templateCache.put("js/shared/options-menu/options-menu-template.html","<md-menu><md-button aria-label=\"Options\" class=\"md-icon-button\" style=\"margin-top:-10px\" ng-click=\"openMenu($mdOpenMenu, $event)\"><ng-md-icon icon=\"{{menuIcon}}\"></ng-md-icon></md-button><md-menu-content width=\"3\"><md-menu-item ng-if=\"showPagination\"><md-input-container><label>Rows per page</label><md-select class=\"\" ng-model=\"paginationData.rowsPerPage\"><md-option ng-repeat=\"x in paginationData.rowsPerPageOptions\" value=\"{{x}}\">{{x}}</md-option></md-select></md-input-container></md-menu-item><md-menu-item class=\"md-menu-item-header\" ng-if=\"showViewType == true\"><span md-menu-align-target class=\"md-subheader md-menu-item-header\">View Options</span></md-menu-item><md-menu-item layout=\"column\" ng-if=\"showViewType == true\"><md-button ng-click=\"selectOption(viewType)\" md-prevent-menu-close=\"md-prevent-menu-close\"><span style=\"float:left\">{{viewType.label}}</span> <span style=\"float:right\"><ng-md-icon icon=\"{{viewType.icon}}\"></ng-md-icon></span></md-button></md-menu-item><md-menu-item class=\"md-menu-item-header\"><span md-menu-align-target class=\"md-subheader md-menu-item-header\">Sort Options</span></md-menu-item><md-menu-item ng-repeat=\"item in sortOptions\" layout=\"column\"><md-button ng-click=\"selectOption(item)\" md-prevent-menu-close=\"md-prevent-menu-close\"><span style=\"float:left\">{{item.label}}</span> <span ng-if=\"item.icon && item.icon != \'\'\" style=\"float:right\"><ng-md-icon icon=\"{{item.icon}}\"></ng-md-icon></span></md-button></md-menu-item><md-menu-divider ng-if=\"additionalOptions && additionalOptions.length >0\"></md-menu-divider><md-menu-item ng-if=\"additionalOptions && additionalOptions.length >0\" ng-repeat=\"item in additionalOptions\" ng-class=\"{\'md-menu-item-header\': item.header}\"><span md-menu-align-target class=\"md-subheader md-menu-item-header\" ng-if=\"item.header\">{{item.label}}</span><md-button ng-click=\"selectAdditionalOption(item)\" md-prevent-menu-close=\"md-prevent-menu-close\" ng-if=\"!item.header\" ng-disabled=\"item.disabled\"><span style=\"float:left\">{{item.label}}</span> <span ng-if=\"item.icon && item.icon != \'\'\" style=\"float:right\"><ng-md-icon icon=\"{{item.icon}}\"></ng-md-icon></span></md-button></md-menu-item></md-menu-content></md-menu>");
$templateCache.put("js/shared/ui-router-breadcrumbs/uiBreadcrumbs.tpl.html","<div ng-if=\"lastBreadcrumbs.length == 2\" layout-align=\"center\" style=\"white-space: nowrap\"><md-button class=\"icon-btn\" ng-click=\"navigate( lastBreadcrumbs[0])\"><ng-md-icon md-icon icon=\"keyboard_arrow_left\"></ng-md-icon></md-button><span>{{ lastBreadcrumbs[0].displayName }}</span></div><div ng-if=\"lastBreadcrumbs.length == 1\" style=\"white-space: nowrap\">{{ lastBreadcrumbs[0].displayName }}</div>");
$templateCache.put("js/shared/vertical-section-layout/vertical-section-layout-template.html","<div layout=\"column\" class=\"layout-padding-left\" style=\"padding-top:10px\"><div><div layout=\"row\" layout-align=\"start stretch\"><ng-md-icon icon=\"check\" style=\"fill:#009933;margin-left: -9px\" ng-if=\"showVerticalCheck == true\"></ng-md-icon><span class=\"md-subhead layout-padding-left\">{{sectionTitle}}</span> <span flex></span><md-button class=\"icon-btn md-icon-button md-primary\" ng-click=\"edit($event)\" ng-if=\"allowEdit ==true && !editable\"><ng-md-icon icon=\"edit\"></ng-md-icon></md-button><md-button class=\"icon-btn md-icon-button\" ng-click=\"cancel($event)\" ng-if=\"allowEdit ==true && editable\"><ng-md-icon icon=\"cancel\" style=\"fill:grey\"></ng-md-icon></md-button></div><div class=\"vertical-step-border\"><div ng-if=\"!editable\" class=\"md-padding\"><div ng-transclude=\"readonly\">REadonly SEction</div></div><div ng-if=\"editable == true\" class=\"md-padding\"><form name=\"{{formName}}\"><div ng-transclude=\"editable\">Editable SEction</div><div layout=\"row\" layout-align=\"end center\"><md-button ng-click=\"delete($event)\" ng-disabled=\"allowDelete == false\" ng-if=\"onDelete !== undefined && isDeleteVisible == true\">Delete</md-button><span flex></span><md-button ng-click=\"cancel($event)\">Cancel</md-button><md-button class=\"md-primary md-raised\" ng-click=\"save($event)\" ng-disabled=\"isValid == false || (theForm != undefined && theForm.$invalid != undefined && theForm.$invalid == true)\">Save</md-button></div></form></div></div></div></div>");
$templateCache.put("js/shared/view-type-selection/view-type-selection-template.html","<span class=\"md-button-group\" layout-align=\"center center\"><md-button class=\"icon-btn\" ng-click=\"viewTypeChanged(\'table\')\" ng-class=\"{\'selected\' : viewType == \'table\'}\"><ng-md-icon md-icon icon=\"list\"></ng-md-icon></md-button><md-button class=\"icon-btn\" ng-click=\"viewTypeChanged(\'list\')\" ng-class=\"{\'selected\' : viewType == \'list\'}\"><ng-md-icon md-icon icon=\"view_list\"></ng-md-icon></md-button></span>");
$templateCache.put("js/vendor/dirPagination/dirPagination.md-tpl.html","<div layout=\"row\"><span ng-if=\"boundaryLinks\" ng-class=\"{ disabled : pagination.current == 1 }\"><a href=\"\" ng-click=\"setCurrent(1)\">&laquo;</a> </span><span ng-if=\"directionLinks\" ng-class=\"{ disabled : pagination.current == 1 }\"><a href=\"\" ng-click=\"setCurrent(pagination.current - 1)\">&lsaquo;</a> </span><span ng-repeat=\"pageNumber in pages track by tracker(pageNumber, $index)\" ng-class=\"{ active : pagination.current == pageNumber, disabled : pageNumber == \'...\' }\"><a href=\"\" ng-click=\"setCurrent(pageNumber)\">{{ pageNumber }}</a> </span><span ng-if=\"directionLinks\" ng-class=\"{ disabled : pagination.current == pagination.last }\"><a href=\"\" ng-click=\"setCurrent(pagination.current + 1)\">&rsaquo;</a> </span><span ng-if=\"boundaryLinks\" ng-class=\"{ disabled : pagination.current == pagination.last }\"><a href=\"\" ng-click=\"setCurrent(pagination.last)\">&raquo;</a></span></div>");
$templateCache.put("js/vendor/dirPagination/dirPagination.tpl.html","<div><span class=\"label\">{{label}}</span><md-select ng-model=\"rowsPerPage\" md-container-class=\"md-pagination-select\" placeholder=\"{{rowsPerPage ? rowsPerPageOptions[0] : 5}}\"><md-option ng-repeat=\"x in rowsPerPageOptions\" value=\"{{x}}\">{{x}}</md-option></md-select><span>{{range.lower}} - {{range.upper}} of {{range.total}}</span></div><div><md-button ng-if=\"boundaryLinks\" type=\"button\" ng-click=\"setCurrent(1)\" ng-disabled=\"pagination.current == 1\" aria-label=\"First\"><md-icon md-svg-icon=\"templates.navigate-first.html\"></md-icon></md-button><md-button type=\"button\" ng-click=\"setCurrent(pagination.current - 1)\" ng-disabled=\"pagination.current == 1\" aria-label=\"Previous\"><md-icon md-svg-icon=\"templates.navigate-before.html\"></md-icon></md-button><md-button type=\"button\" ng-click=\"setCurrent(pagination.current + 1)\" ng-disabled=\"pagination.current == pagination.last\" aria-label=\"Next\"><md-icon md-svg-icon=\"templates.navigate-next.html\"></md-icon></md-button><md-button ng-if=\"boundaryLinks\" type=\"button\" ng-click=\"setCurrent(pagination.last)\" ng-disabled=\"pagination.current == pagination.last\" aria-label=\"Last\"><md-icon md-svg-icon=\"templates.navigate-last.html\"></md-icon></md-button></div>");}]);