/*-
 * #%L
 * kylo-ui-common
 * %%
 * Copyright (C) 2017 ThinkBig Analytics
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
var COMMON_APP_MODULE_NAME="datalakeui.common";angular.module(COMMON_APP_MODULE_NAME,[]);angular.module(COMMON_APP_MODULE_NAME).service("AboutKyloService",function($mdDialog){var self=this;self.showAboutDialog=function(){$mdDialog.show({controller:"AboutKyloDialogController",templateUrl:"js/shared/about-kylo/about.html",parent:angular.element(document.body),clickOutsideToClose:false,escapeToClose:true,fullscreen:false,locals:{}}).then(function(msg){},function(){})}});
(function(){var controller=function($scope,$mdDialog,$http){var self=this;$http({method:"GET",url:"/proxy/v1/about/version"}).then(function callSuccess(response){$scope.version=response.data},function callFailure(response){$scope.version="Not Available"});$scope.hide=function(){$mdDialog.hide()};$scope.cancel=function(){$mdDialog.cancel()}};angular.module(COMMON_APP_MODULE_NAME).controller("AboutKyloDialogController",controller)})();
(function(){var httpInterceptor=function($provide,$httpProvider){$provide.factory("httpInterceptor",function($q,$location,$window,$injector,Utils){return{request:function(request){if(angular.isUndefined(request.headers))request.headers={};request.headers["X-Requested-With"]="XMLHttpRequest";return request},response:function(response){var NotificationService=$injector.get("NotificationService");var redirectLocation;if(response.headers()&&response.headers()["Location"]&&response.headers()["Location"].endsWith("login.html"))redirectLocation=
null;else if(response.data&&response.config&&!Utils.endsWith(response.config.url,".html")&&typeof response.data=="string")if(response.data.indexOf("\x3c!-- login.html --\x3e")>=0)redirectLocation="/login.html";if(angular.isDefined(redirectLocation)){NotificationService.errorWithGroupKey("Login Required","You are required to login to view this content.","Login Required");if(redirectLocation!==null)$window.location.href=redirectLocation}return response||$q.when(response)},responseError:function(rejection){var NotificationService=
$injector.get("NotificationService");if(rejection.data==undefined)rejection.data={};if(rejection.status===401){NotificationService.errorWithGroupKey("Login Required","You are required to login to view this content.","Login Required");$window.location.href="/login.html"}else if(rejection.status<=0);else if(rejection.status===400){var message="An unexpected error occurred ";var errorMessage=rejection.data["message"];var groupKey=errorMessage;if(groupKey==undefined||groupKey=="")groupKey="OtherError";
var url=rejection.data["url"];if(url!=undefined&&url!=null&&url!="")message+=" attempting to access: "+url;message+=".";if(rejection.data["handledException"]==undefined||rejection.data["handledException"]!=undefined&&rejection.data["handledException"]==false)if(rejection.data["url"])NotificationService.errorWithGroupKey("Error",message,url,errorMessage);else NotificationService.errorWithGroupKey("Error",message,groupKey,errorMessage)}else if(rejection.data["handledException"]==undefined||rejection.data["handledException"]!=
undefined&&rejection.data["handledException"]==false){var message="An unexpected error occurred ";var rejectionMessage=rejection.data["message"];if(rejectionMessage==undefined||rejectionMessage=="")rejectionMessage="OtherError";NotificationService.errorWithGroupKey("Error",message,rejectionMessage,rejection.data["message"])}return $q.reject(rejection)}}});$httpProvider.interceptors.push("httpInterceptor")};angular.module(COMMON_APP_MODULE_NAME).config(httpInterceptor)})();
angular.module(COMMON_APP_MODULE_NAME).factory("BroadcastService",function($rootScope,$timeout){var waitingEvents={};var data={notify:function(event,data,waitTime){if(waitTime==undefined)waitTime=0;if(waitingEvents[event]==undefined){waitingEvents[event]=event;$timeout(function(){$rootScope.$emit(event,data);delete waitingEvents[event]},waitTime)}},subscribe:function(scope,event,callback){var handler=$rootScope.$on(event,callback);scope.$on("$destroy",handler)}};return data});
var BroadcastConstants=function(){function BroadcastConstants(){}BroadcastConstants.CONTENT_WINDOW_RESIZED="CONTENT_WINDOW_RESIZED";return BroadcastConstants}();
(function(){var directive=function($window,$compile){return{link:function($scope,element,attrs){element.addClass("browser-height");var eleSelector=attrs.browserHeightSelector;var scrollY=attrs.browserHeightScrollY;var browserHeightWaitAndCalc=attrs.browserHeightWaitAndCalc;if(browserHeightWaitAndCalc!=undefined&&browserHeightWaitAndCalc=="true")browserHeightWaitAndCalc=true;else browserHeightWaitAndCalc=false;if(scrollY==undefined)scrollY=true;else if(scrollY=="false")scrollY=false;else scrollY=true;
var scrollX=attrs.browserHeightScrollLeft;if(scrollX==undefined)scrollX=attrs.browserHeightScrollX;if(scrollX=="true")scrollX=true;else scrollX=false;var bindResize=attrs.browserHeightResizeEvent;if(bindResize==undefined)bindResize=true;else if(bindResize=="true")bindResize=true;else bindResize=false;var ele=element;if(eleSelector!=undefined)ele=element.find(eleSelector);var offsetHeight=attrs.browserHeightOffset;if(offsetHeight)offsetHeight=parseInt(offsetHeight);else offsetHeight=0;function calcHeight(){var windowHeight=
angular.element($window).height();var newHeight=windowHeight-offsetHeight;ele.css("height",newHeight+"px");if(scrollY)ele.css("overflow-y","scroll");if(scrollX)ele.css("overflow-x","scroll");else ele.css("overflow-x","hidden")}if(browserHeightWaitAndCalc)setTimeout(function(){calcHeight()},1300);if(bindResize)angular.element($window).bind("resize.browserheight",function(){calcHeight()});$scope.$on("$destroy",function(){angular.element($window).unbind("resize.browserheight")});setTimeout(function(){calcHeight()},
10)}}};angular.module(COMMON_APP_MODULE_NAME).directive("browserHeight",directive)})();angular.module(COMMON_APP_MODULE_NAME).directive("stringToNumber",function(){return{require:"ngModel",link:function(scope,element,attrs,ngModel){ngModel.$parsers.push(function(value){return""+value});ngModel.$formatters.push(function(value){return parseFloat(value,10)})}}});
angular.module(COMMON_APP_MODULE_NAME).directive("currentTime",function($http,$interval,$filter){return{restrict:"EA",scope:{dateFormat:"@",refreshInterval:"@"},template:"\x3cspan\x3e{{currentTime}}\x3c/span\x3e",link:function(scope,element,attrs){var fullRefreshInterval=6E4;var lastFullRefresh=null;var currentTimeInMillis=null;if(scope.dateFormat==null)scope.dateFormat="MMM d, yyyy HH:mm:ss";function setTimeUsingJavaScript(){if(currentTimeInMillis!=null){var millisDiff=(new Date).getTime()-currentTimeInMillis;
currentTimeInMillis=currentTimeInMillis+millisDiff;scope.currentTime=$filter("date")(currentTimeInMillis,scope.dateFormat)}}function setTime(){if(shouldPerformFullRefresh()){lastFullRefresh=(new Date).getTime();refreshTime()}else setTimeUsingJavaScript()}function refreshTime(){$http.get("/proxy/v1/configuration/system-time").then(function(response){scope.currentTime=$filter("date")(response.data,scope.dateFormat);currentTimeInMillis=response.data})}function shouldPerformFullRefresh(){return lastFullRefresh==
null||(new Date).getTime()-lastFullRefresh>fullRefreshInterval}setTime();if(scope.refreshInterval==null)scope.refreshInterval=5E3;if(scope.refreshInterval>1E3)$interval(setTime,scope.refreshInterval)}}});angular.module(COMMON_APP_MODULE_NAME).service("ConfigurationService",function(){var self=this;this.MODULE_URLS="/proxy/v1/configuration/module-urls"});
angular.module(COMMON_APP_MODULE_NAME).directive("fileModel",["$parse",function($parse){return{restrict:"A",link:function(scope,element,attrs){var model=$parse(attrs.fileModel);var modelSetter=model.assign;element.bind("change",function(){scope.$apply(function(){modelSetter(scope,element[0].files[0])})})}}}]);
function uploadFile($parse){var directive={restrict:"E",template:'\x3cinput id\x3d"fileInput" type\x3d"file" class\x3d"ng-hide"\x3e \x3cmd-button id\x3d"uploadButton" class\x3d"md-raised md-primary" aria-label\x3d"attach_file"\x3e    Choose file \x3c/md-button\x3e\x3cmd-input-container class\x3d"condensed-no-float" md-no-float  flex\x3e    \x3cinput id\x3d"textInput" size\x3d"40" ng-model\x3d"fileName" type\x3d"text" placeholder\x3d"No file chosen" ng-readonly\x3d"true" style\x3d"margin-top: 20px;"\x3e\x3c/md-input-container\x3e',link:function(scope,
element,attrs){var input=$(element[0].querySelector("#fileInput"));var button=$(element[0].querySelector("#uploadButton"));var textInput=$(element[0].querySelector("#textInput"));var size=attrs.inputSize;if(size!=null)try{size=parseInt(size);input.attr("size",size)}catch(e){}var model=$parse(attrs.uploadFileModel);var modelSetter=model.assign;if(input.length&&button.length&&textInput.length){button.click(function(e){input.click()});textInput.click(function(e){input.click()})}input.on("change",function(e){var files=
e.target.files;if(files[0]){scope.fileName=files[0].name;button.removeClass("md-primary")}else{scope.fileName=null;button.addClass("md-primary")}scope.$apply(function(){modelSetter(scope,files[0])})})}};return directive}angular.module(COMMON_APP_MODULE_NAME).directive("uploadFile",["$parse",uploadFile]);
angular.module(COMMON_APP_MODULE_NAME).service("FileUpload",["$http",function($http){this.uploadFileToUrl=function(file,uploadUrl,successFn,errorFn,params){var fd=new FormData;fd.append("file",file);if(params)angular.forEach(params,function(val,key){fd.append(key,val)});$http.post(uploadUrl,fd,{transformRequest:angular.identity,headers:{"Content-Type":undefined}}).success(function(data){if(successFn)successFn(data)}).error(function(err){if(errorFn)errorFn(err)})}}]);
angular.module(COMMON_APP_MODULE_NAME).filter("words",function(){return function(input,words){if(isNaN(words))return input;if(words<=0)return"";if(input){var inputWords=input.split(/\s+/);if(inputWords.length>words)input=inputWords.slice(0,words).join(" ")+"…"}return input}});
angular.module(COMMON_APP_MODULE_NAME).filter("timeAsSeconds",function(){return function(seconds){var SECONDS_PER_YEAR=31536E3;var SECONDS_PER_MONTH=2592E3;var SECONDS_PER_WEEK=604800;var SECONDS_PER_DAY=86400;var SECONDS_PER_HOUR=3600;var SECONDS_PER_MINUTE=60;var timePeriod="";var units="";seconds=seconds.substring(0,seconds.indexOf("sec"));if(!isNaN(seconds))seconds=parseInt(seconds);var numyears=Math.floor(seconds/SECONDS_PER_YEAR);var nummonths=Math.floor(seconds%SECONDS_PER_YEAR/SECONDS_PER_MONTH);
var numweeks=Math.floor(seconds%SECONDS_PER_YEAR%SECONDS_PER_MONTH/SECONDS_PER_WEEK);var numdays=Math.floor(seconds%SECONDS_PER_YEAR%SECONDS_PER_MONTH%SECONDS_PER_WEEK/SECONDS_PER_DAY);var numhours=Math.floor(seconds%SECONDS_PER_YEAR%SECONDS_PER_MONTH%SECONDS_PER_WEEK%SECONDS_PER_DAY/SECONDS_PER_HOUR);var numminutes=Math.floor(seconds%SECONDS_PER_YEAR%SECONDS_PER_MONTH%SECONDS_PER_WEEK%SECONDS_PER_DAY%SECONDS_PER_HOUR/SECONDS_PER_MINUTE);var numseconds=seconds%SECONDS_PER_YEAR%SECONDS_PER_MONTH%SECONDS_PER_WEEK%
SECONDS_PER_DAY%SECONDS_PER_HOUR%SECONDS_PER_MINUTE;if(numyears>0){timePeriod="years";units=numyears}else if(nummonths>0){timePeriod="months";units=nummonths}else if(numweeks>0){timePeriod="weeks";units=numweeks}else if(numdays>0){timePeriod="days";units=numdays}else if(numhours>0){timePeriod="hours";units=numhours}else if(numminutes>0){timePeriod="minutes";units=numminutes}else if(numseconds>0){timePeriod="seconds";units=numseconds}return units+" "+timePeriod}});
angular.module(COMMON_APP_MODULE_NAME).filter("characters",function(){return function(input,chars){if(input==null||input==undefined)input="";if(isNaN(chars))return input;if(chars)if(input.length>chars)input=input.substring(0,chars)+"...";return input}});angular.module(COMMON_APP_MODULE_NAME).filter("maskProfanity",["Utils",function(Utils){return function(input){return Utils.maskProfanity(input)}}]);
angular.module(COMMON_APP_MODULE_NAME).filter("unique",function(){return function(items,filterOn){if(filterOn===false)return items;if((filterOn||angular.isUndefined(filterOn))&&angular.isArray(items)){var hashCheck={},newItems=[];var extractValueToCompare=function(item){if(angular.isObject(item)&&angular.isString(filterOn))return item[filterOn];else return item};angular.forEach(items,function(item){var valueToCheck,isDuplicate=false;for(var i=0;i<newItems.length;i++)if(angular.equals(extractValueToCompare(newItems[i]),
extractValueToCompare(item))){isDuplicate=true;break}if(!isDuplicate)newItems.push(item)});items=newItems}return items}});angular.module("example",[]).filter("trust",["$sce",function($sce){return function(value,type){return $sce.trustAs(type||"html",text)}}]);angular.module(COMMON_APP_MODULE_NAME).filter("highlight",function($sce){return function(text,phrase){if(phrase)text=text.replace(new RegExp("("+phrase+")","gi"),'\x3cspan class\x3d"highlighted"\x3e$1\x3c/span\x3e');return $sce.trustAsHtml(text)}});
angular.module(COMMON_APP_MODULE_NAME).filter("join",function(){return function(arr,joinChar,childProperty){if(joinChar===undefined)joinChar=",";if(angular.isArray(arr))if(!childProperty)return arr.join(joinChar);else return _.map(arr,function(item){return item[childProperty]}).join(joinChar);return arr}});angular.module(COMMON_APP_MODULE_NAME).filter("moment",function(){return function(timeInMs){return moment(timeInMs).fromNow()}});
angular.module(COMMON_APP_MODULE_NAME).filter("time",["Utils",function(Utils){return function(timeInMs){var time=Utils.formatTimeMinSec(timeInMs);return time}}]);
var GoogleChartsUtil=function(){function GoogleChartsUtil(){}GoogleChartsUtil.getPieChartDataTable=function(tableData,xField,xFieldLabelFn,xColumnHeader,aggregrateColumnHeader,aggregrateFn){var data={};var labelMap={};$.each(tableData,function(i,row){var value=row[xField];if(data[value]===undefined){data[value]=[1];if(xFieldLabelFn){var label=xFieldLabelFn(value,data);labelMap[value]=label}}else data[value].push(1)});var totals=[[xColumnHeader,aggregrateColumnHeader]];var keys=Object.keys(data);var len=
keys.length;keys.sort();for(var i=0;i<len;i++){var key=keys[i];var values=data[key];var aggregrateValue=ArrayUtils.aggregrate(values,aggregrateFn)||null;totals[i+1]=[labelMap[key],aggregrateValue]}return google.visualization.arrayToDataTable(totals)};GoogleChartsUtil.getGoogleChartsDataTable=function(tableData,xField,yField,columnField,aggregrateFn,xValueCallbackFn,yValueCallbackFn,tooltipCallbackFn){var xyMap={};var xValueMap={};var distinctXValues=[];var columnNames=$.map(tableData,function(row,
i){return row[columnField]});columnNames=$.unique(columnNames).sort();var offset=0;var arrLength=columnNames.length+offset;var dataTable=new google.visualization.DataTable;dataTable.addColumn(xField.type,xField.label);$.each(columnNames,function(i,columnName){dataTable.addColumn(yField.type,columnName);dataTable.addColumn({"type":"string","role":"tooltip","p":{"html":true}})});var tableMap={};$.each(tableData,function(i,row){var rowXValue=row[xField.fieldName];if(rowXValue!==undefined){if(xValueMap[rowXValue]===
undefined){var rowArray=[];xValueMap[rowXValue]=rowArray;for(var i=0;i<arrLength;i++)rowArray[i]={};distinctXValues.push(rowXValue)}var rowArray=xValueMap[rowXValue];var columnIndex=$.inArray(row[columnField],columnNames);columnIndex+=offset;var currentValue=rowArray[columnIndex];if($.isEmptyObject(currentValue)){currentValue={objects:[],values:[]};rowArray[columnIndex]=currentValue}var yValue=row[yField.fieldName];if(yValue!=null&&yValue!==undefined){currentValue.values.push(yValue);currentValue.objects.push(row)}}else;
});var googleDataTableRows=[];$.each(xValueMap,function(xValue,row){var tableRow=[];var tableXVal=xValue;if(xValueCallbackFn)tableXVal=xValueCallbackFn(xValue,row,columnNames);tableRow.push(tableXVal);$.each(row,function(i,columnValues){if(aggregrateFn==undefined)aggregrateFn="sum";var objects=columnValues.objects;var values=columnValues.values;var yValue=ArrayUtils.aggregrate(values,aggregrateFn)||null;if(yValueCallbackFn)yValue=yValueCallbackFn(yValue,objects,values,columnNames);tableRow.push(yValue);
var toolTipValue="";if(tooltipCallbackFn)toolTipValue=tooltipCallbackFn(yValue,objects,values,columnNames);tableRow.push(toolTipValue)});googleDataTableRows.push(tableRow)});dataTable.addRows(googleDataTableRows);return dataTable};return GoogleChartsUtil}();
angular.module(COMMON_APP_MODULE_NAME).service("HttpService",["$q","$http",function($q,$http){var self=this;this.cancelPendingHttpRequests=function(){angular.forEach($http.pendingRequests,function(request){if(request.cancel&&request.timeout)request.cancel.resolve()})};this.getJson=function(url){return $http.get(url,{headers:{"Content-type":"application/json"}})};this.AbortableRequestBuilder=function(url){var builder=this;this.successFn;this.errorFn;this.finallyFn;this.transformFn;this.params;this.url=
url;return{params:function(getParameters){if(getParameters)builder.params=getParameters;return this},transform:function(fn){if(fn)builder.transformFn=fn;return this},success:function(fn){if(fn)builder.successFn=fn;return this},error:function(fn){if(fn)builder.errorFn=fn;return this},finally:function(fn){if(fn)builder.finallyFn=fn;return this},build:function(){var canceller={resolve:function(){}};var options={};if(builder.params)options.params=builder.params;if(builder.transformFn)options.transformResponse=
builder.transformFn;var promise=$http.get(builder.url,options);if(builder.successFn)promise.success(builder.successFn);if(builder.errorFn)promise.error(builder.errorFn);promise.finally(function(){if(builder.finallyFn)builder.finallyFn()});return{promise:promise,cancel:canceller,abort:function(){if(this.cancel!=null)this.cancel.resolve("Aborted");this.cancel=null;this.promise=null}}}}};this.getAllRequestBuilder=function(urls){this.id=IDGenerator.generateId("requestBuilder");var builder=this;this.urls=
urls;this.requestBuilders=[];this.finalSuccessFn;this.finalErrorFn;this.finallyFn;this.allData=[];var successFn=function(data){if(data.length===undefined)data=[data];if(data.length>0)builder.allData.push.apply(builder.allData,data)};var errorFn=function(data,status,headers,config){if(status&&status==0);else console.log("Failed to execute query  ",data,status,headers,config)};for(var i=0;i<urls.length;i++){var rqst=(new self.AbortableRequestBuilder(urls[i])).success(successFn).error(errorFn);builder.requestBuilders.push(rqst)}return{success:function(fn){if(fn)builder.finalSuccessFn=
fn;return this},error:function(fn){if(fn)builder.finalErrorFn=fn;return this},finally:function(fn){if(fn)builder.finallyFn=fn;return this},build:function(){var deferred=$q.defer();var promises=[];var requests=[];for(var i=0;i<builder.requestBuilders.length;i++){var rqst=builder.requestBuilders[i].build();requests.push(rqst);promises.push(rqst.promise)}deferred.promise.then(function(data){if(builder.finalSuccessFn)builder.finalSuccessFn(data)},function(){if(builder.finalErrorFn)builder.finalErrorFn()}).finally(function(){if(builder.finallyFn)builder.finallyFn()});
$q.all(promises).then(function(returnData){deferred.resolve(builder.allData)},function(e){if(e&&e.status&&e.status==0);else console.log("Error occurred",e)});return{requests:requests,promise:deferred.promise,abort:function(){if(this.requests)for(var i=0;i<this.requests.length;i++)this.requests[i].abort("Aborted")}}}}};this.get=function(url){return self.newRequestBuilder(url).build()};this.newRequestBuilder=function(url){return new self.AbortableRequestBuilder(url)};this.getAndTransform=function(url,
transformFn){return self.newRequestBuilder(url).transform(transformFn).build()};this.getAll=function(urls,successFunction,errorFunction,finallyFunction){return(new self.getAllRequestBuilder(urls)).success(successFunction).error(errorFunction).finally(finallyFunction).build()};this.appendTransform=function(defaults,transform){defaults=angular.isArray(defaults)?defaults:[defaults];return defaults.concat(transform)}}]);
var IDGenerator=function(){function IDGenerator(){}IDGenerator.generateId=function(prefix){IDGenerator.idNumber++;if(prefix)return prefix+"_"+IDGenerator.idNumber;else return IDGenerator.idNumber};IDGenerator.idNumber=0;return IDGenerator}();
var JobUtils=function(){function JobUtils(){}JobUtils.filterStatusMap={"All":"","Active":"STARTED,RUNNING,FAILED","Running":"STARTED","Waiting":"STARTING","Completed":"COMPLETED","Failed":"FAILED","Stopped":"STOPPED","Abandoned":"ABANDONED"};JobUtils.statusFilterMap=function(){var map={};$.each(JobUtils.filterStatusMap,function(filter,status){var arr=status.split(",");if(arr.length==1)map[status]=filter});return map};return JobUtils}();
(function($){$.urlParam=function(name){var results=(new RegExp("[?\x26]"+name+"\x3d([^\x26#]*)")).exec(window.location.href);if(results==null)return null;else return results[1]||0}})(jQuery);
(function(){var directive=function($http,$mdDialog,$window,AboutKyloService){return{restrict:"E",scope:{selectedOption:"\x26?",openedMenu:"\x26?",menuIcon:"@?"},templateUrl:"js/shared/kylo-options/kylo-options.html",link:function($scope){if(!angular.isDefined($scope.menuIcon))$scope.menuIcon="more_vert";$scope.username="User";$http.get("/proxy/v1/about/me").then(function(response){$scope.username=response.data.systemName});$scope.openMenu=function($mdOpenMenu,ev){if($scope.openedMenu)$scope.openedMenu();
$mdOpenMenu(ev)};$scope.aboutKylo=function(){AboutKyloService.showAboutDialog();if($scope.selectedOption)$scope.selectedOption()("aboutKylo")};$scope.logout=function(){$window.location.href="/logout"}}}};angular.module(COMMON_APP_MODULE_NAME).directive("kyloOptions",["$http","$mdDialog","$window","AboutKyloService",directive])})();
(function(){angular.module(COMMON_APP_MODULE_NAME).directive("mdDatepickerContainer",function(){return{scope:{label:"@"},link:function($scope,$element,attrs,ctrl){$element.prepend("\x3clabel\x3e"+$scope.label+"\x3c/label\x3e")}}})})();
(function(){angular.module("ngTextTruncate",[]).directive("ngTextTruncate",["$compile","ValidationServices","CharBasedTruncation","WordBasedTruncation",function($compile,ValidationServices,CharBasedTruncation,WordBasedTruncation){return{restrict:"A",scope:{text:"\x3dngTextTruncate",charsThreshould:"@ngTtCharsThreshold",wordsThreshould:"@ngTtWordsThreshold",customMoreLabel:"@ngTtMoreLabel",customLessLabel:"@ngTtLessLabel"},controller:function($scope,$element,$attrs){$scope.toggleShow=function(){$scope.open=
!$scope.open};$scope.useToggling=$attrs.ngTtNoToggling===undefined},link:function($scope,$element,$attrs){$scope.open=false;ValidationServices.failIfWrongThreshouldConfig($scope.charsThreshould,$scope.wordsThreshould);var CHARS_THRESHOLD=parseInt($scope.charsThreshould);var WORDS_THRESHOLD=parseInt($scope.wordsThreshould);$scope.$watch("text",function(){$element.empty();if(CHARS_THRESHOLD)if($scope.text&&CharBasedTruncation.truncationApplies($scope,CHARS_THRESHOLD))CharBasedTruncation.applyTruncation(CHARS_THRESHOLD,
$scope,$element);else $element.append($scope.text);else if($scope.text&&WordBasedTruncation.truncationApplies($scope,WORDS_THRESHOLD))WordBasedTruncation.applyTruncation(WORDS_THRESHOLD,$scope,$element);else $element.append($scope.text)})}}}]).factory("ValidationServices",function(){return{failIfWrongThreshouldConfig:function(firstThreshould,secondThreshould){if(!firstThreshould&&!secondThreshould||firstThreshould&&secondThreshould)throw"You must specify one, and only one, type of threshould (chars or words)";
}}}).factory("CharBasedTruncation",["$compile",function($compile){return{truncationApplies:function($scope,threshould){return $scope.text.length>threshould},applyTruncation:function(threshould,$scope,$element){if($scope.useToggling){var el=angular.element("\x3cspan\x3e"+$scope.text.substr(0,threshould)+"\x3cspan ng-show\x3d'!open'\x3e...\x3c/span\x3e"+"\x3cspan class\x3d'btn-link ngTruncateToggleText' "+"ng-click\x3d'toggleShow()'"+"ng-show\x3d'!open'\x3e"+" "+($scope.customMoreLabel?$scope.customMoreLabel:
"More")+"\x3c/span\x3e"+"\x3cspan ng-show\x3d'open'\x3e"+$scope.text.substring(threshould)+"\x3cspan class\x3d'btn-link ngTruncateToggleText'"+"ng-click\x3d'toggleShow()'\x3e"+" "+($scope.customLessLabel?$scope.customLessLabel:"Less")+"\x3c/span\x3e"+"\x3c/span\x3e"+"\x3c/span\x3e");$compile(el)($scope);$element.append(el)}else $element.append($scope.text.substr(0,threshould)+"...")}}}]).factory("WordBasedTruncation",["$compile",function($compile){return{truncationApplies:function($scope,threshould){return $scope.text.split(" ").length>
threshould},applyTruncation:function(threshould,$scope,$element){var splitText=$scope.text.split(" ");if($scope.useToggling){var el=angular.element("\x3cspan\x3e"+splitText.slice(0,threshould).join(" ")+" "+"\x3cspan ng-show\x3d'!open'\x3e...\x3c/span\x3e"+"\x3cspan class\x3d'btn-link ngTruncateToggleText' "+"ng-click\x3d'toggleShow()'"+"ng-show\x3d'!open'\x3e"+" "+($scope.customMoreLabel?$scope.customMoreLabel:"More")+"\x3c/span\x3e"+"\x3cspan ng-show\x3d'open'\x3e"+splitText.slice(threshould,splitText.length).join(" ")+
"\x3cspan class\x3d'btn-link ngTruncateToggleText'"+"ng-click\x3d'toggleShow()'\x3e"+" "+($scope.customLessLabel?$scope.customLessLabel:"Less")+"\x3c/span\x3e"+"\x3c/span\x3e"+"\x3c/span\x3e");$compile(el)($scope);$element.append(el)}else $element.append(splitText.slice(0,threshould).join(" ")+"...")}}}])})();
angular.module(COMMON_APP_MODULE_NAME).service("NotificationService",function($timeout,$mdToast){var self=this;this.alerts={};this.CONNECTION_ERRORS_ALERT_THRESHOLD=5;this.connectionErrors=0;this.lastConnectionError=0;this.addAlert=function(errorType,message,detailMsg,type,timeout,groupKey){var id=IDGenerator.generateId("alert");var alert={type:type,msg:message,id:id,detailMsg:detailMsg,errorType:errorType,hasDetail:false};if(detailMsg!=undefined&&detailMsg!="")alert.hasDetail=true;this.alerts[id]=
alert;if(groupKey)alert.groupKey=groupKey;self.toastAlert(alert,timeout);return alert};this.toastAlert=function(alert,timeout){var options={hideDelay:false,msg:alert.msg};if(timeout)options.hideDelay=timeout;if(alert.hasDetail)options.msg+=" "+alert.detailMsg;var alertId=alert.id;var toast=$mdToast.simple().textContent(options.msg).action("Ok").highlightAction(true).hideDelay(options.hideDelay);$mdToast.show(toast).then(function(response){if(response=="ok"){$mdToast.hide();self.removeAlert(alertId)}});
if(timeout)$timeout(function(){self.removeAlert(id)},timeout)};this.getAlertWithGroupKey=function(groupKey){var returnedAlert=null;angular.forEach(this.alerts,function(alert,id){if(returnedAlert==null&&alert.groupKey&&alert.groupKey==groupKey)returnedAlert=alert});return returnedAlert};this.success=function(message,timeout){return this.addAlert("Success",message,undefined,"success",timeout)};this.error=function(message,timeout){return this.addAlert("Error",message,undefined,"danger",timeout)};this.errorWithErrorType=
function(errorType,message,timeout){return this.addAlert(errorType,message,undefined,"danger",timeout)};this.errorWithDetail=function(errorType,message,detailMsg,timeout){return this.addAlert(errorType,message,undefined,"danger",detailMsg,timeout)};this.errorWithGroupKey=function(errorType,message,groupKey,detailMsg){if(groupKey!=undefined){if(this.getAlertWithGroupKey(groupKey)==null){var alert=false;if(groupKey=="Connection Error"){self.connectionErrors++;if((new Date).getTime()-self.lastConnectionError>
6E4)self.connectionErrors=0;self.lastConnectionError=(new Date).getTime();if(self.connectionErrors>self.CONNECTION_ERRORS_ALERT_THRESHOLD){self.connectionErrors=0;alert=true}}else alert=true;if(alert)return this.addAlert(errorType,message,detailMsg,"danger",undefined,groupKey);else return{}}}else this.error(message,undefined)};this.removeAlert=function(id){delete this.alerts[id]};this.getAlerts=function(){return this.alerts}});
(function(){var directive=function($mdDialog,PaginationDataService){return{restrict:"E",scope:{sortOptions:"\x3d",selectedOption:"\x26",openedMenu:"\x26",menuIcon:"@",menuKey:"@",tabs:"\x3d",rowsPerPageOptions:"\x3d",showViewType:"\x3d",showPagination:"\x3d",additionalOptions:"\x3d?",selectedAdditionalOption:"\x26?"},templateUrl:"js/shared/options-menu/options-menu-template.html",link:function($scope,element,attrs){if($scope.showViewType)$scope.viewType={label:"List View",icon:"list",value:"list",
type:"viewType"};$scope.getPaginationId=function(tab){return PaginationDataService.paginationId($scope.menuKey,tab.title)};$scope.getCurrentPage=function(tab){return PaginationDataService.currentPage($scope.menuKey,tab.title)};function setViewTypeOption(toggle){$scope.viewType.value=PaginationDataService.viewType($scope.menuKey);if(toggle==true)$scope.viewType.value=$scope.viewType.value=="list"?"table":"list";if($scope.viewType.value=="list"){$scope.viewType.label="List View";$scope.viewType.icon=
"list"}else{$scope.viewType.label="Table View";$scope.viewType.icon="grid_on"}}if($scope.showViewType)setViewTypeOption(true);$scope.rowsPerPage=5;$scope.paginationData=PaginationDataService.paginationData($scope.menuKey);var originatorEv;$scope.openMenu=function($mdOpenMenu,ev){originatorEv=ev;if($scope.openedMenu)$scope.openedMenu()({sortOptions:$scope.sortOptions,additionalOptions:$scope.additionalOptions});if($scope.showPagination){var tabData=PaginationDataService.getActiveTabData($scope.menuKey);
$scope.currentPage=tabData.currentPage;$scope.paginationId=tabData.paginationId}$mdOpenMenu(ev)};$scope.selectAdditionalOption=function(item){var itemCopy={};angular.extend(itemCopy,item);if($scope.selectedAdditionalOption)$scope.selectedAdditionalOption()(itemCopy)};$scope.selectOption=function(item){var itemCopy={};angular.extend(itemCopy,item);if(item.type=="viewType"){PaginationDataService.toggleViewType($scope.menuKey);setViewTypeOption(true)}if($scope.selectedOption)$scope.selectedOption()(itemCopy);
originatorEv=null};$scope.$on("$destroy",function(){})}}};angular.module(COMMON_APP_MODULE_NAME).directive("tbaOptionsMenu",["$mdDialog","PaginationDataService",directive])})();
angular.module(COMMON_APP_MODULE_NAME).service("PaginationDataService",function(){var self=this;this.data={};this.paginationData=function(pageName,tabName){if(self.data[pageName]===undefined)self.data[pageName]={rowsPerPage:"5",tabs:{},filter:"",sort:"",sortDesc:false,viewType:"list",activeTab:tabName};if(tabName==undefined)tabName=pageName;if(tabName&&self.data[pageName].tabs[tabName]==undefined)self.data[pageName].tabs[tabName]={paginationId:pageName+"_"+tabName,pageInfo:{}};if(tabName&&self.data[pageName].tabs[tabName].currentPage===
undefined)self.data[pageName].tabs[tabName].currentPage=1;return self.data[pageName]};this.setRowsPerPageOptions=function(pageName,rowsPerPageOptions){self.paginationData(pageName).rowsPerPageOptions=rowsPerPageOptions};this.viewType=function(pageName,viewType){if(viewType!=undefined)self.paginationData(pageName).viewType=viewType;return self.paginationData(pageName).viewType};this.toggleViewType=function(pageName){var viewType=self.paginationData(pageName).viewType;if(viewType=="list")viewType="table";
else viewType="list";self.viewType(pageName,viewType)};this.activateTab=function(pageName,tabName){var pageData=self.paginationData(pageName,tabName);angular.forEach(pageData.tabs,function(tabData,name){tabData.active=false;if(name==tabName){tabData.active=true;pageData.activeTab=name}})};this.getActiveTabData=function(pageName){var activeTabData={};var pageData=self.paginationData(pageName);angular.forEach(pageData.tabs,function(tabData,name){if(tabData.active){activeTabData=tabData;return false}});
return activeTabData};this.filter=function(pageName,value){if(value!=undefined)self.paginationData(pageName).filter=value;return self.paginationData(pageName).filter};this.rowsPerPage=function(pageName,value){if(value!=undefined)self.paginationData(pageName).rowsPerPage=value;return self.paginationData(pageName).rowsPerPage};this.sort=function(pageName,value){if(value){self.paginationData(pageName).sort=value;if(value.indexOf("-")==0)self.paginationData(pageName).sortDesc=true;else self.paginationData(pageName).sortDesc=
false}return self.paginationData(pageName).sort};this.isSortDescending=function(pageName){return self.paginationData(pageName).sortDesc};this.paginationId=function(pageName,tabName){if(tabName==undefined)tabName=pageName;return self.paginationData(pageName,tabName).tabs[tabName].paginationId};this.currentPage=function(pageName,tabName,value){if(tabName==undefined||tabName==null)tabName=pageName;if(value)self.paginationData(pageName,tabName).tabs[tabName].currentPage=value;return self.paginationData(pageName,
tabName).tabs[tabName].currentPage}});
var PivotTableUtil=function(){function PivotTableUtil(){}PivotTableUtil.camelCaseToWords=function(str){return str.match(/^[a-z]+|[A-Z][a-z]*/g).map(function(x){return x[0].toUpperCase()+x.substr(1).toLowerCase()}).join(" ")};PivotTableUtil.transformToPivotTable=function(tableData,hideColumns,pivotNameMap,addedColumns){var pivotRows=[];$.each(tableData,function(i,row){var pivotRow={};$.each(row,function(k,val){if($.inArray(k,hideColumns)==-1){var pivotItem=pivotNameMap[k];var pivotName;var pivotValue;
if(pivotItem!==undefined){pivotName=pivotItem.name;pivotValue=val;if(pivotItem.fn)pivotValue=pivotItem.fn(val)}else pivotValue=val;if(pivotName==undefined)pivotName=PivotTableUtil.camelCaseToWords(k);pivotRow[pivotName]=pivotValue}if(addedColumns&&!$.isEmptyObject(addedColumns))$.each(addedColumns,function(key,fn){pivotRow[key]=fn(row)})});pivotRows.push(pivotRow)});return pivotRows};return PivotTableUtil}();
var SortUtils=function(){function SortUtils(){}SortUtils.sort=function(arr,attr,desc){var retObj=arr.sort(function(a,b){if(typeof a[attr]==="number")return parseInt(a[attr])>parseInt(b[attr])?1:-1;else return a[attr]>b[attr]?1:-1});if(desc)return retObj.reverse();else return retObj};return SortUtils}();
(function(){var directive=function($window,$compile,BroadcastService){return{link:function($scope,element,attrs){element.addClass("sticky");element.prepend('\x3cdiv class\x3d"sticky-anchor"\x3e\x3c/div\x3e');var tabsWrapper=element.find("md-tabs-wrapper");tabsWrapper.css("z-index",49);var header=angular.element(".page-header");header.css("z-index",60);var side=angular.element("md-sidenav");side.css("z-index",61);tabsWrapper.css("position","fixed");var width=angular.element("#content").width();if(width==
0)width=angular.element($window).width()-side.width();tabsWrapper.css("width",width+"px");var tabsContentWrapper=element.find("md-tabs-content-wrapper");tabsContentWrapper.css("margin-top","80px");var headerHeight=header.height();angular.element($window).on("resize.stickytab",function(){resize()});BroadcastService.subscribe($scope,BroadcastConstants.CONTENT_WINDOW_RESIZED,onContentWindowResized);function onContentWindowResized(){resize()}function resize(){var width=angular.element("#content").width();
tabsWrapper.css("width",width+"px")}$scope.$on("$destroy",function(){angular.element($window).off("resize.stickytab")})}}};angular.module(COMMON_APP_MODULE_NAME).directive("stickyTabs",directive)})();
angular.module(COMMON_APP_MODULE_NAME).service("TableOptionsService",["PaginationDataService",function(PaginationDataService){this.sortOptions={};var self=this;this.newSortOptions=function(key,labelValueMap,defaultValue,defaultDirection){var sortOptions=Object.keys(labelValueMap).map(function(mapKey){var value=labelValueMap[mapKey];var sortOption={label:mapKey,value:value,direction:"",reverse:false,type:"sort"};if(defaultValue&&value==defaultValue){sortOption["default"]=defaultDirection||"asc";sortOption["direction"]=
defaultDirection||"asc";sortOption["reverse"]=sortOption["direction"]=="asc"?false:true;sortOption["icon"]=sortOption["direction"]=="asc"?"keyboard_arrow_up":"keyboard_arrow_down"}return sortOption});self.sortOptions[key]=sortOptions;return sortOptions};this.newOption=function(label,type,isHeader,disabled,icon){if(isHeader==undefined)isHeader=false;if(disabled==undefined)disabled=false;return{label:label,type:type,header:isHeader,icon:icon,disabled:disabled}};function clearOtherSorts(key,option){var sortOptions=
self.sortOptions[key];if(sortOptions)angular.forEach(sortOptions,function(sortOption,i){if(sortOption!==option){sortOption.direction="";sortOption.icon=""}})}function getDefaultSortOption(key){var sortOptions=self.sortOptions[key];var defaultSortOption=null;if(sortOptions)defaultSortOption=_.find(sortOptions,function(opt){return opt.default});return defaultSortOption}this.initializeSortOption=function(key){var currentOption=PaginationDataService.sort(key);if(currentOption)self.setSortOption(key,currentOption);
else self.saveSortOption(key,getDefaultSortOption(key))};this.saveSortOption=function(key,sortOption){if(sortOption){var val=sortOption.value;if(sortOption.reverse)val="-"+val;PaginationDataService.sort(key,val)}};this.toggleSort=function(key,option){clearOtherSorts(key,option);var returnedSortOption=option;if(option.direction==undefined||option.direction==""||option.direction=="desc"){option.direction="asc";option.icon="keyboard_arrow_up";option.reverse=false}else if(option.direction=="asc"){option.direction=
"desc";option.icon="keyboard_arrow_down";option.reverse=true}return returnedSortOption};this.toSortString=function(option){if(option.direction=="desc")return"-"+option.value;else return option.value};this.setSortOption=function(key,val){var dir="asc";var icon="keyboard_arrow_up";var sortColumn=val;if(val.indexOf("-")==0){dir="desc";icon="keyboard_arrow_down";sortColumn=val.substring(1)}var sortOptions=self.sortOptions[key];angular.forEach(sortOptions,function(sortOption,i){if(sortOption.value==sortColumn){sortOption.direction=
dir;sortOption.icon=icon;sortOption.reverse=dir=="desc"?true:false}else{sortOption.direction="";sortOption.icon="";sortOption.reverse=false}})};this.getCurrentSort=function(key){var sortOptions=self.sortOptions[key];var returnedSortOption=null;if(sortOptions){angular.forEach(sortOptions,function(sortOption,i){if(sortOption.direction&&sortOption.direction!=""){returnedSortOption=sortOption;return false}});if(returnedSortOption==null)returnedSortOption=getDefaultSortOption(key)}return returnedSortOption}}]);
angular.module("datalakeui.common").run(["$templateCache",function($templateCache){$templateCache.put("js/shared/about-kylo/about.html",'\x3cmd-dialog aria-label\x3d"About Kylo" flex\x3d"35"\x3e\x3cmd-dialog-content\x3e\x3cp style\x3d"text-align:center"\x3e\x3cimg src\x3d"/ui-common/img/kylo-logo-orange.png" style\x3d"width:300px"\x3e\x3c/p\x3e\x3cp style\x3d"text-align:center"\x3e\x3cb\x3eVersion:\x3c/b\x3e {{version}}\x3c/p\x3e\x3ctable cellpadding\x3d"10"\x3e\x3ctr\x3e\x3ctd\x3e\x3cp style\x3d"text-align:justify; padding:10px"\x3eThe Kylo framework simplifies building, configuring, deploying and monitoring data pipelines. It enables data profiling, data discovery and data science. Businesses can quickly start leveraging value from their enterprise data lakes.\x3cbr\x3e\x3cbr\x3eFor enterprise support options, please visit \x3ca href\x3d"https://www.thinkbiganalytics.com/kylo/" target\x3d"_blank"\x3eThink Big\x3c/a\x3e.\x3cbr\x3e\x3cbr\x3e\x3ctextarea class\x3d"scrollabletextbox" name\x3d"apache-licence" readonly\x3d"true" rows\x3d"7" cols\x3d"55" style\x3d"text-align:justify; color: black; background-color: #F6DDCC; padding:10px"\x3e\nCopyright 2017 Teradata Corporation\n\nLicensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at\n\n  http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.\n          \x3c/textarea\x3e\x3c/p\x3e\x3c/td\x3e\x3c/tr\x3e\x3c/table\x3e\x3c/md-dialog-content\x3e\x3cmd-dialog-actions\x3e\x3cmd-button ng-click\x3d"cancel();" class\x3d"md-primary"\x3eClose\x3c/md-button\x3e\x3c/md-dialog-actions\x3e\x3c/md-dialog\x3e');
$templateCache.put("js/shared/card-filter-header/card-filter-header-template.html",'\x3cdiv style\x3d"white-space: nowrap;margin-top:10px" class\x3d"card-title"\x3e{{::$cardFilterHeader.cardTitle}}\x3c/div\x3e\x3cspan flex\x3d"5"\x3e\x3c/span\x3e\x3cmd-input-container flex style\x3d"margin-top:0px;margin-bottom:0px"\x3e\x3clabel\x3eFilter\x3c/label\x3e\x3cinput ng-model\x3d"$cardFilterHeader.filterModel" ng-model-options\x3d"$cardFilterHeader.filterModelOptions"\x3e\x3c/md-input-container\x3e\x3cdiv layout\x3d"row" layout-align\x3d"space-between center"\x3e\x3cmd-button aria-label\x3d"Filter Help" class\x3d"md-icon-button filter-help-button" ng-click\x3d"$cardFilterHeader.showFilterHelpPanel($event)" ng-if\x3d"$cardFilterHeader.renderHelp"\x3e\x3cng-md-icon md-icon icon\x3d"help" size\x3d"15" style\x3d"fill:grey"\x3e\x3c/ng-md-icon\x3e\x3c/md-button\x3e\x3ctba-view-type-selection view-type\x3d"$cardFilterHeader.viewType" style\x3d"margin-left:10px"\x3e\x3c/tba-view-type-selection\x3e\x3ctba-options-menu sort-options\x3d"$cardFilterHeader.sortOptions" show-pagination\x3d"false" menu-key\x3d"{{$cardFilterHeader.pageName}}" selected-option\x3d"$cardFilterHeader.selectedOption" opened-menu\x3d"$cardFilterHeader.menuOpen" additional-options\x3d"$cardFilterHeader.additionalOptions" selected-additional-option\x3d"$cardFilterHeader.selectedAdditionalOption" show-view-type\x3d"false" menu-icon\x3d"more_vert"\x3e\x3c/tba-options-menu\x3e\x3c/div\x3e');
$templateCache.put("js/shared/card-layout/card-layout-template.html",'\x3csection class\x3d"md-whiteframe-z1 {{::cardCss}}"\x3e\x3cdiv ng-transclude\x3d"header1" class\x3d"card-toolbar {{::headerCss}}"\x3e\x3c/div\x3e\x3cmd-content ng-transclude\x3d"body1" class\x3d"card-layout-body {{::bodyCss}}"\x3e\x3c/md-content\x3e\x3c/section\x3e');$templateCache.put("js/shared/kylo-options/kylo-options.html",'\x3cmd-menu\x3e\x3cmd-button aria-label\x3d"Options" class\x3d"md-icon-button" style\x3d"margin-top:-10px" ng-click\x3d"openMenu($mdOpenMenu, $event)"\x3e\x3cng-md-icon icon\x3d"{{menuIcon}}"\x3e\x3c/ng-md-icon\x3e\x3c/md-button\x3e\x3cmd-menu-content width\x3d"3"\x3e\x3cmd-menu-item\x3e\x3cheader\x3e\x3cmd-icon style\x3d"margin-right: 16px"\x3eaccount_circle\x3c/md-icon\x3e{{username}}\x3c/header\x3e\x3c/md-menu-item\x3e\x3cmd-menu-item\x3e\x3cmd-button ng-click\x3d"logout()"\x3eLogout\x3c/md-button\x3e\x3c/md-menu-item\x3e\x3cmd-menu-divider\x3e\x3c/md-menu-divider\x3e\x3cmd-menu-item layout\x3d"column"\x3e\x3cmd-button ng-click\x3d"aboutKylo()" md-prevent-menu-close\x3d"md-prevent-menu-close"\x3e\x3cspan style\x3d"float:left"\x3eAbout Kylo\x3c/span\x3e\x3c/md-button\x3e\x3c/md-menu-item\x3e\x3c/md-menu-content\x3e\x3c/md-menu\x3e');
$templateCache.put("js/shared/options-menu/options-menu-template.html",'\x3cmd-menu\x3e\x3cmd-button aria-label\x3d"Options" class\x3d"md-icon-button" style\x3d"margin-top:-10px" ng-click\x3d"openMenu($mdOpenMenu, $event)"\x3e\x3cng-md-icon icon\x3d"{{menuIcon}}"\x3e\x3c/ng-md-icon\x3e\x3c/md-button\x3e\x3cmd-menu-content width\x3d"3"\x3e\x3cmd-menu-item ng-if\x3d"showPagination"\x3e\x3cmd-input-container\x3e\x3clabel\x3eRows per page\x3c/label\x3e\x3cmd-select class\x3d"" ng-model\x3d"paginationData.rowsPerPage"\x3e\x3cmd-option ng-repeat\x3d"x in paginationData.rowsPerPageOptions" value\x3d"{{x}}"\x3e{{x}}\x3c/md-option\x3e\x3c/md-select\x3e\x3c/md-input-container\x3e\x3c/md-menu-item\x3e\x3cmd-menu-item class\x3d"md-menu-item-header" ng-if\x3d"showViewType \x3d\x3d true"\x3e\x3cspan md-menu-align-target class\x3d"md-subheader md-menu-item-header"\x3eView Options\x3c/span\x3e\x3c/md-menu-item\x3e\x3cmd-menu-item layout\x3d"column" ng-if\x3d"showViewType \x3d\x3d true"\x3e\x3cmd-button ng-click\x3d"selectOption(viewType)" md-prevent-menu-close\x3d"md-prevent-menu-close"\x3e\x3cspan style\x3d"float:left"\x3e{{viewType.label}}\x3c/span\x3e \x3cspan style\x3d"float:right"\x3e\x3cng-md-icon icon\x3d"{{viewType.icon}}"\x3e\x3c/ng-md-icon\x3e\x3c/span\x3e\x3c/md-button\x3e\x3c/md-menu-item\x3e\x3cmd-menu-item class\x3d"md-menu-item-header"\x3e\x3cspan md-menu-align-target class\x3d"md-subheader md-menu-item-header"\x3eSort Options\x3c/span\x3e\x3c/md-menu-item\x3e\x3cmd-menu-item ng-repeat\x3d"item in sortOptions" layout\x3d"column"\x3e\x3cmd-button ng-click\x3d"selectOption(item)" md-prevent-menu-close\x3d"md-prevent-menu-close"\x3e\x3cspan style\x3d"float:left"\x3e{{item.label}}\x3c/span\x3e \x3cspan ng-if\x3d"item.icon \x26\x26 item.icon !\x3d \'\'" style\x3d"float:right"\x3e\x3cng-md-icon icon\x3d"{{item.icon}}"\x3e\x3c/ng-md-icon\x3e\x3c/span\x3e\x3c/md-button\x3e\x3c/md-menu-item\x3e\x3cmd-menu-divider ng-if\x3d"additionalOptions \x26\x26 additionalOptions.length \x3e0"\x3e\x3c/md-menu-divider\x3e\x3cmd-menu-item ng-if\x3d"additionalOptions \x26\x26 additionalOptions.length \x3e0" ng-repeat\x3d"item in additionalOptions" ng-class\x3d"{\'md-menu-item-header\': item.header}"\x3e\x3cspan md-menu-align-target class\x3d"md-subheader md-menu-item-header" ng-if\x3d"item.header"\x3e{{item.label}}\x3c/span\x3e\x3cmd-button ng-click\x3d"selectAdditionalOption(item)" md-prevent-menu-close\x3d"md-prevent-menu-close" ng-if\x3d"!item.header" ng-disabled\x3d"item.disabled"\x3e\x3cspan style\x3d"float:left"\x3e{{item.label}}\x3c/span\x3e \x3cspan ng-if\x3d"item.icon \x26\x26 item.icon !\x3d \'\'" style\x3d"float:right"\x3e\x3cng-md-icon icon\x3d"{{item.icon}}"\x3e\x3c/ng-md-icon\x3e\x3c/span\x3e\x3c/md-button\x3e\x3c/md-menu-item\x3e\x3c/md-menu-content\x3e\x3c/md-menu\x3e');
$templateCache.put("js/shared/ui-router-breadcrumbs/uiBreadcrumbs.tpl.html",'\x3cdiv ng-if\x3d"lastBreadcrumbs.length \x3d\x3d 2" layout-align\x3d"center" style\x3d"white-space: nowrap"\x3e\x3cmd-button class\x3d"icon-btn" ng-click\x3d"navigate( lastBreadcrumbs[0])"\x3e\x3cng-md-icon md-icon icon\x3d"keyboard_arrow_left"\x3e\x3c/ng-md-icon\x3e\x3c/md-button\x3e\x3cspan\x3e{{ lastBreadcrumbs[0].displayName }}\x3c/span\x3e\x3c/div\x3e\x3cdiv ng-if\x3d"lastBreadcrumbs.length \x3d\x3d 1" style\x3d"white-space: nowrap"\x3e{{ lastBreadcrumbs[0].displayName }}\x3c/div\x3e');
$templateCache.put("js/shared/vertical-section-layout/vertical-section-layout-template.html",'\x3cdiv layout\x3d"column" class\x3d"layout-padding-left" style\x3d"padding-top:10px"\x3e\x3cdiv\x3e\x3cdiv layout\x3d"row" layout-align\x3d"start stretch"\x3e\x3cng-md-icon icon\x3d"check" style\x3d"fill:#009933;margin-left: -9px" ng-if\x3d"showVerticalCheck \x3d\x3d true"\x3e\x3c/ng-md-icon\x3e\x3cspan class\x3d"md-subhead layout-padding-left"\x3e{{sectionTitle}}\x3c/span\x3e \x3cspan flex\x3e\x3c/span\x3e\x3cmd-button class\x3d"icon-btn md-icon-button md-primary" ng-click\x3d"edit($event)" ng-if\x3d"allowEdit \x3d\x3dtrue \x26\x26 !editable"\x3e\x3cng-md-icon icon\x3d"edit"\x3e\x3c/ng-md-icon\x3e\x3c/md-button\x3e\x3cmd-button class\x3d"icon-btn md-icon-button" ng-click\x3d"cancel($event)" ng-if\x3d"allowEdit \x3d\x3dtrue \x26\x26 editable"\x3e\x3cng-md-icon icon\x3d"cancel" style\x3d"fill:grey"\x3e\x3c/ng-md-icon\x3e\x3c/md-button\x3e\x3c/div\x3e\x3cdiv class\x3d"vertical-step-border"\x3e\x3cdiv ng-if\x3d"!editable" class\x3d"md-padding"\x3e\x3cdiv ng-transclude\x3d"readonly"\x3eREadonly SEction\x3c/div\x3e\x3c/div\x3e\x3cdiv ng-if\x3d"editable \x3d\x3d true" class\x3d"md-padding"\x3e\x3cform name\x3d"{{formName}}"\x3e\x3cdiv ng-transclude\x3d"editable"\x3eEditable SEction\x3c/div\x3e\x3cdiv layout\x3d"row" layout-align\x3d"end center"\x3e\x3cmd-button ng-click\x3d"delete($event)" ng-disabled\x3d"allowDelete \x3d\x3d false" ng-if\x3d"onDelete !\x3d\x3d undefined \x26\x26 isDeleteVisible \x3d\x3d true"\x3eDelete\x3c/md-button\x3e\x3cspan flex\x3e\x3c/span\x3e\x3cmd-button ng-click\x3d"cancel($event)"\x3eCancel\x3c/md-button\x3e\x3cmd-button class\x3d"md-primary md-raised" ng-click\x3d"save($event)" ng-disabled\x3d"isValid \x3d\x3d false || (theForm !\x3d undefined \x26\x26 theForm.$invalid !\x3d undefined \x26\x26 theForm.$invalid \x3d\x3d true)"\x3eSave\x3c/md-button\x3e\x3c/div\x3e\x3c/form\x3e\x3c/div\x3e\x3c/div\x3e\x3c/div\x3e\x3c/div\x3e');
$templateCache.put("js/shared/view-type-selection/view-type-selection-template.html",'\x3cspan class\x3d"md-button-group" layout-align\x3d"center center"\x3e\x3cmd-button class\x3d"icon-btn" ng-click\x3d"viewTypeChanged(\'table\')" ng-class\x3d"{\'selected\' : viewType \x3d\x3d \'table\'}"\x3e\x3cng-md-icon md-icon icon\x3d"list"\x3e\x3c/ng-md-icon\x3e\x3c/md-button\x3e\x3cmd-button class\x3d"icon-btn" ng-click\x3d"viewTypeChanged(\'list\')" ng-class\x3d"{\'selected\' : viewType \x3d\x3d \'list\'}"\x3e\x3cng-md-icon md-icon icon\x3d"view_list"\x3e\x3c/ng-md-icon\x3e\x3c/md-button\x3e\x3c/span\x3e');
$templateCache.put("js/vendor/dirPagination/dirPagination.md-tpl.html",'\x3cdiv layout\x3d"row"\x3e\x3cspan ng-if\x3d"boundaryLinks" ng-class\x3d"{ disabled : pagination.current \x3d\x3d 1 }"\x3e\x3ca href\x3d"" ng-click\x3d"setCurrent(1)"\x3e\x26laquo;\x3c/a\x3e \x3c/span\x3e\x3cspan ng-if\x3d"directionLinks" ng-class\x3d"{ disabled : pagination.current \x3d\x3d 1 }"\x3e\x3ca href\x3d"" ng-click\x3d"setCurrent(pagination.current - 1)"\x3e\x26lsaquo;\x3c/a\x3e \x3c/span\x3e\x3cspan ng-repeat\x3d"pageNumber in pages track by tracker(pageNumber, $index)" ng-class\x3d"{ active : pagination.current \x3d\x3d pageNumber, disabled : pageNumber \x3d\x3d \'...\' }"\x3e\x3ca href\x3d"" ng-click\x3d"setCurrent(pageNumber)"\x3e{{ pageNumber }}\x3c/a\x3e \x3c/span\x3e\x3cspan ng-if\x3d"directionLinks" ng-class\x3d"{ disabled : pagination.current \x3d\x3d pagination.last }"\x3e\x3ca href\x3d"" ng-click\x3d"setCurrent(pagination.current + 1)"\x3e\x26rsaquo;\x3c/a\x3e \x3c/span\x3e\x3cspan ng-if\x3d"boundaryLinks" ng-class\x3d"{ disabled : pagination.current \x3d\x3d pagination.last }"\x3e\x3ca href\x3d"" ng-click\x3d"setCurrent(pagination.last)"\x3e\x26raquo;\x3c/a\x3e\x3c/span\x3e\x3c/div\x3e');
$templateCache.put("js/vendor/dirPagination/dirPagination.tpl.html",'\x3cdiv\x3e\x3cspan class\x3d"label"\x3e{{label}}\x3c/span\x3e\x3cmd-select ng-model\x3d"rowsPerPage" md-container-class\x3d"md-pagination-select" placeholder\x3d"{{rowsPerPage ? rowsPerPageOptions[0] : 5}}"\x3e\x3cmd-option ng-repeat\x3d"x in rowsPerPageOptions" value\x3d"{{x}}"\x3e{{x}}\x3c/md-option\x3e\x3c/md-select\x3e\x3cspan\x3e{{range.lower}} - {{range.upper}} of {{range.total}}\x3c/span\x3e\x3c/div\x3e\x3cdiv\x3e\x3cmd-button ng-if\x3d"boundaryLinks" type\x3d"button" ng-click\x3d"setCurrent(1)" ng-disabled\x3d"pagination.current \x3d\x3d 1" aria-label\x3d"First"\x3e\x3cmd-icon md-svg-icon\x3d"templates.navigate-first.html"\x3e\x3c/md-icon\x3e\x3c/md-button\x3e\x3cmd-button type\x3d"button" ng-click\x3d"setCurrent(pagination.current - 1)" ng-disabled\x3d"pagination.current \x3d\x3d 1" aria-label\x3d"Previous"\x3e\x3cmd-icon md-svg-icon\x3d"templates.navigate-before.html"\x3e\x3c/md-icon\x3e\x3c/md-button\x3e\x3cmd-button type\x3d"button" ng-click\x3d"setCurrent(pagination.current + 1)" ng-disabled\x3d"pagination.current \x3d\x3d pagination.last" aria-label\x3d"Next"\x3e\x3cmd-icon md-svg-icon\x3d"templates.navigate-next.html"\x3e\x3c/md-icon\x3e\x3c/md-button\x3e\x3cmd-button ng-if\x3d"boundaryLinks" type\x3d"button" ng-click\x3d"setCurrent(pagination.last)" ng-disabled\x3d"pagination.current \x3d\x3d pagination.last" aria-label\x3d"Last"\x3e\x3cmd-icon md-svg-icon\x3d"templates.navigate-last.html"\x3e\x3c/md-icon\x3e\x3c/md-button\x3e\x3c/div\x3e')}]);
(function(){var moduleName=COMMON_APP_MODULE_NAME;var templateUrl="js/shared/ui-router/breadcrumbs/uiBreadcrumbs.tpl.html";var module;try{module=angular.module(moduleName)}catch(err){module=angular.module(moduleName,["ui.router"])}module.directive("uiRouterBreadcrumbs",["$interpolate","$state",function($interpolate,$state){return{restrict:"E",templateUrl:function(elem,attrs){return attrs.templateUrl||templateUrl},scope:{displaynameProperty:"@",abstractProxyProperty:"@?"},link:function($scope){$scope.breadcrumbs=
[];$scope.lastBreadcrumbs=[];$scope.$on("$stateChangeSuccess",function(event,toState,toParams,fromState,fromParams){if(toState.data.noBreadcrumb&&toState.data.noBreadcrumb==true);else updateBreadcrumbs(toState,toParams)});function updateLastBreadcrumbs(){$scope.lastBreadcrumbs=$scope.breadcrumbs.slice(Math.max($scope.breadcrumbs.length-2,0))}function getBreadcrumbKey(state){return state.name}function getDisplayName(state){return state.data.displayName||state.name}function isBreadcrumbRoot(state){return state.data.breadcrumbRoot&&
state.data.breadcrumbRoot==true}function addBreadcrumb(state,params){var breadcrumbKey=getBreadcrumbKey(state);var copyParams={};if(params)angular.extend(copyParams,params);var displayName=getDisplayName(state);$scope.breadcrumbs.push({key:breadcrumbKey,displayName:displayName,route:state.name,params:copyParams});updateLastBreadcrumbs()}$scope.navigate=function(crumb){$state.go(crumb.route,crumb.params)};function getBreadcrumbIndex(state){var breadcrumbKey=getBreadcrumbKey(state);var matchingState=
_.find($scope.breadcrumbs,function(breadcrumb){return breadcrumb.key==breadcrumbKey});if(matchingState)return _.indexOf($scope.breadcrumbs,matchingState);return-1}function updateBreadcrumbs(state,params){var index=getBreadcrumbIndex(state);if(isBreadcrumbRoot(state))index=0;if(index==-1)addBreadcrumb(state,params);else{$scope.breadcrumbs=$scope.breadcrumbs.slice(0,index);addBreadcrumb(state,params)}}function getDisplayName1(currentState){var interpolationContext;var propertyReference;var displayName;
if(!$scope.displaynameProperty)return currentState.name;propertyReference=getObjectValue($scope.displaynameProperty,currentState);if(propertyReference===false)return false;else if(typeof propertyReference==="undefined")return currentState.name;else{interpolationContext=typeof currentState.locals!=="undefined"?currentState.locals.globals:currentState;displayName=$interpolate(propertyReference)(interpolationContext);return displayName}}function getObjectValue(objectPath,context){var i;var propertyArray=
objectPath.split(".");var propertyReference=context;for(i=0;i<propertyArray.length;i++)if(angular.isDefined(propertyReference[propertyArray[i]]))propertyReference=propertyReference[propertyArray[i]];else return undefined;return propertyReference}}}}])})();
var UIGridUtil=function(){function UIGridUtil(){}function UIGridUtilTag(){}this.__tag=new UIGridUtilTag;UIGridUtil.newStatus=function(){return{loadingGrid:false,lastRefreshed:"",refreshComplete:function(){this.lastRefreshed=new Date;this.loadingGrid=false;this.isRefreshingGrid=false},loadGrid:function(){this.refresh()},refresh:function(){this.loadingGrid=true;this.isRefreshingGrid=true}}};UIGridUtil.isRefreshing=function(gridStatus){if(gridStatus.isRefreshingGrid!=undefined)return gridStatus.isRefreshingGrid;
return false};UIGridUtil.gridRefreshStart=function(gridStatus){if(!UIGridUtil.isRefreshing(gridStatus)){gridStatus.isRefreshingGrid=true;return true}return false};UIGridUtil.gridRefreshStopped=function(gridStatus){gridStatus.isRefreshingGrid=false;gridStatus.loadingGrid=false};UIGridUtil.gridRefreshComplete=function(gridStatus){gridStatus.isRefreshingGrid=false;gridStatus.lastRefreshed=new Date;gridStatus.loadingGrid=false};return UIGridUtil}();
angular.module(COMMON_APP_MODULE_NAME).factory("Utils",function($timeout){var waitForDomRetryCounts={};var data={stickTabHeader:function($element){var self=this;var tabsWrapper=element.find("md-tabs-wrapper");self.stickTabHeader($element,tabsWrapper)},stickTabHeader:function($element,$tabsWrapper){var header=angular.element(".page-header");var headerHeight=header.height();var window_top=0;var div_top=$element.find(".sticky-anchor").offset().top;if(div_top<headerHeight)if(div_top<0)$tabsWrapper.css("top",
Math.abs(div_top)+headerHeight+"px");else $tabsWrapper.css("top",Math.abs(headerHeight-Math.abs(div_top))+"px");else $tabsWrapper.css("top","0px")},maskProfanity:function(str){return str},waitForDomElementReady:function(selector,callbackFn){if(waitForDomRetryCounts[selector]==undefined)waitForDomRetryCounts[selector]=0;var $ele=angular.element(selector);if($ele.length>0){delete waitForDomRetryCounts[selector];callbackFn()}else{waitForDomRetryCounts[selector]+=1;if(waitForDomRetryCounts[selector]<=
50)$timeout(data.waitForDomElementReady,5,false,selector,callbackFn)}},strEndsWith:function(str,suffix){return str.indexOf(suffix,str.length-suffix.length)!==-1},endsWith:function(str,suffix){return this.strEndsWith(str,suffix)},startsWith:function(str,prefix){return str.indexOf(prefix)===0},camelCaseToWords:function(str){return str.match(/^[a-z]+|[A-Z][a-z]*/g).map(function(x){return x[0].toUpperCase()+x.substr(1).toLowerCase()}).join(" ")},capitalizeFirstLetter:function(string){if(string&&string!=
"")return string.charAt(0).toUpperCase()+string.slice(1).toLowerCase();return""},convertDate:function(date){if(date==null)return"--";var local=new Date(date);local.setMinutes(local.getMinutes()-local.getTimezoneOffset());return local.toISOString().slice(0,10)+" "+local.toISOString().slice(11,19)},dateDifference:function(startDate,endDate){if(startDate==null||endDate==null)return"N/A";else{var msec=endDate-startDate;return this.formatTimeMinSec(msec)}},dateDifferenceMs:function(startDate,endDate){var diff=
endDate-startDate;return diff},formatTimeMinSec:function(timeInMSec){if(timeInMSec==null)return"N/A";else{if(timeInMSec<0)return"0 sec";var sec_num=timeInMSec/1E3;sec_num=parseInt(sec_num,10);var hours=Math.floor(sec_num/3600);var minutes=Math.floor((sec_num-hours*3600)/60);var seconds=sec_num-hours*3600-minutes*60;var str=seconds+" sec";if(hours==0){if(minutes!=0)str=minutes+" min "+str}else str=hours+" hrs "+minutes+" min "+str;return str}},TimeDiffString:function(timeInMs){var diffString=moment.duration(timeInMs).format("HH:mm:ss");
if(diffString=="00")diffString="0";var parts=diffString.split(":");var suffixes=["hr","min","sec"];var len=parts.length;var suffixIndex=Math.abs(len-3);var startIndex=parts.length;var timeString="";for(var i=0;i<parts.length;i++){if(i>0)timeString+=" ";timeString+=parts[i]+" "+suffixes[suffixIndex];suffixIndex++}return timeString},DateDiffString:function(date1,date2){var diff=date2.getTime()-date2.getTime();return this.TimeDiffString(diff)},getParameterByName:function(name){var match=RegExp("[?\x26]"+
name+"\x3d([^\x26]*)").exec(window.location.search);return match&&decodeURIComponent(match[1].replace(/\+/g," "))},toBoolean:function(str){if(typeof str=="boolean")return str;else if(typeof str=="string")return str.toLowerCase()=="true";else if(typeof str=="number")return str==1;return false},resolveStatusClass:function(status,exitCode){var statusClass="status-info";switch(status){case "STARTED":case "RUNNING":case "COMPLETED":if(exitCode&&exitCode=="FAILED")statusClass="status-errors";else statusClass=
"status-healthy";break;case "FAILED":statusClass="status-errors";break;default:}return statusClass}};return data});
angular.module(COMMON_APP_MODULE_NAME).directive("verticalSectionLayout",function(){return{restrict:"E",scope:{showVerticalCheck:"\x3d?",allowEdit:"\x3d?",sectionTitle:"@",formName:"@",onDelete:"\x26?",isDeleteVisible:"\x3d?",allowDelete:"\x3d?",onEdit:"\x26",onSaveEdit:"\x26",onCancelEdit:"\x26",editable:"\x3d?",keepEditableAfterSave:"\x3d?",isValid:"\x3d?",theForm:"\x3d?"},transclude:{"readonly":"?readonlySection","editable":"?editableSection"},templateUrl:"js/shared/vertical-section-layout/vertical-section-layout-template.html",
link:function($scope,iElem,iAttrs,ctrl,transcludeFn){if($scope.isDeleteVisible==undefined)$scope.isDeleteVisible=true;if($scope.editable==undefined)$scope.editable=false;if($scope.showVerticalCheck==undefined)$scope.showVerticalCheck=true;if($scope.allowEdit==undefined)$scope.allowEdit=true;if($scope.isValid==undefined)$scope.isValid=true;if($scope.keepEditableAfterSave==undefined)$scope.keepEditableAfterSave=false;$scope.edit=function(ev){$scope.editable=true;$scope.onEdit(ev)};$scope.cancel=function(ev){$scope.onCancelEdit(ev);
$scope.editable=false};$scope.save=function(ev){$scope.onSaveEdit(ev);if(!$scope.keepEditableAfterSave)$scope.editable=false};$scope.delete=function(ev){if($scope.onDelete)$scope.onDelete(ev)}}}});angular.module(COMMON_APP_MODULE_NAME).directive("tbaViewTypeSelection",function(){return{restrict:"E",templateUrl:"js/shared/view-type-selection/view-type-selection-template.html",scope:{viewType:"\x3d"},link:function($scope,elem,attr){$scope.viewTypeChanged=function(viewType){$scope.viewType=viewType}}}});
