package com.thinkbiganalytics.nifi.provenance.model;

/*-
 * #%L
 * thinkbig-nifi-provenance-model
 * %%
 * Copyright (C) 2017 ThinkBig Analytics
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.nio.file.Files;

public enum ProvenanceEventExtendedAttributes {

    FLOW_FILES_PROCESSED_COUNT("Flow Files Processed","Total Number of files processed"),PARENT_FLOW_FILES_COUNT("Parent Flow Files","Count of parent flow files coming into this processor"), CHILD_FLOW_FILES_COUNT("Child Flow Files", "Count of child flow files coming out of this processor");

    private String displayName;
    private String description;

    ProvenanceEventExtendedAttributes(String displayName, String description){
        this.displayName = displayName;
        this.description = description;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}
