/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.v1;

import com.cloudera.api.DataView;
import com.cloudera.api.model.ApiCommandList;
import com.cloudera.api.model.ApiConfigList;
import com.cloudera.api.model.ApiMetricList;
import com.cloudera.api.model.ApiRole;
import com.cloudera.api.model.ApiRoleList;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public interface RolesResource {
    @POST
    @Path(value="/")
    public ApiRoleList createRoles(ApiRoleList var1);

    @DELETE
    @Path(value="/{roleName}")
    public ApiRole deleteRole(@PathParam(value="roleName") String var1);

    @GET
    @Path(value="/")
    public ApiRoleList readRoles();

    @GET
    @Path(value="/{roleName}")
    public ApiRole readRole(@PathParam(value="roleName") String var1);

    @GET
    @Path(value="/{roleName}/config")
    public ApiConfigList readRoleConfig(@PathParam(value="roleName") String var1, @QueryParam(value="view") @DefaultValue(value="summary") DataView var2);

    @PUT
    @Path(value="/{roleName}/config")
    public ApiConfigList updateRoleConfig(@PathParam(value="roleName") String var1, @QueryParam(value="message") String var2, ApiConfigList var3);

    @Deprecated
    @GET
    @Path(value="/{roleName}/metrics")
    public ApiMetricList getMetrics(@PathParam(value="roleName") String var1, @QueryParam(value="from") String var2, @QueryParam(value="to") @DefaultValue(value="now") String var3, @QueryParam(value="metrics") List<String> var4, @QueryParam(value="view") @DefaultValue(value="summary") DataView var5);

    @GET
    @Path(value="/{roleName}/commands")
    public ApiCommandList listActiveCommands(@PathParam(value="roleName") String var1, @QueryParam(value="view") @DefaultValue(value="summary") DataView var2);

    @GET
    @Path(value="/{roleName}/logs/full")
    @Produces(value={"text/plain"})
    public InputStream getFullLog(@PathParam(value="roleName") String var1);

    @GET
    @Path(value="/{roleName}/logs/stdout")
    @Produces(value={"text/plain"})
    public InputStream getStandardOutput(@PathParam(value="roleName") String var1);

    @GET
    @Path(value="/{roleName}/logs/stderr")
    @Produces(value={"text/plain"})
    public InputStream getStandardError(@PathParam(value="roleName") String var1);
}

