/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.model;

import com.cloudera.api.ApiUtils;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.Set;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="user")
public class ApiUser {
    private String name;
    private String password;
    private Set<String> roles;
    private String pwHash;
    private Long pwSalt;
    private Boolean pwLogin;

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("roles", this.roles).toString();
    }

    public boolean equals(Object o) {
        ApiUser other = ApiUtils.baseEquals(this, o);
        return this == other || other != null && Objects.equal((Object)this.name, (Object)other.getName()) && Objects.equal(this.roles, other.getRoles());
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.name != null) {
            hashCode += this.name.hashCode();
        }
        if (this.roles != null) {
            for (String role : this.roles) {
                hashCode += role.hashCode();
            }
        }
        return hashCode;
    }

    @XmlElement
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElement
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @XmlElementWrapper(name="roles")
    public Set<String> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<String> roles) {
        this.roles = roles != null ? Sets.newHashSet(roles) : null;
    }

    public void addRole(String role) {
        if (this.roles == null) {
            this.roles = Sets.newHashSet();
        }
        this.roles.add(role);
    }

    @XmlElement
    public String getPwHash() {
        return this.pwHash;
    }

    public void setPwHash(String pwHash) {
        this.pwHash = pwHash;
    }

    @XmlElement
    public Long getPwSalt() {
        return this.pwSalt;
    }

    public void setPwSalt(Long pwSalt) {
        this.pwSalt = pwSalt;
    }

    @XmlElement
    public Boolean getPwLogin() {
        return this.pwLogin;
    }

    public void setPwLogin(Boolean pwLogin) {
        this.pwLogin = pwLogin;
    }
}

