/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.model;

import com.cloudera.api.model.ApiHostRef;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.joda.time.Duration;

@XmlRootElement(name="impalaQuery")
public class ApiImpalaQuery {
    private String queryId;
    private String statement;
    private String queryType;
    private String queryState;
    private Date startTime;
    private Date endTime;
    private Long rowsProduced;
    private Map<String, String> attributes;
    private String user;
    private ApiHostRef coordinator;
    private boolean detailsAvailable;
    private String database;
    private Long durationMillis;

    public ApiImpalaQuery() {
    }

    public ApiImpalaQuery(String queryId, String statement, String queryType, String queryState, Date startTime, Date endTime, Long rowsProduced, Map<String, String> syntheticAttributes, String user, String frontEndHostId, boolean runtimeProfileAvailable, String defaultDatabase, Duration duration) {
        Preconditions.checkNotNull((Object)queryId);
        this.queryId = queryId;
        this.statement = statement;
        this.queryType = queryType;
        this.queryState = queryState;
        this.startTime = startTime;
        this.endTime = endTime;
        this.rowsProduced = rowsProduced;
        this.attributes = syntheticAttributes;
        this.user = user;
        this.coordinator = new ApiHostRef(frontEndHostId);
        this.detailsAvailable = runtimeProfileAvailable;
        this.database = defaultDatabase;
        this.durationMillis = duration == null ? null : Long.valueOf(duration.getMillis());
    }

    @XmlElement
    public String getQueryId() {
        return this.queryId;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    @XmlElement
    public String getStatement() {
        return this.statement;
    }

    public void setStatement(String statement) {
        this.statement = statement;
    }

    @XmlElement
    public String getQueryType() {
        return this.queryType;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    @XmlElement
    public String getQueryState() {
        return this.queryState;
    }

    public void setQueryState(String queryState) {
        this.queryState = queryState;
    }

    @XmlElement
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    @XmlElement
    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Long getRowsProduced() {
        return this.rowsProduced;
    }

    public void setRowsProduced(Long rowsProduced) {
        this.rowsProduced = rowsProduced;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public ApiHostRef getCoordinator() {
        return this.coordinator;
    }

    public void setCoordinator(ApiHostRef coordinator) {
        this.coordinator = coordinator;
    }

    public boolean getDetailsAvailable() {
        return this.detailsAvailable;
    }

    public void setDetailsAvailable(boolean detailsAvailable) {
        this.detailsAvailable = detailsAvailable;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public Long getDurationMillis() {
        return this.durationMillis;
    }

    public void setDurationMillis(long durationMillis) {
        this.durationMillis = durationMillis;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("statement", (Object)this.statement).add("queryType", (Object)this.queryType).add("queryState", (Object)this.queryState).add("startTime", (Object)this.startTime).add("endTime", (Object)this.endTime).add("rowsProduced", (Object)this.rowsProduced).add("attributes", this.attributes).add("user", (Object)this.user).add("coordinator", (Object)this.coordinator).add("detailsAvailable", this.detailsAvailable).add("database", (Object)this.database).add("durationMillis", (Object)this.durationMillis).toString();
    }
}

