/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.model;

import com.cloudera.api.ApiUtils;
import com.cloudera.api.model.ApiCommissionState;
import com.cloudera.api.model.ApiConfigList;
import com.cloudera.api.model.ApiEntityType;
import com.cloudera.api.model.ApiHealthCheck;
import com.cloudera.api.model.ApiHealthSummary;
import com.cloudera.api.model.ApiRoleRef;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="host")
public class ApiHost {
    private String hostId;
    private String ipAddress;
    private String hostname;
    private String rackId;
    private String hostUrl;
    private Date lastHeartbeat;
    private ApiHealthSummary healthSummary;
    private List<ApiHealthCheck> healthChecks;
    private List<ApiRoleRef> roleRefs;
    private Boolean maintenanceMode;
    private List<ApiEntityType> maintenanceOwners;
    private ApiCommissionState commissionState;
    private ApiConfigList config;
    private Long numCores;
    private Long numPhysicalCores;
    private Long totalPhysMemBytes;

    public ApiHost() {
    }

    public ApiHost(ApiHost host) {
        Preconditions.checkNotNull((Object)host, (Object)"Cannot copy a null host");
        this.hostId = host.getHostId();
        this.ipAddress = host.getIpAddress();
        this.hostname = host.getHostname();
        this.rackId = host.getRackId();
        this.hostUrl = host.getHostUrl();
        this.lastHeartbeat = host.getLastHeartbeat();
        this.healthSummary = host.getHealthSummary();
        this.healthChecks = host.getHealthChecks();
        List<ApiRoleRef> refs = host.getRoleRefs();
        this.roleRefs = refs != null ? Lists.newArrayList(refs) : Lists.newArrayList();
        this.maintenanceMode = host.getMaintenanceMode();
        this.maintenanceOwners = host.getMaintenanceOwners();
        this.commissionState = host.getCommissionState();
        this.config = host.getConfig();
        this.numCores = host.getNumCores();
        this.numPhysicalCores = host.getNumPhysicalCores();
        this.totalPhysMemBytes = host.getTotalPhysMemBytes();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("hostId", (Object)this.hostId).add("ipAddress", (Object)this.ipAddress).add("hostname", (Object)this.hostname).add("rackId", (Object)this.rackId).add("lastHeartbeat", (Object)this.lastHeartbeat).add("healthSummary", (Object)this.healthSummary).add("healthChecks", this.healthChecks).add("roleRefs", this.roleRefs).toString();
    }

    public boolean equals(Object o) {
        ApiHost that = ApiUtils.baseEquals(this, o);
        return this == that || that != null && Objects.equal((Object)this.hostId, (Object)that.getHostId());
    }

    public int hashCode() {
        return this.hostId != null ? this.hostId.hashCode() : 0;
    }

    @XmlElement
    public String getHostId() {
        return this.hostId;
    }

    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    @XmlElement
    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @XmlElement
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @XmlElement
    public String getRackId() {
        return this.rackId;
    }

    public void setRackId(String rackId) {
        this.rackId = rackId;
    }

    @XmlElement
    public Date getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    public void setLastHeartbeat(Date lastHeartbeat) {
        this.lastHeartbeat = lastHeartbeat;
    }

    @XmlElementWrapper(name="roleRefs")
    public List<ApiRoleRef> getRoleRefs() {
        return this.roleRefs;
    }

    public void setRoleRefs(List<ApiRoleRef> roleRefs) {
        this.roleRefs = roleRefs;
    }

    @XmlElement
    public ApiHealthSummary getHealthSummary() {
        return this.healthSummary;
    }

    public void setHealthSummary(ApiHealthSummary healthSummary) {
        this.healthSummary = healthSummary;
    }

    @XmlElementWrapper
    public List<ApiHealthCheck> getHealthChecks() {
        return this.healthChecks;
    }

    public void setHealthChecks(List<ApiHealthCheck> healthChecks) {
        this.healthChecks = healthChecks;
    }

    @XmlElement
    public String getHostUrl() {
        return this.hostUrl;
    }

    public void setHostUrl(String hostUrl) {
        this.hostUrl = hostUrl;
    }

    @XmlElement
    public Boolean getMaintenanceMode() {
        return this.maintenanceMode;
    }

    public void setMaintenanceMode(Boolean maintenanceMode) {
        this.maintenanceMode = maintenanceMode;
    }

    @XmlElement
    public ApiCommissionState getCommissionState() {
        return this.commissionState;
    }

    public void setCommissionState(ApiCommissionState commissionState) {
        this.commissionState = commissionState;
    }

    @XmlElementWrapper(name="maintenanceOwners")
    public List<ApiEntityType> getMaintenanceOwners() {
        return this.maintenanceOwners;
    }

    public void setMaintenanceOwners(List<ApiEntityType> maintenanceOwners) {
        this.maintenanceOwners = Lists.newArrayList(maintenanceOwners);
    }

    @XmlElement
    public ApiConfigList getConfig() {
        return this.config;
    }

    public void setConfig(ApiConfigList config) {
        this.config = config;
    }

    @XmlElement
    public Long getNumCores() {
        return this.numCores;
    }

    public void setNumCores(Long numCores) {
        this.numCores = numCores;
    }

    @XmlElement
    public Long getNumPhysicalCores() {
        return this.numPhysicalCores;
    }

    public void setNumPhysicalCores(Long numCores) {
        this.numPhysicalCores = numCores;
    }

    @XmlElement
    public Long getTotalPhysMemBytes() {
        return this.totalPhysMemBytes;
    }

    public void setTotalPhysMemBytes(Long totalPhysMemBytes) {
        this.totalPhysMemBytes = totalPhysMemBytes;
    }
}

