/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.model;

import com.cloudera.api.ApiUtils;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Date;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="hdfsSnapshot")
public class ApiHdfsSnapshot {
    private String path;
    private String snapshotName;
    private String snapshotPath;
    private Date creationTime;

    public ApiHdfsSnapshot() {
    }

    public ApiHdfsSnapshot(String snapshottedPath, String snapshotName, String snapshotPath) {
        this(snapshottedPath, snapshotName, snapshotPath, null);
    }

    public ApiHdfsSnapshot(String snapshottedPath, String snapshotName, String snapshotPath, Date creationTime) {
        ApiHdfsSnapshot.validateSnapshotNameAndPath(snapshotName, snapshotPath);
        this.path = snapshottedPath;
        this.snapshotName = snapshotName;
        this.snapshotPath = snapshotPath;
        this.creationTime = creationTime;
    }

    @XmlElement
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    @XmlElement
    public String getSnapshotName() {
        return this.snapshotName;
    }

    public void setSnapshotName(String snapshotName) {
        ApiHdfsSnapshot.validateSnapshotNameAndPath(snapshotName, this.snapshotPath);
        this.snapshotName = snapshotName;
    }

    @XmlElement
    public String getSnapshotPath() {
        return this.snapshotPath;
    }

    public void setSnapshotPath(String snapshotPath) {
        ApiHdfsSnapshot.validateSnapshotNameAndPath(this.snapshotName, snapshotPath);
        this.snapshotPath = snapshotPath;
    }

    @XmlElement
    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("path", (Object)this.path).add("snapshotName", (Object)this.snapshotName).add("snapshotPath", (Object)this.snapshotPath).add("creationTime", (Object)this.creationTime).toString();
    }

    public boolean equals(Object o) {
        ApiHdfsSnapshot that = ApiUtils.baseEquals(this, o);
        return this == that || that != null && Objects.equal((Object)this.path, (Object)that.getPath()) && Objects.equal((Object)this.snapshotName, (Object)that.getSnapshotName()) && Objects.equal((Object)this.snapshotPath, (Object)that.getSnapshotPath()) && Objects.equal((Object)this.creationTime, (Object)that.getCreationTime());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.path, this.snapshotName, this.snapshotPath, this.creationTime});
    }

    private static void validateSnapshotNameAndPath(String snapshotName, String snapshotPath) {
        if (snapshotName != null && snapshotPath != null) {
            Preconditions.checkArgument((boolean)snapshotPath.contains("/.snapshot/" + snapshotName), (String)"Passed in arguments snapshot name '%s' and snapshot path '%s' does not match.", (Object[])new Object[]{snapshotName, snapshotPath});
        }
    }
}

