/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.model;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Arrays;

public enum ApiEventSeverity {
    UNKNOWN,
    INFORMATIONAL,
    IMPORTANT,
    CRITICAL;

    private static final String VALID_SEVERITIES;

    public static ApiEventSeverity fromString(String severity) {
        try {
            ApiEventSeverity res = ApiEventSeverity.valueOf(severity.toUpperCase());
            if (res == UNKNOWN) {
                throw new IllegalArgumentException();
            }
            return res;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(severity + " is not a valid event severity. Support severity values: " + VALID_SEVERITIES);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Severity cannot be null.");
        }
    }

    static {
        VALID_SEVERITIES = Joiner.on((String)", ").join((Iterable)Collections2.filter(Arrays.asList(ApiEventSeverity.values()), (Predicate)new Predicate<ApiEventSeverity>(){

            public boolean apply(ApiEventSeverity input) {
                return input != UNKNOWN;
            }
        }));
    }
}

