/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.model;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

public enum ApiActivityType {
    UNKNOWN,
    OOZIE,
    PIG,
    HIVE,
    MR,
    STREAMING;

    private static String VALID_VALUES;

    public static ApiActivityType fromString(String str) {
        if (str == null) {
            return null;
        }
        try {
            ApiActivityType res = ApiActivityType.valueOf(str.toUpperCase());
            if (res == UNKNOWN) {
                throw new IllegalArgumentException();
            }
            return res;
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(String.format("Illegal type='%s'. Supported type values: %s", str, VALID_VALUES));
        }
    }

    static {
        VALID_VALUES = Joiner.on((String)", ").join(Iterables.filter((Iterable)Lists.newArrayList((Object[])ApiActivityType.values()), (Predicate)new Predicate<ApiActivityType>(){

            public boolean apply(ApiActivityType input) {
                return input != UNKNOWN;
            }
        }));
    }
}

