/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.model;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;

public enum ApiActivityStatus {
    UNKNOWN,
    SUBMITTED,
    STARTED,
    SUSPENDED,
    FAILED,
    KILLED,
    SUCCEEDED,
    ASSUMED_SUCCEEDED;

    private static String VALID_STATUS_VALUES;

    public static ApiActivityStatus fromString(String s) {
        if (s == null) {
            return null;
        }
        try {
            ApiActivityStatus res = ApiActivityStatus.valueOf(s.toUpperCase());
            if (res == UNKNOWN) {
                throw new IllegalArgumentException();
            }
            return res;
        }
        catch (IllegalArgumentException t) {
            throw new IllegalArgumentException(String.format("Illegal status='%s'. Supported status values: %s", s, VALID_STATUS_VALUES));
        }
    }

    static {
        VALID_STATUS_VALUES = Joiner.on((String)", ").join(Iterables.filter((Iterable)Lists.newArrayList((Object[])ApiActivityStatus.values()), (Predicate)new Predicate<ApiActivityStatus>(){

            public boolean apply(ApiActivityStatus input) {
                return input != UNKNOWN;
            }
        }));
    }
}

