/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.AnnotationIntrospectorPair;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.SimpleTimeZone;

public class ApiObjectMapper
extends ObjectMapper {
    public ApiObjectMapper() {
        this.configure(SerializationFeature.INDENT_OUTPUT, true);
        this.setAnnotationIntrospector((AnnotationIntrospector)new AnnotationIntrospectorPair(this.getSerializationConfig().getAnnotationIntrospector(), (AnnotationIntrospector)new JaxbAnnotationIntrospector(this.getTypeFactory())));
        this.enable(new MapperFeature[]{MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME});
        this.setDateFormat(ApiObjectMapper.makeISODateFormat());
    }

    public static DateFormat makeISODateFormat() {
        SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        Calendar cal = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
        iso8601.setCalendar(cal);
        return iso8601;
    }

    public static DateFormat makeDateFormat(String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        Calendar cal = Calendar.getInstance(new SimpleTimeZone(0, "GMT"));
        dateFormat.setCalendar(cal);
        return dateFormat;
    }
}

