% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{FrequencyMatrix-class}
\alias{FrequencyMatrix-class}
\alias{totals,FrequencyMatrix-method}
\title{Frequency matrix}
\usage{
\S4method{totals}{FrequencyMatrix}(object)
}
\arguments{
\item{object}{A \code{FrequencyMatrix} object.}
}
\description{
An S4 class to represent a frequency matrix.
}
\details{
To ensure data integrity, a \code{FrequencyMatrix} can only be created by
 coercion from a \linkS4class{CountMatrix} (see examples).
}
\section{Methods (by generic)}{
\itemize{
\item \code{totals}: Returns the row sums (counts).
}}

\section{Slots}{

\describe{
\item{\code{total}}{A \code{\link{numeric}} vector.}
}}

\note{
This class extends the \code{base} \link[base]{matrix}.
}
\examples{
# Create a count data matrix
A1 <- CountMatrix(data = sample(0:10, 100, TRUE),
                  nrow = 10, ncol = 10, byrow = TRUE)

# Coerce counts to frequencies
B <- as(A1, "FrequencyMatrix")

# Row sums are internally stored before coercing to a frequency matrix
totals(B) # Get row sums

# This allows to restore the source data
A2 <- as(B, "CountMatrix")
all(A1 == A2)
}
\seealso{
\link[base]{matrix}

Other abundance matrix: \code{\link{CountMatrix-class}}
}
\author{
N. Frerebeau
}
\concept{abundance matrix}
