---
name: Bug report
about: Create a report to help us improve
title: ''
labels: 'Bug'
assignees: ''

---

**Describe the bug**
A clear and concise description of what the bug is.

**Logs**
Please include browser console and server logs around the time this bug occurred.

**To Reproduce**
To help us help you, if you've found a bug please consider the following:

* If you can demonstrate the bug using https://svelte.dev/repl, please do.
* If that's not possible, we recommend creating a small repo that illustrates the problem.
* Reproductions should be small, self-contained, correct examples – http://sscce.org.

Occasionally, this won't be possible, and that's fine – we still appreciate you raising the issue. But please understand that Svelte is run by unpaid volunteers in their free time, and issues that follow these instructions will get fixed faster.

**Expected behavior**
A clear and concise description of what you expected to happen.

**Stacktraces**
If you have a stack trace to include, we recommend putting inside a `<details>` block for the sake of the thread's readability:

<details>
  <summary>Stack trace</summary>

  Stack trace goes here...
</details>

**Information about your Svelte project:**
- Your browser and the version: (e.x. Chrome 52.1, Firefox 48.0, IE 10)

- Your operating system: (e.x. OS X 10, Ubuntu Linux 19.10, Windows XP, etc)

- Svelte version (Please check you can reproduce the issue with the latest release!)

- Whether your project uses Webpack or Rollup

**Severity**
How severe an issue is this bug to you? Is this annoying, blocking some users, blocking an upgrade or blocking your usage of Svelte entirely?

Note: the more honest and specific you are here the more we will take you seriously.

**Additional context**
Add any other context about the problem here.
