import * as assert from 'assert';
import get_name_from_filename from './get_name_from_filename';

describe('get_name_from_filename', () => {
	it('uses the basename', () => {
		assert.equal(get_name_from_filename('path/to/Widget.svelte'), 'Widget');
	});

	it('uses the directory name, if basename is index', () => {
		assert.equal(get_name_from_filename('path/to/Widget/index.svelte'), 'Widget');
	});

	it('handles unusual filenames', () => {
		assert.equal(get_name_from_filename('path/to/[...parts].svelte'), 'Parts');
	});
});
