import send from '@polka/send';
import body from './_utils/body.js';
import { query } from '../../utils/db';

export async function post(req, res) {
	const { user } = req;
	if (!user) return; // response already sent

	try {
		const { name, files } = await body(req);

		const [row] = await query(`
			insert into gists(user_id, name, files)
			values ($1, $2, $3) returning *`, [user.id, name, JSON.stringify(files)]);

		send(res, 201, {
			uid: row.uid.replace(/-/g, ''),
			name: row.name,
			files: row.files,
			owner: user.uid,
		});
	} catch (err) {
		send(res, 500, {
			error: err.message
		});
	}
}
