// ThreeWebGL.js - http://github.com/mrdoob/three.js
'use strict';var THREE=THREE||{REVISION:"48"};if(!self.Int32Array)self.Int32Array=Array,self.Float32Array=Array;
(function(){for(var a=0,b=["ms","moz","webkit","o"],c=0;c<b.length&&!window.requestAnimationFrame;++c)window.requestAnimationFrame=window[b[c]+"RequestAnimationFrame"],window.cancelAnimationFrame=window[b[c]+"CancelAnimationFrame"]||window[b[c]+"CancelRequestAnimationFrame"];if(!window.requestAnimationFrame)window.requestAnimationFrame=function(b){var c=(new Date).getTime(),g=Math.max(0,16-(c-a)),h=window.setTimeout(function(){b(c+g)},g);a=c+g;return h};if(!window.cancelAnimationFrame)window.cancelAnimationFrame=
function(a){clearTimeout(a)}})();THREE.Color=function(a){void 0!==a&&this.setHex(a);return this};
THREE.Color.prototype={constructor:THREE.Color,r:1,g:1,b:1,copy:function(a){this.r=a.r;this.g=a.g;this.b=a.b;return this},copyGammaToLinear:function(a){this.r=a.r*a.r;this.g=a.g*a.g;this.b=a.b*a.b;return this},copyLinearToGamma:function(a){this.r=Math.sqrt(a.r);this.g=Math.sqrt(a.g);this.b=Math.sqrt(a.b);return this},convertGammaToLinear:function(){var a=this.r,b=this.g,c=this.b;this.r=a*a;this.g=b*b;this.b=c*c;return this},convertLinearToGamma:function(){this.r=Math.sqrt(this.r);this.g=Math.sqrt(this.g);
this.b=Math.sqrt(this.b);return this},setRGB:function(a,b,c){this.r=a;this.g=b;this.b=c;return this},setHSV:function(a,b,c){var d,e,g;if(0===c)this.r=this.g=this.b=0;else switch(d=Math.floor(6*a),e=6*a-d,a=c*(1-b),g=c*(1-b*e),b=c*(1-b*(1-e)),d){case 1:this.r=g;this.g=c;this.b=a;break;case 2:this.r=a;this.g=c;this.b=b;break;case 3:this.r=a;this.g=g;this.b=c;break;case 4:this.r=b;this.g=a;this.b=c;break;case 5:this.r=c;this.g=a;this.b=g;break;case 6:case 0:this.r=c,this.g=b,this.b=a}return this},setHex:function(a){a=
Math.floor(a);this.r=(a>>16&255)/255;this.g=(a>>8&255)/255;this.b=(a&255)/255;return this},getHex:function(){return Math.floor(255*this.r)<<16^Math.floor(255*this.g)<<8^Math.floor(255*this.b)},getContextStyle:function(){return"rgb("+Math.floor(255*this.r)+","+Math.floor(255*this.g)+","+Math.floor(255*this.b)+")"},clone:function(){return(new THREE.Color).setRGB(this.r,this.g,this.b)}};THREE.Vector2=function(a,b){this.x=a||0;this.y=b||0};
THREE.Vector2.prototype={constructor:THREE.Vector2,set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.x=a.x;this.y=a.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;return this},
divideScalar:function(a){a?(this.x/=a,this.y/=a):this.set(0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x,a=this.y-a.y;return b*b+a*a},setLength:function(a){return this.normalize().multiplyScalar(a)},
lerpSelf:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;return this},equals:function(a){return a.x===this.x&&a.y===this.y},isZero:function(){return 1.0E-4>this.lengthSq()}};THREE.Vector3=function(a,b,c){this.x=a||0;this.y=b||0;this.z=c||0};
THREE.Vector3.prototype={constructor:THREE.Vector3,set:function(a,b,c){this.x=a;this.y=b;this.z=c;return this},setX:function(a){this.x=a;return this},setY:function(a){this.y=a;return this},setZ:function(a){this.z=a;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;return this},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;return this},
addScalar:function(a){this.x+=a;this.y+=a;this.z+=a;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;return this},multiply:function(a,b){this.x=a.x*b.x;this.y=a.y*b.y;this.z=a.z*b.z;return this},multiplySelf:function(a){this.x*=a.x;this.y*=a.y;this.z*=a.z;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;return this},divideSelf:function(a){this.x/=a.x;this.y/=a.y;this.z/=a.z;return this},
divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a):this.z=this.y=this.x=0;return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.lengthSq())},lengthManhattan:function(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)},normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},
lerpSelf:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;this.z+=(a.z-this.z)*b;return this},cross:function(a,b){this.x=a.y*b.z-a.z*b.y;this.y=a.z*b.x-a.x*b.z;this.z=a.x*b.y-a.y*b.x;return this},crossSelf:function(a){var b=this.x,c=this.y,d=this.z;this.x=c*a.z-d*a.y;this.y=d*a.x-b*a.z;this.z=b*a.y-c*a.x;return this},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){return(new THREE.Vector3).sub(this,a).lengthSq()},getPositionFromMatrix:function(a){this.x=
a.n14;this.y=a.n24;this.z=a.n34;return this},getRotationFromMatrix:function(a,b){var c=b?b.x:1,d=b?b.y:1,e=b?b.z:1,g=a.n11/c,h=a.n12/d,c=a.n21/c,d=a.n22/d,i=a.n23/e,m=a.n33/e;this.y=Math.asin(a.n13/e);e=Math.cos(this.y);1.0E-5<Math.abs(e)?(this.x=Math.atan2(-i/e,m/e),this.z=Math.atan2(-h/e,g/e)):(this.x=0,this.z=Math.atan2(c,d));return this},getScaleFromMatrix:function(a){var b=this.set(a.n11,a.n21,a.n31).length(),c=this.set(a.n12,a.n22,a.n32).length(),a=this.set(a.n13,a.n23,a.n33).length();this.x=
b;this.y=c;this.z=a},equals:function(a){return a.x===this.x&&a.y===this.y&&a.z===this.z},isZero:function(){return 1.0E-4>this.lengthSq()}};THREE.Vector4=function(a,b,c,d){this.x=a||0;this.y=b||0;this.z=c||0;this.w=void 0!==d?d:1};
THREE.Vector4.prototype={constructor:THREE.Vector4,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=void 0!==a.w?a.w:1;return this},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;this.w=a.w+b.w;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;this.w+=a.w;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;
this.z=a.z-b.z;this.w=a.w-b.w;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;this.w-=a.w;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;this.w*=a;return this},divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a,this.w/=a):(this.z=this.y=this.x=0,this.w=1);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z+this.w*a.w},lengthSq:function(){return this.dot(this)},length:function(){return Math.sqrt(this.lengthSq())},
normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},lerpSelf:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;this.z+=(a.z-this.z)*b;this.w+=(a.w-this.w)*b;return this}};THREE.Frustum=function(){this.planes=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4]};
THREE.Frustum.prototype.setFromMatrix=function(a){var b,c=this.planes;c[0].set(a.n41-a.n11,a.n42-a.n12,a.n43-a.n13,a.n44-a.n14);c[1].set(a.n41+a.n11,a.n42+a.n12,a.n43+a.n13,a.n44+a.n14);c[2].set(a.n41+a.n21,a.n42+a.n22,a.n43+a.n23,a.n44+a.n24);c[3].set(a.n41-a.n21,a.n42-a.n22,a.n43-a.n23,a.n44-a.n24);c[4].set(a.n41-a.n31,a.n42-a.n32,a.n43-a.n33,a.n44-a.n34);c[5].set(a.n41+a.n31,a.n42+a.n32,a.n43+a.n33,a.n44+a.n34);for(a=0;6>a;a++)b=c[a],b.divideScalar(Math.sqrt(b.x*b.x+b.y*b.y+b.z*b.z))};
THREE.Frustum.prototype.contains=function(a){for(var b=this.planes,c=a.matrixWorld,d=THREE.Frustum.__v1.set(c.getColumnX().length(),c.getColumnY().length(),c.getColumnZ().length()),d=-a.geometry.boundingSphere.radius*Math.max(d.x,Math.max(d.y,d.z)),e=0;6>e;e++)if(a=b[e].x*c.n14+b[e].y*c.n24+b[e].z*c.n34+b[e].w,a<=d)return!1;return!0};THREE.Frustum.__v1=new THREE.Vector3;
THREE.Ray=function(a,b){function c(a,b,c){o.sub(c,a);y=o.dot(b);w=p.add(a,s.copy(b).multiplyScalar(y));return N=c.distanceTo(w)}function d(a,b,c,d){o.sub(d,b);p.sub(c,b);s.sub(a,b);A=o.dot(o);u=o.dot(p);H=o.dot(s);I=p.dot(p);D=p.dot(s);L=1/(A*I-u*u);K=(I*H-u*D)*L;M=(A*D-u*H)*L;return 0<=K&&0<=M&&1>K+M}this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3;this.intersectObjects=function(a){var b,c,d=[];for(b=0,c=a.length;b<c;b++)Array.prototype.push.apply(d,this.intersectObject(a[b]));
d.sort(function(a,b){return a.distance-b.distance});return d};var e=1.0E-4;this.setPrecision=function(a){e=a};var g=new THREE.Vector3,h=new THREE.Vector3,i=new THREE.Vector3,m=new THREE.Vector3,k=new THREE.Vector3,j=new THREE.Vector3,n=new THREE.Vector3,l=new THREE.Vector3,q=new THREE.Vector3;this.intersectObject=function(a){var b,o=[];if(a instanceof THREE.Particle){var p=c(this.origin,this.direction,a.matrixWorld.getPosition());if(p>a.scale.x)return[];b={distance:p,point:a.position,face:null,object:a};
o.push(b)}else if(a instanceof THREE.Mesh){var p=c(this.origin,this.direction,a.matrixWorld.getPosition()),s=THREE.Frustum.__v1.set(a.matrixWorld.getColumnX().length(),a.matrixWorld.getColumnY().length(),a.matrixWorld.getColumnZ().length());if(p>a.geometry.boundingSphere.radius*Math.max(s.x,Math.max(s.y,s.z)))return o;var u,f,y=a.geometry,w=y.vertices,A;a.matrixRotationWorld.extractRotation(a.matrixWorld);for(p=0,s=y.faces.length;p<s;p++)if(b=y.faces[p],k.copy(this.origin),j.copy(this.direction),
A=a.matrixWorld,n=A.multiplyVector3(n.copy(b.centroid)).subSelf(k),l=a.matrixRotationWorld.multiplyVector3(l.copy(b.normal)),u=j.dot(l),!(Math.abs(u)<e)&&(f=l.dot(n)/u,!(0>f)&&(a.doubleSided||(a.flipSided?0<u:0>u))))if(q.add(k,j.multiplyScalar(f)),b instanceof THREE.Face3)g=A.multiplyVector3(g.copy(w[b.a].position)),h=A.multiplyVector3(h.copy(w[b.b].position)),i=A.multiplyVector3(i.copy(w[b.c].position)),d(q,g,h,i)&&(b={distance:k.distanceTo(q),point:q.clone(),face:b,object:a},o.push(b));else if(b instanceof
THREE.Face4&&(g=A.multiplyVector3(g.copy(w[b.a].position)),h=A.multiplyVector3(h.copy(w[b.b].position)),i=A.multiplyVector3(i.copy(w[b.c].position)),m=A.multiplyVector3(m.copy(w[b.d].position)),d(q,g,h,m)||d(q,h,i,m)))b={distance:k.distanceTo(q),point:q.clone(),face:b,object:a},o.push(b)}return o};var o=new THREE.Vector3,p=new THREE.Vector3,s=new THREE.Vector3,y,w,N,A,u,H,I,D,L,K,M};
THREE.Rectangle=function(){function a(){g=d-b;h=e-c}var b,c,d,e,g,h,i=!0;this.getX=function(){return b};this.getY=function(){return c};this.getWidth=function(){return g};this.getHeight=function(){return h};this.getLeft=function(){return b};this.getTop=function(){return c};this.getRight=function(){return d};this.getBottom=function(){return e};this.set=function(g,h,j,n){i=!1;b=g;c=h;d=j;e=n;a()};this.addPoint=function(g,h){i?(i=!1,b=g,c=h,d=g,e=h):(b=b<g?b:g,c=c<h?c:h,d=d>g?d:g,e=e>h?e:h);a()};this.add3Points=
function(g,h,j,n,l,q){i?(i=!1,b=g<j?g<l?g:l:j<l?j:l,c=h<n?h<q?h:q:n<q?n:q,d=g>j?g>l?g:l:j>l?j:l,e=h>n?h>q?h:q:n>q?n:q):(b=g<j?g<l?g<b?g:b:l<b?l:b:j<l?j<b?j:b:l<b?l:b,c=h<n?h<q?h<c?h:c:q<c?q:c:n<q?n<c?n:c:q<c?q:c,d=g>j?g>l?g>d?g:d:l>d?l:d:j>l?j>d?j:d:l>d?l:d,e=h>n?h>q?h>e?h:e:q>e?q:e:n>q?n>e?n:e:q>e?q:e);a()};this.addRectangle=function(g){i?(i=!1,b=g.getLeft(),c=g.getTop(),d=g.getRight(),e=g.getBottom()):(b=b<g.getLeft()?b:g.getLeft(),c=c<g.getTop()?c:g.getTop(),d=d>g.getRight()?d:g.getRight(),e=e>
g.getBottom()?e:g.getBottom());a()};this.inflate=function(g){b-=g;c-=g;d+=g;e+=g;a()};this.minSelf=function(g){b=b>g.getLeft()?b:g.getLeft();c=c>g.getTop()?c:g.getTop();d=d<g.getRight()?d:g.getRight();e=e<g.getBottom()?e:g.getBottom();a()};this.intersects=function(a){return d<a.getLeft()||b>a.getRight()||e<a.getTop()||c>a.getBottom()?!1:!0};this.empty=function(){i=!0;e=d=c=b=0;a()};this.isEmpty=function(){return i}};
THREE.Math={clamp:function(a,b,c){return a<b?b:a>c?c:a},clampBottom:function(a,b){return a<b?b:a},mapLinear:function(a,b,c,d,e){return d+(a-b)*(e-d)/(c-b)},random16:function(){return(65280*Math.random()+255*Math.random())/65535},randInt:function(a,b){return a+Math.floor(Math.random()*(b-a+1))},randFloat:function(a,b){return a+Math.random()*(b-a)},randFloatSpread:function(a){return a*(0.5-Math.random())},sign:function(a){return 0>a?-1:0<a?1:0}};THREE.Matrix3=function(){this.m=[]};
THREE.Matrix3.prototype={constructor:THREE.Matrix3,transposeIntoArray:function(a){var b=this.m;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this}};THREE.Matrix4=function(a,b,c,d,e,g,h,i,m,k,j,n,l,q,o,p){this.set(void 0!==a?a:1,b||0,c||0,d||0,e||0,void 0!==g?g:1,h||0,i||0,m||0,k||0,void 0!==j?j:1,n||0,l||0,q||0,o||0,void 0!==p?p:1);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={constructor:THREE.Matrix4,set:function(a,b,c,d,e,g,h,i,m,k,j,n,l,q,o,p){this.n11=a;this.n12=b;this.n13=c;this.n14=d;this.n21=e;this.n22=g;this.n23=h;this.n24=i;this.n31=m;this.n32=k;this.n33=j;this.n34=n;this.n41=l;this.n42=q;this.n43=o;this.n44=p;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){this.set(a.n11,a.n12,a.n13,a.n14,a.n21,a.n22,a.n23,a.n24,a.n31,a.n32,a.n33,a.n34,a.n41,a.n42,a.n43,a.n44);return this},lookAt:function(a,
b,c){var d=THREE.Matrix4.__v1,e=THREE.Matrix4.__v2,g=THREE.Matrix4.__v3;g.sub(a,b).normalize();if(0===g.length())g.z=1;d.cross(c,g).normalize();0===d.length()&&(g.x+=1.0E-4,d.cross(c,g).normalize());e.cross(g,d);this.n11=d.x;this.n12=e.x;this.n13=g.x;this.n21=d.y;this.n22=e.y;this.n23=g.y;this.n31=d.z;this.n32=e.z;this.n33=g.z;return this},multiply:function(a,b){var c=a.n11,d=a.n12,e=a.n13,g=a.n14,h=a.n21,i=a.n22,m=a.n23,k=a.n24,j=a.n31,n=a.n32,l=a.n33,q=a.n34,o=a.n41,p=a.n42,s=a.n43,y=a.n44,w=b.n11,
N=b.n12,A=b.n13,u=b.n14,H=b.n21,I=b.n22,D=b.n23,L=b.n24,K=b.n31,M=b.n32,ja=b.n33,oa=b.n34,ka=b.n41,X=b.n42,$=b.n43,C=b.n44;this.n11=c*w+d*H+e*K+g*ka;this.n12=c*N+d*I+e*M+g*X;this.n13=c*A+d*D+e*ja+g*$;this.n14=c*u+d*L+e*oa+g*C;this.n21=h*w+i*H+m*K+k*ka;this.n22=h*N+i*I+m*M+k*X;this.n23=h*A+i*D+m*ja+k*$;this.n24=h*u+i*L+m*oa+k*C;this.n31=j*w+n*H+l*K+q*ka;this.n32=j*N+n*I+l*M+q*X;this.n33=j*A+n*D+l*ja+q*$;this.n34=j*u+n*L+l*oa+q*C;this.n41=o*w+p*H+s*K+y*ka;this.n42=o*N+p*I+s*M+y*X;this.n43=o*A+p*D+s*
ja+y*$;this.n44=o*u+p*L+s*oa+y*C;return this},multiplySelf:function(a){return this.multiply(this,a)},multiplyToArray:function(a,b,c){this.multiply(a,b);c[0]=this.n11;c[1]=this.n21;c[2]=this.n31;c[3]=this.n41;c[4]=this.n12;c[5]=this.n22;c[6]=this.n32;c[7]=this.n42;c[8]=this.n13;c[9]=this.n23;c[10]=this.n33;c[11]=this.n43;c[12]=this.n14;c[13]=this.n24;c[14]=this.n34;c[15]=this.n44;return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=
a;this.n24*=a;this.n31*=a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=a;this.n42*=a;this.n43*=a;this.n44*=a;return this},multiplyVector3:function(a){var b=a.x,c=a.y,d=a.z,e=1/(this.n41*b+this.n42*c+this.n43*d+this.n44);a.x=(this.n11*b+this.n12*c+this.n13*d+this.n14)*e;a.y=(this.n21*b+this.n22*c+this.n23*d+this.n24)*e;a.z=(this.n31*b+this.n32*c+this.n33*d+this.n34)*e;return a},multiplyVector4:function(a){var b=a.x,c=a.y,d=a.z,e=a.w;a.x=this.n11*b+this.n12*c+this.n13*d+this.n14*e;a.y=this.n21*b+this.n22*
c+this.n23*d+this.n24*e;a.z=this.n31*b+this.n32*c+this.n33*d+this.n34*e;a.w=this.n41*b+this.n42*c+this.n43*d+this.n44*e;return a},rotateAxis:function(a){var b=a.x,c=a.y,d=a.z;a.x=b*this.n11+c*this.n12+d*this.n13;a.y=b*this.n21+c*this.n22+d*this.n23;a.z=b*this.n31+c*this.n32+d*this.n33;a.normalize();return a},crossVector:function(a){var b=new THREE.Vector4;b.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;b.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;b.z=this.n31*a.x+this.n32*a.y+this.n33*
a.z+this.n34*a.w;b.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return b},determinant:function(){var a=this.n11,b=this.n12,c=this.n13,d=this.n14,e=this.n21,g=this.n22,h=this.n23,i=this.n24,m=this.n31,k=this.n32,j=this.n33,n=this.n34,l=this.n41,q=this.n42,o=this.n43,p=this.n44;return d*h*k*l-c*i*k*l-d*g*j*l+b*i*j*l+c*g*n*l-b*h*n*l-d*h*m*q+c*i*m*q+d*e*j*q-a*i*j*q-c*e*n*q+a*h*n*q+d*g*m*o-b*i*m*o-d*e*k*o+a*i*k*o+b*e*n*o-a*g*n*o-c*g*m*p+b*h*m*p+c*e*k*p-a*h*k*p-b*e*j*p+a*g*j*p},transpose:function(){var a;
a=this.n21;this.n21=this.n12;this.n12=a;a=this.n31;this.n31=this.n13;this.n13=a;a=this.n32;this.n32=this.n23;this.n23=a;a=this.n41;this.n41=this.n14;this.n14=a;a=this.n42;this.n42=this.n24;this.n24=a;a=this.n43;this.n43=this.n34;this.n34=a;return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;a.n41=this.n41;a.n42=this.n42;
a.n43=this.n43;a.n44=this.n44;return a},flattenToArray:function(a){a[0]=this.n11;a[1]=this.n21;a[2]=this.n31;a[3]=this.n41;a[4]=this.n12;a[5]=this.n22;a[6]=this.n32;a[7]=this.n42;a[8]=this.n13;a[9]=this.n23;a[10]=this.n33;a[11]=this.n43;a[12]=this.n14;a[13]=this.n24;a[14]=this.n34;a[15]=this.n44;return a},flattenToArrayOffset:function(a,b){a[b]=this.n11;a[b+1]=this.n21;a[b+2]=this.n31;a[b+3]=this.n41;a[b+4]=this.n12;a[b+5]=this.n22;a[b+6]=this.n32;a[b+7]=this.n42;a[b+8]=this.n13;a[b+9]=this.n23;a[b+
10]=this.n33;a[b+11]=this.n43;a[b+12]=this.n14;a[b+13]=this.n24;a[b+14]=this.n34;a[b+15]=this.n44;return a},setTranslation:function(a,b,c){this.set(1,0,0,a,0,1,0,b,0,0,1,c,0,0,0,1);return this},setScale:function(a,b,c){this.set(a,0,0,0,0,b,0,0,0,0,c,0,0,0,0,1);return this},setRotationX:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(1,0,0,0,0,b,-a,0,0,a,b,0,0,0,0,1);return this},setRotationY:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},setRotationZ:function(a){var b=
Math.cos(a),a=Math.sin(a);this.set(b,-a,0,0,a,b,0,0,0,0,1,0,0,0,0,1);return this},setRotationAxis:function(a,b){var c=Math.cos(b),d=Math.sin(b),e=1-c,g=a.x,h=a.y,i=a.z,m=e*g,k=e*h;this.set(m*g+c,m*h-d*i,m*i+d*h,0,m*h+d*i,k*h+c,k*i-d*g,0,m*i-d*h,k*i+d*g,e*i*i+c,0,0,0,0,1);return this},setPosition:function(a){this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},getPosition:function(){return THREE.Matrix4.__v1.set(this.n14,this.n24,this.n34)},getColumnX:function(){return THREE.Matrix4.__v1.set(this.n11,
this.n21,this.n31)},getColumnY:function(){return THREE.Matrix4.__v1.set(this.n12,this.n22,this.n32)},getColumnZ:function(){return THREE.Matrix4.__v1.set(this.n13,this.n23,this.n33)},getInverse:function(a){var b=a.n11,c=a.n12,d=a.n13,e=a.n14,g=a.n21,h=a.n22,i=a.n23,m=a.n24,k=a.n31,j=a.n32,n=a.n33,l=a.n34,q=a.n41,o=a.n42,p=a.n43,s=a.n44;this.n11=i*l*o-m*n*o+m*j*p-h*l*p-i*j*s+h*n*s;this.n12=e*n*o-d*l*o-e*j*p+c*l*p+d*j*s-c*n*s;this.n13=d*m*o-e*i*o+e*h*p-c*m*p-d*h*s+c*i*s;this.n14=e*i*j-d*m*j-e*h*n+c*
m*n+d*h*l-c*i*l;this.n21=m*n*q-i*l*q-m*k*p+g*l*p+i*k*s-g*n*s;this.n22=d*l*q-e*n*q+e*k*p-b*l*p-d*k*s+b*n*s;this.n23=e*i*q-d*m*q-e*g*p+b*m*p+d*g*s-b*i*s;this.n24=d*m*k-e*i*k+e*g*n-b*m*n-d*g*l+b*i*l;this.n31=h*l*q-m*j*q+m*k*o-g*l*o-h*k*s+g*j*s;this.n32=e*j*q-c*l*q-e*k*o+b*l*o+c*k*s-b*j*s;this.n33=c*m*q-e*h*q+e*g*o-b*m*o-c*g*s+b*h*s;this.n34=e*h*k-c*m*k-e*g*j+b*m*j+c*g*l-b*h*l;this.n41=i*j*q-h*n*q-i*k*o+g*n*o+h*k*p-g*j*p;this.n42=c*n*q-d*j*q+d*k*o-b*n*o-c*k*p+b*j*p;this.n43=d*h*q-c*i*q-d*g*o+b*i*o+c*
g*p-b*h*p;this.n44=c*i*k-d*h*k+d*g*j-b*i*j-c*g*n+b*h*n;this.multiplyScalar(1/a.determinant());return this},setRotationFromEuler:function(a,b){var c=a.x,d=a.y,e=a.z,g=Math.cos(c),c=Math.sin(c),h=Math.cos(d),d=Math.sin(d),i=Math.cos(e),e=Math.sin(e);switch(b){case "YXZ":var m=h*i,k=h*e,j=d*i,n=d*e;this.n11=m+n*c;this.n12=j*c-k;this.n13=g*d;this.n21=g*e;this.n22=g*i;this.n23=-c;this.n31=k*c-j;this.n32=n+m*c;this.n33=g*h;break;case "ZXY":m=h*i;k=h*e;j=d*i;n=d*e;this.n11=m-n*c;this.n12=-g*e;this.n13=j+
k*c;this.n21=k+j*c;this.n22=g*i;this.n23=n-m*c;this.n31=-g*d;this.n32=c;this.n33=g*h;break;case "ZYX":m=g*i;k=g*e;j=c*i;n=c*e;this.n11=h*i;this.n12=j*d-k;this.n13=m*d+n;this.n21=h*e;this.n22=n*d+m;this.n23=k*d-j;this.n31=-d;this.n32=c*h;this.n33=g*h;break;case "YZX":m=g*h;k=g*d;j=c*h;n=c*d;this.n11=h*i;this.n12=n-m*e;this.n13=j*e+k;this.n21=e;this.n22=g*i;this.n23=-c*i;this.n31=-d*i;this.n32=k*e+j;this.n33=m-n*e;break;case "XZY":m=g*h;k=g*d;j=c*h;n=c*d;this.n11=h*i;this.n12=-e;this.n13=d*i;this.n21=
m*e+n;this.n22=g*i;this.n23=k*e-j;this.n31=j*e-k;this.n32=c*i;this.n33=n*e+m;break;default:m=g*i,k=g*e,j=c*i,n=c*e,this.n11=h*i,this.n12=-h*e,this.n13=d,this.n21=k+j*d,this.n22=m-n*d,this.n23=-c*h,this.n31=n-m*d,this.n32=j+k*d,this.n33=g*h}return this},setRotationFromQuaternion:function(a){var b=a.x,c=a.y,d=a.z,e=a.w,g=b+b,h=c+c,i=d+d,a=b*g,m=b*h,b=b*i,k=c*h,c=c*i,d=d*i,g=e*g,h=e*h,e=e*i;this.n11=1-(k+d);this.n12=m-e;this.n13=b+h;this.n21=m+e;this.n22=1-(a+d);this.n23=c-g;this.n31=b-h;this.n32=c+
g;this.n33=1-(a+k);return this},scale:function(a){var b=a.x,c=a.y,a=a.z;this.n11*=b;this.n12*=c;this.n13*=a;this.n21*=b;this.n22*=c;this.n23*=a;this.n31*=b;this.n32*=c;this.n33*=a;this.n41*=b;this.n42*=c;this.n43*=a;return this},compose:function(a,b,c){var d=THREE.Matrix4.__m1,e=THREE.Matrix4.__m2;d.identity();d.setRotationFromQuaternion(b);e.setScale(c.x,c.y,c.z);this.multiply(d,e);this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},decompose:function(a,b,c){var d=THREE.Matrix4.__v1,e=THREE.Matrix4.__v2,
g=THREE.Matrix4.__v3;d.set(this.n11,this.n21,this.n31);e.set(this.n12,this.n22,this.n32);g.set(this.n13,this.n23,this.n33);a=a instanceof THREE.Vector3?a:new THREE.Vector3;b=b instanceof THREE.Quaternion?b:new THREE.Quaternion;c=c instanceof THREE.Vector3?c:new THREE.Vector3;c.x=d.length();c.y=e.length();c.z=g.length();a.x=this.n14;a.y=this.n24;a.z=this.n34;d=THREE.Matrix4.__m1;d.copy(this);d.n11/=c.x;d.n21/=c.x;d.n31/=c.x;d.n12/=c.y;d.n22/=c.y;d.n32/=c.y;d.n13/=c.z;d.n23/=c.z;d.n33/=c.z;b.setFromRotationMatrix(d);
return[a,b,c]},extractPosition:function(a){this.n14=a.n14;this.n24=a.n24;this.n34=a.n34;return this},extractRotation:function(a){var b=THREE.Matrix4.__v1,c=1/b.set(a.n11,a.n21,a.n31).length(),d=1/b.set(a.n12,a.n22,a.n32).length(),b=1/b.set(a.n13,a.n23,a.n33).length();this.n11=a.n11*c;this.n21=a.n21*c;this.n31=a.n31*c;this.n12=a.n12*d;this.n22=a.n22*d;this.n32=a.n32*d;this.n13=a.n13*b;this.n23=a.n23*b;this.n33=a.n33*b;return this},rotateByAxis:function(a,b){if(1===a.x&&0===a.y&&0===a.z)return this.rotateX(b);
if(0===a.x&&1===a.y&&0===a.z)return this.rotateY(b);if(0===a.x&&0===a.y&&1===a.z)return this.rotateZ(b);var c=a.x,d=a.y,e=a.z,g=Math.sqrt(c*c+d*d+e*e),c=c/g,d=d/g,e=e/g,g=c*c,h=d*d,i=e*e,m=Math.cos(b),k=Math.sin(b),j=1-m,n=c*d*j,l=c*e*j,j=d*e*j,c=c*k,q=d*k,k=e*k,e=g+(1-g)*m,g=n+k,d=l-q,n=n-k,h=h+(1-h)*m,k=j+c,l=l+q,j=j-c,i=i+(1-i)*m,m=this.n11,c=this.n21,q=this.n31,o=this.n41,p=this.n12,s=this.n22,y=this.n32,w=this.n42,N=this.n13,A=this.n23,u=this.n33,H=this.n43;this.n11=e*m+g*p+d*N;this.n21=e*c+
g*s+d*A;this.n31=e*q+g*y+d*u;this.n41=e*o+g*w+d*H;this.n12=n*m+h*p+k*N;this.n22=n*c+h*s+k*A;this.n32=n*q+h*y+k*u;this.n42=n*o+h*w+k*H;this.n13=l*m+j*p+i*N;this.n23=l*c+j*s+i*A;this.n33=l*q+j*y+i*u;this.n43=l*o+j*w+i*H;return this},rotateX:function(a){var b=this.n12,c=this.n22,d=this.n32,e=this.n42,g=this.n13,h=this.n23,i=this.n33,m=this.n43,k=Math.cos(a),a=Math.sin(a);this.n12=k*b+a*g;this.n22=k*c+a*h;this.n32=k*d+a*i;this.n42=k*e+a*m;this.n13=k*g-a*b;this.n23=k*h-a*c;this.n33=k*i-a*d;this.n43=k*
m-a*e;return this},rotateY:function(a){var b=this.n11,c=this.n21,d=this.n31,e=this.n41,g=this.n13,h=this.n23,i=this.n33,m=this.n43,k=Math.cos(a),a=Math.sin(a);this.n11=k*b-a*g;this.n21=k*c-a*h;this.n31=k*d-a*i;this.n41=k*e-a*m;this.n13=k*g+a*b;this.n23=k*h+a*c;this.n33=k*i+a*d;this.n43=k*m+a*e;return this},rotateZ:function(a){var b=this.n11,c=this.n21,d=this.n31,e=this.n41,g=this.n12,h=this.n22,i=this.n32,m=this.n42,k=Math.cos(a),a=Math.sin(a);this.n11=k*b+a*g;this.n21=k*c+a*h;this.n31=k*d+a*i;this.n41=
k*e+a*m;this.n12=k*g-a*b;this.n22=k*h-a*c;this.n32=k*i-a*d;this.n42=k*m-a*e;return this},translate:function(a){var b=a.x,c=a.y,a=a.z;this.n14=this.n11*b+this.n12*c+this.n13*a+this.n14;this.n24=this.n21*b+this.n22*c+this.n23*a+this.n24;this.n34=this.n31*b+this.n32*c+this.n33*a+this.n34;this.n44=this.n41*b+this.n42*c+this.n43*a+this.n44;return this}};
THREE.Matrix4.makeInvert3x3=function(a){var b=a.m33,c=b.m,d=a.n33*a.n22-a.n32*a.n23,e=-a.n33*a.n21+a.n31*a.n23,g=a.n32*a.n21-a.n31*a.n22,h=-a.n33*a.n12+a.n32*a.n13,i=a.n33*a.n11-a.n31*a.n13,m=-a.n32*a.n11+a.n31*a.n12,k=a.n23*a.n12-a.n22*a.n13,j=-a.n23*a.n11+a.n21*a.n13,n=a.n22*a.n11-a.n21*a.n12,a=a.n11*d+a.n21*h+a.n31*k;if(0===a)return null;a=1/a;c[0]=a*d;c[1]=a*e;c[2]=a*g;c[3]=a*h;c[4]=a*i;c[5]=a*m;c[6]=a*k;c[7]=a*j;c[8]=a*n;return b};
THREE.Matrix4.makeFrustum=function(a,b,c,d,e,g){var h;h=new THREE.Matrix4;h.n11=2*e/(b-a);h.n12=0;h.n13=(b+a)/(b-a);h.n14=0;h.n21=0;h.n22=2*e/(d-c);h.n23=(d+c)/(d-c);h.n24=0;h.n31=0;h.n32=0;h.n33=-(g+e)/(g-e);h.n34=-2*g*e/(g-e);h.n41=0;h.n42=0;h.n43=-1;h.n44=0;return h};THREE.Matrix4.makePerspective=function(a,b,c,d){var e,a=c*Math.tan(a*Math.PI/360);e=-a;return THREE.Matrix4.makeFrustum(e*b,a*b,e,a,c,d)};
THREE.Matrix4.makeOrtho=function(a,b,c,d,e,g){var h,i,m,k;h=new THREE.Matrix4;i=b-a;m=c-d;k=g-e;h.n11=2/i;h.n12=0;h.n13=0;h.n14=-((b+a)/i);h.n21=0;h.n22=2/m;h.n23=0;h.n24=-((c+d)/m);h.n31=0;h.n32=0;h.n33=-2/k;h.n34=-((g+e)/k);h.n41=0;h.n42=0;h.n43=0;h.n44=1;return h};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;THREE.Matrix4.__m1=new THREE.Matrix4;THREE.Matrix4.__m2=new THREE.Matrix4;
THREE.Object3D=function(){this.id=THREE.Object3DCount++;this.name="";this.parent=void 0;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.eulerOrder="XYZ";this.scale=new THREE.Vector3(1,1,1);this.flipSided=this.doubleSided=!1;this.renderDepth=null;this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixWorldNeedsUpdate=this.matrixAutoUpdate=
!0;this.quaternion=new THREE.Quaternion;this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=!0;this.receiveShadow=this.castShadow=!1;this.frustumCulled=!0;this._vector=new THREE.Vector3};
THREE.Object3D.prototype={constructor:THREE.Object3D,applyMatrix:function(a){this.matrix.multiply(a,this.matrix);this.scale.getScaleFromMatrix(this.matrix);this.rotation.getRotationFromMatrix(this.matrix,this.scale);this.position.getPositionFromMatrix(this.matrix)},translate:function(a,b){this.matrix.rotateAxis(b);this.position.addSelf(b.multiplyScalar(a))},translateX:function(a){this.translate(a,this._vector.set(1,0,0))},translateY:function(a){this.translate(a,this._vector.set(0,1,0))},translateZ:function(a){this.translate(a,
this._vector.set(0,0,1))},lookAt:function(a){this.matrix.lookAt(a,this.position,this.up);this.rotationAutoUpdate&&this.rotation.getRotationFromMatrix(this.matrix)},add:function(a){if(a===this)console.warn("THREE.Object3D.add: An object can't be added as a child of itself.");else if(-1===this.children.indexOf(a)){void 0!==a.parent&&a.parent.remove(a);a.parent=this;this.children.push(a);for(var b=this;void 0!==b.parent;)b=b.parent;void 0!==b&&b instanceof THREE.Scene&&b.__addObject(a)}},remove:function(a){var b=
this.children.indexOf(a);if(-1!==b){a.parent=void 0;this.children.splice(b,1);for(b=this;void 0!==b.parent;)b=b.parent;void 0!==b&&b instanceof THREE.Scene&&b.__removeObject(a)}},getChildByName:function(a,b){var c,d,e;for(c=0,d=this.children.length;c<d;c++){e=this.children[c];if(e.name===a||b&&(e=e.getChildByName(a,b),void 0!==e))return e}},updateMatrix:function(){this.matrix.setPosition(this.position);this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation,
this.eulerOrder);if(1!==this.scale.x||1!==this.scale.y||1!==this.scale.z)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z));this.matrixWorldNeedsUpdate=!0},updateMatrixWorld:function(a){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||a)this.parent?this.matrixWorld.multiply(this.parent.matrixWorld,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,a=!0;for(var b=0,c=this.children.length;b<
c;b++)this.children[b].updateMatrixWorld(a)}};THREE.Object3DCount=0;
THREE.Projector=function(){function a(){var a=h[g]=h[g]||new THREE.RenderableObject;g++;return a}function b(){var a=k[m]=k[m]||new THREE.RenderableVertex;m++;return a}function c(a,b){return b.z-a.z}function d(a,b){var c=0,d=1,e=a.z+a.w,f=b.z+b.w,g=-a.z+a.w,h=-b.z+b.w;if(0<=e&&0<=f&&0<=g&&0<=h)return!0;if(0>e&&0>f||0>g&&0>h)return!1;0>e?c=Math.max(c,e/(e-f)):0>f&&(d=Math.min(d,e/(e-f)));0>g?c=Math.max(c,g/(g-h)):0>h&&(d=Math.min(d,g/(g-h)));if(d<c)return!1;a.lerpSelf(b,c);b.lerpSelf(a,1-d);return!0}
var e,g,h=[],i,m,k=[],j,n,l=[],q,o=[],p,s,y=[],w,N,A=[],u={objects:[],sprites:[],lights:[],elements:[]},H=new THREE.Vector3,I=new THREE.Vector4,D=new THREE.Matrix4,L=new THREE.Matrix4,K=new THREE.Frustum,M=new THREE.Vector4,ja=new THREE.Vector4;this.projectVector=function(a,b){b.matrixWorldInverse.getInverse(b.matrixWorld);D.multiply(b.projectionMatrix,b.matrixWorldInverse);D.multiplyVector3(a);return a};this.unprojectVector=function(a,b){b.projectionMatrixInverse.getInverse(b.projectionMatrix);D.multiply(b.matrixWorld,
b.projectionMatrixInverse);D.multiplyVector3(a);return a};this.pickingRay=function(a,b){var c;a.z=-1;c=new THREE.Vector3(a.x,a.y,1);this.unprojectVector(a,b);this.unprojectVector(c,b);c.subSelf(a).normalize();return new THREE.Ray(a,c)};this.projectGraph=function(b,d){g=0;u.objects.length=0;u.sprites.length=0;u.lights.length=0;var h=function(b){if(!1!==b.visible){(b instanceof THREE.Mesh||b instanceof THREE.Line)&&(!1===b.frustumCulled||K.contains(b))?(D.multiplyVector3(H.copy(b.position)),e=a(),e.object=
b,e.z=H.z,u.objects.push(e)):b instanceof THREE.Sprite||b instanceof THREE.Particle?(D.multiplyVector3(H.copy(b.position)),e=a(),e.object=b,e.z=H.z,u.sprites.push(e)):b instanceof THREE.Light&&u.lights.push(b);for(var c=0,f=b.children.length;c<f;c++)h(b.children[c])}};h(b);d&&u.objects.sort(c);return u};this.projectScene=function(a,e,g){var h=e.near,C=e.far,f=!1,H,Ba,S,sa,J,aa,ta,xa,T,Aa,Ga,Ha,Sa,Wa,Ma;N=s=q=n=0;u.elements.length=0;void 0===e.parent&&(console.warn("DEPRECATED: Camera hasn't been added to a Scene. Adding it..."),
a.add(e));a.updateMatrixWorld();e.matrixWorldInverse.getInverse(e.matrixWorld);D.multiply(e.projectionMatrix,e.matrixWorldInverse);K.setFromMatrix(D);u=this.projectGraph(a,!1);for(a=0,H=u.objects.length;a<H;a++)if(T=u.objects[a].object,Aa=T.matrixWorld,m=0,T instanceof THREE.Mesh){Ga=T.geometry;Ha=T.geometry.materials;sa=Ga.vertices;Sa=Ga.faces;Wa=Ga.faceVertexUvs;Ga=T.matrixRotationWorld.extractRotation(Aa);for(Ba=0,S=sa.length;Ba<S;Ba++)i=b(),i.positionWorld.copy(sa[Ba].position),Aa.multiplyVector3(i.positionWorld),
i.positionScreen.copy(i.positionWorld),D.multiplyVector4(i.positionScreen),i.positionScreen.x/=i.positionScreen.w,i.positionScreen.y/=i.positionScreen.w,i.visible=i.positionScreen.z>h&&i.positionScreen.z<C;for(sa=0,Ba=Sa.length;sa<Ba;sa++){S=Sa[sa];if(S instanceof THREE.Face3)if(J=k[S.a],aa=k[S.b],ta=k[S.c],J.visible&&aa.visible&&ta.visible)if(f=0>(ta.positionScreen.x-J.positionScreen.x)*(aa.positionScreen.y-J.positionScreen.y)-(ta.positionScreen.y-J.positionScreen.y)*(aa.positionScreen.x-J.positionScreen.x),
T.doubleSided||f!=T.flipSided)xa=l[n]=l[n]||new THREE.RenderableFace3,n++,j=xa,j.v1.copy(J),j.v2.copy(aa),j.v3.copy(ta);else continue;else continue;else if(S instanceof THREE.Face4)if(J=k[S.a],aa=k[S.b],ta=k[S.c],xa=k[S.d],J.visible&&aa.visible&&ta.visible&&xa.visible)if(f=0>(xa.positionScreen.x-J.positionScreen.x)*(aa.positionScreen.y-J.positionScreen.y)-(xa.positionScreen.y-J.positionScreen.y)*(aa.positionScreen.x-J.positionScreen.x)||0>(aa.positionScreen.x-ta.positionScreen.x)*(xa.positionScreen.y-
ta.positionScreen.y)-(aa.positionScreen.y-ta.positionScreen.y)*(xa.positionScreen.x-ta.positionScreen.x),T.doubleSided||f!=T.flipSided)Ma=o[q]=o[q]||new THREE.RenderableFace4,q++,j=Ma,j.v1.copy(J),j.v2.copy(aa),j.v3.copy(ta),j.v4.copy(xa);else continue;else continue;j.normalWorld.copy(S.normal);!f&&(T.flipSided||T.doubleSided)&&j.normalWorld.negate();Ga.multiplyVector3(j.normalWorld);j.centroidWorld.copy(S.centroid);Aa.multiplyVector3(j.centroidWorld);j.centroidScreen.copy(j.centroidWorld);D.multiplyVector3(j.centroidScreen);
ta=S.vertexNormals;for(J=0,aa=ta.length;J<aa;J++)xa=j.vertexNormalsWorld[J],xa.copy(ta[J]),!f&&(T.flipSided||T.doubleSided)&&xa.negate(),Ga.multiplyVector3(xa);for(J=0,aa=Wa.length;J<aa;J++)if(Ma=Wa[J][sa])for(ta=0,xa=Ma.length;ta<xa;ta++)j.uvs[J][ta]=Ma[ta];j.material=T.material;j.faceMaterial=null!==S.materialIndex?Ha[S.materialIndex]:null;j.z=j.centroidScreen.z;u.elements.push(j)}}else if(T instanceof THREE.Line){L.multiply(D,Aa);sa=T.geometry.vertices;J=b();J.positionScreen.copy(sa[0].position);
L.multiplyVector4(J.positionScreen);for(Ba=1,S=sa.length;Ba<S;Ba++)if(J=b(),J.positionScreen.copy(sa[Ba].position),L.multiplyVector4(J.positionScreen),aa=k[m-2],M.copy(J.positionScreen),ja.copy(aa.positionScreen),d(M,ja))M.multiplyScalar(1/M.w),ja.multiplyScalar(1/ja.w),Aa=y[s]=y[s]||new THREE.RenderableLine,s++,p=Aa,p.v1.positionScreen.copy(M),p.v2.positionScreen.copy(ja),p.z=Math.max(M.z,ja.z),p.material=T.material,u.elements.push(p)}for(a=0,H=u.sprites.length;a<H;a++)if(T=u.sprites[a].object,Aa=
T.matrixWorld,T instanceof THREE.Particle&&(I.set(Aa.n14,Aa.n24,Aa.n34,1),D.multiplyVector4(I),I.z/=I.w,0<I.z&&1>I.z))h=A[N]=A[N]||new THREE.RenderableParticle,N++,w=h,w.x=I.x/I.w,w.y=I.y/I.w,w.z=I.z,w.rotation=T.rotation.z,w.scale.x=T.scale.x*Math.abs(w.x-(I.x+e.projectionMatrix.n11)/(I.w+e.projectionMatrix.n14)),w.scale.y=T.scale.y*Math.abs(w.y-(I.y+e.projectionMatrix.n22)/(I.w+e.projectionMatrix.n24)),w.material=T.material,u.elements.push(w);g&&u.elements.sort(c);return u}};
THREE.Quaternion=function(a,b,c,d){this.x=a||0;this.y=b||0;this.z=c||0;this.w=void 0!==d?d:1};
THREE.Quaternion.prototype={constructor:THREE.Quaternion,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w;return this},clone:function(){return new THREE.Quaternion(this.x,this.y,this.z,this.w)},setFromEuler:function(a){var b=Math.PI/360,c=a.x*b,d=a.y*b,e=a.z*b,a=Math.cos(d),d=Math.sin(d),b=Math.cos(-e),e=Math.sin(-e),g=Math.cos(c),c=Math.sin(c),h=a*b,i=d*e;this.w=h*g-i*c;this.x=h*c+i*g;this.y=d*b*g+a*e*c;this.z=a*e*
g-d*b*c;return this},setFromAxisAngle:function(a,b){var c=b/2,d=Math.sin(c);this.x=a.x*d;this.y=a.y*d;this.z=a.z*d;this.w=Math.cos(c);return this},setFromRotationMatrix:function(a){var b=Math.pow(a.determinant(),1/3);this.w=Math.sqrt(Math.max(0,b+a.n11+a.n22+a.n33))/2;this.x=Math.sqrt(Math.max(0,b+a.n11-a.n22-a.n33))/2;this.y=Math.sqrt(Math.max(0,b-a.n11+a.n22-a.n33))/2;this.z=Math.sqrt(Math.max(0,b-a.n11-a.n22+a.n33))/2;this.x=0>a.n32-a.n23?-Math.abs(this.x):Math.abs(this.x);this.y=0>a.n13-a.n31?
-Math.abs(this.y):Math.abs(this.y);this.z=0>a.n21-a.n12?-Math.abs(this.z):Math.abs(this.z);this.normalize();return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);0===a?this.w=this.z=
this.y=this.x=0:(a=1/a,this.x*=a,this.y*=a,this.z*=a,this.w*=a);return this},multiplySelf:function(a){var b=this.x,c=this.y,d=this.z,e=this.w,g=a.x,h=a.y,i=a.z,a=a.w;this.x=b*a+e*g+c*i-d*h;this.y=c*a+e*h+d*g-b*i;this.z=d*a+e*i+b*h-c*g;this.w=e*a-b*g-c*h-d*i;return this},multiply:function(a,b){this.x=a.x*b.w+a.y*b.z-a.z*b.y+a.w*b.x;this.y=-a.x*b.z+a.y*b.w+a.z*b.x+a.w*b.y;this.z=a.x*b.y-a.y*b.x+a.z*b.w+a.w*b.z;this.w=-a.x*b.x-a.y*b.y-a.z*b.z+a.w*b.w;return this},multiplyVector3:function(a,b){b||(b=
a);var c=a.x,d=a.y,e=a.z,g=this.x,h=this.y,i=this.z,m=this.w,k=m*c+h*e-i*d,j=m*d+i*c-g*e,n=m*e+g*d-h*c,c=-g*c-h*d-i*e;b.x=k*m+c*-g+j*-i-n*-h;b.y=j*m+c*-h+n*-g-k*-i;b.z=n*m+c*-i+k*-h-j*-g;return b}};
THREE.Quaternion.slerp=function(a,b,c,d){var e=a.w*b.w+a.x*b.x+a.y*b.y+a.z*b.z;0>e?(c.w=-b.w,c.x=-b.x,c.y=-b.y,c.z=-b.z,e=-e):c.copy(b);if(1<=Math.abs(e))return c.w=a.w,c.x=a.x,c.y=a.y,c.z=a.z,c;var g=Math.acos(e),e=Math.sqrt(1-e*e);if(0.001>Math.abs(e))return c.w=0.5*(a.w+b.w),c.x=0.5*(a.x+b.x),c.y=0.5*(a.y+b.y),c.z=0.5*(a.z+b.z),c;b=Math.sin((1-d)*g)/e;d=Math.sin(d*g)/e;c.w=a.w*b+c.w*d;c.x=a.x*b+c.x*d;c.y=a.y*b+c.y*d;c.z=a.z*b+c.z*d;return c};THREE.Vertex=function(a){this.position=a||new THREE.Vector3};
THREE.Vertex.prototype={constructor:THREE.Vertex,clone:function(){return new THREE.Vertex(this.position.clone())}};THREE.Face3=function(a,b,c,d,e,g){this.a=a;this.b=b;this.c=c;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=d instanceof Array?d:[];this.color=e instanceof THREE.Color?e:new THREE.Color;this.vertexColors=e instanceof Array?e:[];this.vertexTangents=[];this.materialIndex=g;this.centroid=new THREE.Vector3};
THREE.Face3.prototype={constructor:THREE.Face3,clone:function(){var a=new THREE.Face3(this.a,this.b,this.c);a.normal.copy(this.normal);a.color.copy(this.color);a.centroid.copy(this.centroid);a.materialIndex=this.materialIndex;var b,c;for(b=0,c=this.vertexNormals.length;b<c;b++)a.vertexNormals[b]=this.vertexNormals[b].clone();for(b=0,c=this.vertexColors.length;b<c;b++)a.vertexColors[b]=this.vertexColors[b].clone();for(b=0,c=this.vertexTangents.length;b<c;b++)a.vertexTangents[b]=this.vertexTangents[b].clone();
return a}};THREE.Face4=function(a,b,c,d,e,g,h){this.a=a;this.b=b;this.c=c;this.d=d;this.normal=e instanceof THREE.Vector3?e:new THREE.Vector3;this.vertexNormals=e instanceof Array?e:[];this.color=g instanceof THREE.Color?g:new THREE.Color;this.vertexColors=g instanceof Array?g:[];this.vertexTangents=[];this.materialIndex=h;this.centroid=new THREE.Vector3};
THREE.Face4.prototype={constructor:THREE.Face4,clone:function(){var a=new THREE.Face4(this.a,this.b,this.c,this.d);a.normal.copy(this.normal);a.color.copy(this.color);a.centroid.copy(this.centroid);a.materialIndex=this.materialIndex;var b,c;for(b=0,c=this.vertexNormals.length;b<c;b++)a.vertexNormals[b]=this.vertexNormals[b].clone();for(b=0,c=this.vertexColors.length;b<c;b++)a.vertexColors[b]=this.vertexColors[b].clone();for(b=0,c=this.vertexTangents.length;b<c;b++)a.vertexTangents[b]=this.vertexTangents[b].clone();
return a}};THREE.UV=function(a,b){this.u=a||0;this.v=b||0};THREE.UV.prototype={constructor:THREE.UV,set:function(a,b){this.u=a;this.v=b;return this},copy:function(a){this.u=a.u;this.v=a.v;return this},lerpSelf:function(a,b){this.u+=(a.u-this.u)*b;this.v+=(a.v-this.v)*b;return this},clone:function(){return new THREE.UV(this.u,this.v)}};
THREE.Geometry=function(){this.id=THREE.GeometryCount++;this.vertices=[];this.colors=[];this.materials=[];this.faces=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.morphNormals=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.dynamic=this.hasTangents=!1};
THREE.Geometry.prototype={constructor:THREE.Geometry,applyMatrix:function(a){var b=new THREE.Matrix4;b.extractRotation(a);for(var c=0,d=this.vertices.length;c<d;c++)a.multiplyVector3(this.vertices[c].position);c=0;for(d=this.faces.length;c<d;c++){var e=this.faces[c];b.multiplyVector3(e.normal);for(var g=0,h=e.vertexNormals.length;g<h;g++)b.multiplyVector3(e.vertexNormals[g]);a.multiplyVector3(e.centroid)}},computeCentroids:function(){var a,b,c;for(a=0,b=this.faces.length;a<b;a++)c=this.faces[a],c.centroid.set(0,
0,0),c instanceof THREE.Face3?(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),c.centroid.divideScalar(3)):c instanceof THREE.Face4&&(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),c.centroid.addSelf(this.vertices[c.d].position),c.centroid.divideScalar(4))},computeFaceNormals:function(){var a,b,c,d,e,g,h=new THREE.Vector3,
i=new THREE.Vector3;for(a=0,b=this.faces.length;a<b;a++)c=this.faces[a],d=this.vertices[c.a],e=this.vertices[c.b],g=this.vertices[c.c],h.sub(g.position,e.position),i.sub(d.position,e.position),h.crossSelf(i),h.isZero()||h.normalize(),c.normal.copy(h)},computeVertexNormals:function(){var a,b,c,d;if(void 0===this.__tmpVertices){d=this.__tmpVertices=Array(this.vertices.length);for(a=0,b=this.vertices.length;a<b;a++)d[a]=new THREE.Vector3;for(a=0,b=this.faces.length;a<b;a++)if(c=this.faces[a],c instanceof
THREE.Face3)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(c instanceof THREE.Face4)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}else{d=this.__tmpVertices;for(a=0,b=this.vertices.length;a<b;a++)d[a].set(0,0,0)}for(a=0,b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(d[c.a].addSelf(c.normal),d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal)):c instanceof THREE.Face4&&(d[c.a].addSelf(c.normal),d[c.b].addSelf(c.normal),
d[c.c].addSelf(c.normal),d[c.d].addSelf(c.normal));for(a=0,b=this.vertices.length;a<b;a++)d[a].normalize();for(a=0,b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(c.vertexNormals[0].copy(d[c.a]),c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c])):c instanceof THREE.Face4&&(c.vertexNormals[0].copy(d[c.a]),c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c]),c.vertexNormals[3].copy(d[c.d]))},computeMorphNormals:function(){var a,b,c,d,e;for(c=0,d=this.faces.length;c<
d;c++){e=this.faces[c];e.__originalFaceNormal?e.__originalFaceNormal.copy(e.normal):e.__originalFaceNormal=e.normal.clone();if(!e.__originalVertexNormals)e.__originalVertexNormals=[];for(a=0,b=e.vertexNormals.length;a<b;a++)e.__originalVertexNormals[a]?e.__originalVertexNormals[a].copy(e.vertexNormals[a]):e.__originalVertexNormals[a]=e.vertexNormals[a].clone()}var g=new THREE.Geometry;g.faces=this.faces;for(a=0,b=this.morphTargets.length;a<b;a++){if(!this.morphNormals[a]){this.morphNormals[a]={};
this.morphNormals[a].faceNormals=[];this.morphNormals[a].vertexNormals=[];var h=this.morphNormals[a].faceNormals,i=this.morphNormals[a].vertexNormals,m,k;for(c=0,d=this.faces.length;c<d;c++)e=this.faces[c],m=new THREE.Vector3,k=e instanceof THREE.Face3?{a:new THREE.Vector3,b:new THREE.Vector3,c:new THREE.Vector3}:{a:new THREE.Vector3,b:new THREE.Vector3,c:new THREE.Vector3,d:new THREE.Vector3},h.push(m),i.push(k)}h=this.morphNormals[a];g.vertices=this.morphTargets[a].vertices;g.computeFaceNormals();
g.computeVertexNormals();for(c=0,d=this.faces.length;c<d;c++)e=this.faces[c],m=h.faceNormals[c],k=h.vertexNormals[c],m.copy(e.normal),e instanceof THREE.Face3?(k.a.copy(e.vertexNormals[0]),k.b.copy(e.vertexNormals[1]),k.c.copy(e.vertexNormals[2])):(k.a.copy(e.vertexNormals[0]),k.b.copy(e.vertexNormals[1]),k.c.copy(e.vertexNormals[2]),k.d.copy(e.vertexNormals[3]))}for(c=0,d=this.faces.length;c<d;c++)e=this.faces[c],e.normal=e.__originalFaceNormal,e.vertexNormals=e.__originalVertexNormals},computeTangents:function(){function a(a,
b,c,d,e,g,D){i=a.vertices[b].position;m=a.vertices[c].position;k=a.vertices[d].position;j=h[e];n=h[g];l=h[D];q=m.x-i.x;o=k.x-i.x;p=m.y-i.y;s=k.y-i.y;y=m.z-i.z;w=k.z-i.z;N=n.u-j.u;A=l.u-j.u;u=n.v-j.v;H=l.v-j.v;I=1/(N*H-A*u);M.set((H*q-u*o)*I,(H*p-u*s)*I,(H*y-u*w)*I);ja.set((N*o-A*q)*I,(N*s-A*p)*I,(N*w-A*y)*I);L[b].addSelf(M);L[c].addSelf(M);L[d].addSelf(M);K[b].addSelf(ja);K[c].addSelf(ja);K[d].addSelf(ja)}var b,c,d,e,g,h,i,m,k,j,n,l,q,o,p,s,y,w,N,A,u,H,I,D,L=[],K=[],M=new THREE.Vector3,ja=new THREE.Vector3,
oa=new THREE.Vector3,ka=new THREE.Vector3,X=new THREE.Vector3;for(b=0,c=this.vertices.length;b<c;b++)L[b]=new THREE.Vector3,K[b]=new THREE.Vector3;for(b=0,c=this.faces.length;b<c;b++)g=this.faces[b],h=this.faceVertexUvs[0][b],g instanceof THREE.Face3?a(this,g.a,g.b,g.c,0,1,2):g instanceof THREE.Face4&&(a(this,g.a,g.b,g.c,0,1,2),a(this,g.a,g.b,g.d,0,1,3));var $=["a","b","c","d"];for(b=0,c=this.faces.length;b<c;b++){g=this.faces[b];for(d=0;d<g.vertexNormals.length;d++)X.copy(g.vertexNormals[d]),e=g[$[d]],
D=L[e],oa.copy(D),oa.subSelf(X.multiplyScalar(X.dot(D))).normalize(),ka.cross(g.vertexNormals[d],D),e=ka.dot(K[e]),e=0>e?-1:1,g.vertexTangents[d]=new THREE.Vector4(oa.x,oa.y,oa.z,e)}this.hasTangents=!0},computeBoundingBox:function(){if(!this.boundingBox)this.boundingBox={min:new THREE.Vector3,max:new THREE.Vector3};if(0<this.vertices.length){var a;a=this.vertices[0].position;this.boundingBox.min.copy(a);this.boundingBox.max.copy(a);for(var b=this.boundingBox.min,c=this.boundingBox.max,d=1,e=this.vertices.length;d<
e;d++){a=this.vertices[d].position;if(a.x<b.x)b.x=a.x;else if(a.x>c.x)c.x=a.x;if(a.y<b.y)b.y=a.y;else if(a.y>c.y)c.y=a.y;if(a.z<b.z)b.z=a.z;else if(a.z>c.z)c.z=a.z}}else this.boundingBox.min.set(0,0,0),this.boundingBox.max.set(0,0,0)},computeBoundingSphere:function(){if(!this.boundingSphere)this.boundingSphere={radius:0};for(var a,b=0,c=0,d=this.vertices.length;c<d;c++)a=this.vertices[c].position.length(),a>b&&(b=a);this.boundingSphere.radius=b},mergeVertices:function(){var a={},b=[],c=[],d,e=Math.pow(10,
4),g,h;for(g=0,h=this.vertices.length;g<h;g++)d=this.vertices[g].position,d=[Math.round(d.x*e),Math.round(d.y*e),Math.round(d.z*e)].join("_"),void 0===a[d]?(a[d]=g,b.push(this.vertices[g]),c[g]=b.length-1):c[g]=c[a[d]];for(g=0,h=this.faces.length;g<h;g++)if(a=this.faces[g],a instanceof THREE.Face3)a.a=c[a.a],a.b=c[a.b],a.c=c[a.c];else if(a instanceof THREE.Face4)a.a=c[a.a],a.b=c[a.b],a.c=c[a.c],a.d=c[a.d];this.vertices=b}};THREE.GeometryCount=0;
THREE.Spline=function(a){function b(a,b,c,d,e,g,h){a=0.5*(c-a);d=0.5*(d-b);return(2*(b-c)+a+d)*h+(-3*(b-c)-2*a-d)*g+a*e+b}this.points=a;var c=[],d={x:0,y:0,z:0},e,g,h,i,m,k,j,n,l;this.initFromArray=function(a){this.points=[];for(var b=0;b<a.length;b++)this.points[b]={x:a[b][0],y:a[b][1],z:a[b][2]}};this.getPoint=function(a){e=(this.points.length-1)*a;g=Math.floor(e);h=e-g;c[0]=0===g?g:g-1;c[1]=g;c[2]=g>this.points.length-2?g:g+1;c[3]=g>this.points.length-3?g:g+2;k=this.points[c[0]];j=this.points[c[1]];
n=this.points[c[2]];l=this.points[c[3]];i=h*h;m=h*i;d.x=b(k.x,j.x,n.x,l.x,h,i,m);d.y=b(k.y,j.y,n.y,l.y,h,i,m);d.z=b(k.z,j.z,n.z,l.z,h,i,m);return d};this.getControlPointsArray=function(){var a,b,c=this.points.length,d=[];for(a=0;a<c;a++)b=this.points[a],d[a]=[b.x,b.y,b.z];return d};this.getLength=function(a){var b,c,d,e=b=b=0,g=new THREE.Vector3,h=new THREE.Vector3,i=[],j=0;i[0]=0;a||(a=100);c=this.points.length*a;g.copy(this.points[0]);for(a=1;a<c;a++)b=a/c,d=this.getPoint(b),h.copy(d),j+=h.distanceTo(g),
g.copy(d),b*=this.points.length-1,b=Math.floor(b),b!=e&&(i[b]=j,e=b);i[i.length]=j;return{chunks:i,total:j}};this.reparametrizeByArcLength=function(a){var b,c,d,e,g,h,i=[],j=new THREE.Vector3,k=this.getLength();i.push(j.copy(this.points[0]).clone());for(b=1;b<this.points.length;b++){c=k.chunks[b]-k.chunks[b-1];h=Math.ceil(a*c/k.total);e=(b-1)/(this.points.length-1);g=b/(this.points.length-1);for(c=1;c<h-1;c++)d=e+c*(1/h)*(g-e),d=this.getPoint(d),i.push(j.copy(d).clone());i.push(j.copy(this.points[b]).clone())}this.points=
i}};THREE.Camera=function(){THREE.Object3D.call(this);this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=new THREE.Matrix4;this.projectionMatrixInverse=new THREE.Matrix4};THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;THREE.Camera.prototype.lookAt=function(a){this.matrix.lookAt(this.position,a,this.up);this.rotationAutoUpdate&&this.rotation.getRotationFromMatrix(this.matrix)};
THREE.OrthographicCamera=function(a,b,c,d,e,g){THREE.Camera.call(this);this.left=a;this.right=b;this.top=c;this.bottom=d;this.near=void 0!==e?e:0.1;this.far=void 0!==g?g:2E3;this.updateProjectionMatrix()};THREE.OrthographicCamera.prototype=new THREE.Camera;THREE.OrthographicCamera.prototype.constructor=THREE.OrthographicCamera;THREE.OrthographicCamera.prototype.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makeOrtho(this.left,this.right,this.top,this.bottom,this.near,this.far)};
THREE.PerspectiveCamera=function(a,b,c,d){THREE.Camera.call(this);this.fov=void 0!==a?a:50;this.aspect=void 0!==b?b:1;this.near=void 0!==c?c:0.1;this.far=void 0!==d?d:2E3;this.updateProjectionMatrix()};THREE.PerspectiveCamera.prototype=new THREE.Camera;THREE.PerspectiveCamera.prototype.constructor=THREE.PerspectiveCamera;THREE.PerspectiveCamera.prototype.setLens=function(a,b){this.fov=2*Math.atan((void 0!==b?b:24)/(2*a))*(180/Math.PI);this.updateProjectionMatrix()};
THREE.PerspectiveCamera.prototype.setViewOffset=function(a,b,c,d,e,g){this.fullWidth=a;this.fullHeight=b;this.x=c;this.y=d;this.width=e;this.height=g;this.updateProjectionMatrix()};
THREE.PerspectiveCamera.prototype.updateProjectionMatrix=function(){if(this.fullWidth){var a=this.fullWidth/this.fullHeight,b=Math.tan(this.fov*Math.PI/360)*this.near,c=-b,d=a*c,a=Math.abs(a*b-d),c=Math.abs(b-c);this.projectionMatrix=THREE.Matrix4.makeFrustum(d+this.x*a/this.fullWidth,d+(this.x+this.width)*a/this.fullWidth,b-(this.y+this.height)*c/this.fullHeight,b-this.y*c/this.fullHeight,this.near,this.far)}else this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,
this.far)};THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;
THREE.DirectionalLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.target=new THREE.Object3D;this.intensity=void 0!==b?b:1;this.distance=void 0!==c?c:0;this.onlyShadow=this.castShadow=!1;this.shadowCameraNear=50;this.shadowCameraFar=5E3;this.shadowCameraLeft=-500;this.shadowCameraTop=this.shadowCameraRight=500;this.shadowCameraBottom=-500;this.shadowCameraVisible=!1;this.shadowBias=0;this.shadowDarkness=0.5;this.shadowMapHeight=this.shadowMapWidth=512;this.shadowCascade=
!1;this.shadowCascadeOffset=new THREE.Vector3(0,0,-1E3);this.shadowCascadeCount=2;this.shadowCascadeBias=[0,0,0];this.shadowCascadeWidth=[512,512,512];this.shadowCascadeHeight=[512,512,512];this.shadowCascadeNearZ=[-1,0.99,0.998];this.shadowCascadeFarZ=[0.99,0.998,1];this.shadowCascadeArray=[];this.shadowMatrix=this.shadowCamera=this.shadowMapSize=this.shadowMap=null};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;
THREE.PointLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,0,0);this.intensity=void 0!==b?b:1;this.distance=void 0!==c?c:0};THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;
THREE.SpotLight=function(a,b,c,d){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.target=new THREE.Object3D;this.intensity=void 0!==b?b:1;this.distance=void 0!==c?c:0;this.castShadow=void 0!==d?d:!1;this.onlyShadow=!1;this.shadowCameraNear=50;this.shadowCameraFar=5E3;this.shadowCameraFov=50;this.shadowCameraVisible=!1;this.shadowBias=0;this.shadowDarkness=0.5;this.shadowMapHeight=this.shadowMapWidth=512;this.shadowMatrix=this.shadowCamera=this.shadowMapSize=this.shadowMap=null};
THREE.SpotLight.prototype=new THREE.Light;THREE.SpotLight.prototype.constructor=THREE.SpotLight;
THREE.Material=function(a){a=a||{};this.id=THREE.MaterialCount++;this.name="";this.opacity=void 0!==a.opacity?a.opacity:1;this.transparent=void 0!==a.transparent?a.transparent:!1;this.blending=void 0!==a.blending?a.blending:THREE.NormalBlending;this.depthTest=void 0!==a.depthTest?a.depthTest:!0;this.depthWrite=void 0!==a.depthWrite?a.depthWrite:!0;this.polygonOffset=void 0!==a.polygonOffset?a.polygonOffset:!1;this.polygonOffsetFactor=void 0!==a.polygonOffsetFactor?a.polygonOffsetFactor:0;this.polygonOffsetUnits=
void 0!==a.polygonOffsetUnits?a.polygonOffsetUnits:0;this.alphaTest=void 0!==a.alphaTest?a.alphaTest:0;this.overdraw=void 0!==a.overdraw?a.overdraw:!1};THREE.MaterialCount=0;THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NoBlending=0;THREE.NormalBlending=1;THREE.AdditiveBlending=2;THREE.SubtractiveBlending=3;THREE.MultiplyBlending=4;THREE.AdditiveAlphaBlending=5;
THREE.LineBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.linewidth=void 0!==a.linewidth?a.linewidth:1;this.linecap=void 0!==a.linecap?a.linecap:"round";this.linejoin=void 0!==a.linejoin?a.linejoin:"round";this.vertexColors=a.vertexColors?a.vertexColors:!1;this.fog=void 0!==a.fog?a.fog:!0};THREE.LineBasicMaterial.prototype=new THREE.Material;THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.map=void 0!==a.map?a.map:null;this.lightMap=void 0!==a.lightMap?a.lightMap:null;this.envMap=void 0!==a.envMap?a.envMap:null;this.combine=void 0!==a.combine?a.combine:THREE.MultiplyOperation;this.reflectivity=void 0!==a.reflectivity?a.reflectivity:1;this.refractionRatio=void 0!==a.refractionRatio?a.refractionRatio:0.98;this.fog=void 0!==a.fog?a.fog:
!0;this.shading=void 0!==a.shading?a.shading:THREE.SmoothShading;this.wireframe=void 0!==a.wireframe?a.wireframe:!1;this.wireframeLinewidth=void 0!==a.wireframeLinewidth?a.wireframeLinewidth:1;this.wireframeLinecap=void 0!==a.wireframeLinecap?a.wireframeLinecap:"round";this.wireframeLinejoin=void 0!==a.wireframeLinejoin?a.wireframeLinejoin:"round";this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.skinning=void 0!==a.skinning?a.skinning:!1;this.morphTargets=void 0!==a.morphTargets?a.morphTargets:
!1};THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=void 0!==a.ambient?new THREE.Color(a.ambient):new THREE.Color(16777215);this.wrapAround=void 0!==a.wrapAround?a.wrapAround:!1;this.wrapRGB=new THREE.Vector3(1,1,1);this.map=void 0!==a.map?a.map:null;this.lightMap=void 0!==a.lightMap?a.lightMap:null;this.envMap=void 0!==a.envMap?a.envMap:null;this.combine=void 0!==a.combine?a.combine:
THREE.MultiplyOperation;this.reflectivity=void 0!==a.reflectivity?a.reflectivity:1;this.refractionRatio=void 0!==a.refractionRatio?a.refractionRatio:0.98;this.fog=void 0!==a.fog?a.fog:!0;this.shading=void 0!==a.shading?a.shading:THREE.SmoothShading;this.wireframe=void 0!==a.wireframe?a.wireframe:!1;this.wireframeLinewidth=void 0!==a.wireframeLinewidth?a.wireframeLinewidth:1;this.wireframeLinecap=void 0!==a.wireframeLinecap?a.wireframeLinecap:"round";this.wireframeLinejoin=void 0!==a.wireframeLinejoin?
a.wireframeLinejoin:"round";this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.skinning=void 0!==a.skinning?a.skinning:!1;this.morphTargets=void 0!==a.morphTargets?a.morphTargets:!1;this.morphNormals=void 0!==a.morphNormals?a.morphNormals:!1};THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=void 0!==a.ambient?new THREE.Color(a.ambient):new THREE.Color(16777215);this.specular=void 0!==a.specular?new THREE.Color(a.specular):new THREE.Color(1118481);this.shininess=void 0!==a.shininess?a.shininess:30;this.metal=void 0!==a.metal?a.metal:!1;this.perPixel=void 0!==a.perPixel?a.perPixel:!1;this.wrapAround=void 0!==a.wrapAround?a.wrapAround:
!1;this.wrapRGB=new THREE.Vector3(1,1,1);this.map=void 0!==a.map?a.map:null;this.lightMap=void 0!==a.lightMap?a.lightMap:null;this.envMap=void 0!==a.envMap?a.envMap:null;this.combine=void 0!==a.combine?a.combine:THREE.MultiplyOperation;this.reflectivity=void 0!==a.reflectivity?a.reflectivity:1;this.refractionRatio=void 0!==a.refractionRatio?a.refractionRatio:0.98;this.fog=void 0!==a.fog?a.fog:!0;this.shading=void 0!==a.shading?a.shading:THREE.SmoothShading;this.wireframe=void 0!==a.wireframe?a.wireframe:
!1;this.wireframeLinewidth=void 0!==a.wireframeLinewidth?a.wireframeLinewidth:1;this.wireframeLinecap=void 0!==a.wireframeLinecap?a.wireframeLinecap:"round";this.wireframeLinejoin=void 0!==a.wireframeLinejoin?a.wireframeLinejoin:"round";this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.skinning=void 0!==a.skinning?a.skinning:!1;this.morphTargets=void 0!==a.morphTargets?a.morphTargets:!1;this.morphNormals=void 0!==a.morphNormals?a.morphNormals:!1};THREE.MeshPhongMaterial.prototype=new THREE.Material;
THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;THREE.MeshDepthMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=void 0!==a.shading?a.shading:THREE.SmoothShading;this.wireframe=void 0!==a.wireframe?a.wireframe:!1;this.wireframeLinewidth=void 0!==a.wireframeLinewidth?a.wireframeLinewidth:1};THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;
THREE.MeshNormalMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading?a.shading:THREE.FlatShading;this.wireframe=a.wireframe?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth?a.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshFaceMaterial=function(){};
THREE.ParticleBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.map=void 0!==a.map?a.map:null;this.size=void 0!==a.size?a.size:1;this.sizeAttenuation=void 0!==a.sizeAttenuation?a.sizeAttenuation:!0;this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.fog=void 0!==a.fog?a.fog:!0};THREE.ParticleBasicMaterial.prototype=new THREE.Material;THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.ShaderMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.fragmentShader=void 0!==a.fragmentShader?a.fragmentShader:"void main() {}";this.vertexShader=void 0!==a.vertexShader?a.vertexShader:"void main() {}";this.uniforms=void 0!==a.uniforms?a.uniforms:{};this.attributes=a.attributes;this.shading=void 0!==a.shading?a.shading:THREE.SmoothShading;this.wireframe=void 0!==a.wireframe?a.wireframe:!1;this.wireframeLinewidth=void 0!==a.wireframeLinewidth?a.wireframeLinewidth:1;this.fog=void 0!==
a.fog?a.fog:!1;this.lights=void 0!==a.lights?a.lights:!1;this.vertexColors=void 0!==a.vertexColors?a.vertexColors:!1;this.skinning=void 0!==a.skinning?a.skinning:!1;this.morphTargets=void 0!==a.morphTargets?a.morphTargets:!1};THREE.ShaderMaterial.prototype=new THREE.Material;THREE.ShaderMaterial.prototype.constructor=THREE.ShaderMaterial;
THREE.Texture=function(a,b,c,d,e,g,h,i){this.id=THREE.TextureCount++;this.image=a;this.mapping=void 0!==b?b:new THREE.UVMapping;this.wrapS=void 0!==c?c:THREE.ClampToEdgeWrapping;this.wrapT=void 0!==d?d:THREE.ClampToEdgeWrapping;this.magFilter=void 0!==e?e:THREE.LinearFilter;this.minFilter=void 0!==g?g:THREE.LinearMipMapLinearFilter;this.format=void 0!==h?h:THREE.RGBAFormat;this.type=void 0!==i?i:THREE.UnsignedByteType;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.generateMipmaps=
!0;this.needsUpdate=!1;this.onUpdate=null};THREE.Texture.prototype={constructor:THREE.Texture,clone:function(){var a=new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter,this.format,this.type);a.offset.copy(this.offset);a.repeat.copy(this.repeat);return a}};THREE.TextureCount=0;THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};
THREE.LatitudeRefractionMapping=function(){};THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;THREE.ShortType=11;
THREE.UnsignedShortType=12;THREE.IntType=13;THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;THREE.DataTexture=function(a,b,c,d,e,g,h,i,m,k){THREE.Texture.call(this,null,g,h,i,m,k,d,e);this.image={data:a,width:b,height:c}};THREE.DataTexture.prototype=new THREE.Texture;THREE.DataTexture.prototype.constructor=THREE.DataTexture;
THREE.DataTexture.prototype.clone=function(){var a=new THREE.DataTexture(this.image.data,this.image.width,this.image.height,this.format,this.type,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter);a.offset.copy(this.offset);a.repeat.copy(this.repeat);return a};THREE.Particle=function(a){THREE.Object3D.call(this);this.material=a};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;
THREE.ParticleSystem=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.material=void 0!==b?b:new THREE.ParticleBasicMaterial({color:16777215*Math.random()});this.sortParticles=!1;if(this.geometry)this.geometry.boundingSphere||this.geometry.computeBoundingSphere(),this.boundRadius=a.boundingSphere.radius;this.frustumCulled=!1};THREE.ParticleSystem.prototype=new THREE.Object3D;THREE.ParticleSystem.prototype.constructor=THREE.ParticleSystem;
THREE.Line=function(a,b,c){THREE.Object3D.call(this);this.geometry=a;this.material=void 0!==b?b:new THREE.LineBasicMaterial({color:16777215*Math.random()});this.type=void 0!==c?c:THREE.LineStrip;this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere())};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.material=void 0!==b?b:new THREE.MeshBasicMaterial({color:16777215*Math.random(),wireframe:!0});if(this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere(),this.boundRadius=a.boundingSphere.radius,this.geometry.morphTargets.length)){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var c=0;c<this.geometry.morphTargets.length;c++)this.morphTargetInfluences.push(0),
this.morphTargetDictionary[this.geometry.morphTargets[c].name]=c}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;THREE.Mesh.prototype.getMorphTargetIndexByName=function(a){if(void 0!==this.morphTargetDictionary[a])return this.morphTargetDictionary[a];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+a+" does not exist. Returning 0.");return 0};
THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,b){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixWorldNeedsUpdate)a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,b=!0;var c,d=this.children.length;for(c=0;c<d;c++)this.children[c].update(this.skinMatrix,b)};
THREE.SkinnedMesh=function(a,b){THREE.Mesh.call(this,a,b);this.identityMatrix=new THREE.Matrix4;this.bones=[];this.boneMatrices=[];var c,d,e,g,h,i;if(void 0!==this.geometry.bones){for(c=0;c<this.geometry.bones.length;c++)e=this.geometry.bones[c],g=e.pos,h=e.rotq,i=e.scl,d=this.addBone(),d.name=e.name,d.position.set(g[0],g[1],g[2]),d.quaternion.set(h[0],h[1],h[2],h[3]),d.useQuaternion=!0,void 0!==i?d.scale.set(i[0],i[1],i[2]):d.scale.set(1,1,1);for(c=0;c<this.bones.length;c++)e=this.geometry.bones[c],
d=this.bones[c],-1===e.parent?this.add(d):this.bones[e.parent].add(d);this.boneMatrices=new Float32Array(16*this.bones.length);this.pose()}};THREE.SkinnedMesh.prototype=new THREE.Mesh;THREE.SkinnedMesh.prototype.constructor=THREE.SkinnedMesh;THREE.SkinnedMesh.prototype.addBone=function(a){void 0===a&&(a=new THREE.Bone(this));this.bones.push(a);return a};
THREE.SkinnedMesh.prototype.updateMatrixWorld=function(a){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||a)this.parent?this.matrixWorld.multiply(this.parent.matrixWorld,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=!1;for(var a=0,b=this.children.length;a<b;a++){var c=this.children[a];c instanceof THREE.Bone?c.update(this.identityMatrix,!1):c.updateMatrixWorld(!0)}for(var b=this.bones.length,c=this.bones,d=this.boneMatrices,a=0;a<b;a++)c[a].skinMatrix.flattenToArrayOffset(d,
16*a)};
THREE.SkinnedMesh.prototype.pose=function(){this.updateMatrixWorld(!0);for(var a,b=[],c=0;c<this.bones.length;c++){a=this.bones[c];var d=new THREE.Matrix4;d.getInverse(a.skinMatrix);b.push(d);a.skinMatrix.flattenToArrayOffset(this.boneMatrices,16*c)}if(void 0===this.geometry.skinVerticesA){this.geometry.skinVerticesA=[];this.geometry.skinVerticesB=[];for(a=0;a<this.geometry.skinIndices.length;a++){var c=this.geometry.vertices[a].position,e=this.geometry.skinIndices[a].x,g=this.geometry.skinIndices[a].y,d=
new THREE.Vector3(c.x,c.y,c.z);this.geometry.skinVerticesA.push(b[e].multiplyVector3(d));d=new THREE.Vector3(c.x,c.y,c.z);this.geometry.skinVerticesB.push(b[g].multiplyVector3(d));1!==this.geometry.skinWeights[a].x+this.geometry.skinWeights[a].y&&(c=0.5*(1-(this.geometry.skinWeights[a].x+this.geometry.skinWeights[a].y)),this.geometry.skinWeights[a].x+=c,this.geometry.skinWeights[a].y+=c)}}};THREE.Ribbon=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.material=b};
THREE.Ribbon.prototype=new THREE.Object3D;THREE.Ribbon.prototype.constructor=THREE.Ribbon;THREE.LOD=function(){THREE.Object3D.call(this);this.LODs=[]};THREE.LOD.prototype=new THREE.Object3D;THREE.LOD.prototype.constructor=THREE.LOD;THREE.LOD.prototype.supr=THREE.Object3D.prototype;THREE.LOD.prototype.addLevel=function(a,b){void 0===b&&(b=0);for(var b=Math.abs(b),c=0;c<this.LODs.length&&!(b<this.LODs[c].visibleAtDistance);c++);this.LODs.splice(c,0,{visibleAtDistance:b,object3D:a});this.add(a)};
THREE.LOD.prototype.update=function(a){if(1<this.LODs.length){a.matrixWorldInverse.getInverse(a.matrixWorld);a=a.matrixWorldInverse;a=-(a.n31*this.matrixWorld.n14+a.n32*this.matrixWorld.n24+a.n33*this.matrixWorld.n34+a.n34);this.LODs[0].object3D.visible=!0;for(var b=1;b<this.LODs.length;b++)if(a>=this.LODs[b].visibleAtDistance)this.LODs[b-1].object3D.visible=!1,this.LODs[b].object3D.visible=!0;else break;for(;b<this.LODs.length;b++)this.LODs[b].object3D.visible=!1}};
THREE.Sprite=function(a){THREE.Object3D.call(this);this.color=void 0!==a.color?new THREE.Color(a.color):new THREE.Color(16777215);this.map=void 0!==a.map?a.map:new THREE.Texture;this.blending=void 0!==a.blending?a.blending:THREE.NormalBlending;this.useScreenCoordinates=void 0!==a.useScreenCoordinates?a.useScreenCoordinates:!0;this.mergeWith3D=void 0!==a.mergeWith3D?a.mergeWith3D:!this.useScreenCoordinates;this.affectedByDistance=void 0!==a.affectedByDistance?a.affectedByDistance:!this.useScreenCoordinates;
this.scaleByViewport=void 0!==a.scaleByViewport?a.scaleByViewport:!this.affectedByDistance;this.alignment=a.alignment instanceof THREE.Vector2?a.alignment:THREE.SpriteAlignment.center;this.rotation3d=this.rotation;this.rotation=0;this.opacity=1;this.uvOffset=new THREE.Vector2(0,0);this.uvScale=new THREE.Vector2(1,1)};THREE.Sprite.prototype=new THREE.Object3D;THREE.Sprite.prototype.constructor=THREE.Sprite;
THREE.Sprite.prototype.updateMatrix=function(){this.matrix.setPosition(this.position);this.rotation3d.set(0,0,this.rotation);this.matrix.setRotationFromEuler(this.rotation3d);if(1!==this.scale.x||1!==this.scale.y)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,this.scale.y);this.matrixWorldNeedsUpdate=!0};THREE.SpriteAlignment={};THREE.SpriteAlignment.topLeft=new THREE.Vector2(1,-1);THREE.SpriteAlignment.topCenter=new THREE.Vector2(0,-1);
THREE.SpriteAlignment.topRight=new THREE.Vector2(-1,-1);THREE.SpriteAlignment.centerLeft=new THREE.Vector2(1,0);THREE.SpriteAlignment.center=new THREE.Vector2(0,0);THREE.SpriteAlignment.centerRight=new THREE.Vector2(-1,0);THREE.SpriteAlignment.bottomLeft=new THREE.Vector2(1,1);THREE.SpriteAlignment.bottomCenter=new THREE.Vector2(0,1);THREE.SpriteAlignment.bottomRight=new THREE.Vector2(-1,1);
THREE.Scene=function(){THREE.Object3D.call(this);this.overrideMaterial=this.fog=null;this.matrixAutoUpdate=!1;this.__objects=[];this.__lights=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;
THREE.Scene.prototype.__addObject=function(a){if(a instanceof THREE.Light)-1===this.__lights.indexOf(a)&&this.__lights.push(a);else if(!(a instanceof THREE.Camera||a instanceof THREE.Bone)&&-1===this.__objects.indexOf(a)){this.__objects.push(a);this.__objectsAdded.push(a);var b=this.__objectsRemoved.indexOf(a);-1!==b&&this.__objectsRemoved.splice(b,1)}for(b=0;b<a.children.length;b++)this.__addObject(a.children[b])};
THREE.Scene.prototype.__removeObject=function(a){if(a instanceof THREE.Light){var b=this.__lights.indexOf(a);-1!==b&&this.__lights.splice(b,1)}else a instanceof THREE.Camera||(b=this.__objects.indexOf(a),-1!==b&&(this.__objects.splice(b,1),this.__objectsRemoved.push(a),b=this.__objectsAdded.indexOf(a),-1!==b&&this.__objectsAdded.splice(b,1)));for(b=0;b<a.children.length;b++)this.__removeObject(a.children[b])};
THREE.Fog=function(a,b,c){this.color=new THREE.Color(a);this.near=void 0!==b?b:1;this.far=void 0!==c?c:1E3};THREE.FogExp2=function(a,b){this.color=new THREE.Color(a);this.density=void 0!==b?b:2.5E-4};
THREE.ShaderChunk={fog_pars_fragment:"#ifdef USE_FOG\nuniform vec3 fogColor;\n#ifdef FOG_EXP2\nuniform float fogDensity;\n#else\nuniform float fogNear;\nuniform float fogFar;\n#endif\n#endif",fog_fragment:"#ifdef USE_FOG\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\n#ifdef FOG_EXP2\nconst float LOG2 = 1.442695;\nfloat fogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );\nfogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );\n#else\nfloat fogFactor = smoothstep( fogNear, fogFar, depth );\n#endif\ngl_FragColor = mix( gl_FragColor, vec4( fogColor, gl_FragColor.w ), fogFactor );\n#endif",envmap_pars_fragment:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float reflectivity;\nuniform samplerCube envMap;\nuniform float flipEnvMap;\nuniform int combine;\n#endif",
envmap_fragment:"#ifdef USE_ENVMAP\n#ifdef DOUBLE_SIDED\nfloat flipNormal = ( -1.0 + 2.0 * float( gl_FrontFacing ) );\nvec4 cubeColor = textureCube( envMap, flipNormal * vec3( flipEnvMap * vReflect.x, vReflect.yz ) );\n#else\nvec4 cubeColor = textureCube( envMap, vec3( flipEnvMap * vReflect.x, vReflect.yz ) );\n#endif\n#ifdef GAMMA_INPUT\ncubeColor.xyz *= cubeColor.xyz;\n#endif\nif ( combine == 1 ) {\ngl_FragColor.xyz = mix( gl_FragColor.xyz, cubeColor.xyz, reflectivity );\n} else {\ngl_FragColor.xyz = gl_FragColor.xyz * cubeColor.xyz;\n}\n#endif",
envmap_pars_vertex:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float refractionRatio;\nuniform bool useRefract;\n#endif",envmap_vertex:"#ifdef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = mat3( objectMatrix[ 0 ].xyz, objectMatrix[ 1 ].xyz, objectMatrix[ 2 ].xyz ) * normal;\nif ( useRefract ) {\nvReflect = refract( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ), refractionRatio );\n} else {\nvReflect = reflect( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ) );\n}\n#endif",
map_particle_pars_fragment:"#ifdef USE_MAP\nuniform sampler2D map;\n#endif",map_particle_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, gl_PointCoord );\n#endif",map_pars_vertex:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform vec4 offsetRepeat;\n#endif",map_pars_fragment:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform sampler2D map;\n#endif",map_vertex:"#ifdef USE_MAP\nvUv = uv * offsetRepeat.zw + offsetRepeat.xy;\n#endif",map_fragment:"#ifdef USE_MAP\n#ifdef GAMMA_INPUT\nvec4 texelColor = texture2D( map, vUv );\ntexelColor.xyz *= texelColor.xyz;\ngl_FragColor = gl_FragColor * texelColor;\n#else\ngl_FragColor = gl_FragColor * texture2D( map, vUv );\n#endif\n#endif",
lightmap_pars_fragment:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\nuniform sampler2D lightMap;\n#endif",lightmap_pars_vertex:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\n#endif",lightmap_fragment:"#ifdef USE_LIGHTMAP\ngl_FragColor = gl_FragColor * texture2D( lightMap, vUv2 );\n#endif",lightmap_vertex:"#ifdef USE_LIGHTMAP\nvUv2 = uv2;\n#endif",lights_lambert_pars_vertex:"uniform vec3 ambient;\nuniform vec3 diffuse;\nuniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\n#endif\n#ifdef WRAP_AROUND\nuniform vec3 wrapRGB;\n#endif",
lights_lambert_vertex:"vLightFront = vec3( 0.0 );\n#ifdef DOUBLE_SIDED\nvLightBack = vec3( 0.0 );\n#endif\ntransformedNormal = normalize( transformedNormal );\n#if MAX_DIR_LIGHTS > 0\nfor( int i = 0; i < MAX_DIR_LIGHTS; i ++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nfloat dotProduct = dot( transformedNormal, dirVector );\nvec3 directionalLightWeighting = vec3( max( dotProduct, 0.0 ) );\n#ifdef DOUBLE_SIDED\nvec3 directionalLightWeightingBack = vec3( max( -dotProduct, 0.0 ) );\n#ifdef WRAP_AROUND\nvec3 directionalLightWeightingHalfBack = vec3( max( -0.5 * dotProduct + 0.5, 0.0 ) );\n#endif\n#endif\n#ifdef WRAP_AROUND\nvec3 directionalLightWeightingHalf = vec3( max( 0.5 * dotProduct + 0.5, 0.0 ) );\ndirectionalLightWeighting = mix( directionalLightWeighting, directionalLightWeightingHalf, wrapRGB );\n#ifdef DOUBLE_SIDED\ndirectionalLightWeightingBack = mix( directionalLightWeightingBack, directionalLightWeightingHalfBack, wrapRGB );\n#endif\n#endif\nvLightFront += directionalLightColor[ i ] * directionalLightWeighting;\n#ifdef DOUBLE_SIDED\nvLightBack += directionalLightColor[ i ] * directionalLightWeightingBack;\n#endif\n}\n#endif\n#if MAX_POINT_LIGHTS > 0\nfor( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz - mvPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nlVector = normalize( lVector );\nfloat dotProduct = dot( transformedNormal, lVector );\nvec3 pointLightWeighting = vec3( max( dotProduct, 0.0 ) );\n#ifdef DOUBLE_SIDED\nvec3 pointLightWeightingBack = vec3( max( -dotProduct, 0.0 ) );\n#ifdef WRAP_AROUND\nvec3 pointLightWeightingHalfBack = vec3( max( -0.5 * dotProduct + 0.5, 0.0 ) );\n#endif\n#endif\n#ifdef WRAP_AROUND\nvec3 pointLightWeightingHalf = vec3( max( 0.5 * dotProduct + 0.5, 0.0 ) );\npointLightWeighting = mix( pointLightWeighting, pointLightWeightingHalf, wrapRGB );\n#ifdef DOUBLE_SIDED\npointLightWeightingBack = mix( pointLightWeightingBack, pointLightWeightingHalfBack, wrapRGB );\n#endif\n#endif\nvLightFront += pointLightColor[ i ] * pointLightWeighting * lDistance;\n#ifdef DOUBLE_SIDED\nvLightBack += pointLightColor[ i ] * pointLightWeightingBack * lDistance;\n#endif\n}\n#endif\nvLightFront = vLightFront * diffuse + ambient * ambientLightColor;\n#ifdef DOUBLE_SIDED\nvLightBack = vLightBack * diffuse + ambient * ambientLightColor;\n#endif",
lights_phong_pars_vertex:"#if MAX_POINT_LIGHTS > 0\n#ifndef PHONG_PER_PIXEL\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\n#endif",lights_phong_vertex:"#if MAX_POINT_LIGHTS > 0\n#ifndef PHONG_PER_PIXEL\nfor( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz - mvPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nvPointLight[ i ] = vec4( lVector, lDistance );\n}\n#endif\n#endif",
lights_phong_pars_fragment:"uniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\n#ifdef PHONG_PER_PIXEL\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\n#else\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\n#endif\n#ifdef WRAP_AROUND\nuniform vec3 wrapRGB;\n#endif\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",
lights_phong_fragment:"vec3 normal = normalize( vNormal );\nvec3 viewPosition = normalize( vViewPosition );\n#ifdef DOUBLE_SIDED\nnormal = normal * ( -1.0 + 2.0 * float( gl_FrontFacing ) );\n#endif\n#if MAX_POINT_LIGHTS > 0\nvec3 pointDiffuse  = vec3( 0.0 );\nvec3 pointSpecular = vec3( 0.0 );\nfor ( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\n#ifdef PHONG_PER_PIXEL\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz + vViewPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nlVector = normalize( lVector );\n#else\nvec3 lVector = normalize( vPointLight[ i ].xyz );\nfloat lDistance = vPointLight[ i ].w;\n#endif\nfloat dotProduct = dot( normal, lVector );\n#ifdef WRAP_AROUND\nfloat pointDiffuseWeightFull = max( dotProduct, 0.0 );\nfloat pointDiffuseWeightHalf = max( 0.5 * dotProduct + 0.5, 0.0 );\nvec3 pointDiffuseWeight = mix( vec3 ( pointDiffuseWeightFull ), vec3( pointDiffuseWeightHalf ), wrapRGB );\n#else\nfloat pointDiffuseWeight = max( dotProduct, 0.0 );\n#endif\npointDiffuse  += diffuse * pointLightColor[ i ] * pointDiffuseWeight * lDistance;\nvec3 pointHalfVector = normalize( lVector + viewPosition );\nfloat pointDotNormalHalf = max( dot( normal, pointHalfVector ), 0.0 );\nfloat pointSpecularWeight = max( pow( pointDotNormalHalf, shininess ), 0.0 );\n#ifdef PHYSICALLY_BASED_SHADING\nvec3 schlick = specular + vec3( 1.0 - specular ) * pow( dot( lVector, pointHalfVector ), 5.0 );\npointSpecular += schlick * pointLightColor[ i ] * pointSpecularWeight * pointDiffuseWeight * lDistance;\n#else\npointSpecular += specular * pointLightColor[ i ] * pointSpecularWeight * pointDiffuseWeight * lDistance;\n#endif\n}\n#endif\n#if MAX_DIR_LIGHTS > 0\nvec3 dirDiffuse  = vec3( 0.0 );\nvec3 dirSpecular = vec3( 0.0 );\nfor( int i = 0; i < MAX_DIR_LIGHTS; i ++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nfloat dotProduct = dot( normal, dirVector );\n#ifdef WRAP_AROUND\nfloat dirDiffuseWeightFull = max( dotProduct, 0.0 );\nfloat dirDiffuseWeightHalf = max( 0.5 * dotProduct + 0.5, 0.0 );\nvec3 dirDiffuseWeight = mix( vec3( dirDiffuseWeightFull ), vec3( dirDiffuseWeightHalf ), wrapRGB );\n#else\nfloat dirDiffuseWeight = max( dotProduct, 0.0 );\n#endif\ndirDiffuse  += diffuse * directionalLightColor[ i ] * dirDiffuseWeight;\nvec3 dirHalfVector = normalize( dirVector + viewPosition );\nfloat dirDotNormalHalf = max( dot( normal, dirHalfVector ), 0.0 );\nfloat dirSpecularWeight = max( pow( dirDotNormalHalf, shininess ), 0.0 );\n#ifdef PHYSICALLY_BASED_SHADING\nvec3 schlick = specular + vec3( 1.0 - specular ) * pow( dot( dirVector, dirHalfVector ), 5.0 );\ndirSpecular += schlick * directionalLightColor[ i ] * dirSpecularWeight * dirDiffuseWeight;\n#else\ndirSpecular += specular * directionalLightColor[ i ] * dirSpecularWeight * dirDiffuseWeight;\n#endif\n}\n#endif\nvec3 totalDiffuse = vec3( 0.0 );\nvec3 totalSpecular = vec3( 0.0 );\n#if MAX_DIR_LIGHTS > 0\ntotalDiffuse += dirDiffuse;\ntotalSpecular += dirSpecular;\n#endif\n#if MAX_POINT_LIGHTS > 0\ntotalDiffuse += pointDiffuse;\ntotalSpecular += pointSpecular;\n#endif\n#ifdef METAL\ngl_FragColor.xyz = gl_FragColor.xyz * ( totalDiffuse + ambientLightColor * ambient + totalSpecular );\n#else\ngl_FragColor.xyz = gl_FragColor.xyz * ( totalDiffuse + ambientLightColor * ambient ) + totalSpecular;\n#endif",
color_pars_fragment:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_fragment:"#ifdef USE_COLOR\ngl_FragColor = gl_FragColor * vec4( vColor, opacity );\n#endif",color_pars_vertex:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_vertex:"#ifdef USE_COLOR\n#ifdef GAMMA_INPUT\nvColor = color * color;\n#else\nvColor = color;\n#endif\n#endif",skinning_pars_vertex:"#ifdef USE_SKINNING\nuniform mat4 boneGlobalMatrices[ MAX_BONES ];\n#endif",skinning_vertex:"#ifdef USE_SKINNING\ngl_Position  = ( boneGlobalMatrices[ int( skinIndex.x ) ] * skinVertexA ) * skinWeight.x;\ngl_Position += ( boneGlobalMatrices[ int( skinIndex.y ) ] * skinVertexB ) * skinWeight.y;\ngl_Position  = projectionMatrix * modelViewMatrix * gl_Position;\n#endif",
morphtarget_pars_vertex:"#ifdef USE_MORPHTARGETS\n#ifndef USE_MORPHNORMALS\nuniform float morphTargetInfluences[ 8 ];\n#else\nuniform float morphTargetInfluences[ 4 ];\n#endif\n#endif",morphtarget_vertex:"#ifdef USE_MORPHTARGETS\nvec3 morphed = vec3( 0.0 );\nmorphed += ( morphTarget0 - position ) * morphTargetInfluences[ 0 ];\nmorphed += ( morphTarget1 - position ) * morphTargetInfluences[ 1 ];\nmorphed += ( morphTarget2 - position ) * morphTargetInfluences[ 2 ];\nmorphed += ( morphTarget3 - position ) * morphTargetInfluences[ 3 ];\n#ifndef USE_MORPHNORMALS\nmorphed += ( morphTarget4 - position ) * morphTargetInfluences[ 4 ];\nmorphed += ( morphTarget5 - position ) * morphTargetInfluences[ 5 ];\nmorphed += ( morphTarget6 - position ) * morphTargetInfluences[ 6 ];\nmorphed += ( morphTarget7 - position ) * morphTargetInfluences[ 7 ];\n#endif\nmorphed += position;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( morphed, 1.0 );\n#endif",
default_vertex:"#ifndef USE_MORPHTARGETS\n#ifndef USE_SKINNING\ngl_Position = projectionMatrix * mvPosition;\n#endif\n#endif",morphnormal_vertex:"#ifdef USE_MORPHNORMALS\nvec3 morphedNormal = vec3( 0.0 );\nmorphedNormal +=  ( morphNormal0 - normal ) * morphTargetInfluences[ 0 ];\nmorphedNormal +=  ( morphNormal1 - normal ) * morphTargetInfluences[ 1 ];\nmorphedNormal +=  ( morphNormal2 - normal ) * morphTargetInfluences[ 2 ];\nmorphedNormal +=  ( morphNormal3 - normal ) * morphTargetInfluences[ 3 ];\nmorphedNormal += normal;\nvec3 transformedNormal = normalMatrix * morphedNormal;\n#else\nvec3 transformedNormal = normalMatrix * normal;\n#endif",
shadowmap_pars_fragment:"#ifdef USE_SHADOWMAP\nuniform sampler2D shadowMap[ MAX_SHADOWS ];\nuniform vec2 shadowMapSize[ MAX_SHADOWS ];\nuniform float shadowDarkness[ MAX_SHADOWS ];\nuniform float shadowBias[ MAX_SHADOWS ];\nvarying vec4 vShadowCoord[ MAX_SHADOWS ];\nfloat unpackDepth( const in vec4 rgba_depth ) {\nconst vec4 bit_shift = vec4( 1.0 / ( 256.0 * 256.0 * 256.0 ), 1.0 / ( 256.0 * 256.0 ), 1.0 / 256.0, 1.0 );\nfloat depth = dot( rgba_depth, bit_shift );\nreturn depth;\n}\n#endif",shadowmap_fragment:"#ifdef USE_SHADOWMAP\n#ifdef SHADOWMAP_DEBUG\nvec3 frustumColors[3];\nfrustumColors[0] = vec3( 1.0, 0.5, 0.0 );\nfrustumColors[1] = vec3( 0.0, 1.0, 0.8 );\nfrustumColors[2] = vec3( 0.0, 0.5, 1.0 );\n#endif\n#ifdef SHADOWMAP_CASCADE\nint inFrustumCount = 0;\n#endif\nfloat fDepth;\nvec3 shadowColor = vec3( 1.0 );\nfor( int i = 0; i < MAX_SHADOWS; i ++ ) {\nvec3 shadowCoord = vShadowCoord[ i ].xyz / vShadowCoord[ i ].w;\nbvec4 inFrustumVec = bvec4 ( shadowCoord.x >= 0.0, shadowCoord.x <= 1.0, shadowCoord.y >= 0.0, shadowCoord.y <= 1.0 );\nbool inFrustum = all( inFrustumVec );\n#ifdef SHADOWMAP_CASCADE\ninFrustumCount += int( inFrustum );\nbvec3 frustumTestVec = bvec3( inFrustum, inFrustumCount == 1, shadowCoord.z <= 1.0 );\n#else\nbvec2 frustumTestVec = bvec2( inFrustum, shadowCoord.z <= 1.0 );\n#endif\nbool frustumTest = all( frustumTestVec );\nif ( frustumTest ) {\nshadowCoord.z += shadowBias[ i ];\n#ifdef SHADOWMAP_SOFT\nfloat shadow = 0.0;\nconst float shadowDelta = 1.0 / 9.0;\nfloat xPixelOffset = 1.0 / shadowMapSize[ i ].x;\nfloat yPixelOffset = 1.0 / shadowMapSize[ i ].y;\nfloat dx0 = -1.25 * xPixelOffset;\nfloat dy0 = -1.25 * yPixelOffset;\nfloat dx1 = 1.25 * xPixelOffset;\nfloat dy1 = 1.25 * yPixelOffset;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx0, dy0 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( 0.0, dy0 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx1, dy0 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx0, 0.0 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx1, 0.0 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx0, dy1 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( 0.0, dy1 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nfDepth = unpackDepth( texture2D( shadowMap[ i ], shadowCoord.xy + vec2( dx1, dy1 ) ) );\nif ( fDepth < shadowCoord.z ) shadow += shadowDelta;\nshadowColor = shadowColor * vec3( ( 1.0 - shadowDarkness[ i ] * shadow ) );\n#else\nvec4 rgbaDepth = texture2D( shadowMap[ i ], shadowCoord.xy );\nfloat fDepth = unpackDepth( rgbaDepth );\nif ( fDepth < shadowCoord.z )\nshadowColor = shadowColor * vec3( 1.0 - shadowDarkness[ i ] );\n#endif\n}\n#ifdef SHADOWMAP_DEBUG\n#ifdef SHADOWMAP_CASCADE\nif ( inFrustum && inFrustumCount == 1 ) gl_FragColor.xyz *= frustumColors[ i ];\n#else\nif ( inFrustum ) gl_FragColor.xyz *= frustumColors[ i ];\n#endif\n#endif\n}\n#ifdef GAMMA_OUTPUT\nshadowColor *= shadowColor;\n#endif\ngl_FragColor.xyz = gl_FragColor.xyz * shadowColor;\n#endif",
shadowmap_pars_vertex:"#ifdef USE_SHADOWMAP\nvarying vec4 vShadowCoord[ MAX_SHADOWS ];\nuniform mat4 shadowMatrix[ MAX_SHADOWS ];\n#endif",shadowmap_vertex:"#ifdef USE_SHADOWMAP\nfor( int i = 0; i < MAX_SHADOWS; i ++ ) {\n#ifdef USE_MORPHTARGETS\nvShadowCoord[ i ] = shadowMatrix[ i ] * objectMatrix * vec4( morphed, 1.0 );\n#else\nvShadowCoord[ i ] = shadowMatrix[ i ] * objectMatrix * vec4( position, 1.0 );\n#endif\n}\n#endif",alphatest_fragment:"#ifdef ALPHATEST\nif ( gl_FragColor.a < ALPHATEST ) discard;\n#endif",
linear_to_gamma_fragment:"#ifdef GAMMA_OUTPUT\ngl_FragColor.xyz = sqrt( gl_FragColor.xyz );\n#endif"};
THREE.UniformsUtils={merge:function(a){var b,c,d,e={};for(b=0;b<a.length;b++)for(c in d=this.clone(a[b]),d)e[c]=d[c];return e},clone:function(a){var b,c,d,e={};for(b in a)for(c in e[b]={},a[b])d=a[b][c],e[b][c]=d instanceof THREE.Color||d instanceof THREE.Vector2||d instanceof THREE.Vector3||d instanceof THREE.Vector4||d instanceof THREE.Matrix4||d instanceof THREE.Texture?d.clone():d instanceof Array?d.slice():d;return e}};
THREE.UniformsLib={common:{diffuse:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},map:{type:"t",value:0,texture:null},offsetRepeat:{type:"v4",value:new THREE.Vector4(0,0,1,1)},lightMap:{type:"t",value:2,texture:null},envMap:{type:"t",value:1,texture:null},flipEnvMap:{type:"f",value:-1},useRefract:{type:"i",value:0},reflectivity:{type:"f",value:1},refractionRatio:{type:"f",value:0.98},combine:{type:"i",value:0},morphTargetInfluences:{type:"f",value:0}},fog:{fogDensity:{type:"f",
value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}},lights:{ambientLightColor:{type:"fv",value:[]},directionalLightDirection:{type:"fv",value:[]},directionalLightColor:{type:"fv",value:[]},pointLightColor:{type:"fv",value:[]},pointLightPosition:{type:"fv",value:[]},pointLightDistance:{type:"fv1",value:[]}},particle:{psColor:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},size:{type:"f",value:1},scale:{type:"f",
value:1},map:{type:"t",value:0,texture:null},fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}},shadowmap:{shadowMap:{type:"tv",value:6,texture:[]},shadowMapSize:{type:"v2v",value:[]},shadowBias:{type:"fv1",value:[]},shadowDarkness:{type:"fv1",value:[]},shadowMatrix:{type:"m4v",value:[]}}};
THREE.ShaderLib={depth:{uniforms:{mNear:{type:"f",value:1},mFar:{type:"f",value:2E3},opacity:{type:"f",value:1}},vertexShader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform float mNear;\nuniform float mFar;\nuniform float opacity;\nvoid main() {\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\nfloat color = 1.0 - smoothstep( mNear, mFar, depth );\ngl_FragColor = vec4( vec3( color ), opacity );\n}"},normal:{uniforms:{opacity:{type:"f",
value:1}},vertexShader:"varying vec3 vNormal;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\ngl_Position = projectionMatrix * mvPosition;\n}",fragmentShader:"uniform float opacity;\nvarying vec3 vNormal;\nvoid main() {\ngl_FragColor = vec4( 0.5 * normalize( vNormal ) + 0.5, opacity );\n}"},basic:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,THREE.UniformsLib.shadowmap]),vertexShader:[THREE.ShaderChunk.map_pars_vertex,
THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,
THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n"),fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.alphatest_fragment,
THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.linear_to_gamma_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n")},lambert:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,THREE.UniformsLib.lights,THREE.UniformsLib.shadowmap,{ambient:{type:"c",value:new THREE.Color(328965)},wrapRGB:{type:"v3",value:new THREE.Vector3(1,1,1)}}]),vertexShader:["varying vec3 vLightFront;\n#ifdef DOUBLE_SIDED\nvarying vec3 vLightBack;\n#endif",
THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_lambert_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,
THREE.ShaderChunk.morphnormal_vertex,THREE.ShaderChunk.lights_lambert_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n"),fragmentShader:["uniform float opacity;\nvarying vec3 vLightFront;\n#ifdef DOUBLE_SIDED\nvarying vec3 vLightBack;\n#endif",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,
THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( vec3 ( 1.0 ), opacity );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.alphatest_fragment,"#ifdef DOUBLE_SIDED\nif ( gl_FrontFacing )\ngl_FragColor.xyz *= vLightFront;\nelse\ngl_FragColor.xyz *= vLightBack;\n#else\ngl_FragColor.xyz *= vLightFront;\n#endif",THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.shadowmap_fragment,
THREE.ShaderChunk.linear_to_gamma_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n")},phong:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,THREE.UniformsLib.lights,THREE.UniformsLib.shadowmap,{ambient:{type:"c",value:new THREE.Color(328965)},specular:{type:"c",value:new THREE.Color(1118481)},shininess:{type:"f",value:30},wrapRGB:{type:"v3",value:new THREE.Vector3(1,1,1)}}]),vertexShader:["varying vec3 vViewPosition;\nvarying vec3 vNormal;",THREE.ShaderChunk.map_pars_vertex,
THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_phong_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,"#ifndef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\n#endif\nvViewPosition = -mvPosition.xyz;",
THREE.ShaderChunk.morphnormal_vertex,"vNormal = transformedNormal;",THREE.ShaderChunk.lights_phong_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n"),fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nuniform vec3 ambient;\nuniform vec3 specular;\nuniform float shininess;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,
THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.lights_phong_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( vec3 ( 1.0 ), opacity );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.alphatest_fragment,THREE.ShaderChunk.lights_phong_fragment,THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.linear_to_gamma_fragment,
THREE.ShaderChunk.fog_fragment,"}"].join("\n")},particle_basic:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.particle,THREE.UniformsLib.shadowmap]),vertexShader:["uniform float size;\nuniform float scale;",THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {",THREE.ShaderChunk.color_vertex,"vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\n#ifdef USE_SIZEATTENUATION\ngl_PointSize = size * ( scale / length( mvPosition.xyz ) );\n#else\ngl_PointSize = size;\n#endif\ngl_Position = projectionMatrix * mvPosition;",
THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n"),fragmentShader:["uniform vec3 psColor;\nuniform float opacity;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_particle_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( psColor, opacity );",THREE.ShaderChunk.map_particle_fragment,THREE.ShaderChunk.alphatest_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.fog_fragment,
"}"].join("\n")},depthRGBA:{uniforms:{},vertexShader:[THREE.ShaderChunk.morphtarget_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,"}"].join("\n"),fragmentShader:"vec4 pack_depth( const in float depth ) {\nconst vec4 bit_shift = vec4( 256.0 * 256.0 * 256.0, 256.0 * 256.0, 256.0, 1.0 );\nconst vec4 bit_mask  = vec4( 0.0, 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0 );\nvec4 res = fract( depth * bit_shift );\nres -= res.xxyz * bit_mask;\nreturn res;\n}\nvoid main() {\ngl_FragData[ 0 ] = pack_depth( gl_FragCoord.z );\n}"}};
THREE.WebGLRenderer=function(a){function b(a,b){var c=a.vertices.length,d=b.material;if(d.attributes){if(void 0===a.__webglCustomAttributesList)a.__webglCustomAttributesList=[];for(var e in d.attributes){var g=d.attributes[e];if(!g.__webglInitialized||g.createUniqueBuffers){g.__webglInitialized=!0;var h=1;"v2"===g.type?h=2:"v3"===g.type?h=3:"v4"===g.type?h=4:"c"===g.type&&(h=3);g.size=h;g.array=new Float32Array(c*h);g.buffer=f.createBuffer();g.buffer.belongsToAttribute=e;g.needsUpdate=!0}a.__webglCustomAttributesList.push(g)}}}
function c(a,b){if(a.material&&!(a.material instanceof THREE.MeshFaceMaterial))return a.material;if(0<=b.materialIndex)return a.geometry.materials[b.materialIndex]}function d(a){return a instanceof THREE.MeshBasicMaterial&&!a.envMap||a instanceof THREE.MeshDepthMaterial?!1:a&&void 0!==a.shading&&a.shading===THREE.SmoothShading?THREE.SmoothShading:THREE.FlatShading}function e(a){return a.map||a.lightMap||a instanceof THREE.ShaderMaterial?!0:!1}function g(a,b,c){var d,e,g,h,i=a.vertices;h=i.length;
var j=a.colors,k=j.length,m=a.__vertexArray,l=a.__colorArray,n=a.__sortArray,p=a.__dirtyVertices,o=a.__dirtyColors,q=a.__webglCustomAttributesList;if(c.sortParticles){Xa.multiplySelf(c.matrixWorld);for(d=0;d<h;d++)e=i[d].position,Na.copy(e),Xa.multiplyVector3(Na),n[d]=[Na.z,d];n.sort(function(a,b){return b[0]-a[0]});for(d=0;d<h;d++)e=i[n[d][1]].position,g=3*d,m[g]=e.x,m[g+1]=e.y,m[g+2]=e.z;for(d=0;d<k;d++)g=3*d,e=j[n[d][1]],l[g]=e.r,l[g+1]=e.g,l[g+2]=e.b;if(q)for(j=0,k=q.length;j<k;j++)if(i=q[j],
void 0===i.boundTo||"vertices"===i.boundTo)if(g=0,e=i.value.length,1===i.size)for(d=0;d<e;d++)h=n[d][1],i.array[d]=i.value[h];else if(2===i.size)for(d=0;d<e;d++)h=n[d][1],h=i.value[h],i.array[g]=h.x,i.array[g+1]=h.y,g+=2;else if(3===i.size)if("c"===i.type)for(d=0;d<e;d++)h=n[d][1],h=i.value[h],i.array[g]=h.r,i.array[g+1]=h.g,i.array[g+2]=h.b,g+=3;else for(d=0;d<e;d++)h=n[d][1],h=i.value[h],i.array[g]=h.x,i.array[g+1]=h.y,i.array[g+2]=h.z,g+=3;else if(4===i.size)for(d=0;d<e;d++)h=n[d][1],h=i.value[h],
i.array[g]=h.x,i.array[g+1]=h.y,i.array[g+2]=h.z,i.array[g+3]=h.w,g+=4}else{if(p)for(d=0;d<h;d++)e=i[d].position,g=3*d,m[g]=e.x,m[g+1]=e.y,m[g+2]=e.z;if(o)for(d=0;d<k;d++)e=j[d],g=3*d,l[g]=e.r,l[g+1]=e.g,l[g+2]=e.b;if(q)for(j=0,k=q.length;j<k;j++)if(i=q[j],i.needsUpdate&&(void 0===i.boundTo||"vertices"===i.boundTo))if(e=i.value.length,g=0,1===i.size)for(d=0;d<e;d++)i.array[d]=i.value[d];else if(2===i.size)for(d=0;d<e;d++)h=i.value[d],i.array[g]=h.x,i.array[g+1]=h.y,g+=2;else if(3===i.size)if("c"===
i.type)for(d=0;d<e;d++)h=i.value[d],i.array[g]=h.r,i.array[g+1]=h.g,i.array[g+2]=h.b,g+=3;else for(d=0;d<e;d++)h=i.value[d],i.array[g]=h.x,i.array[g+1]=h.y,i.array[g+2]=h.z,g+=3;else if(4===i.size)for(d=0;d<e;d++)h=i.value[d],i.array[g]=h.x,i.array[g+1]=h.y,i.array[g+2]=h.z,i.array[g+3]=h.w,g+=4}if(p||c.sortParticles)f.bindBuffer(f.ARRAY_BUFFER,a.__webglVertexBuffer),f.bufferData(f.ARRAY_BUFFER,m,b);if(o||c.sortParticles)f.bindBuffer(f.ARRAY_BUFFER,a.__webglColorBuffer),f.bufferData(f.ARRAY_BUFFER,
l,b);if(q)for(j=0,k=q.length;j<k;j++)if(i=q[j],i.needsUpdate||c.sortParticles)f.bindBuffer(f.ARRAY_BUFFER,i.buffer),f.bufferData(f.ARRAY_BUFFER,i.array,b)}function h(a,b){return b.z-a.z}function i(a,b,c){if(a.length)for(var d=0,f=a.length;d<f;d++)aa=Ba=null,sa=J=Ha=Ga=Aa=-1,a[d].render(b,c,lc,mc),aa=Ba=null,sa=J=Ha=Ga=Aa=-1}function m(a,b,c,d,f,e,g,h){var i,j,k,m;b?(j=a.length-1,m=b=-1):(j=0,b=a.length,m=1);for(var l=j;l!==b;l+=m)if(i=a[l],i.render){j=i.object;k=i.buffer;if(h)i=h;else{i=i[c];if(!i)continue;
g&&C.setBlending(i.blending);C.setDepthTest(i.depthTest);C.setDepthWrite(i.depthWrite);y(i.polygonOffset,i.polygonOffsetFactor,i.polygonOffsetUnits)}C.setObjectFaces(j);k instanceof THREE.BufferGeometry?C.renderBufferDirect(d,f,e,i,k,j):C.renderBuffer(d,f,e,i,k,j)}}function k(a,b,c,d,f,e,g){for(var h,i,j=0,k=a.length;j<k;j++)if(h=a[j],i=h.object,i.visible){if(g)h=g;else{h=h[b];if(!h)continue;e&&C.setBlending(h.blending);C.setDepthTest(h.depthTest);C.setDepthWrite(h.depthWrite);y(h.polygonOffset,h.polygonOffsetFactor,
h.polygonOffsetUnits)}C.renderImmediateObject(c,d,f,h,i)}}function j(a,b,c){a.push({buffer:b,object:c,opaque:null,transparent:null})}function n(a){for(var b in a.attributes)if(a.attributes[b].needsUpdate)return!0;return!1}function l(a){for(var b in a.attributes)a.attributes[b].needsUpdate=!1}function q(a,b){for(var c=a.length-1;0<=c;c--)a[c].object===b&&a.splice(c,1)}function o(a,b){for(var c=a.length-1;0<=c;c--)a[c]===b&&a.splice(c,1)}function p(a,b,c,d,e){d.program||C.initMaterial(d,b,c,e);if(d.morphTargets&&
!e.__webglMorphTargetInfluences){e.__webglMorphTargetInfluences=new Float32Array(C.maxMorphTargets);for(var g=0,h=C.maxMorphTargets;g<h;g++)e.__webglMorphTargetInfluences[g]=0}var i=!1,g=d.program,h=g.uniforms,j=d.uniforms;g!==Ba&&(f.useProgram(g),Ba=g,i=!0);if(d.id!==sa)sa=d.id,i=!0;if(i||a!==aa)f.uniformMatrix4fv(h.projectionMatrix,!1,a._projectionMatrixArray),a!==aa&&(aa=a);if(i){if(c&&d.fog)if(j.fogColor.value=c.color,c instanceof THREE.Fog)j.fogNear.value=c.near,j.fogFar.value=c.far;else if(c instanceof
THREE.FogExp2)j.fogDensity.value=c.density;if(d instanceof THREE.MeshPhongMaterial||d instanceof THREE.MeshLambertMaterial||d.lights){var k,l=0,m=0,n=0,p,o,q,s=nc,u=s.directional.colors,w=s.directional.positions,y=s.point.colors,A=s.point.positions,D=s.point.distances,L=0,M=0,J=q=0;for(c=0,i=b.length;c<i;c++)if(k=b[c],!k.onlyShadow)if(p=k.color,o=k.intensity,q=k.distance,k instanceof THREE.AmbientLight)C.gammaInput?(l+=p.r*p.r,m+=p.g*p.g,n+=p.b*p.b):(l+=p.r,m+=p.g,n+=p.b);else if(k instanceof THREE.DirectionalLight)q=
3*L,C.gammaInput?(u[q]=p.r*p.r*o*o,u[q+1]=p.g*p.g*o*o,u[q+2]=p.b*p.b*o*o):(u[q]=p.r*o,u[q+1]=p.g*o,u[q+2]=p.b*o),nb.copy(k.matrixWorld.getPosition()),nb.subSelf(k.target.matrixWorld.getPosition()),nb.normalize(),w[q]=nb.x,w[q+1]=nb.y,w[q+2]=nb.z,L+=1;else if(k instanceof THREE.PointLight||k instanceof THREE.SpotLight)J=3*M,C.gammaInput?(y[J]=p.r*p.r*o*o,y[J+1]=p.g*p.g*o*o,y[J+2]=p.b*p.b*o*o):(y[J]=p.r*o,y[J+1]=p.g*o,y[J+2]=p.b*o),k=k.matrixWorld.getPosition(),A[J]=k.x,A[J+1]=k.y,A[J+2]=k.z,D[M]=q,
M+=1;for(c=3*L,i=u.length;c<i;c++)u[c]=0;for(c=3*M,i=y.length;c<i;c++)y[c]=0;s.point.length=M;s.directional.length=L;s.ambient[0]=l;s.ambient[1]=m;s.ambient[2]=n;c=nc;j.ambientLightColor.value=c.ambient;j.directionalLightColor.value=c.directional.colors;j.directionalLightDirection.value=c.directional.positions;j.pointLightColor.value=c.point.colors;j.pointLightPosition.value=c.point.positions;j.pointLightDistance.value=c.point.distances}if(d instanceof THREE.MeshBasicMaterial||d instanceof THREE.MeshLambertMaterial||
d instanceof THREE.MeshPhongMaterial)j.opacity.value=d.opacity,C.gammaInput?j.diffuse.value.copyGammaToLinear(d.color):j.diffuse.value=d.color,(j.map.texture=d.map)&&j.offsetRepeat.value.set(d.map.offset.x,d.map.offset.y,d.map.repeat.x,d.map.repeat.y),j.lightMap.texture=d.lightMap,j.envMap.texture=d.envMap,j.flipEnvMap.value=d.envMap instanceof THREE.WebGLRenderTargetCube?1:-1,j.reflectivity.value=d.reflectivity,j.refractionRatio.value=d.refractionRatio,j.combine.value=d.combine,j.useRefract.value=
d.envMap&&d.envMap.mapping instanceof THREE.CubeRefractionMapping;if(d instanceof THREE.LineBasicMaterial)j.diffuse.value=d.color,j.opacity.value=d.opacity;else if(d instanceof THREE.ParticleBasicMaterial)j.psColor.value=d.color,j.opacity.value=d.opacity,j.size.value=d.size,j.scale.value=I.height/2,j.map.texture=d.map;else if(d instanceof THREE.MeshPhongMaterial)j.shininess.value=d.shininess,C.gammaInput?(j.ambient.value.copyGammaToLinear(d.ambient),j.specular.value.copyGammaToLinear(d.specular)):
(j.ambient.value=d.ambient,j.specular.value=d.specular),d.wrapAround&&j.wrapRGB.value.copy(d.wrapRGB);else if(d instanceof THREE.MeshLambertMaterial)C.gammaInput?j.ambient.value.copyGammaToLinear(d.ambient):j.ambient.value=d.ambient,d.wrapAround&&j.wrapRGB.value.copy(d.wrapRGB);else if(d instanceof THREE.MeshDepthMaterial)j.mNear.value=a.near,j.mFar.value=a.far,j.opacity.value=d.opacity;else if(d instanceof THREE.MeshNormalMaterial)j.opacity.value=d.opacity;if(e.receiveShadow&&!d._shadowPass&&j.shadowMatrix){i=
c=0;for(l=b.length;i<l;i++)if(m=b[i],m.castShadow&&(m instanceof THREE.SpotLight||m instanceof THREE.DirectionalLight&&!m.shadowCascade))j.shadowMap.texture[c]=m.shadowMap,j.shadowMapSize.value[c]=m.shadowMapSize,j.shadowMatrix.value[c]=m.shadowMatrix,j.shadowDarkness.value[c]=m.shadowDarkness,j.shadowBias.value[c]=m.shadowBias,c++}b=d.uniformsList;for(j=0,c=b.length;j<c;j++)if(m=g.uniforms[b[j][1]])if(i=b[j][0],n=i.type,l=i.value,"i"===n)f.uniform1i(m,l);else if("f"===n)f.uniform1f(m,l);else if("v2"===
n)f.uniform2f(m,l.x,l.y);else if("v3"===n)f.uniform3f(m,l.x,l.y,l.z);else if("v4"===n)f.uniform4f(m,l.x,l.y,l.z,l.w);else if("c"===n)f.uniform3f(m,l.r,l.g,l.b);else if("fv1"===n)f.uniform1fv(m,l);else if("fv"===n)f.uniform3fv(m,l);else if("v2v"===n){if(!i._array)i._array=new Float32Array(2*l.length);for(n=0,s=l.length;n<s;n++)u=2*n,i._array[u]=l[n].x,i._array[u+1]=l[n].y;f.uniform2fv(m,i._array)}else if("v3v"===n){if(!i._array)i._array=new Float32Array(3*l.length);for(n=0,s=l.length;n<s;n++)u=3*n,
i._array[u]=l[n].x,i._array[u+1]=l[n].y,i._array[u+2]=l[n].z;f.uniform3fv(m,i._array)}else if("v4v"==n){if(!i._array)i._array=new Float32Array(4*l.length);for(n=0,s=l.length;n<s;n++)u=4*n,i._array[u]=l[n].x,i._array[u+1]=l[n].y,i._array[u+2]=l[n].z,i._array[u+3]=l[n].w;f.uniform4fv(m,i._array)}else if("m4"===n){if(!i._array)i._array=new Float32Array(16);l.flattenToArray(i._array);f.uniformMatrix4fv(m,!1,i._array)}else if("m4v"===n){if(!i._array)i._array=new Float32Array(16*l.length);for(n=0,s=l.length;n<
s;n++)l[n].flattenToArrayOffset(i._array,16*n);f.uniformMatrix4fv(m,!1,i._array)}else if("t"===n){if(f.uniform1i(m,l),m=i.texture)if(m.image instanceof Array&&6===m.image.length){if(i=m,6===i.image.length)if(i.needsUpdate){if(!i.image.__webglTextureCube)i.image.__webglTextureCube=f.createTexture();f.activeTexture(f.TEXTURE0+l);f.bindTexture(f.TEXTURE_CUBE_MAP,i.image.__webglTextureCube);l=[];for(m=0;6>m;m++){n=l;s=m;if(C.autoScaleCubemaps){if(u=i.image[m],y=Ec,!(u.width<=y&&u.height<=y))A=Math.max(u.width,
u.height),w=Math.floor(u.width*y/A),y=Math.floor(u.height*y/A),A=document.createElement("canvas"),A.width=w,A.height=y,A.getContext("2d").drawImage(u,0,0,u.width,u.height,0,0,w,y),u=A}else u=i.image[m];n[s]=u}m=l[0];n=0===(m.width&m.width-1)&&0===(m.height&m.height-1);s=H(i.format);u=H(i.type);N(f.TEXTURE_CUBE_MAP,i,n);for(m=0;6>m;m++)f.texImage2D(f.TEXTURE_CUBE_MAP_POSITIVE_X+m,0,s,s,u,l[m]);i.generateMipmaps&&n&&f.generateMipmap(f.TEXTURE_CUBE_MAP);i.needsUpdate=!1;if(i.onUpdate)i.onUpdate()}else f.activeTexture(f.TEXTURE0+
l),f.bindTexture(f.TEXTURE_CUBE_MAP,i.image.__webglTextureCube)}else m instanceof THREE.WebGLRenderTargetCube?(i=m,f.activeTexture(f.TEXTURE0+l),f.bindTexture(f.TEXTURE_CUBE_MAP,i.__webglTexture)):C.setTexture(m,l)}else if("tv"===n){if(!i._array){i._array=[];for(n=0,s=i.texture.length;n<s;n++)i._array[n]=l+n}f.uniform1iv(m,i._array);for(n=0,s=i.texture.length;n<s;n++)(m=i.texture[n])&&C.setTexture(m,i._array[n])}if((d instanceof THREE.ShaderMaterial||d instanceof THREE.MeshPhongMaterial||d.envMap)&&
null!==h.cameraPosition)b=a.matrixWorld.getPosition(),f.uniform3f(h.cameraPosition,b.x,b.y,b.z);(d instanceof THREE.MeshPhongMaterial||d instanceof THREE.MeshLambertMaterial||d instanceof THREE.ShaderMaterial||d.skinning)&&null!==h.viewMatrix&&f.uniformMatrix4fv(h.viewMatrix,!1,a._viewMatrixArray);d.skinning&&f.uniformMatrix4fv(h.boneGlobalMatrices,!1,e.boneMatrices)}f.uniformMatrix4fv(h.modelViewMatrix,!1,e._modelViewMatrixArray);h.normalMatrix&&f.uniformMatrix3fv(h.normalMatrix,!1,e._normalMatrixArray);
(d instanceof THREE.ShaderMaterial||d.envMap||d.skinning||e.receiveShadow)&&null!==h.objectMatrix&&f.uniformMatrix4fv(h.objectMatrix,!1,e._objectMatrixArray);return g}function s(a,b){a._modelViewMatrix.multiplyToArray(b.matrixWorldInverse,a.matrixWorld,a._modelViewMatrixArray);var c=THREE.Matrix4.makeInvert3x3(a._modelViewMatrix);c&&c.transposeIntoArray(a._normalMatrixArray)}function y(a,b,c){Sa!==a&&(a?f.enable(f.POLYGON_OFFSET_FILL):f.disable(f.POLYGON_OFFSET_FILL),Sa=a);if(a&&(Wa!==b||Ma!==c))f.polygonOffset(b,
c),Wa=b,Ma=c}function w(a,b){var c;"fragment"===a?c=f.createShader(f.FRAGMENT_SHADER):"vertex"===a&&(c=f.createShader(f.VERTEX_SHADER));f.shaderSource(c,b);f.compileShader(c);return!f.getShaderParameter(c,f.COMPILE_STATUS)?(console.error(f.getShaderInfoLog(c)),console.error(b),null):c}function N(a,b,c){c?(f.texParameteri(a,f.TEXTURE_WRAP_S,H(b.wrapS)),f.texParameteri(a,f.TEXTURE_WRAP_T,H(b.wrapT)),f.texParameteri(a,f.TEXTURE_MAG_FILTER,H(b.magFilter)),f.texParameteri(a,f.TEXTURE_MIN_FILTER,H(b.minFilter))):
(f.texParameteri(a,f.TEXTURE_WRAP_S,f.CLAMP_TO_EDGE),f.texParameteri(a,f.TEXTURE_WRAP_T,f.CLAMP_TO_EDGE),f.texParameteri(a,f.TEXTURE_MAG_FILTER,u(b.magFilter)),f.texParameteri(a,f.TEXTURE_MIN_FILTER,u(b.minFilter)))}function A(a,b){f.bindRenderbuffer(f.RENDERBUFFER,a);b.depthBuffer&&!b.stencilBuffer?(f.renderbufferStorage(f.RENDERBUFFER,f.DEPTH_COMPONENT16,b.width,b.height),f.framebufferRenderbuffer(f.FRAMEBUFFER,f.DEPTH_ATTACHMENT,f.RENDERBUFFER,a)):b.depthBuffer&&b.stencilBuffer?(f.renderbufferStorage(f.RENDERBUFFER,
f.DEPTH_STENCIL,b.width,b.height),f.framebufferRenderbuffer(f.FRAMEBUFFER,f.DEPTH_STENCIL_ATTACHMENT,f.RENDERBUFFER,a)):f.renderbufferStorage(f.RENDERBUFFER,f.RGBA4,b.width,b.height)}function u(a){switch(a){case THREE.NearestFilter:case THREE.NearestMipMapNearestFilter:case THREE.NearestMipMapLinearFilter:return f.NEAREST;default:return f.LINEAR}}function H(a){switch(a){case THREE.RepeatWrapping:return f.REPEAT;case THREE.ClampToEdgeWrapping:return f.CLAMP_TO_EDGE;case THREE.MirroredRepeatWrapping:return f.MIRRORED_REPEAT;
case THREE.NearestFilter:return f.NEAREST;case THREE.NearestMipMapNearestFilter:return f.NEAREST_MIPMAP_NEAREST;case THREE.NearestMipMapLinearFilter:return f.NEAREST_MIPMAP_LINEAR;case THREE.LinearFilter:return f.LINEAR;case THREE.LinearMipMapNearestFilter:return f.LINEAR_MIPMAP_NEAREST;case THREE.LinearMipMapLinearFilter:return f.LINEAR_MIPMAP_LINEAR;case THREE.ByteType:return f.BYTE;case THREE.UnsignedByteType:return f.UNSIGNED_BYTE;case THREE.ShortType:return f.SHORT;case THREE.UnsignedShortType:return f.UNSIGNED_SHORT;
case THREE.IntType:return f.INT;case THREE.UnsignedIntType:return f.UNSIGNED_INT;case THREE.FloatType:return f.FLOAT;case THREE.AlphaFormat:return f.ALPHA;case THREE.RGBFormat:return f.RGB;case THREE.RGBAFormat:return f.RGBA;case THREE.LuminanceFormat:return f.LUMINANCE;case THREE.LuminanceAlphaFormat:return f.LUMINANCE_ALPHA}return 0}var a=a||{},I=void 0!==a.canvas?a.canvas:document.createElement("canvas"),D=void 0!==a.precision?a.precision:"mediump",L=void 0!==a.alpha?a.alpha:!0,K=void 0!==a.premultipliedAlpha?
a.premultipliedAlpha:!0,M=void 0!==a.antialias?a.antialias:!1,ja=void 0!==a.stencil?a.stencil:!0,oa=void 0!==a.preserveDrawingBuffer?a.preserveDrawingBuffer:!1,ka=void 0!==a.clearColor?new THREE.Color(a.clearColor):new THREE.Color(0),X=void 0!==a.clearAlpha?a.clearAlpha:0,$=void 0!==a.maxLights?a.maxLights:4;this.domElement=I;this.context=null;this.autoUpdateScene=this.autoUpdateObjects=this.sortObjects=this.autoClearStencil=this.autoClearDepth=this.autoClearColor=this.autoClear=!0;this.shadowMapEnabled=
this.physicallyBasedShading=this.gammaOutput=this.gammaInput=!1;this.shadowMapCullFrontFaces=this.shadowMapSoft=this.shadowMapAutoUpdate=!0;this.shadowMapCascade=this.shadowMapDebug=!1;this.maxMorphTargets=8;this.maxMorphNormals=4;this.autoScaleCubemaps=!0;this.renderPluginsPre=[];this.renderPluginsPost=[];this.info={memory:{programs:0,geometries:0,textures:0},render:{calls:0,vertices:0,faces:0,points:0}};var C=this,f,Va=[],Ba=null,S=null,sa=-1,J=null,aa=null,ta=0,xa=null,T=null,Aa=null,Ga=null,Ha=
null,Sa=null,Wa=null,Ma=null,tb=null,Nb=0,Xb=0,Hb=0,Ob=0,lc=0,mc=0,Yb=new THREE.Frustum,Xa=new THREE.Matrix4,Na=new THREE.Vector4,nb=new THREE.Vector3,nc={ambient:[0,0,0],directional:{length:0,colors:[],positions:[]},point:{length:0,colors:[],positions:[],distances:[]}};f=function(){var a;try{if(!(a=I.getContext("experimental-webgl",{alpha:L,premultipliedAlpha:K,antialias:M,stencil:ja,preserveDrawingBuffer:oa})))throw"Error creating WebGL context.";console.log(navigator.userAgent+" | "+a.getParameter(a.VERSION)+
" | "+a.getParameter(a.VENDOR)+" | "+a.getParameter(a.RENDERER)+" | "+a.getParameter(a.SHADING_LANGUAGE_VERSION))}catch(b){console.error(b)}return a}();f.clearColor(0,0,0,1);f.clearDepth(1);f.clearStencil(0);f.enable(f.DEPTH_TEST);f.depthFunc(f.LEQUAL);f.frontFace(f.CCW);f.cullFace(f.BACK);f.enable(f.CULL_FACE);f.enable(f.BLEND);f.blendEquation(f.FUNC_ADD);f.blendFunc(f.SRC_ALPHA,f.ONE_MINUS_SRC_ALPHA);f.clearColor(ka.r,ka.g,ka.b,X);this.context=f;var oc=f.getParameter(f.MAX_VERTEX_TEXTURE_IMAGE_UNITS);
f.getParameter(f.MAX_TEXTURE_SIZE);var Ec=f.getParameter(f.MAX_CUBE_MAP_TEXTURE_SIZE);this.getContext=function(){return f};this.supportsVertexTextures=function(){return 0<oc};this.setSize=function(a,b){I.width=a;I.height=b;this.setViewport(0,0,I.width,I.height)};this.setViewport=function(a,b,c,d){Nb=a;Xb=b;Hb=c;Ob=d;f.viewport(Nb,Xb,Hb,Ob)};this.setScissor=function(a,b,c,d){f.scissor(a,b,c,d)};this.enableScissorTest=function(a){a?f.enable(f.SCISSOR_TEST):f.disable(f.SCISSOR_TEST)};this.setClearColorHex=
function(a,b){ka.setHex(a);X=b;f.clearColor(ka.r,ka.g,ka.b,X)};this.setClearColor=function(a,b){ka.copy(a);X=b;f.clearColor(ka.r,ka.g,ka.b,X)};this.getClearColor=function(){return ka};this.getClearAlpha=function(){return X};this.clear=function(a,b,c){var d=0;if(void 0===a||a)d|=f.COLOR_BUFFER_BIT;if(void 0===b||b)d|=f.DEPTH_BUFFER_BIT;if(void 0===c||c)d|=f.STENCIL_BUFFER_BIT;f.clear(d)};this.clearTarget=function(a,b,c,d){this.setRenderTarget(a);this.clear(b,c,d)};this.addPostPlugin=function(a){a.init(this);
this.renderPluginsPost.push(a)};this.addPrePlugin=function(a){a.init(this);this.renderPluginsPre.push(a)};this.deallocateObject=function(a){if(a.__webglInit)if(a.__webglInit=!1,delete a._modelViewMatrix,delete a._normalMatrixArray,delete a._modelViewMatrixArray,delete a._objectMatrixArray,a instanceof THREE.Mesh)for(var b in a.geometry.geometryGroups){var c=a.geometry.geometryGroups[b];f.deleteBuffer(c.__webglVertexBuffer);f.deleteBuffer(c.__webglNormalBuffer);f.deleteBuffer(c.__webglTangentBuffer);
f.deleteBuffer(c.__webglColorBuffer);f.deleteBuffer(c.__webglUVBuffer);f.deleteBuffer(c.__webglUV2Buffer);f.deleteBuffer(c.__webglSkinVertexABuffer);f.deleteBuffer(c.__webglSkinVertexBBuffer);f.deleteBuffer(c.__webglSkinIndicesBuffer);f.deleteBuffer(c.__webglSkinWeightsBuffer);f.deleteBuffer(c.__webglFaceBuffer);f.deleteBuffer(c.__webglLineBuffer);var d=void 0,e=void 0;if(c.numMorphTargets)for(d=0,e=c.numMorphTargets;d<e;d++)f.deleteBuffer(c.__webglMorphTargetsBuffers[d]);if(c.numMorphNormals)for(d=
0,e=c.numMorphNormals;d<e;d++)f.deleteBuffer(c.__webglMorphNormalsBuffers[d]);if(c.__webglCustomAttributesList)for(d in d=void 0,c.__webglCustomAttributesList)f.deleteBuffer(c.__webglCustomAttributesList[d].buffer);C.info.memory.geometries--}else if(a instanceof THREE.Ribbon)a=a.geometry,f.deleteBuffer(a.__webglVertexBuffer),f.deleteBuffer(a.__webglColorBuffer),C.info.memory.geometries--;else if(a instanceof THREE.Line)a=a.geometry,f.deleteBuffer(a.__webglVertexBuffer),f.deleteBuffer(a.__webglColorBuffer),
C.info.memory.geometries--;else if(a instanceof THREE.ParticleSystem)a=a.geometry,f.deleteBuffer(a.__webglVertexBuffer),f.deleteBuffer(a.__webglColorBuffer),C.info.memory.geometries--};this.deallocateTexture=function(a){if(a.__webglInit)a.__webglInit=!1,f.deleteTexture(a.__webglTexture),C.info.memory.textures--};this.updateShadowMap=function(a,b){Ba=null;sa=J=Ha=Ga=Aa=-1;this.shadowMapPlugin.update(a,b)};this.renderBufferImmediate=function(a,b,c){if(!a.__webglVertexBuffer)a.__webglVertexBuffer=f.createBuffer();
if(!a.__webglNormalBuffer)a.__webglNormalBuffer=f.createBuffer();a.hasPos&&(f.bindBuffer(f.ARRAY_BUFFER,a.__webglVertexBuffer),f.bufferData(f.ARRAY_BUFFER,a.positionArray,f.DYNAMIC_DRAW),f.enableVertexAttribArray(b.attributes.position),f.vertexAttribPointer(b.attributes.position,3,f.FLOAT,!1,0,0));if(a.hasNormal){f.bindBuffer(f.ARRAY_BUFFER,a.__webglNormalBuffer);if(c===THREE.FlatShading){var d,e,g,h,i,j,m,l,n,k,p=3*a.count;for(k=0;k<p;k+=9)c=a.normalArray,d=c[k],e=c[k+1],g=c[k+2],h=c[k+3],j=c[k+
4],l=c[k+5],i=c[k+6],m=c[k+7],n=c[k+8],d=(d+h+i)/3,e=(e+j+m)/3,g=(g+l+n)/3,c[k]=d,c[k+1]=e,c[k+2]=g,c[k+3]=d,c[k+4]=e,c[k+5]=g,c[k+6]=d,c[k+7]=e,c[k+8]=g}f.bufferData(f.ARRAY_BUFFER,a.normalArray,f.DYNAMIC_DRAW);f.enableVertexAttribArray(b.attributes.normal);f.vertexAttribPointer(b.attributes.normal,3,f.FLOAT,!1,0,0)}f.drawArrays(f.TRIANGLES,0,a.count);a.count=0};this.renderBufferDirect=function(a,b,c,d,e,g){if(0!==d.opacity&&(c=p(a,b,c,d,g),a=c.attributes,b=!1,d=16777215*e.id+2*c.id+(d.wireframe?
1:0),d!==J&&(J=d,b=!0),g instanceof THREE.Mesh)){g=e.offsets;d=0;for(c=g.length;d<c;++d)b&&(f.bindBuffer(f.ARRAY_BUFFER,e.vertexPositionBuffer),f.vertexAttribPointer(a.position,e.vertexPositionBuffer.itemSize,f.FLOAT,!1,0,12*g[d].index),0<=a.normal&&e.vertexNormalBuffer&&(f.bindBuffer(f.ARRAY_BUFFER,e.vertexNormalBuffer),f.vertexAttribPointer(a.normal,e.vertexNormalBuffer.itemSize,f.FLOAT,!1,0,12*g[d].index)),0<=a.uv&&e.vertexUvBuffer&&(e.vertexUvBuffer?(f.bindBuffer(f.ARRAY_BUFFER,e.vertexUvBuffer),
f.vertexAttribPointer(a.uv,e.vertexUvBuffer.itemSize,f.FLOAT,!1,0,8*g[d].index),f.enableVertexAttribArray(a.uv)):f.disableVertexAttribArray(a.uv)),0<=a.color&&e.vertexColorBuffer&&(f.bindBuffer(f.ARRAY_BUFFER,e.vertexColorBuffer),f.vertexAttribPointer(a.color,e.vertexColorBuffer.itemSize,f.FLOAT,!1,0,16*g[d].index)),f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,e.vertexIndexBuffer)),f.drawElements(f.TRIANGLES,g[d].count,f.UNSIGNED_SHORT,2*g[d].start),C.info.render.calls++,C.info.render.vertices+=g[d].count,
C.info.render.faces+=g[d].count/3}};this.renderBuffer=function(a,b,c,d,e,g){if(0!==d.opacity){var h,i,c=p(a,b,c,d,g),b=c.attributes,a=!1,c=16777215*e.id+2*c.id+(d.wireframe?1:0);c!==J&&(J=c,a=!0);if(!d.morphTargets&&0<=b.position)a&&(f.bindBuffer(f.ARRAY_BUFFER,e.__webglVertexBuffer),f.vertexAttribPointer(b.position,3,f.FLOAT,!1,0,0));else if(g.morphTargetBase){c=d.program.attributes;-1!==g.morphTargetBase?(f.bindBuffer(f.ARRAY_BUFFER,e.__webglMorphTargetsBuffers[g.morphTargetBase]),f.vertexAttribPointer(c.position,
3,f.FLOAT,!1,0,0)):0<=c.position&&(f.bindBuffer(f.ARRAY_BUFFER,e.__webglVertexBuffer),f.vertexAttribPointer(c.position,3,f.FLOAT,!1,0,0));if(g.morphTargetForcedOrder.length){h=0;var j=g.morphTargetForcedOrder;for(i=g.morphTargetInfluences;h<d.numSupportedMorphTargets&&h<j.length;)f.bindBuffer(f.ARRAY_BUFFER,e.__webglMorphTargetsBuffers[j[h]]),f.vertexAttribPointer(c["morphTarget"+h],3,f.FLOAT,!1,0,0),d.morphNormals&&(f.bindBuffer(f.ARRAY_BUFFER,e.__webglMorphNormalsBuffers[j[h]]),f.vertexAttribPointer(c["morphNormal"+
h],3,f.FLOAT,!1,0,0)),g.__webglMorphTargetInfluences[h]=i[j[h]],h++}else{var j=[],m=-1,k=0;i=g.morphTargetInfluences;var l,n=i.length;h=0;for(-1!==g.morphTargetBase&&(j[g.morphTargetBase]=!0);h<d.numSupportedMorphTargets;){for(l=0;l<n;l++)!j[l]&&i[l]>m&&(k=l,m=i[k]);f.bindBuffer(f.ARRAY_BUFFER,e.__webglMorphTargetsBuffers[k]);f.vertexAttribPointer(c["morphTarget"+h],3,f.FLOAT,!1,0,0);d.morphNormals&&(f.bindBuffer(f.ARRAY_BUFFER,e.__webglMorphNormalsBuffers[k]),f.vertexAttribPointer(c["morphNormal"+
h],3,f.FLOAT,!1,0,0));g.__webglMorphTargetInfluences[h]=m;j[k]=1;m=-1;h++}}null!==d.program.uniforms.morphTargetInfluences&&f.uniform1fv(d.program.uniforms.morphTargetInfluences,g.__webglMorphTargetInfluences)}if(a){if(e.__webglCustomAttributesList)for(h=0,i=e.__webglCustomAttributesList.length;h<i;h++)c=e.__webglCustomAttributesList[h],0<=b[c.buffer.belongsToAttribute]&&(f.bindBuffer(f.ARRAY_BUFFER,c.buffer),f.vertexAttribPointer(b[c.buffer.belongsToAttribute],c.size,f.FLOAT,!1,0,0));0<=b.color&&
(f.bindBuffer(f.ARRAY_BUFFER,e.__webglColorBuffer),f.vertexAttribPointer(b.color,3,f.FLOAT,!1,0,0));0<=b.normal&&(f.bindBuffer(f.ARRAY_BUFFER,e.__webglNormalBuffer),f.vertexAttribPointer(b.normal,3,f.FLOAT,!1,0,0));0<=b.tangent&&(f.bindBuffer(f.ARRAY_BUFFER,e.__webglTangentBuffer),f.vertexAttribPointer(b.tangent,4,f.FLOAT,!1,0,0));0<=b.uv&&(e.__webglUVBuffer?(f.bindBuffer(f.ARRAY_BUFFER,e.__webglUVBuffer),f.vertexAttribPointer(b.uv,2,f.FLOAT,!1,0,0),f.enableVertexAttribArray(b.uv)):f.disableVertexAttribArray(b.uv));
0<=b.uv2&&(e.__webglUV2Buffer?(f.bindBuffer(f.ARRAY_BUFFER,e.__webglUV2Buffer),f.vertexAttribPointer(b.uv2,2,f.FLOAT,!1,0,0),f.enableVertexAttribArray(b.uv2)):f.disableVertexAttribArray(b.uv2));d.skinning&&0<=b.skinVertexA&&0<=b.skinVertexB&&0<=b.skinIndex&&0<=b.skinWeight&&(f.bindBuffer(f.ARRAY_BUFFER,e.__webglSkinVertexABuffer),f.vertexAttribPointer(b.skinVertexA,4,f.FLOAT,!1,0,0),f.bindBuffer(f.ARRAY_BUFFER,e.__webglSkinVertexBBuffer),f.vertexAttribPointer(b.skinVertexB,4,f.FLOAT,!1,0,0),f.bindBuffer(f.ARRAY_BUFFER,
e.__webglSkinIndicesBuffer),f.vertexAttribPointer(b.skinIndex,4,f.FLOAT,!1,0,0),f.bindBuffer(f.ARRAY_BUFFER,e.__webglSkinWeightsBuffer),f.vertexAttribPointer(b.skinWeight,4,f.FLOAT,!1,0,0))}g instanceof THREE.Mesh?(d.wireframe?(d=d.wireframeLinewidth,d!==tb&&(f.lineWidth(d),tb=d),a&&f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,e.__webglLineBuffer),f.drawElements(f.LINES,e.__webglLineCount,f.UNSIGNED_SHORT,0)):(a&&f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,e.__webglFaceBuffer),f.drawElements(f.TRIANGLES,e.__webglFaceCount,
f.UNSIGNED_SHORT,0)),C.info.render.calls++,C.info.render.vertices+=e.__webglFaceCount,C.info.render.faces+=e.__webglFaceCount/3):g instanceof THREE.Line?(g=g.type===THREE.LineStrip?f.LINE_STRIP:f.LINES,d=d.linewidth,d!==tb&&(f.lineWidth(d),tb=d),f.drawArrays(g,0,e.__webglLineCount),C.info.render.calls++):g instanceof THREE.ParticleSystem?(f.drawArrays(f.POINTS,0,e.__webglParticleCount),C.info.render.calls++,C.info.render.points+=e.__webglParticleCount):g instanceof THREE.Ribbon&&(f.drawArrays(f.TRIANGLE_STRIP,
0,e.__webglVertexCount),C.info.render.calls++)}};this.render=function(a,b,c,d){var e,g,j,l,n=a.__lights,p=a.fog;sa=-1;this.autoUpdateObjects&&this.initWebGLObjects(a);void 0===b.parent&&(console.warn("DEPRECATED: Camera hasn't been added to a Scene. Adding it..."),a.add(b));this.autoUpdateScene&&a.updateMatrixWorld();i(this.renderPluginsPre,a,b);C.info.render.calls=0;C.info.render.vertices=0;C.info.render.faces=0;C.info.render.points=0;b.matrixWorldInverse.getInverse(b.matrixWorld);if(!b._viewMatrixArray)b._viewMatrixArray=
new Float32Array(16);b.matrixWorldInverse.flattenToArray(b._viewMatrixArray);if(!b._projectionMatrixArray)b._projectionMatrixArray=new Float32Array(16);b.projectionMatrix.flattenToArray(b._projectionMatrixArray);Xa.multiply(b.projectionMatrix,b.matrixWorldInverse);Yb.setFromMatrix(Xa);this.setRenderTarget(c);(this.autoClear||d)&&this.clear(this.autoClearColor,this.autoClearDepth,this.autoClearStencil);l=a.__webglObjects;for(d=0,e=l.length;d<e;d++)if(g=l[d],j=g.object,g.render=!1,j.visible&&(!(j instanceof
THREE.Mesh||j instanceof THREE.ParticleSystem)||!j.frustumCulled||Yb.contains(j))){j.matrixWorld.flattenToArray(j._objectMatrixArray);s(j,b);var o=g,q=o.object,u=o.buffer,w=void 0,w=w=void 0,w=q.material;if(w instanceof THREE.MeshFaceMaterial){if(w=u.materialIndex,0<=w)w=q.geometry.materials[w],w.transparent?(o.transparent=w,o.opaque=null):(o.opaque=w,o.transparent=null)}else if(w)w.transparent?(o.transparent=w,o.opaque=null):(o.opaque=w,o.transparent=null);g.render=!0;if(this.sortObjects)j.renderDepth?
g.z=j.renderDepth:(Na.copy(j.position),Xa.multiplyVector3(Na),g.z=Na.z)}this.sortObjects&&l.sort(h);l=a.__webglObjectsImmediate;for(d=0,e=l.length;d<e;d++)if(g=l[d],j=g.object,j.visible)j.matrixAutoUpdate&&j.matrixWorld.flattenToArray(j._objectMatrixArray),s(j,b),j=g.object.material,j.transparent?(g.transparent=j,g.opaque=null):(g.opaque=j,g.transparent=null);a.overrideMaterial?(this.setBlending(a.overrideMaterial.blending),this.setDepthTest(a.overrideMaterial.depthTest),this.setDepthWrite(a.overrideMaterial.depthWrite),
y(a.overrideMaterial.polygonOffset,a.overrideMaterial.polygonOffsetFactor,a.overrideMaterial.polygonOffsetUnits),m(a.__webglObjects,!1,"",b,n,p,!0,a.overrideMaterial),k(a.__webglObjectsImmediate,"",b,n,p,!1,a.overrideMaterial)):(this.setBlending(THREE.NormalBlending),m(a.__webglObjects,!0,"opaque",b,n,p,!1),k(a.__webglObjectsImmediate,"opaque",b,n,p,!1),m(a.__webglObjects,!1,"transparent",b,n,p,!0),k(a.__webglObjectsImmediate,"transparent",b,n,p,!0));i(this.renderPluginsPost,a,b);c&&c.generateMipmaps&&
c.minFilter!==THREE.NearestFilter&&c.minFilter!==THREE.LinearFilter&&(c instanceof THREE.WebGLRenderTargetCube?(f.bindTexture(f.TEXTURE_CUBE_MAP,c.__webglTexture),f.generateMipmap(f.TEXTURE_CUBE_MAP),f.bindTexture(f.TEXTURE_CUBE_MAP,null)):(f.bindTexture(f.TEXTURE_2D,c.__webglTexture),f.generateMipmap(f.TEXTURE_2D),f.bindTexture(f.TEXTURE_2D,null)));this.setDepthTest(!0);this.setDepthWrite(!0)};this.renderImmediateObject=function(a,b,c,d,e){var g=p(a,b,c,d,e);J=-1;C.setObjectFaces(e);e.immediateRenderCallback?
e.immediateRenderCallback(g,f,Yb):e.render(function(a){C.renderBufferImmediate(a,g,d.shading)})};this.initWebGLObjects=function(a){if(!a.__webglObjects)a.__webglObjects=[],a.__webglObjectsImmediate=[],a.__webglSprites=[],a.__webglFlares=[];for(;a.__objectsAdded.length;){var h=a.__objectsAdded[0],i=a,m=void 0,k=void 0,p=void 0;if(!h.__webglInit)if(h.__webglInit=!0,h._modelViewMatrix=new THREE.Matrix4,h._normalMatrixArray=new Float32Array(9),h._modelViewMatrixArray=new Float32Array(16),h._objectMatrixArray=
new Float32Array(16),h.matrixWorld.flattenToArray(h._objectMatrixArray),h instanceof THREE.Mesh){if(k=h.geometry,k instanceof THREE.Geometry){if(void 0===k.geometryGroups){var s=k,u=void 0,w=void 0,y=void 0,A=void 0,I=void 0,D=void 0,H=void 0,J={},L=s.morphTargets.length,N=s.morphNormals.length;s.geometryGroups={};for(u=0,w=s.faces.length;u<w;u++)y=s.faces[u],A=y.materialIndex,D=void 0!==A?A:-1,void 0===J[D]&&(J[D]={hash:D,counter:0}),H=J[D].hash+"_"+J[D].counter,void 0===s.geometryGroups[H]&&(s.geometryGroups[H]=
{faces3:[],faces4:[],materialIndex:A,vertices:0,numMorphTargets:L,numMorphNormals:N}),I=y instanceof THREE.Face3?3:4,65535<s.geometryGroups[H].vertices+I&&(J[D].counter+=1,H=J[D].hash+"_"+J[D].counter,void 0===s.geometryGroups[H]&&(s.geometryGroups[H]={faces3:[],faces4:[],materialIndex:A,vertices:0,numMorphTargets:L,numMorphNormals:N})),y instanceof THREE.Face3?s.geometryGroups[H].faces3.push(u):s.geometryGroups[H].faces4.push(u),s.geometryGroups[H].vertices+=I;s.geometryGroupsList=[];var M=void 0;
for(M in s.geometryGroups)s.geometryGroups[M].id=ta++,s.geometryGroupsList.push(s.geometryGroups[M])}for(m in k.geometryGroups)if(p=k.geometryGroups[m],!p.__webglVertexBuffer){var K=p;K.__webglVertexBuffer=f.createBuffer();K.__webglNormalBuffer=f.createBuffer();K.__webglTangentBuffer=f.createBuffer();K.__webglColorBuffer=f.createBuffer();K.__webglUVBuffer=f.createBuffer();K.__webglUV2Buffer=f.createBuffer();K.__webglSkinVertexABuffer=f.createBuffer();K.__webglSkinVertexBBuffer=f.createBuffer();K.__webglSkinIndicesBuffer=
f.createBuffer();K.__webglSkinWeightsBuffer=f.createBuffer();K.__webglFaceBuffer=f.createBuffer();K.__webglLineBuffer=f.createBuffer();var T=void 0,X=void 0;if(K.numMorphTargets){K.__webglMorphTargetsBuffers=[];for(T=0,X=K.numMorphTargets;T<X;T++)K.__webglMorphTargetsBuffers.push(f.createBuffer())}if(K.numMorphNormals){K.__webglMorphNormalsBuffers=[];for(T=0,X=K.numMorphNormals;T<X;T++)K.__webglMorphNormalsBuffers.push(f.createBuffer())}C.info.memory.geometries++;var ca=p,$=h,aa=$.geometry,ja=ca.faces3,
ka=ca.faces4,S=3*ja.length+4*ka.length,sa=1*ja.length+2*ka.length,xa=3*ja.length+4*ka.length,oa=c($,ca),Aa=e(oa),Ba=d(oa),Ga=oa.vertexColors?oa.vertexColors:!1;ca.__vertexArray=new Float32Array(3*S);if(Ba)ca.__normalArray=new Float32Array(3*S);if(aa.hasTangents)ca.__tangentArray=new Float32Array(4*S);if(Ga)ca.__colorArray=new Float32Array(3*S);if(Aa){if(0<aa.faceUvs.length||0<aa.faceVertexUvs.length)ca.__uvArray=new Float32Array(2*S);if(1<aa.faceUvs.length||1<aa.faceVertexUvs.length)ca.__uv2Array=
new Float32Array(2*S)}if($.geometry.skinWeights.length&&$.geometry.skinIndices.length)ca.__skinVertexAArray=new Float32Array(4*S),ca.__skinVertexBArray=new Float32Array(4*S),ca.__skinIndexArray=new Float32Array(4*S),ca.__skinWeightArray=new Float32Array(4*S);ca.__faceArray=new Uint16Array(3*sa);ca.__lineArray=new Uint16Array(2*xa);var Ha=void 0,Ma=void 0;if(ca.numMorphTargets){ca.__morphTargetsArrays=[];for(Ha=0,Ma=ca.numMorphTargets;Ha<Ma;Ha++)ca.__morphTargetsArrays.push(new Float32Array(3*S))}if(ca.numMorphNormals){ca.__morphNormalsArrays=
[];for(Ha=0,Ma=ca.numMorphNormals;Ha<Ma;Ha++)ca.__morphNormalsArrays.push(new Float32Array(3*S))}ca.__webglFaceCount=3*sa;ca.__webglLineCount=2*xa;if(oa.attributes){if(void 0===ca.__webglCustomAttributesList)ca.__webglCustomAttributesList=[];var Va=void 0;for(Va in oa.attributes){var Sa=oa.attributes[Va],La={},Wa;for(Wa in Sa)La[Wa]=Sa[Wa];if(!La.__webglInitialized||La.createUniqueBuffers){La.__webglInitialized=!0;var Na=1;"v2"===La.type?Na=2:"v3"===La.type?Na=3:"v4"===La.type?Na=4:"c"===La.type&&
(Na=3);La.size=Na;La.array=new Float32Array(S*Na);La.buffer=f.createBuffer();La.buffer.belongsToAttribute=Va;Sa.needsUpdate=!0;La.__original=Sa}ca.__webglCustomAttributesList.push(La)}}ca.__inittedArrays=!0;k.__dirtyVertices=!0;k.__dirtyMorphTargets=!0;k.__dirtyElements=!0;k.__dirtyUvs=!0;k.__dirtyNormals=!0;k.__dirtyTangents=!0;k.__dirtyColors=!0}}}else if(h instanceof THREE.Ribbon){if(k=h.geometry,!k.__webglVertexBuffer){var nb=k;nb.__webglVertexBuffer=f.createBuffer();nb.__webglColorBuffer=f.createBuffer();
C.info.memory.geometries++;var Xa=k,tb=Xa.vertices.length;Xa.__vertexArray=new Float32Array(3*tb);Xa.__colorArray=new Float32Array(3*tb);Xa.__webglVertexCount=tb;k.__dirtyVertices=!0;k.__dirtyColors=!0}}else if(h instanceof THREE.Line){if(k=h.geometry,!k.__webglVertexBuffer){var Nb=k;Nb.__webglVertexBuffer=f.createBuffer();Nb.__webglColorBuffer=f.createBuffer();C.info.memory.geometries++;var Zb=k,Xb=h,Hb=Zb.vertices.length;Zb.__vertexArray=new Float32Array(3*Hb);Zb.__colorArray=new Float32Array(3*
Hb);Zb.__webglLineCount=Hb;b(Zb,Xb);k.__dirtyVertices=!0;k.__dirtyColors=!0}}else if(h instanceof THREE.ParticleSystem&&(k=h.geometry,!k.__webglVertexBuffer)){var Ob=k;Ob.__webglVertexBuffer=f.createBuffer();Ob.__webglColorBuffer=f.createBuffer();C.info.geometries++;var Pb=k,Yb=h,Fc=Pb.vertices.length;Pb.__vertexArray=new Float32Array(3*Fc);Pb.__colorArray=new Float32Array(3*Fc);Pb.__sortArray=[];Pb.__webglParticleCount=Fc;b(Pb,Yb);k.__dirtyVertices=!0;k.__dirtyColors=!0}if(!h.__webglActive){if(h instanceof
THREE.Mesh)if(k=h.geometry,k instanceof THREE.BufferGeometry)j(i.__webglObjects,k,h);else for(m in k.geometryGroups)p=k.geometryGroups[m],j(i.__webglObjects,p,h);else h instanceof THREE.Ribbon||h instanceof THREE.Line||h instanceof THREE.ParticleSystem?(k=h.geometry,j(i.__webglObjects,k,h)):void 0!==THREE.MarchingCubes&&h instanceof THREE.MarchingCubes||h.immediateRenderCallback?i.__webglObjectsImmediate.push({object:h,opaque:null,transparent:null}):h instanceof THREE.Sprite?i.__webglSprites.push(h):
h instanceof THREE.LensFlare&&i.__webglFlares.push(h);h.__webglActive=!0}a.__objectsAdded.splice(0,1)}for(;a.__objectsRemoved.length;){var Oa=a.__objectsRemoved[0],pc=a;Oa instanceof THREE.Mesh||Oa instanceof THREE.ParticleSystem||Oa instanceof THREE.Ribbon||Oa instanceof THREE.Line?q(pc.__webglObjects,Oa):Oa instanceof THREE.Sprite?o(pc.__webglSprites,Oa):Oa instanceof THREE.LensFlare?o(pc.__webglFlares,Oa):(Oa instanceof THREE.MarchingCubes||Oa.immediateRenderCallback)&&q(pc.__webglObjectsImmediate,
Oa);Oa.__webglActive=!1;a.__objectsRemoved.splice(0,1)}for(var Gc=0,lc=a.__webglObjects.length;Gc<lc;Gc++){var Ta=a.__webglObjects[Gc].object,R=Ta.geometry,$b=void 0,Qb=void 0,Ea=void 0;if(Ta instanceof THREE.Mesh)if(R instanceof THREE.BufferGeometry)R.__dirtyVertices=!1,R.__dirtyElements=!1,R.__dirtyUvs=!1,R.__dirtyNormals=!1,R.__dirtyColors=!1;else{for(var Hc=0,mc=R.geometryGroupsList.length;Hc<mc;Hc++)if($b=R.geometryGroupsList[Hc],Ea=c(Ta,$b),Qb=Ea.attributes&&n(Ea),R.__dirtyVertices||R.__dirtyMorphTargets||
R.__dirtyElements||R.__dirtyUvs||R.__dirtyNormals||R.__dirtyColors||R.__dirtyTangents||Qb){var P=$b,nc=Ta,Ia=f.DYNAMIC_DRAW,oc=!R.dynamic,Ib=Ea;if(P.__inittedArrays){var Qc=d(Ib),Ic=Ib.vertexColors?Ib.vertexColors:!1,Rc=e(Ib),qc=Qc===THREE.SmoothShading,v=void 0,B=void 0,Ra=void 0,z=void 0,Rb=void 0,ub=void 0,Ua=void 0,rc=void 0,ob=void 0,Sb=void 0,Tb=void 0,E=void 0,F=void 0,G=void 0,Y=void 0,Ya=void 0,Za=void 0,$a=void 0,ac=void 0,ab=void 0,bb=void 0,cb=void 0,bc=void 0,db=void 0,eb=void 0,fb=void 0,
cc=void 0,gb=void 0,hb=void 0,ib=void 0,dc=void 0,jb=void 0,kb=void 0,lb=void 0,ec=void 0,vb=void 0,wb=void 0,xb=void 0,sc=void 0,yb=void 0,zb=void 0,Ab=void 0,tc=void 0,U=void 0,Sc=void 0,Bb=void 0,Ub=void 0,Vb=void 0,ua=void 0,Tc=void 0,qa=void 0,ra=void 0,Cb=void 0,pb=void 0,la=0,pa=0,qb=0,rb=0,Pa=0,za=0,Z=0,Ca=0,ma=0,x=0,O=0,t=0,Ja=void 0,va=P.__vertexArray,fc=P.__uvArray,gc=P.__uv2Array,Qa=P.__normalArray,da=P.__tangentArray,wa=P.__colorArray,ea=P.__skinVertexAArray,fa=P.__skinVertexBArray,ga=
P.__skinIndexArray,ha=P.__skinWeightArray,Jc=P.__morphTargetsArrays,Kc=P.__morphNormalsArrays,Lc=P.__webglCustomAttributesList,r=void 0,mb=P.__faceArray,Ka=P.__lineArray,Da=nc.geometry,Ec=Da.__dirtyElements,Uc=Da.__dirtyUvs,ad=Da.__dirtyNormals,bd=Da.__dirtyTangents,cd=Da.__dirtyColors,dd=Da.__dirtyMorphTargets,Jb=Da.vertices,V=P.faces3,W=P.faces4,na=Da.faces,Mc=Da.faceVertexUvs[0],Nc=Da.faceVertexUvs[1],Kb=Da.skinVerticesA,Lb=Da.skinVerticesB,Mb=Da.skinIndices,Db=Da.skinWeights,Eb=Da.morphTargets,
uc=Da.morphNormals;if(Da.__dirtyVertices){for(v=0,B=V.length;v<B;v++)z=na[V[v]],E=Jb[z.a].position,F=Jb[z.b].position,G=Jb[z.c].position,va[pa]=E.x,va[pa+1]=E.y,va[pa+2]=E.z,va[pa+3]=F.x,va[pa+4]=F.y,va[pa+5]=F.z,va[pa+6]=G.x,va[pa+7]=G.y,va[pa+8]=G.z,pa+=9;for(v=0,B=W.length;v<B;v++)z=na[W[v]],E=Jb[z.a].position,F=Jb[z.b].position,G=Jb[z.c].position,Y=Jb[z.d].position,va[pa]=E.x,va[pa+1]=E.y,va[pa+2]=E.z,va[pa+3]=F.x,va[pa+4]=F.y,va[pa+5]=F.z,va[pa+6]=G.x,va[pa+7]=G.y,va[pa+8]=G.z,va[pa+9]=Y.x,va[pa+
10]=Y.y,va[pa+11]=Y.z,pa+=12;f.bindBuffer(f.ARRAY_BUFFER,P.__webglVertexBuffer);f.bufferData(f.ARRAY_BUFFER,va,Ia)}if(dd)for(ua=0,Tc=Eb.length;ua<Tc;ua++){O=0;for(v=0,B=V.length;v<B;v++){Cb=V[v];z=na[Cb];E=Eb[ua].vertices[z.a].position;F=Eb[ua].vertices[z.b].position;G=Eb[ua].vertices[z.c].position;qa=Jc[ua];qa[O]=E.x;qa[O+1]=E.y;qa[O+2]=E.z;qa[O+3]=F.x;qa[O+4]=F.y;qa[O+5]=F.z;qa[O+6]=G.x;qa[O+7]=G.y;qa[O+8]=G.z;if(Ib.morphNormals)qc?(pb=uc[ua].vertexNormals[Cb],ab=pb.a,bb=pb.b,cb=pb.c):cb=bb=ab=
uc[ua].faceNormals[Cb],ra=Kc[ua],ra[O]=ab.x,ra[O+1]=ab.y,ra[O+2]=ab.z,ra[O+3]=bb.x,ra[O+4]=bb.y,ra[O+5]=bb.z,ra[O+6]=cb.x,ra[O+7]=cb.y,ra[O+8]=cb.z;O+=9}for(v=0,B=W.length;v<B;v++){Cb=W[v];z=na[Cb];E=Eb[ua].vertices[z.a].position;F=Eb[ua].vertices[z.b].position;G=Eb[ua].vertices[z.c].position;Y=Eb[ua].vertices[z.d].position;qa=Jc[ua];qa[O]=E.x;qa[O+1]=E.y;qa[O+2]=E.z;qa[O+3]=F.x;qa[O+4]=F.y;qa[O+5]=F.z;qa[O+6]=G.x;qa[O+7]=G.y;qa[O+8]=G.z;qa[O+9]=Y.x;qa[O+10]=Y.y;qa[O+11]=Y.z;if(Ib.morphNormals)qc?
(pb=uc[ua].vertexNormals[Cb],ab=pb.a,bb=pb.b,cb=pb.c,bc=pb.d):bc=cb=bb=ab=uc[ua].faceNormals[Cb],ra=Kc[ua],ra[O]=ab.x,ra[O+1]=ab.y,ra[O+2]=ab.z,ra[O+3]=bb.x,ra[O+4]=bb.y,ra[O+5]=bb.z,ra[O+6]=cb.x,ra[O+7]=cb.y,ra[O+8]=cb.z,ra[O+9]=bc.x,ra[O+10]=bc.y,ra[O+11]=bc.z;O+=12}f.bindBuffer(f.ARRAY_BUFFER,P.__webglMorphTargetsBuffers[ua]);f.bufferData(f.ARRAY_BUFFER,Jc[ua],Ia);Ib.morphNormals&&(f.bindBuffer(f.ARRAY_BUFFER,P.__webglMorphNormalsBuffers[ua]),f.bufferData(f.ARRAY_BUFFER,Kc[ua],Ia))}if(Db.length){for(v=
0,B=V.length;v<B;v++)z=na[V[v]],gb=Db[z.a],hb=Db[z.b],ib=Db[z.c],ha[x]=gb.x,ha[x+1]=gb.y,ha[x+2]=gb.z,ha[x+3]=gb.w,ha[x+4]=hb.x,ha[x+5]=hb.y,ha[x+6]=hb.z,ha[x+7]=hb.w,ha[x+8]=ib.x,ha[x+9]=ib.y,ha[x+10]=ib.z,ha[x+11]=ib.w,jb=Mb[z.a],kb=Mb[z.b],lb=Mb[z.c],ga[x]=jb.x,ga[x+1]=jb.y,ga[x+2]=jb.z,ga[x+3]=jb.w,ga[x+4]=kb.x,ga[x+5]=kb.y,ga[x+6]=kb.z,ga[x+7]=kb.w,ga[x+8]=lb.x,ga[x+9]=lb.y,ga[x+10]=lb.z,ga[x+11]=lb.w,vb=Kb[z.a],wb=Kb[z.b],xb=Kb[z.c],ea[x]=vb.x,ea[x+1]=vb.y,ea[x+2]=vb.z,ea[x+3]=1,ea[x+4]=wb.x,
ea[x+5]=wb.y,ea[x+6]=wb.z,ea[x+7]=1,ea[x+8]=xb.x,ea[x+9]=xb.y,ea[x+10]=xb.z,ea[x+11]=1,yb=Lb[z.a],zb=Lb[z.b],Ab=Lb[z.c],fa[x]=yb.x,fa[x+1]=yb.y,fa[x+2]=yb.z,fa[x+3]=1,fa[x+4]=zb.x,fa[x+5]=zb.y,fa[x+6]=zb.z,fa[x+7]=1,fa[x+8]=Ab.x,fa[x+9]=Ab.y,fa[x+10]=Ab.z,fa[x+11]=1,x+=12;for(v=0,B=W.length;v<B;v++)z=na[W[v]],gb=Db[z.a],hb=Db[z.b],ib=Db[z.c],dc=Db[z.d],ha[x]=gb.x,ha[x+1]=gb.y,ha[x+2]=gb.z,ha[x+3]=gb.w,ha[x+4]=hb.x,ha[x+5]=hb.y,ha[x+6]=hb.z,ha[x+7]=hb.w,ha[x+8]=ib.x,ha[x+9]=ib.y,ha[x+10]=ib.z,ha[x+
11]=ib.w,ha[x+12]=dc.x,ha[x+13]=dc.y,ha[x+14]=dc.z,ha[x+15]=dc.w,jb=Mb[z.a],kb=Mb[z.b],lb=Mb[z.c],ec=Mb[z.d],ga[x]=jb.x,ga[x+1]=jb.y,ga[x+2]=jb.z,ga[x+3]=jb.w,ga[x+4]=kb.x,ga[x+5]=kb.y,ga[x+6]=kb.z,ga[x+7]=kb.w,ga[x+8]=lb.x,ga[x+9]=lb.y,ga[x+10]=lb.z,ga[x+11]=lb.w,ga[x+12]=ec.x,ga[x+13]=ec.y,ga[x+14]=ec.z,ga[x+15]=ec.w,vb=Kb[z.a],wb=Kb[z.b],xb=Kb[z.c],sc=Kb[z.d],ea[x]=vb.x,ea[x+1]=vb.y,ea[x+2]=vb.z,ea[x+3]=1,ea[x+4]=wb.x,ea[x+5]=wb.y,ea[x+6]=wb.z,ea[x+7]=1,ea[x+8]=xb.x,ea[x+9]=xb.y,ea[x+10]=xb.z,
ea[x+11]=1,ea[x+12]=sc.x,ea[x+13]=sc.y,ea[x+14]=sc.z,ea[x+15]=1,yb=Lb[z.a],zb=Lb[z.b],Ab=Lb[z.c],tc=Lb[z.d],fa[x]=yb.x,fa[x+1]=yb.y,fa[x+2]=yb.z,fa[x+3]=1,fa[x+4]=zb.x,fa[x+5]=zb.y,fa[x+6]=zb.z,fa[x+7]=1,fa[x+8]=Ab.x,fa[x+9]=Ab.y,fa[x+10]=Ab.z,fa[x+11]=1,fa[x+12]=tc.x,fa[x+13]=tc.y,fa[x+14]=tc.z,fa[x+15]=1,x+=16;0<x&&(f.bindBuffer(f.ARRAY_BUFFER,P.__webglSkinVertexABuffer),f.bufferData(f.ARRAY_BUFFER,ea,Ia),f.bindBuffer(f.ARRAY_BUFFER,P.__webglSkinVertexBBuffer),f.bufferData(f.ARRAY_BUFFER,fa,Ia),
f.bindBuffer(f.ARRAY_BUFFER,P.__webglSkinIndicesBuffer),f.bufferData(f.ARRAY_BUFFER,ga,Ia),f.bindBuffer(f.ARRAY_BUFFER,P.__webglSkinWeightsBuffer),f.bufferData(f.ARRAY_BUFFER,ha,Ia))}if(cd&&Ic){for(v=0,B=V.length;v<B;v++)z=na[V[v]],Ua=z.vertexColors,rc=z.color,3===Ua.length&&Ic===THREE.VertexColors?(db=Ua[0],eb=Ua[1],fb=Ua[2]):fb=eb=db=rc,wa[ma]=db.r,wa[ma+1]=db.g,wa[ma+2]=db.b,wa[ma+3]=eb.r,wa[ma+4]=eb.g,wa[ma+5]=eb.b,wa[ma+6]=fb.r,wa[ma+7]=fb.g,wa[ma+8]=fb.b,ma+=9;for(v=0,B=W.length;v<B;v++)z=na[W[v]],
Ua=z.vertexColors,rc=z.color,4===Ua.length&&Ic===THREE.VertexColors?(db=Ua[0],eb=Ua[1],fb=Ua[2],cc=Ua[3]):cc=fb=eb=db=rc,wa[ma]=db.r,wa[ma+1]=db.g,wa[ma+2]=db.b,wa[ma+3]=eb.r,wa[ma+4]=eb.g,wa[ma+5]=eb.b,wa[ma+6]=fb.r,wa[ma+7]=fb.g,wa[ma+8]=fb.b,wa[ma+9]=cc.r,wa[ma+10]=cc.g,wa[ma+11]=cc.b,ma+=12;0<ma&&(f.bindBuffer(f.ARRAY_BUFFER,P.__webglColorBuffer),f.bufferData(f.ARRAY_BUFFER,wa,Ia))}if(bd&&Da.hasTangents){for(v=0,B=V.length;v<B;v++)z=na[V[v]],ob=z.vertexTangents,Ya=ob[0],Za=ob[1],$a=ob[2],da[Z]=
Ya.x,da[Z+1]=Ya.y,da[Z+2]=Ya.z,da[Z+3]=Ya.w,da[Z+4]=Za.x,da[Z+5]=Za.y,da[Z+6]=Za.z,da[Z+7]=Za.w,da[Z+8]=$a.x,da[Z+9]=$a.y,da[Z+10]=$a.z,da[Z+11]=$a.w,Z+=12;for(v=0,B=W.length;v<B;v++)z=na[W[v]],ob=z.vertexTangents,Ya=ob[0],Za=ob[1],$a=ob[2],ac=ob[3],da[Z]=Ya.x,da[Z+1]=Ya.y,da[Z+2]=Ya.z,da[Z+3]=Ya.w,da[Z+4]=Za.x,da[Z+5]=Za.y,da[Z+6]=Za.z,da[Z+7]=Za.w,da[Z+8]=$a.x,da[Z+9]=$a.y,da[Z+10]=$a.z,da[Z+11]=$a.w,da[Z+12]=ac.x,da[Z+13]=ac.y,da[Z+14]=ac.z,da[Z+15]=ac.w,Z+=16;f.bindBuffer(f.ARRAY_BUFFER,P.__webglTangentBuffer);
f.bufferData(f.ARRAY_BUFFER,da,Ia)}if(ad&&Qc){for(v=0,B=V.length;v<B;v++)if(z=na[V[v]],Rb=z.vertexNormals,ub=z.normal,3===Rb.length&&qc)for(U=0;3>U;U++)Bb=Rb[U],Qa[za]=Bb.x,Qa[za+1]=Bb.y,Qa[za+2]=Bb.z,za+=3;else for(U=0;3>U;U++)Qa[za]=ub.x,Qa[za+1]=ub.y,Qa[za+2]=ub.z,za+=3;for(v=0,B=W.length;v<B;v++)if(z=na[W[v]],Rb=z.vertexNormals,ub=z.normal,4===Rb.length&&qc)for(U=0;4>U;U++)Bb=Rb[U],Qa[za]=Bb.x,Qa[za+1]=Bb.y,Qa[za+2]=Bb.z,za+=3;else for(U=0;4>U;U++)Qa[za]=ub.x,Qa[za+1]=ub.y,Qa[za+2]=ub.z,za+=3;
f.bindBuffer(f.ARRAY_BUFFER,P.__webglNormalBuffer);f.bufferData(f.ARRAY_BUFFER,Qa,Ia)}if(Uc&&Mc&&Rc){for(v=0,B=V.length;v<B;v++)if(Ra=V[v],z=na[Ra],Sb=Mc[Ra],void 0!==Sb)for(U=0;3>U;U++)Ub=Sb[U],fc[qb]=Ub.u,fc[qb+1]=Ub.v,qb+=2;for(v=0,B=W.length;v<B;v++)if(Ra=W[v],z=na[Ra],Sb=Mc[Ra],void 0!==Sb)for(U=0;4>U;U++)Ub=Sb[U],fc[qb]=Ub.u,fc[qb+1]=Ub.v,qb+=2;0<qb&&(f.bindBuffer(f.ARRAY_BUFFER,P.__webglUVBuffer),f.bufferData(f.ARRAY_BUFFER,fc,Ia))}if(Uc&&Nc&&Rc){for(v=0,B=V.length;v<B;v++)if(Ra=V[v],z=na[Ra],
Tb=Nc[Ra],void 0!==Tb)for(U=0;3>U;U++)Vb=Tb[U],gc[rb]=Vb.u,gc[rb+1]=Vb.v,rb+=2;for(v=0,B=W.length;v<B;v++)if(Ra=W[v],z=na[Ra],Tb=Nc[Ra],void 0!==Tb)for(U=0;4>U;U++)Vb=Tb[U],gc[rb]=Vb.u,gc[rb+1]=Vb.v,rb+=2;0<rb&&(f.bindBuffer(f.ARRAY_BUFFER,P.__webglUV2Buffer),f.bufferData(f.ARRAY_BUFFER,gc,Ia))}if(Ec){for(v=0,B=V.length;v<B;v++)z=na[V[v]],mb[Pa]=la,mb[Pa+1]=la+1,mb[Pa+2]=la+2,Pa+=3,Ka[Ca]=la,Ka[Ca+1]=la+1,Ka[Ca+2]=la,Ka[Ca+3]=la+2,Ka[Ca+4]=la+1,Ka[Ca+5]=la+2,Ca+=6,la+=3;for(v=0,B=W.length;v<B;v++)z=
na[W[v]],mb[Pa]=la,mb[Pa+1]=la+1,mb[Pa+2]=la+3,mb[Pa+3]=la+1,mb[Pa+4]=la+2,mb[Pa+5]=la+3,Pa+=6,Ka[Ca]=la,Ka[Ca+1]=la+1,Ka[Ca+2]=la,Ka[Ca+3]=la+3,Ka[Ca+4]=la+1,Ka[Ca+5]=la+2,Ka[Ca+6]=la+2,Ka[Ca+7]=la+3,Ca+=8,la+=4;f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,P.__webglFaceBuffer);f.bufferData(f.ELEMENT_ARRAY_BUFFER,mb,Ia);f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,P.__webglLineBuffer);f.bufferData(f.ELEMENT_ARRAY_BUFFER,Ka,Ia)}if(Lc)for(U=0,Sc=Lc.length;U<Sc;U++)if(r=Lc[U],r.__original.needsUpdate){t=0;if(1===r.size)if(void 0===
r.boundTo||"vertices"===r.boundTo){for(v=0,B=V.length;v<B;v++)z=na[V[v]],r.array[t]=r.value[z.a],r.array[t+1]=r.value[z.b],r.array[t+2]=r.value[z.c],t+=3;for(v=0,B=W.length;v<B;v++)z=na[W[v]],r.array[t]=r.value[z.a],r.array[t+1]=r.value[z.b],r.array[t+2]=r.value[z.c],r.array[t+3]=r.value[z.d],t+=4}else{if("faces"===r.boundTo){for(v=0,B=V.length;v<B;v++)Ja=r.value[V[v]],r.array[t]=Ja,r.array[t+1]=Ja,r.array[t+2]=Ja,t+=3;for(v=0,B=W.length;v<B;v++)Ja=r.value[W[v]],r.array[t]=Ja,r.array[t+1]=Ja,r.array[t+
2]=Ja,r.array[t+3]=Ja,t+=4}}else if(2===r.size)if(void 0===r.boundTo||"vertices"===r.boundTo){for(v=0,B=V.length;v<B;v++)z=na[V[v]],E=r.value[z.a],F=r.value[z.b],G=r.value[z.c],r.array[t]=E.x,r.array[t+1]=E.y,r.array[t+2]=F.x,r.array[t+3]=F.y,r.array[t+4]=G.x,r.array[t+5]=G.y,t+=6;for(v=0,B=W.length;v<B;v++)z=na[W[v]],E=r.value[z.a],F=r.value[z.b],G=r.value[z.c],Y=r.value[z.d],r.array[t]=E.x,r.array[t+1]=E.y,r.array[t+2]=F.x,r.array[t+3]=F.y,r.array[t+4]=G.x,r.array[t+5]=G.y,r.array[t+6]=Y.x,r.array[t+
7]=Y.y,t+=8}else{if("faces"===r.boundTo){for(v=0,B=V.length;v<B;v++)G=F=E=Ja=r.value[V[v]],r.array[t]=E.x,r.array[t+1]=E.y,r.array[t+2]=F.x,r.array[t+3]=F.y,r.array[t+4]=G.x,r.array[t+5]=G.y,t+=6;for(v=0,B=W.length;v<B;v++)Y=G=F=E=Ja=r.value[W[v]],r.array[t]=E.x,r.array[t+1]=E.y,r.array[t+2]=F.x,r.array[t+3]=F.y,r.array[t+4]=G.x,r.array[t+5]=G.y,r.array[t+6]=Y.x,r.array[t+7]=Y.y,t+=8}}else if(3===r.size){var Q;Q="c"===r.type?["r","g","b"]:["x","y","z"];if(void 0===r.boundTo||"vertices"===r.boundTo){for(v=
0,B=V.length;v<B;v++)z=na[V[v]],E=r.value[z.a],F=r.value[z.b],G=r.value[z.c],r.array[t]=E[Q[0]],r.array[t+1]=E[Q[1]],r.array[t+2]=E[Q[2]],r.array[t+3]=F[Q[0]],r.array[t+4]=F[Q[1]],r.array[t+5]=F[Q[2]],r.array[t+6]=G[Q[0]],r.array[t+7]=G[Q[1]],r.array[t+8]=G[Q[2]],t+=9;for(v=0,B=W.length;v<B;v++)z=na[W[v]],E=r.value[z.a],F=r.value[z.b],G=r.value[z.c],Y=r.value[z.d],r.array[t]=E[Q[0]],r.array[t+1]=E[Q[1]],r.array[t+2]=E[Q[2]],r.array[t+3]=F[Q[0]],r.array[t+4]=F[Q[1]],r.array[t+5]=F[Q[2]],r.array[t+
6]=G[Q[0]],r.array[t+7]=G[Q[1]],r.array[t+8]=G[Q[2]],r.array[t+9]=Y[Q[0]],r.array[t+10]=Y[Q[1]],r.array[t+11]=Y[Q[2]],t+=12}else if("faces"===r.boundTo){for(v=0,B=V.length;v<B;v++)G=F=E=Ja=r.value[V[v]],r.array[t]=E[Q[0]],r.array[t+1]=E[Q[1]],r.array[t+2]=E[Q[2]],r.array[t+3]=F[Q[0]],r.array[t+4]=F[Q[1]],r.array[t+5]=F[Q[2]],r.array[t+6]=G[Q[0]],r.array[t+7]=G[Q[1]],r.array[t+8]=G[Q[2]],t+=9;for(v=0,B=W.length;v<B;v++)Y=G=F=E=Ja=r.value[W[v]],r.array[t]=E[Q[0]],r.array[t+1]=E[Q[1]],r.array[t+2]=E[Q[2]],
r.array[t+3]=F[Q[0]],r.array[t+4]=F[Q[1]],r.array[t+5]=F[Q[2]],r.array[t+6]=G[Q[0]],r.array[t+7]=G[Q[1]],r.array[t+8]=G[Q[2]],r.array[t+9]=Y[Q[0]],r.array[t+10]=Y[Q[1]],r.array[t+11]=Y[Q[2]],t+=12}}else if(4===r.size)if(void 0===r.boundTo||"vertices"===r.boundTo){for(v=0,B=V.length;v<B;v++)z=na[V[v]],E=r.value[z.a],F=r.value[z.b],G=r.value[z.c],r.array[t]=E.x,r.array[t+1]=E.y,r.array[t+2]=E.z,r.array[t+3]=E.w,r.array[t+4]=F.x,r.array[t+5]=F.y,r.array[t+6]=F.z,r.array[t+7]=F.w,r.array[t+8]=G.x,r.array[t+
9]=G.y,r.array[t+10]=G.z,r.array[t+11]=G.w,t+=12;for(v=0,B=W.length;v<B;v++)z=na[W[v]],E=r.value[z.a],F=r.value[z.b],G=r.value[z.c],Y=r.value[z.d],r.array[t]=E.x,r.array[t+1]=E.y,r.array[t+2]=E.z,r.array[t+3]=E.w,r.array[t+4]=F.x,r.array[t+5]=F.y,r.array[t+6]=F.z,r.array[t+7]=F.w,r.array[t+8]=G.x,r.array[t+9]=G.y,r.array[t+10]=G.z,r.array[t+11]=G.w,r.array[t+12]=Y.x,r.array[t+13]=Y.y,r.array[t+14]=Y.z,r.array[t+15]=Y.w,t+=16}else if("faces"===r.boundTo){for(v=0,B=V.length;v<B;v++)G=F=E=Ja=r.value[V[v]],
r.array[t]=E.x,r.array[t+1]=E.y,r.array[t+2]=E.z,r.array[t+3]=E.w,r.array[t+4]=F.x,r.array[t+5]=F.y,r.array[t+6]=F.z,r.array[t+7]=F.w,r.array[t+8]=G.x,r.array[t+9]=G.y,r.array[t+10]=G.z,r.array[t+11]=G.w,t+=12;for(v=0,B=W.length;v<B;v++)Y=G=F=E=Ja=r.value[W[v]],r.array[t]=E.x,r.array[t+1]=E.y,r.array[t+2]=E.z,r.array[t+3]=E.w,r.array[t+4]=F.x,r.array[t+5]=F.y,r.array[t+6]=F.z,r.array[t+7]=F.w,r.array[t+8]=G.x,r.array[t+9]=G.y,r.array[t+10]=G.z,r.array[t+11]=G.w,r.array[t+12]=Y.x,r.array[t+13]=Y.y,
r.array[t+14]=Y.z,r.array[t+15]=Y.w,t+=16}f.bindBuffer(f.ARRAY_BUFFER,r.buffer);f.bufferData(f.ARRAY_BUFFER,r.array,Ia)}oc&&(delete P.__inittedArrays,delete P.__colorArray,delete P.__normalArray,delete P.__tangentArray,delete P.__uvArray,delete P.__uv2Array,delete P.__faceArray,delete P.__vertexArray,delete P.__lineArray,delete P.__skinVertexAArray,delete P.__skinVertexBArray,delete P.__skinIndexArray,delete P.__skinWeightArray)}}R.__dirtyVertices=!1;R.__dirtyMorphTargets=!1;R.__dirtyElements=!1;
R.__dirtyUvs=!1;R.__dirtyNormals=!1;R.__dirtyColors=!1;R.__dirtyTangents=!1;Ea.attributes&&l(Ea)}else if(Ta instanceof THREE.Ribbon){if(R.__dirtyVertices||R.__dirtyColors){var Fb=R,Vc=f.DYNAMIC_DRAW,hc=void 0,ic=void 0,vc=void 0,Gb=void 0,wc=void 0,Wc=Fb.vertices,Xc=Fb.colors,ed=Wc.length,fd=Xc.length,xc=Fb.__vertexArray,yc=Fb.__colorArray,gd=Fb.__dirtyColors;if(Fb.__dirtyVertices){for(hc=0;hc<ed;hc++)vc=Wc[hc].position,Gb=3*hc,xc[Gb]=vc.x,xc[Gb+1]=vc.y,xc[Gb+2]=vc.z;f.bindBuffer(f.ARRAY_BUFFER,Fb.__webglVertexBuffer);
f.bufferData(f.ARRAY_BUFFER,xc,Vc)}if(gd){for(ic=0;ic<fd;ic++)wc=Xc[ic],Gb=3*ic,yc[Gb]=wc.r,yc[Gb+1]=wc.g,yc[Gb+2]=wc.b;f.bindBuffer(f.ARRAY_BUFFER,Fb.__webglColorBuffer);f.bufferData(f.ARRAY_BUFFER,yc,Vc)}}R.__dirtyVertices=!1;R.__dirtyColors=!1}else if(Ta instanceof THREE.Line){Ea=c(Ta,$b);Qb=Ea.attributes&&n(Ea);if(R.__dirtyVertices||R.__dirtyColors||Qb){var sb=R,Oc=f.DYNAMIC_DRAW,jc=void 0,kc=void 0,zc=void 0,ia=void 0,Ac=void 0,Yc=sb.vertices,Zc=sb.colors,hd=Yc.length,id=Zc.length,Bc=sb.__vertexArray,
Cc=sb.__colorArray,jd=sb.__dirtyColors,Pc=sb.__webglCustomAttributesList,Dc=void 0,$c=void 0,ya=void 0,Wb=void 0,Fa=void 0,ba=void 0;if(sb.__dirtyVertices){for(jc=0;jc<hd;jc++)zc=Yc[jc].position,ia=3*jc,Bc[ia]=zc.x,Bc[ia+1]=zc.y,Bc[ia+2]=zc.z;f.bindBuffer(f.ARRAY_BUFFER,sb.__webglVertexBuffer);f.bufferData(f.ARRAY_BUFFER,Bc,Oc)}if(jd){for(kc=0;kc<id;kc++)Ac=Zc[kc],ia=3*kc,Cc[ia]=Ac.r,Cc[ia+1]=Ac.g,Cc[ia+2]=Ac.b;f.bindBuffer(f.ARRAY_BUFFER,sb.__webglColorBuffer);f.bufferData(f.ARRAY_BUFFER,Cc,Oc)}if(Pc)for(Dc=
0,$c=Pc.length;Dc<$c;Dc++)if(ba=Pc[Dc],ba.needsUpdate&&(void 0===ba.boundTo||"vertices"===ba.boundTo)){ia=0;Wb=ba.value.length;if(1===ba.size)for(ya=0;ya<Wb;ya++)ba.array[ya]=ba.value[ya];else if(2===ba.size)for(ya=0;ya<Wb;ya++)Fa=ba.value[ya],ba.array[ia]=Fa.x,ba.array[ia+1]=Fa.y,ia+=2;else if(3===ba.size)if("c"===ba.type)for(ya=0;ya<Wb;ya++)Fa=ba.value[ya],ba.array[ia]=Fa.r,ba.array[ia+1]=Fa.g,ba.array[ia+2]=Fa.b,ia+=3;else for(ya=0;ya<Wb;ya++)Fa=ba.value[ya],ba.array[ia]=Fa.x,ba.array[ia+1]=Fa.y,
ba.array[ia+2]=Fa.z,ia+=3;else if(4===ba.size)for(ya=0;ya<Wb;ya++)Fa=ba.value[ya],ba.array[ia]=Fa.x,ba.array[ia+1]=Fa.y,ba.array[ia+2]=Fa.z,ba.array[ia+3]=Fa.w,ia+=4;f.bindBuffer(f.ARRAY_BUFFER,ba.buffer);f.bufferData(f.ARRAY_BUFFER,ba.array,Oc)}}R.__dirtyVertices=!1;R.__dirtyColors=!1;Ea.attributes&&l(Ea)}else if(Ta instanceof THREE.ParticleSystem)Ea=c(Ta,$b),Qb=Ea.attributes&&n(Ea),(R.__dirtyVertices||R.__dirtyColors||Ta.sortParticles||Qb)&&g(R,f.DYNAMIC_DRAW,Ta),R.__dirtyVertices=!1,R.__dirtyColors=
!1,Ea.attributes&&l(Ea)}};this.initMaterial=function(a,b,c,d){var e,g,h,i,j;a instanceof THREE.MeshDepthMaterial?j="depth":a instanceof THREE.MeshNormalMaterial?j="normal":a instanceof THREE.MeshBasicMaterial?j="basic":a instanceof THREE.MeshLambertMaterial?j="lambert":a instanceof THREE.MeshPhongMaterial?j="phong":a instanceof THREE.LineBasicMaterial?j="basic":a instanceof THREE.ParticleBasicMaterial&&(j="particle_basic");if(j){var k=THREE.ShaderLib[j];a.uniforms=THREE.UniformsUtils.clone(k.uniforms);
a.vertexShader=k.vertexShader;a.fragmentShader=k.fragmentShader}var l,m;g=k=0;for(l=0,m=b.length;l<m;l++)e=b[l],e.onlyShadow||(e instanceof THREE.DirectionalLight&&g++,e instanceof THREE.PointLight&&k++,e instanceof THREE.SpotLight&&k++);k+g<=$?l=g:(l=Math.ceil($*g/(k+g)),k=$-l);e=l;g=k;var n=0;for(k=0,l=b.length;k<l;k++)m=b[k],m.castShadow&&(m instanceof THREE.SpotLight&&n++,m instanceof THREE.DirectionalLight&&!m.shadowCascade&&n++);var p=50;if(void 0!==d&&d instanceof THREE.SkinnedMesh)p=d.bones.length;
var o;a:{l=a.fragmentShader;m=a.vertexShader;var k=a.uniforms,b=a.attributes,c={map:!!a.map,envMap:!!a.envMap,lightMap:!!a.lightMap,vertexColors:a.vertexColors,fog:c,useFog:a.fog,sizeAttenuation:a.sizeAttenuation,skinning:a.skinning,morphTargets:a.morphTargets,morphNormals:a.morphNormals,maxMorphTargets:this.maxMorphTargets,maxMorphNormals:this.maxMorphNormals,maxDirLights:e,maxPointLights:g,maxBones:p,shadowMapEnabled:this.shadowMapEnabled&&d.receiveShadow,shadowMapSoft:this.shadowMapSoft,shadowMapDebug:this.shadowMapDebug,
shadowMapCascade:this.shadowMapCascade,maxShadows:n,alphaTest:a.alphaTest,metal:a.metal,perPixel:a.perPixel,wrapAround:a.wrapAround,doubleSided:d&&d.doubleSided},q,d=[];j?d.push(j):(d.push(l),d.push(m));for(q in c)d.push(q),d.push(c[q]);j=d.join();for(q=0,d=Va.length;q<d;q++)if(Va[q].code===j){o=Va[q].program;break a}q=f.createProgram();d=[0<oc?"#define VERTEX_TEXTURES":"",C.gammaInput?"#define GAMMA_INPUT":"",C.gammaOutput?"#define GAMMA_OUTPUT":"",C.physicallyBasedShading?"#define PHYSICALLY_BASED_SHADING":
"","#define MAX_DIR_LIGHTS "+c.maxDirLights,"#define MAX_POINT_LIGHTS "+c.maxPointLights,"#define MAX_SHADOWS "+c.maxShadows,"#define MAX_BONES "+c.maxBones,c.map?"#define USE_MAP":"",c.envMap?"#define USE_ENVMAP":"",c.lightMap?"#define USE_LIGHTMAP":"",c.vertexColors?"#define USE_COLOR":"",c.skinning?"#define USE_SKINNING":"",c.morphTargets?"#define USE_MORPHTARGETS":"",c.morphNormals?"#define USE_MORPHNORMALS":"",c.perPixel?"#define PHONG_PER_PIXEL":"",c.wrapAround?"#define WRAP_AROUND":"",c.doubleSided?
"#define DOUBLE_SIDED":"",c.shadowMapEnabled?"#define USE_SHADOWMAP":"",c.shadowMapSoft?"#define SHADOWMAP_SOFT":"",c.shadowMapDebug?"#define SHADOWMAP_DEBUG":"",c.shadowMapCascade?"#define SHADOWMAP_CASCADE":"",c.sizeAttenuation?"#define USE_SIZEATTENUATION":"","uniform mat4 objectMatrix;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 viewMatrix;\nuniform mat3 normalMatrix;\nuniform vec3 cameraPosition;\nattribute vec3 position;\nattribute vec3 normal;\nattribute vec2 uv;\nattribute vec2 uv2;\n#ifdef USE_COLOR\nattribute vec3 color;\n#endif\n#ifdef USE_MORPHTARGETS\nattribute vec3 morphTarget0;\nattribute vec3 morphTarget1;\nattribute vec3 morphTarget2;\nattribute vec3 morphTarget3;\n#ifdef USE_MORPHNORMALS\nattribute vec3 morphNormal0;\nattribute vec3 morphNormal1;\nattribute vec3 morphNormal2;\nattribute vec3 morphNormal3;\n#else\nattribute vec3 morphTarget4;\nattribute vec3 morphTarget5;\nattribute vec3 morphTarget6;\nattribute vec3 morphTarget7;\n#endif\n#endif\n#ifdef USE_SKINNING\nattribute vec4 skinVertexA;\nattribute vec4 skinVertexB;\nattribute vec4 skinIndex;\nattribute vec4 skinWeight;\n#endif\n"].join("\n");
e=["precision "+D+" float;","#define MAX_DIR_LIGHTS "+c.maxDirLights,"#define MAX_POINT_LIGHTS "+c.maxPointLights,"#define MAX_SHADOWS "+c.maxShadows,c.alphaTest?"#define ALPHATEST "+c.alphaTest:"",C.gammaInput?"#define GAMMA_INPUT":"",C.gammaOutput?"#define GAMMA_OUTPUT":"",C.physicallyBasedShading?"#define PHYSICALLY_BASED_SHADING":"",c.useFog&&c.fog?"#define USE_FOG":"",c.useFog&&c.fog instanceof THREE.FogExp2?"#define FOG_EXP2":"",c.map?"#define USE_MAP":"",c.envMap?"#define USE_ENVMAP":"",c.lightMap?
"#define USE_LIGHTMAP":"",c.vertexColors?"#define USE_COLOR":"",c.metal?"#define METAL":"",c.perPixel?"#define PHONG_PER_PIXEL":"",c.wrapAround?"#define WRAP_AROUND":"",c.doubleSided?"#define DOUBLE_SIDED":"",c.shadowMapEnabled?"#define USE_SHADOWMAP":"",c.shadowMapSoft?"#define SHADOWMAP_SOFT":"",c.shadowMapDebug?"#define SHADOWMAP_DEBUG":"",c.shadowMapCascade?"#define SHADOWMAP_CASCADE":"","uniform mat4 viewMatrix;\nuniform vec3 cameraPosition;\n"].join("\n");f.attachShader(q,w("fragment",e+l));
f.attachShader(q,w("vertex",d+m));f.linkProgram(q);f.getProgramParameter(q,f.LINK_STATUS)||console.error("Could not initialise shader\nVALIDATE_STATUS: "+f.getProgramParameter(q,f.VALIDATE_STATUS)+", gl error ["+f.getError()+"]");q.uniforms={};q.attributes={};var s,d="viewMatrix,modelViewMatrix,projectionMatrix,normalMatrix,objectMatrix,cameraPosition,boneGlobalMatrices,morphTargetInfluences".split(",");for(s in k)d.push(s);s=d;for(d=0,k=s.length;d<k;d++)l=s[d],q.uniforms[l]=f.getUniformLocation(q,
l);d="position,normal,uv,uv2,tangent,color,skinVertexA,skinVertexB,skinIndex,skinWeight".split(",");for(s=0;s<c.maxMorphTargets;s++)d.push("morphTarget"+s);for(s=0;s<c.maxMorphNormals;s++)d.push("morphNormal"+s);for(o in b)d.push(o);o=d;for(s=0,b=o.length;s<b;s++)c=o[s],q.attributes[c]=f.getAttribLocation(q,c);q.id=Va.length;Va.push({program:q,code:j});C.info.memory.programs=Va.length;o=q}a.program=o;o=a.program.attributes;0<=o.position&&f.enableVertexAttribArray(o.position);0<=o.color&&f.enableVertexAttribArray(o.color);
0<=o.normal&&f.enableVertexAttribArray(o.normal);0<=o.tangent&&f.enableVertexAttribArray(o.tangent);a.skinning&&0<=o.skinVertexA&&0<=o.skinVertexB&&0<=o.skinIndex&&0<=o.skinWeight&&(f.enableVertexAttribArray(o.skinVertexA),f.enableVertexAttribArray(o.skinVertexB),f.enableVertexAttribArray(o.skinIndex),f.enableVertexAttribArray(o.skinWeight));if(a.attributes)for(i in a.attributes)void 0!==o[i]&&0<=o[i]&&f.enableVertexAttribArray(o[i]);if(a.morphTargets){a.numSupportedMorphTargets=0;q="morphTarget";
for(i=0;i<this.maxMorphTargets;i++)s=q+i,0<=o[s]&&(f.enableVertexAttribArray(o[s]),a.numSupportedMorphTargets++)}if(a.morphNormals){a.numSupportedMorphNormals=0;q="morphNormal";for(i=0;i<this.maxMorphNormals;i++)s=q+i,0<=o[s]&&(f.enableVertexAttribArray(o[s]),a.numSupportedMorphNormals++)}a.uniformsList=[];for(h in a.uniforms)a.uniformsList.push([a.uniforms[h],h])};this.setFaceCulling=function(a,b){a?(!b||"ccw"===b?f.frontFace(f.CCW):f.frontFace(f.CW),"back"===a?f.cullFace(f.BACK):"front"===a?f.cullFace(f.FRONT):
f.cullFace(f.FRONT_AND_BACK),f.enable(f.CULL_FACE)):f.disable(f.CULL_FACE)};this.setObjectFaces=function(a){if(xa!==a.doubleSided)a.doubleSided?f.disable(f.CULL_FACE):f.enable(f.CULL_FACE),xa=a.doubleSided;if(T!==a.flipSided)a.flipSided?f.frontFace(f.CW):f.frontFace(f.CCW),T=a.flipSided};this.setDepthTest=function(a){Ga!==a&&(a?f.enable(f.DEPTH_TEST):f.disable(f.DEPTH_TEST),Ga=a)};this.setDepthWrite=function(a){Ha!==a&&(f.depthMask(a),Ha=a)};this.setBlending=function(a){if(a!==Aa){switch(a){case THREE.NoBlending:f.disable(f.BLEND);
break;case THREE.AdditiveBlending:f.enable(f.BLEND);f.blendEquation(f.FUNC_ADD);f.blendFunc(f.SRC_ALPHA,f.ONE);break;case THREE.SubtractiveBlending:f.enable(f.BLEND);f.blendEquation(f.FUNC_ADD);f.blendFunc(f.ZERO,f.ONE_MINUS_SRC_COLOR);break;case THREE.MultiplyBlending:f.enable(f.BLEND);f.blendEquation(f.FUNC_ADD);f.blendFunc(f.ZERO,f.SRC_COLOR);break;default:f.enable(f.BLEND),f.blendEquationSeparate(f.FUNC_ADD,f.FUNC_ADD),f.blendFuncSeparate(f.SRC_ALPHA,f.ONE_MINUS_SRC_ALPHA,f.ONE,f.ONE_MINUS_SRC_ALPHA)}Aa=
a}};this.setTexture=function(a,b){if(a.needsUpdate){if(!a.__webglInit)a.__webglInit=!0,a.__webglTexture=f.createTexture(),C.info.memory.textures++;f.activeTexture(f.TEXTURE0+b);f.bindTexture(f.TEXTURE_2D,a.__webglTexture);var c=a.image,d=0===(c.width&c.width-1)&&0===(c.height&c.height-1),e=H(a.format),g=H(a.type);N(f.TEXTURE_2D,a,d);a instanceof THREE.DataTexture?f.texImage2D(f.TEXTURE_2D,0,e,c.width,c.height,0,e,g,c.data):f.texImage2D(f.TEXTURE_2D,0,e,e,g,a.image);a.generateMipmaps&&d&&f.generateMipmap(f.TEXTURE_2D);
a.needsUpdate=!1;if(a.onUpdate)a.onUpdate()}else f.activeTexture(f.TEXTURE0+b),f.bindTexture(f.TEXTURE_2D,a.__webglTexture)};this.setRenderTarget=function(a){var b=a instanceof THREE.WebGLRenderTargetCube;if(a&&!a.__webglFramebuffer){if(void 0===a.depthBuffer)a.depthBuffer=!0;if(void 0===a.stencilBuffer)a.stencilBuffer=!0;a.__webglTexture=f.createTexture();var c=0===(a.width&a.width-1)&&0===(a.height&a.height-1),d=H(a.format),e=H(a.type);if(b){a.__webglFramebuffer=[];a.__webglRenderbuffer=[];f.bindTexture(f.TEXTURE_CUBE_MAP,
a.__webglTexture);N(f.TEXTURE_CUBE_MAP,a,c);for(c=0;6>c;c++){a.__webglFramebuffer[c]=f.createFramebuffer();a.__webglRenderbuffer[c]=f.createRenderbuffer();f.texImage2D(f.TEXTURE_CUBE_MAP_POSITIVE_X+c,0,d,a.width,a.height,0,d,e,null);var g=a,h=f.TEXTURE_CUBE_MAP_POSITIVE_X+c;f.bindFramebuffer(f.FRAMEBUFFER,a.__webglFramebuffer[c]);f.framebufferTexture2D(f.FRAMEBUFFER,f.COLOR_ATTACHMENT0,h,g.__webglTexture,0);A(a.__webglRenderbuffer[c],a)}}else a.__webglFramebuffer=f.createFramebuffer(),a.__webglRenderbuffer=
f.createRenderbuffer(),f.bindTexture(f.TEXTURE_2D,a.__webglTexture),N(f.TEXTURE_2D,a,c),f.texImage2D(f.TEXTURE_2D,0,d,a.width,a.height,0,d,e,null),d=f.TEXTURE_2D,f.bindFramebuffer(f.FRAMEBUFFER,a.__webglFramebuffer),f.framebufferTexture2D(f.FRAMEBUFFER,f.COLOR_ATTACHMENT0,d,a.__webglTexture,0),A(a.__webglRenderbuffer,a);b?f.bindTexture(f.TEXTURE_CUBE_MAP,null):f.bindTexture(f.TEXTURE_2D,null);f.bindRenderbuffer(f.RENDERBUFFER,null);f.bindFramebuffer(f.FRAMEBUFFER,null)}a?(b=b?a.__webglFramebuffer[a.activeCubeFace]:
a.__webglFramebuffer,d=a.width,a=a.height,c=e=0):(b=null,d=Hb,a=Ob,e=Nb,c=Xb);b!==S&&(f.bindFramebuffer(f.FRAMEBUFFER,b),f.viewport(e,c,d,a),S=b);lc=d;mc=a};this.shadowMapPlugin=new THREE.ShadowMapPlugin;this.addPrePlugin(this.shadowMapPlugin);this.addPostPlugin(new THREE.SpritePlugin);this.addPostPlugin(new THREE.LensFlarePlugin)};
THREE.WebGLRenderTarget=function(a,b,c){this.width=a;this.height=b;c=c||{};this.wrapS=void 0!==c.wrapS?c.wrapS:THREE.ClampToEdgeWrapping;this.wrapT=void 0!==c.wrapT?c.wrapT:THREE.ClampToEdgeWrapping;this.magFilter=void 0!==c.magFilter?c.magFilter:THREE.LinearFilter;this.minFilter=void 0!==c.minFilter?c.minFilter:THREE.LinearMipMapLinearFilter;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.format=void 0!==c.format?c.format:THREE.RGBAFormat;this.type=void 0!==c.type?c.type:
THREE.UnsignedByteType;this.depthBuffer=void 0!==c.depthBuffer?c.depthBuffer:!0;this.stencilBuffer=void 0!==c.stencilBuffer?c.stencilBuffer:!0;this.generateMipmaps=!0};
THREE.WebGLRenderTarget.prototype.clone=function(){var a=new THREE.WebGLRenderTarget(this.width,this.height);a.wrapS=this.wrapS;a.wrapT=this.wrapT;a.magFilter=this.magFilter;a.minFilter=this.minFilter;a.offset.copy(this.offset);a.repeat.copy(this.repeat);a.format=this.format;a.type=this.type;a.depthBuffer=this.depthBuffer;a.stencilBuffer=this.stencilBuffer;return a};THREE.WebGLRenderTargetCube=function(a,b,c){THREE.WebGLRenderTarget.call(this,a,b,c);this.activeCubeFace=0};
THREE.WebGLRenderTargetCube.prototype=new THREE.WebGLRenderTarget;THREE.WebGLRenderTargetCube.prototype.constructor=THREE.WebGLRenderTargetCube;THREE.RenderableVertex=function(){this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.visible=!0};THREE.RenderableVertex.prototype.copy=function(a){this.positionWorld.copy(a.positionWorld);this.positionScreen.copy(a.positionScreen)};
THREE.RenderableFace3=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterial=this.material=null;this.uvs=[[]];this.z=null};
THREE.RenderableFace4=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.v4=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterial=this.material=null;this.uvs=[[]];this.z=null};THREE.RenderableObject=function(){this.z=this.object=null};
THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.material=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.material=null};
THREE.BufferGeometry=function(){this.id=THREE.GeometryCount++;this.vertexColorArray=this.vertexUvArray=this.vertexNormalArray=this.vertexPositionArray=this.vertexIndexArray=this.vertexColorBuffer=this.vertexUvBuffer=this.vertexNormalBuffer=this.vertexPositionBuffer=this.vertexIndexBuffer=null;this.dynamic=!1;this.boundingSphere=this.boundingBox=null;this.morphTargets=[]};THREE.BufferGeometry.prototype={constructor:THREE.BufferGeometry,computeBoundingBox:function(){},computeBoundingSphere:function(){}};
THREE.Gyroscope=function(){THREE.Object3D.call(this)};THREE.Gyroscope.prototype=new THREE.Object3D;THREE.Gyroscope.prototype.constructor=THREE.Gyroscope;
THREE.Gyroscope.prototype.updateMatrixWorld=function(a){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||a)this.parent?(this.matrixWorld.multiply(this.parent.matrixWorld,this.matrix),this.matrixWorld.decompose(this.translationWorld,this.rotationWorld,this.scaleWorld),this.matrix.decompose(this.translationObject,this.rotationObject,this.scaleObject),this.matrixWorld.compose(this.translationWorld,this.rotationObject,this.scaleWorld)):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=
!1,a=!0;for(var b=0,c=this.children.length;b<c;b++)this.children[b].updateMatrixWorld(a)};THREE.Gyroscope.prototype.translationWorld=new THREE.Vector3;THREE.Gyroscope.prototype.translationObject=new THREE.Vector3;THREE.Gyroscope.prototype.rotationWorld=new THREE.Quaternion;THREE.Gyroscope.prototype.rotationObject=new THREE.Quaternion;THREE.Gyroscope.prototype.scaleWorld=new THREE.Vector3;THREE.Gyroscope.prototype.scaleObject=new THREE.Vector3;
THREE.CameraHelper=function(a){function b(a,b,d){c(a,d);c(b,d)}function c(a,b){d.lineGeometry.vertices.push(new THREE.Vertex(new THREE.Vector3));d.lineGeometry.colors.push(new THREE.Color(b));void 0===d.pointMap[a]&&(d.pointMap[a]=[]);d.pointMap[a].push(d.lineGeometry.vertices.length-1)}THREE.Object3D.call(this);var d=this;this.lineGeometry=new THREE.Geometry;this.lineMaterial=new THREE.LineBasicMaterial({color:16777215,vertexColors:THREE.FaceColors});this.pointMap={};b("n1","n2",16755200);b("n2",
"n4",16755200);b("n4","n3",16755200);b("n3","n1",16755200);b("f1","f2",16755200);b("f2","f4",16755200);b("f4","f3",16755200);b("f3","f1",16755200);b("n1","f1",16755200);b("n2","f2",16755200);b("n3","f3",16755200);b("n4","f4",16755200);b("p","n1",16711680);b("p","n2",16711680);b("p","n3",16711680);b("p","n4",16711680);b("u1","u2",43775);b("u2","u3",43775);b("u3","u1",43775);b("c","t",16777215);b("p","c",3355443);b("cn1","cn2",3355443);b("cn3","cn4",3355443);b("cf1","cf2",3355443);b("cf3","cf4",3355443);
this.update(a);this.lines=new THREE.Line(this.lineGeometry,this.lineMaterial,THREE.LinePieces);this.add(this.lines)};THREE.CameraHelper.prototype=new THREE.Object3D;THREE.CameraHelper.prototype.constructor=THREE.CameraHelper;
THREE.CameraHelper.prototype.update=function(a){function b(a,b,g,h){THREE.CameraHelper.__v.set(b,g,h);THREE.CameraHelper.__projector.unprojectVector(THREE.CameraHelper.__v,THREE.CameraHelper.__c);a=c.pointMap[a];if(void 0!==a){b=0;for(g=a.length;b<g;b++)c.lineGeometry.vertices[a[b]].position.copy(THREE.CameraHelper.__v)}}var c=this;THREE.CameraHelper.__c.projectionMatrix.copy(a.projectionMatrix);b("c",0,0,-1);b("t",0,0,1);b("n1",-1,-1,-1);b("n2",1,-1,-1);b("n3",-1,1,-1);b("n4",1,1,-1);b("f1",-1,-1,
1);b("f2",1,-1,1);b("f3",-1,1,1);b("f4",1,1,1);b("u1",0.7,1.1,-1);b("u2",-0.7,1.1,-1);b("u3",0,2,-1);b("cf1",-1,0,1);b("cf2",1,0,1);b("cf3",0,-1,1);b("cf4",0,1,1);b("cn1",-1,0,-1);b("cn2",1,0,-1);b("cn3",0,-1,-1);b("cn4",0,1,-1);this.lineGeometry.__dirtyVertices=!0};THREE.CameraHelper.__projector=new THREE.Projector;THREE.CameraHelper.__v=new THREE.Vector3;THREE.CameraHelper.__c=new THREE.Camera;
THREE.LensFlare=function(a,b,c,d,e){THREE.Object3D.call(this);this.lensFlares=[];this.positionScreen=new THREE.Vector3;this.customUpdateCallback=void 0;void 0!==a&&this.add(a,b,c,d,e)};THREE.LensFlare.prototype=new THREE.Object3D;THREE.LensFlare.prototype.constructor=THREE.LensFlare;THREE.LensFlare.prototype.supr=THREE.Object3D.prototype;
THREE.LensFlare.prototype.add=function(a,b,c,d,e,g){void 0===b&&(b=-1);void 0===c&&(c=0);void 0===g&&(g=1);void 0===e&&(e=new THREE.Color(16777215));if(void 0===d)d=THREE.NormalBlending;c=Math.min(c,Math.max(0,c));this.lensFlares.push({texture:a,size:b,distance:c,x:0,y:0,z:0,scale:1,rotation:1,opacity:g,color:e,blending:d})};
THREE.LensFlare.prototype.updateLensFlares=function(){var a,b=this.lensFlares.length,c,d=2*-this.positionScreen.x,e=2*-this.positionScreen.y;for(a=0;a<b;a++)c=this.lensFlares[a],c.x=this.positionScreen.x+d*c.distance,c.y=this.positionScreen.y+e*c.distance,c.wantedRotation=0.25*c.x*Math.PI,c.rotation+=0.25*(c.wantedRotation-c.rotation)};
THREE.MarchingCubes=function(a,b){THREE.Object3D.call(this);this.material=b;this.init=function(a){this.resolution=a;this.isolation=80;this.size=a;this.size2=this.size*this.size;this.size3=this.size2*this.size;this.halfsize=this.size/2;this.delta=2/this.size;this.yd=this.size;this.zd=this.size2;this.field=new Float32Array(this.size3);this.normal_cache=new Float32Array(3*this.size3);this.vlist=new Float32Array(36);this.nlist=new Float32Array(36);this.firstDraw=!0;this.maxCount=4096;this.count=0;this.hasNormal=
this.hasPos=!1;this.positionArray=new Float32Array(3*this.maxCount);this.normalArray=new Float32Array(3*this.maxCount)};this.lerp=function(a,b,e){return a+(b-a)*e};this.VIntX=function(a,b,e,g,h,i,m,k,j,n){h=(h-j)/(n-j);j=this.normal_cache;b[g]=i+h*this.delta;b[g+1]=m;b[g+2]=k;e[g]=this.lerp(j[a],j[a+3],h);e[g+1]=this.lerp(j[a+1],j[a+4],h);e[g+2]=this.lerp(j[a+2],j[a+5],h)};this.VIntY=function(a,b,e,g,h,i,m,k,j,n){h=(h-j)/(n-j);j=this.normal_cache;b[g]=i;b[g+1]=m+h*this.delta;b[g+2]=k;b=a+3*this.yd;
e[g]=this.lerp(j[a],j[b],h);e[g+1]=this.lerp(j[a+1],j[b+1],h);e[g+2]=this.lerp(j[a+2],j[b+2],h)};this.VIntZ=function(a,b,e,g,h,i,m,k,j,n){h=(h-j)/(n-j);j=this.normal_cache;b[g]=i;b[g+1]=m;b[g+2]=k+h*this.delta;b=a+3*this.zd;e[g]=this.lerp(j[a],j[b],h);e[g+1]=this.lerp(j[a+1],j[b+1],h);e[g+2]=this.lerp(j[a+2],j[b+2],h)};this.compNorm=function(a){var b=3*a;0===this.normal_cache[b]&&(this.normal_cache[b]=this.field[a-1]-this.field[a+1],this.normal_cache[b+1]=this.field[a-this.yd]-this.field[a+this.yd],
this.normal_cache[b+2]=this.field[a-this.zd]-this.field[a+this.zd])};this.polygonize=function(a,b,e,g,h,i){var m=g+1,k=g+this.yd,j=g+this.zd,n=m+this.yd,l=m+this.zd,q=g+this.yd+this.zd,o=m+this.yd+this.zd,p=0,s=this.field[g],y=this.field[m],w=this.field[k],N=this.field[n],A=this.field[j],u=this.field[l],H=this.field[q],I=this.field[o];s<h&&(p|=1);y<h&&(p|=2);w<h&&(p|=8);N<h&&(p|=4);A<h&&(p|=16);u<h&&(p|=32);H<h&&(p|=128);I<h&&(p|=64);var D=THREE.edgeTable[p];if(0===D)return 0;var L=this.delta,K=a+
L,M=b+L,L=e+L;D&1&&(this.compNorm(g),this.compNorm(m),this.VIntX(3*g,this.vlist,this.nlist,0,h,a,b,e,s,y));D&2&&(this.compNorm(m),this.compNorm(n),this.VIntY(3*m,this.vlist,this.nlist,3,h,K,b,e,y,N));D&4&&(this.compNorm(k),this.compNorm(n),this.VIntX(3*k,this.vlist,this.nlist,6,h,a,M,e,w,N));D&8&&(this.compNorm(g),this.compNorm(k),this.VIntY(3*g,this.vlist,this.nlist,9,h,a,b,e,s,w));D&16&&(this.compNorm(j),this.compNorm(l),this.VIntX(3*j,this.vlist,this.nlist,12,h,a,b,L,A,u));D&32&&(this.compNorm(l),
this.compNorm(o),this.VIntY(3*l,this.vlist,this.nlist,15,h,K,b,L,u,I));D&64&&(this.compNorm(q),this.compNorm(o),this.VIntX(3*q,this.vlist,this.nlist,18,h,a,M,L,H,I));D&128&&(this.compNorm(j),this.compNorm(q),this.VIntY(3*j,this.vlist,this.nlist,21,h,a,b,L,A,H));D&256&&(this.compNorm(g),this.compNorm(j),this.VIntZ(3*g,this.vlist,this.nlist,24,h,a,b,e,s,A));D&512&&(this.compNorm(m),this.compNorm(l),this.VIntZ(3*m,this.vlist,this.nlist,27,h,K,b,e,y,u));D&1024&&(this.compNorm(n),this.compNorm(o),this.VIntZ(3*
n,this.vlist,this.nlist,30,h,K,M,e,N,I));D&2048&&(this.compNorm(k),this.compNorm(q),this.VIntZ(3*k,this.vlist,this.nlist,33,h,a,M,e,w,H));p<<=4;for(h=g=0;-1!=THREE.triTable[p+h];)a=p+h,b=a+1,e=a+2,this.posnormtriv(this.vlist,this.nlist,3*THREE.triTable[a],3*THREE.triTable[b],3*THREE.triTable[e],i),h+=3,g++;return g};this.posnormtriv=function(a,b,e,g,h,i){var m=3*this.count;this.positionArray[m]=a[e];this.positionArray[m+1]=a[e+1];this.positionArray[m+2]=a[e+2];this.positionArray[m+3]=a[g];this.positionArray[m+
4]=a[g+1];this.positionArray[m+5]=a[g+2];this.positionArray[m+6]=a[h];this.positionArray[m+7]=a[h+1];this.positionArray[m+8]=a[h+2];this.normalArray[m]=b[e];this.normalArray[m+1]=b[e+1];this.normalArray[m+2]=b[e+2];this.normalArray[m+3]=b[g];this.normalArray[m+4]=b[g+1];this.normalArray[m+5]=b[g+2];this.normalArray[m+6]=b[h];this.normalArray[m+7]=b[h+1];this.normalArray[m+8]=b[h+2];this.hasNormal=this.hasPos=!0;this.count+=3;this.count>=this.maxCount-3&&i(this)};this.begin=function(){this.count=0;
this.hasNormal=this.hasPos=!1};this.end=function(a){if(0!==this.count){for(var b=3*this.count;b<this.positionArray.length;b++)this.positionArray[b]=0;a(this)}};this.addBall=function(a,b,e,g,h){var i=this.size*Math.sqrt(g/h),m=e*this.size,k=b*this.size,j=a*this.size,n=Math.floor(m-i);1>n&&(n=1);m=Math.floor(m+i);m>this.size-1&&(m=this.size-1);var l=Math.floor(k-i);1>l&&(l=1);k=Math.floor(k+i);k>this.size-1&&(k=this.size-1);var q=Math.floor(j-i);1>q&&(q=1);i=Math.floor(j+i);i>this.size-1&&(i=this.size-
1);for(var o,p,s,y,w,N,A,j=n;j<m;j++){s=this.size2*j;w=j/this.size-e;N=w*w;for(n=l;n<k;n++){p=s+this.size*n;o=n/this.size-b;A=o*o;for(o=q;o<i;o++)y=o/this.size-a,y=g/(1.0E-6+y*y+A+N)-h,0<y&&(this.field[p+o]+=y)}}};this.addPlaneX=function(a,b){var e,g,h,i,m,k=this.size,j=this.yd,n=this.zd,l=this.field,q=k*Math.sqrt(a/b);q>k&&(q=k);for(e=0;e<q;e++)if(g=e/k,g*=g,i=a/(1.0E-4+g)-b,0<i)for(g=0;g<k;g++){m=e+g*j;for(h=0;h<k;h++)l[n*h+m]+=i}};this.addPlaneY=function(a,b){var e,g,h,i,m,k,j=this.size,n=this.yd,
l=this.zd,q=this.field,o=j*Math.sqrt(a/b);o>j&&(o=j);for(g=0;g<o;g++)if(e=g/j,e*=e,i=a/(1.0E-4+e)-b,0<i){m=g*n;for(e=0;e<j;e++){k=m+e;for(h=0;h<j;h++)q[l*h+k]+=i}}};this.addPlaneZ=function(a,b){var e,g,h,i,m,k,j=this.size,n=this.yd,l=this.zd,q=this.field,o=j*Math.sqrt(a/b);o>j&&(o=j);for(h=0;h<o;h++)if(e=h/j,e*=e,i=a/(1.0E-4+e)-b,0<i){m=l*h;for(g=0;g<j;g++){k=m+g*n;for(e=0;e<j;e++)q[k+e]+=i}}};this.reset=function(){var a;for(a=0;a<this.size3;a++)this.normal_cache[3*a]=0,this.field[a]=0};this.render=
function(a){this.begin();var b,e,g,h,i,m,k,j,n,l=this.size-2;for(h=1;h<l;h++){n=this.size2*h;k=(h-this.halfsize)/this.halfsize;for(g=1;g<l;g++){j=n+this.size*g;m=(g-this.halfsize)/this.halfsize;for(e=1;e<l;e++)i=(e-this.halfsize)/this.halfsize,b=j+e,this.polygonize(i,m,k,b,this.isolation,a)}}this.end(a)};this.generateGeometry=function(){var a=0,b=new THREE.Geometry,e=[];this.render(function(g){var h,i,m,k,j,n,l,q;for(h=0;h<g.count;h++)l=3*h,j=l+1,q=l+2,i=g.positionArray[l],m=g.positionArray[j],k=
g.positionArray[q],n=new THREE.Vector3(i,m,k),i=g.normalArray[l],m=g.normalArray[j],k=g.normalArray[q],l=new THREE.Vector3(i,m,k),l.normalize(),j=new THREE.Vertex(n),b.vertices.push(j),e.push(l);n=g.count/3;for(h=0;h<n;h++)l=3*(a+h),j=l+1,q=l+2,i=e[l],m=e[j],k=e[q],l=new THREE.Face3(l,j,q,[i,m,k]),b.faces.push(l);a+=n;g.count=0});return b};this.init(a)};THREE.MarchingCubes.prototype=new THREE.Object3D;THREE.MarchingCubes.prototype.constructor=THREE.MarchingCubes;
THREE.edgeTable=new Int32Array([0,265,515,778,1030,1295,1541,1804,2060,2309,2575,2822,3082,3331,3593,3840,400,153,915,666,1430,1183,1941,1692,2460,2197,2975,2710,3482,3219,3993,3728,560,825,51,314,1590,1855,1077,1340,2620,2869,2111,2358,3642,3891,3129,3376,928,681,419,170,1958,1711,1445,1196,2988,2725,2479,2214,4010,3747,3497,3232,1120,1385,1635,1898,102,367,613,876,3180,3429,3695,3942,2154,2403,2665,2912,1520,1273,2035,1786,502,255,1013,764,3580,3317,4095,3830,2554,2291,3065,2800,1616,1881,1107,
1370,598,863,85,348,3676,3925,3167,3414,2650,2899,2137,2384,1984,1737,1475,1226,966,719,453,204,4044,3781,3535,3270,3018,2755,2505,2240,2240,2505,2755,3018,3270,3535,3781,4044,204,453,719,966,1226,1475,1737,1984,2384,2137,2899,2650,3414,3167,3925,3676,348,85,863,598,1370,1107,1881,1616,2800,3065,2291,2554,3830,4095,3317,3580,764,1013,255,502,1786,2035,1273,1520,2912,2665,2403,2154,3942,3695,3429,3180,876,613,367,102,1898,1635,1385,1120,3232,3497,3747,4010,2214,2479,2725,2988,1196,1445,1711,1958,170,
419,681,928,3376,3129,3891,3642,2358,2111,2869,2620,1340,1077,1855,1590,314,51,825,560,3728,3993,3219,3482,2710,2975,2197,2460,1692,1941,1183,1430,666,915,153,400,3840,3593,3331,3082,2822,2575,2309,2060,1804,1541,1295,1030,778,515,265,0]);
THREE.triTable=new Int32Array([-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,9,8,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,2,10,0,2,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,8,3,2,10,8,10,9,8,-1,-1,-1,-1,-1,-1,-1,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,8,11,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,11,-1,-1,-1,-1,-1,
-1,-1,-1,-1,-1,1,11,2,1,9,11,9,8,11,-1,-1,-1,-1,-1,-1,-1,3,10,1,11,10,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,10,1,0,8,10,8,11,10,-1,-1,-1,-1,-1,-1,-1,3,9,0,3,11,9,11,10,9,-1,-1,-1,-1,-1,-1,-1,9,8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,7,3,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,1,9,4,7,1,7,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,4,7,3,0,4,1,2,10,-1,-1,-1,-1,-1,-1,-1,9,2,10,9,0,2,8,4,7,
-1,-1,-1,-1,-1,-1,-1,2,10,9,2,9,7,2,7,3,7,9,4,-1,-1,-1,-1,8,4,7,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,4,7,11,2,4,2,0,4,-1,-1,-1,-1,-1,-1,-1,9,0,1,8,4,7,2,3,11,-1,-1,-1,-1,-1,-1,-1,4,7,11,9,4,11,9,11,2,9,2,1,-1,-1,-1,-1,3,10,1,3,11,10,7,8,4,-1,-1,-1,-1,-1,-1,-1,1,11,10,1,4,11,1,0,4,7,11,4,-1,-1,-1,-1,4,7,8,9,0,11,9,11,10,11,0,3,-1,-1,-1,-1,4,7,11,4,11,9,9,11,10,-1,-1,-1,-1,-1,-1,-1,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,5,4,1,5,0,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,8,5,4,8,3,5,3,1,5,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,10,4,9,5,-1,-1,-1,-1,-1,-1,-1,5,2,10,5,4,2,4,0,2,-1,-1,-1,-1,-1,-1,-1,2,10,5,3,2,5,3,5,4,3,4,8,-1,-1,-1,-1,9,5,4,2,3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,0,8,11,4,9,5,-1,-1,-1,-1,-1,-1,-1,0,5,4,0,1,5,2,3,11,-1,-1,-1,-1,-1,-1,-1,2,1,5,2,5,8,2,8,11,4,8,5,-1,-1,-1,-1,10,3,11,10,1,3,9,5,4,-1,-1,-1,-1,-1,-1,-1,4,9,5,0,8,1,8,10,1,8,11,10,-1,-1,-1,-1,5,4,0,5,0,11,5,11,10,11,0,3,-1,-1,-1,-1,5,4,8,5,
8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,9,7,8,5,7,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,3,0,9,5,3,5,7,3,-1,-1,-1,-1,-1,-1,-1,0,7,8,0,1,7,1,5,7,-1,-1,-1,-1,-1,-1,-1,1,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,7,8,9,5,7,10,1,2,-1,-1,-1,-1,-1,-1,-1,10,1,2,9,5,0,5,3,0,5,7,3,-1,-1,-1,-1,8,0,2,8,2,5,8,5,7,10,5,2,-1,-1,-1,-1,2,10,5,2,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,7,9,5,7,8,9,3,11,2,-1,-1,-1,-1,-1,-1,-1,9,5,7,9,7,2,9,2,0,2,7,11,-1,-1,-1,-1,2,3,11,0,1,8,1,7,8,1,5,7,-1,-1,-1,-1,11,2,1,11,1,7,7,1,5,-1,-1,-1,-1,-1,-1,
-1,9,5,8,8,5,7,10,1,3,10,3,11,-1,-1,-1,-1,5,7,0,5,0,9,7,11,0,1,0,10,11,10,0,-1,11,10,0,11,0,3,10,5,0,8,0,7,5,7,0,-1,11,10,5,7,11,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,6,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,0,1,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,1,9,8,5,10,6,-1,-1,-1,-1,-1,-1,-1,1,6,5,2,6,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,6,5,1,2,6,3,0,8,-1,-1,-1,-1,-1,-1,-1,9,6,5,9,0,6,0,2,6,-1,-1,-1,-1,-1,-1,-1,5,9,8,5,8,2,5,2,6,3,2,8,-1,-1,-1,-1,2,3,11,10,6,
5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,0,8,11,2,0,10,6,5,-1,-1,-1,-1,-1,-1,-1,0,1,9,2,3,11,5,10,6,-1,-1,-1,-1,-1,-1,-1,5,10,6,1,9,2,9,11,2,9,8,11,-1,-1,-1,-1,6,3,11,6,5,3,5,1,3,-1,-1,-1,-1,-1,-1,-1,0,8,11,0,11,5,0,5,1,5,11,6,-1,-1,-1,-1,3,11,6,0,3,6,0,6,5,0,5,9,-1,-1,-1,-1,6,5,9,6,9,11,11,9,8,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,4,7,3,6,5,10,-1,-1,-1,-1,-1,-1,-1,1,9,0,5,10,6,8,4,7,-1,-1,-1,-1,-1,-1,-1,10,6,5,1,9,7,1,7,3,7,9,4,-1,-1,-1,-1,6,1,2,6,5,1,4,7,8,-1,-1,-1,-1,
-1,-1,-1,1,2,5,5,2,6,3,0,4,3,4,7,-1,-1,-1,-1,8,4,7,9,0,5,0,6,5,0,2,6,-1,-1,-1,-1,7,3,9,7,9,4,3,2,9,5,9,6,2,6,9,-1,3,11,2,7,8,4,10,6,5,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,2,4,2,0,2,7,11,-1,-1,-1,-1,0,1,9,4,7,8,2,3,11,5,10,6,-1,-1,-1,-1,9,2,1,9,11,2,9,4,11,7,11,4,5,10,6,-1,8,4,7,3,11,5,3,5,1,5,11,6,-1,-1,-1,-1,5,1,11,5,11,6,1,0,11,7,11,4,0,4,11,-1,0,5,9,0,6,5,0,3,6,11,6,3,8,4,7,-1,6,5,9,6,9,11,4,7,9,7,11,9,-1,-1,-1,-1,10,4,9,6,4,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,10,6,4,9,10,0,8,3,-1,-1,-1,-1,-1,-1,-1,
10,0,1,10,6,0,6,4,0,-1,-1,-1,-1,-1,-1,-1,8,3,1,8,1,6,8,6,4,6,1,10,-1,-1,-1,-1,1,4,9,1,2,4,2,6,4,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,9,2,4,9,2,6,4,-1,-1,-1,-1,0,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,3,2,8,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,10,4,9,10,6,4,11,2,3,-1,-1,-1,-1,-1,-1,-1,0,8,2,2,8,11,4,9,10,4,10,6,-1,-1,-1,-1,3,11,2,0,1,6,0,6,4,6,1,10,-1,-1,-1,-1,6,4,1,6,1,10,4,8,1,2,1,11,8,11,1,-1,9,6,4,9,3,6,9,1,3,11,6,3,-1,-1,-1,-1,8,11,1,8,1,0,11,6,1,9,1,4,6,4,1,-1,3,11,6,3,6,0,0,6,4,-1,-1,-1,-1,-1,-1,-1,
6,4,8,11,6,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,10,6,7,8,10,8,9,10,-1,-1,-1,-1,-1,-1,-1,0,7,3,0,10,7,0,9,10,6,7,10,-1,-1,-1,-1,10,6,7,1,10,7,1,7,8,1,8,0,-1,-1,-1,-1,10,6,7,10,7,1,1,7,3,-1,-1,-1,-1,-1,-1,-1,1,2,6,1,6,8,1,8,9,8,6,7,-1,-1,-1,-1,2,6,9,2,9,1,6,7,9,0,9,3,7,3,9,-1,7,8,0,7,0,6,6,0,2,-1,-1,-1,-1,-1,-1,-1,7,3,2,6,7,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,11,10,6,8,10,8,9,8,6,7,-1,-1,-1,-1,2,0,7,2,7,11,0,9,7,6,7,10,9,10,7,-1,1,8,0,1,7,8,1,10,7,6,7,10,2,3,11,-1,11,2,1,11,1,7,10,6,1,6,7,1,-1,-1,-1,-1,
8,9,6,8,6,7,9,1,6,11,6,3,1,3,6,-1,0,9,1,11,6,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,8,0,7,0,6,3,11,0,11,6,0,-1,-1,-1,-1,7,11,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,1,9,8,3,1,11,7,6,-1,-1,-1,-1,-1,-1,-1,10,1,2,6,11,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,3,0,8,6,11,7,-1,-1,-1,-1,-1,-1,-1,2,9,0,2,10,9,6,11,7,-1,-1,-1,-1,-1,-1,-1,6,11,7,2,10,3,10,8,3,10,9,8,-1,-1,-1,-1,7,
2,3,6,2,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,0,8,7,6,0,6,2,0,-1,-1,-1,-1,-1,-1,-1,2,7,6,2,3,7,0,1,9,-1,-1,-1,-1,-1,-1,-1,1,6,2,1,8,6,1,9,8,8,7,6,-1,-1,-1,-1,10,7,6,10,1,7,1,3,7,-1,-1,-1,-1,-1,-1,-1,10,7,6,1,7,10,1,8,7,1,0,8,-1,-1,-1,-1,0,3,7,0,7,10,0,10,9,6,10,7,-1,-1,-1,-1,7,6,10,7,10,8,8,10,9,-1,-1,-1,-1,-1,-1,-1,6,8,4,11,8,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,6,11,3,0,6,0,4,6,-1,-1,-1,-1,-1,-1,-1,8,6,11,8,4,6,9,0,1,-1,-1,-1,-1,-1,-1,-1,9,4,6,9,6,3,9,3,1,11,3,6,-1,-1,-1,-1,6,8,4,6,11,8,2,10,1,-1,-1,-1,
-1,-1,-1,-1,1,2,10,3,0,11,0,6,11,0,4,6,-1,-1,-1,-1,4,11,8,4,6,11,0,2,9,2,10,9,-1,-1,-1,-1,10,9,3,10,3,2,9,4,3,11,3,6,4,6,3,-1,8,2,3,8,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,0,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,4,2,4,6,4,3,8,-1,-1,-1,-1,1,9,4,1,4,2,2,4,6,-1,-1,-1,-1,-1,-1,-1,8,1,3,8,6,1,8,4,6,6,10,1,-1,-1,-1,-1,10,1,0,10,0,6,6,0,4,-1,-1,-1,-1,-1,-1,-1,4,6,3,4,3,8,6,10,3,0,3,9,10,9,3,-1,10,9,4,6,10,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,5,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,5,11,7,6,
-1,-1,-1,-1,-1,-1,-1,5,0,1,5,4,0,7,6,11,-1,-1,-1,-1,-1,-1,-1,11,7,6,8,3,4,3,5,4,3,1,5,-1,-1,-1,-1,9,5,4,10,1,2,7,6,11,-1,-1,-1,-1,-1,-1,-1,6,11,7,1,2,10,0,8,3,4,9,5,-1,-1,-1,-1,7,6,11,5,4,10,4,2,10,4,0,2,-1,-1,-1,-1,3,4,8,3,5,4,3,2,5,10,5,2,11,7,6,-1,7,2,3,7,6,2,5,4,9,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,6,0,6,2,6,8,7,-1,-1,-1,-1,3,6,2,3,7,6,1,5,0,5,4,0,-1,-1,-1,-1,6,2,8,6,8,7,2,1,8,4,8,5,1,5,8,-1,9,5,4,10,1,6,1,7,6,1,3,7,-1,-1,-1,-1,1,6,10,1,7,6,1,0,7,8,7,0,9,5,4,-1,4,0,10,4,10,5,0,3,10,6,10,7,3,7,10,
-1,7,6,10,7,10,8,5,4,10,4,8,10,-1,-1,-1,-1,6,9,5,6,11,9,11,8,9,-1,-1,-1,-1,-1,-1,-1,3,6,11,0,6,3,0,5,6,0,9,5,-1,-1,-1,-1,0,11,8,0,5,11,0,1,5,5,6,11,-1,-1,-1,-1,6,11,3,6,3,5,5,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,11,9,11,8,11,5,6,-1,-1,-1,-1,0,11,3,0,6,11,0,9,6,5,6,9,1,2,10,-1,11,8,5,11,5,6,8,0,5,10,5,2,0,2,5,-1,6,11,3,6,3,5,2,10,3,10,5,3,-1,-1,-1,-1,5,8,9,5,2,8,5,6,2,3,8,2,-1,-1,-1,-1,9,5,6,9,6,0,0,6,2,-1,-1,-1,-1,-1,-1,-1,1,5,8,1,8,0,5,6,8,3,8,2,6,2,8,-1,1,5,6,2,1,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
1,3,6,1,6,10,3,8,6,5,6,9,8,9,6,-1,10,1,0,10,0,6,9,5,0,5,6,0,-1,-1,-1,-1,0,3,8,5,6,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,5,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,7,5,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,11,7,5,8,3,0,-1,-1,-1,-1,-1,-1,-1,5,11,7,5,10,11,1,9,0,-1,-1,-1,-1,-1,-1,-1,10,7,5,10,11,7,9,8,1,8,3,1,-1,-1,-1,-1,11,1,2,11,7,1,7,5,1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,7,1,7,5,7,2,11,-1,-1,-1,-1,9,7,5,9,2,7,9,0,2,2,11,7,-1,-1,-1,-1,7,5,2,7,2,11,5,9,2,3,2,8,9,8,2,-1,2,5,10,2,3,5,3,7,5,-1,-1,
-1,-1,-1,-1,-1,8,2,0,8,5,2,8,7,5,10,2,5,-1,-1,-1,-1,9,0,1,5,10,3,5,3,7,3,10,2,-1,-1,-1,-1,9,8,2,9,2,1,8,7,2,10,2,5,7,5,2,-1,1,3,5,3,7,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,7,0,7,1,1,7,5,-1,-1,-1,-1,-1,-1,-1,9,0,3,9,3,5,5,3,7,-1,-1,-1,-1,-1,-1,-1,9,8,7,5,9,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5,8,4,5,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,5,0,4,5,11,0,5,10,11,11,3,0,-1,-1,-1,-1,0,1,9,8,4,10,8,10,11,10,4,5,-1,-1,-1,-1,10,11,4,10,4,5,11,3,4,9,4,1,3,1,4,-1,2,5,1,2,8,5,2,11,8,4,5,8,-1,-1,-1,-1,0,4,11,0,11,3,4,5,11,
2,11,1,5,1,11,-1,0,2,5,0,5,9,2,11,5,4,5,8,11,8,5,-1,9,4,5,2,11,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,5,10,3,5,2,3,4,5,3,8,4,-1,-1,-1,-1,5,10,2,5,2,4,4,2,0,-1,-1,-1,-1,-1,-1,-1,3,10,2,3,5,10,3,8,5,4,5,8,0,1,9,-1,5,10,2,5,2,4,1,9,2,9,4,2,-1,-1,-1,-1,8,4,5,8,5,3,3,5,1,-1,-1,-1,-1,-1,-1,-1,0,4,5,1,0,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,4,5,8,5,3,9,0,5,0,3,5,-1,-1,-1,-1,9,4,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,11,7,4,9,11,9,10,11,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,7,9,11,7,9,10,11,-1,-1,-1,-1,1,10,11,1,11,
4,1,4,0,7,4,11,-1,-1,-1,-1,3,1,4,3,4,8,1,10,4,7,4,11,10,11,4,-1,4,11,7,9,11,4,9,2,11,9,1,2,-1,-1,-1,-1,9,7,4,9,11,7,9,1,11,2,11,1,0,8,3,-1,11,7,4,11,4,2,2,4,0,-1,-1,-1,-1,-1,-1,-1,11,7,4,11,4,2,8,3,4,3,2,4,-1,-1,-1,-1,2,9,10,2,7,9,2,3,7,7,4,9,-1,-1,-1,-1,9,10,7,9,7,4,10,2,7,8,7,0,2,0,7,-1,3,7,10,3,10,2,7,4,10,1,10,0,4,0,10,-1,1,10,2,8,7,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,7,1,3,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,0,8,1,8,7,1,-1,-1,-1,-1,4,0,3,7,4,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,8,7,-1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,11,9,10,-1,-1,-1,-1,-1,-1,-1,0,1,10,0,10,8,8,10,11,-1,-1,-1,-1,-1,-1,-1,3,1,10,11,3,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,11,1,11,9,9,11,8,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,1,2,9,2,11,9,-1,-1,-1,-1,0,2,11,8,0,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,2,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,10,8,9,-1,-1,-1,-1,-1,-1,-1,9,10,2,0,9,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,0,1,8,1,10,8,-1,-1,-1,-1,1,10,
2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,3,8,9,1,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,9,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,3,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]);
THREE.LensFlarePlugin=function(){function a(a){var c=b.createProgram(),d=b.createShader(b.FRAGMENT_SHADER),e=b.createShader(b.VERTEX_SHADER);b.shaderSource(d,a.fragmentShader);b.shaderSource(e,a.vertexShader);b.compileShader(d);b.compileShader(e);b.attachShader(c,d);b.attachShader(c,e);b.linkProgram(c);return c}var b,c,d,e,g,h,i,m,k,j,n,l,q;this.init=function(o){b=o.context;c=o;d=new Float32Array(16);e=new Uint16Array(6);o=0;d[o++]=-1;d[o++]=-1;d[o++]=0;d[o++]=0;d[o++]=1;d[o++]=-1;d[o++]=1;d[o++]=
0;d[o++]=1;d[o++]=1;d[o++]=1;d[o++]=1;d[o++]=-1;d[o++]=1;d[o++]=0;d[o++]=1;o=0;e[o++]=0;e[o++]=1;e[o++]=2;e[o++]=0;e[o++]=2;e[o++]=3;g=b.createBuffer();h=b.createBuffer();b.bindBuffer(b.ARRAY_BUFFER,g);b.bufferData(b.ARRAY_BUFFER,d,b.STATIC_DRAW);b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,h);b.bufferData(b.ELEMENT_ARRAY_BUFFER,e,b.STATIC_DRAW);i=b.createTexture();m=b.createTexture();b.bindTexture(b.TEXTURE_2D,i);b.texImage2D(b.TEXTURE_2D,0,b.RGB,16,16,0,b.RGB,b.UNSIGNED_BYTE,null);b.texParameteri(b.TEXTURE_2D,
b.TEXTURE_WRAP_S,b.CLAMP_TO_EDGE);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_T,b.CLAMP_TO_EDGE);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MAG_FILTER,b.NEAREST);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MIN_FILTER,b.NEAREST);b.bindTexture(b.TEXTURE_2D,m);b.texImage2D(b.TEXTURE_2D,0,b.RGBA,16,16,0,b.RGBA,b.UNSIGNED_BYTE,null);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_S,b.CLAMP_TO_EDGE);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_T,b.CLAMP_TO_EDGE);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MAG_FILTER,b.NEAREST);
b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MIN_FILTER,b.NEAREST);0>=b.getParameter(b.MAX_VERTEX_TEXTURE_IMAGE_UNITS)?(k=!1,j=a(THREE.ShaderFlares.lensFlare)):(k=!0,j=a(THREE.ShaderFlares.lensFlareVertexTexture));n={};l={};n.vertex=b.getAttribLocation(j,"position");n.uv=b.getAttribLocation(j,"uv");l.renderType=b.getUniformLocation(j,"renderType");l.map=b.getUniformLocation(j,"map");l.occlusionMap=b.getUniformLocation(j,"occlusionMap");l.opacity=b.getUniformLocation(j,"opacity");l.color=b.getUniformLocation(j,
"color");l.scale=b.getUniformLocation(j,"scale");l.rotation=b.getUniformLocation(j,"rotation");l.screenPosition=b.getUniformLocation(j,"screenPosition");q=!1};this.render=function(a,d,e,y){var a=a.__webglFlares,w=a.length;if(w){var N=new THREE.Vector3,A=y/e,u=0.5*e,H=0.5*y,I=16/y,D=new THREE.Vector2(I*A,I),L=new THREE.Vector3(1,1,0),K=new THREE.Vector2(1,1),M=l,I=n;b.useProgram(j);q||(b.enableVertexAttribArray(n.vertex),b.enableVertexAttribArray(n.uv),q=!0);b.uniform1i(M.occlusionMap,0);b.uniform1i(M.map,
1);b.bindBuffer(b.ARRAY_BUFFER,g);b.vertexAttribPointer(I.vertex,2,b.FLOAT,!1,16,0);b.vertexAttribPointer(I.uv,2,b.FLOAT,!1,16,8);b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,h);b.disable(b.CULL_FACE);b.depthMask(!1);var ja,oa,ka,X,$;for(ja=0;ja<w;ja++)if(I=16/y,D.set(I*A,I),X=a[ja],N.set(X.matrixWorld.n14,X.matrixWorld.n24,X.matrixWorld.n34),d.matrixWorldInverse.multiplyVector3(N),d.projectionMatrix.multiplyVector3(N),L.copy(N),K.x=L.x*u+u,K.y=L.y*H+H,k||0<K.x&&K.x<e&&0<K.y&&K.y<y){b.activeTexture(b.TEXTURE1);
b.bindTexture(b.TEXTURE_2D,i);b.copyTexImage2D(b.TEXTURE_2D,0,b.RGB,K.x-8,K.y-8,16,16,0);b.uniform1i(M.renderType,0);b.uniform2f(M.scale,D.x,D.y);b.uniform3f(M.screenPosition,L.x,L.y,L.z);b.disable(b.BLEND);b.enable(b.DEPTH_TEST);b.drawElements(b.TRIANGLES,6,b.UNSIGNED_SHORT,0);b.activeTexture(b.TEXTURE0);b.bindTexture(b.TEXTURE_2D,m);b.copyTexImage2D(b.TEXTURE_2D,0,b.RGBA,K.x-8,K.y-8,16,16,0);b.uniform1i(M.renderType,1);b.disable(b.DEPTH_TEST);b.activeTexture(b.TEXTURE1);b.bindTexture(b.TEXTURE_2D,
i);b.drawElements(b.TRIANGLES,6,b.UNSIGNED_SHORT,0);X.positionScreen.copy(L);X.customUpdateCallback?X.customUpdateCallback(X):X.updateLensFlares();b.uniform1i(M.renderType,2);b.enable(b.BLEND);for(oa=0,ka=X.lensFlares.length;oa<ka;oa++)if($=X.lensFlares[oa],0.001<$.opacity&&0.001<$.scale)L.x=$.x,L.y=$.y,L.z=$.z,I=$.size*$.scale/y,D.x=I*A,D.y=I,b.uniform3f(M.screenPosition,L.x,L.y,L.z),b.uniform2f(M.scale,D.x,D.y),b.uniform1f(M.rotation,$.rotation),b.uniform1f(M.opacity,$.opacity),b.uniform3f(M.color,
$.color.r,$.color.g,$.color.b),c.setBlending($.blending),c.setTexture($.texture,1),b.drawElements(b.TRIANGLES,6,b.UNSIGNED_SHORT,0)}b.enable(b.CULL_FACE);b.enable(b.DEPTH_TEST);b.depthMask(!0)}}};
THREE.ShadowMapPlugin=function(){var a,b,c,d,e=new THREE.Frustum,g=new THREE.Matrix4,h=new THREE.Vector3,i=new THREE.Vector3;this.init=function(e){a=e.context;b=e;var e=THREE.ShaderLib.depthRGBA,g=THREE.UniformsUtils.clone(e.uniforms);c=new THREE.ShaderMaterial({fragmentShader:e.fragmentShader,vertexShader:e.vertexShader,uniforms:g});d=new THREE.ShaderMaterial({fragmentShader:e.fragmentShader,vertexShader:e.vertexShader,uniforms:g,morphTargets:!0});c._shadowPass=!0;d._shadowPass=!0};this.render=function(a,
c){b.shadowMapEnabled&&b.shadowMapAutoUpdate&&this.update(a,c)};this.update=function(m,k){var j,n,l,q,o,p,s,y,w,N=[];q=0;a.clearColor(1,1,1,1);a.disable(a.BLEND);b.shadowMapCullFrontFaces&&a.cullFace(a.FRONT);b.setDepthTest(!0);for(j=0,n=m.__lights.length;j<n;j++)if(l=m.__lights[j],l.castShadow)if(l instanceof THREE.DirectionalLight&&l.shadowCascade)for(o=0;o<l.shadowCascadeCount;o++){var A;if(l.shadowCascadeArray[o])A=l.shadowCascadeArray[o];else{w=l;s=o;A=new THREE.DirectionalLight;A.isVirtual=
!0;A.onlyShadow=!0;A.castShadow=!0;A.shadowCameraNear=w.shadowCameraNear;A.shadowCameraFar=w.shadowCameraFar;A.shadowCameraLeft=w.shadowCameraLeft;A.shadowCameraRight=w.shadowCameraRight;A.shadowCameraBottom=w.shadowCameraBottom;A.shadowCameraTop=w.shadowCameraTop;A.shadowCameraVisible=w.shadowCameraVisible;A.shadowDarkness=w.shadowDarkness;A.shadowBias=w.shadowCascadeBias[s];A.shadowMapWidth=w.shadowCascadeWidth[s];A.shadowMapHeight=w.shadowCascadeHeight[s];A.pointsWorld=[];A.pointsFrustum=[];y=
A.pointsWorld;p=A.pointsFrustum;for(var u=0;8>u;u++)y[u]=new THREE.Vector3,p[u]=new THREE.Vector3;y=w.shadowCascadeNearZ[s];w=w.shadowCascadeFarZ[s];p[0].set(-1,-1,y);p[1].set(1,-1,y);p[2].set(-1,1,y);p[3].set(1,1,y);p[4].set(-1,-1,w);p[5].set(1,-1,w);p[6].set(-1,1,w);p[7].set(1,1,w);A.originalCamera=k;p=new THREE.Gyroscope;p.position=l.shadowCascadeOffset;p.add(A);p.add(A.target);k.add(p);l.shadowCascadeArray[o]=A;console.log("Created virtualLight",A)}s=l;y=o;w=s.shadowCascadeArray[y];w.position.copy(s.position);
w.target.position.copy(s.target.position);w.lookAt(w.target);w.shadowCameraVisible=s.shadowCameraVisible;w.shadowDarkness=s.shadowDarkness;w.shadowBias=s.shadowCascadeBias[y];p=s.shadowCascadeNearZ[y];s=s.shadowCascadeFarZ[y];w=w.pointsFrustum;w[0].z=p;w[1].z=p;w[2].z=p;w[3].z=p;w[4].z=s;w[5].z=s;w[6].z=s;w[7].z=s;N[q]=A;q++}else N[q]=l,q++;for(j=0,n=N.length;j<n;j++){l=N[j];if(!l.shadowMap)l.shadowMap=new THREE.WebGLRenderTarget(l.shadowMapWidth,l.shadowMapHeight,{minFilter:THREE.LinearFilter,magFilter:THREE.LinearFilter,
format:THREE.RGBAFormat}),l.shadowMapSize=new THREE.Vector2(l.shadowMapWidth,l.shadowMapHeight),l.shadowMatrix=new THREE.Matrix4;if(!l.shadowCamera){if(l instanceof THREE.SpotLight)l.shadowCamera=new THREE.PerspectiveCamera(l.shadowCameraFov,l.shadowMapWidth/l.shadowMapHeight,l.shadowCameraNear,l.shadowCameraFar);else if(l instanceof THREE.DirectionalLight)l.shadowCamera=new THREE.OrthographicCamera(l.shadowCameraLeft,l.shadowCameraRight,l.shadowCameraTop,l.shadowCameraBottom,l.shadowCameraNear,l.shadowCameraFar);
else{console.error("Unsupported light type for shadow");continue}m.add(l.shadowCamera);b.autoUpdateScene&&m.updateMatrixWorld()}if(l.shadowCameraVisible&&!l.cameraHelper)l.cameraHelper=new THREE.CameraHelper(l.shadowCamera),l.shadowCamera.add(l.cameraHelper);if(l.isVirtual&&A.originalCamera==k){o=k;q=l.shadowCamera;p=l.pointsFrustum;w=l.pointsWorld;h.set(Infinity,Infinity,Infinity);i.set(-Infinity,-Infinity,-Infinity);for(s=0;8>s;s++){y=w[s];y.copy(p[s]);THREE.ShadowMapPlugin.__projector.unprojectVector(y,
o);q.matrixWorldInverse.multiplyVector3(y);if(y.x<h.x)h.x=y.x;if(y.x>i.x)i.x=y.x;if(y.y<h.y)h.y=y.y;if(y.y>i.y)i.y=y.y;if(y.z<h.z)h.z=y.z;if(y.z>i.z)i.z=y.z}q.left=h.x;q.right=i.x;q.top=i.y;q.bottom=h.y;q.updateProjectionMatrix()}q=l.shadowMap;p=l.shadowMatrix;o=l.shadowCamera;o.position.copy(l.matrixWorld.getPosition());o.lookAt(l.target.matrixWorld.getPosition());o.updateMatrixWorld();o.matrixWorldInverse.getInverse(o.matrixWorld);if(l.cameraHelper)l.cameraHelper.lines.visible=l.shadowCameraVisible;
l.shadowCameraVisible&&l.cameraHelper.update(l.shadowCamera);p.set(0.5,0,0,0.5,0,0.5,0,0.5,0,0,0.5,0.5,0,0,0,1);p.multiplySelf(o.projectionMatrix);p.multiplySelf(o.matrixWorldInverse);if(!o._viewMatrixArray)o._viewMatrixArray=new Float32Array(16);o.matrixWorldInverse.flattenToArray(o._viewMatrixArray);if(!o._projectionMatrixArray)o._projectionMatrixArray=new Float32Array(16);o.projectionMatrix.flattenToArray(o._projectionMatrixArray);g.multiply(o.projectionMatrix,o.matrixWorldInverse);e.setFromMatrix(g);
b.setRenderTarget(q);b.clear();w=m.__webglObjects;for(l=0,q=w.length;l<q;l++)if(s=w[l],p=s.object,s.render=!1,p.visible&&p.castShadow&&(!(p instanceof THREE.Mesh)||!p.frustumCulled||e.contains(p)))p.matrixWorld.flattenToArray(p._objectMatrixArray),p._modelViewMatrix.multiplyToArray(o.matrixWorldInverse,p.matrixWorld,p._modelViewMatrixArray),s.render=!0;for(l=0,q=w.length;l<q;l++)if(s=w[l],s.render)p=s.object,s=s.buffer,b.setObjectFaces(p),y=p.customDepthMaterial?p.customDepthMaterial:p.geometry.morphTargets.length?
d:c,s instanceof THREE.BufferGeometry?b.renderBufferDirect(o,m.__lights,null,y,s,p):b.renderBuffer(o,m.__lights,null,y,s,p);w=m.__webglObjectsImmediate;for(l=0,q=w.length;l<q;l++)s=w[l],p=s.object,p.visible&&p.castShadow&&(p.matrixAutoUpdate&&p.matrixWorld.flattenToArray(p._objectMatrixArray),p._modelViewMatrix.multiplyToArray(o.matrixWorldInverse,p.matrixWorld,p._modelViewMatrixArray),b.renderImmediateObject(o,m.__lights,null,c,p))}j=b.getClearColor();n=b.getClearAlpha();a.clearColor(j.r,j.g,j.b,
n);a.enable(a.BLEND);b.shadowMapCullFrontFaces&&a.cullFace(a.BACK)}};THREE.ShadowMapPlugin.__projector=new THREE.Projector;
THREE.SpritePlugin=function(){function a(a,b){return b.z-a.z}var b,c,d,e,g,h,i,m,k,j;this.init=function(a){b=a.context;c=a;d=new Float32Array(16);e=new Uint16Array(6);a=0;d[a++]=-1;d[a++]=-1;d[a++]=0;d[a++]=1;d[a++]=1;d[a++]=-1;d[a++]=1;d[a++]=1;d[a++]=1;d[a++]=1;d[a++]=1;d[a++]=0;d[a++]=-1;d[a++]=1;d[a++]=0;a=d[a++]=0;e[a++]=0;e[a++]=1;e[a++]=2;e[a++]=0;e[a++]=2;e[a++]=3;g=b.createBuffer();h=b.createBuffer();b.bindBuffer(b.ARRAY_BUFFER,g);b.bufferData(b.ARRAY_BUFFER,d,b.STATIC_DRAW);b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,
h);b.bufferData(b.ELEMENT_ARRAY_BUFFER,e,b.STATIC_DRAW);var a=THREE.ShaderSprite.sprite,l=b.createProgram(),q=b.createShader(b.FRAGMENT_SHADER),o=b.createShader(b.VERTEX_SHADER);b.shaderSource(q,a.fragmentShader);b.shaderSource(o,a.vertexShader);b.compileShader(q);b.compileShader(o);b.attachShader(l,q);b.attachShader(l,o);b.linkProgram(l);i=l;m={};k={};m.position=b.getAttribLocation(i,"position");m.uv=b.getAttribLocation(i,"uv");k.uvOffset=b.getUniformLocation(i,"uvOffset");k.uvScale=b.getUniformLocation(i,
"uvScale");k.rotation=b.getUniformLocation(i,"rotation");k.scale=b.getUniformLocation(i,"scale");k.alignment=b.getUniformLocation(i,"alignment");k.color=b.getUniformLocation(i,"color");k.map=b.getUniformLocation(i,"map");k.opacity=b.getUniformLocation(i,"opacity");k.useScreenCoordinates=b.getUniformLocation(i,"useScreenCoordinates");k.affectedByDistance=b.getUniformLocation(i,"affectedByDistance");k.screenPosition=b.getUniformLocation(i,"screenPosition");k.modelViewMatrix=b.getUniformLocation(i,"modelViewMatrix");
k.projectionMatrix=b.getUniformLocation(i,"projectionMatrix");j=!1};this.render=function(d,e,q,o){var d=d.__webglSprites,p=d.length;if(p){var s=m,y=k,w=o/q,q=0.5*q,N=0.5*o,A=!0;b.useProgram(i);j||(b.enableVertexAttribArray(s.position),b.enableVertexAttribArray(s.uv),j=!0);b.disable(b.CULL_FACE);b.enable(b.BLEND);b.depthMask(!0);b.bindBuffer(b.ARRAY_BUFFER,g);b.vertexAttribPointer(s.position,2,b.FLOAT,!1,16,0);b.vertexAttribPointer(s.uv,2,b.FLOAT,!1,16,8);b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,h);b.uniformMatrix4fv(y.projectionMatrix,
!1,e._projectionMatrixArray);b.activeTexture(b.TEXTURE0);b.uniform1i(y.map,0);for(var u,H=[],s=0;s<p;s++)if(u=d[s],u.visible&&0!==u.opacity)u.useScreenCoordinates?u.z=-u.position.z:(u._modelViewMatrix.multiplyToArray(e.matrixWorldInverse,u.matrixWorld,u._modelViewMatrixArray),u.z=-u._modelViewMatrix.n34);d.sort(a);for(s=0;s<p;s++)u=d[s],u.visible&&0!==u.opacity&&u.map&&u.map.image&&u.map.image.width&&(u.useScreenCoordinates?(b.uniform1i(y.useScreenCoordinates,1),b.uniform3f(y.screenPosition,(u.position.x-
q)/q,(N-u.position.y)/N,Math.max(0,Math.min(1,u.position.z)))):(b.uniform1i(y.useScreenCoordinates,0),b.uniform1i(y.affectedByDistance,u.affectedByDistance?1:0),b.uniformMatrix4fv(y.modelViewMatrix,!1,u._modelViewMatrixArray)),e=u.map.image.width/(u.scaleByViewport?o:1),H[0]=e*w*u.scale.x,H[1]=e*u.scale.y,b.uniform2f(y.uvScale,u.uvScale.x,u.uvScale.y),b.uniform2f(y.uvOffset,u.uvOffset.x,u.uvOffset.y),b.uniform2f(y.alignment,u.alignment.x,u.alignment.y),b.uniform1f(y.opacity,u.opacity),b.uniform3f(y.color,
u.color.r,u.color.g,u.color.b),b.uniform1f(y.rotation,u.rotation),b.uniform2fv(y.scale,H),u.mergeWith3D&&!A?(b.enable(b.DEPTH_TEST),A=!0):!u.mergeWith3D&&A&&(b.disable(b.DEPTH_TEST),A=!1),c.setBlending(u.blending),c.setTexture(u.map,0),b.drawElements(b.TRIANGLES,6,b.UNSIGNED_SHORT,0));b.enable(b.CULL_FACE);b.enable(b.DEPTH_TEST);b.depthMask(!0)}}};
THREE.ShaderFlares={lensFlareVertexTexture:{vertexShader:"uniform vec3 screenPosition;\nuniform vec2 scale;\nuniform float rotation;\nuniform int renderType;\nuniform sampler2D occlusionMap;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nvUV = uv;\nvec2 pos = position;\nif( renderType == 2 ) {\nvec4 visibility = texture2D( occlusionMap, vec2( 0.1, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.5 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.1, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.1, 0.5 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.5 ) );\nvVisibility = (       visibility.r / 9.0 ) *\n( 1.0 - visibility.g / 9.0 ) *\n(       visibility.b / 9.0 ) *\n( 1.0 - visibility.a / 9.0 );\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",fragmentShader:"precision mediump float;\nuniform sampler2D map;\nuniform float opacity;\nuniform int renderType;\nuniform vec3 color;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nif( renderType == 0 ) {\ngl_FragColor = vec4( 1.0, 0.0, 1.0, 0.0 );\n} else if( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nvec4 texture = texture2D( map, vUV );\ntexture.a *= opacity * vVisibility;\ngl_FragColor = texture;\ngl_FragColor.rgb *= color;\n}\n}"},
lensFlare:{vertexShader:"uniform vec3 screenPosition;\nuniform vec2 scale;\nuniform float rotation;\nuniform int renderType;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvoid main() {\nvUV = uv;\nvec2 pos = position;\nif( renderType == 2 ) {\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",fragmentShader:"precision mediump float;\nuniform sampler2D map;\nuniform sampler2D occlusionMap;\nuniform float opacity;\nuniform int renderType;\nuniform vec3 color;\nvarying vec2 vUV;\nvoid main() {\nif( renderType == 0 ) {\ngl_FragColor = vec4( texture2D( map, vUV ).rgb, 0.0 );\n} else if( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nfloat visibility = texture2D( occlusionMap, vec2( 0.5, 0.1 ) ).a +\ntexture2D( occlusionMap, vec2( 0.9, 0.5 ) ).a +\ntexture2D( occlusionMap, vec2( 0.5, 0.9 ) ).a +\ntexture2D( occlusionMap, vec2( 0.1, 0.5 ) ).a;\nvisibility = ( 1.0 - visibility / 4.0 );\nvec4 texture = texture2D( map, vUV );\ntexture.a *= opacity * visibility;\ngl_FragColor = texture;\ngl_FragColor.rgb *= color;\n}\n}"}};
THREE.ShaderSprite={sprite:{vertexShader:"uniform int useScreenCoordinates;\nuniform int affectedByDistance;\nuniform vec3 screenPosition;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform float rotation;\nuniform vec2 scale;\nuniform vec2 alignment;\nuniform vec2 uvOffset;\nuniform vec2 uvScale;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvoid main() {\nvUV = uvOffset + uv * uvScale;\nvec2 alignedPosition = position + alignment;\nvec2 rotatedPosition;\nrotatedPosition.x = ( cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y ) * scale.x;\nrotatedPosition.y = ( sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y ) * scale.y;\nvec4 finalPosition;\nif( useScreenCoordinates != 0 ) {\nfinalPosition = vec4( screenPosition.xy + rotatedPosition, screenPosition.z, 1.0 );\n} else {\nfinalPosition = projectionMatrix * modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );\nfinalPosition.xy += rotatedPosition * ( affectedByDistance == 1 ? 1.0 : finalPosition.z );\n}\ngl_Position = finalPosition;\n}",
fragmentShader:"precision mediump float;\nuniform vec3 color;\nuniform sampler2D map;\nuniform float opacity;\nvarying vec2 vUV;\nvoid main() {\nvec4 texture = texture2D( map, vUV );\ngl_FragColor = vec4( color * texture.xyz, texture.a * opacity );\n}"}};
