// ThreeExtras.js - http://github.com/mrdoob/three.js
'use strict';THREE.ColorUtils={adjustHSV:function(a,b,c,d){var f=THREE.ColorUtils.__hsv;THREE.ColorUtils.rgbToHsv(a,f);f.h=THREE.Math.clamp(f.h+b,0,1);f.s=THREE.Math.clamp(f.s+c,0,1);f.v=THREE.Math.clamp(f.v+d,0,1);a.setHSV(f.h,f.s,f.v)},rgbToHsv:function(a,b){var c=a.r,d=a.g,f=a.b,g=Math.max(Math.max(c,d),f),e=Math.min(Math.min(c,d),f);if(e===g)e=c=0;else{var h=g-e,e=h/g,c=(c===g?(d-f)/h:d===g?2+(f-c)/h:4+(c-d)/h)/6;0>c&&(c+=1);1<c&&(c-=1)}void 0===b&&(b={h:0,s:0,v:0});b.h=c;b.s=e;b.v=g;return b}};
THREE.ColorUtils.__hsv={h:0,s:0,v:0};
THREE.GeometryUtils={merge:function(a,b){for(var c,d,f=a.vertices.length,g=b instanceof THREE.Mesh?b.geometry:b,e=a.vertices,h=g.vertices,i=a.faces,k=g.faces,j=a.faceVertexUvs[0],q=g.faceVertexUvs[0],l={},n=0;n<a.materials.length;n++)l[a.materials[n].id]=n;if(b instanceof THREE.Mesh)b.matrixAutoUpdate&&b.updateMatrix(),c=b.matrix,d=new THREE.Matrix4,d.extractRotation(c,b.scale);for(var n=0,r=h.length;n<r;n++){var m=h[n].clone();c&&c.multiplyVector3(m.position);e.push(m)}for(n=0,r=k.length;n<r;n++){var e=
k[n],o,p,s=e.vertexNormals,t=e.vertexColors;e instanceof THREE.Face3?o=new THREE.Face3(e.a+f,e.b+f,e.c+f):e instanceof THREE.Face4&&(o=new THREE.Face4(e.a+f,e.b+f,e.c+f,e.d+f));o.normal.copy(e.normal);d&&d.multiplyVector3(o.normal);h=0;for(m=s.length;h<m;h++)p=s[h].clone(),d&&d.multiplyVector3(p),o.vertexNormals.push(p);o.color.copy(e.color);h=0;for(m=t.length;h<m;h++)p=t[h],o.vertexColors.push(p.clone());if(void 0!==e.materialIndex){h=g.materials[e.materialIndex];m=h.id;t=l[m];if(void 0===t)t=a.materials.length,
l[m]=t,a.materials.push(h);o.materialIndex=t}o.centroid.copy(e.centroid);c&&c.multiplyVector3(o.centroid);i.push(o)}for(n=0,r=q.length;n<r;n++){c=q[n];d=[];h=0;for(m=c.length;h<m;h++)d.push(new THREE.UV(c[h].u,c[h].v));j.push(d)}},clone:function(a){var b=new THREE.Geometry,c,d=a.vertices,f=a.faces,g=a.faceVertexUvs[0];if(a.materials)b.materials=a.materials.slice();for(a=0,c=d.length;a<c;a++)b.vertices.push(d[a].clone());for(a=0,c=f.length;a<c;a++)b.faces.push(f[a].clone());for(a=0,c=g.length;a<c;a++){for(var d=
g[a],f=[],e=0,h=d.length;e<h;e++)f.push(new THREE.UV(d[e].u,d[e].v));b.faceVertexUvs[0].push(f)}return b},randomPointInTriangle:function(a,b,c){var d,f,g,e=new THREE.Vector3,h=THREE.GeometryUtils.__v1;d=THREE.GeometryUtils.random();f=THREE.GeometryUtils.random();1<d+f&&(d=1-d,f=1-f);g=1-d-f;e.copy(a);e.multiplyScalar(d);h.copy(b);h.multiplyScalar(f);e.addSelf(h);h.copy(c);h.multiplyScalar(g);e.addSelf(h);return e},randomPointInFace:function(a,b,c){var d,f,g;if(a instanceof THREE.Face3)return d=b.vertices[a.a].position,
f=b.vertices[a.b].position,g=b.vertices[a.c].position,THREE.GeometryUtils.randomPointInTriangle(d,f,g);if(a instanceof THREE.Face4){d=b.vertices[a.a].position;f=b.vertices[a.b].position;g=b.vertices[a.c].position;var b=b.vertices[a.d].position,e;c?a._area1&&a._area2?(c=a._area1,e=a._area2):(c=THREE.GeometryUtils.triangleArea(d,f,b),e=THREE.GeometryUtils.triangleArea(f,g,b),a._area1=c,a._area2=e):(c=THREE.GeometryUtils.triangleArea(d,f,b),e=THREE.GeometryUtils.triangleArea(f,g,b));return THREE.GeometryUtils.random()*
(c+e)<c?THREE.GeometryUtils.randomPointInTriangle(d,f,b):THREE.GeometryUtils.randomPointInTriangle(f,g,b)}},randomPointsInGeometry:function(a,b){function c(a){function b(c,d){if(d<c)return c;var f=c+Math.floor((d-c)/2);return k[f]>a?b(c,f-1):k[f]<a?b(f+1,d):f}return b(0,k.length-1)}var d,f,g=a.faces,e=a.vertices,h=g.length,i=0,k=[],j,q,l,n;for(f=0;f<h;f++){d=g[f];if(d instanceof THREE.Face3)j=e[d.a].position,q=e[d.b].position,l=e[d.c].position,d._area=THREE.GeometryUtils.triangleArea(j,q,l);else if(d instanceof
THREE.Face4)j=e[d.a].position,q=e[d.b].position,l=e[d.c].position,n=e[d.d].position,d._area1=THREE.GeometryUtils.triangleArea(j,q,n),d._area2=THREE.GeometryUtils.triangleArea(q,l,n),d._area=d._area1+d._area2;i+=d._area;k[f]=i}d=[];for(f=0;f<b;f++)e=THREE.GeometryUtils.random()*i,e=c(e),d[f]=THREE.GeometryUtils.randomPointInFace(g[e],a,!0);return d},triangleArea:function(a,b,c){var d,f=THREE.GeometryUtils.__v1;f.sub(a,b);d=f.length();f.sub(a,c);a=f.length();f.sub(b,c);c=f.length();b=0.5*(d+a+c);return Math.sqrt(b*
(b-d)*(b-a)*(b-c))},center:function(a){a.computeBoundingBox();var b=a.boundingBox,c=new THREE.Vector3;c.add(b.min,b.max);c.multiplyScalar(-0.5);a.applyMatrix((new THREE.Matrix4).setTranslation(c.x,c.y,c.z));a.computeBoundingBox();return c},normalizeUVs:function(a){for(var a=a.faceVertexUvs[0],b=0,c=a.length;b<c;b++)for(var d=a[b],f=0,g=d.length;f<g;f++)1!==d[f].u&&(d[f].u-=Math.floor(d[f].u)),1!==d[f].v&&(d[f].v-=Math.floor(d[f].v))},triangulateQuads:function(a){for(var b=a.faces.length-1;0<=b;b--){var c=
a.faces[b];if(c instanceof THREE.Face4){var d=c.a,f=c.b,g=c.c,e=c.d,h=c.clone(),c=c.clone();h.a=d;h.b=f;h.c=e;c.a=f;c.b=g;c.c=e;a.faces.splice(b,1,h,c);for(d=0;d<a.faceVertexUvs.length;d++)a.faceVertexUvs[d].length&&(h=a.faceVertexUvs[d][b],f=h[1],g=h[2],e=h[3],h=[h[0].clone(),f.clone(),e.clone()],f=[f.clone(),g.clone(),e.clone()],a.faceVertexUvs[d].splice(b,1,h,f));for(d=0;d<a.faceUvs.length;d++)a.faceUvs[d].length&&(f=a.faceUvs[d][b],a.faceUvs[d].splice(b,1,f,f))}}a.computeCentroids();a.computeFaceNormals();
a.computeVertexNormals();a.hasTangents&&a.computeTangents()},explode:function(a){for(var b=[],c=0,d=a.faces.length;c<d;c++){var f=b.length,g=a.faces[c];if(g instanceof THREE.Face4){var e=g.a,h=g.b,i=g.c,e=a.vertices[e],h=a.vertices[h],i=a.vertices[i],k=a.vertices[g.d];b.push(e.clone());b.push(h.clone());b.push(i.clone());b.push(k.clone());g.a=f;g.b=f+1;g.c=f+2;g.d=f+3}else e=g.a,h=g.b,i=g.c,e=a.vertices[e],h=a.vertices[h],i=a.vertices[i],b.push(e.clone()),b.push(h.clone()),b.push(i.clone()),g.a=f,
g.b=f+1,g.c=f+2}a.vertices=b},tessellate:function(a,b){var c,d,f,g,e,h,i,k,j,q,l,n,r,m,o,p,s;for(c=a.faces.length-1;0<=c;c--)if(d=a.faces[c],d instanceof THREE.Face3){if(f=d.a,g=d.b,e=d.c,i=a.vertices[f],k=a.vertices[g],j=a.vertices[e],l=i.position.distanceTo(k.position),n=k.position.distanceTo(j.position),q=i.position.distanceTo(j.position),l>b||n>b||q>b){h=a.vertices.length;s=d.clone();d=d.clone();l>=n&&l>=q?(i=i.clone(),i.position.lerpSelf(k.position,0.5),s.a=f,s.b=h,s.c=e,d.a=h,d.b=g,d.c=e,f=
0):n>=l&&n>=q?(i=k.clone(),i.position.lerpSelf(j.position,0.5),s.a=f,s.b=g,s.c=h,d.a=h,d.b=e,d.c=f,f=1):(i=i.clone(),i.position.lerpSelf(j.position,0.5),s.a=f,s.b=g,s.c=h,d.a=h,d.b=g,d.c=e,f=2);a.faces.splice(c,1,s,d);a.vertices.push(i);for(g=0;g<a.faceVertexUvs.length;g++)a.faceVertexUvs[g].length&&(j=a.faceVertexUvs[g][c],k=j[0],e=j[1],i=j[2],0===f?(l=k.clone(),l.lerpSelf(e,0.5),j=[k.clone(),l.clone(),i.clone()],e=[l.clone(),e.clone(),i.clone()]):1===f?(l=e.clone(),l.lerpSelf(i,0.5),j=[k.clone(),
e.clone(),l.clone()],e=[l.clone(),i.clone(),k.clone()]):(l=k.clone(),l.lerpSelf(i,0.5),j=[k.clone(),e.clone(),l.clone()],e=[l.clone(),e.clone(),i.clone()]),a.faceVertexUvs[g].splice(c,1,j,e))}}else if(f=d.a,g=d.b,e=d.c,h=d.d,i=a.vertices[f],k=a.vertices[g],j=a.vertices[e],q=a.vertices[h],l=i.position.distanceTo(k.position),n=k.position.distanceTo(j.position),r=j.position.distanceTo(q.position),m=i.position.distanceTo(q.position),l>b||n>b||r>b||m>b){o=a.vertices.length;p=a.vertices.length+1;s=d.clone();
d=d.clone();l>=n&&l>=r&&l>=m||r>=n&&r>=l&&r>=m?(l=i.clone(),l.position.lerpSelf(k.position,0.5),k=j.clone(),k.position.lerpSelf(q.position,0.5),s.a=f,s.b=o,s.c=p,s.d=h,d.a=o,d.b=g,d.c=e,d.d=p,f=0):(l=k.clone(),l.position.lerpSelf(j.position,0.5),k=q.clone(),k.position.lerpSelf(i.position,0.5),s.a=f,s.b=g,s.c=o,s.d=p,d.a=p,d.b=o,d.c=e,d.d=h,f=1);a.faces.splice(c,1,s,d);a.vertices.push(l);a.vertices.push(k);for(g=0;g<a.faceVertexUvs.length;g++)a.faceVertexUvs[g].length&&(j=a.faceVertexUvs[g][c],k=j[0],
e=j[1],i=j[2],j=j[3],0===f?(l=k.clone(),l.lerpSelf(e,0.5),n=i.clone(),n.lerpSelf(j,0.5),k=[k.clone(),l.clone(),n.clone(),j.clone()],e=[l.clone(),e.clone(),i.clone(),n.clone()]):(l=e.clone(),l.lerpSelf(i,0.5),n=j.clone(),n.lerpSelf(k,0.5),k=[k.clone(),e.clone(),l.clone(),n.clone()],e=[n.clone(),l.clone(),i.clone(),j.clone()]),a.faceVertexUvs[g].splice(c,1,k,e))}}};THREE.GeometryUtils.random=THREE.Math.random16;THREE.GeometryUtils.__v1=new THREE.Vector3;
THREE.ImageUtils={crossOrigin:"anonymous",loadTexture:function(a,b,c){var d=new Image,f=new THREE.Texture(d,b);d.onload=function(){f.needsUpdate=!0;c&&c(this)};d.crossOrigin=this.crossOrigin;d.src=a;return f},loadTextureCube:function(a,b,c){var d,f=[],g=new THREE.Texture(f,b);f.loadCount=0;for(b=0,d=a.length;b<d;++b)f[b]=new Image,f[b].onload=function(){f.loadCount+=1;if(6===f.loadCount)g.needsUpdate=!0;c&&c(this)},f[b].crossOrigin=this.crossOrigin,f[b].src=a[b];return g},getNormalMap:function(a,
b){var c=function(a){var b=Math.sqrt(a[0]*a[0]+a[1]*a[1]+a[2]*a[2]);return[a[0]/b,a[1]/b,a[2]/b]},b=b|1,d=a.width,f=a.height,g=document.createElement("canvas");g.width=d;g.height=f;var e=g.getContext("2d");e.drawImage(a,0,0);for(var h=e.getImageData(0,0,d,f).data,i=e.createImageData(d,f),k=i.data,j=0;j<d;j++)for(var q=1;q<f;q++){var l=0>q-1?f-1:q-1,n=(q+1)%f,r=0>j-1?d-1:j-1,m=(j+1)%d,o=[],p=[0,0,h[4*(q*d+j)]/255*b];o.push([-1,0,h[4*(q*d+r)]/255*b]);o.push([-1,-1,h[4*(l*d+r)]/255*b]);o.push([0,-1,
h[4*(l*d+j)]/255*b]);o.push([1,-1,h[4*(l*d+m)]/255*b]);o.push([1,0,h[4*(q*d+m)]/255*b]);o.push([1,1,h[4*(n*d+m)]/255*b]);o.push([0,1,h[4*(n*d+j)]/255*b]);o.push([-1,1,h[4*(n*d+r)]/255*b]);l=[];r=o.length;for(n=0;n<r;n++){var m=o[n],s=o[(n+1)%r],m=[m[0]-p[0],m[1]-p[1],m[2]-p[2]],s=[s[0]-p[0],s[1]-p[1],s[2]-p[2]];l.push(c([m[1]*s[2]-m[2]*s[1],m[2]*s[0]-m[0]*s[2],m[0]*s[1]-m[1]*s[0]]))}o=[0,0,0];for(n=0;n<l.length;n++)o[0]+=l[n][0],o[1]+=l[n][1],o[2]+=l[n][2];o[0]/=l.length;o[1]/=l.length;o[2]/=l.length;
p=4*(q*d+j);k[p]=255*((o[0]+1)/2)|0;k[p+1]=255*(o[1]+0.5)|0;k[p+2]=255*o[2]|0;k[p+3]=255}e.putImageData(i,0,0);return g},generateDataTexture:function(a,b,c){for(var d=a*b,f=new Uint8Array(3*d),g=Math.floor(255*c.r),e=Math.floor(255*c.g),c=Math.floor(255*c.b),h=0;h<d;h++)f[3*h]=g,f[3*h+1]=e,f[3*h+2]=c;a=new THREE.DataTexture(f,a,b,THREE.RGBFormat);a.needsUpdate=!0;return a}};
THREE.SceneUtils={showHierarchy:function(a,b){THREE.SceneUtils.traverseHierarchy(a,function(a){a.visible=b})},traverseHierarchy:function(a,b){var c,d,f=a.children.length;for(d=0;d<f;d++)c=a.children[d],b(c),THREE.SceneUtils.traverseHierarchy(c,b)},createMultiMaterialObject:function(a,b){var c,d=b.length,f=new THREE.Object3D;for(c=0;c<d;c++){var g=new THREE.Mesh(a,b[c]);f.add(g)}return f},cloneObject:function(a){var b;a instanceof THREE.MorphAnimMesh?(b=new THREE.MorphAnimMesh(a.geometry,a.material),
b.duration=a.duration,b.mirroredLoop=a.mirroredLoop,b.time=a.time,b.lastKeyframe=a.lastKeyframe,b.currentKeyframe=a.currentKeyframe,b.direction=a.direction,b.directionBackwards=a.directionBackwards):a instanceof THREE.SkinnedMesh?b=new THREE.SkinnedMesh(a.geometry,a.material):a instanceof THREE.Mesh?b=new THREE.Mesh(a.geometry,a.material):a instanceof THREE.Line?b=new THREE.Line(a.geometry,a.material,a.type):a instanceof THREE.Ribbon?b=new THREE.Ribbon(a.geometry,a.material):a instanceof THREE.ParticleSystem?
(b=new THREE.ParticleSystem(a.geometry,a.material),b.sortParticles=a.sortParticles):a instanceof THREE.Particle?b=new THREE.Particle(a.material):a instanceof THREE.Sprite?(b=new THREE.Sprite({}),b.color.copy(a.color),b.map=a.map,b.blending=a.blending,b.useScreenCoordinates=a.useScreenCoordinates,b.mergeWith3D=a.mergeWith3D,b.affectedByDistance=a.affectedByDistance,b.scaleByViewport=a.scaleByViewport,b.alignment=a.alignment,b.rotation3d.copy(a.rotation3d),b.rotation=a.rotation,b.opacity=a.opacity,
b.uvOffset.copy(a.uvOffset),b.uvScale.copy(a.uvScale)):a instanceof THREE.LOD?b=new THREE.LOD:a instanceof THREE.MarchingCubes?(b=new THREE.MarchingCubes(a.resolution,a.material),b.field.set(a.field),b.isolation=a.isolation):a instanceof THREE.Object3D&&(b=new THREE.Object3D);b.name=a.name;b.parent=a.parent;b.up.copy(a.up);b.position.copy(a.position);b.rotation instanceof THREE.Vector3&&b.rotation.copy(a.rotation);b.eulerOrder=a.eulerOrder;b.scale.copy(a.scale);b.dynamic=a.dynamic;b.doubleSided=a.doubleSided;
b.flipSided=a.flipSided;b.renderDepth=a.renderDepth;b.rotationAutoUpdate=a.rotationAutoUpdate;b.matrix.copy(a.matrix);b.matrixWorld.copy(a.matrixWorld);b.matrixRotationWorld.copy(a.matrixRotationWorld);b.matrixAutoUpdate=a.matrixAutoUpdate;b.matrixWorldNeedsUpdate=a.matrixWorldNeedsUpdate;b.quaternion.copy(a.quaternion);b.useQuaternion=a.useQuaternion;b.boundRadius=a.boundRadius;b.boundRadiusScale=a.boundRadiusScale;b.visible=a.visible;b.castShadow=a.castShadow;b.receiveShadow=a.receiveShadow;b.frustumCulled=
a.frustumCulled;for(var c=0;c<a.children.length;c++){var d=THREE.SceneUtils.cloneObject(a.children[c]);b.children[c]=d;d.parent=b}if(a instanceof THREE.LOD)for(c=0;c<a.LODs.length;c++)b.LODs[c]={visibleAtDistance:a.LODs[c].visibleAtDistance,object3D:b.children[c]};return b},detach:function(a,b,c){a.applyMatrix(b.matrixWorld);b.remove(a);c.add(a)},attach:function(a,b,c){var d=new THREE.Matrix4;d.getInverse(c.matrixWorld);a.applyMatrix(d);b.remove(a);c.add(a)}};
if(THREE.WebGLRenderer)THREE.ShaderUtils={lib:{fresnel:{uniforms:{mRefractionRatio:{type:"f",value:1.02},mFresnelBias:{type:"f",value:0.1},mFresnelPower:{type:"f",value:2},mFresnelScale:{type:"f",value:1},tCube:{type:"t",value:1,texture:null}},fragmentShader:"uniform samplerCube tCube;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 reflectedColor = textureCube( tCube, vec3( -vReflect.x, vReflect.yz ) );\nvec4 refractedColor = vec4( 1.0, 1.0, 1.0, 1.0 );\nrefractedColor.r = textureCube( tCube, vec3( -vRefract[0].x, vRefract[0].yz ) ).r;\nrefractedColor.g = textureCube( tCube, vec3( -vRefract[1].x, vRefract[1].yz ) ).g;\nrefractedColor.b = textureCube( tCube, vec3( -vRefract[2].x, vRefract[2].yz ) ).b;\nrefractedColor.a = 1.0;\ngl_FragColor = mix( refractedColor, reflectedColor, clamp( vReflectionFactor, 0.0, 1.0 ) );\n}",
vertexShader:"uniform float mRefractionRatio;\nuniform float mFresnelBias;\nuniform float mFresnelScale;\nuniform float mFresnelPower;\nvarying vec3 vReflect;\nvarying vec3 vRefract[3];\nvarying float vReflectionFactor;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = normalize ( mat3( objectMatrix[0].xyz, objectMatrix[1].xyz, objectMatrix[2].xyz ) * normal );\nvec3 I = mPosition.xyz - cameraPosition;\nvReflect = reflect( I, nWorld );\nvRefract[0] = refract( normalize( I ), nWorld, mRefractionRatio );\nvRefract[1] = refract( normalize( I ), nWorld, mRefractionRatio * 0.99 );\nvRefract[2] = refract( normalize( I ), nWorld, mRefractionRatio * 0.98 );\nvReflectionFactor = mFresnelBias + mFresnelScale * pow( 1.0 + dot( normalize( I ), nWorld ), mFresnelPower );\ngl_Position = projectionMatrix * mvPosition;\n}"},
normal:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.fog,THREE.UniformsLib.lights,THREE.UniformsLib.shadowmap,{enableAO:{type:"i",value:0},enableDiffuse:{type:"i",value:0},enableSpecular:{type:"i",value:0},enableReflection:{type:"i",value:0},tDiffuse:{type:"t",value:0,texture:null},tCube:{type:"t",value:1,texture:null},tNormal:{type:"t",value:2,texture:null},tSpecular:{type:"t",value:3,texture:null},tAO:{type:"t",value:4,texture:null},tDisplacement:{type:"t",value:5,texture:null},uNormalScale:{type:"f",
value:1},uDisplacementBias:{type:"f",value:0},uDisplacementScale:{type:"f",value:1},uDiffuseColor:{type:"c",value:new THREE.Color(16777215)},uSpecularColor:{type:"c",value:new THREE.Color(1118481)},uAmbientColor:{type:"c",value:new THREE.Color(16777215)},uShininess:{type:"f",value:30},uOpacity:{type:"f",value:1},uReflectivity:{type:"f",value:0.5},uOffset:{type:"v2",value:new THREE.Vector2(0,0)},uRepeat:{type:"v2",value:new THREE.Vector2(1,1)},wrapRGB:{type:"v3",value:new THREE.Vector3(1,1,1)}}]),
fragmentShader:["uniform vec3 uAmbientColor;\nuniform vec3 uDiffuseColor;\nuniform vec3 uSpecularColor;\nuniform float uShininess;\nuniform float uOpacity;\nuniform bool enableDiffuse;\nuniform bool enableSpecular;\nuniform bool enableAO;\nuniform bool enableReflection;\nuniform sampler2D tDiffuse;\nuniform sampler2D tNormal;\nuniform sampler2D tSpecular;\nuniform sampler2D tAO;\nuniform samplerCube tCube;\nuniform float uNormalScale;\nuniform float uReflectivity;\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\nuniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\n#ifdef WRAP_AROUND\nuniform vec3 wrapRGB;\n#endif\nvarying vec3 vViewPosition;",
THREE.ShaderChunk.shadowmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,"void main() {\ngl_FragColor = vec4( vec3( 1.0 ), uOpacity );\nvec3 specularTex = vec3( 1.0 );\nvec3 normalTex = texture2D( tNormal, vUv ).xyz * 2.0 - 1.0;\nnormalTex.xy *= uNormalScale;\nnormalTex = normalize( normalTex );\nif( enableDiffuse ) {\n#ifdef GAMMA_INPUT\nvec4 texelColor = texture2D( tDiffuse, vUv );\ntexelColor.xyz *= texelColor.xyz;\ngl_FragColor = gl_FragColor * texelColor;\n#else\ngl_FragColor = gl_FragColor * texture2D( tDiffuse, vUv );\n#endif\n}\nif( enableAO ) {\n#ifdef GAMMA_INPUT\nvec4 aoColor = texture2D( tAO, vUv );\naoColor.xyz *= aoColor.xyz;\ngl_FragColor.xyz = gl_FragColor.xyz * aoColor.xyz;\n#else\ngl_FragColor.xyz = gl_FragColor.xyz * texture2D( tAO, vUv ).xyz;\n#endif\n}\nif( enableSpecular )\nspecularTex = texture2D( tSpecular, vUv ).xyz;\nmat3 tsb = mat3( normalize( vTangent ), normalize( vBinormal ), normalize( vNormal ) );\nvec3 finalNormal = tsb * normalTex;\nvec3 normal = normalize( finalNormal );\nvec3 viewPosition = normalize( vViewPosition );\n#if MAX_POINT_LIGHTS > 0\nvec3 pointDiffuse = vec3( 0.0 );\nvec3 pointSpecular = vec3( 0.0 );\nfor ( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec3 pointVector = normalize( vPointLight[ i ].xyz );\nfloat pointDistance = vPointLight[ i ].w;\n#ifdef WRAP_AROUND\nfloat pointDiffuseWeightFull = max( dot( normal, pointVector ), 0.0 );\nfloat pointDiffuseWeightHalf = max( 0.5 * dot( normal, pointVector ) + 0.5, 0.0 );\nvec3 pointDiffuseWeight = mix( vec3 ( pointDiffuseWeightFull ), vec3( pointDiffuseWeightHalf ), wrapRGB );\n#else\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\n#endif\npointDiffuse += pointDistance * pointLightColor[ i ] * uDiffuseColor * pointDiffuseWeight;\nvec3 pointHalfVector = normalize( pointVector + viewPosition );\nfloat pointDotNormalHalf = max( dot( normal, pointHalfVector ), 0.0 );\nfloat pointSpecularWeight = specularTex.r * max( pow( pointDotNormalHalf, uShininess ), 0.0 );\npointSpecular += pointDistance * pointLightColor[ i ] * uSpecularColor * pointSpecularWeight * pointDiffuseWeight;\n}\n#endif\n#if MAX_DIR_LIGHTS > 0\nvec3 dirDiffuse = vec3( 0.0 );\nvec3 dirSpecular = vec3( 0.0 );\nfor( int i = 0; i < MAX_DIR_LIGHTS; i++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\n#ifdef WRAP_AROUND\nfloat directionalLightWeightingFull = max( dot( normal, dirVector ), 0.0 );\nfloat directionalLightWeightingHalf = max( 0.5 * dot( normal, dirVector ) + 0.5, 0.0 );\nvec3 dirDiffuseWeight = mix( vec3( directionalLightWeightingFull ), vec3( directionalLightWeightingHalf ), wrapRGB );\n#else\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\n#endif\ndirDiffuse += directionalLightColor[ i ] * uDiffuseColor * dirDiffuseWeight;\nvec3 dirHalfVector = normalize( dirVector + viewPosition );\nfloat dirDotNormalHalf = max( dot( normal, dirHalfVector ), 0.0 );\nfloat dirSpecularWeight = specularTex.r * max( pow( dirDotNormalHalf, uShininess ), 0.0 );\ndirSpecular += directionalLightColor[ i ] * uSpecularColor * dirSpecularWeight * dirDiffuseWeight;\n}\n#endif\nvec3 totalDiffuse = vec3( 0.0 );\nvec3 totalSpecular = vec3( 0.0 );\n#if MAX_DIR_LIGHTS > 0\ntotalDiffuse += dirDiffuse;\ntotalSpecular += dirSpecular;\n#endif\n#if MAX_POINT_LIGHTS > 0\ntotalDiffuse += pointDiffuse;\ntotalSpecular += pointSpecular;\n#endif\ngl_FragColor.xyz = gl_FragColor.xyz * ( totalDiffuse + ambientLightColor * uAmbientColor) + totalSpecular;\nif ( enableReflection ) {\nvec3 wPos = cameraPosition - vViewPosition;\nvec3 vReflect = reflect( normalize( wPos ), normal );\nvec4 cubeColor = textureCube( tCube, vec3( -vReflect.x, vReflect.yz ) );\n#ifdef GAMMA_INPUT\ncubeColor.xyz *= cubeColor.xyz;\n#endif\ngl_FragColor.xyz = mix( gl_FragColor.xyz, cubeColor.xyz, specularTex.r * uReflectivity );\n}",
THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.linear_to_gamma_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["attribute vec4 tangent;\nuniform vec2 uOffset;\nuniform vec2 uRepeat;\n#ifdef VERTEX_TEXTURES\nuniform sampler2D tDisplacement;\nuniform float uDisplacementScale;\nuniform float uDisplacementBias;\n#endif\nvarying vec3 vTangent;\nvarying vec3 vBinormal;\nvarying vec3 vNormal;\nvarying vec2 vUv;\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\nvarying vec3 vViewPosition;",
THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvViewPosition = -mvPosition.xyz;\nvNormal = normalMatrix * normal;\nvTangent = normalMatrix * tangent.xyz;\nvBinormal = cross( vNormal, vTangent ) * tangent.w;\nvUv = uv * uRepeat + uOffset;\n#if MAX_POINT_LIGHTS > 0\nfor( int i = 0; i < MAX_POINT_LIGHTS; i++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz - mvPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nlVector = normalize( lVector );\nvPointLight[ i ] = vec4( lVector, lDistance );\n}\n#endif\n#ifdef VERTEX_TEXTURES\nvec3 dv = texture2D( tDisplacement, uv ).xyz;\nfloat df = uDisplacementScale * dv.x + uDisplacementBias;\nvec4 displacedPosition = vec4( normalize( vNormal.xyz ) * df, 0.0 ) + mvPosition;\ngl_Position = projectionMatrix * displacedPosition;\n#else\ngl_Position = projectionMatrix * mvPosition;\n#endif",
THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n")},cube:{uniforms:{tCube:{type:"t",value:1,texture:null},tFlip:{type:"f",value:-1}},vertexShader:"varying vec3 vViewPosition;\nvoid main() {\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvViewPosition = cameraPosition - mPosition.xyz;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform samplerCube tCube;\nuniform float tFlip;\nvarying vec3 vViewPosition;\nvoid main() {\nvec3 wPos = cameraPosition - vViewPosition;\ngl_FragColor = textureCube( tCube, vec3( tFlip * wPos.x, wPos.yz ) );\n}"}}};
THREE.BufferGeometry=function(){this.id=THREE.GeometryCount++;this.vertexColorArray=this.vertexUvArray=this.vertexNormalArray=this.vertexPositionArray=this.vertexIndexArray=this.vertexColorBuffer=this.vertexUvBuffer=this.vertexNormalBuffer=this.vertexPositionBuffer=this.vertexIndexBuffer=null;this.dynamic=!1;this.boundingSphere=this.boundingBox=null;this.morphTargets=[]};THREE.BufferGeometry.prototype={constructor:THREE.BufferGeometry,computeBoundingBox:function(){},computeBoundingSphere:function(){}};
THREE.Curve=function(){};THREE.Curve.prototype.getPoint=function(){console.log("Warning, getPoint() not implemented!");return null};THREE.Curve.prototype.getPointAt=function(a){return this.getPoint(this.getUtoTmapping(a))};THREE.Curve.prototype.getPoints=function(a){a||(a=5);var b,c=[];for(b=0;b<=a;b++)c.push(this.getPoint(b/a));return c};THREE.Curve.prototype.getSpacedPoints=function(a){a||(a=5);var b,c=[];for(b=0;b<=a;b++)c.push(this.getPointAt(b/a));return c};
THREE.Curve.prototype.getLength=function(){var a=this.getLengths();return a[a.length-1]};THREE.Curve.prototype.getLengths=function(a){a||(a=200);if(this.cacheArcLengths&&this.cacheArcLengths.length==a+1)return this.cacheArcLengths;var b=[],c,d=this.getPoint(0),f,g=0;b.push(0);for(f=1;f<=a;f++)c=this.getPoint(f/a),g+=c.distanceTo(d),b.push(g),d=c;return this.cacheArcLengths=b};
THREE.Curve.prototype.getUtoTmapping=function(a,b){var c=this.getLengths(),d=0,f=c.length,g;g=b?b:a*c[f-1];for(var e=0,h=f-1,i;e<=h;)if(d=Math.floor(e+(h-e)/2),i=c[d]-g,0>i)e=d+1;else if(0<i)h=d-1;else{h=d;break}d=h;if(c[d]==g)return d/(f-1);e=c[d];return c=(d+(g-e)/(c[d+1]-e))/(f-1)};THREE.Curve.prototype.getNormalVector=function(a){a=this.getTangent(a);return new THREE.Vector2(-a.y,a.x)};
THREE.Curve.prototype.getTangent=function(a){var b=a-1.0E-4,a=a+1.0E-4;0>b&&(b=0);1<a&&(a=1);b=this.getPoint(b);a=this.getPoint(a);return b.clone().subSelf(a).normalize()};THREE.Curve.prototype.getTangentAt=function(a){return this.getTangent(this.getUtoTmapping(a))};THREE.LineCurve=function(a,b){a instanceof THREE.Vector2?(this.v1=a,this.v2=b):THREE.LineCurve.oldConstructor.apply(this,arguments)};
THREE.LineCurve.oldConstructor=function(a,b,c,d){this.constructor(new THREE.Vector2(a,b),new THREE.Vector2(c,d))};THREE.LineCurve.prototype=new THREE.Curve;THREE.LineCurve.prototype.constructor=THREE.LineCurve;THREE.LineCurve.prototype.getPoint=function(a){var b=new THREE.Vector2;b.sub(this.v2,this.v1);b.multiplyScalar(a).addSelf(this.v1);return b};THREE.LineCurve.prototype.getPointAt=function(a){return this.getPoint(a)};
THREE.LineCurve.prototype.getTangent=function(){var a=new THREE.Vector2;a.sub(this.v2,this.v1);a.normalize();return a};THREE.QuadraticBezierCurve=function(a,b,c){if(!(b instanceof THREE.Vector2))var d=Array.prototype.slice.call(arguments),a=new THREE.Vector2(d[0],d[1]),b=new THREE.Vector2(d[2],d[3]),c=new THREE.Vector2(d[4],d[5]);this.v0=a;this.v1=b;this.v2=c};THREE.QuadraticBezierCurve.prototype=new THREE.Curve;THREE.QuadraticBezierCurve.prototype.constructor=THREE.QuadraticBezierCurve;
THREE.QuadraticBezierCurve.prototype.getPoint=function(a){var b;b=THREE.Shape.Utils.b2(a,this.v0.x,this.v1.x,this.v2.x);a=THREE.Shape.Utils.b2(a,this.v0.y,this.v1.y,this.v2.y);return new THREE.Vector2(b,a)};THREE.QuadraticBezierCurve.prototype.getTangent=function(a){var b;b=THREE.Curve.Utils.tangentQuadraticBezier(a,this.v0.x,this.v1.x,this.v2.x);a=THREE.Curve.Utils.tangentQuadraticBezier(a,this.v0.y,this.v1.y,this.v2.y);b=new THREE.Vector2(b,a);b.normalize();return b};
THREE.CubicBezierCurve=function(a,b,c,d){if(!(b instanceof THREE.Vector2))var f=Array.prototype.slice.call(arguments),a=new THREE.Vector2(f[0],f[1]),b=new THREE.Vector2(f[2],f[3]),c=new THREE.Vector2(f[4],f[5]),d=new THREE.Vector2(f[6],f[7]);this.v0=a;this.v1=b;this.v2=c;this.v3=d};THREE.CubicBezierCurve.prototype=new THREE.Curve;THREE.CubicBezierCurve.prototype.constructor=THREE.CubicBezierCurve;
THREE.CubicBezierCurve.prototype.getPoint=function(a){var b;b=THREE.Shape.Utils.b3(a,this.v0.x,this.v1.x,this.v2.x,this.v3.x);a=THREE.Shape.Utils.b3(a,this.v0.y,this.v1.y,this.v2.y,this.v3.y);return new THREE.Vector2(b,a)};THREE.CubicBezierCurve.prototype.getTangent=function(a){var b;b=THREE.Curve.Utils.tangentCubicBezier(a,this.v0.x,this.v1.x,this.v2.x,this.v3.x);a=THREE.Curve.Utils.tangentCubicBezier(a,this.v0.y,this.v1.y,this.v2.y,this.v3.y);b=new THREE.Vector2(b,a);b.normalize();return b};
THREE.SplineCurve=function(a){this.points=void 0==a?[]:a};THREE.SplineCurve.prototype=new THREE.Curve;THREE.SplineCurve.prototype.constructor=THREE.SplineCurve;
THREE.SplineCurve.prototype.getPoint=function(a){var b=new THREE.Vector2,c=[],d=this.points,f;f=(d.length-1)*a;a=Math.floor(f);f-=a;c[0]=0==a?a:a-1;c[1]=a;c[2]=a>d.length-2?a:a+1;c[3]=a>d.length-3?a:a+2;b.x=THREE.Curve.Utils.interpolate(d[c[0]].x,d[c[1]].x,d[c[2]].x,d[c[3]].x,f);b.y=THREE.Curve.Utils.interpolate(d[c[0]].y,d[c[1]].y,d[c[2]].y,d[c[3]].y,f);return b};THREE.ArcCurve=function(a,b,c,d,f,g){this.aX=a;this.aY=b;this.aRadius=c;this.aStartAngle=d;this.aEndAngle=f;this.aClockwise=g};
THREE.ArcCurve.prototype=new THREE.Curve;THREE.ArcCurve.prototype.constructor=THREE.ArcCurve;THREE.ArcCurve.prototype.getPoint=function(a){var b=this.aEndAngle-this.aStartAngle;this.aClockwise||(a=1-a);b=this.aStartAngle+a*b;a=this.aX+this.aRadius*Math.cos(b);b=this.aY+this.aRadius*Math.sin(b);return new THREE.Vector2(a,b)};
THREE.Curve.Utils={tangentQuadraticBezier:function(a,b,c,d){return 2*(1-a)*(c-b)+2*a*(d-c)},tangentCubicBezier:function(a,b,c,d,f){return-3*b*(1-a)*(1-a)+3*c*(1-a)*(1-a)-6*a*c*(1-a)+6*a*d*(1-a)-3*a*a*d+3*a*a*f},tangentSpline:function(a){return 6*a*a-6*a+(3*a*a-4*a+1)+(-6*a*a+6*a)+(3*a*a-2*a)},interpolate:function(a,b,c,d,f){var a=0.5*(c-a),d=0.5*(d-b),g=f*f;return(2*b-2*c+a+d)*f*g+(-3*b+3*c-2*a-d)*g+a*f+b}};
THREE.Curve.create=function(a,b){a.prototype=new THREE.Curve;a.prototype.constructor=a;a.prototype.getPoint=b;return a};THREE.LineCurve3=THREE.Curve.create(function(a,b){this.v1=a;this.v2=b},function(a){var b=new THREE.Vector3;b.sub(this.v2,this.v1);b.multiplyScalar(a);b.addSelf(this.v1);return b});
THREE.QuadraticBezierCurve3=THREE.Curve.create(function(a,b,c){this.v0=a;this.v1=b;this.v2=c},function(a){var b,c;b=THREE.Shape.Utils.b2(a,this.v0.x,this.v1.x,this.v2.x);c=THREE.Shape.Utils.b2(a,this.v0.y,this.v1.y,this.v2.y);a=THREE.Shape.Utils.b2(a,this.v0.z,this.v1.z,this.v2.z);return new THREE.Vector3(b,c,a)});
THREE.CubicBezierCurve3=THREE.Curve.create(function(a,b,c,d){this.v0=a;this.v1=b;this.v2=c;this.v3=d},function(a){var b,c;b=THREE.Shape.Utils.b3(a,this.v0.x,this.v1.x,this.v2.x,this.v3.x);c=THREE.Shape.Utils.b3(a,this.v0.y,this.v1.y,this.v2.y,this.v3.y);a=THREE.Shape.Utils.b3(a,this.v0.z,this.v1.z,this.v2.z,this.v3.z);return new THREE.Vector3(b,c,a)});
THREE.SplineCurve3=THREE.Curve.create(function(a){this.points=void 0==a?[]:a},function(a){var b=new THREE.Vector3,c=[],d=this.points,f;f=(d.length-1)*a;a=Math.floor(f);f-=a;c[0]=0==a?a:a-1;c[1]=a;c[2]=a>d.length-2?a:a+1;c[3]=a>d.length-3?a:a+2;b.x=THREE.Curve.Utils.interpolate(d[c[0]].x,d[c[1]].x,d[c[2]].x,d[c[3]].x,f);b.y=THREE.Curve.Utils.interpolate(d[c[0]].y,d[c[1]].y,d[c[2]].y,d[c[3]].y,f);b.z=THREE.Curve.Utils.interpolate(d[c[0]].z,d[c[1]].z,d[c[2]].z,d[c[3]].z,f);return b});
THREE.CurvePath=function(){this.curves=[];this.bends=[];this.autoClose=!1};THREE.CurvePath.prototype=new THREE.Curve;THREE.CurvePath.prototype.constructor=THREE.CurvePath;THREE.CurvePath.prototype.add=function(a){this.curves.push(a)};THREE.CurvePath.prototype.checkConnection=function(){};THREE.CurvePath.prototype.closePath=function(){var a=this.curves[0].getPoint(0),b=this.curves[this.curves.length-1].getPoint(1);a.equals(b)||this.curves.push(new THREE.LineCurve(b,a))};
THREE.CurvePath.prototype.getPoint=function(a){for(var b=a*this.getLength(),c=this.getCurveLengths(),a=0;a<c.length;){if(c[a]>=b)return b=c[a]-b,a=this.curves[a],b=1-b/a.getLength(),a.getPointAt(b);a++}return null};THREE.CurvePath.prototype.getLength=function(){var a=this.getCurveLengths();return a[a.length-1]};
THREE.CurvePath.prototype.getCurveLengths=function(){if(this.cacheLengths&&this.cacheLengths.length==this.curves.length)return this.cacheLengths;var a=[],b=0,c,d=this.curves.length;for(c=0;c<d;c++)b+=this.curves[c].getLength(),a.push(b);return this.cacheLengths=a};
THREE.CurvePath.prototype.getBoundingBox=function(){var a=this.getPoints(),b,c,d,f;b=c=Number.NEGATIVE_INFINITY;d=f=Number.POSITIVE_INFINITY;var g,e,h,i;i=new THREE.Vector2;for(e=0,h=a.length;e<h;e++){g=a[e];if(g.x>b)b=g.x;else if(g.x<d)d=g.x;if(g.y>c)c=g.y;else if(g.y<c)f=g.y;i.addSelf(g.x,g.y)}return{minX:d,minY:f,maxX:b,maxY:c,centroid:i.divideScalar(h)}};THREE.CurvePath.prototype.createPointsGeometry=function(a){return this.createGeometry(this.getPoints(a,!0))};
THREE.CurvePath.prototype.createSpacedPointsGeometry=function(a){return this.createGeometry(this.getSpacedPoints(a,!0))};THREE.CurvePath.prototype.createGeometry=function(a){for(var b=new THREE.Geometry,c=0;c<a.length;c++)b.vertices.push(new THREE.Vertex(new THREE.Vector3(a[c].x,a[c].y,0)));return b};THREE.CurvePath.prototype.addWrapPath=function(a){this.bends.push(a)};
THREE.CurvePath.prototype.getTransformedPoints=function(a,b){var c=this.getPoints(a),d,f;if(!b)b=this.bends;for(d=0,f=b.length;d<f;d++)c=this.getWrapPoints(c,b[d]);return c};THREE.CurvePath.prototype.getTransformedSpacedPoints=function(a,b){var c=this.getSpacedPoints(a),d,f;if(!b)b=this.bends;for(d=0,f=b.length;d<f;d++)c=this.getWrapPoints(c,b[d]);return c};
THREE.CurvePath.prototype.getWrapPoints=function(a,b){var c=this.getBoundingBox(),d,f,g,e,h,i;for(d=0,f=a.length;d<f;d++)g=a[d],e=g.x,h=g.y,i=e/c.maxX,i=b.getUtoTmapping(i,e),e=b.getPoint(i),h=b.getNormalVector(i).multiplyScalar(h),g.x=e.x+h.x,g.y=e.y+h.y;return a};
THREE.EventTarget=function(){var a={};this.addEventListener=function(b,c){void 0==a[b]&&(a[b]=[]);-1===a[b].indexOf(c)&&a[b].push(c)};this.dispatchEvent=function(b){for(var c in a[b.type])a[b.type][c](b)};this.removeEventListener=function(b,c){var d=a[b].indexOf(c);-1!==d&&a[b].splice(d,1)}};THREE.Gyroscope=function(){THREE.Object3D.call(this)};THREE.Gyroscope.prototype=new THREE.Object3D;THREE.Gyroscope.prototype.constructor=THREE.Gyroscope;
THREE.Gyroscope.prototype.updateMatrixWorld=function(a){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||a)this.parent?(this.matrixWorld.multiply(this.parent.matrixWorld,this.matrix),this.matrixWorld.decompose(this.translationWorld,this.rotationWorld,this.scaleWorld),this.matrix.decompose(this.translationObject,this.rotationObject,this.scaleObject),this.matrixWorld.compose(this.translationWorld,this.rotationObject,this.scaleWorld)):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=
!1,a=!0;for(var b=0,c=this.children.length;b<c;b++)this.children[b].updateMatrixWorld(a)};THREE.Gyroscope.prototype.translationWorld=new THREE.Vector3;THREE.Gyroscope.prototype.translationObject=new THREE.Vector3;THREE.Gyroscope.prototype.rotationWorld=new THREE.Quaternion;THREE.Gyroscope.prototype.rotationObject=new THREE.Quaternion;THREE.Gyroscope.prototype.scaleWorld=new THREE.Vector3;THREE.Gyroscope.prototype.scaleObject=new THREE.Vector3;
THREE.Path=function(a){THREE.CurvePath.call(this);this.actions=[];a&&this.fromPoints(a)};THREE.Path.prototype=new THREE.CurvePath;THREE.Path.prototype.constructor=THREE.Path;THREE.PathActions={MOVE_TO:"moveTo",LINE_TO:"lineTo",QUADRATIC_CURVE_TO:"quadraticCurveTo",BEZIER_CURVE_TO:"bezierCurveTo",CSPLINE_THRU:"splineThru",ARC:"arc"};THREE.Path.prototype.fromPoints=function(a){this.moveTo(a[0].x,a[0].y);for(var b=1,c=a.length;b<c;b++)this.lineTo(a[b].x,a[b].y)};
THREE.Path.prototype.moveTo=function(a,b){var c=Array.prototype.slice.call(arguments);this.actions.push({action:THREE.PathActions.MOVE_TO,args:c})};THREE.Path.prototype.lineTo=function(a,b){var c=Array.prototype.slice.call(arguments),d=this.actions[this.actions.length-1].args;this.curves.push(new THREE.LineCurve(new THREE.Vector2(d[d.length-2],d[d.length-1]),new THREE.Vector2(a,b)));this.actions.push({action:THREE.PathActions.LINE_TO,args:c})};
THREE.Path.prototype.quadraticCurveTo=function(a,b,c,d){var f=Array.prototype.slice.call(arguments),g=this.actions[this.actions.length-1].args;this.curves.push(new THREE.QuadraticBezierCurve(new THREE.Vector2(g[g.length-2],g[g.length-1]),new THREE.Vector2(a,b),new THREE.Vector2(c,d)));this.actions.push({action:THREE.PathActions.QUADRATIC_CURVE_TO,args:f})};
THREE.Path.prototype.bezierCurveTo=function(a,b,c,d,f,g){var e=Array.prototype.slice.call(arguments),h=this.actions[this.actions.length-1].args;this.curves.push(new THREE.CubicBezierCurve(new THREE.Vector2(h[h.length-2],h[h.length-1]),new THREE.Vector2(a,b),new THREE.Vector2(c,d),new THREE.Vector2(f,g)));this.actions.push({action:THREE.PathActions.BEZIER_CURVE_TO,args:e})};
THREE.Path.prototype.splineThru=function(a){var b=Array.prototype.slice.call(arguments),c=this.actions[this.actions.length-1].args,c=[new THREE.Vector2(c[c.length-2],c[c.length-1])];Array.prototype.push.apply(c,a);this.curves.push(new THREE.SplineCurve(c));this.actions.push({action:THREE.PathActions.CSPLINE_THRU,args:b})};
THREE.Path.prototype.arc=function(a,b,c,d,f,g){var e=Array.prototype.slice.call(arguments);this.curves.push(new THREE.ArcCurve(a,b,c,d,f,g));this.actions.push({action:THREE.PathActions.ARC,args:e})};THREE.Path.prototype.getSpacedPoints=function(a){a||(a=40);for(var b=[],c=0;c<a;c++)b.push(this.getPoint(c/a));return b};
THREE.Path.prototype.getPoints=function(a,b){var a=a||12,c=[],d,f,g,e,h,i,k,j,q,l,n,r,m;for(d=0,f=this.actions.length;d<f;d++)switch(g=this.actions[d],e=g.action,g=g.args,e){case THREE.PathActions.LINE_TO:c.push(new THREE.Vector2(g[0],g[1]));break;case THREE.PathActions.QUADRATIC_CURVE_TO:h=g[2];i=g[3];q=g[0];l=g[1];0<c.length?(e=c[c.length-1],n=e.x,r=e.y):(e=this.actions[d-1].args,n=e[e.length-2],r=e[e.length-1]);for(e=1;e<=a;e++)m=e/a,g=THREE.Shape.Utils.b2(m,n,q,h),m=THREE.Shape.Utils.b2(m,r,l,
i),c.push(new THREE.Vector2(g,m));break;case THREE.PathActions.BEZIER_CURVE_TO:h=g[4];i=g[5];q=g[0];l=g[1];k=g[2];j=g[3];0<c.length?(e=c[c.length-1],n=e.x,r=e.y):(e=this.actions[d-1].args,n=e[e.length-2],r=e[e.length-1]);for(e=1;e<=a;e++)m=e/a,g=THREE.Shape.Utils.b3(m,n,q,k,h),m=THREE.Shape.Utils.b3(m,r,l,j,i),c.push(new THREE.Vector2(g,m));break;case THREE.PathActions.CSPLINE_THRU:e=this.actions[d-1].args;e=[new THREE.Vector2(e[e.length-2],e[e.length-1])];m=a*g[0].length;e=e.concat(g[0]);g=new THREE.SplineCurve(e);
for(e=1;e<=m;e++)c.push(g.getPointAt(e/m));break;case THREE.PathActions.ARC:e=this.actions[d-1].args;h=g[0];i=g[1];k=g[2];q=g[3];m=g[4];l=!!g[5];j=e[e.length-2];n=e[e.length-1];0==e.length&&(j=n=0);r=m-q;var o=2*a;for(e=1;e<=o;e++)m=e/o,l||(m=1-m),m=q+m*r,g=j+h+k*Math.cos(m),m=n+i+k*Math.sin(m),c.push(new THREE.Vector2(g,m))}b&&c.push(c[0]);return c};THREE.Path.prototype.transform=function(a,b){this.getBoundingBox();return this.getWrapPoints(this.getPoints(b),a)};
THREE.Path.prototype.nltransform=function(a,b,c,d,f,g){var e=this.getPoints(),h,i,k,j,q;for(h=0,i=e.length;h<i;h++)k=e[h],j=k.x,q=k.y,k.x=a*j+b*q+c,k.y=d*q+f*j+g;return e};
THREE.Path.prototype.debug=function(a){var b=this.getBoundingBox();a||(a=document.createElement("canvas"),a.setAttribute("width",b.maxX+100),a.setAttribute("height",b.maxY+100),document.body.appendChild(a));b=a.getContext("2d");b.fillStyle="white";b.fillRect(0,0,a.width,a.height);b.strokeStyle="black";b.beginPath();var c,d,f;for(a=0,c=this.actions.length;a<c;a++)d=this.actions[a],f=d.args,d=d.action,d!=THREE.PathActions.CSPLINE_THRU&&b[d].apply(b,f);b.stroke();b.closePath();b.strokeStyle="red";d=
this.getPoints();for(a=0,c=d.length;a<c;a++)f=d[a],b.beginPath(),b.arc(f.x,f.y,1.5,0,2*Math.PI,!1),b.stroke(),b.closePath()};
THREE.Path.prototype.toShapes=function(){var a,b,c,d,f=[],g=new THREE.Path;for(a=0,b=this.actions.length;a<b;a++)c=this.actions[a],d=c.args,c=c.action,c==THREE.PathActions.MOVE_TO&&0!=g.actions.length&&(f.push(g),g=new THREE.Path),g[c].apply(g,d);0!=g.actions.length&&f.push(g);if(0==f.length)return[];var e;d=[];a=!THREE.Shape.Utils.isClockWise(f[0].getPoints());if(1==f.length)return g=f[0],e=new THREE.Shape,e.actions=g.actions,e.curves=g.curves,d.push(e),d;if(a){e=new THREE.Shape;for(a=0,b=f.length;a<
b;a++)g=f[a],THREE.Shape.Utils.isClockWise(g.getPoints())?(e.actions=g.actions,e.curves=g.curves,d.push(e),e=new THREE.Shape):e.holes.push(g)}else{for(a=0,b=f.length;a<b;a++)g=f[a],THREE.Shape.Utils.isClockWise(g.getPoints())?(e&&d.push(e),e=new THREE.Shape,e.actions=g.actions,e.curves=g.curves):e.holes.push(g);d.push(e)}return d};THREE.Shape=function(){THREE.Path.apply(this,arguments);this.holes=[]};THREE.Shape.prototype=new THREE.Path;THREE.Shape.prototype.constructor=THREE.Path;
THREE.Shape.prototype.extrude=function(a){return new THREE.ExtrudeGeometry(this,a)};THREE.Shape.prototype.getPointsHoles=function(a){var b,c=this.holes.length,d=[];for(b=0;b<c;b++)d[b]=this.holes[b].getTransformedPoints(a,this.bends);return d};THREE.Shape.prototype.getSpacedPointsHoles=function(a){var b,c=this.holes.length,d=[];for(b=0;b<c;b++)d[b]=this.holes[b].getTransformedSpacedPoints(a,this.bends);return d};
THREE.Shape.prototype.extractAllPoints=function(a){return{shape:this.getTransformedPoints(a),holes:this.getPointsHoles(a)}};THREE.Shape.prototype.extractAllSpacedPoints=function(a){return{shape:this.getTransformedSpacedPoints(a),holes:this.getSpacedPointsHoles(a)}};
THREE.Shape.Utils={removeHoles:function(a,b){var c=a.concat(),d=c.concat(),f,g,e,h,i,k,j,q,l,n,r=[];for(i=0;i<b.length;i++){k=b[i];Array.prototype.push.apply(d,k);g=Number.POSITIVE_INFINITY;for(f=0;f<k.length;f++){l=k[f];n=[];for(q=0;q<c.length;q++)j=c[q],j=l.distanceToSquared(j),n.push(j),j<g&&(g=j,e=f,h=q)}f=0<=h-1?h-1:c.length-1;g=0<=e-1?e-1:k.length-1;var m=[k[e],c[h],c[f]];q=THREE.FontUtils.Triangulate.area(m);var o=[k[e],k[g],c[h]];l=THREE.FontUtils.Triangulate.area(o);n=h;j=e;h+=1;e+=-1;0>
h&&(h+=c.length);h%=c.length;0>e&&(e+=k.length);e%=k.length;f=0<=h-1?h-1:c.length-1;g=0<=e-1?e-1:k.length-1;m=[k[e],c[h],c[f]];m=THREE.FontUtils.Triangulate.area(m);o=[k[e],k[g],c[h]];o=THREE.FontUtils.Triangulate.area(o);q+l>m+o&&(h=n,e=j,0>h&&(h+=c.length),h%=c.length,0>e&&(e+=k.length),e%=k.length,f=0<=h-1?h-1:c.length-1,g=0<=e-1?e-1:k.length-1);q=c.slice(0,h);l=c.slice(h);n=k.slice(e);j=k.slice(0,e);g=[k[e],k[g],c[h]];r.push([k[e],c[h],c[f]]);r.push(g);c=q.concat(n).concat(j).concat(l)}return{shape:c,
isolatedPts:r,allpoints:d}},triangulateShape:function(a,b){var c=THREE.Shape.Utils.removeHoles(a,b),d=c.allpoints,f=c.isolatedPts,c=THREE.FontUtils.Triangulate(c.shape,!1),g,e,h,i,k={};for(g=0,e=d.length;g<e;g++)i=d[g].x+":"+d[g].y,void 0!==k[i]&&console.log("Duplicate point",i),k[i]=g;for(g=0,e=c.length;g<e;g++){h=c[g];for(d=0;3>d;d++)i=h[d].x+":"+h[d].y,i=k[i],void 0!==i&&(h[d]=i)}for(g=0,e=f.length;g<e;g++){h=f[g];for(d=0;3>d;d++)i=h[d].x+":"+h[d].y,i=k[i],void 0!==i&&(h[d]=i)}return c.concat(f)},
isClockWise:function(a){return 0>THREE.FontUtils.Triangulate.area(a)},b2p0:function(a,b){var c=1-a;return c*c*b},b2p1:function(a,b){return 2*(1-a)*a*b},b2p2:function(a,b){return a*a*b},b2:function(a,b,c,d){return this.b2p0(a,b)+this.b2p1(a,c)+this.b2p2(a,d)},b3p0:function(a,b){var c=1-a;return c*c*c*b},b3p1:function(a,b){var c=1-a;return 3*c*c*a*b},b3p2:function(a,b){return 3*(1-a)*a*a*b},b3p3:function(a,b){return a*a*a*b},b3:function(a,b,c,d,f){return this.b3p0(a,b)+this.b3p1(a,c)+this.b3p2(a,d)+
this.b3p3(a,f)}};THREE.TextPath=function(a,b){THREE.Path.call(this);this.parameters=b||{};this.set(a)};THREE.TextPath.prototype.set=function(a,b){b=b||this.parameters;this.text=a;var c=void 0!==b.curveSegments?b.curveSegments:4,d=void 0!==b.font?b.font:"helvetiker",f=void 0!==b.weight?b.weight:"normal",g=void 0!==b.style?b.style:"normal";THREE.FontUtils.size=void 0!==b.size?b.size:100;THREE.FontUtils.divisions=c;THREE.FontUtils.face=d;THREE.FontUtils.weight=f;THREE.FontUtils.style=g};
THREE.TextPath.prototype.toShapes=function(){for(var a=THREE.FontUtils.drawText(this.text).paths,b=[],c=0,d=a.length;c<d;c++)Array.prototype.push.apply(b,a[c].toShapes());return b};
THREE.AnimationHandler=function(){var a=[],b={},c={update:function(b){for(var c=0;c<a.length;c++)a[c].update(b)},addToUpdate:function(b){-1===a.indexOf(b)&&a.push(b)},removeFromUpdate:function(b){b=a.indexOf(b);-1!==b&&a.splice(b,1)},add:function(a){void 0!==b[a.name]&&console.log("THREE.AnimationHandler.add: Warning! "+a.name+" already exists in library. Overwriting.");b[a.name]=a;if(!0!==a.initialized){for(var c=0;c<a.hierarchy.length;c++){for(var d=0;d<a.hierarchy[c].keys.length;d++){if(0>a.hierarchy[c].keys[d].time)a.hierarchy[c].keys[d].time=
0;if(void 0!==a.hierarchy[c].keys[d].rot&&!(a.hierarchy[c].keys[d].rot instanceof THREE.Quaternion)){var h=a.hierarchy[c].keys[d].rot;a.hierarchy[c].keys[d].rot=new THREE.Quaternion(h[0],h[1],h[2],h[3])}}if(a.hierarchy[c].keys.length&&void 0!==a.hierarchy[c].keys[0].morphTargets){h={};for(d=0;d<a.hierarchy[c].keys.length;d++)for(var i=0;i<a.hierarchy[c].keys[d].morphTargets.length;i++){var k=a.hierarchy[c].keys[d].morphTargets[i];h[k]=-1}a.hierarchy[c].usedMorphTargets=h;for(d=0;d<a.hierarchy[c].keys.length;d++){var j=
{};for(k in h){for(i=0;i<a.hierarchy[c].keys[d].morphTargets.length;i++)if(a.hierarchy[c].keys[d].morphTargets[i]===k){j[k]=a.hierarchy[c].keys[d].morphTargetsInfluences[i];break}i===a.hierarchy[c].keys[d].morphTargets.length&&(j[k]=0)}a.hierarchy[c].keys[d].morphTargetsInfluences=j}}for(d=1;d<a.hierarchy[c].keys.length;d++)a.hierarchy[c].keys[d].time===a.hierarchy[c].keys[d-1].time&&(a.hierarchy[c].keys.splice(d,1),d--);for(d=0;d<a.hierarchy[c].keys.length;d++)a.hierarchy[c].keys[d].index=d}d=parseInt(a.length*
a.fps,10);a.JIT={};a.JIT.hierarchy=[];for(c=0;c<a.hierarchy.length;c++)a.JIT.hierarchy.push(Array(d));a.initialized=!0}},get:function(a){if("string"===typeof a){if(b[a])return b[a];console.log("THREE.AnimationHandler.get: Couldn't find animation "+a);return null}},parse:function(a){var b=[];if(a instanceof THREE.SkinnedMesh)for(var c=0;c<a.bones.length;c++)b.push(a.bones[c]);else d(a,b);return b}},d=function(a,b){b.push(a);for(var c=0;c<a.children.length;c++)d(a.children[c],b)};c.LINEAR=0;c.CATMULLROM=
1;c.CATMULLROM_FORWARD=2;return c}();THREE.Animation=function(a,b,c,d){this.root=a;this.data=THREE.AnimationHandler.get(b);this.hierarchy=THREE.AnimationHandler.parse(a);this.currentTime=0;this.timeScale=1;this.isPlaying=!1;this.loop=this.isPaused=!0;this.interpolationType=void 0!==c?c:THREE.AnimationHandler.LINEAR;this.JITCompile=void 0!==d?d:!0;this.points=[];this.target=new THREE.Vector3};
THREE.Animation.prototype.play=function(a,b){if(!this.isPlaying){this.isPlaying=!0;this.loop=void 0!==a?a:!0;this.currentTime=void 0!==b?b:0;var c,d=this.hierarchy.length,f;for(c=0;c<d;c++){f=this.hierarchy[c];if(this.interpolationType!==THREE.AnimationHandler.CATMULLROM_FORWARD)f.useQuaternion=!0;f.matrixAutoUpdate=!0;if(void 0===f.animationCache)f.animationCache={},f.animationCache.prevKey={pos:0,rot:0,scl:0},f.animationCache.nextKey={pos:0,rot:0,scl:0},f.animationCache.originalMatrix=f instanceof
THREE.Bone?f.skinMatrix:f.matrix;var g=f.animationCache.prevKey;f=f.animationCache.nextKey;g.pos=this.data.hierarchy[c].keys[0];g.rot=this.data.hierarchy[c].keys[0];g.scl=this.data.hierarchy[c].keys[0];f.pos=this.getNextKeyWith("pos",c,1);f.rot=this.getNextKeyWith("rot",c,1);f.scl=this.getNextKeyWith("scl",c,1)}this.update(0)}this.isPaused=!1;THREE.AnimationHandler.addToUpdate(this)};
THREE.Animation.prototype.pause=function(){this.isPaused?THREE.AnimationHandler.addToUpdate(this):THREE.AnimationHandler.removeFromUpdate(this);this.isPaused=!this.isPaused};
THREE.Animation.prototype.stop=function(){this.isPaused=this.isPlaying=!1;THREE.AnimationHandler.removeFromUpdate(this);for(var a=0;a<this.hierarchy.length;a++)if(void 0!==this.hierarchy[a].animationCache)this.hierarchy[a]instanceof THREE.Bone?this.hierarchy[a].skinMatrix=this.hierarchy[a].animationCache.originalMatrix:this.hierarchy[a].matrix=this.hierarchy[a].animationCache.originalMatrix,delete this.hierarchy[a].animationCache};
THREE.Animation.prototype.update=function(a){if(this.isPlaying){var b=["pos","rot","scl"],c,d,f,g,e,h,i,k,j=this.data.JIT.hierarchy,q,l;l=this.currentTime+=a*this.timeScale;q=this.currentTime%=this.data.length;k=parseInt(Math.min(q*this.data.fps,this.data.length*this.data.fps),10);for(var n=0,r=this.hierarchy.length;n<r;n++)if(a=this.hierarchy[n],i=a.animationCache,this.JITCompile&&void 0!==j[n][k])a instanceof THREE.Bone?(a.skinMatrix=j[n][k],a.matrixAutoUpdate=!1,a.matrixWorldNeedsUpdate=!1):(a.matrix=
j[n][k],a.matrixAutoUpdate=!1,a.matrixWorldNeedsUpdate=!0);else{if(this.JITCompile)a instanceof THREE.Bone?a.skinMatrix=a.animationCache.originalMatrix:a.matrix=a.animationCache.originalMatrix;for(var m=0;3>m;m++){c=b[m];e=i.prevKey[c];h=i.nextKey[c];if(h.time<=l){if(q<l)if(this.loop){e=this.data.hierarchy[n].keys[0];for(h=this.getNextKeyWith(c,n,1);h.time<q;)e=h,h=this.getNextKeyWith(c,n,h.index+1)}else{this.stop();return}else{do e=h,h=this.getNextKeyWith(c,n,h.index+1);while(h.time<q)}i.prevKey[c]=
e;i.nextKey[c]=h}a.matrixAutoUpdate=!0;a.matrixWorldNeedsUpdate=!0;d=(q-e.time)/(h.time-e.time);f=e[c];g=h[c];if(0>d||1<d)console.log("THREE.Animation.update: Warning! Scale out of bounds:"+d+" on bone "+n),d=0>d?0:1;if("pos"===c)if(c=a.position,this.interpolationType===THREE.AnimationHandler.LINEAR)c.x=f[0]+(g[0]-f[0])*d,c.y=f[1]+(g[1]-f[1])*d,c.z=f[2]+(g[2]-f[2])*d;else{if(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD)if(this.points[0]=
this.getPrevKeyWith("pos",n,e.index-1).pos,this.points[1]=f,this.points[2]=g,this.points[3]=this.getNextKeyWith("pos",n,h.index+1).pos,d=0.33*d+0.33,f=this.interpolateCatmullRom(this.points,d),c.x=f[0],c.y=f[1],c.z=f[2],this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD)d=this.interpolateCatmullRom(this.points,1.01*d),this.target.set(d[0],d[1],d[2]),this.target.subSelf(c),this.target.y=0,this.target.normalize(),d=Math.atan2(this.target.x,this.target.z),a.rotation.set(0,d,0)}else if("rot"===
c)THREE.Quaternion.slerp(f,g,a.quaternion,d);else if("scl"===c)c=a.scale,c.x=f[0]+(g[0]-f[0])*d,c.y=f[1]+(g[1]-f[1])*d,c.z=f[2]+(g[2]-f[2])*d}}if(this.JITCompile&&void 0===j[0][k]){this.hierarchy[0].updateMatrixWorld(!0);for(n=0;n<this.hierarchy.length;n++)j[n][k]=this.hierarchy[n]instanceof THREE.Bone?this.hierarchy[n].skinMatrix.clone():this.hierarchy[n].matrix.clone()}}};
THREE.Animation.prototype.interpolateCatmullRom=function(a,b){var c=[],d=[],f,g,e,h,i,k;f=(a.length-1)*b;g=Math.floor(f);f-=g;c[0]=0===g?g:g-1;c[1]=g;c[2]=g>a.length-2?g:g+1;c[3]=g>a.length-3?g:g+2;g=a[c[0]];h=a[c[1]];i=a[c[2]];k=a[c[3]];c=f*f;e=f*c;d[0]=this.interpolate(g[0],h[0],i[0],k[0],f,c,e);d[1]=this.interpolate(g[1],h[1],i[1],k[1],f,c,e);d[2]=this.interpolate(g[2],h[2],i[2],k[2],f,c,e);return d};
THREE.Animation.prototype.interpolate=function(a,b,c,d,f,g,e){a=0.5*(c-a);d=0.5*(d-b);return(2*(b-c)+a+d)*e+(-3*(b-c)-2*a-d)*g+a*f+b};THREE.Animation.prototype.getNextKeyWith=function(a,b,c){for(var d=this.data.hierarchy[b].keys,c=this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD?c<d.length-1?c:d.length-1:c%d.length;c<d.length;c++)if(void 0!==d[c][a])return d[c];return this.data.hierarchy[b].keys[0]};
THREE.Animation.prototype.getPrevKeyWith=function(a,b,c){for(var d=this.data.hierarchy[b].keys,c=this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD?0<c?c:0:0<=c?c:c+d.length;0<=c;c--)if(void 0!==d[c][a])return d[c];return this.data.hierarchy[b].keys[d.length-1]};
THREE.KeyFrameAnimation=function(a,b,c){this.root=a;this.data=THREE.AnimationHandler.get(b);this.hierarchy=THREE.AnimationHandler.parse(a);this.currentTime=0;this.timeScale=0.001;this.isPlaying=!1;this.loop=this.isPaused=!0;this.JITCompile=void 0!==c?c:!0;a=0;for(b=this.hierarchy.length;a<b;a++){var c=this.data.hierarchy[a].sids,d=this.hierarchy[a];if(this.data.hierarchy[a].keys.length&&c){for(var f=0;f<c.length;f++){var g=c[f],e=this.getNextKeyWith(g,a,0);e&&e.apply(g)}d.matrixAutoUpdate=!1;this.data.hierarchy[a].node.updateMatrix();
d.matrixWorldNeedsUpdate=!0}}};
THREE.KeyFrameAnimation.prototype.play=function(a,b){if(!this.isPlaying){this.isPlaying=!0;this.loop=void 0!==a?a:!0;this.currentTime=void 0!==b?b:0;this.startTimeMs=b;this.startTime=1E7;this.endTime=-this.startTime;var c,d=this.hierarchy.length,f,g;for(c=0;c<d;c++){f=this.hierarchy[c];g=this.data.hierarchy[c];f.useQuaternion=!0;if(void 0===g.animationCache)g.animationCache={},g.animationCache.prevKey=null,g.animationCache.nextKey=null,g.animationCache.originalMatrix=f instanceof THREE.Bone?f.skinMatrix:
f.matrix;f=this.data.hierarchy[c].keys;if(f.length)g.animationCache.prevKey=f[0],g.animationCache.nextKey=f[1],this.startTime=Math.min(f[0].time,this.startTime),this.endTime=Math.max(f[f.length-1].time,this.endTime)}this.update(0)}this.isPaused=!1;THREE.AnimationHandler.addToUpdate(this)};THREE.KeyFrameAnimation.prototype.pause=function(){this.isPaused?THREE.AnimationHandler.addToUpdate(this):THREE.AnimationHandler.removeFromUpdate(this);this.isPaused=!this.isPaused};
THREE.KeyFrameAnimation.prototype.stop=function(){this.isPaused=this.isPlaying=!1;THREE.AnimationHandler.removeFromUpdate(this);for(var a=0;a<this.data.hierarchy.length;a++){var b=this.hierarchy[a],c=this.data.hierarchy[a];if(void 0!==c.animationCache){var d=c.animationCache.originalMatrix;b instanceof THREE.Bone?(d.copy(b.skinMatrix),b.skinMatrix=d):(d.copy(b.matrix),b.matrix=d);delete c.animationCache}}};
THREE.KeyFrameAnimation.prototype.update=function(a){if(this.isPlaying){var b,c,d,f,g=this.data.JIT.hierarchy,e,h,i;h=this.currentTime+=a*this.timeScale;e=this.currentTime%=this.data.length;if(e<this.startTimeMs)e=this.currentTime=this.startTimeMs+e;f=parseInt(Math.min(e*this.data.fps,this.data.length*this.data.fps),10);if((i=e<h)&&!this.loop){for(var a=0,k=this.hierarchy.length;a<k;a++){var j=this.data.hierarchy[a].keys,g=this.data.hierarchy[a].sids;d=j.length-1;f=this.hierarchy[a];if(j.length){for(j=
0;j<g.length;j++)e=g[j],(h=this.getPrevKeyWith(e,a,d))&&h.apply(e);this.data.hierarchy[a].node.updateMatrix();f.matrixWorldNeedsUpdate=!0}}this.stop()}else if(!(e<this.startTime)){a=0;for(k=this.hierarchy.length;a<k;a++){d=this.hierarchy[a];b=this.data.hierarchy[a];var j=b.keys,q=b.animationCache;if(this.JITCompile&&void 0!==g[a][f])d instanceof THREE.Bone?(d.skinMatrix=g[a][f],d.matrixWorldNeedsUpdate=!1):(d.matrix=g[a][f],d.matrixWorldNeedsUpdate=!0);else if(j.length){if(this.JITCompile&&q)d instanceof
THREE.Bone?d.skinMatrix=q.originalMatrix:d.matrix=q.originalMatrix;b=q.prevKey;c=q.nextKey;if(b&&c){if(c.time<=h){if(i&&this.loop){b=j[0];for(c=j[1];c.time<e;)b=c,c=j[b.index+1]}else if(!i)for(var l=j.length-1;c.time<e&&c.index!==l;)b=c,c=j[b.index+1];q.prevKey=b;q.nextKey=c}c.time>=e?b.interpolate(c,e):b.interpolate(c,c.time)}this.data.hierarchy[a].node.updateMatrix();d.matrixWorldNeedsUpdate=!0}}if(this.JITCompile&&void 0===g[0][f]){this.hierarchy[0].updateMatrixWorld(!0);for(a=0;a<this.hierarchy.length;a++)g[a][f]=
this.hierarchy[a]instanceof THREE.Bone?this.hierarchy[a].skinMatrix.clone():this.hierarchy[a].matrix.clone()}}}};THREE.KeyFrameAnimation.prototype.getNextKeyWith=function(a,b,c){b=this.data.hierarchy[b].keys;for(c%=b.length;c<b.length;c++)if(b[c].hasTarget(a))return b[c];return b[0]};THREE.KeyFrameAnimation.prototype.getPrevKeyWith=function(a,b,c){b=this.data.hierarchy[b].keys;for(c=0<=c?c:c+b.length;0<=c;c--)if(b[c].hasTarget(a))return b[c];return b[b.length-1]};
THREE.CubeCamera=function(a,b,c,d){this.heightOffset=c;this.position=new THREE.Vector3(0,c,0);this.cameraPX=new THREE.PerspectiveCamera(90,1,a,b);this.cameraNX=new THREE.PerspectiveCamera(90,1,a,b);this.cameraPY=new THREE.PerspectiveCamera(90,1,a,b);this.cameraNY=new THREE.PerspectiveCamera(90,1,a,b);this.cameraPZ=new THREE.PerspectiveCamera(90,1,a,b);this.cameraNZ=new THREE.PerspectiveCamera(90,1,a,b);this.cameraPX.position=this.position;this.cameraNX.position=this.position;this.cameraPY.position=
this.position;this.cameraNY.position=this.position;this.cameraPZ.position=this.position;this.cameraNZ.position=this.position;this.cameraPX.up.set(0,-1,0);this.cameraNX.up.set(0,-1,0);this.cameraPY.up.set(0,0,1);this.cameraNY.up.set(0,0,-1);this.cameraPZ.up.set(0,-1,0);this.cameraNZ.up.set(0,-1,0);this.targetPX=new THREE.Vector3(0,0,0);this.targetNX=new THREE.Vector3(0,0,0);this.targetPY=new THREE.Vector3(0,0,0);this.targetNY=new THREE.Vector3(0,0,0);this.targetPZ=new THREE.Vector3(0,0,0);this.targetNZ=
new THREE.Vector3(0,0,0);this.renderTarget=new THREE.WebGLRenderTargetCube(d,d,{format:THREE.RGBFormat,magFilter:THREE.LinearFilter,minFilter:THREE.LinearFilter});this.updatePosition=function(a){this.position.copy(a);this.position.y+=this.heightOffset;this.targetPX.copy(this.position);this.targetNX.copy(this.position);this.targetPY.copy(this.position);this.targetNY.copy(this.position);this.targetPZ.copy(this.position);this.targetNZ.copy(this.position);this.targetPX.x+=1;this.targetNX.x-=1;this.targetPY.y+=
1;this.targetNY.y-=1;this.targetPZ.z+=1;this.targetNZ.z-=1;this.cameraPX.lookAt(this.targetPX);this.cameraNX.lookAt(this.targetNX);this.cameraPY.lookAt(this.targetPY);this.cameraNY.lookAt(this.targetNY);this.cameraPZ.lookAt(this.targetPZ);this.cameraNZ.lookAt(this.targetNZ)};this.updateCubeMap=function(a,b){var c=this.renderTarget;c.activeCubeFace=0;a.render(b,this.cameraPX,c);c.activeCubeFace=1;a.render(b,this.cameraNX,c);c.activeCubeFace=2;a.render(b,this.cameraPY,c);c.activeCubeFace=3;a.render(b,
this.cameraNY,c);c.activeCubeFace=4;a.render(b,this.cameraPZ,c);c.activeCubeFace=5;a.render(b,this.cameraNZ,c)}};THREE.CombinedCamera=function(a,b,c,d,f,g,e){THREE.Camera.call(this);this.fov=c;this.left=-a/2;this.right=a/2;this.top=b/2;this.bottom=-b/2;this.cameraO=new THREE.OrthographicCamera(a/-2,a/2,b/2,b/-2,g,e);this.cameraP=new THREE.PerspectiveCamera(c,a/b,d,f);this.zoom=1;this.toPerspective()};THREE.CombinedCamera.prototype=new THREE.Camera;THREE.CombinedCamera.prototype.constructor=THREE.CoolCamera;
THREE.CombinedCamera.prototype.toPerspective=function(){this.near=this.cameraP.near;this.far=this.cameraP.far;this.cameraP.fov=this.fov/this.zoom;this.cameraP.updateProjectionMatrix();this.projectionMatrix=this.cameraP.projectionMatrix;this.inPersepectiveMode=!0;this.inOrthographicMode=!1};
THREE.CombinedCamera.prototype.toOrthographic=function(){var a=this.cameraP.aspect,b=(this.cameraP.near+this.cameraP.far)/2,b=Math.tan(this.fov/2)*b,a=2*b*a/2,b=b/this.zoom,a=a/this.zoom;this.cameraO.left=-a;this.cameraO.right=a;this.cameraO.top=b;this.cameraO.bottom=-b;this.cameraO.updateProjectionMatrix();this.near=this.cameraO.near;this.far=this.cameraO.far;this.projectionMatrix=this.cameraO.projectionMatrix;this.inPersepectiveMode=!1;this.inOrthographicMode=!0};
THREE.CombinedCamera.prototype.setFov=function(a){this.fov=a;this.inPersepectiveMode?this.toPerspective():this.toOrthographic()};THREE.CombinedCamera.prototype.setLens=function(a,b){var c=2*Math.atan((void 0!==b?b:24)/(2*a))*(180/Math.PI);this.setFov(c);return c};THREE.CombinedCamera.prototype.setZoom=function(a){this.zoom=a;this.inPersepectiveMode?this.toPerspective():this.toOrthographic()};
THREE.CombinedCamera.prototype.toFrontView=function(){this.rotation.x=0;this.rotation.y=0;this.rotation.z=0;this.rotationAutoUpdate=!1};THREE.CombinedCamera.prototype.toBackView=function(){this.rotation.x=0;this.rotation.y=Math.PI;this.rotation.z=0;this.rotationAutoUpdate=!1};THREE.CombinedCamera.prototype.toLeftView=function(){this.rotation.x=0;this.rotation.y=-Math.PI/2;this.rotation.z=0;this.rotationAutoUpdate=!1};
THREE.CombinedCamera.prototype.toRightView=function(){this.rotation.x=0;this.rotation.y=Math.PI/2;this.rotation.z=0;this.rotationAutoUpdate=!1};THREE.CombinedCamera.prototype.toTopView=function(){this.rotation.x=-Math.PI/2;this.rotation.y=0;this.rotation.z=0;this.rotationAutoUpdate=!1};THREE.CombinedCamera.prototype.toBottomView=function(){this.rotation.x=Math.PI/2;this.rotation.y=0;this.rotation.z=0;this.rotationAutoUpdate=!1};
THREE.FirstPersonControls=function(a,b){function c(a,b){return function(){b.apply(a,arguments)}}this.object=a;this.target=new THREE.Vector3(0,0,0);this.domElement=void 0!==b?b:document;this.movementSpeed=1;this.lookSpeed=0.005;this.noFly=!1;this.lookVertical=!0;this.autoForward=!1;this.activeLook=!0;this.heightSpeed=!1;this.heightCoef=1;this.heightMin=0;this.constrainVertical=!1;this.verticalMin=0;this.verticalMax=Math.PI;this.theta=this.phi=this.lon=this.lat=this.mouseY=this.mouseX=this.autoSpeedFactor=
0;this.mouseDragOn=this.freeze=this.moveRight=this.moveLeft=this.moveBackward=this.moveForward=!1;this.domElement===document?(this.viewHalfX=window.innerWidth/2,this.viewHalfY=window.innerHeight/2):(this.viewHalfX=this.domElement.offsetWidth/2,this.viewHalfY=this.domElement.offsetHeight/2,this.domElement.setAttribute("tabindex",-1));this.onMouseDown=function(a){this.domElement!==document&&this.domElement.focus();a.preventDefault();a.stopPropagation();if(this.activeLook)switch(a.button){case 0:this.moveForward=
!0;break;case 2:this.moveBackward=!0}this.mouseDragOn=!0};this.onMouseUp=function(a){a.preventDefault();a.stopPropagation();if(this.activeLook)switch(a.button){case 0:this.moveForward=!1;break;case 2:this.moveBackward=!1}this.mouseDragOn=!1};this.onMouseMove=function(a){this.domElement===document?(this.mouseX=a.pageX-this.viewHalfX,this.mouseY=a.pageY-this.viewHalfY):(this.mouseX=a.pageX-this.domElement.offsetLeft-this.viewHalfX,this.mouseY=a.pageY-this.domElement.offsetTop-this.viewHalfY)};this.onKeyDown=
function(a){switch(a.keyCode){case 38:case 87:this.moveForward=!0;break;case 37:case 65:this.moveLeft=!0;break;case 40:case 83:this.moveBackward=!0;break;case 39:case 68:this.moveRight=!0;break;case 82:this.moveUp=!0;break;case 70:this.moveDown=!0;break;case 81:this.freeze=!this.freeze}};this.onKeyUp=function(a){switch(a.keyCode){case 38:case 87:this.moveForward=!1;break;case 37:case 65:this.moveLeft=!1;break;case 40:case 83:this.moveBackward=!1;break;case 39:case 68:this.moveRight=!1;break;case 82:this.moveUp=
!1;break;case 70:this.moveDown=!1}};this.update=function(a){var b=0;if(!this.freeze){this.heightSpeed?(b=THREE.Math.clamp(this.object.position.y,this.heightMin,this.heightMax)-this.heightMin,this.autoSpeedFactor=a*b*this.heightCoef):this.autoSpeedFactor=0;b=a*this.movementSpeed;(this.moveForward||this.autoForward&&!this.moveBackward)&&this.object.translateZ(-(b+this.autoSpeedFactor));this.moveBackward&&this.object.translateZ(b);this.moveLeft&&this.object.translateX(-b);this.moveRight&&this.object.translateX(b);
this.moveUp&&this.object.translateY(b);this.moveDown&&this.object.translateY(-b);a*=this.lookSpeed;this.activeLook||(a=0);this.lon+=this.mouseX*a;this.lookVertical&&(this.lat-=this.mouseY*a);this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*Math.PI/180;this.theta=this.lon*Math.PI/180;var b=this.target,c=this.object.position;b.x=c.x+100*Math.sin(this.phi)*Math.cos(this.theta);b.y=c.y+100*Math.cos(this.phi);b.z=c.z+100*Math.sin(this.phi)*Math.sin(this.theta);b=1;this.constrainVertical&&
(b=Math.PI/(this.verticalMax-this.verticalMin));this.lon+=this.mouseX*a;this.lookVertical&&(this.lat-=this.mouseY*a*b);this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*Math.PI/180;this.theta=this.lon*Math.PI/180;if(this.constrainVertical)this.phi=THREE.Math.mapLinear(this.phi,0,Math.PI,this.verticalMin,this.verticalMax);b=this.target;c=this.object.position;b.x=c.x+100*Math.sin(this.phi)*Math.cos(this.theta);b.y=c.y+100*Math.cos(this.phi);b.z=c.z+100*Math.sin(this.phi)*Math.sin(this.theta);
this.object.lookAt(b)}};this.domElement.addEventListener("contextmenu",function(a){a.preventDefault()},!1);this.domElement.addEventListener("mousemove",c(this,this.onMouseMove),!1);this.domElement.addEventListener("mousedown",c(this,this.onMouseDown),!1);this.domElement.addEventListener("mouseup",c(this,this.onMouseUp),!1);this.domElement.addEventListener("keydown",c(this,this.onKeyDown),!1);this.domElement.addEventListener("keyup",c(this,this.onKeyUp),!1)};
THREE.PathControls=function(a,b){function c(a){return 1>(a*=2)?0.5*a*a:-0.5*(--a*(a-2)-1)}function d(a,b){return function(){b.apply(a,arguments)}}function f(a,b,c,d){var e={name:c,fps:0.6,length:d,hierarchy:[]},f,g=b.getControlPointsArray(),h=b.getLength(),o=g.length,p=0;f=o-1;b={parent:-1,keys:[]};b.keys[0]={time:0,pos:g[0],rot:[0,0,0,1],scl:[1,1,1]};b.keys[f]={time:d,pos:g[f],rot:[0,0,0,1],scl:[1,1,1]};for(f=1;f<o-1;f++)p=d*h.chunks[f]/h.total,b.keys[f]={time:p,pos:g[f]};e.hierarchy[0]=b;THREE.AnimationHandler.add(e);
return new THREE.Animation(a,c,THREE.AnimationHandler.CATMULLROM_FORWARD,!1)}function g(a,b){var c,d,e=new THREE.Geometry;for(c=0;c<a.points.length*b;c++)d=c/(a.points.length*b),d=a.getPoint(d),e.vertices[c]=new THREE.Vertex(new THREE.Vector3(d.x,d.y,d.z));return e}this.object=a;this.domElement=void 0!==b?b:document;this.id="PathControls"+THREE.PathControlsIdCounter++;this.duration=1E4;this.waypoints=[];this.useConstantSpeed=!0;this.resamplingCoef=50;this.debugPath=new THREE.Object3D;this.debugDummy=
new THREE.Object3D;this.animationParent=new THREE.Object3D;this.lookSpeed=0.005;this.lookHorizontal=this.lookVertical=!0;this.verticalAngleMap={srcRange:[0,2*Math.PI],dstRange:[0,2*Math.PI]};this.horizontalAngleMap={srcRange:[0,2*Math.PI],dstRange:[0,2*Math.PI]};this.target=new THREE.Object3D;this.theta=this.phi=this.lon=this.lat=this.mouseY=this.mouseX=0;this.domElement===document?(this.viewHalfX=window.innerWidth/2,this.viewHalfY=window.innerHeight/2):(this.viewHalfX=this.domElement.offsetWidth/
2,this.viewHalfY=this.domElement.offsetHeight/2,this.domElement.setAttribute("tabindex",-1));var e=2*Math.PI,h=Math.PI/180;this.update=function(a){var b;this.lookHorizontal&&(this.lon+=this.mouseX*this.lookSpeed*a);this.lookVertical&&(this.lat-=this.mouseY*this.lookSpeed*a);this.lon=Math.max(0,Math.min(360,this.lon));this.lat=Math.max(-85,Math.min(85,this.lat));this.phi=(90-this.lat)*h;this.theta=this.lon*h;a=this.phi%e;this.phi=0<=a?a:a+e;b=this.verticalAngleMap.srcRange;a=this.verticalAngleMap.dstRange;
b=THREE.Math.mapLinear(this.phi,b[0],b[1],a[0],a[1]);var d=a[1]-a[0];this.phi=c((b-a[0])/d)*d+a[0];b=this.horizontalAngleMap.srcRange;a=this.horizontalAngleMap.dstRange;b=THREE.Math.mapLinear(this.theta,b[0],b[1],a[0],a[1]);d=a[1]-a[0];this.theta=c((b-a[0])/d)*d+a[0];a=this.target.position;a.x=100*Math.sin(this.phi)*Math.cos(this.theta);a.y=100*Math.cos(this.phi);a.z=100*Math.sin(this.phi)*Math.sin(this.theta);this.object.lookAt(this.target.position)};this.onMouseMove=function(a){this.domElement===
document?(this.mouseX=a.pageX-this.viewHalfX,this.mouseY=a.pageY-this.viewHalfY):(this.mouseX=a.pageX-this.domElement.offsetLeft-this.viewHalfX,this.mouseY=a.pageY-this.domElement.offsetTop-this.viewHalfY)};this.init=function(){this.spline=new THREE.Spline;this.spline.initFromArray(this.waypoints);this.useConstantSpeed&&this.spline.reparametrizeByArcLength(this.resamplingCoef);if(this.createDebugDummy){var a=new THREE.MeshLambertMaterial({color:30719}),b=new THREE.MeshLambertMaterial({color:65280}),
c=new THREE.CubeGeometry(10,10,20),e=new THREE.CubeGeometry(2,2,10);this.animationParent=new THREE.Mesh(c,a);a=new THREE.Mesh(e,b);a.position.set(0,10,0);this.animation=f(this.animationParent,this.spline,this.id,this.duration);this.animationParent.add(this.object);this.animationParent.add(this.target);this.animationParent.add(a)}else this.animation=f(this.animationParent,this.spline,this.id,this.duration),this.animationParent.add(this.target),this.animationParent.add(this.object);if(this.createDebugPath){var a=
this.debugPath,b=this.spline,e=g(b,10),c=g(b,10),h=new THREE.LineBasicMaterial({color:16711680,linewidth:3}),e=new THREE.Line(e,h),c=new THREE.ParticleSystem(c,new THREE.ParticleBasicMaterial({color:16755200,size:3}));e.scale.set(1,1,1);a.add(e);c.scale.set(1,1,1);a.add(c);for(var e=new THREE.SphereGeometry(1,16,8),h=new THREE.MeshBasicMaterial({color:65280}),n=0;n<b.points.length;n++)c=new THREE.Mesh(e,h),c.position.copy(b.points[n]),a.add(c)}this.domElement.addEventListener("mousemove",d(this,this.onMouseMove),
!1)}};THREE.PathControlsIdCounter=0;
THREE.FlyControls=function(a,b){function c(a,b){return function(){b.apply(a,arguments)}}this.object=a;this.domElement=void 0!==b?b:document;b&&this.domElement.setAttribute("tabindex",-1);this.movementSpeed=1;this.rollSpeed=0.005;this.autoForward=this.dragToLook=!1;this.object.useQuaternion=!0;this.tmpQuaternion=new THREE.Quaternion;this.mouseStatus=0;this.moveState={up:0,down:0,left:0,right:0,forward:0,back:0,pitchUp:0,pitchDown:0,yawLeft:0,yawRight:0,rollLeft:0,rollRight:0};this.moveVector=new THREE.Vector3(0,
0,0);this.rotationVector=new THREE.Vector3(0,0,0);this.handleEvent=function(a){if("function"==typeof this[a.type])this[a.type](a)};this.keydown=function(a){if(!a.altKey){switch(a.keyCode){case 16:this.movementSpeedMultiplier=0.1;break;case 87:this.moveState.forward=1;break;case 83:this.moveState.back=1;break;case 65:this.moveState.left=1;break;case 68:this.moveState.right=1;break;case 82:this.moveState.up=1;break;case 70:this.moveState.down=1;break;case 38:this.moveState.pitchUp=1;break;case 40:this.moveState.pitchDown=
1;break;case 37:this.moveState.yawLeft=1;break;case 39:this.moveState.yawRight=1;break;case 81:this.moveState.rollLeft=1;break;case 69:this.moveState.rollRight=1}this.updateMovementVector();this.updateRotationVector()}};this.keyup=function(a){switch(a.keyCode){case 16:this.movementSpeedMultiplier=1;break;case 87:this.moveState.forward=0;break;case 83:this.moveState.back=0;break;case 65:this.moveState.left=0;break;case 68:this.moveState.right=0;break;case 82:this.moveState.up=0;break;case 70:this.moveState.down=
0;break;case 38:this.moveState.pitchUp=0;break;case 40:this.moveState.pitchDown=0;break;case 37:this.moveState.yawLeft=0;break;case 39:this.moveState.yawRight=0;break;case 81:this.moveState.rollLeft=0;break;case 69:this.moveState.rollRight=0}this.updateMovementVector();this.updateRotationVector()};this.mousedown=function(a){this.domElement!==document&&this.domElement.focus();a.preventDefault();a.stopPropagation();if(this.dragToLook)this.mouseStatus++;else switch(a.button){case 0:this.object.moveForward=
!0;break;case 2:this.object.moveBackward=!0}};this.mousemove=function(a){if(!this.dragToLook||0<this.mouseStatus){var b=this.getContainerDimensions(),c=b.size[0]/2,e=b.size[1]/2;this.moveState.yawLeft=-(a.pageX-b.offset[0]-c)/c;this.moveState.pitchDown=(a.pageY-b.offset[1]-e)/e;this.updateRotationVector()}};this.mouseup=function(a){a.preventDefault();a.stopPropagation();if(this.dragToLook)this.mouseStatus--,this.moveState.yawLeft=this.moveState.pitchDown=0;else switch(a.button){case 0:this.moveForward=
!1;break;case 2:this.moveBackward=!1}this.updateRotationVector()};this.update=function(a){var b=a*this.movementSpeed,a=a*this.rollSpeed;this.object.translateX(this.moveVector.x*b);this.object.translateY(this.moveVector.y*b);this.object.translateZ(this.moveVector.z*b);this.tmpQuaternion.set(this.rotationVector.x*a,this.rotationVector.y*a,this.rotationVector.z*a,1).normalize();this.object.quaternion.multiplySelf(this.tmpQuaternion);this.object.matrix.setPosition(this.object.position);this.object.matrix.setRotationFromQuaternion(this.object.quaternion);
this.object.matrixWorldNeedsUpdate=!0};this.updateMovementVector=function(){var a=this.moveState.forward||this.autoForward&&!this.moveState.back?1:0;this.moveVector.x=-this.moveState.left+this.moveState.right;this.moveVector.y=-this.moveState.down+this.moveState.up;this.moveVector.z=-a+this.moveState.back};this.updateRotationVector=function(){this.rotationVector.x=-this.moveState.pitchDown+this.moveState.pitchUp;this.rotationVector.y=-this.moveState.yawRight+this.moveState.yawLeft;this.rotationVector.z=
-this.moveState.rollRight+this.moveState.rollLeft};this.getContainerDimensions=function(){return this.domElement!=document?{size:[this.domElement.offsetWidth,this.domElement.offsetHeight],offset:[this.domElement.offsetLeft,this.domElement.offsetTop]}:{size:[window.innerWidth,window.innerHeight],offset:[0,0]}};this.domElement.addEventListener("mousemove",c(this,this.mousemove),!1);this.domElement.addEventListener("mousedown",c(this,this.mousedown),!1);this.domElement.addEventListener("mouseup",c(this,
this.mouseup),!1);this.domElement.addEventListener("keydown",c(this,this.keydown),!1);this.domElement.addEventListener("keyup",c(this,this.keyup),!1);this.updateMovementVector();this.updateRotationVector()};
THREE.RollControls=function(a,b){this.object=a;this.domElement=void 0!==b?b:document;this.mouseLook=!0;this.autoForward=!1;this.rollSpeed=this.movementSpeed=this.lookSpeed=1;this.constrainVertical=[-0.9,0.9];this.object.matrixAutoUpdate=!1;this.forward=new THREE.Vector3(0,0,1);this.roll=0;var c=new THREE.Vector3,d=new THREE.Vector3,f=new THREE.Vector3,g=new THREE.Matrix4,e=!1,h=1,i=0,k=0,j=0,q=0,l=0,n=window.innerWidth/2,r=window.innerHeight/2;this.update=function(a){if(this.mouseLook){var b=a*this.lookSpeed;
this.rotateHorizontally(b*q);this.rotateVertically(b*l)}b=a*this.movementSpeed;this.object.translateZ(-b*(0<i||this.autoForward&&!(0>i)?1:i));this.object.translateX(b*k);this.object.translateY(b*j);e&&(this.roll+=this.rollSpeed*a*h);if(this.forward.y>this.constrainVertical[1])this.forward.y=this.constrainVertical[1],this.forward.normalize();else if(this.forward.y<this.constrainVertical[0])this.forward.y=this.constrainVertical[0],this.forward.normalize();f.copy(this.forward);d.set(0,1,0);c.cross(d,
f).normalize();d.cross(f,c).normalize();this.object.matrix.n11=c.x;this.object.matrix.n12=d.x;this.object.matrix.n13=f.x;this.object.matrix.n21=c.y;this.object.matrix.n22=d.y;this.object.matrix.n23=f.y;this.object.matrix.n31=c.z;this.object.matrix.n32=d.z;this.object.matrix.n33=f.z;g.identity();g.n11=Math.cos(this.roll);g.n12=-Math.sin(this.roll);g.n21=Math.sin(this.roll);g.n22=Math.cos(this.roll);this.object.matrix.multiplySelf(g);this.object.matrixWorldNeedsUpdate=!0;this.object.matrix.n14=this.object.position.x;
this.object.matrix.n24=this.object.position.y;this.object.matrix.n34=this.object.position.z};this.translateX=function(a){this.object.position.x+=this.object.matrix.n11*a;this.object.position.y+=this.object.matrix.n21*a;this.object.position.z+=this.object.matrix.n31*a};this.translateY=function(a){this.object.position.x+=this.object.matrix.n12*a;this.object.position.y+=this.object.matrix.n22*a;this.object.position.z+=this.object.matrix.n32*a};this.translateZ=function(a){this.object.position.x-=this.object.matrix.n13*
a;this.object.position.y-=this.object.matrix.n23*a;this.object.position.z-=this.object.matrix.n33*a};this.rotateHorizontally=function(a){c.set(this.object.matrix.n11,this.object.matrix.n21,this.object.matrix.n31);c.multiplyScalar(a);this.forward.subSelf(c);this.forward.normalize()};this.rotateVertically=function(a){d.set(this.object.matrix.n12,this.object.matrix.n22,this.object.matrix.n32);d.multiplyScalar(a);this.forward.addSelf(d);this.forward.normalize()};this.domElement.addEventListener("contextmenu",
function(a){a.preventDefault()},!1);this.domElement.addEventListener("mousemove",function(a){q=(a.clientX-n)/window.innerWidth;l=(a.clientY-r)/window.innerHeight},!1);this.domElement.addEventListener("mousedown",function(a){a.preventDefault();a.stopPropagation();switch(a.button){case 0:i=1;break;case 2:i=-1}},!1);this.domElement.addEventListener("mouseup",function(a){a.preventDefault();a.stopPropagation();switch(a.button){case 0:i=0;break;case 2:i=0}},!1);this.domElement.addEventListener("keydown",
function(a){switch(a.keyCode){case 38:case 87:i=1;break;case 37:case 65:k=-1;break;case 40:case 83:i=-1;break;case 39:case 68:k=1;break;case 81:e=!0;h=1;break;case 69:e=!0;h=-1;break;case 82:j=1;break;case 70:j=-1}},!1);this.domElement.addEventListener("keyup",function(a){switch(a.keyCode){case 38:case 87:i=0;break;case 37:case 65:k=0;break;case 40:case 83:i=0;break;case 39:case 68:k=0;break;case 81:e=!1;break;case 69:e=!1;break;case 82:j=0;break;case 70:j=0}},!1)};
THREE.TrackballControls=function(a,b){THREE.EventTarget.call(this);var c=this;this.object=a;this.domElement=void 0!==b?b:document;this.enabled=!0;this.screen={width:window.innerWidth,height:window.innerHeight,offsetLeft:0,offsetTop:0};this.radius=(this.screen.width+this.screen.height)/4;this.rotateSpeed=1;this.zoomSpeed=1.2;this.panSpeed=0.3;this.staticMoving=this.noPan=this.noZoom=this.noRotate=!1;this.dynamicDampingFactor=0.2;this.minDistance=0;this.maxDistance=Infinity;this.keys=[65,83,68];this.target=
new THREE.Vector3;var d=new THREE.Vector3,f=!1,g=-1,e=new THREE.Vector3,h=new THREE.Vector3,i=new THREE.Vector3,k=new THREE.Vector2,j=new THREE.Vector2,q=new THREE.Vector2,l=new THREE.Vector2,n={type:"change"};this.handleEvent=function(a){if("function"==typeof this[a.type])this[a.type](a)};this.getMouseOnScreen=function(a,b){return new THREE.Vector2(0.5*((a-c.screen.offsetLeft)/c.radius),0.5*((b-c.screen.offsetTop)/c.radius))};this.getMouseProjectionOnBall=function(a,b){var d=new THREE.Vector3((a-
0.5*c.screen.width-c.screen.offsetLeft)/c.radius,(0.5*c.screen.height+c.screen.offsetTop-b)/c.radius,0),f=d.length();1<f?d.normalize():d.z=Math.sqrt(1-f*f);e.copy(c.object.position).subSelf(c.target);f=c.object.up.clone().setLength(d.y);f.addSelf(c.object.up.clone().crossSelf(e).setLength(d.x));f.addSelf(e.setLength(d.z));return f};this.rotateCamera=function(){var a=Math.acos(h.dot(i)/h.length()/i.length());if(a){var b=(new THREE.Vector3).cross(h,i).normalize(),d=new THREE.Quaternion,a=a*c.rotateSpeed;
d.setFromAxisAngle(b,-a);d.multiplyVector3(e);d.multiplyVector3(c.object.up);d.multiplyVector3(i);c.staticMoving?h=i:(d.setFromAxisAngle(b,a*(c.dynamicDampingFactor-1)),d.multiplyVector3(h))}};this.zoomCamera=function(){var a=1+(j.y-k.y)*c.zoomSpeed;1!==a&&0<a&&(e.multiplyScalar(a),c.staticMoving?k=j:k.y+=(j.y-k.y)*this.dynamicDampingFactor)};this.panCamera=function(){var a=l.clone().subSelf(q);if(a.lengthSq()){a.multiplyScalar(e.length()*c.panSpeed);var b=e.clone().crossSelf(c.object.up).setLength(a.x);
b.addSelf(c.object.up.clone().setLength(a.y));c.object.position.addSelf(b);c.target.addSelf(b);c.staticMoving?q=l:q.addSelf(a.sub(l,q).multiplyScalar(c.dynamicDampingFactor))}};this.checkDistances=function(){if(!c.noZoom||!c.noPan)c.object.position.lengthSq()>c.maxDistance*c.maxDistance&&c.object.position.setLength(c.maxDistance),e.lengthSq()<c.minDistance*c.minDistance&&c.object.position.add(c.target,e.setLength(c.minDistance))};this.update=function(){e.copy(c.object.position).subSelf(c.target);
c.noRotate||c.rotateCamera();c.noZoom||c.zoomCamera();c.noPan||c.panCamera();c.object.position.add(c.target,e);c.checkDistances();c.object.lookAt(c.target);0<d.distanceTo(c.object.position)&&(c.dispatchEvent(n),d.copy(c.object.position))};this.domElement.addEventListener("contextmenu",function(a){a.preventDefault()},!1);this.domElement.addEventListener("mousemove",function(a){c.enabled&&(f&&(h=i=c.getMouseProjectionOnBall(a.clientX,a.clientY),k=j=c.getMouseOnScreen(a.clientX,a.clientY),q=l=c.getMouseOnScreen(a.clientX,
a.clientY),f=!1),-1!==g&&(0===g&&!c.noRotate?i=c.getMouseProjectionOnBall(a.clientX,a.clientY):1===g&&!c.noZoom?j=c.getMouseOnScreen(a.clientX,a.clientY):2===g&&!c.noPan&&(l=c.getMouseOnScreen(a.clientX,a.clientY))))},!1);this.domElement.addEventListener("mousedown",function(a){if(c.enabled&&(a.preventDefault(),a.stopPropagation(),-1===g))g=a.button,0===g&&!c.noRotate?h=i=c.getMouseProjectionOnBall(a.clientX,a.clientY):1===g&&!c.noZoom?k=j=c.getMouseOnScreen(a.clientX,a.clientY):this.noPan||(q=l=
c.getMouseOnScreen(a.clientX,a.clientY))},!1);this.domElement.addEventListener("mouseup",function(a){c.enabled&&(a.preventDefault(),a.stopPropagation(),g=-1)},!1);window.addEventListener("keydown",function(a){c.enabled&&-1===g&&(a.keyCode===c.keys[0]&&!c.noRotate?g=0:a.keyCode===c.keys[1]&&!c.noZoom?g=1:a.keyCode===c.keys[2]&&!c.noPan&&(g=2),-1!==g&&(f=!0))},!1);window.addEventListener("keyup",function(){c.enabled&&-1!==g&&(g=-1)},!1)};
THREE.CubeGeometry=function(a,b,c,d,f,g,e,h){function i(a,b,c,e,h,l,i,j){var m,n=d||1,q=f||1,r=h/2,p=l/2,o=k.vertices.length;if("x"===a&&"y"===b||"y"===a&&"x"===b)m="z";else if("x"===a&&"z"===b||"z"===a&&"x"===b)m="y",q=g||1;else if("z"===a&&"y"===b||"y"===a&&"z"===b)m="x",n=g||1;var s=n+1,t=q+1,B=h/n,M=l/q,L=new THREE.Vector3;L[m]=0<i?1:-1;for(h=0;h<t;h++)for(l=0;l<s;l++){var N=new THREE.Vector3;N[a]=(l*B-r)*c;N[b]=(h*M-p)*e;N[m]=i;k.vertices.push(new THREE.Vertex(N))}for(h=0;h<q;h++)for(l=0;l<n;l++)a=
new THREE.Face4(l+s*h+o,l+s*(h+1)+o,l+1+s*(h+1)+o,l+1+s*h+o),a.normal.copy(L),a.vertexNormals.push(L.clone(),L.clone(),L.clone(),L.clone()),a.materialIndex=j,k.faces.push(a),k.faceVertexUvs[0].push([new THREE.UV(l/n,h/q),new THREE.UV(l/n,(h+1)/q),new THREE.UV((l+1)/n,(h+1)/q),new THREE.UV((l+1)/n,h/q)])}THREE.Geometry.call(this);var k=this,j=a/2,q=b/2,l=c/2,n,r,m,o,p,s;if(void 0!==e){if(e instanceof Array)this.materials=e;else{this.materials=[];for(n=0;6>n;n++)this.materials.push(e)}n=0;o=1;r=2;p=
3;m=4;s=5}else this.materials=[];this.sides={px:!0,nx:!0,py:!0,ny:!0,pz:!0,nz:!0};if(void 0!=h)for(var t in h)void 0!==this.sides[t]&&(this.sides[t]=h[t]);this.sides.px&&i("z","y",-1,-1,c,b,j,n);this.sides.nx&&i("z","y",1,-1,c,b,-j,o);this.sides.py&&i("x","z",1,1,a,c,q,r);this.sides.ny&&i("x","z",1,-1,a,c,-q,p);this.sides.pz&&i("x","y",1,-1,a,b,l,m);this.sides.nz&&i("x","y",-1,-1,a,b,-l,s);this.computeCentroids();this.mergeVertices()};THREE.CubeGeometry.prototype=new THREE.Geometry;
THREE.CubeGeometry.prototype.constructor=THREE.CubeGeometry;
THREE.CylinderGeometry=function(a,b,c,d,f,g){THREE.Geometry.call(this);var a=void 0!==a?a:20,b=void 0!==b?b:20,c=void 0!==c?c:100,e=c/2,d=d||8,f=f||1,h,i,k=[],j=[];for(i=0;i<=f;i++){var q=[],l=[],n=i/f,r=n*(b-a)+a;for(h=0;h<=d;h++){var m=h/d,o=r*Math.sin(2*m*Math.PI),p=-n*c+e,s=r*Math.cos(2*m*Math.PI);this.vertices.push(new THREE.Vertex(new THREE.Vector3(o,p,s)));q.push(this.vertices.length-1);l.push(new THREE.UV(m,n))}k.push(q);j.push(l)}for(i=0;i<f;i++)for(h=0;h<d;h++){var c=k[i][h],q=k[i+1][h],
l=k[i+1][h+1],n=k[i][h+1],r=this.vertices[c].position.clone().setY(0).normalize(),m=this.vertices[q].position.clone().setY(0).normalize(),o=this.vertices[l].position.clone().setY(0).normalize(),p=this.vertices[n].position.clone().setY(0).normalize(),s=j[i][h].clone(),t=j[i+1][h].clone(),v=j[i+1][h+1].clone(),u=j[i][h+1].clone();this.faces.push(new THREE.Face4(c,q,l,n,[r,m,o,p]));this.faceVertexUvs[0].push([s,t,v,u])}if(!g&&0<a){this.vertices.push(new THREE.Vertex(new THREE.Vector3(0,e,0)));for(h=
0;h<d;h++)c=k[0][h],q=k[0][h+1],l=this.vertices.length-1,r=new THREE.Vector3(0,1,0),m=new THREE.Vector3(0,1,0),o=new THREE.Vector3(0,1,0),s=j[0][h].clone(),t=j[0][h+1].clone(),v=new THREE.UV(t.u,0),this.faces.push(new THREE.Face3(c,q,l,[r,m,o])),this.faceVertexUvs[0].push([s,t,v])}if(!g&&0<b){this.vertices.push(new THREE.Vertex(new THREE.Vector3(0,-e,0)));for(h=0;h<d;h++)c=k[i][h+1],q=k[i][h],l=this.vertices.length-1,r=new THREE.Vector3(0,-1,0),m=new THREE.Vector3(0,-1,0),o=new THREE.Vector3(0,-1,
0),s=j[i][h+1].clone(),t=j[i][h].clone(),v=new THREE.UV(t.u,1),this.faces.push(new THREE.Face3(c,q,l,[r,m,o])),this.faceVertexUvs[0].push([s,t,v])}this.computeCentroids();this.computeFaceNormals()};THREE.CylinderGeometry.prototype=new THREE.Geometry;THREE.CylinderGeometry.prototype.constructor=THREE.CylinderGeometry;
THREE.ExtrudeGeometry=function(a,b){if("undefined"!==typeof a){THREE.Geometry.call(this);var a=a instanceof Array?a:[a],c,d,f=a.length;this.shapebb=a[f-1].getBoundingBox();for(d=0;d<f;d++)c=a[d],this.addShape(c,b);this.computeCentroids();this.computeFaceNormals()}};THREE.ExtrudeGeometry.prototype=new THREE.Geometry;THREE.ExtrudeGeometry.prototype.constructor=THREE.ExtrudeGeometry;
THREE.ExtrudeGeometry.prototype.addShape=function(a,b){function c(a,b,c){b||console.log("die");return b.clone().multiplyScalar(c).addSelf(a)}function d(a,b,c){var d=THREE.ExtrudeGeometry.__v1,e=THREE.ExtrudeGeometry.__v2,f=THREE.ExtrudeGeometry.__v3,g=THREE.ExtrudeGeometry.__v4,h=THREE.ExtrudeGeometry.__v5,l=THREE.ExtrudeGeometry.__v6;d.set(a.x-b.x,a.y-b.y);e.set(a.x-c.x,a.y-c.y);d=d.normalize();e=e.normalize();f.set(-d.y,d.x);g.set(e.y,-e.x);h.copy(a).addSelf(f);l.copy(a).addSelf(g);if(h.equals(l))return g.clone();
h.copy(b).addSelf(f);l.copy(c).addSelf(g);f=d.dot(g);g=l.subSelf(h).dot(g);0===f&&(console.log("Either infinite or no solutions!"),0===g?console.log("Its finite solutions."):console.log("Too bad, no solutions."));g/=f;return 0>g?(b=Math.atan2(b.y-a.y,b.x-a.x),a=Math.atan2(c.y-a.y,c.x-a.x),b>a&&(a+=2*Math.PI),c=(b+a)/2,a=-Math.cos(c),c=-Math.sin(c),new THREE.Vector2(a,c)):d.multiplyScalar(g).addSelf(h).subSelf(a).clone()}function f(a){for(y=a.length;0<=--y;){K=y;B=y-1;0>B&&(B=a.length-1);for(var b=
0,c=n+2*j,b=0;b<c;b++){var d=E*b,e=E*(b+1),f=O+K+d,g=O+B+d,h=O+B+e,l=O+K+e,f=f+A,g=g+A,h=h+A,l=l+A;x.faces.push(new THREE.Face4(f,g,h,l,null,null,v));var e=x.vertices[f].position.x,d=x.vertices[f].position.y,f=x.vertices[f].position.z,i=x.vertices[g].position.x,k=x.vertices[g].position.y,g=x.vertices[g].position.z,m=x.vertices[h].position.x,q=x.vertices[h].position.y,h=x.vertices[h].position.z,r=x.vertices[l].position.x,o=x.vertices[l].position.y,l=x.vertices[l].position.z;0.01>Math.abs(d-k)?x.faceVertexUvs[0].push([new THREE.UV(e,
f),new THREE.UV(i,g),new THREE.UV(m,h),new THREE.UV(r,l)]):x.faceVertexUvs[0].push([new THREE.UV(d,f),new THREE.UV(k,g),new THREE.UV(q,h),new THREE.UV(o,l)])}}}function g(a,b,c){x.vertices.push(new THREE.Vertex(new THREE.Vector3(a,b,c)))}function e(a,b,c){a+=A;b+=A;c+=A;x.faces.push(new THREE.Face3(a,b,c,null,null,t));var d=x.vertices[b].position.x,b=x.vertices[b].position.y,e=x.vertices[c].position.x,c=x.vertices[c].position.y;x.faceVertexUvs[0].push([new THREE.UV(x.vertices[a].position.x,1-x.vertices[a].position.y),
new THREE.UV(d,1-b),new THREE.UV(e,1-c)])}var h=void 0!==b.amount?b.amount:100,i=void 0!==b.bevelThickness?b.bevelThickness:6,k=void 0!==b.bevelSize?b.bevelSize:i-2,j=void 0!==b.bevelSegments?b.bevelSegments:3,q=void 0!==b.bevelEnabled?b.bevelEnabled:!0,l=void 0!==b.curveSegments?b.curveSegments:12,n=void 0!==b.steps?b.steps:1,r=b.bendPath,m=b.extrudePath,o,p=!1,s=void 0!==b.useSpacedPoints?b.useSpacedPoints:!1,t=b.material,v=b.extrudeMaterial;if(m)o=m.getPoints(l),n=o.length,p=!0,q=!1;q||(k=i=j=
0);var u,w,z,x=this,A=this.vertices.length;r&&a.addWrapPath(r);l=s?a.extractAllSpacedPoints(l):a.extractAllPoints(l);r=l.shape;l=l.holes;if(m=!THREE.Shape.Utils.isClockWise(r)){r=r.reverse();for(w=0,z=l.length;w<z;w++)u=l[w],THREE.Shape.Utils.isClockWise(u)&&(l[w]=u.reverse());m=!1}m=THREE.Shape.Utils.triangulateShape(r,l);s=r;for(w=0,z=l.length;w<z;w++)u=l[w],r=r.concat(u);for(var D,G,J,F,E=r.length,C=m.length,H=[],y=0,I=s.length,K=I-1,B=y+1;y<I;y++,K++,B++)K===I&&(K=0),B===I&&(B=0),H[y]=d(s[y],
s[K],s[B]);var M=[],L,N=H.concat();for(w=0,z=l.length;w<z;w++){u=l[w];L=[];for(y=0,I=u.length,K=I-1,B=y+1;y<I;y++,K++,B++)K===I&&(K=0),B===I&&(B=0),L[y]=d(u[y],u[K],u[B]);M.push(L);N=N.concat(L)}for(D=0;D<j;D++){G=D/j;J=i*(1-G);G=k*Math.sin(G*Math.PI/2);for(y=0,I=s.length;y<I;y++)F=c(s[y],H[y],G),g(F.x,F.y,-J);for(w=0,z=l.length;w<z;w++){u=l[w];L=M[w];for(y=0,I=u.length;y<I;y++)F=c(u[y],L[y],G),g(F.x,F.y,-J)}}G=k;for(y=0;y<E;y++)F=q?c(r[y],N[y],G):r[y],p?g(F.x,F.y+o[0].y,o[0].x):g(F.x,F.y,0);for(D=
1;D<=n;D++)for(y=0;y<E;y++)F=q?c(r[y],N[y],G):r[y],p?g(F.x,F.y+o[D-1].y,o[D-1].x):g(F.x,F.y,h/n*D);for(D=j-1;0<=D;D--){G=D/j;J=i*(1-G);G=k*Math.sin(G*Math.PI/2);for(y=0,I=s.length;y<I;y++)F=c(s[y],H[y],G),g(F.x,F.y,h+J);for(w=0,z=l.length;w<z;w++){u=l[w];L=M[w];for(y=0,I=u.length;y<I;y++)F=c(u[y],L[y],G),p?g(F.x,F.y+o[n-1].y,o[n-1].x+J):g(F.x,F.y,h+J)}}if(q){i=0*E;for(y=0;y<C;y++)h=m[y],e(h[2]+i,h[1]+i,h[0]+i);i=E*(n+2*j);for(y=0;y<C;y++)h=m[y],e(h[0]+i,h[1]+i,h[2]+i)}else{for(y=0;y<C;y++)h=m[y],
e(h[2],h[1],h[0]);for(y=0;y<C;y++)h=m[y],e(h[0]+E*n,h[1]+E*n,h[2]+E*n)}var O=0;f(s);O+=s.length;for(w=0,z=l.length;w<z;w++)u=l[w],f(u),O+=u.length};THREE.ExtrudeGeometry.__v1=new THREE.Vector2;THREE.ExtrudeGeometry.__v2=new THREE.Vector2;THREE.ExtrudeGeometry.__v3=new THREE.Vector2;THREE.ExtrudeGeometry.__v4=new THREE.Vector2;THREE.ExtrudeGeometry.__v5=new THREE.Vector2;THREE.ExtrudeGeometry.__v6=new THREE.Vector2;
THREE.LatheGeometry=function(a,b,c){THREE.Geometry.call(this);this.steps=b||12;this.angle=c||2*Math.PI;for(var b=this.angle/this.steps,c=[],d=[],f=[],g=[],e=(new THREE.Matrix4).setRotationZ(b),h=0;h<a.length;h++)this.vertices.push(new THREE.Vertex(a[h])),c[h]=a[h].clone(),d[h]=this.vertices.length-1;for(var i=0;i<=this.angle+0.001;i+=b){for(h=0;h<c.length;h++)i<this.angle?(c[h]=e.multiplyVector3(c[h].clone()),this.vertices.push(new THREE.Vertex(c[h])),f[h]=this.vertices.length-1):f=g;0==i&&(g=d);
for(h=0;h<d.length-1;h++)this.faces.push(new THREE.Face4(f[h],f[h+1],d[h+1],d[h])),this.faceVertexUvs[0].push([new THREE.UV(1-i/this.angle,h/a.length),new THREE.UV(1-i/this.angle,(h+1)/a.length),new THREE.UV(1-(i-b)/this.angle,(h+1)/a.length),new THREE.UV(1-(i-b)/this.angle,h/a.length)]);d=f;f=[]}this.computeCentroids();this.computeFaceNormals();this.computeVertexNormals()};THREE.LatheGeometry.prototype=new THREE.Geometry;THREE.LatheGeometry.prototype.constructor=THREE.LatheGeometry;
THREE.PlaneGeometry=function(a,b,c,d){THREE.Geometry.call(this);for(var f=a/2,g=b/2,c=c||1,d=d||1,e=c+1,h=d+1,i=a/c,k=b/d,j=new THREE.Vector3(0,0,1),a=0;a<h;a++)for(b=0;b<e;b++)this.vertices.push(new THREE.Vertex(new THREE.Vector3(b*i-f,-(a*k-g),0)));for(a=0;a<d;a++)for(b=0;b<c;b++)f=new THREE.Face4(b+e*a,b+e*(a+1),b+1+e*(a+1),b+1+e*a),f.normal.copy(j),f.vertexNormals.push(j.clone(),j.clone(),j.clone(),j.clone()),this.faces.push(f),this.faceVertexUvs[0].push([new THREE.UV(b/c,a/d),new THREE.UV(b/
c,(a+1)/d),new THREE.UV((b+1)/c,(a+1)/d),new THREE.UV((b+1)/c,a/d)]);this.computeCentroids()};THREE.PlaneGeometry.prototype=new THREE.Geometry;THREE.PlaneGeometry.prototype.constructor=THREE.PlaneGeometry;
THREE.SphereGeometry=function(a,b,c,d,f,g,e){THREE.Geometry.call(this);var a=a||50,d=void 0!==d?d:0,f=void 0!==f?f:2*Math.PI,g=void 0!==g?g:0,e=void 0!==e?e:Math.PI,b=Math.max(3,Math.floor(b)||8),c=Math.max(2,Math.floor(c)||6),h,i,k=[],j=[];for(i=0;i<=c;i++){var q=[],l=[];for(h=0;h<=b;h++){var n=h/b,r=i/c,m=-a*Math.cos(d+n*f)*Math.sin(g+r*e),o=a*Math.cos(g+r*e),p=a*Math.sin(d+n*f)*Math.sin(g+r*e);this.vertices.push(new THREE.Vertex(new THREE.Vector3(m,o,p)));q.push(this.vertices.length-1);l.push(new THREE.UV(n,
r))}k.push(q);j.push(l)}for(i=0;i<c;i++)for(h=0;h<b;h++){var d=k[i][h+1],f=k[i][h],g=k[i+1][h],e=k[i+1][h+1],q=this.vertices[d].position.clone().normalize(),l=this.vertices[f].position.clone().normalize(),n=this.vertices[g].position.clone().normalize(),r=this.vertices[e].position.clone().normalize(),m=j[i][h+1].clone(),o=j[i][h].clone(),p=j[i+1][h].clone(),s=j[i+1][h+1].clone();Math.abs(this.vertices[d].position.y)==a?(this.faces.push(new THREE.Face3(d,g,e,[q,n,r])),this.faceVertexUvs[0].push([m,
p,s])):Math.abs(this.vertices[g].position.y)==a?(this.faces.push(new THREE.Face3(d,f,g,[q,l,n])),this.faceVertexUvs[0].push([m,o,p])):(this.faces.push(new THREE.Face4(d,f,g,e,[q,l,n,r])),this.faceVertexUvs[0].push([m,o,p,s]))}this.computeCentroids();this.computeFaceNormals();this.boundingSphere={radius:a}};THREE.SphereGeometry.prototype=new THREE.Geometry;THREE.SphereGeometry.prototype.constructor=THREE.SphereGeometry;
THREE.TextGeometry=function(a,b){var c=(new THREE.TextPath(a,b)).toShapes();b.amount=void 0!==b.height?b.height:50;if(void 0===b.bevelThickness)b.bevelThickness=10;if(void 0===b.bevelSize)b.bevelSize=8;if(void 0===b.bevelEnabled)b.bevelEnabled=!1;if(b.bend){var d=c[c.length-1].getBoundingBox().maxX;b.bendPath=new THREE.QuadraticBezierCurve(new THREE.Vector2(0,0),new THREE.Vector2(d/2,120),new THREE.Vector2(d,0))}THREE.ExtrudeGeometry.call(this,c,b)};THREE.TextGeometry.prototype=new THREE.ExtrudeGeometry;
THREE.TextGeometry.prototype.constructor=THREE.TextGeometry;
THREE.FontUtils={faces:{},face:"helvetiker",weight:"normal",style:"normal",size:150,divisions:10,getFace:function(){return this.faces[this.face][this.weight][this.style]},loadFace:function(a){var b=a.familyName.toLowerCase();this.faces[b]=this.faces[b]||{};this.faces[b][a.cssFontWeight]=this.faces[b][a.cssFontWeight]||{};this.faces[b][a.cssFontWeight][a.cssFontStyle]=a;return this.faces[b][a.cssFontWeight][a.cssFontStyle]=a},drawText:function(a){for(var b=this.getFace(),c=this.size/b.resolution,d=
0,f=(""+a).split(""),g=f.length,e=[],a=0;a<g;a++){var h=new THREE.Path,h=this.extractGlyphPoints(f[a],b,c,d,h),d=d+h.offset;e.push(h.path)}return{paths:e,offset:d/2}},extractGlyphPoints:function(a,b,c,d,f){var g=[],e,h,i,k,j,q,l,n,r,m,o,p=b.glyphs[a]||b.glyphs["?"];if(p){if(p.o){b=p._cachedOutline||(p._cachedOutline=p.o.split(" "));k=b.length;for(a=0;a<k;)switch(i=b[a++],i){case "m":i=b[a++]*c+d;j=b[a++]*c;g.push(new THREE.Vector2(i,j));f.moveTo(i,j);break;case "l":i=b[a++]*c+d;j=b[a++]*c;g.push(new THREE.Vector2(i,
j));f.lineTo(i,j);break;case "q":i=b[a++]*c+d;j=b[a++]*c;n=b[a++]*c+d;r=b[a++]*c;f.quadraticCurveTo(n,r,i,j);if(e=g[g.length-1]){q=e.x;l=e.y;for(e=1,h=this.divisions;e<=h;e++){var s=e/h,t=THREE.Shape.Utils.b2(s,q,n,i),s=THREE.Shape.Utils.b2(s,l,r,j);g.push(new THREE.Vector2(t,s))}}break;case "b":if(i=b[a++]*c+d,j=b[a++]*c,n=b[a++]*c+d,r=b[a++]*-c,m=b[a++]*c+d,o=b[a++]*-c,f.bezierCurveTo(i,j,n,r,m,o),e=g[g.length-1]){q=e.x;l=e.y;for(e=1,h=this.divisions;e<=h;e++)s=e/h,t=THREE.Shape.Utils.b3(s,q,n,
m,i),s=THREE.Shape.Utils.b3(s,l,r,o,j),g.push(new THREE.Vector2(t,s))}}}return{offset:p.ha*c,points:g,path:f}}}};
(function(a){var b=function(a){for(var b=a.length,f=0,g=b-1,e=0;e<b;g=e++)f+=a[g].x*a[e].y-a[e].x*a[g].y;return 0.5*f};a.Triangulate=function(a,d){var f=a.length;if(3>f)return null;var g=[],e=[],h=[],i,k,j;if(0<b(a))for(k=0;k<f;k++)e[k]=k;else for(k=0;k<f;k++)e[k]=f-1-k;var q=2*f;for(k=f-1;2<f;){if(0>=q--){console.log("Warning, unable to triangulate polygon!");break}i=k;f<=i&&(i=0);k=i+1;f<=k&&(k=0);j=k+1;f<=j&&(j=0);var l;a:{l=a;var n=i,r=k,m=j,o=f,p=e,s=void 0,t=void 0,v=void 0,u=void 0,w=void 0,
z=void 0,x=void 0,A=void 0,D=void 0,t=l[p[n]].x,v=l[p[n]].y,u=l[p[r]].x,w=l[p[r]].y,z=l[p[m]].x,x=l[p[m]].y;if(1.0E-10>(u-t)*(x-v)-(w-v)*(z-t))l=!1;else{for(s=0;s<o;s++)if(!(s==n||s==r||s==m)){var A=l[p[s]].x,D=l[p[s]].y,G=void 0,J=void 0,F=void 0,E=void 0,C=void 0,H=void 0,y=void 0,I=void 0,K=void 0,B=void 0,M=void 0,L=void 0,G=F=C=void 0,G=z-u,J=x-w,F=t-z,E=v-x,C=u-t,H=w-v,y=A-t,I=D-v,K=A-u,B=D-w,M=A-z,L=D-x,G=G*B-J*K,C=C*I-H*y,F=F*L-E*M;if(0<=G&&0<=F&&0<=C){l=!1;break a}}l=!0}}if(l){g.push([a[e[i]],
a[e[k]],a[e[j]]]);h.push([e[i],e[k],e[j]]);for(i=k,j=k+1;j<f;i++,j++)e[i]=e[j];f--;q=2*f}}return d?h:g};a.Triangulate.area=b;return a})(THREE.FontUtils);self._typeface_js={faces:THREE.FontUtils.faces,loadFace:THREE.FontUtils.loadFace};
THREE.TorusGeometry=function(a,b,c,d,f){THREE.Geometry.call(this);this.radius=a||100;this.tube=b||40;this.segmentsR=c||8;this.segmentsT=d||6;this.arc=f||2*Math.PI;f=new THREE.Vector3;a=[];b=[];for(c=0;c<=this.segmentsR;c++)for(d=0;d<=this.segmentsT;d++){var g=d/this.segmentsT*this.arc,e=2*c/this.segmentsR*Math.PI;f.x=this.radius*Math.cos(g);f.y=this.radius*Math.sin(g);var h=new THREE.Vector3;h.x=(this.radius+this.tube*Math.cos(e))*Math.cos(g);h.y=(this.radius+this.tube*Math.cos(e))*Math.sin(g);h.z=
this.tube*Math.sin(e);this.vertices.push(new THREE.Vertex(h));a.push(new THREE.UV(d/this.segmentsT,1-c/this.segmentsR));b.push(h.clone().subSelf(f).normalize())}for(c=1;c<=this.segmentsR;c++)for(d=1;d<=this.segmentsT;d++){var f=(this.segmentsT+1)*c+d-1,g=(this.segmentsT+1)*(c-1)+d-1,e=(this.segmentsT+1)*(c-1)+d,h=(this.segmentsT+1)*c+d,i=new THREE.Face4(f,g,e,h,[b[f],b[g],b[e],b[h]]);i.normal.addSelf(b[f]);i.normal.addSelf(b[g]);i.normal.addSelf(b[e]);i.normal.addSelf(b[h]);i.normal.normalize();this.faces.push(i);
this.faceVertexUvs[0].push([a[f].clone(),a[g].clone(),a[e].clone(),a[h].clone()])}this.computeCentroids()};THREE.TorusGeometry.prototype=new THREE.Geometry;THREE.TorusGeometry.prototype.constructor=THREE.TorusGeometry;
THREE.TorusKnotGeometry=function(a,b,c,d,f,g,e){function h(a,b,c,d,e,f){var g=Math.cos(a);Math.cos(b);b=Math.sin(a);a*=c/d;c=Math.cos(a);g*=0.5*e*(2+c);b=0.5*e*(2+c)*b;e=0.5*f*e*Math.sin(a);return new THREE.Vector3(g,b,e)}THREE.Geometry.call(this);this.radius=a||200;this.tube=b||40;this.segmentsR=c||64;this.segmentsT=d||8;this.p=f||2;this.q=g||3;this.heightScale=e||1;this.grid=Array(this.segmentsR);c=new THREE.Vector3;d=new THREE.Vector3;f=new THREE.Vector3;for(a=0;a<this.segmentsR;++a){this.grid[a]=
Array(this.segmentsT);for(b=0;b<this.segmentsT;++b){var i=2*(a/this.segmentsR)*this.p*Math.PI,e=2*(b/this.segmentsT)*Math.PI,g=h(i,e,this.q,this.p,this.radius,this.heightScale),i=h(i+0.01,e,this.q,this.p,this.radius,this.heightScale);c.sub(i,g);d.add(i,g);f.cross(c,d);d.cross(f,c);f.normalize();d.normalize();i=-this.tube*Math.cos(e);e=this.tube*Math.sin(e);g.x+=i*d.x+e*f.x;g.y+=i*d.y+e*f.y;g.z+=i*d.z+e*f.z;this.grid[a][b]=this.vertices.push(new THREE.Vertex(new THREE.Vector3(g.x,g.y,g.z)))-1}}for(a=
0;a<this.segmentsR;++a)for(b=0;b<this.segmentsT;++b){var f=(a+1)%this.segmentsR,g=(b+1)%this.segmentsT,c=this.grid[a][b],d=this.grid[f][b],f=this.grid[f][g],g=this.grid[a][g],e=new THREE.UV(a/this.segmentsR,b/this.segmentsT),i=new THREE.UV((a+1)/this.segmentsR,b/this.segmentsT),k=new THREE.UV((a+1)/this.segmentsR,(b+1)/this.segmentsT),j=new THREE.UV(a/this.segmentsR,(b+1)/this.segmentsT);this.faces.push(new THREE.Face4(c,d,f,g));this.faceVertexUvs[0].push([e,i,k,j])}this.computeCentroids();this.computeFaceNormals();
this.computeVertexNormals()};THREE.TorusKnotGeometry.prototype=new THREE.Geometry;THREE.TorusKnotGeometry.prototype.constructor=THREE.TorusKnotGeometry;
THREE.PolyhedronGeometry=function(a,b,c,d){function f(a){var b=new THREE.Vertex(a.normalize());b.index=i.vertices.push(b)-1;var c=Math.atan2(a.z,-a.x)/2/Math.PI+0.5,a=Math.atan2(-a.y,Math.sqrt(a.x*a.x+a.z*a.z))/Math.PI+0.5;b.uv=new THREE.UV(c,a);return b}function g(a,b,c,d){1>d?(d=new THREE.Face3(a.index,b.index,c.index,[a.position.clone(),b.position.clone(),c.position.clone()]),d.centroid.addSelf(a.position).addSelf(b.position).addSelf(c.position).divideScalar(3),d.normal=d.centroid.clone().normalize(),
i.faces.push(d),d=Math.atan2(d.centroid.z,-d.centroid.x),i.faceVertexUvs[0].push([h(a.uv,a.position,d),h(b.uv,b.position,d),h(c.uv,c.position,d)])):(d-=1,g(a,e(a,b),e(a,c),d),g(e(a,b),b,e(b,c),d),g(e(a,c),e(b,c),c,d),g(e(a,b),e(b,c),e(a,c),d))}function e(a,b){q[a.index]||(q[a.index]=[]);q[b.index]||(q[b.index]=[]);var c=q[a.index][b.index];void 0===c&&(q[a.index][b.index]=q[b.index][a.index]=c=f((new THREE.Vector3).add(a.position,b.position).divideScalar(2)));return c}function h(a,b,c){0>c&&1===a.u&&
(a=new THREE.UV(a.u-1,a.v));0===b.x&&0===b.z&&(a=new THREE.UV(c/2/Math.PI+0.5,a.v));return a}THREE.Geometry.call(this);for(var c=c||1,d=d||0,i=this,k=0,j=a.length;k<j;k++)f(new THREE.Vector3(a[k][0],a[k][1],a[k][2]));for(var q=[],a=this.vertices,k=0,j=b.length;k<j;k++)g(a[b[k][0]],a[b[k][1]],a[b[k][2]],d);this.mergeVertices();k=0;for(j=this.vertices.length;k<j;k++)this.vertices[k].position.multiplyScalar(c);this.boundingSphere={radius:c}};THREE.PolyhedronGeometry.prototype=new THREE.Geometry;
THREE.PolyhedronGeometry.prototype.constructor=THREE.PolyhedronGeometry;THREE.IcosahedronGeometry=function(a,b){var c=(1+Math.sqrt(5))/2;THREE.PolyhedronGeometry.call(this,[[-1,c,0],[1,c,0],[-1,-c,0],[1,-c,0],[0,-1,c],[0,1,c],[0,-1,-c],[0,1,-c],[c,0,-1],[c,0,1],[-c,0,-1],[-c,0,1]],[[0,11,5],[0,5,1],[0,1,7],[0,7,10],[0,10,11],[1,5,9],[5,11,4],[11,10,2],[10,7,6],[7,1,8],[3,9,4],[3,4,2],[3,2,6],[3,6,8],[3,8,9],[4,9,5],[2,4,11],[6,2,10],[8,6,7],[9,8,1]],a,b)};THREE.IcosahedronGeometry.prototype=new THREE.Geometry;
THREE.IcosahedronGeometry.prototype.constructor=THREE.IcosahedronGeometry;THREE.OctahedronGeometry=function(a,b){THREE.PolyhedronGeometry.call(this,[[1,0,0],[-1,0,0],[0,1,0],[0,-1,0],[0,0,1],[0,0,-1]],[[0,2,4],[0,4,3],[0,3,5],[0,5,2],[1,2,5],[1,5,3],[1,3,4],[1,4,2]],a,b)};THREE.OctahedronGeometry.prototype=new THREE.Geometry;THREE.OctahedronGeometry.prototype.constructor=THREE.OctahedronGeometry;
THREE.TetrahedronGeometry=function(a,b){THREE.PolyhedronGeometry.call(this,[[1,1,1],[-1,-1,1],[-1,1,-1],[1,-1,-1]],[[2,1,0],[0,3,2],[1,3,0],[2,3,1]],a,b)};THREE.TetrahedronGeometry.prototype=new THREE.Geometry;THREE.TetrahedronGeometry.prototype.constructor=THREE.TetrahedronGeometry;
THREE.AxisHelper=function(){THREE.Object3D.call(this);var a=new THREE.Geometry;a.vertices.push(new THREE.Vertex);a.vertices.push(new THREE.Vertex(new THREE.Vector3(0,100,0)));var b=new THREE.CylinderGeometry(0,5,25,5,1),c;c=new THREE.Line(a,new THREE.LineBasicMaterial({color:16711680}));c.rotation.z=-Math.PI/2;this.add(c);c=new THREE.Mesh(b,new THREE.MeshBasicMaterial({color:16711680}));c.position.x=100;c.rotation.z=-Math.PI/2;this.add(c);c=new THREE.Line(a,new THREE.LineBasicMaterial({color:65280}));
this.add(c);c=new THREE.Mesh(b,new THREE.MeshBasicMaterial({color:65280}));c.position.y=100;this.add(c);c=new THREE.Line(a,new THREE.LineBasicMaterial({color:255}));c.rotation.x=Math.PI/2;this.add(c);c=new THREE.Mesh(b,new THREE.MeshBasicMaterial({color:255}));c.position.z=100;c.rotation.x=Math.PI/2;this.add(c)};THREE.AxisHelper.prototype=new THREE.Object3D;THREE.AxisHelper.prototype.constructor=THREE.AxisHelper;
THREE.CameraHelper=function(a){function b(a,b,d){c(a,d);c(b,d)}function c(a,b){d.lineGeometry.vertices.push(new THREE.Vertex(new THREE.Vector3));d.lineGeometry.colors.push(new THREE.Color(b));void 0===d.pointMap[a]&&(d.pointMap[a]=[]);d.pointMap[a].push(d.lineGeometry.vertices.length-1)}THREE.Object3D.call(this);var d=this;this.lineGeometry=new THREE.Geometry;this.lineMaterial=new THREE.LineBasicMaterial({color:16777215,vertexColors:THREE.FaceColors});this.pointMap={};b("n1","n2",16755200);b("n2",
"n4",16755200);b("n4","n3",16755200);b("n3","n1",16755200);b("f1","f2",16755200);b("f2","f4",16755200);b("f4","f3",16755200);b("f3","f1",16755200);b("n1","f1",16755200);b("n2","f2",16755200);b("n3","f3",16755200);b("n4","f4",16755200);b("p","n1",16711680);b("p","n2",16711680);b("p","n3",16711680);b("p","n4",16711680);b("u1","u2",43775);b("u2","u3",43775);b("u3","u1",43775);b("c","t",16777215);b("p","c",3355443);b("cn1","cn2",3355443);b("cn3","cn4",3355443);b("cf1","cf2",3355443);b("cf3","cf4",3355443);
this.update(a);this.lines=new THREE.Line(this.lineGeometry,this.lineMaterial,THREE.LinePieces);this.add(this.lines)};THREE.CameraHelper.prototype=new THREE.Object3D;THREE.CameraHelper.prototype.constructor=THREE.CameraHelper;
THREE.CameraHelper.prototype.update=function(a){function b(a,b,g,e){THREE.CameraHelper.__v.set(b,g,e);THREE.CameraHelper.__projector.unprojectVector(THREE.CameraHelper.__v,THREE.CameraHelper.__c);a=c.pointMap[a];if(void 0!==a){b=0;for(g=a.length;b<g;b++)c.lineGeometry.vertices[a[b]].position.copy(THREE.CameraHelper.__v)}}var c=this;THREE.CameraHelper.__c.projectionMatrix.copy(a.projectionMatrix);b("c",0,0,-1);b("t",0,0,1);b("n1",-1,-1,-1);b("n2",1,-1,-1);b("n3",-1,1,-1);b("n4",1,1,-1);b("f1",-1,-1,
1);b("f2",1,-1,1);b("f3",-1,1,1);b("f4",1,1,1);b("u1",0.7,1.1,-1);b("u2",-0.7,1.1,-1);b("u3",0,2,-1);b("cf1",-1,0,1);b("cf2",1,0,1);b("cf3",0,-1,1);b("cf4",0,1,1);b("cn1",-1,0,-1);b("cn2",1,0,-1);b("cn3",0,-1,-1);b("cn4",0,1,-1);this.lineGeometry.__dirtyVertices=!0};THREE.CameraHelper.__projector=new THREE.Projector;THREE.CameraHelper.__v=new THREE.Vector3;THREE.CameraHelper.__c=new THREE.Camera;
THREE.SubdivisionModifier=function(a){this.subdivisions=void 0===a?1:a;this.useOldVertexColors=!1;this.supportUVs=!0};THREE.SubdivisionModifier.prototype.constructor=THREE.SubdivisionModifier;THREE.SubdivisionModifier.prototype.modify=function(a){for(var b=this.subdivisions;0<b--;)this.smooth(a)};
THREE.SubdivisionModifier.prototype.smooth=function(a){function b(a,b,c,d,h,i){var j=new THREE.Face4(a,b,c,d,null,h.color,h.material);if(e.useOldVertexColors){j.vertexColors=[];for(var k,m,n,q=0;4>q;q++){n=i[q];k=new THREE.Color;k.setRGB(0,0,0);for(var o=0;o<n.length;o++)m=h.vertexColors[n[o]-1],k.r+=m.r,k.g+=m.g,k.b+=m.b;k.r/=n.length;k.g/=n.length;k.b/=n.length;j.vertexColors[q]=k}}f.push(j);(!e.supportUVs||0!=l.length)&&g.push([l[a],l[b],l[c],l[d]])}function c(a,b){return Math.min(a,b)+"_"+Math.max(a,
b)}var d=[],f=[],g=[],e=this,h=a.vertices,d=a.faces,i=h.concat(),k=[],j={},q={},l=[],n,r,m,o,p,s=a.faceVertexUvs[0];for(n=0,r=s.length;n<r;n++)for(m=0,o=s[n].length;m<o;m++)p=d[n]["abcd".charAt(m)],l[p]||(l[p]=s[n][m]);var t;for(n=0,r=d.length;n<r;n++)if(p=d[n],k.push(p.centroid),i.push(new THREE.Vertex(p.centroid)),e.supportUVs&&0!=l.length){t=new THREE.UV;if(p instanceof THREE.Face3)t.u=l[p.a].u+l[p.b].u+l[p.c].u,t.v=l[p.a].v+l[p.b].v+l[p.c].v,t.u/=3,t.v/=3;else if(p instanceof THREE.Face4)t.u=
l[p.a].u+l[p.b].u+l[p.c].u+l[p.d].u,t.v=l[p.a].v+l[p.b].v+l[p.c].v+l[p.d].v,t.u/=4,t.v/=4;l.push(t)}r=function(a){function b(a,c,d){void 0===a[c]&&(a[c]=[]);a[c].push(d)}var d,e,g,f,h={};for(d=0,e=a.faces.length;d<e;d++)g=a.faces[d],g instanceof THREE.Face3?(f=c(g.a,g.b),b(h,f,d),f=c(g.b,g.c),b(h,f,d),f=c(g.c,g.a),b(h,f,d)):g instanceof THREE.Face4&&(f=c(g.a,g.b),b(h,f,d),f=c(g.b,g.c),b(h,f,d),f=c(g.c,g.d),b(h,f,d),f=c(g.d,g.a),b(h,f,d));return h}(a);var v=0,s=h.length,u,w,z={},x={},A=function(a,
b){void 0===z[a]&&(z[a]=[]);z[a].push(b)},D=function(a,b){void 0===x[a]&&(x[a]={});x[a][b]=null};for(n in r){t=r[n];u=n.split("_");w=u[0];u=u[1];A(w,[w,u]);A(u,[w,u]);for(m=0,o=t.length;m<o;m++)p=t[m],D(w,p,n),D(u,p,n);2>t.length&&(q[n]=!0)}for(n in r)if(t=r[n],p=t[0],t=t[1],u=n.split("_"),w=u[0],u=u[1],o=new THREE.Vector3,q[n]?(o.addSelf(h[w].position),o.addSelf(h[u].position),o.multiplyScalar(0.5)):(o.addSelf(k[p]),o.addSelf(k[t]),o.addSelf(h[w].position),o.addSelf(h[u].position),o.multiplyScalar(0.25)),
j[n]=s+d.length+v,i.push(new THREE.Vertex(o)),v++,e.supportUVs&&0!=l.length)t=new THREE.UV,t.u=l[w].u+l[u].u,t.v=l[w].v+l[u].v,t.u/=2,t.v/=2,l.push(t);var G,J;u=["123","12","2","23"];o=["123","23","3","31"];var A=["123","31","1","12"],D=["1234","12","2","23"],F=["1234","23","3","34"],E=["1234","34","4","41"],C=["1234","41","1","12"];for(n=0,r=k.length;n<r;n++)p=d[n],t=s+n,p instanceof THREE.Face3?(v=c(p.a,p.b),w=c(p.b,p.c),G=c(p.c,p.a),b(t,j[v],p.b,j[w],p,u),b(t,j[w],p.c,j[G],p,o),b(t,j[G],p.a,j[v],
p,A)):p instanceof THREE.Face4?(v=c(p.a,p.b),w=c(p.b,p.c),G=c(p.c,p.d),J=c(p.d,p.a),b(t,j[v],p.b,j[w],p,D),b(t,j[w],p.c,j[G],p,F),b(t,j[G],p.d,j[J],p,E),b(t,j[J],p.a,j[v],p,C)):console.log("face should be a face!",p);d=i;i=new THREE.Vector3;j=new THREE.Vector3;for(n=0,r=h.length;n<r;n++)if(void 0!==z[n]){i.set(0,0,0);j.set(0,0,0);p=new THREE.Vector3(0,0,0);t=0;for(m in x[n])i.addSelf(k[m]),t++;v=0;s=z[n].length;for(m=0;m<s;m++)q[c(z[n][m][0],z[n][m][1])]&&v++;if(2!=v){i.divideScalar(t);for(m=0;m<
s;m++)t=z[n][m],t=h[t[0]].position.clone().addSelf(h[t[1]].position).divideScalar(2),j.addSelf(t);j.divideScalar(s);p.addSelf(h[n].position);p.multiplyScalar(s-3);p.addSelf(i);p.addSelf(j.multiplyScalar(2));p.divideScalar(s);d[n].position=p}}a.vertices=d;a.faces=f;a.faceVertexUvs[0]=g;delete a.__tmpVertices;a.computeCentroids();a.computeFaceNormals();a.computeVertexNormals()};
THREE.Loader=function(a){this.statusDomElement=(this.showStatus=a)?THREE.Loader.prototype.addStatusElement():null;this.onLoadStart=function(){};this.onLoadProgress=function(){};this.onLoadComplete=function(){}};
THREE.Loader.prototype={constructor:THREE.Loader,crossOrigin:"anonymous",addStatusElement:function(){var a=document.createElement("div");a.style.position="absolute";a.style.right="0px";a.style.top="0px";a.style.fontSize="0.8em";a.style.textAlign="left";a.style.background="rgba(0,0,0,0.25)";a.style.color="#fff";a.style.width="120px";a.style.padding="0.5em 0.5em 0.5em 0.5em";a.style.zIndex=1E3;a.innerHTML="Loading ...";return a},updateProgress:function(a){var b="Loaded ",b=a.total?b+((100*a.loaded/
a.total).toFixed(0)+"%"):b+((a.loaded/1E3).toFixed(2)+" KB");this.statusDomElement.innerHTML=b},extractUrlBase:function(a){a=a.split("/");a.pop();return(1>a.length?".":a.join("/"))+"/"},initMaterials:function(a,b,c){a.materials=[];for(var d=0;d<b.length;++d)a.materials[d]=THREE.Loader.prototype.createMaterial(b[d],c)},hasNormals:function(a){var b,c,d=a.materials.length;for(c=0;c<d;c++)if(b=a.materials[c],b instanceof THREE.ShaderMaterial)return!0;return!1},createMaterial:function(a,b){function c(a){a=
Math.log(a)/Math.LN2;return Math.floor(a)==a}function d(a){a=Math.log(a)/Math.LN2;return Math.pow(2,Math.round(a))}function f(a,b){var e=new Image;e.onload=function(){if(!c(this.width)||!c(this.height)){var b=d(this.width),e=d(this.height);a.image.width=b;a.image.height=e;a.image.getContext("2d").drawImage(this,0,0,b,e)}else a.image=this;a.needsUpdate=!0};e.crossOrigin=h.crossOrigin;e.src=b}function g(a,c,d,e,g,h){var i=document.createElement("canvas");a[c]=new THREE.Texture(i);a[c].sourceFile=d;
if(e){a[c].repeat.set(e[0],e[1]);if(1!=e[0])a[c].wrapS=THREE.RepeatWrapping;if(1!=e[1])a[c].wrapT=THREE.RepeatWrapping}g&&a[c].offset.set(g[0],g[1]);if(h){e={repeat:THREE.RepeatWrapping,mirror:THREE.MirroredRepeatWrapping};if(void 0!==e[h[0]])a[c].wrapS=e[h[0]];if(void 0!==e[h[1]])a[c].wrapT=e[h[1]]}f(a[c],b+"/"+d)}function e(a){return(255*a[0]<<16)+(255*a[1]<<8)+255*a[2]}var h=this,i="MeshLambertMaterial",k={color:15658734,opacity:1,map:null,lightMap:null,normalMap:null,wireframe:a.wireframe};a.shading&&
("Phong"==a.shading?i="MeshPhongMaterial":"Basic"==a.shading&&(i="MeshBasicMaterial"));if(a.blending)if("Additive"==a.blending)k.blending=THREE.AdditiveBlending;else if("Subtractive"==a.blending)k.blending=THREE.SubtractiveBlending;else if("Multiply"==a.blending)k.blending=THREE.MultiplyBlending;if(void 0!==a.transparent||1>a.opacity)k.transparent=a.transparent;if(void 0!==a.depthTest)k.depthTest=a.depthTest;if(void 0!==a.vertexColors)if("face"==a.vertexColors)k.vertexColors=THREE.FaceColors;else if(a.vertexColors)k.vertexColors=
THREE.VertexColors;if(a.colorDiffuse)k.color=e(a.colorDiffuse);else if(a.DbgColor)k.color=a.DbgColor;if(a.colorSpecular)k.specular=e(a.colorSpecular);if(a.colorAmbient)k.ambient=e(a.colorAmbient);if(a.transparency)k.opacity=a.transparency;if(a.specularCoef)k.shininess=a.specularCoef;a.mapDiffuse&&b&&g(k,"map",a.mapDiffuse,a.mapDiffuseRepeat,a.mapDiffuseOffset,a.mapDiffuseWrap);a.mapLight&&b&&g(k,"lightMap",a.mapLight,a.mapLightRepeat,a.mapLightOffset,a.mapLightWrap);a.mapNormal&&b&&g(k,"normalMap",
a.mapNormal,a.mapNormalRepeat,a.mapNormalOffset,a.mapNormalWrap);a.mapSpecular&&b&&g(k,"specularMap",a.mapSpecular,a.mapSpecularRepeat,a.mapSpecularOffset,a.mapSpecularWrap);if(a.mapNormal){var i=THREE.ShaderUtils.lib.normal,j=THREE.UniformsUtils.clone(i.uniforms);j.tNormal.texture=k.normalMap;if(a.mapNormalFactor)j.uNormalScale.value=a.mapNormalFactor;if(k.map)j.tDiffuse.texture=k.map,j.enableDiffuse.value=!0;if(k.specularMap)j.tSpecular.texture=k.specularMap,j.enableSpecular.value=!0;if(k.lightMap)j.tAO.texture=
k.lightMap,j.enableAO.value=!0;j.uDiffuseColor.value.setHex(k.color);j.uSpecularColor.value.setHex(k.specular);j.uAmbientColor.value.setHex(k.ambient);j.uShininess.value=k.shininess;if(void 0!==k.opacity)j.uOpacity.value=k.opacity;k=new THREE.ShaderMaterial({fragmentShader:i.fragmentShader,vertexShader:i.vertexShader,uniforms:j,lights:!0,fog:!0})}else k=new THREE[i](k);if(void 0!==a.DbgName)k.name=a.DbgName;return k}};THREE.BinaryLoader=function(a){THREE.Loader.call(this,a)};
THREE.BinaryLoader.prototype=new THREE.Loader;THREE.BinaryLoader.prototype.constructor=THREE.BinaryLoader;THREE.BinaryLoader.prototype.supr=THREE.Loader.prototype;THREE.BinaryLoader.prototype.load=function(a,b,c,d){var c=c?c:this.extractUrlBase(a),d=d?d:this.extractUrlBase(a),f=this.showProgress?THREE.Loader.prototype.updateProgress:null;this.onLoadStart();this.loadAjaxJSON(this,a,b,c,d,f)};
THREE.BinaryLoader.prototype.loadAjaxJSON=function(a,b,c,d,f,g){var e=new XMLHttpRequest;e.onreadystatechange=function(){if(4==e.readyState)if(200==e.status||0==e.status){var h=JSON.parse(e.responseText);a.loadAjaxBuffers(h,c,f,d,g)}else console.error("THREE.BinaryLoader: Couldn't load ["+b+"] ["+e.status+"]")};e.open("GET",b,!0);e.overrideMimeType&&e.overrideMimeType("text/plain; charset=x-user-defined");e.setRequestHeader("Content-Type","text/plain");e.send(null)};
THREE.BinaryLoader.prototype.loadAjaxBuffers=function(a,b,c,d,f){var g=new XMLHttpRequest,e=c+"/"+a.buffers,h=0;g.onreadystatechange=function(){4==g.readyState?200==g.status||0==g.status?THREE.BinaryLoader.prototype.createBinModel(g.response,b,d,a.materials):console.error("THREE.BinaryLoader: Couldn't load ["+e+"] ["+g.status+"]"):3==g.readyState?f&&(0==h&&(h=g.getResponseHeader("Content-Length")),f({total:h,loaded:g.responseText.length})):2==g.readyState&&(h=g.getResponseHeader("Content-Length"))};
g.open("GET",e,!0);g.responseType="arraybuffer";g.send(null)};
THREE.BinaryLoader.prototype.createBinModel=function(a,b,c,d){var f=function(b){var c,f,i,k,j,q,l,n,r,m,o,p,s,t,v;function u(a){return a%4?4-a%4:0}function w(a,b){return(new Uint8Array(a,b,1))[0]}function z(a,b){return(new Uint32Array(a,b,1))[0]}function x(b,c){var d,e,f,g,h,i,j,l,k=new Uint32Array(a,c,3*b);for(d=0;d<b;d++){e=k[3*d];f=k[3*d+1];g=k[3*d+2];h=y[2*e];e=y[2*e+1];i=y[2*f];j=y[2*f+1];f=y[2*g];l=y[2*g+1];g=E.faceVertexUvs[0];var m=[];m.push(new THREE.UV(h,e));m.push(new THREE.UV(i,j));m.push(new THREE.UV(f,
l));g.push(m)}}function A(b,c){var d,e,f,g,h,i,j,l,k,m,n=new Uint32Array(a,c,4*b);for(d=0;d<b;d++){e=n[4*d];f=n[4*d+1];g=n[4*d+2];h=n[4*d+3];i=y[2*e];e=y[2*e+1];j=y[2*f];k=y[2*f+1];l=y[2*g];m=y[2*g+1];g=y[2*h];f=y[2*h+1];h=E.faceVertexUvs[0];var q=[];q.push(new THREE.UV(i,e));q.push(new THREE.UV(j,k));q.push(new THREE.UV(l,m));q.push(new THREE.UV(g,f));h.push(q)}}function D(b,c,d){for(var e,f,g,h,c=new Uint32Array(a,c,3*b),i=new Uint16Array(a,d,b),d=0;d<b;d++)e=c[3*d],f=c[3*d+1],g=c[3*d+2],h=i[d],
E.faces.push(new THREE.Face3(e,f,g,null,null,h))}function G(b,c,d){for(var e,f,g,h,i,c=new Uint32Array(a,c,4*b),j=new Uint16Array(a,d,b),d=0;d<b;d++)e=c[4*d],f=c[4*d+1],g=c[4*d+2],h=c[4*d+3],i=j[d],E.faces.push(new THREE.Face4(e,f,g,h,null,null,i))}function J(b,c,d,e){for(var f,g,h,i,j,l,k,c=new Uint32Array(a,c,3*b),d=new Uint32Array(a,d,3*b),m=new Uint16Array(a,e,b),e=0;e<b;e++){f=c[3*e];g=c[3*e+1];h=c[3*e+2];j=d[3*e];l=d[3*e+1];k=d[3*e+2];i=m[e];var n=H[3*l],q=H[3*l+1];l=H[3*l+2];var o=H[3*k],p=
H[3*k+1];k=H[3*k+2];E.faces.push(new THREE.Face3(f,g,h,[new THREE.Vector3(H[3*j],H[3*j+1],H[3*j+2]),new THREE.Vector3(n,q,l),new THREE.Vector3(o,p,k)],null,i))}}function F(b,c,d,e){for(var f,g,h,i,j,l,k,m,n,c=new Uint32Array(a,c,4*b),d=new Uint32Array(a,d,4*b),q=new Uint16Array(a,e,b),e=0;e<b;e++){f=c[4*e];g=c[4*e+1];h=c[4*e+2];i=c[4*e+3];l=d[4*e];k=d[4*e+1];m=d[4*e+2];n=d[4*e+3];j=q[e];var o=H[3*k],p=H[3*k+1];k=H[3*k+2];var r=H[3*m],s=H[3*m+1];m=H[3*m+2];var t=H[3*n],u=H[3*n+1];n=H[3*n+2];E.faces.push(new THREE.Face4(f,
g,h,i,[new THREE.Vector3(H[3*l],H[3*l+1],H[3*l+2]),new THREE.Vector3(o,p,k),new THREE.Vector3(r,s,m),new THREE.Vector3(t,u,n)],null,j))}}var E=this,C=0,H=[],y=[],I,K,B;THREE.Geometry.call(this);THREE.Loader.prototype.initMaterials(E,d,b);(function(a,b,c){for(var a=new Uint8Array(a,b,c),d="",e=0;e<c;e++)d+=String.fromCharCode(a[b+e]);return d})(a,C,12);c=w(a,C+12);w(a,C+13);w(a,C+14);w(a,C+15);f=w(a,C+16);i=w(a,C+17);k=w(a,C+18);j=w(a,C+19);q=z(a,C+20);l=z(a,C+20+4);n=z(a,C+20+8);b=z(a,C+20+12);r=
z(a,C+20+16);m=z(a,C+20+20);o=z(a,C+20+24);p=z(a,C+20+28);s=z(a,C+20+32);t=z(a,C+20+36);v=z(a,C+20+40);C+=c;c=3*f+j;B=4*f+j;I=b*c;K=r*(c+3*i);f=m*(c+3*k);j=o*(c+3*i+3*k);c=p*B;i=s*(B+4*i);k=t*(B+4*k);C+=function(b){var b=new Float32Array(a,b,3*q),c,d,e,f;for(c=0;c<q;c++)d=b[3*c],e=b[3*c+1],f=b[3*c+2],E.vertices.push(new THREE.Vertex(new THREE.Vector3(d,e,f)));return 3*q*Float32Array.BYTES_PER_ELEMENT}(C);C+=function(b){if(l){var b=new Int8Array(a,b,3*l),c,d,e,f;for(c=0;c<l;c++)d=b[3*c],e=b[3*c+1],
f=b[3*c+2],H.push(d/127,e/127,f/127)}return 3*l*Int8Array.BYTES_PER_ELEMENT}(C);C+=u(3*l);C+=function(b){if(n){var b=new Float32Array(a,b,2*n),c,d,e;for(c=0;c<n;c++)d=b[2*c],e=b[2*c+1],y.push(d,e)}return 2*n*Float32Array.BYTES_PER_ELEMENT}(C);I=C+I+u(2*b);K=I+K+u(2*r);f=K+f+u(2*m);j=f+j+u(2*o);c=j+c+u(2*p);i=c+i+u(2*s);k=i+k+u(2*t);(function(a){if(m){var b=a+3*m*Uint32Array.BYTES_PER_ELEMENT;D(m,a,b+3*m*Uint32Array.BYTES_PER_ELEMENT);x(m,b)}})(K);(function(a){if(o){var b=a+3*o*Uint32Array.BYTES_PER_ELEMENT,
c=b+3*o*Uint32Array.BYTES_PER_ELEMENT;J(o,a,b,c+3*o*Uint32Array.BYTES_PER_ELEMENT);x(o,c)}})(f);(function(a){if(t){var b=a+4*t*Uint32Array.BYTES_PER_ELEMENT;G(t,a,b+4*t*Uint32Array.BYTES_PER_ELEMENT);A(t,b)}})(i);(function(a){if(v){var b=a+4*v*Uint32Array.BYTES_PER_ELEMENT,c=b+4*v*Uint32Array.BYTES_PER_ELEMENT;F(v,a,b,c+4*v*Uint32Array.BYTES_PER_ELEMENT);A(v,c)}})(k);b&&D(b,C,C+3*b*Uint32Array.BYTES_PER_ELEMENT);(function(a){if(r){var b=a+3*r*Uint32Array.BYTES_PER_ELEMENT;J(r,a,b,b+3*r*Uint32Array.BYTES_PER_ELEMENT)}})(I);
p&&G(p,j,j+4*p*Uint32Array.BYTES_PER_ELEMENT);(function(a){if(s){var b=a+4*s*Uint32Array.BYTES_PER_ELEMENT;F(s,a,b,b+4*s*Uint32Array.BYTES_PER_ELEMENT)}})(c);this.computeCentroids();this.computeFaceNormals();THREE.Loader.prototype.hasNormals(this)&&this.computeTangents()};f.prototype=new THREE.Geometry;f.prototype.constructor=f;b(new f(c))};
THREE.ColladaLoader=function(){function a(a,d,f){Q=a;d=d||la;void 0!==f&&(a=f.split("/"),a.pop(),ma=(1>a.length?".":a.join("/"))+"/");if((a=Q.evaluate("//dae:asset",Q,M,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null).iterateNext())&&a.childNodes)for(f=0;f<a.childNodes.length;f++){var i=a.childNodes[f];switch(i.nodeName){case "unit":(i=i.getAttribute("meter"))&&parseFloat(i);break;case "up_axis":$=i.textContent.charAt(0)}}if(!R.convertUpAxis||$===R.upAxis)V=null;else switch($){case "X":V="Y"===R.upAxis?
"XtoY":"XtoZ";break;case "Y":V="X"===R.upAxis?"YtoX":"YtoZ";break;case "Z":V="X"===R.upAxis?"ZtoX":"ZtoY"}ea=b("//dae:library_images/dae:image",e,"image");fa=b("//dae:library_materials/dae:material",x,"material");ga=b("//dae:library_effects/dae:effect",F,"effect");U=b("//dae:library_geometries/dae:geometry",o,"geometry");ha=b(".//dae:library_cameras/dae:camera",K,"camera");T=b("//dae:library_controllers/dae:controller",h,"controller");W=b("//dae:library_animations/dae:animation",C,"animation");ia=
b(".//dae:library_visual_scenes/dae:visual_scene",j,"visual_scene");aa=[];ba=[];(a=Q.evaluate(".//dae:scene/dae:instance_visual_scene",Q,M,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null).iterateNext())?(a=a.getAttribute("url").replace(/^#/,""),S=ia[0<a.length?a:"visual_scene0"]):S=null;Z=new THREE.Object3D;for(a=0;a<S.nodes.length;a++)Z.add(g(S.nodes[a]));ja=[];c(Z);a={scene:Z,morphs:aa,skins:ba,animations:ja,dae:{images:ea,materials:fa,cameras:ha,effects:ga,geometries:U,controllers:T,animations:W,visualScenes:ia,
scene:S}};d&&d(a);return a}function b(a,b,c){for(var a=Q.evaluate(a,Q,M,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null),d={},e=a.iterateNext(),f=0;e;){e=(new b).parse(e);if(!e.id||0==e.id.length)e.id=c+f++;d[e.id]=e;e=a.iterateNext()}return d}function c(a){var b=S.getChildById(a.name,!0),d=null;if(b&&b.keys){d={fps:60,hierarchy:[{node:b,keys:b.keys,sids:b.sids}],node:a,name:"animation_"+a.name,length:0};ja.push(d);for(var e=0,f=b.keys.length;e<f;e++)d.length=Math.max(d.length,b.keys[e].time)}else d=
{hierarchy:[{keys:[],sids:[]}]};e=0;for(f=a.children.length;e<f;e++)for(var b=0,g=c(a.children[e]).hierarchy.length;b<g;b++)d.hierarchy.push({keys:[],sids:[]});return d}function d(a,b,c,e){a.world=a.world||new THREE.Matrix4;a.world.copy(a.matrix);if(a.channels&&a.channels.length){var f=a.channels[0].sampler.output[c];f instanceof THREE.Matrix4&&a.world.copy(f)}e&&a.world.multiply(e,a.world);b.push(a);for(e=0;e<a.nodes.length;e++)d(a.nodes[e],b,c,a.world)}function f(a,b,c){var e,f=T[b.url];if(!f||
!f.skin)console.log("ColladaLoader: Could not find skin controller.");else if(!b.skeleton||!b.skeleton.length)console.log("ColladaLoader: Could not find the skeleton for the skin. ");else{var c=1E6,g=-c,h=0;for(e in W)for(var i=W[e],j=0;j<i.sampler.length;j++){var k=i.sampler[j];k.create();c=Math.min(c,k.startTime);g=Math.max(g,k.endTime);h=Math.max(h,k.input.length)}e=h;for(var b=S.getChildById(b.skeleton[0],!0)||S.getChildBySid(b.skeleton[0],!0),l,m,g=new THREE.Vector3,n,j=0;j<a.vertices.length;j++)f.skin.bindShapeMatrix.multiplyVector3(a.vertices[j].position);
for(c=0;c<e;c++){h=[];i=[];for(j=0;j<a.vertices.length;j++)i.push(new THREE.Vertex(new THREE.Vector3));d(b,h,c);j=h;k=f.skin;for(m=0;m<j.length;m++)if(l=j[m],n=-1,"JOINT"==l.type){for(var q=0;q<k.joints.length;q++)if(l.sid==k.joints[q]){n=q;break}if(0<=n){q=k.invBindMatrices[n];l.invBindMatrix=q;l.skinningMatrix=new THREE.Matrix4;l.skinningMatrix.multiply(l.world,q);l.weights=[];for(q=0;q<k.weights.length;q++)for(var o=0;o<k.weights[q].length;o++){var p=k.weights[q][o];p.joint==n&&l.weights.push(p)}}else throw"ColladaLoader: Could not find joint '"+
l.sid+"'.";}for(j=0;j<h.length;j++)if("JOINT"==h[j].type)for(k=0;k<h[j].weights.length;k++)l=h[j].weights[k],m=l.index,l=l.weight,n=a.vertices[m],m=i[m],g.x=n.position.x,g.y=n.position.y,g.z=n.position.z,h[j].skinningMatrix.multiplyVector3(g),m.position.x+=g.x*l,m.position.y+=g.y*l,m.position.z+=g.z*l;a.morphTargets.push({name:"target_"+c,vertices:i})}}}function g(a){var b=new THREE.Object3D,c,d,e,h;for(e=0;e<a.controllers.length;e++){var i=T[a.controllers[e].url];switch(i.type){case "skin":if(U[i.skin.source]){var j=
new m;j.url=i.skin.source;j.instance_material=a.controllers[e].instance_material;a.geometries.push(j);c=a.controllers[e]}else if(T[i.skin.source]&&(d=i=T[i.skin.source],i.morph&&U[i.morph.source]))j=new m,j.url=i.morph.source,j.instance_material=a.controllers[e].instance_material,a.geometries.push(j);break;case "morph":if(U[i.morph.source])j=new m,j.url=i.morph.source,j.instance_material=a.controllers[e].instance_material,a.geometries.push(j),d=a.controllers[e];console.log("ColladaLoader: Morph-controller partially supported.")}}for(e=
0;e<a.geometries.length;e++){var i=a.geometries[e],j=i.instance_material,i=U[i.url],l={},k=[],q=0,o;if(i&&i.mesh&&i.mesh.primitives){if(0==b.name.length)b.name=i.id;if(j)for(h=0;h<j.length;h++){o=j[h];var p=fa[o.target],r=ga[p.instance_effect.url].shader;r.material.opacity=!r.material.opacity?1:r.material.opacity;l[o.symbol]=q;k.push(r.material);o=r.material;o.name=null==p.name||""===p.name?p.id:p.name;q++}j=o||new THREE.MeshLambertMaterial({color:14540253,shading:THREE.FlatShading});i=i.mesh.geometry3js;
if(1<q){j=new THREE.MeshFaceMaterial;i.materials=k;for(h=0;h<i.faces.length;h++)k=i.faces[h],k.materialIndex=l[k.daeMaterial]}if(void 0!==c)f(i,c),j.morphTargets=!0,j=new THREE.SkinnedMesh(i,j),j.skeleton=c.skeleton,j.skinController=T[c.url],j.skinInstanceController=c,j.name="skin_"+ba.length,ba.push(j);else if(void 0!==d){h=i;l=d instanceof n?T[d.url]:d;if(!l||!l.morph)console.log("could not find morph controller!");else{l=l.morph;for(k=0;k<l.targets.length;k++)if(q=U[l.targets[k]],q.mesh&&q.mesh.primitives&&
q.mesh.primitives.length)q=q.mesh.primitives[0].geometry,q.vertices.length===h.vertices.length&&h.morphTargets.push({name:"target_1",vertices:q.vertices});h.morphTargets.push({name:"target_Z",vertices:h.vertices})}j.morphTargets=!0;j=new THREE.Mesh(i,j);j.name="morph_"+aa.length;aa.push(j)}else j=new THREE.Mesh(i,j);1<a.geometries.length?b.add(j):b=j}}for(e=0;e<a.cameras.length;e++)b=ha[a.cameras[e].url],b=new THREE.PerspectiveCamera(b.fov,b.aspect_ratio,b.znear,b.zfar);b.name=a.id||"";b.matrix=a.matrix;
e=a.matrix.decompose();b.position=e[0];b.quaternion=e[1];b.useQuaternion=!0;b.scale=e[2];R.centerGeometry&&b.geometry&&(e=THREE.GeometryUtils.center(b.geometry),b.quaternion.multiplyVector3(e.multiplySelf(b.scale)),b.position.subSelf(e));for(e=0;e<a.nodes.length;e++)b.add(g(a.nodes[e],a));return b}function e(){this.init_from=this.id=""}function h(){this.type=this.name=this.id="";this.morph=this.skin=null}function i(){this.weights=this.targets=this.source=this.method=null}function k(){this.source=
"";this.bindShapeMatrix=null;this.invBindMatrices=[];this.joints=[];this.weights=[]}function j(){this.name=this.id="";this.nodes=[];this.scene=new THREE.Object3D}function q(){this.sid=this.name=this.id="";this.nodes=[];this.controllers=[];this.transforms=[];this.geometries=[];this.channels=[];this.matrix=new THREE.Matrix4}function l(){this.type=this.sid="";this.data=[];this.obj=null}function n(){this.url="";this.skeleton=[];this.instance_material=[]}function r(){this.target=this.symbol=""}function m(){this.url=
"";this.instance_material=[]}function o(){this.id="";this.mesh=null}function p(a){this.geometry=a.id;this.primitives=[];this.geometry3js=this.vertices=null}function s(){}function t(){this.material="";this.count=0;this.inputs=[];this.vcount=null;this.p=[];this.geometry=new THREE.Geometry}function v(){this.source="";this.stride=this.count=0;this.params=[]}function u(){this.input={}}function w(){this.semantic="";this.offset=0;this.source="";this.set=0}function z(a){this.id=a;this.type=null}function x(){this.name=
this.id="";this.instance_effect=null}function A(){this.color=new THREE.Color(0);this.color.setRGB(Math.random(),Math.random(),Math.random());this.color.a=1;this.texOpts=this.texcoord=this.texture=null}function D(a,b){this.type=a;this.effect=b;this.material=null}function G(a){this.effect=a;this.format=this.init_from=null}function J(a){this.effect=a;this.mipfilter=this.magfilter=this.minfilter=this.wrap_t=this.wrap_s=this.source=null}function F(){this.name=this.id="";this.sampler=this.surface=this.shader=
null}function E(){this.url=""}function C(){this.name=this.id="";this.source={};this.sampler=[];this.channel=[]}function H(a){this.animation=a;this.target=this.source="";this.member=this.arrIndices=this.arrSyntax=this.dotSyntax=this.sid=this.fullSid=null}function y(a){this.id="";this.animation=a;this.inputs=[];this.endTime=this.startTime=this.interpolation=this.strideOut=this.output=this.input=null;this.duration=0}function I(a){this.targets=[];this.time=a}function K(){this.name=this.id=""}function B(){this.url=
""}function M(a){return"dae"==a?"http://www.collada.org/2005/11/COLLADASchema":null}function L(a){for(var a=O(a),b=[],c=0,d=a.length;c<d;c++)b.push(parseFloat(a[c]));return b}function N(a){for(var a=O(a),b=[],c=0,d=a.length;c<d;c++)b.push(parseInt(a[c],10));return b}function O(a){return 0<a.length?a.replace(/^\s+/,"").replace(/\s+$/,"").split(/\s+/):[]}function X(a,b,c){return a.hasAttribute(b)?parseInt(a.getAttribute(b),10):c}function P(a,b){if(R.convertUpAxis&&$!==R.upAxis)switch(V){case "XtoY":var c=
a[0];a[0]=b*a[1];a[1]=c;break;case "XtoZ":c=a[2];a[2]=a[1];a[1]=a[0];a[0]=c;break;case "YtoX":c=a[0];a[0]=a[1];a[1]=b*c;break;case "YtoZ":c=a[1];a[1]=b*a[2];a[2]=c;break;case "ZtoX":c=a[0];a[0]=a[1];a[1]=a[2];a[2]=c;break;case "ZtoY":c=a[1],a[1]=a[2],a[2]=b*c}}function ca(a,b){var c=[a[b],a[b+1],a[b+2]];P(c,-1);return new THREE.Vector3(c[0],c[1],c[2])}function da(a){if(R.convertUpAxis){var b=[a[0],a[4],a[8]];P(b,-1);a[0]=b[0];a[4]=b[1];a[8]=b[2];b=[a[1],a[5],a[9]];P(b,-1);a[1]=b[0];a[5]=b[1];a[9]=
b[2];b=[a[2],a[6],a[10]];P(b,-1);a[2]=b[0];a[6]=b[1];a[10]=b[2];b=[a[0],a[1],a[2]];P(b,-1);a[0]=b[0];a[1]=b[1];a[2]=b[2];b=[a[4],a[5],a[6]];P(b,-1);a[4]=b[0];a[5]=b[1];a[6]=b[2];b=[a[8],a[9],a[10]];P(b,-1);a[8]=b[0];a[9]=b[1];a[10]=b[2];b=[a[3],a[7],a[11]];P(b,-1);a[3]=b[0];a[7]=b[1];a[11]=b[2]}return new THREE.Matrix4(a[0],a[1],a[2],a[3],a[4],a[5],a[6],a[7],a[8],a[9],a[10],a[11],a[12],a[13],a[14],a[15])}var Q=null,Z=null,S,la=null,Y={},ea={},W={},T={},U={},fa={},ga={},ha={},ja,ia,ma,aa,ba,na=THREE.SmoothShading,
R={centerGeometry:!1,convertUpAxis:!1,subdivideFaces:!0,upAxis:"Y"},$="Y",V=null,ka=Math.PI/180;e.prototype.parse=function(a){this.id=a.getAttribute("id");for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if("init_from"==c.nodeName)this.init_from=c.textContent}return this};h.prototype.parse=function(a){this.id=a.getAttribute("id");this.name=a.getAttribute("name");this.type="none";for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];switch(c.nodeName){case "skin":this.skin=(new k).parse(c);
this.type=c.nodeName;break;case "morph":this.morph=(new i).parse(c),this.type=c.nodeName}}return this};i.prototype.parse=function(a){var b={},c=[],d;this.method=a.getAttribute("method");this.source=a.getAttribute("source").replace(/^#/,"");for(d=0;d<a.childNodes.length;d++){var e=a.childNodes[d];if(1==e.nodeType)switch(e.nodeName){case "source":e=(new z).parse(e);b[e.id]=e;break;case "targets":c=this.parseInputs(e);break;default:console.log(e.nodeName)}}for(d=0;d<c.length;d++)switch(a=c[d],e=b[a.source],
a.semantic){case "MORPH_TARGET":this.targets=e.read();break;case "MORPH_WEIGHT":this.weights=e.read()}return this};i.prototype.parseInputs=function(a){for(var b=[],c=0;c<a.childNodes.length;c++){var d=a.childNodes[c];if(1==d.nodeType)switch(d.nodeName){case "input":b.push((new w).parse(d))}}return b};k.prototype.parse=function(a){var b={},c,d;this.source=a.getAttribute("source").replace(/^#/,"");this.invBindMatrices=[];this.joints=[];this.weights=[];for(var e=0;e<a.childNodes.length;e++){var f=a.childNodes[e];
if(1==f.nodeType)switch(f.nodeName){case "bind_shape_matrix":f=L(f.textContent);this.bindShapeMatrix=da(f);break;case "source":f=(new z).parse(f);b[f.id]=f;break;case "joints":c=f;break;case "vertex_weights":d=f;break;default:console.log(f.nodeName)}}this.parseJoints(c,b);this.parseWeights(d,b);return this};k.prototype.parseJoints=function(a,b){for(var c=0;c<a.childNodes.length;c++){var d=a.childNodes[c];if(1==d.nodeType)switch(d.nodeName){case "input":var d=(new w).parse(d),e=b[d.source];if("JOINT"==
d.semantic)this.joints=e.read();else if("INV_BIND_MATRIX"==d.semantic)this.invBindMatrices=e.read()}}};k.prototype.parseWeights=function(a,b){for(var c,d,e=[],f=0;f<a.childNodes.length;f++){var g=a.childNodes[f];if(1==g.nodeType)switch(g.nodeName){case "input":e.push((new w).parse(g));break;case "v":c=N(g.textContent);break;case "vcount":d=N(g.textContent)}}for(f=g=0;f<d.length;f++){for(var h=d[f],i=[],j=0;j<h;j++){for(var l={},k=0;k<e.length;k++){var m=e[k],n=c[g+m.offset];switch(m.semantic){case "JOINT":l.joint=
n;break;case "WEIGHT":l.weight=b[m.source].data[n]}}i.push(l);g+=e.length}for(j=0;j<i.length;j++)i[j].index=f;this.weights.push(i)}};j.prototype.getChildById=function(a,b){for(var c=0;c<this.nodes.length;c++){var d=this.nodes[c].getChildById(a,b);if(d)return d}return null};j.prototype.getChildBySid=function(a,b){for(var c=0;c<this.nodes.length;c++){var d=this.nodes[c].getChildBySid(a,b);if(d)return d}return null};j.prototype.parse=function(a){this.id=a.getAttribute("id");this.name=a.getAttribute("name");
this.nodes=[];for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if(1==c.nodeType)switch(c.nodeName){case "node":this.nodes.push((new q).parse(c))}}return this};q.prototype.getChannelForTransform=function(a){for(var b=0;b<this.channels.length;b++){var c=this.channels[b],d=c.target.split("/");d.shift();var e=d.shift(),f=0<=e.indexOf("."),g=0<=e.indexOf("("),h;if(f)d=e.split("."),e=d.shift(),d.shift();else if(g){h=e.split("(");e=h.shift();for(d=0;d<h.length;d++)h[d]=parseInt(h[d].replace(/\)/,
""))}if(e==a)return c.info={sid:e,dotSyntax:f,arrSyntax:g,arrIndices:h},c}return null};q.prototype.getChildById=function(a,b){if(this.id==a)return this;if(b)for(var c=0;c<this.nodes.length;c++){var d=this.nodes[c].getChildById(a,b);if(d)return d}return null};q.prototype.getChildBySid=function(a,b){if(this.sid==a)return this;if(b)for(var c=0;c<this.nodes.length;c++){var d=this.nodes[c].getChildBySid(a,b);if(d)return d}return null};q.prototype.getTransformBySid=function(a){for(var b=0;b<this.transforms.length;b++)if(this.transforms[b].sid==
a)return this.transforms[b];return null};q.prototype.parse=function(a){var b;this.id=a.getAttribute("id");this.sid=a.getAttribute("sid");this.name=a.getAttribute("name");this.type=a.getAttribute("type");this.type="JOINT"==this.type?this.type:"NODE";this.nodes=[];this.transforms=[];this.geometries=[];this.cameras=[];this.controllers=[];this.matrix=new THREE.Matrix4;for(var c=0;c<a.childNodes.length;c++)if(b=a.childNodes[c],1==b.nodeType)switch(b.nodeName){case "node":this.nodes.push((new q).parse(b));
break;case "instance_camera":this.cameras.push((new B).parse(b));break;case "instance_controller":this.controllers.push((new n).parse(b));break;case "instance_geometry":this.geometries.push((new m).parse(b));break;case "instance_light":break;case "instance_node":b=b.getAttribute("url").replace(/^#/,"");(b=Q.evaluate(".//dae:library_nodes//dae:node[@id='"+b+"']",Q,M,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null).iterateNext())&&this.nodes.push((new q).parse(b));break;case "rotate":case "translate":case "scale":case "matrix":case "lookat":case "skew":this.transforms.push((new l).parse(b));
break;case "extra":break;default:console.log(b.nodeName)}a=[];c=1E6;b=-1E6;for(var d in W)for(var e=W[d],f=0;f<e.channel.length;f++){var g=e.channel[f],h=e.sampler[f];d=g.target.split("/")[0];if(d==this.id)h.create(),g.sampler=h,c=Math.min(c,h.startTime),b=Math.max(b,h.endTime),a.push(g)}if(a.length)this.startTime=c,this.endTime=b;if((this.channels=a)&&this.channels.length){d=[];a=[];c=0;for(e=this.channels.length;c<e;c++){b=this.channels[c];f=b.fullSid;g=b.member;if(R.convertUpAxis)switch(g){case "X":switch(V){case "XtoY":case "XtoZ":case "YtoX":g=
"Y";break;case "ZtoX":g="Z"}break;case "Y":switch(V){case "XtoY":case "YtoX":case "ZtoX":g="X";break;case "XtoZ":case "YtoZ":case "ZtoY":g="Z"}break;case "Z":switch(V){case "XtoZ":g="X";break;case "YtoZ":case "ZtoX":case "ZtoY":g="Y"}}var h=b.sampler,i=h.input,j=this.getTransformBySid(b.sid);if(j){-1===a.indexOf(f)&&a.push(f);b=0;for(var k=i.length;b<k;b++){var o=i[b],p=h.getData(j.type,b),r;r=null;for(var s=0,t=d.length;s<t&&null==r;s++){var u=d[s];if(u.time===o)r=u;else if(u.time>o)break}if(!r){r=
new I(o);s=-1;t=0;for(u=d.length;t<u&&-1==s;t++)d[t].time>=o&&(s=t);o=s;d.splice(-1==o?d.length:o,0,r)}r.addTarget(f,j,g,p)}}else console.log('Could not find transform "'+b.sid+'" in node '+this.id)}for(c=0;c<a.length;c++){e=a[c];for(b=0;b<d.length;b++)if(r=d[b],!r.hasTarget(e)){h=d;f=r;j=b;g=e;i=void 0;a:{i=j?j-1:0;for(i=0<=i?i:i+h.length;0<=i;i--)if(k=h[i],k.hasTarget(g)){i=k;break a}i=null}k=void 0;a:{for(j+=1;j<h.length;j++)if(k=h[j],k.hasTarget(g))break a;k=null}if(i&&k){h=(f.time-i.time)/(k.time-
i.time);i=i.getTarget(g);j=k.getTarget(g).data;k=i.data;p=void 0;if(k.length){p=[];for(o=0;o<k.length;++o)p[o]=k[o]+(j[o]-k[o])*h}else p=k+(j-k)*h;f.addTarget(g,i.transform,i.member,p)}}}this.keys=d;this.sids=a}this.updateMatrix();return this};q.prototype.updateMatrix=function(){this.matrix.identity();for(var a=0;a<this.transforms.length;a++)this.transforms[a].apply(this.matrix)};l.prototype.parse=function(a){this.sid=a.getAttribute("sid");this.type=a.nodeName;this.data=L(a.textContent);this.convert();
return this};l.prototype.convert=function(){switch(this.type){case "matrix":this.obj=da(this.data);break;case "rotate":this.angle=this.data[3]*ka;case "translate":P(this.data,-1);this.obj=new THREE.Vector3(this.data[0],this.data[1],this.data[2]);break;case "scale":P(this.data,1);this.obj=new THREE.Vector3(this.data[0],this.data[1],this.data[2]);break;default:console.log("Can not convert Transform of type "+this.type)}};l.prototype.apply=function(a){switch(this.type){case "matrix":a.multiplySelf(this.obj);
break;case "translate":a.translate(this.obj);break;case "rotate":a.rotateByAxis(this.obj,this.angle);break;case "scale":a.scale(this.obj)}};l.prototype.update=function(a,b){switch(this.type){case "matrix":console.log("Currently not handling matrix transform updates");break;case "translate":case "scale":switch(b){case "X":this.obj.x=a;break;case "Y":this.obj.y=a;break;case "Z":this.obj.z=a;break;default:this.obj.x=a[0],this.obj.y=a[1],this.obj.z=a[2]}break;case "rotate":switch(b){case "X":this.obj.x=
a;break;case "Y":this.obj.y=a;break;case "Z":this.obj.z=a;break;case "ANGLE":this.angle=a*ka;break;default:this.obj.x=a[0],this.obj.y=a[1],this.obj.z=a[2],this.angle=a[3]*ka}}};n.prototype.parse=function(a){this.url=a.getAttribute("url").replace(/^#/,"");this.skeleton=[];this.instance_material=[];for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if(1==c.nodeType)switch(c.nodeName){case "skeleton":this.skeleton.push(c.textContent.replace(/^#/,""));break;case "bind_material":if(c=Q.evaluate(".//dae:instance_material",
c,M,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null))for(var d=c.iterateNext();d;)this.instance_material.push((new r).parse(d)),d=c.iterateNext()}}return this};r.prototype.parse=function(a){this.symbol=a.getAttribute("symbol");this.target=a.getAttribute("target").replace(/^#/,"");return this};m.prototype.parse=function(a){this.url=a.getAttribute("url").replace(/^#/,"");this.instance_material=[];for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if(1==c.nodeType&&"bind_material"==c.nodeName){if(a=
Q.evaluate(".//dae:instance_material",c,M,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null))for(b=a.iterateNext();b;)this.instance_material.push((new r).parse(b)),b=a.iterateNext();break}}return this};o.prototype.parse=function(a){this.id=a.getAttribute("id");for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];switch(c.nodeName){case "mesh":this.mesh=(new p(this)).parse(c)}}return this};p.prototype.parse=function(a){this.primitives=[];var b;for(b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];
switch(c.nodeName){case "source":var d=c.getAttribute("id");void 0==Y[d]&&(Y[d]=(new z(d)).parse(c));break;case "vertices":this.vertices=(new u).parse(c);break;case "triangles":this.primitives.push((new t).parse(c));break;case "polygons":console.warn("polygon holes not yet supported!");case "polylist":this.primitives.push((new s).parse(c))}}this.geometry3js=new THREE.Geometry;a=Y[this.vertices.input.POSITION.source].data;for(b=0;b<a.length;b+=3)this.geometry3js.vertices.push(new THREE.Vertex(ca(a,
b)));for(b=0;b<this.primitives.length;b++)a=this.primitives[b],a.setVertices(this.vertices),this.handlePrimitive(a,this.geometry3js);this.geometry3js.computeCentroids();this.geometry3js.computeFaceNormals();this.geometry3js.calcNormals&&(this.geometry3js.computeVertexNormals(),delete this.geometry3js.calcNormals);this.geometry3js.computeBoundingBox();return this};p.prototype.handlePrimitive=function(a,b){var c=0,d,e,f=a.p,g=a.inputs,h,i,j,k,l=0,m=3,n=0,q=[];for(d=0;d<g.length;d++){h=g[d];var o=h.offset+
1,n=n<o?o:n;switch(h.semantic){case "TEXCOORD":q.push(h.set)}}for(;c<f.length;){var p=[],r=[],o={},s=[];a.vcount&&(m=a.vcount[l++]);for(d=0;d<m;d++)for(e=0;e<g.length;e++)switch(h=g[e],k=Y[h.source],i=f[c+d*n+h.offset],j=k.accessor.params.length,j*=i,h.semantic){case "VERTEX":p.push(i);break;case "NORMAL":r.push(ca(k.data,j));break;case "TEXCOORD":void 0===o[h.set]&&(o[h.set]=[]);o[h.set].push(new THREE.UV(k.data[j],1-k.data[j+1]));break;case "COLOR":s.push((new THREE.Color).setRGB(k.data[j],k.data[j+
1],k.data[j+2]))}e=null;d=[];if(0==r.length)if(h=this.vertices.input.NORMAL){k=Y[h.source];j=k.accessor.params.length;h=0;for(i=p.length;h<i;h++)r.push(ca(k.data,p[h]*j))}else b.calcNormals=!0;if(3===m)d.push(new THREE.Face3(p[0],p[1],p[2],r,s.length?s:new THREE.Color));else if(4===m)d.push(new THREE.Face4(p[0],p[1],p[2],p[3],r,s.length?s:new THREE.Color));else if(4<m&&R.subdivideFaces){s=s.length?s:new THREE.Color;for(e=1;e<m-1;)d.push(new THREE.Face3(p[0],p[e],p[e+1],[r[0],r[e++],r[e]],s))}if(d.length){h=
0;for(i=d.length;h<i;h++){e=d[h];e.daeMaterial=a.material;b.faces.push(e);for(e=0;e<q.length;e++)p=o[q[e]],p=4<m?[p[0],p[h+1],p[h+2]]:4===m?[p[0],p[1],p[2],p[3]]:[p[0],p[1],p[2]],b.faceVertexUvs[e]||(b.faceVertexUvs[e]=[]),b.faceVertexUvs[e].push(p)}}else console.log("dropped face with vcount "+m+" for geometry with id: "+b.id);c+=n*m}};s.prototype=new t;s.prototype.constructor=s;t.prototype.setVertices=function(a){for(var b=0;b<this.inputs.length;b++)if(this.inputs[b].source==a.id)this.inputs[b].source=
a.input.POSITION.source};t.prototype.parse=function(a){this.inputs=[];this.material=a.getAttribute("material");this.count=X(a,"count",0);for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];switch(c.nodeName){case "input":this.inputs.push((new w).parse(a.childNodes[b]));break;case "vcount":this.vcount=N(c.textContent);break;case "p":this.p=N(c.textContent)}}return this};v.prototype.parse=function(a){this.params=[];this.source=a.getAttribute("source");this.count=X(a,"count",0);this.stride=
X(a,"stride",0);for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if("param"==c.nodeName){var d={};d.name=c.getAttribute("name");d.type=c.getAttribute("type");this.params.push(d)}}return this};u.prototype.parse=function(a){this.id=a.getAttribute("id");for(var b=0;b<a.childNodes.length;b++)if("input"==a.childNodes[b].nodeName){var c=(new w).parse(a.childNodes[b]);this.input[c.semantic]=c}return this};w.prototype.parse=function(a){this.semantic=a.getAttribute("semantic");this.source=a.getAttribute("source").replace(/^#/,
"");this.set=X(a,"set",-1);this.offset=X(a,"offset",0);if("TEXCOORD"==this.semantic&&0>this.set)this.set=0;return this};z.prototype.parse=function(a){this.id=a.getAttribute("id");for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];switch(c.nodeName){case "bool_array":for(var d=O(c.textContent),e=[],f=0,g=d.length;f<g;f++)e.push("true"==d[f]||"1"==d[f]?!0:!1);this.data=e;this.type=c.nodeName;break;case "float_array":this.data=L(c.textContent);this.type=c.nodeName;break;case "int_array":this.data=
N(c.textContent);this.type=c.nodeName;break;case "IDREF_array":case "Name_array":this.data=O(c.textContent);this.type=c.nodeName;break;case "technique_common":for(d=0;d<c.childNodes.length;d++)if("accessor"==c.childNodes[d].nodeName){this.accessor=(new v).parse(c.childNodes[d]);break}}}return this};z.prototype.read=function(){var a=[],b=this.accessor.params[0];switch(b.type){case "IDREF":case "Name":case "name":case "float":return this.data;case "float4x4":for(b=0;b<this.data.length;b+=16){var c=
this.data.slice(b,b+16),c=da(c);a.push(c)}break;default:console.log("ColladaLoader: Source: Read dont know how to read "+b.type+".")}return a};x.prototype.parse=function(a){this.id=a.getAttribute("id");this.name=a.getAttribute("name");for(var b=0;b<a.childNodes.length;b++)if("instance_effect"==a.childNodes[b].nodeName){this.instance_effect=(new E).parse(a.childNodes[b]);break}return this};A.prototype.isColor=function(){return null==this.texture};A.prototype.isTexture=function(){return null!=this.texture};
A.prototype.parse=function(a){for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if(1==c.nodeType)switch(c.nodeName){case "color":c=L(c.textContent);this.color=new THREE.Color(0);this.color.setRGB(c[0],c[1],c[2]);this.color.a=c[3];break;case "texture":this.texture=c.getAttribute("texture"),this.texcoord=c.getAttribute("texcoord"),this.texOpts={offsetU:0,offsetV:0,repeatU:1,repeatV:1,wrapU:1,wrapV:1},this.parseTexture(c)}}return this};A.prototype.parseTexture=function(a){if(!a.childNodes)return this;
a.childNodes[1]&&"extra"===a.childNodes[1].nodeName&&(a=a.childNodes[1],a.childNodes[1]&&"technique"===a.childNodes[1].nodeName&&(a=a.childNodes[1]));for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];switch(c.nodeName){case "offsetU":case "offsetV":case "repeatU":case "repeatV":this.texOpts[c.nodeName]=parseFloat(c.textContent);break;case "wrapU":case "wrapV":this.texOpts[c.nodeName]=parseInt(c.textContent);break;default:this.texOpts[c.nodeName]=c.textContent}}return this};D.prototype.parse=
function(a){for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if(1==c.nodeType)switch(c.nodeName){case "ambient":case "emission":case "diffuse":case "specular":case "transparent":this[c.nodeName]=(new A).parse(c);break;case "shininess":case "reflectivity":case "transparency":var d;d=Q.evaluate(".//dae:float",c,M,XPathResult.ORDERED_NODE_ITERATOR_TYPE,null);for(var e=d.iterateNext(),f=[];e;)f.push(e),e=d.iterateNext();d=f;0<d.length&&(this[c.nodeName]=parseFloat(d[0].textContent))}}this.create();
return this};D.prototype.create=function(){var a={},b=void 0!==this.transparency&&1>this.transparency,c;for(c in this)switch(c){case "ambient":case "emission":case "diffuse":case "specular":var d=this[c];if(d instanceof A)if(d.isTexture()){if(this.effect.sampler&&this.effect.surface&&this.effect.sampler.source==this.effect.surface.sid){var e=ea[this.effect.surface.init_from];if(e)e=THREE.ImageUtils.loadTexture(ma+e.init_from),e.wrapS=d.texOpts.wrapU?THREE.RepeatWrapping:THREE.ClampToEdgeWrapping,
e.wrapT=d.texOpts.wrapV?THREE.RepeatWrapping:THREE.ClampToEdgeWrapping,e.offset.x=d.texOpts.offsetU,e.offset.y=d.texOpts.offsetV,e.repeat.x=d.texOpts.repeatU,e.repeat.y=d.texOpts.repeatV,a.map=e}}else"diffuse"==c?a.color=d.color.getHex():b||(a[c]=d.color.getHex());break;case "shininess":case "reflectivity":a[c]=this[c];break;case "transparency":if(b)a.transparent=!0,a.opacity=this[c],b=!0}a.shading=na;return this.material=new THREE.MeshLambertMaterial(a)};G.prototype.parse=function(a){for(var b=0;b<
a.childNodes.length;b++){var c=a.childNodes[b];if(1==c.nodeType)switch(c.nodeName){case "init_from":this.init_from=c.textContent;break;case "format":this.format=c.textContent;break;default:console.log("unhandled Surface prop: "+c.nodeName)}}return this};J.prototype.parse=function(a){for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if(1==c.nodeType)switch(c.nodeName){case "source":this.source=c.textContent;break;case "minfilter":this.minfilter=c.textContent;break;case "magfilter":this.magfilter=
c.textContent;break;case "mipfilter":this.mipfilter=c.textContent;break;case "wrap_s":this.wrap_s=c.textContent;break;case "wrap_t":this.wrap_t=c.textContent;break;default:console.log("unhandled Sampler2D prop: "+c.nodeName)}}return this};F.prototype.create=function(){if(null==this.shader)return null};F.prototype.parse=function(a){this.id=a.getAttribute("id");this.name=a.getAttribute("name");this.shader=null;for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if(1==c.nodeType)switch(c.nodeName){case "profile_COMMON":this.parseTechnique(this.parseProfileCOMMON(c))}}return this};
F.prototype.parseNewparam=function(a){for(var b=a.getAttribute("sid"),c=0;c<a.childNodes.length;c++){var d=a.childNodes[c];if(1==d.nodeType)switch(d.nodeName){case "surface":this.surface=(new G(this)).parse(d);this.surface.sid=b;break;case "sampler2D":this.sampler=(new J(this)).parse(d);this.sampler.sid=b;break;case "extra":break;default:console.log(d.nodeName)}}};F.prototype.parseProfileCOMMON=function(a){for(var b,c=0;c<a.childNodes.length;c++){var d=a.childNodes[c];if(1==d.nodeType)switch(d.nodeName){case "profile_COMMON":this.parseProfileCOMMON(d);
break;case "technique":b=d;break;case "newparam":this.parseNewparam(d);break;case "extra":break;default:console.log(d.nodeName)}}return b};F.prototype.parseTechnique=function(a){for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if(1==c.nodeType)switch(c.nodeName){case "constant":case "lambert":case "blinn":case "phong":this.shader=(new D(c.nodeName,this)).parse(c)}}};E.prototype.parse=function(a){this.url=a.getAttribute("url").replace(/^#/,"");return this};C.prototype.parse=function(a){this.id=
a.getAttribute("id");this.name=a.getAttribute("name");this.source={};for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if(1==c.nodeType)switch(c.nodeName){case "source":c=(new z).parse(c);this.source[c.id]=c;break;case "sampler":this.sampler.push((new y(this)).parse(c));break;case "channel":this.channel.push((new H(this)).parse(c))}}return this};H.prototype.parse=function(a){this.source=a.getAttribute("source").replace(/^#/,"");this.target=a.getAttribute("target");var b=this.target.split("/");
b.shift();var a=b.shift(),c=0<=a.indexOf("."),d=0<=a.indexOf("(");if(c)b=a.split("."),this.sid=b.shift(),this.member=b.shift();else if(d){b=a.split("(");this.sid=b.shift();for(var e=0;e<b.length;e++)b[e]=parseInt(b[e].replace(/\)/,""));this.arrIndices=b}else this.sid=a;this.fullSid=a;this.dotSyntax=c;this.arrSyntax=d;return this};y.prototype.parse=function(a){this.id=a.getAttribute("id");this.inputs=[];for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if(1==c.nodeType)switch(c.nodeName){case "input":this.inputs.push((new w).parse(c))}}return this};
y.prototype.create=function(){for(var a=0;a<this.inputs.length;a++){var b=this.inputs[a],c=this.animation.source[b.source];switch(b.semantic){case "INPUT":this.input=c.read();break;case "OUTPUT":this.output=c.read();this.strideOut=c.accessor.stride;break;case "INTERPOLATION":this.interpolation=c.read();break;case "IN_TANGENT":break;case "OUT_TANGENT":break;default:console.log(b.semantic)}}this.duration=this.endTime=this.startTime=0;if(this.input.length){this.startTime=1E8;this.endTime=-1E8;for(a=
0;a<this.input.length;a++)this.startTime=Math.min(this.startTime,this.input[a]),this.endTime=Math.max(this.endTime,this.input[a]);this.duration=this.endTime-this.startTime}};y.prototype.getData=function(a,b){var c;if(1<this.strideOut){c=[];for(var b=b*this.strideOut,d=0;d<this.strideOut;++d)c[d]=this.output[b+d];if(3===this.strideOut)switch(a){case "rotate":case "translate":P(c,-1);break;case "scale":P(c,1)}}else c=this.output[b];return c};I.prototype.addTarget=function(a,b,c,d){this.targets.push({sid:a,
member:c,transform:b,data:d})};I.prototype.apply=function(a){for(var b=0;b<this.targets.length;++b){var c=this.targets[b];(!a||c.sid===a)&&c.transform.update(c.data,c.member)}};I.prototype.getTarget=function(a){for(var b=0;b<this.targets.length;++b)if(this.targets[b].sid===a)return this.targets[b];return null};I.prototype.hasTarget=function(a){for(var b=0;b<this.targets.length;++b)if(this.targets[b].sid===a)return!0;return!1};I.prototype.interpolate=function(a,b){for(var c=0;c<this.targets.length;++c){var d=
this.targets[c],e=a.getTarget(d.sid);if(e){var f=(b-this.time)/(a.time-this.time),g=e.data,h=d.data;if(0>f||1<f)console.log("Key.interpolate: Warning! Scale out of bounds:"+f),f=0>f?0:1;if(h.length)for(var e=[],i=0;i<h.length;++i)e[i]=h[i]+(g[i]-h[i])*f;else e=h+(g-h)*f}else e=d.data;d.transform.update(e,d.member)}};K.prototype.parse=function(a){this.id=a.getAttribute("id");this.name=a.getAttribute("name");for(var b=0;b<a.childNodes.length;b++){var c=a.childNodes[b];if(1==c.nodeType)switch(c.nodeName){case "optics":this.parseOptics(c)}}return this};
K.prototype.parseOptics=function(a){for(var b=0;b<a.childNodes.length;b++)if("technique_common"==a.childNodes[b].nodeName)for(var c=a.childNodes[b],d=0;d<c.childNodes.length;d++)if("perspective"==c.childNodes[d].nodeName)for(var e=c.childNodes[d],f=0;f<e.childNodes.length;f++){var g=e.childNodes[f];switch(g.nodeName){case "xfov":this.fov=g.textContent;break;case "znear":this.znear=0.4;break;case "zfar":this.zfar=1E15;break;case "aspect_ratio":this.aspect_ratio=g.textContent}}return this};B.prototype.parse=
function(a){this.url=a.getAttribute("url").replace(/^#/,"");return this};return{load:function(b,c,d){var e=0;if(document.implementation&&document.implementation.createDocument){var f=new XMLHttpRequest;f.overrideMimeType&&f.overrideMimeType("text/xml");f.onreadystatechange=function(){if(4==f.readyState){if(0==f.status||200==f.status)f.responseXML?(la=c,a(f.responseXML,void 0,b)):console.error("ColladaLoader: Empty or non-existing file ("+b+")")}else 3==f.readyState&&d&&(0==e&&(e=f.getResponseHeader("Content-Length")),
d({total:e,loaded:f.responseText.length}))};f.open("GET",b,!0);f.send(null)}else alert("Don't know how to parse XML!")},parse:a,setPreferredShading:function(a){na=a},applySkin:f,geometries:U,options:R}};THREE.JSONLoader=function(a){THREE.Loader.call(this,a)};THREE.JSONLoader.prototype=new THREE.Loader;THREE.JSONLoader.prototype.constructor=THREE.JSONLoader;THREE.JSONLoader.prototype.supr=THREE.Loader.prototype;
THREE.JSONLoader.prototype.load=function(a,b,c){c=c?c:this.extractUrlBase(a);this.onLoadStart();this.loadAjaxJSON(this,a,b,c)};
THREE.JSONLoader.prototype.loadAjaxJSON=function(a,b,c,d,f){var g=new XMLHttpRequest,e=0;g.onreadystatechange=function(){if(g.readyState===g.DONE)if(200===g.status||0===g.status){if(g.responseText){var h=JSON.parse(g.responseText);a.createModel(h,c,d)}else console.warn("THREE.JSONLoader: ["+b+"] seems to be unreachable or file there is empty");a.onLoadComplete()}else console.error("THREE.JSONLoader: Couldn't load ["+b+"] ["+g.status+"]");else g.readyState===g.LOADING?f&&(0===e&&(e=g.getResponseHeader("Content-Length")),
f({total:e,loaded:g.responseText.length})):g.readyState===g.HEADERS_RECEIVED&&(e=g.getResponseHeader("Content-Length"))};g.open("GET",b,!0);g.overrideMimeType&&g.overrideMimeType("text/plain; charset=x-user-defined");g.setRequestHeader("Content-Type","text/plain");g.send(null)};
THREE.JSONLoader.prototype.createModel=function(a,b,c){var d=new THREE.Geometry,f=void 0!==a.scale?1/a.scale:1;this.initMaterials(d,a.materials,c);(function(b){var c,f,i,k,j,q,l,n,r,m,o,p,s,t,v=a.faces;q=a.vertices;var u=a.normals,w=a.colors,z=0;for(c=0;c<a.uvs.length;c++)a.uvs[c].length&&z++;for(c=0;c<z;c++)d.faceUvs[c]=[],d.faceVertexUvs[c]=[];k=0;for(j=q.length;k<j;)l=new THREE.Vertex,l.position.x=q[k++]*b,l.position.y=q[k++]*b,l.position.z=q[k++]*b,d.vertices.push(l);k=0;for(j=v.length;k<j;){b=
v[k++];q=b&1;i=b&2;c=b&4;f=b&8;n=b&16;l=b&32;m=b&64;b&=128;q?(o=new THREE.Face4,o.a=v[k++],o.b=v[k++],o.c=v[k++],o.d=v[k++],q=4):(o=new THREE.Face3,o.a=v[k++],o.b=v[k++],o.c=v[k++],q=3);if(i)i=v[k++],o.materialIndex=i;i=d.faces.length;if(c)for(c=0;c<z;c++)p=a.uvs[c],r=v[k++],t=p[2*r],r=p[2*r+1],d.faceUvs[c][i]=new THREE.UV(t,r);if(f)for(c=0;c<z;c++){p=a.uvs[c];s=[];for(f=0;f<q;f++)r=v[k++],t=p[2*r],r=p[2*r+1],s[f]=new THREE.UV(t,r);d.faceVertexUvs[c][i]=s}if(n)n=3*v[k++],f=new THREE.Vector3,f.x=u[n++],
f.y=u[n++],f.z=u[n],o.normal=f;if(l)for(c=0;c<q;c++)n=3*v[k++],f=new THREE.Vector3,f.x=u[n++],f.y=u[n++],f.z=u[n],o.vertexNormals.push(f);if(m)l=v[k++],l=new THREE.Color(w[l]),o.color=l;if(b)for(c=0;c<q;c++)l=v[k++],l=new THREE.Color(w[l]),o.vertexColors.push(l);d.faces.push(o)}})(f);(function(){var b,c,f,i;if(a.skinWeights)for(b=0,c=a.skinWeights.length;b<c;b+=2)f=a.skinWeights[b],i=a.skinWeights[b+1],d.skinWeights.push(new THREE.Vector4(f,i,0,0));if(a.skinIndices)for(b=0,c=a.skinIndices.length;b<
c;b+=2)f=a.skinIndices[b],i=a.skinIndices[b+1],d.skinIndices.push(new THREE.Vector4(f,i,0,0));d.bones=a.bones;d.animation=a.animation})();(function(b){if(void 0!==a.morphTargets){var c,f,i,k,j,q,l,n,r;for(c=0,f=a.morphTargets.length;c<f;c++){d.morphTargets[c]={};d.morphTargets[c].name=a.morphTargets[c].name;d.morphTargets[c].vertices=[];n=d.morphTargets[c].vertices;r=a.morphTargets[c].vertices;for(i=0,k=r.length;i<k;i+=3)j=r[i]*b,q=r[i+1]*b,l=r[i+2]*b,n.push(new THREE.Vertex(new THREE.Vector3(j,q,
l)))}}if(void 0!==a.morphColors)for(c=0,f=a.morphColors.length;c<f;c++){d.morphColors[c]={};d.morphColors[c].name=a.morphColors[c].name;d.morphColors[c].colors=[];k=d.morphColors[c].colors;j=a.morphColors[c].colors;for(b=0,i=j.length;b<i;b+=3)q=new THREE.Color(16755200),q.setRGB(j[b],j[b+1],j[b+2]),k.push(q)}})(f);d.computeCentroids();d.computeFaceNormals();this.hasNormals(d)&&d.computeTangents();b(d)};
THREE.SceneLoader=function(){this.onLoadStart=function(){};this.onLoadProgress=function(){};this.onLoadComplete=function(){};this.callbackSync=function(){};this.callbackProgress=function(){}};THREE.SceneLoader.prototype.constructor=THREE.SceneLoader;
THREE.SceneLoader.prototype.load=function(a,b){var c=this,d=new XMLHttpRequest;d.onreadystatechange=function(){if(4==d.readyState)if(200==d.status||0==d.status){var f=JSON.parse(d.responseText);c.createScene(f,b,a)}else console.error("THREE.SceneLoader: Couldn't load ["+a+"] ["+d.status+"]")};d.open("GET",a,!0);d.overrideMimeType&&d.overrideMimeType("text/plain; charset=x-user-defined");d.setRequestHeader("Content-Type","text/plain");d.send(null)};
THREE.SceneLoader.prototype.createScene=function(a,b,c){function d(a,b){return"relativeToHTML"==b?a:k+"/"+a}function f(){var a;for(l in E.objects)if(!B.objects[l])if(p=E.objects[l],void 0!==p.geometry){if(D=B.geometries[p.geometry]){a=!1;G=B.materials[p.materials[0]];(a=G instanceof THREE.ShaderMaterial)&&D.computeTangents();v=p.position;u=p.rotation;w=p.quaternion;z=p.scale;w=0;0==p.materials.length&&(G=new THREE.MeshFaceMaterial);1<p.materials.length&&(G=new THREE.MeshFaceMaterial);a=new THREE.Mesh(D,
G);a.name=l;a.position.set(v[0],v[1],v[2]);w?(a.quaternion.set(w[0],w[1],w[2],w[3]),a.useQuaternion=!0):a.rotation.set(u[0],u[1],u[2]);a.scale.set(z[0],z[1],z[2]);a.visible=p.visible;B.scene.add(a);B.objects[l]=a;if(p.castsShadow){var b=new THREE.ShadowVolume(D);B.scene.add(b);b.position=a.position;b.rotation=a.rotation;b.scale=a.scale}p.trigger&&"none"!=p.trigger.toLowerCase()&&(b={type:p.trigger,object:p},B.triggers[a.name]=b)}}else v=p.position,u=p.rotation,w=p.quaternion,z=p.scale,w=0,a=new THREE.Object3D,
a.name=l,a.position.set(v[0],v[1],v[2]),w?(a.quaternion.set(w[0],w[1],w[2],w[3]),a.useQuaternion=!0):a.rotation.set(u[0],u[1],u[2]),a.scale.set(z[0],z[1],z[2]),a.visible=void 0!==p.visible?p.visible:!1,B.scene.add(a),B.objects[l]=a,B.empties[l]=a,p.trigger&&"none"!=p.trigger.toLowerCase()&&(b={type:p.trigger,object:p},B.triggers[a.name]=b)}function g(a){return function(b){B.geometries[a]=b;f();H-=1;i.onLoadComplete();h()}}function e(a){return function(b){B.geometries[a]=b}}function h(){i.callbackProgress({totalModels:I,
totalTextures:K,loadedModels:I-H,loadedTextures:K-y},B);i.onLoadProgress();0==H&&0==y&&b(B)}var i=this,k=THREE.Loader.prototype.extractUrlBase(c),j,q,l,n,r,m,o,p,s,t,v,u,w,z,x,A,D,G,J,F,E,C,H,y,I,K,B;E=a;c=new THREE.BinaryLoader;C=new THREE.JSONLoader;y=H=0;B={scene:new THREE.Scene,geometries:{},materials:{},textures:{},objects:{},cameras:{},lights:{},fogs:{},triggers:{},empties:{}};if(E.transform)a=E.transform.position,s=E.transform.rotation,x=E.transform.scale,a&&B.scene.position.set(a[0],a[1],
a[2]),s&&B.scene.rotation.set(s[0],s[1],s[2]),x&&B.scene.scale.set(x[0],x[1],x[2]),(a||s||x)&&B.scene.updateMatrix();a=function(){y-=1;h();i.onLoadComplete()};for(r in E.cameras)x=E.cameras[r],"perspective"==x.type?J=new THREE.PerspectiveCamera(x.fov,x.aspect,x.near,x.far):"ortho"==x.type&&(J=new THREE.OrthographicCamera(x.left,x.right,x.top,x.bottom,x.near,x.far)),v=x.position,s=x.target,x=x.up,J.position.set(v[0],v[1],v[2]),J.target=new THREE.Vector3(s[0],s[1],s[2]),x&&J.up.set(x[0],x[1],x[2]),
B.cameras[r]=J;for(n in E.lights)s=E.lights[n],r=void 0!==s.color?s.color:16777215,J=void 0!==s.intensity?s.intensity:1,"directional"==s.type?(v=s.direction,t=new THREE.DirectionalLight(r,J),t.position.set(v[0],v[1],v[2]),t.position.normalize()):"point"==s.type?(v=s.position,t=s.distance,t=new THREE.PointLight(r,J,t),t.position.set(v[0],v[1],v[2])):"ambient"==s.type&&(t=new THREE.AmbientLight(r)),B.scene.add(t),B.lights[n]=t;for(m in E.fogs)n=E.fogs[m],"linear"==n.type?F=new THREE.Fog(0,n.near,n.far):
"exp2"==n.type&&(F=new THREE.FogExp2(0,n.density)),x=n.color,F.color.setRGB(x[0],x[1],x[2]),B.fogs[m]=F;if(B.cameras&&E.defaults.camera)B.currentCamera=B.cameras[E.defaults.camera];if(B.fogs&&E.defaults.fog)B.scene.fog=B.fogs[E.defaults.fog];x=E.defaults.bgcolor;B.bgColor=new THREE.Color;B.bgColor.setRGB(x[0],x[1],x[2]);B.bgColorAlpha=E.defaults.bgalpha;for(j in E.geometries)if(m=E.geometries[j],"bin_mesh"==m.type||"ascii_mesh"==m.type)H+=1,i.onLoadStart();I=H;for(j in E.geometries)if(m=E.geometries[j],
"cube"==m.type)D=new THREE.CubeGeometry(m.width,m.height,m.depth,m.segmentsWidth,m.segmentsHeight,m.segmentsDepth,null,m.flipped,m.sides),B.geometries[j]=D;else if("plane"==m.type)D=new THREE.PlaneGeometry(m.width,m.height,m.segmentsWidth,m.segmentsHeight),B.geometries[j]=D;else if("sphere"==m.type)D=new THREE.SphereGeometry(m.radius,m.segmentsWidth,m.segmentsHeight),B.geometries[j]=D;else if("cylinder"==m.type)D=new THREE.CylinderGeometry(m.topRad,m.botRad,m.height,m.radSegs,m.heightSegs),B.geometries[j]=
D;else if("torus"==m.type)D=new THREE.TorusGeometry(m.radius,m.tube,m.segmentsR,m.segmentsT),B.geometries[j]=D;else if("icosahedron"==m.type)D=new THREE.IcosahedronGeometry(m.radius,m.subdivisions),B.geometries[j]=D;else if("bin_mesh"==m.type)c.load(d(m.url,E.urlBaseType),g(j));else if("ascii_mesh"==m.type)C.load(d(m.url,E.urlBaseType),g(j));else if("embedded_mesh"==m.type)m=E.embeds[m.id],m.metadata=E.metadata,m&&C.createModel(m,e(j),"");for(o in E.textures)if(j=E.textures[o],j.url instanceof Array){y+=
j.url.length;for(m=0;m<j.url.length;m++)i.onLoadStart()}else y+=1,i.onLoadStart();K=y;for(o in E.textures){j=E.textures[o];if(void 0!=j.mapping&&void 0!=THREE[j.mapping])j.mapping=new THREE[j.mapping];if(j.url instanceof Array){m=[];for(F=0;F<j.url.length;F++)m[F]=d(j.url[F],E.urlBaseType);m=THREE.ImageUtils.loadTextureCube(m,j.mapping,a)}else{m=THREE.ImageUtils.loadTexture(d(j.url,E.urlBaseType),j.mapping,a);if(void 0!=THREE[j.minFilter])m.minFilter=THREE[j.minFilter];if(void 0!=THREE[j.magFilter])m.magFilter=
THREE[j.magFilter];if(j.repeat){m.repeat.set(j.repeat[0],j.repeat[1]);if(1!=j.repeat[0])m.wrapS=THREE.RepeatWrapping;if(1!=j.repeat[1])m.wrapT=THREE.RepeatWrapping}j.offset&&m.offset.set(j.offset[0],j.offset[1]);if(j.wrap){F={repeat:THREE.RepeatWrapping,mirror:THREE.MirroredRepeatWrapping};if(void 0!==F[j.wrap[0]])m.wrapS=F[j.wrap[0]];if(void 0!==F[j.wrap[1]])m.wrapT=F[j.wrap[1]]}}B.textures[o]=m}for(q in E.materials){o=E.materials[q];for(A in o.parameters)if("envMap"==A||"map"==A||"lightMap"==A)o.parameters[A]=
B.textures[o.parameters[A]];else if("shading"==A)o.parameters[A]="flat"==o.parameters[A]?THREE.FlatShading:THREE.SmoothShading;else if("blending"==A)o.parameters[A]=THREE[o.parameters[A]]?THREE[o.parameters[A]]:THREE.NormalBlending;else if("combine"==A)o.parameters[A]="MixOperation"==o.parameters[A]?THREE.MixOperation:THREE.MultiplyOperation;else if("vertexColors"==A)if("face"==o.parameters[A])o.parameters[A]=THREE.FaceColors;else if(o.parameters[A])o.parameters[A]=THREE.VertexColors;if(void 0!==
o.parameters.opacity&&1>o.parameters.opacity)o.parameters.transparent=!0;if(o.parameters.normalMap){a=THREE.ShaderUtils.lib.normal;j=THREE.UniformsUtils.clone(a.uniforms);m=o.parameters.color;F=o.parameters.specular;c=o.parameters.ambient;C=o.parameters.shininess;j.tNormal.texture=B.textures[o.parameters.normalMap];if(o.parameters.normalMapFactor)j.uNormalScale.value=o.parameters.normalMapFactor;if(o.parameters.map)j.tDiffuse.texture=o.parameters.map,j.enableDiffuse.value=!0;if(o.parameters.lightMap)j.tAO.texture=
o.parameters.lightMap,j.enableAO.value=!0;if(o.parameters.specularMap)j.tSpecular.texture=B.textures[o.parameters.specularMap],j.enableSpecular.value=!0;j.uDiffuseColor.value.setHex(m);j.uSpecularColor.value.setHex(F);j.uAmbientColor.value.setHex(c);j.uShininess.value=C;if(o.parameters.opacity)j.uOpacity.value=o.parameters.opacity;G=new THREE.ShaderMaterial({fragmentShader:a.fragmentShader,vertexShader:a.vertexShader,uniforms:j,lights:!0,fog:!0})}else G=new THREE[o.type](o.parameters);B.materials[q]=
G}f();i.callbackSync(B);h()};THREE.UTF8Loader=function(){};
THREE.UTF8Loader.prototype.load=function(a,b,c){var d=new XMLHttpRequest,f=void 0!==c.scale?c.scale:1,g=void 0!==c.offsetX?c.offsetX:0,e=void 0!==c.offsetY?c.offsetY:0,h=void 0!==c.offsetZ?c.offsetZ:0;d.onreadystatechange=function(){4==d.readyState?200==d.status||0==d.status?THREE.UTF8Loader.prototype.createModel(d.responseText,b,f,g,e,h):console.error("THREE.UTF8Loader: Couldn't load ["+a+"] ["+d.status+"]"):3!=d.readyState&&2==d.readyState&&d.getResponseHeader("Content-Length")};d.open("GET",a,
!0);d.send(null)};THREE.UTF8Loader.prototype.decompressMesh=function(a){var b=a.charCodeAt(0);57344<=b&&(b-=2048);b++;for(var c=new Float32Array(8*b),d=1,f=0;8>f;f++){for(var g=0,e=0;e<b;++e){var h=a.charCodeAt(e+d),g=g+(h>>1^-(h&1));c[8*e+f]=g}d+=b}b=a.length-d;g=new Uint16Array(b);for(f=e=0;f<b;f++)h=a.charCodeAt(f+d),g[f]=e-h,0==h&&e++;return[c,g]};
THREE.UTF8Loader.prototype.createModel=function(a,b,c,d,f,g){var e=function(){var b=this;b.materials=[];THREE.Geometry.call(this);var e=THREE.UTF8Loader.prototype.decompressMesh(a),k=[],j=[];(function(a,e,i){for(var j,k,o,p=a.length;i<p;i+=e)j=a[i],k=a[i+1],o=a[i+2],j=j/16383*c,k=k/16383*c,o=o/16383*c,j+=d,k+=f,o+=g,b.vertices.push(new THREE.Vertex(new THREE.Vector3(j,k,o)))})(e[0],8,0);(function(a,b,c){for(var d,e,f=a.length;c<f;c+=b)d=a[c],e=a[c+1],d/=1023,e/=1023,j.push(d,1-e)})(e[0],8,3);(function(a,
b,c){for(var d,e,f,g=a.length;c<g;c+=b)d=a[c],e=a[c+1],f=a[c+2],d=(d-512)/511,e=(e-512)/511,f=(f-512)/511,k.push(d,e,f)})(e[0],8,5);(function(a){var c,d,e,f,g,i,s,t,v,u=a.length;for(c=0;c<u;c+=3){d=a[c];e=a[c+1];f=a[c+2];g=b;t=d;v=e;i=f;var w=k[3*e],z=k[3*e+1],x=k[3*e+2],A=k[3*f],D=k[3*f+1],G=k[3*f+2];s=new THREE.Vector3(k[3*d],k[3*d+1],k[3*d+2]);w=new THREE.Vector3(w,z,x);A=new THREE.Vector3(A,D,G);g.faces.push(new THREE.Face3(t,v,i,[s,w,A],null,0));g=j[2*d];d=j[2*d+1];i=j[2*e];s=j[2*e+1];t=j[2*
f];v=j[2*f+1];f=b.faceVertexUvs[0];e=i;i=s;s=[];s.push(new THREE.UV(g,d));s.push(new THREE.UV(e,i));s.push(new THREE.UV(t,v));f.push(s)}})(e[1]);this.computeCentroids();this.computeFaceNormals()};e.prototype=new THREE.Geometry;e.prototype.constructor=e;b(new e)};
THREE.MarchingCubes=function(a,b){THREE.Object3D.call(this);this.material=b;this.init=function(a){this.resolution=a;this.isolation=80;this.size=a;this.size2=this.size*this.size;this.size3=this.size2*this.size;this.halfsize=this.size/2;this.delta=2/this.size;this.yd=this.size;this.zd=this.size2;this.field=new Float32Array(this.size3);this.normal_cache=new Float32Array(3*this.size3);this.vlist=new Float32Array(36);this.nlist=new Float32Array(36);this.firstDraw=!0;this.maxCount=4096;this.count=0;this.hasNormal=
this.hasPos=!1;this.positionArray=new Float32Array(3*this.maxCount);this.normalArray=new Float32Array(3*this.maxCount)};this.lerp=function(a,b,f){return a+(b-a)*f};this.VIntX=function(a,b,f,g,e,h,i,k,j,q){e=(e-j)/(q-j);j=this.normal_cache;b[g]=h+e*this.delta;b[g+1]=i;b[g+2]=k;f[g]=this.lerp(j[a],j[a+3],e);f[g+1]=this.lerp(j[a+1],j[a+4],e);f[g+2]=this.lerp(j[a+2],j[a+5],e)};this.VIntY=function(a,b,f,g,e,h,i,k,j,q){e=(e-j)/(q-j);j=this.normal_cache;b[g]=h;b[g+1]=i+e*this.delta;b[g+2]=k;b=a+3*this.yd;
f[g]=this.lerp(j[a],j[b],e);f[g+1]=this.lerp(j[a+1],j[b+1],e);f[g+2]=this.lerp(j[a+2],j[b+2],e)};this.VIntZ=function(a,b,f,g,e,h,i,k,j,q){e=(e-j)/(q-j);j=this.normal_cache;b[g]=h;b[g+1]=i;b[g+2]=k+e*this.delta;b=a+3*this.zd;f[g]=this.lerp(j[a],j[b],e);f[g+1]=this.lerp(j[a+1],j[b+1],e);f[g+2]=this.lerp(j[a+2],j[b+2],e)};this.compNorm=function(a){var b=3*a;0===this.normal_cache[b]&&(this.normal_cache[b]=this.field[a-1]-this.field[a+1],this.normal_cache[b+1]=this.field[a-this.yd]-this.field[a+this.yd],
this.normal_cache[b+2]=this.field[a-this.zd]-this.field[a+this.zd])};this.polygonize=function(a,b,f,g,e,h){var i=g+1,k=g+this.yd,j=g+this.zd,q=i+this.yd,l=i+this.zd,n=g+this.yd+this.zd,r=i+this.yd+this.zd,m=0,o=this.field[g],p=this.field[i],s=this.field[k],t=this.field[q],v=this.field[j],u=this.field[l],w=this.field[n],z=this.field[r];o<e&&(m|=1);p<e&&(m|=2);s<e&&(m|=8);t<e&&(m|=4);v<e&&(m|=16);u<e&&(m|=32);w<e&&(m|=128);z<e&&(m|=64);var x=THREE.edgeTable[m];if(0===x)return 0;var A=this.delta,D=a+
A,G=b+A,A=f+A;x&1&&(this.compNorm(g),this.compNorm(i),this.VIntX(3*g,this.vlist,this.nlist,0,e,a,b,f,o,p));x&2&&(this.compNorm(i),this.compNorm(q),this.VIntY(3*i,this.vlist,this.nlist,3,e,D,b,f,p,t));x&4&&(this.compNorm(k),this.compNorm(q),this.VIntX(3*k,this.vlist,this.nlist,6,e,a,G,f,s,t));x&8&&(this.compNorm(g),this.compNorm(k),this.VIntY(3*g,this.vlist,this.nlist,9,e,a,b,f,o,s));x&16&&(this.compNorm(j),this.compNorm(l),this.VIntX(3*j,this.vlist,this.nlist,12,e,a,b,A,v,u));x&32&&(this.compNorm(l),
this.compNorm(r),this.VIntY(3*l,this.vlist,this.nlist,15,e,D,b,A,u,z));x&64&&(this.compNorm(n),this.compNorm(r),this.VIntX(3*n,this.vlist,this.nlist,18,e,a,G,A,w,z));x&128&&(this.compNorm(j),this.compNorm(n),this.VIntY(3*j,this.vlist,this.nlist,21,e,a,b,A,v,w));x&256&&(this.compNorm(g),this.compNorm(j),this.VIntZ(3*g,this.vlist,this.nlist,24,e,a,b,f,o,v));x&512&&(this.compNorm(i),this.compNorm(l),this.VIntZ(3*i,this.vlist,this.nlist,27,e,D,b,f,p,u));x&1024&&(this.compNorm(q),this.compNorm(r),this.VIntZ(3*
q,this.vlist,this.nlist,30,e,D,G,f,t,z));x&2048&&(this.compNorm(k),this.compNorm(n),this.VIntZ(3*k,this.vlist,this.nlist,33,e,a,G,f,s,w));m<<=4;for(e=g=0;-1!=THREE.triTable[m+e];)a=m+e,b=a+1,f=a+2,this.posnormtriv(this.vlist,this.nlist,3*THREE.triTable[a],3*THREE.triTable[b],3*THREE.triTable[f],h),e+=3,g++;return g};this.posnormtriv=function(a,b,f,g,e,h){var i=3*this.count;this.positionArray[i]=a[f];this.positionArray[i+1]=a[f+1];this.positionArray[i+2]=a[f+2];this.positionArray[i+3]=a[g];this.positionArray[i+
4]=a[g+1];this.positionArray[i+5]=a[g+2];this.positionArray[i+6]=a[e];this.positionArray[i+7]=a[e+1];this.positionArray[i+8]=a[e+2];this.normalArray[i]=b[f];this.normalArray[i+1]=b[f+1];this.normalArray[i+2]=b[f+2];this.normalArray[i+3]=b[g];this.normalArray[i+4]=b[g+1];this.normalArray[i+5]=b[g+2];this.normalArray[i+6]=b[e];this.normalArray[i+7]=b[e+1];this.normalArray[i+8]=b[e+2];this.hasNormal=this.hasPos=!0;this.count+=3;this.count>=this.maxCount-3&&h(this)};this.begin=function(){this.count=0;
this.hasNormal=this.hasPos=!1};this.end=function(a){if(0!==this.count){for(var b=3*this.count;b<this.positionArray.length;b++)this.positionArray[b]=0;a(this)}};this.addBall=function(a,b,f,g,e){var h=this.size*Math.sqrt(g/e),i=f*this.size,k=b*this.size,j=a*this.size,q=Math.floor(i-h);1>q&&(q=1);i=Math.floor(i+h);i>this.size-1&&(i=this.size-1);var l=Math.floor(k-h);1>l&&(l=1);k=Math.floor(k+h);k>this.size-1&&(k=this.size-1);var n=Math.floor(j-h);1>n&&(n=1);h=Math.floor(j+h);h>this.size-1&&(h=this.size-
1);for(var r,m,o,p,s,t,v,j=q;j<i;j++){o=this.size2*j;s=j/this.size-f;t=s*s;for(q=l;q<k;q++){m=o+this.size*q;r=q/this.size-b;v=r*r;for(r=n;r<h;r++)p=r/this.size-a,p=g/(1.0E-6+p*p+v+t)-e,0<p&&(this.field[m+r]+=p)}}};this.addPlaneX=function(a,b){var f,g,e,h,i,k=this.size,j=this.yd,q=this.zd,l=this.field,n=k*Math.sqrt(a/b);n>k&&(n=k);for(f=0;f<n;f++)if(g=f/k,g*=g,h=a/(1.0E-4+g)-b,0<h)for(g=0;g<k;g++){i=f+g*j;for(e=0;e<k;e++)l[q*e+i]+=h}};this.addPlaneY=function(a,b){var f,g,e,h,i,k,j=this.size,q=this.yd,
l=this.zd,n=this.field,r=j*Math.sqrt(a/b);r>j&&(r=j);for(g=0;g<r;g++)if(f=g/j,f*=f,h=a/(1.0E-4+f)-b,0<h){i=g*q;for(f=0;f<j;f++){k=i+f;for(e=0;e<j;e++)n[l*e+k]+=h}}};this.addPlaneZ=function(a,b){var f,g,e,h,i,k,j=this.size,q=this.yd,l=this.zd,n=this.field,r=j*Math.sqrt(a/b);r>j&&(r=j);for(e=0;e<r;e++)if(f=e/j,f*=f,h=a/(1.0E-4+f)-b,0<h){i=l*e;for(g=0;g<j;g++){k=i+g*q;for(f=0;f<j;f++)n[k+f]+=h}}};this.reset=function(){var a;for(a=0;a<this.size3;a++)this.normal_cache[3*a]=0,this.field[a]=0};this.render=
function(a){this.begin();var b,f,g,e,h,i,k,j,q,l=this.size-2;for(e=1;e<l;e++){q=this.size2*e;k=(e-this.halfsize)/this.halfsize;for(g=1;g<l;g++){j=q+this.size*g;i=(g-this.halfsize)/this.halfsize;for(f=1;f<l;f++)h=(f-this.halfsize)/this.halfsize,b=j+f,this.polygonize(h,i,k,b,this.isolation,a)}}this.end(a)};this.generateGeometry=function(){var a=0,b=new THREE.Geometry,f=[];this.render(function(g){var e,h,i,k,j,q,l,n;for(e=0;e<g.count;e++)l=3*e,j=l+1,n=l+2,h=g.positionArray[l],i=g.positionArray[j],k=
g.positionArray[n],q=new THREE.Vector3(h,i,k),h=g.normalArray[l],i=g.normalArray[j],k=g.normalArray[n],l=new THREE.Vector3(h,i,k),l.normalize(),j=new THREE.Vertex(q),b.vertices.push(j),f.push(l);q=g.count/3;for(e=0;e<q;e++)l=3*(a+e),j=l+1,n=l+2,h=f[l],i=f[j],k=f[n],l=new THREE.Face3(l,j,n,[h,i,k]),b.faces.push(l);a+=q;g.count=0});return b};this.init(a)};THREE.MarchingCubes.prototype=new THREE.Object3D;THREE.MarchingCubes.prototype.constructor=THREE.MarchingCubes;
THREE.edgeTable=new Int32Array([0,265,515,778,1030,1295,1541,1804,2060,2309,2575,2822,3082,3331,3593,3840,400,153,915,666,1430,1183,1941,1692,2460,2197,2975,2710,3482,3219,3993,3728,560,825,51,314,1590,1855,1077,1340,2620,2869,2111,2358,3642,3891,3129,3376,928,681,419,170,1958,1711,1445,1196,2988,2725,2479,2214,4010,3747,3497,3232,1120,1385,1635,1898,102,367,613,876,3180,3429,3695,3942,2154,2403,2665,2912,1520,1273,2035,1786,502,255,1013,764,3580,3317,4095,3830,2554,2291,3065,2800,1616,1881,1107,
1370,598,863,85,348,3676,3925,3167,3414,2650,2899,2137,2384,1984,1737,1475,1226,966,719,453,204,4044,3781,3535,3270,3018,2755,2505,2240,2240,2505,2755,3018,3270,3535,3781,4044,204,453,719,966,1226,1475,1737,1984,2384,2137,2899,2650,3414,3167,3925,3676,348,85,863,598,1370,1107,1881,1616,2800,3065,2291,2554,3830,4095,3317,3580,764,1013,255,502,1786,2035,1273,1520,2912,2665,2403,2154,3942,3695,3429,3180,876,613,367,102,1898,1635,1385,1120,3232,3497,3747,4010,2214,2479,2725,2988,1196,1445,1711,1958,170,
419,681,928,3376,3129,3891,3642,2358,2111,2869,2620,1340,1077,1855,1590,314,51,825,560,3728,3993,3219,3482,2710,2975,2197,2460,1692,1941,1183,1430,666,915,153,400,3840,3593,3331,3082,2822,2575,2309,2060,1804,1541,1295,1030,778,515,265,0]);
THREE.triTable=new Int32Array([-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,9,8,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,2,10,0,2,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,8,3,2,10,8,10,9,8,-1,-1,-1,-1,-1,-1,-1,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,8,11,0,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,11,-1,-1,-1,-1,-1,
-1,-1,-1,-1,-1,1,11,2,1,9,11,9,8,11,-1,-1,-1,-1,-1,-1,-1,3,10,1,11,10,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,10,1,0,8,10,8,11,10,-1,-1,-1,-1,-1,-1,-1,3,9,0,3,11,9,11,10,9,-1,-1,-1,-1,-1,-1,-1,9,8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,7,3,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,1,9,4,7,1,7,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,8,4,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,4,7,3,0,4,1,2,10,-1,-1,-1,-1,-1,-1,-1,9,2,10,9,0,2,8,4,7,
-1,-1,-1,-1,-1,-1,-1,2,10,9,2,9,7,2,7,3,7,9,4,-1,-1,-1,-1,8,4,7,3,11,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,4,7,11,2,4,2,0,4,-1,-1,-1,-1,-1,-1,-1,9,0,1,8,4,7,2,3,11,-1,-1,-1,-1,-1,-1,-1,4,7,11,9,4,11,9,11,2,9,2,1,-1,-1,-1,-1,3,10,1,3,11,10,7,8,4,-1,-1,-1,-1,-1,-1,-1,1,11,10,1,4,11,1,0,4,7,11,4,-1,-1,-1,-1,4,7,8,9,0,11,9,11,10,11,0,3,-1,-1,-1,-1,4,7,11,4,11,9,9,11,10,-1,-1,-1,-1,-1,-1,-1,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,5,4,1,5,0,-1,-1,-1,-1,-1,-1,
-1,-1,-1,-1,8,5,4,8,3,5,3,1,5,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,10,4,9,5,-1,-1,-1,-1,-1,-1,-1,5,2,10,5,4,2,4,0,2,-1,-1,-1,-1,-1,-1,-1,2,10,5,3,2,5,3,5,4,3,4,8,-1,-1,-1,-1,9,5,4,2,3,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,11,2,0,8,11,4,9,5,-1,-1,-1,-1,-1,-1,-1,0,5,4,0,1,5,2,3,11,-1,-1,-1,-1,-1,-1,-1,2,1,5,2,5,8,2,8,11,4,8,5,-1,-1,-1,-1,10,3,11,10,1,3,9,5,4,-1,-1,-1,-1,-1,-1,-1,4,9,5,0,8,1,8,10,1,8,11,10,-1,-1,-1,-1,5,4,0,5,0,11,5,11,10,11,0,3,-1,-1,-1,-1,5,4,8,5,
8,10,10,8,11,-1,-1,-1,-1,-1,-1,-1,9,7,8,5,7,9,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,3,0,9,5,3,5,7,3,-1,-1,-1,-1,-1,-1,-1,0,7,8,0,1,7,1,5,7,-1,-1,-1,-1,-1,-1,-1,1,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,7,8,9,5,7,10,1,2,-1,-1,-1,-1,-1,-1,-1,10,1,2,9,5,0,5,3,0,5,7,3,-1,-1,-1,-1,8,0,2,8,2,5,8,5,7,10,5,2,-1,-1,-1,-1,2,10,5,2,5,3,3,5,7,-1,-1,-1,-1,-1,-1,-1,7,9,5,7,8,9,3,11,2,-1,-1,-1,-1,-1,-1,-1,9,5,7,9,7,2,9,2,0,2,7,11,-1,-1,-1,-1,2,3,11,0,1,8,1,7,8,1,5,7,-1,-1,-1,-1,11,2,1,11,1,7,7,1,5,-1,-1,-1,-1,-1,-1,
-1,9,5,8,8,5,7,10,1,3,10,3,11,-1,-1,-1,-1,5,7,0,5,0,9,7,11,0,1,0,10,11,10,0,-1,11,10,0,11,0,3,10,5,0,8,0,7,5,7,0,-1,11,10,5,7,11,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,6,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,0,1,5,10,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,8,3,1,9,8,5,10,6,-1,-1,-1,-1,-1,-1,-1,1,6,5,2,6,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,6,5,1,2,6,3,0,8,-1,-1,-1,-1,-1,-1,-1,9,6,5,9,0,6,0,2,6,-1,-1,-1,-1,-1,-1,-1,5,9,8,5,8,2,5,2,6,3,2,8,-1,-1,-1,-1,2,3,11,10,6,
5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,0,8,11,2,0,10,6,5,-1,-1,-1,-1,-1,-1,-1,0,1,9,2,3,11,5,10,6,-1,-1,-1,-1,-1,-1,-1,5,10,6,1,9,2,9,11,2,9,8,11,-1,-1,-1,-1,6,3,11,6,5,3,5,1,3,-1,-1,-1,-1,-1,-1,-1,0,8,11,0,11,5,0,5,1,5,11,6,-1,-1,-1,-1,3,11,6,0,3,6,0,6,5,0,5,9,-1,-1,-1,-1,6,5,9,6,9,11,11,9,8,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,3,0,4,7,3,6,5,10,-1,-1,-1,-1,-1,-1,-1,1,9,0,5,10,6,8,4,7,-1,-1,-1,-1,-1,-1,-1,10,6,5,1,9,7,1,7,3,7,9,4,-1,-1,-1,-1,6,1,2,6,5,1,4,7,8,-1,-1,-1,-1,
-1,-1,-1,1,2,5,5,2,6,3,0,4,3,4,7,-1,-1,-1,-1,8,4,7,9,0,5,0,6,5,0,2,6,-1,-1,-1,-1,7,3,9,7,9,4,3,2,9,5,9,6,2,6,9,-1,3,11,2,7,8,4,10,6,5,-1,-1,-1,-1,-1,-1,-1,5,10,6,4,7,2,4,2,0,2,7,11,-1,-1,-1,-1,0,1,9,4,7,8,2,3,11,5,10,6,-1,-1,-1,-1,9,2,1,9,11,2,9,4,11,7,11,4,5,10,6,-1,8,4,7,3,11,5,3,5,1,5,11,6,-1,-1,-1,-1,5,1,11,5,11,6,1,0,11,7,11,4,0,4,11,-1,0,5,9,0,6,5,0,3,6,11,6,3,8,4,7,-1,6,5,9,6,9,11,4,7,9,7,11,9,-1,-1,-1,-1,10,4,9,6,4,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,10,6,4,9,10,0,8,3,-1,-1,-1,-1,-1,-1,-1,
10,0,1,10,6,0,6,4,0,-1,-1,-1,-1,-1,-1,-1,8,3,1,8,1,6,8,6,4,6,1,10,-1,-1,-1,-1,1,4,9,1,2,4,2,6,4,-1,-1,-1,-1,-1,-1,-1,3,0,8,1,2,9,2,4,9,2,6,4,-1,-1,-1,-1,0,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,3,2,8,2,4,4,2,6,-1,-1,-1,-1,-1,-1,-1,10,4,9,10,6,4,11,2,3,-1,-1,-1,-1,-1,-1,-1,0,8,2,2,8,11,4,9,10,4,10,6,-1,-1,-1,-1,3,11,2,0,1,6,0,6,4,6,1,10,-1,-1,-1,-1,6,4,1,6,1,10,4,8,1,2,1,11,8,11,1,-1,9,6,4,9,3,6,9,1,3,11,6,3,-1,-1,-1,-1,8,11,1,8,1,0,11,6,1,9,1,4,6,4,1,-1,3,11,6,3,6,0,0,6,4,-1,-1,-1,-1,-1,-1,-1,
6,4,8,11,6,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,10,6,7,8,10,8,9,10,-1,-1,-1,-1,-1,-1,-1,0,7,3,0,10,7,0,9,10,6,7,10,-1,-1,-1,-1,10,6,7,1,10,7,1,7,8,1,8,0,-1,-1,-1,-1,10,6,7,10,7,1,1,7,3,-1,-1,-1,-1,-1,-1,-1,1,2,6,1,6,8,1,8,9,8,6,7,-1,-1,-1,-1,2,6,9,2,9,1,6,7,9,0,9,3,7,3,9,-1,7,8,0,7,0,6,6,0,2,-1,-1,-1,-1,-1,-1,-1,7,3,2,6,7,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,11,10,6,8,10,8,9,8,6,7,-1,-1,-1,-1,2,0,7,2,7,11,0,9,7,6,7,10,9,10,7,-1,1,8,0,1,7,8,1,10,7,6,7,10,2,3,11,-1,11,2,1,11,1,7,10,6,1,6,7,1,-1,-1,-1,-1,
8,9,6,8,6,7,9,1,6,11,6,3,1,3,6,-1,0,9,1,11,6,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,8,0,7,0,6,3,11,0,11,6,0,-1,-1,-1,-1,7,11,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,8,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,1,9,11,7,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,1,9,8,3,1,11,7,6,-1,-1,-1,-1,-1,-1,-1,10,1,2,6,11,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,10,3,0,8,6,11,7,-1,-1,-1,-1,-1,-1,-1,2,9,0,2,10,9,6,11,7,-1,-1,-1,-1,-1,-1,-1,6,11,7,2,10,3,10,8,3,10,9,8,-1,-1,-1,-1,7,
2,3,6,2,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,7,0,8,7,6,0,6,2,0,-1,-1,-1,-1,-1,-1,-1,2,7,6,2,3,7,0,1,9,-1,-1,-1,-1,-1,-1,-1,1,6,2,1,8,6,1,9,8,8,7,6,-1,-1,-1,-1,10,7,6,10,1,7,1,3,7,-1,-1,-1,-1,-1,-1,-1,10,7,6,1,7,10,1,8,7,1,0,8,-1,-1,-1,-1,0,3,7,0,7,10,0,10,9,6,10,7,-1,-1,-1,-1,7,6,10,7,10,8,8,10,9,-1,-1,-1,-1,-1,-1,-1,6,8,4,11,8,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,6,11,3,0,6,0,4,6,-1,-1,-1,-1,-1,-1,-1,8,6,11,8,4,6,9,0,1,-1,-1,-1,-1,-1,-1,-1,9,4,6,9,6,3,9,3,1,11,3,6,-1,-1,-1,-1,6,8,4,6,11,8,2,10,1,-1,-1,-1,
-1,-1,-1,-1,1,2,10,3,0,11,0,6,11,0,4,6,-1,-1,-1,-1,4,11,8,4,6,11,0,2,9,2,10,9,-1,-1,-1,-1,10,9,3,10,3,2,9,4,3,11,3,6,4,6,3,-1,8,2,3,8,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,0,4,2,4,6,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,9,0,2,3,4,2,4,6,4,3,8,-1,-1,-1,-1,1,9,4,1,4,2,2,4,6,-1,-1,-1,-1,-1,-1,-1,8,1,3,8,6,1,8,4,6,6,10,1,-1,-1,-1,-1,10,1,0,10,0,6,6,0,4,-1,-1,-1,-1,-1,-1,-1,4,6,3,4,3,8,6,10,3,0,3,9,10,9,3,-1,10,9,4,6,10,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,5,7,6,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,5,11,7,6,
-1,-1,-1,-1,-1,-1,-1,5,0,1,5,4,0,7,6,11,-1,-1,-1,-1,-1,-1,-1,11,7,6,8,3,4,3,5,4,3,1,5,-1,-1,-1,-1,9,5,4,10,1,2,7,6,11,-1,-1,-1,-1,-1,-1,-1,6,11,7,1,2,10,0,8,3,4,9,5,-1,-1,-1,-1,7,6,11,5,4,10,4,2,10,4,0,2,-1,-1,-1,-1,3,4,8,3,5,4,3,2,5,10,5,2,11,7,6,-1,7,2,3,7,6,2,5,4,9,-1,-1,-1,-1,-1,-1,-1,9,5,4,0,8,6,0,6,2,6,8,7,-1,-1,-1,-1,3,6,2,3,7,6,1,5,0,5,4,0,-1,-1,-1,-1,6,2,8,6,8,7,2,1,8,4,8,5,1,5,8,-1,9,5,4,10,1,6,1,7,6,1,3,7,-1,-1,-1,-1,1,6,10,1,7,6,1,0,7,8,7,0,9,5,4,-1,4,0,10,4,10,5,0,3,10,6,10,7,3,7,10,
-1,7,6,10,7,10,8,5,4,10,4,8,10,-1,-1,-1,-1,6,9,5,6,11,9,11,8,9,-1,-1,-1,-1,-1,-1,-1,3,6,11,0,6,3,0,5,6,0,9,5,-1,-1,-1,-1,0,11,8,0,5,11,0,1,5,5,6,11,-1,-1,-1,-1,6,11,3,6,3,5,5,3,1,-1,-1,-1,-1,-1,-1,-1,1,2,10,9,5,11,9,11,8,11,5,6,-1,-1,-1,-1,0,11,3,0,6,11,0,9,6,5,6,9,1,2,10,-1,11,8,5,11,5,6,8,0,5,10,5,2,0,2,5,-1,6,11,3,6,3,5,2,10,3,10,5,3,-1,-1,-1,-1,5,8,9,5,2,8,5,6,2,3,8,2,-1,-1,-1,-1,9,5,6,9,6,0,0,6,2,-1,-1,-1,-1,-1,-1,-1,1,5,8,1,8,0,5,6,8,3,8,2,6,2,8,-1,1,5,6,2,1,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
1,3,6,1,6,10,3,8,6,5,6,9,8,9,6,-1,10,1,0,10,0,6,9,5,0,5,6,0,-1,-1,-1,-1,0,3,8,5,6,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,10,5,6,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,7,5,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,11,5,10,11,7,5,8,3,0,-1,-1,-1,-1,-1,-1,-1,5,11,7,5,10,11,1,9,0,-1,-1,-1,-1,-1,-1,-1,10,7,5,10,11,7,9,8,1,8,3,1,-1,-1,-1,-1,11,1,2,11,7,1,7,5,1,-1,-1,-1,-1,-1,-1,-1,0,8,3,1,2,7,1,7,5,7,2,11,-1,-1,-1,-1,9,7,5,9,2,7,9,0,2,2,11,7,-1,-1,-1,-1,7,5,2,7,2,11,5,9,2,3,2,8,9,8,2,-1,2,5,10,2,3,5,3,7,5,-1,-1,
-1,-1,-1,-1,-1,8,2,0,8,5,2,8,7,5,10,2,5,-1,-1,-1,-1,9,0,1,5,10,3,5,3,7,3,10,2,-1,-1,-1,-1,9,8,2,9,2,1,8,7,2,10,2,5,7,5,2,-1,1,3,5,3,7,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,8,7,0,7,1,1,7,5,-1,-1,-1,-1,-1,-1,-1,9,0,3,9,3,5,5,3,7,-1,-1,-1,-1,-1,-1,-1,9,8,7,5,9,7,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5,8,4,5,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,5,0,4,5,11,0,5,10,11,11,3,0,-1,-1,-1,-1,0,1,9,8,4,10,8,10,11,10,4,5,-1,-1,-1,-1,10,11,4,10,4,5,11,3,4,9,4,1,3,1,4,-1,2,5,1,2,8,5,2,11,8,4,5,8,-1,-1,-1,-1,0,4,11,0,11,3,4,5,11,
2,11,1,5,1,11,-1,0,2,5,0,5,9,2,11,5,4,5,8,11,8,5,-1,9,4,5,2,11,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,5,10,3,5,2,3,4,5,3,8,4,-1,-1,-1,-1,5,10,2,5,2,4,4,2,0,-1,-1,-1,-1,-1,-1,-1,3,10,2,3,5,10,3,8,5,4,5,8,0,1,9,-1,5,10,2,5,2,4,1,9,2,9,4,2,-1,-1,-1,-1,8,4,5,8,5,3,3,5,1,-1,-1,-1,-1,-1,-1,-1,0,4,5,1,0,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,4,5,8,5,3,9,0,5,0,3,5,-1,-1,-1,-1,9,4,5,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,11,7,4,9,11,9,10,11,-1,-1,-1,-1,-1,-1,-1,0,8,3,4,9,7,9,11,7,9,10,11,-1,-1,-1,-1,1,10,11,1,11,
4,1,4,0,7,4,11,-1,-1,-1,-1,3,1,4,3,4,8,1,10,4,7,4,11,10,11,4,-1,4,11,7,9,11,4,9,2,11,9,1,2,-1,-1,-1,-1,9,7,4,9,11,7,9,1,11,2,11,1,0,8,3,-1,11,7,4,11,4,2,2,4,0,-1,-1,-1,-1,-1,-1,-1,11,7,4,11,4,2,8,3,4,3,2,4,-1,-1,-1,-1,2,9,10,2,7,9,2,3,7,7,4,9,-1,-1,-1,-1,9,10,7,9,7,4,10,2,7,8,7,0,2,0,7,-1,3,7,10,3,10,2,7,4,10,1,10,0,4,0,10,-1,1,10,2,8,7,4,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,7,1,3,-1,-1,-1,-1,-1,-1,-1,4,9,1,4,1,7,0,8,1,8,7,1,-1,-1,-1,-1,4,0,3,7,4,3,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,4,8,7,-1,-1,-1,
-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,9,10,8,10,11,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,11,9,10,-1,-1,-1,-1,-1,-1,-1,0,1,10,0,10,8,8,10,11,-1,-1,-1,-1,-1,-1,-1,3,1,10,11,3,10,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,2,11,1,11,9,9,11,8,-1,-1,-1,-1,-1,-1,-1,3,0,9,3,9,11,1,2,9,2,11,9,-1,-1,-1,-1,0,2,11,8,0,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,2,11,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,10,8,9,-1,-1,-1,-1,-1,-1,-1,9,10,2,0,9,2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,3,8,2,8,10,0,1,8,1,10,8,-1,-1,-1,-1,1,10,
2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,1,3,8,9,1,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,9,1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,0,3,8,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1]);THREE.LensFlare=function(a,b,c,d,f){THREE.Object3D.call(this);this.lensFlares=[];this.positionScreen=new THREE.Vector3;this.customUpdateCallback=void 0;void 0!==a&&this.add(a,b,c,d,f)};THREE.LensFlare.prototype=new THREE.Object3D;THREE.LensFlare.prototype.constructor=THREE.LensFlare;
THREE.LensFlare.prototype.supr=THREE.Object3D.prototype;THREE.LensFlare.prototype.add=function(a,b,c,d,f,g){void 0===b&&(b=-1);void 0===c&&(c=0);void 0===g&&(g=1);void 0===f&&(f=new THREE.Color(16777215));if(void 0===d)d=THREE.NormalBlending;c=Math.min(c,Math.max(0,c));this.lensFlares.push({texture:a,size:b,distance:c,x:0,y:0,z:0,scale:1,rotation:1,opacity:g,color:f,blending:d})};
THREE.LensFlare.prototype.updateLensFlares=function(){var a,b=this.lensFlares.length,c,d=2*-this.positionScreen.x,f=2*-this.positionScreen.y;for(a=0;a<b;a++)c=this.lensFlares[a],c.x=this.positionScreen.x+d*c.distance,c.y=this.positionScreen.y+f*c.distance,c.wantedRotation=0.25*c.x*Math.PI,c.rotation+=0.25*(c.wantedRotation-c.rotation)};
THREE.LensFlarePlugin=function(){function a(a){var c=b.createProgram(),d=b.createShader(b.FRAGMENT_SHADER),e=b.createShader(b.VERTEX_SHADER);b.shaderSource(d,a.fragmentShader);b.shaderSource(e,a.vertexShader);b.compileShader(d);b.compileShader(e);b.attachShader(c,d);b.attachShader(c,e);b.linkProgram(c);return c}var b,c,d,f,g,e,h,i,k,j,q,l,n;this.init=function(r){b=r.context;c=r;d=new Float32Array(16);f=new Uint16Array(6);r=0;d[r++]=-1;d[r++]=-1;d[r++]=0;d[r++]=0;d[r++]=1;d[r++]=-1;d[r++]=1;d[r++]=
0;d[r++]=1;d[r++]=1;d[r++]=1;d[r++]=1;d[r++]=-1;d[r++]=1;d[r++]=0;d[r++]=1;r=0;f[r++]=0;f[r++]=1;f[r++]=2;f[r++]=0;f[r++]=2;f[r++]=3;g=b.createBuffer();e=b.createBuffer();b.bindBuffer(b.ARRAY_BUFFER,g);b.bufferData(b.ARRAY_BUFFER,d,b.STATIC_DRAW);b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,e);b.bufferData(b.ELEMENT_ARRAY_BUFFER,f,b.STATIC_DRAW);h=b.createTexture();i=b.createTexture();b.bindTexture(b.TEXTURE_2D,h);b.texImage2D(b.TEXTURE_2D,0,b.RGB,16,16,0,b.RGB,b.UNSIGNED_BYTE,null);b.texParameteri(b.TEXTURE_2D,
b.TEXTURE_WRAP_S,b.CLAMP_TO_EDGE);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_T,b.CLAMP_TO_EDGE);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MAG_FILTER,b.NEAREST);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MIN_FILTER,b.NEAREST);b.bindTexture(b.TEXTURE_2D,i);b.texImage2D(b.TEXTURE_2D,0,b.RGBA,16,16,0,b.RGBA,b.UNSIGNED_BYTE,null);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_S,b.CLAMP_TO_EDGE);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_WRAP_T,b.CLAMP_TO_EDGE);b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MAG_FILTER,b.NEAREST);
b.texParameteri(b.TEXTURE_2D,b.TEXTURE_MIN_FILTER,b.NEAREST);0>=b.getParameter(b.MAX_VERTEX_TEXTURE_IMAGE_UNITS)?(k=!1,j=a(THREE.ShaderFlares.lensFlare)):(k=!0,j=a(THREE.ShaderFlares.lensFlareVertexTexture));q={};l={};q.vertex=b.getAttribLocation(j,"position");q.uv=b.getAttribLocation(j,"uv");l.renderType=b.getUniformLocation(j,"renderType");l.map=b.getUniformLocation(j,"map");l.occlusionMap=b.getUniformLocation(j,"occlusionMap");l.opacity=b.getUniformLocation(j,"opacity");l.color=b.getUniformLocation(j,
"color");l.scale=b.getUniformLocation(j,"scale");l.rotation=b.getUniformLocation(j,"rotation");l.screenPosition=b.getUniformLocation(j,"screenPosition");n=!1};this.render=function(a,d,f,p){var a=a.__webglFlares,s=a.length;if(s){var t=new THREE.Vector3,v=p/f,u=0.5*f,w=0.5*p,z=16/p,x=new THREE.Vector2(z*v,z),A=new THREE.Vector3(1,1,0),D=new THREE.Vector2(1,1),G=l,z=q;b.useProgram(j);n||(b.enableVertexAttribArray(q.vertex),b.enableVertexAttribArray(q.uv),n=!0);b.uniform1i(G.occlusionMap,0);b.uniform1i(G.map,
1);b.bindBuffer(b.ARRAY_BUFFER,g);b.vertexAttribPointer(z.vertex,2,b.FLOAT,!1,16,0);b.vertexAttribPointer(z.uv,2,b.FLOAT,!1,16,8);b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,e);b.disable(b.CULL_FACE);b.depthMask(!1);var J,F,E,C,H;for(J=0;J<s;J++)if(z=16/p,x.set(z*v,z),C=a[J],t.set(C.matrixWorld.n14,C.matrixWorld.n24,C.matrixWorld.n34),d.matrixWorldInverse.multiplyVector3(t),d.projectionMatrix.multiplyVector3(t),A.copy(t),D.x=A.x*u+u,D.y=A.y*w+w,k||0<D.x&&D.x<f&&0<D.y&&D.y<p){b.activeTexture(b.TEXTURE1);b.bindTexture(b.TEXTURE_2D,
h);b.copyTexImage2D(b.TEXTURE_2D,0,b.RGB,D.x-8,D.y-8,16,16,0);b.uniform1i(G.renderType,0);b.uniform2f(G.scale,x.x,x.y);b.uniform3f(G.screenPosition,A.x,A.y,A.z);b.disable(b.BLEND);b.enable(b.DEPTH_TEST);b.drawElements(b.TRIANGLES,6,b.UNSIGNED_SHORT,0);b.activeTexture(b.TEXTURE0);b.bindTexture(b.TEXTURE_2D,i);b.copyTexImage2D(b.TEXTURE_2D,0,b.RGBA,D.x-8,D.y-8,16,16,0);b.uniform1i(G.renderType,1);b.disable(b.DEPTH_TEST);b.activeTexture(b.TEXTURE1);b.bindTexture(b.TEXTURE_2D,h);b.drawElements(b.TRIANGLES,
6,b.UNSIGNED_SHORT,0);C.positionScreen.copy(A);C.customUpdateCallback?C.customUpdateCallback(C):C.updateLensFlares();b.uniform1i(G.renderType,2);b.enable(b.BLEND);for(F=0,E=C.lensFlares.length;F<E;F++)if(H=C.lensFlares[F],0.001<H.opacity&&0.001<H.scale)A.x=H.x,A.y=H.y,A.z=H.z,z=H.size*H.scale/p,x.x=z*v,x.y=z,b.uniform3f(G.screenPosition,A.x,A.y,A.z),b.uniform2f(G.scale,x.x,x.y),b.uniform1f(G.rotation,H.rotation),b.uniform1f(G.opacity,H.opacity),b.uniform3f(G.color,H.color.r,H.color.g,H.color.b),c.setBlending(H.blending),
c.setTexture(H.texture,1),b.drawElements(b.TRIANGLES,6,b.UNSIGNED_SHORT,0)}b.enable(b.CULL_FACE);b.enable(b.DEPTH_TEST);b.depthMask(!0)}}};
THREE.ShadowMapPlugin=function(){var a,b,c,d,f=new THREE.Frustum,g=new THREE.Matrix4,e=new THREE.Vector3,h=new THREE.Vector3;this.init=function(e){a=e.context;b=e;var e=THREE.ShaderLib.depthRGBA,f=THREE.UniformsUtils.clone(e.uniforms);c=new THREE.ShaderMaterial({fragmentShader:e.fragmentShader,vertexShader:e.vertexShader,uniforms:f});d=new THREE.ShaderMaterial({fragmentShader:e.fragmentShader,vertexShader:e.vertexShader,uniforms:f,morphTargets:!0});c._shadowPass=!0;d._shadowPass=!0};this.render=function(a,
c){b.shadowMapEnabled&&b.shadowMapAutoUpdate&&this.update(a,c)};this.update=function(i,k){var j,q,l,n,r,m,o,p,s,t=[];n=0;a.clearColor(1,1,1,1);a.disable(a.BLEND);b.shadowMapCullFrontFaces&&a.cullFace(a.FRONT);b.setDepthTest(!0);for(j=0,q=i.__lights.length;j<q;j++)if(l=i.__lights[j],l.castShadow)if(l instanceof THREE.DirectionalLight&&l.shadowCascade)for(r=0;r<l.shadowCascadeCount;r++){var v;if(l.shadowCascadeArray[r])v=l.shadowCascadeArray[r];else{s=l;o=r;v=new THREE.DirectionalLight;v.isVirtual=
!0;v.onlyShadow=!0;v.castShadow=!0;v.shadowCameraNear=s.shadowCameraNear;v.shadowCameraFar=s.shadowCameraFar;v.shadowCameraLeft=s.shadowCameraLeft;v.shadowCameraRight=s.shadowCameraRight;v.shadowCameraBottom=s.shadowCameraBottom;v.shadowCameraTop=s.shadowCameraTop;v.shadowCameraVisible=s.shadowCameraVisible;v.shadowDarkness=s.shadowDarkness;v.shadowBias=s.shadowCascadeBias[o];v.shadowMapWidth=s.shadowCascadeWidth[o];v.shadowMapHeight=s.shadowCascadeHeight[o];v.pointsWorld=[];v.pointsFrustum=[];p=
v.pointsWorld;m=v.pointsFrustum;for(var u=0;8>u;u++)p[u]=new THREE.Vector3,m[u]=new THREE.Vector3;p=s.shadowCascadeNearZ[o];s=s.shadowCascadeFarZ[o];m[0].set(-1,-1,p);m[1].set(1,-1,p);m[2].set(-1,1,p);m[3].set(1,1,p);m[4].set(-1,-1,s);m[5].set(1,-1,s);m[6].set(-1,1,s);m[7].set(1,1,s);v.originalCamera=k;m=new THREE.Gyroscope;m.position=l.shadowCascadeOffset;m.add(v);m.add(v.target);k.add(m);l.shadowCascadeArray[r]=v;console.log("Created virtualLight",v)}o=l;p=r;s=o.shadowCascadeArray[p];s.position.copy(o.position);
s.target.position.copy(o.target.position);s.lookAt(s.target);s.shadowCameraVisible=o.shadowCameraVisible;s.shadowDarkness=o.shadowDarkness;s.shadowBias=o.shadowCascadeBias[p];m=o.shadowCascadeNearZ[p];o=o.shadowCascadeFarZ[p];s=s.pointsFrustum;s[0].z=m;s[1].z=m;s[2].z=m;s[3].z=m;s[4].z=o;s[5].z=o;s[6].z=o;s[7].z=o;t[n]=v;n++}else t[n]=l,n++;for(j=0,q=t.length;j<q;j++){l=t[j];if(!l.shadowMap)l.shadowMap=new THREE.WebGLRenderTarget(l.shadowMapWidth,l.shadowMapHeight,{minFilter:THREE.LinearFilter,magFilter:THREE.LinearFilter,
format:THREE.RGBAFormat}),l.shadowMapSize=new THREE.Vector2(l.shadowMapWidth,l.shadowMapHeight),l.shadowMatrix=new THREE.Matrix4;if(!l.shadowCamera){if(l instanceof THREE.SpotLight)l.shadowCamera=new THREE.PerspectiveCamera(l.shadowCameraFov,l.shadowMapWidth/l.shadowMapHeight,l.shadowCameraNear,l.shadowCameraFar);else if(l instanceof THREE.DirectionalLight)l.shadowCamera=new THREE.OrthographicCamera(l.shadowCameraLeft,l.shadowCameraRight,l.shadowCameraTop,l.shadowCameraBottom,l.shadowCameraNear,l.shadowCameraFar);
else{console.error("Unsupported light type for shadow");continue}i.add(l.shadowCamera);b.autoUpdateScene&&i.updateMatrixWorld()}if(l.shadowCameraVisible&&!l.cameraHelper)l.cameraHelper=new THREE.CameraHelper(l.shadowCamera),l.shadowCamera.add(l.cameraHelper);if(l.isVirtual&&v.originalCamera==k){r=k;n=l.shadowCamera;m=l.pointsFrustum;s=l.pointsWorld;e.set(Infinity,Infinity,Infinity);h.set(-Infinity,-Infinity,-Infinity);for(o=0;8>o;o++){p=s[o];p.copy(m[o]);THREE.ShadowMapPlugin.__projector.unprojectVector(p,
r);n.matrixWorldInverse.multiplyVector3(p);if(p.x<e.x)e.x=p.x;if(p.x>h.x)h.x=p.x;if(p.y<e.y)e.y=p.y;if(p.y>h.y)h.y=p.y;if(p.z<e.z)e.z=p.z;if(p.z>h.z)h.z=p.z}n.left=e.x;n.right=h.x;n.top=h.y;n.bottom=e.y;n.updateProjectionMatrix()}n=l.shadowMap;m=l.shadowMatrix;r=l.shadowCamera;r.position.copy(l.matrixWorld.getPosition());r.lookAt(l.target.matrixWorld.getPosition());r.updateMatrixWorld();r.matrixWorldInverse.getInverse(r.matrixWorld);if(l.cameraHelper)l.cameraHelper.lines.visible=l.shadowCameraVisible;
l.shadowCameraVisible&&l.cameraHelper.update(l.shadowCamera);m.set(0.5,0,0,0.5,0,0.5,0,0.5,0,0,0.5,0.5,0,0,0,1);m.multiplySelf(r.projectionMatrix);m.multiplySelf(r.matrixWorldInverse);if(!r._viewMatrixArray)r._viewMatrixArray=new Float32Array(16);r.matrixWorldInverse.flattenToArray(r._viewMatrixArray);if(!r._projectionMatrixArray)r._projectionMatrixArray=new Float32Array(16);r.projectionMatrix.flattenToArray(r._projectionMatrixArray);g.multiply(r.projectionMatrix,r.matrixWorldInverse);f.setFromMatrix(g);
b.setRenderTarget(n);b.clear();s=i.__webglObjects;for(l=0,n=s.length;l<n;l++)if(o=s[l],m=o.object,o.render=!1,m.visible&&m.castShadow&&(!(m instanceof THREE.Mesh)||!m.frustumCulled||f.contains(m)))m.matrixWorld.flattenToArray(m._objectMatrixArray),m._modelViewMatrix.multiplyToArray(r.matrixWorldInverse,m.matrixWorld,m._modelViewMatrixArray),o.render=!0;for(l=0,n=s.length;l<n;l++)if(o=s[l],o.render)m=o.object,o=o.buffer,b.setObjectFaces(m),p=m.customDepthMaterial?m.customDepthMaterial:m.geometry.morphTargets.length?
d:c,o instanceof THREE.BufferGeometry?b.renderBufferDirect(r,i.__lights,null,p,o,m):b.renderBuffer(r,i.__lights,null,p,o,m);s=i.__webglObjectsImmediate;for(l=0,n=s.length;l<n;l++)o=s[l],m=o.object,m.visible&&m.castShadow&&(m.matrixAutoUpdate&&m.matrixWorld.flattenToArray(m._objectMatrixArray),m._modelViewMatrix.multiplyToArray(r.matrixWorldInverse,m.matrixWorld,m._modelViewMatrixArray),b.renderImmediateObject(r,i.__lights,null,c,m))}j=b.getClearColor();q=b.getClearAlpha();a.clearColor(j.r,j.g,j.b,
q);a.enable(a.BLEND);b.shadowMapCullFrontFaces&&a.cullFace(a.BACK)}};THREE.ShadowMapPlugin.__projector=new THREE.Projector;
THREE.SpritePlugin=function(){function a(a,b){return b.z-a.z}var b,c,d,f,g,e,h,i,k,j;this.init=function(a){b=a.context;c=a;d=new Float32Array(16);f=new Uint16Array(6);a=0;d[a++]=-1;d[a++]=-1;d[a++]=0;d[a++]=1;d[a++]=1;d[a++]=-1;d[a++]=1;d[a++]=1;d[a++]=1;d[a++]=1;d[a++]=1;d[a++]=0;d[a++]=-1;d[a++]=1;d[a++]=0;a=d[a++]=0;f[a++]=0;f[a++]=1;f[a++]=2;f[a++]=0;f[a++]=2;f[a++]=3;g=b.createBuffer();e=b.createBuffer();b.bindBuffer(b.ARRAY_BUFFER,g);b.bufferData(b.ARRAY_BUFFER,d,b.STATIC_DRAW);b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,
e);b.bufferData(b.ELEMENT_ARRAY_BUFFER,f,b.STATIC_DRAW);var a=THREE.ShaderSprite.sprite,l=b.createProgram(),n=b.createShader(b.FRAGMENT_SHADER),r=b.createShader(b.VERTEX_SHADER);b.shaderSource(n,a.fragmentShader);b.shaderSource(r,a.vertexShader);b.compileShader(n);b.compileShader(r);b.attachShader(l,n);b.attachShader(l,r);b.linkProgram(l);h=l;i={};k={};i.position=b.getAttribLocation(h,"position");i.uv=b.getAttribLocation(h,"uv");k.uvOffset=b.getUniformLocation(h,"uvOffset");k.uvScale=b.getUniformLocation(h,
"uvScale");k.rotation=b.getUniformLocation(h,"rotation");k.scale=b.getUniformLocation(h,"scale");k.alignment=b.getUniformLocation(h,"alignment");k.color=b.getUniformLocation(h,"color");k.map=b.getUniformLocation(h,"map");k.opacity=b.getUniformLocation(h,"opacity");k.useScreenCoordinates=b.getUniformLocation(h,"useScreenCoordinates");k.affectedByDistance=b.getUniformLocation(h,"affectedByDistance");k.screenPosition=b.getUniformLocation(h,"screenPosition");k.modelViewMatrix=b.getUniformLocation(h,"modelViewMatrix");
k.projectionMatrix=b.getUniformLocation(h,"projectionMatrix");j=!1};this.render=function(d,f,n,r){var d=d.__webglSprites,m=d.length;if(m){var o=i,p=k,s=r/n,n=0.5*n,t=0.5*r,v=!0;b.useProgram(h);j||(b.enableVertexAttribArray(o.position),b.enableVertexAttribArray(o.uv),j=!0);b.disable(b.CULL_FACE);b.enable(b.BLEND);b.depthMask(!0);b.bindBuffer(b.ARRAY_BUFFER,g);b.vertexAttribPointer(o.position,2,b.FLOAT,!1,16,0);b.vertexAttribPointer(o.uv,2,b.FLOAT,!1,16,8);b.bindBuffer(b.ELEMENT_ARRAY_BUFFER,e);b.uniformMatrix4fv(p.projectionMatrix,
!1,f._projectionMatrixArray);b.activeTexture(b.TEXTURE0);b.uniform1i(p.map,0);for(var u,w=[],o=0;o<m;o++)if(u=d[o],u.visible&&0!==u.opacity)u.useScreenCoordinates?u.z=-u.position.z:(u._modelViewMatrix.multiplyToArray(f.matrixWorldInverse,u.matrixWorld,u._modelViewMatrixArray),u.z=-u._modelViewMatrix.n34);d.sort(a);for(o=0;o<m;o++)u=d[o],u.visible&&0!==u.opacity&&u.map&&u.map.image&&u.map.image.width&&(u.useScreenCoordinates?(b.uniform1i(p.useScreenCoordinates,1),b.uniform3f(p.screenPosition,(u.position.x-
n)/n,(t-u.position.y)/t,Math.max(0,Math.min(1,u.position.z)))):(b.uniform1i(p.useScreenCoordinates,0),b.uniform1i(p.affectedByDistance,u.affectedByDistance?1:0),b.uniformMatrix4fv(p.modelViewMatrix,!1,u._modelViewMatrixArray)),f=u.map.image.width/(u.scaleByViewport?r:1),w[0]=f*s*u.scale.x,w[1]=f*u.scale.y,b.uniform2f(p.uvScale,u.uvScale.x,u.uvScale.y),b.uniform2f(p.uvOffset,u.uvOffset.x,u.uvOffset.y),b.uniform2f(p.alignment,u.alignment.x,u.alignment.y),b.uniform1f(p.opacity,u.opacity),b.uniform3f(p.color,
u.color.r,u.color.g,u.color.b),b.uniform1f(p.rotation,u.rotation),b.uniform2fv(p.scale,w),u.mergeWith3D&&!v?(b.enable(b.DEPTH_TEST),v=!0):!u.mergeWith3D&&v&&(b.disable(b.DEPTH_TEST),v=!1),c.setBlending(u.blending),c.setTexture(u.map,0),b.drawElements(b.TRIANGLES,6,b.UNSIGNED_SHORT,0));b.enable(b.CULL_FACE);b.enable(b.DEPTH_TEST);b.depthMask(!0)}}};
if(THREE.WebGLRenderer)THREE.AnaglyphWebGLRenderer=function(a){THREE.WebGLRenderer.call(this,a);this.autoUpdateScene=!1;var b=this,c=this.setSize,d=this.render,f=new THREE.PerspectiveCamera,g=new THREE.PerspectiveCamera,e=new THREE.Matrix4,h=new THREE.Matrix4,i,k,j,q;f.matrixAutoUpdate=g.matrixAutoUpdate=!1;var a={minFilter:THREE.LinearFilter,magFilter:THREE.NearestFilter,format:THREE.RGBAFormat},l=new THREE.WebGLRenderTarget(512,512,a),n=new THREE.WebGLRenderTarget(512,512,a),r=new THREE.PerspectiveCamera(53,
1,1,1E4);r.position.z=2;var a=new THREE.ShaderMaterial({uniforms:{mapLeft:{type:"t",value:0,texture:l},mapRight:{type:"t",value:1,texture:n}},vertexShader:"varying vec2 vUv;\nvoid main() {\nvUv = vec2( uv.x, 1.0 - uv.y );\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",fragmentShader:"uniform sampler2D mapLeft;\nuniform sampler2D mapRight;\nvarying vec2 vUv;\nvoid main() {\nvec4 colorL, colorR;\nvec2 uv = vUv;\ncolorL = texture2D( mapLeft, uv );\ncolorR = texture2D( mapRight, uv );\ngl_FragColor = vec4( colorL.g * 0.7 + colorL.b * 0.3, colorR.g, colorR.b, colorL.a + colorR.a ) * 1.1;\n}"}),
m=new THREE.Scene;m.add(new THREE.Mesh(new THREE.PlaneGeometry(2,2),a));m.add(r);this.setSize=function(a,d){c.call(b,a,d);l.width=a;l.height=d;n.width=a;n.height=d};this.render=function(a,c){a.updateMatrixWorld();if(i!==c.aspect||k!==c.near||j!==c.far||q!==c.fov){i=c.aspect;k=c.near;j=c.far;q=c.fov;var s=c.projectionMatrix.clone(),t=0.5*(125/30),v=t*k/125,u=k*Math.tan(q*Math.PI/360),w;e.n14=t;h.n14=-t;t=-u*i+v;w=u*i+v;s.n11=2*k/(w-t);s.n13=(w+t)/(w-t);f.projectionMatrix.copy(s);t=-u*i-v;w=u*i-v;s.n11=
2*k/(w-t);s.n13=(w+t)/(w-t);g.projectionMatrix.copy(s)}f.matrixWorld.copy(c.matrixWorld).multiplySelf(h);f.position.copy(c.position);f.near=c.near;f.far=c.far;d.call(b,a,f,l,!0);g.matrixWorld.copy(c.matrixWorld).multiplySelf(e);g.position.copy(c.position);g.near=c.near;g.far=c.far;d.call(b,a,g,n,!0);m.updateMatrixWorld();d.call(b,m,r)}};
if(THREE.WebGLRenderer)THREE.CrosseyedWebGLRenderer=function(a){THREE.WebGLRenderer.call(this,a);this.autoClear=!1;var b=this,c=this.setSize,d=this.render,f,g,e=new THREE.PerspectiveCamera;e.target=new THREE.Vector3(0,0,0);var h=new THREE.PerspectiveCamera;h.target=new THREE.Vector3(0,0,0);b.separation=10;if(a&&void 0!==a.separation)b.separation=a.separation;this.setSize=function(a,d){c.call(b,a,d);f=a/2;g=d};this.render=function(a,c){this.clear();e.fov=c.fov;e.aspect=0.5*c.aspect;e.near=c.near;e.far=
c.far;e.updateProjectionMatrix();e.position.copy(c.position);e.target.copy(c.target);e.translateX(b.separation);e.lookAt(e.target);h.projectionMatrix=e.projectionMatrix;h.position.copy(c.position);h.target.copy(c.target);h.translateX(-b.separation);h.lookAt(h.target);this.setViewport(0,0,f,g);d.call(b,a,e);this.setViewport(f,0,f,g);d.call(b,a,h,!1)}};
THREE.ShaderFlares={lensFlareVertexTexture:{vertexShader:"uniform vec3 screenPosition;\nuniform vec2 scale;\nuniform float rotation;\nuniform int renderType;\nuniform sampler2D occlusionMap;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nvUV = uv;\nvec2 pos = position;\nif( renderType == 2 ) {\nvec4 visibility = texture2D( occlusionMap, vec2( 0.1, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.5 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.1, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.1, 0.5 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.5 ) );\nvVisibility = (       visibility.r / 9.0 ) *\n( 1.0 - visibility.g / 9.0 ) *\n(       visibility.b / 9.0 ) *\n( 1.0 - visibility.a / 9.0 );\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",fragmentShader:"precision mediump float;\nuniform sampler2D map;\nuniform float opacity;\nuniform int renderType;\nuniform vec3 color;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nif( renderType == 0 ) {\ngl_FragColor = vec4( 1.0, 0.0, 1.0, 0.0 );\n} else if( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nvec4 texture = texture2D( map, vUV );\ntexture.a *= opacity * vVisibility;\ngl_FragColor = texture;\ngl_FragColor.rgb *= color;\n}\n}"},
lensFlare:{vertexShader:"uniform vec3 screenPosition;\nuniform vec2 scale;\nuniform float rotation;\nuniform int renderType;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvoid main() {\nvUV = uv;\nvec2 pos = position;\nif( renderType == 2 ) {\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",fragmentShader:"precision mediump float;\nuniform sampler2D map;\nuniform sampler2D occlusionMap;\nuniform float opacity;\nuniform int renderType;\nuniform vec3 color;\nvarying vec2 vUV;\nvoid main() {\nif( renderType == 0 ) {\ngl_FragColor = vec4( texture2D( map, vUV ).rgb, 0.0 );\n} else if( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nfloat visibility = texture2D( occlusionMap, vec2( 0.5, 0.1 ) ).a +\ntexture2D( occlusionMap, vec2( 0.9, 0.5 ) ).a +\ntexture2D( occlusionMap, vec2( 0.5, 0.9 ) ).a +\ntexture2D( occlusionMap, vec2( 0.1, 0.5 ) ).a;\nvisibility = ( 1.0 - visibility / 4.0 );\nvec4 texture = texture2D( map, vUV );\ntexture.a *= opacity * visibility;\ngl_FragColor = texture;\ngl_FragColor.rgb *= color;\n}\n}"}};
THREE.ShaderSprite={sprite:{vertexShader:"uniform int useScreenCoordinates;\nuniform int affectedByDistance;\nuniform vec3 screenPosition;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform float rotation;\nuniform vec2 scale;\nuniform vec2 alignment;\nuniform vec2 uvOffset;\nuniform vec2 uvScale;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvoid main() {\nvUV = uvOffset + uv * uvScale;\nvec2 alignedPosition = position + alignment;\nvec2 rotatedPosition;\nrotatedPosition.x = ( cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y ) * scale.x;\nrotatedPosition.y = ( sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y ) * scale.y;\nvec4 finalPosition;\nif( useScreenCoordinates != 0 ) {\nfinalPosition = vec4( screenPosition.xy + rotatedPosition, screenPosition.z, 1.0 );\n} else {\nfinalPosition = projectionMatrix * modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );\nfinalPosition.xy += rotatedPosition * ( affectedByDistance == 1 ? 1.0 : finalPosition.z );\n}\ngl_Position = finalPosition;\n}",
fragmentShader:"precision mediump float;\nuniform vec3 color;\nuniform sampler2D map;\nuniform float opacity;\nvarying vec2 vUV;\nvoid main() {\nvec4 texture = texture2D( map, vUV );\ngl_FragColor = vec4( color * texture.xyz, texture.a * opacity );\n}"}};
