var DemosPage = /** @class */ (function () {
    function DemosPage() {
        this.demos = [
            {
                title: 'Stenciljs.com',
                description: 'Yep, this site is also built with Stencil!',
                url: 'https://github.com/ionic-team/stencil-site',
                source: 'https://github.com/ionic-team/stencil-site',
            },
            {
                title: 'IonicHN',
                description: 'Hacker News PWA built with @stencil/core and @ionic/core',
                url: 'https://corehacker-10883.firebaseapp.com/',
                source: 'https://github.com/ionic-team/ionic-stencil-hn-app'
            },
            {
                title: 'Stencil Fiber demo',
                description: 'This showcases the runtime performance of stencil using our async rendering',
                url: 'https://stencil-fiber-demo.firebaseapp.com/',
                source: 'https://github.com/ionic-team/stencil-fiber-demo'
            },
            {
                title: 'StencilNews',
                description: 'Demo of how you could use @stencil/core to build a fast, modern News PWA',
                url: 'https://stencilnews.firebaseapp.com/',
                source: 'https://github.com/ionic-team/stencil-news'
            }
        ];
        document.title = "Stencil Demos";
    }
    DemosPage.prototype.render = function () {
        return (h("div", 0,
            h("h1", 0, t("Demos")),
            h("h4", 0, t("Awesome demos of apps built using Stencil and Ionic")),
            this.demos.map(function (demo) {
                return [
                    h("h4", 0, demo.title),
                    h("p", 0, demo.description),
                    h("p", 0,
                        h("a", { "a": { "target": "_blank", "rel": "noopener" }, "p": { "href": demo.url } }, t("Demo")), t("\u00A0\u00A0"),
                        h("a", { "a": { "target": "_blank", "rel": "noopener" }, "p": { "href": demo.source } }, t("Source")))
                ];
            })));
    };
    return DemosPage;
}());
export { DemosPage };
