// ThreeWebGL.js r43 - http://github.com/mrdoob/three.js
var THREE=THREE||{};if(!window.Int32Array)window.Int32Array=Array,window.Float32Array=Array;THREE.Color=function(b){b!==void 0&&this.setHex(b);return this};
THREE.Color.prototype={constructor:THREE.Color,r:1,g:1,b:1,copy:function(b){this.r=b.r;this.g=b.g;this.b=b.b;return this},setRGB:function(b,c,d){this.r=b;this.g=c;this.b=d;return this},setHSV:function(b,c,d){var e,h,j;if(d==0)this.r=this.g=this.b=0;else switch(e=Math.floor(b*6),h=b*6-e,b=d*(1-c),j=d*(1-c*h),c=d*(1-c*(1-h)),e){case 1:this.r=j;this.g=d;this.b=b;break;case 2:this.r=b;this.g=d;this.b=c;break;case 3:this.r=b;this.g=j;this.b=d;break;case 4:this.r=c;this.g=b;this.b=d;break;case 5:this.r=
d;this.g=b;this.b=j;break;case 6:case 0:this.r=d,this.g=c,this.b=b}return this},setHex:function(b){b=Math.floor(b);this.r=(b>>16&255)/255;this.g=(b>>8&255)/255;this.b=(b&255)/255;return this},getHex:function(){return~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},getContextStyle:function(){return"rgb("+Math.floor(this.r*255)+","+Math.floor(this.g*255)+","+Math.floor(this.b*255)+")"},clone:function(){return(new THREE.Color).setRGB(this.r,this.g,this.b)}};
THREE.Vector2=function(b,c){this.set(b||0,c||0)};
THREE.Vector2.prototype={constructor:THREE.Vector2,set:function(b,c){this.x=b;this.y=c;return this},copy:function(b){this.x=b.x;this.y=b.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},add:function(b,c){this.x=b.x+c.x;this.y=b.y+c.y;return this},addSelf:function(b){this.x+=b.x;this.y+=b.y;return this},sub:function(b,c){this.x=b.x-c.x;this.y=b.y-c.y;return this},subSelf:function(b){this.x-=b.x;this.y-=b.y;return this},multiplyScalar:function(b){this.x*=b;this.y*=b;return this},
divideScalar:function(b){b?(this.x/=b,this.y/=b):this.set(0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(b){return this.x*b.x+this.y*b.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},distanceTo:function(b){return Math.sqrt(this.distanceToSquared(b))},distanceToSquared:function(b){var c=this.x-b.x,b=this.y-b.y;return c*c+b*b},setLength:function(b){return this.normalize().multiplyScalar(b)},
unit:function(){return this.normalize()},equals:function(b){return b.x==this.x&&b.y==this.y}};THREE.Vector3=function(b,c,d){this.set(b||0,c||0,d||0)};
THREE.Vector3.prototype={constructor:THREE.Vector3,set:function(b,c,d){this.x=b;this.y=c;this.z=d;return this},copy:function(b){this.x=b.x;this.y=b.y;this.z=b.z;return this},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},add:function(b,c){this.x=b.x+c.x;this.y=b.y+c.y;this.z=b.z+c.z;return this},addSelf:function(b){this.x+=b.x;this.y+=b.y;this.z+=b.z;return this},addScalar:function(b){this.x+=b;this.y+=b;this.z+=b;return this},sub:function(b,c){this.x=b.x-c.x;this.y=b.y-c.y;this.z=
b.z-c.z;return this},subSelf:function(b){this.x-=b.x;this.y-=b.y;this.z-=b.z;return this},multiply:function(b,c){this.x=b.x*c.x;this.y=b.y*c.y;this.z=b.z*c.z;return this},multiplySelf:function(b){this.x*=b.x;this.y*=b.y;this.z*=b.z;return this},multiplyScalar:function(b){this.x*=b;this.y*=b;this.z*=b;return this},divideSelf:function(b){return this.divide(this,b)},divideScalar:function(b){b?(this.x/=b,this.y/=b,this.z/=b):this.set(0,0,0);return this},negate:function(){return this.multiplyScalar(-1)},
dot:function(b){return this.x*b.x+this.y*b.y+this.z*b.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.lengthSq())},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){return this.divideScalar(this.length())},setLength:function(b){return this.normalize().multiplyScalar(b)},cross:function(b,c){this.x=b.y*c.z-b.z*c.y;this.y=b.z*c.x-b.x*c.z;this.z=b.x*c.y-b.y*c.x;return this},crossSelf:function(b){return this.set(this.y*
b.z-this.z*b.y,this.z*b.x-this.x*b.z,this.x*b.y-this.y*b.x)},distanceTo:function(b){return Math.sqrt(this.distanceToSquared(b))},distanceToSquared:function(b){return(new THREE.Vector3).sub(this,b).lengthSq()},setPositionFromMatrix:function(b){this.x=b.n14;this.y=b.n24;this.z=b.n34},setRotationFromMatrix:function(b){var c=Math.cos(this.y);this.y=Math.asin(b.n13);Math.abs(c)>1.0E-5?(this.x=Math.atan2(-b.n23/c,b.n33/c),this.z=Math.atan2(-b.n12/c,b.n11/c)):(this.x=0,this.z=Math.atan2(b.n21,b.n22))},isZero:function(){return this.lengthSq()<
1.0E-4}};THREE.Vector4=function(b,c,d,e){this.set(b||0,c||0,d||0,e||1)};
THREE.Vector4.prototype={constructor:THREE.Vector4,set:function(b,c,d,e){this.x=b;this.y=c;this.z=d;this.w=e;return this},copy:function(b){return this.set(b.x,b.y,b.z,b.w||1)},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},add:function(b,c){this.x=b.x+c.x;this.y=b.y+c.y;this.z=b.z+c.z;this.w=b.w+c.w;return this},addSelf:function(b){this.x+=b.x;this.y+=b.y;this.z+=b.z;this.w+=b.w;return this},sub:function(b,c){this.x=b.x-c.x;this.y=b.y-c.y;this.z=b.z-c.z;this.w=b.w-c.w;return this},
subSelf:function(b){this.x-=b.x;this.y-=b.y;this.z-=b.z;this.w-=b.w;return this},multiplyScalar:function(b){this.x*=b;this.y*=b;this.z*=b;this.w*=b;return this},divideScalar:function(b){b?(this.x/=b,this.y/=b,this.z/=b,this.w/=b):this.set(0,0,0,1);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(b){return this.x*b.x+this.y*b.y+this.z*b.z+this.w*b.w},lengthSq:function(){return this.dot(this)},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},
setLength:function(b){return this.normalize().multiplyScalar(b)},lerpSelf:function(b,c){this.x+=(b.x-this.x)*c;this.y+=(b.y-this.y)*c;this.z+=(b.z-this.z)*c;this.w+=(b.w-this.w)*c;return this}};THREE.Ray=function(b,c){this.origin=b||new THREE.Vector3;this.direction=c||new THREE.Vector3};
THREE.Ray.prototype={constructor:THREE.Ray,intersectScene:function(b){return this.intersectObjects(b.objects)},intersectObjects:function(b){var c,d,e=[];c=0;for(d=b.length;c<d;c++)e=e.concat(this.intersectObject(b[c]));e.sort(function(b,c){return b.distance-c.distance});return e},intersectObject:function(b){function c(b,c,d){var e,d=d.matrixWorld.getPosition();e=d.clone().subSelf(b).dot(c);b=b.clone().addSelf(c.clone().multiplyScalar(e));return d.distanceTo(b)}function d(b,c,d,e){var e=e.clone().subSelf(c),
d=d.clone().subSelf(c),h=b.clone().subSelf(c),b=e.dot(e),c=e.dot(d),e=e.dot(h),g=d.dot(d),d=d.dot(h),h=1/(b*g-c*c),g=(g*e-c*d)*h,b=(b*d-c*e)*h;return g>0&&b>0&&g+b<1}if(b instanceof THREE.Particle){var e=c(this.origin,this.direction,b);if(!e||e>b.scale.x)return[];return[{distance:e,point:b.position,face:null,object:b}]}else if(b instanceof THREE.Mesh){e=c(this.origin,this.direction,b);if(!e||e>b.geometry.boundingSphere.radius*Math.max(b.scale.x,Math.max(b.scale.y,b.scale.z)))return[];var h,j,g,k,
q,m,o,p,r,v,C=b.geometry,x=C.vertices,E=[],e=0;for(h=C.faces.length;e<h;e++)if(j=C.faces[e],r=this.origin.clone(),v=this.direction.clone(),m=b.matrixWorld,g=m.multiplyVector3(x[j.a].position.clone()),k=m.multiplyVector3(x[j.b].position.clone()),q=m.multiplyVector3(x[j.c].position.clone()),m=j instanceof THREE.Face4?m.multiplyVector3(x[j.d].position.clone()):null,o=b.matrixRotationWorld.multiplyVector3(j.normal.clone()),p=v.dot(o),b.doubleSided||(b.flipSided?p>0:p<0))if(o=o.dot((new THREE.Vector3).sub(g,
r))/p,r=r.addSelf(v.multiplyScalar(o)),j instanceof THREE.Face3)d(r,g,k,q)&&(j={distance:this.origin.distanceTo(r),point:r,face:j,object:b},E.push(j));else if(j instanceof THREE.Face4&&(d(r,g,k,m)||d(r,k,q,m)))j={distance:this.origin.distanceTo(r),point:r,face:j,object:b},E.push(j);return E}else return[]}};
THREE.Rectangle=function(){function b(){j=e-c;g=h-d}var c,d,e,h,j,g,k=!0;this.getX=function(){return c};this.getY=function(){return d};this.getWidth=function(){return j};this.getHeight=function(){return g};this.getLeft=function(){return c};this.getTop=function(){return d};this.getRight=function(){return e};this.getBottom=function(){return h};this.set=function(g,j,o,p){k=!1;c=g;d=j;e=o;h=p;b()};this.addPoint=function(g,j){k?(k=!1,c=g,d=j,e=g,h=j):(c=c<g?c:g,d=d<j?d:j,e=e>g?e:g,h=h>j?h:j);b()};this.add3Points=
function(g,j,o,p,r,v){k?(k=!1,c=g<o?g<r?g:r:o<r?o:r,d=j<p?j<v?j:v:p<v?p:v,e=g>o?g>r?g:r:o>r?o:r,h=j>p?j>v?j:v:p>v?p:v):(c=g<o?g<r?g<c?g:c:r<c?r:c:o<r?o<c?o:c:r<c?r:c,d=j<p?j<v?j<d?j:d:v<d?v:d:p<v?p<d?p:d:v<d?v:d,e=g>o?g>r?g>e?g:e:r>e?r:e:o>r?o>e?o:e:r>e?r:e,h=j>p?j>v?j>h?j:h:v>h?v:h:p>v?p>h?p:h:v>h?v:h);b()};this.addRectangle=function(g){k?(k=!1,c=g.getLeft(),d=g.getTop(),e=g.getRight(),h=g.getBottom()):(c=c<g.getLeft()?c:g.getLeft(),d=d<g.getTop()?d:g.getTop(),e=e>g.getRight()?e:g.getRight(),h=h>
g.getBottom()?h:g.getBottom());b()};this.inflate=function(g){c-=g;d-=g;e+=g;h+=g;b()};this.minSelf=function(g){c=c>g.getLeft()?c:g.getLeft();d=d>g.getTop()?d:g.getTop();e=e<g.getRight()?e:g.getRight();h=h<g.getBottom()?h:g.getBottom();b()};this.instersects=function(b){return Math.min(e,b.getRight())-Math.max(c,b.getLeft())>=0&&Math.min(h,b.getBottom())-Math.max(d,b.getTop())>=0};this.empty=function(){k=!0;h=e=d=c=0;b()};this.isEmpty=function(){return k}};THREE.Matrix3=function(){this.m=[]};
THREE.Matrix3.prototype={constructor:THREE.Matrix3,transpose:function(){var b,c=this.m;b=c[1];c[1]=c[3];c[3]=b;b=c[2];c[2]=c[6];c[6]=b;b=c[5];c[5]=c[7];c[7]=b;return this},transposeIntoArray:function(b){var c=this.m;b[0]=c[0];b[1]=c[3];b[2]=c[6];b[3]=c[1];b[4]=c[4];b[5]=c[7];b[6]=c[2];b[7]=c[5];b[8]=c[8];return this}};THREE.Matrix4=function(b,c,d,e,h,j,g,k,q,m,o,p,r,v,C,x){this.set(b||1,c||0,d||0,e||0,h||0,j||1,g||0,k||0,q||0,m||0,o||1,p||0,r||0,v||0,C||0,x||1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={constructor:THREE.Matrix4,set:function(b,c,d,e,h,j,g,k,q,m,o,p,r,v,C,x){this.n11=b;this.n12=c;this.n13=d;this.n14=e;this.n21=h;this.n22=j;this.n23=g;this.n24=k;this.n31=q;this.n32=m;this.n33=o;this.n34=p;this.n41=r;this.n42=v;this.n43=C;this.n44=x;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(b){this.set(b.n11,b.n12,b.n13,b.n14,b.n21,b.n22,b.n23,b.n24,b.n31,b.n32,b.n33,b.n34,b.n41,b.n42,b.n43,b.n44);return this},lookAt:function(b,
c,d){var e=THREE.Matrix4.__v1,h=THREE.Matrix4.__v2,j=THREE.Matrix4.__v3;j.sub(b,c).normalize();if(j.length()===0)j.z=1;e.cross(d,j).normalize();e.length()===0&&(j.x+=1.0E-4,e.cross(d,j).normalize());h.cross(j,e).normalize();this.n11=e.x;this.n12=h.x;this.n13=j.x;this.n21=e.y;this.n22=h.y;this.n23=j.y;this.n31=e.z;this.n32=h.z;this.n33=j.z;return this},multiplyVector3:function(b){var c=b.x,d=b.y,e=b.z,h=1/(this.n41*c+this.n42*d+this.n43*e+this.n44);b.x=(this.n11*c+this.n12*d+this.n13*e+this.n14)*h;
b.y=(this.n21*c+this.n22*d+this.n23*e+this.n24)*h;b.z=(this.n31*c+this.n32*d+this.n33*e+this.n34)*h;return b},multiplyVector4:function(b){var c=b.x,d=b.y,e=b.z,h=b.w;b.x=this.n11*c+this.n12*d+this.n13*e+this.n14*h;b.y=this.n21*c+this.n22*d+this.n23*e+this.n24*h;b.z=this.n31*c+this.n32*d+this.n33*e+this.n34*h;b.w=this.n41*c+this.n42*d+this.n43*e+this.n44*h;return b},rotateAxis:function(b){var c=b.x,d=b.y,e=b.z;b.x=c*this.n11+d*this.n12+e*this.n13;b.y=c*this.n21+d*this.n22+e*this.n23;b.z=c*this.n31+
d*this.n32+e*this.n33;b.normalize();return b},crossVector:function(b){var c=new THREE.Vector4;c.x=this.n11*b.x+this.n12*b.y+this.n13*b.z+this.n14*b.w;c.y=this.n21*b.x+this.n22*b.y+this.n23*b.z+this.n24*b.w;c.z=this.n31*b.x+this.n32*b.y+this.n33*b.z+this.n34*b.w;c.w=b.w?this.n41*b.x+this.n42*b.y+this.n43*b.z+this.n44*b.w:1;return c},multiply:function(b,c){var d=b.n11,e=b.n12,h=b.n13,j=b.n14,g=b.n21,k=b.n22,q=b.n23,m=b.n24,o=b.n31,p=b.n32,r=b.n33,v=b.n34,C=b.n41,x=b.n42,E=b.n43,J=b.n44,ya=c.n11,za=
c.n12,sa=c.n13,V=c.n14,u=c.n21,Q=c.n22,O=c.n23,T=c.n24,U=c.n31,qa=c.n32,N=c.n33,L=c.n34,f=c.n41,ua=c.n42,Aa=c.n43,ta=c.n44;this.n11=d*ya+e*u+h*U+j*f;this.n12=d*za+e*Q+h*qa+j*ua;this.n13=d*sa+e*O+h*N+j*Aa;this.n14=d*V+e*T+h*L+j*ta;this.n21=g*ya+k*u+q*U+m*f;this.n22=g*za+k*Q+q*qa+m*ua;this.n23=g*sa+k*O+q*N+m*Aa;this.n24=g*V+k*T+q*L+m*ta;this.n31=o*ya+p*u+r*U+v*f;this.n32=o*za+p*Q+r*qa+v*ua;this.n33=o*sa+p*O+r*N+v*Aa;this.n34=o*V+p*T+r*L+v*ta;this.n41=C*ya+x*u+E*U+J*f;this.n42=C*za+x*Q+E*qa+J*ua;this.n43=
C*sa+x*O+E*N+J*Aa;this.n44=C*V+x*T+E*L+J*ta;return this},multiplyToArray:function(b,c,d){this.multiply(b,c);d[0]=this.n11;d[1]=this.n21;d[2]=this.n31;d[3]=this.n41;d[4]=this.n12;d[5]=this.n22;d[6]=this.n32;d[7]=this.n42;d[8]=this.n13;d[9]=this.n23;d[10]=this.n33;d[11]=this.n43;d[12]=this.n14;d[13]=this.n24;d[14]=this.n34;d[15]=this.n44;return this},multiplySelf:function(b){this.multiply(this,b);return this},multiplyScalar:function(b){this.n11*=b;this.n12*=b;this.n13*=b;this.n14*=b;this.n21*=b;this.n22*=
b;this.n23*=b;this.n24*=b;this.n31*=b;this.n32*=b;this.n33*=b;this.n34*=b;this.n41*=b;this.n42*=b;this.n43*=b;this.n44*=b;return this},determinant:function(){var b=this.n11,c=this.n12,d=this.n13,e=this.n14,h=this.n21,j=this.n22,g=this.n23,k=this.n24,q=this.n31,m=this.n32,o=this.n33,p=this.n34,r=this.n41,v=this.n42,C=this.n43,x=this.n44;return e*g*m*r-d*k*m*r-e*j*o*r+c*k*o*r+d*j*p*r-c*g*p*r-e*g*q*v+d*k*q*v+e*h*o*v-b*k*o*v-d*h*p*v+b*g*p*v+e*j*q*C-c*k*q*C-e*h*m*C+b*k*m*C+c*h*p*C-b*j*p*C-d*j*q*x+c*g*
q*x+d*h*m*x-b*g*m*x-c*h*o*x+b*j*o*x},transpose:function(){var b;b=this.n21;this.n21=this.n12;this.n12=b;b=this.n31;this.n31=this.n13;this.n13=b;b=this.n32;this.n32=this.n23;this.n23=b;b=this.n41;this.n41=this.n14;this.n14=b;b=this.n42;this.n42=this.n24;this.n24=b;b=this.n43;this.n43=this.n34;this.n43=b;return this},clone:function(){var b=new THREE.Matrix4;b.n11=this.n11;b.n12=this.n12;b.n13=this.n13;b.n14=this.n14;b.n21=this.n21;b.n22=this.n22;b.n23=this.n23;b.n24=this.n24;b.n31=this.n31;b.n32=this.n32;
b.n33=this.n33;b.n34=this.n34;b.n41=this.n41;b.n42=this.n42;b.n43=this.n43;b.n44=this.n44;return b},flatten:function(){this.flat[0]=this.n11;this.flat[1]=this.n21;this.flat[2]=this.n31;this.flat[3]=this.n41;this.flat[4]=this.n12;this.flat[5]=this.n22;this.flat[6]=this.n32;this.flat[7]=this.n42;this.flat[8]=this.n13;this.flat[9]=this.n23;this.flat[10]=this.n33;this.flat[11]=this.n43;this.flat[12]=this.n14;this.flat[13]=this.n24;this.flat[14]=this.n34;this.flat[15]=this.n44;return this.flat},flattenToArray:function(b){b[0]=
this.n11;b[1]=this.n21;b[2]=this.n31;b[3]=this.n41;b[4]=this.n12;b[5]=this.n22;b[6]=this.n32;b[7]=this.n42;b[8]=this.n13;b[9]=this.n23;b[10]=this.n33;b[11]=this.n43;b[12]=this.n14;b[13]=this.n24;b[14]=this.n34;b[15]=this.n44;return b},flattenToArrayOffset:function(b,c){b[c]=this.n11;b[c+1]=this.n21;b[c+2]=this.n31;b[c+3]=this.n41;b[c+4]=this.n12;b[c+5]=this.n22;b[c+6]=this.n32;b[c+7]=this.n42;b[c+8]=this.n13;b[c+9]=this.n23;b[c+10]=this.n33;b[c+11]=this.n43;b[c+12]=this.n14;b[c+13]=this.n24;b[c+14]=
this.n34;b[c+15]=this.n44;return b},setTranslation:function(b,c,d){this.set(1,0,0,b,0,1,0,c,0,0,1,d,0,0,0,1);return this},setScale:function(b,c,d){this.set(b,0,0,0,0,c,0,0,0,0,d,0,0,0,0,1);return this},setRotationX:function(b){var c=Math.cos(b),b=Math.sin(b);this.set(1,0,0,0,0,c,-b,0,0,b,c,0,0,0,0,1);return this},setRotationY:function(b){var c=Math.cos(b),b=Math.sin(b);this.set(c,0,b,0,0,1,0,0,-b,0,c,0,0,0,0,1);return this},setRotationZ:function(b){var c=Math.cos(b),b=Math.sin(b);this.set(c,-b,0,
0,b,c,0,0,0,0,1,0,0,0,0,1);return this},setRotationAxis:function(b,c){var d=Math.cos(c),e=Math.sin(c),h=1-d,j=b.x,g=b.y,k=b.z,q=h*j,m=h*g;this.set(q*j+d,q*g-e*k,q*k+e*g,0,q*g+e*k,m*g+d,m*k-e*j,0,q*k-e*g,m*k+e*j,h*k*k+d,0,0,0,0,1);return this},setPosition:function(b){this.n14=b.x;this.n24=b.y;this.n34=b.z;return this},getPosition:function(){if(!this.position)this.position=new THREE.Vector3;this.position.set(this.n14,this.n24,this.n34);return this.position},getColumnX:function(){if(!this.columnX)this.columnX=
new THREE.Vector3;this.columnX.set(this.n11,this.n21,this.n31);return this.columnX},getColumnY:function(){if(!this.columnY)this.columnY=new THREE.Vector3;this.columnY.set(this.n12,this.n22,this.n32);return this.columnY},getColumnZ:function(){if(!this.columnZ)this.columnZ=new THREE.Vector3;this.columnZ.set(this.n13,this.n23,this.n33);return this.columnZ},setRotationFromEuler:function(b,c){var d=b.x,e=b.y,h=b.z,j=Math.cos(d),d=Math.sin(d),g=Math.cos(e),e=Math.sin(e),k=Math.cos(h),h=Math.sin(h);switch(c){case "YXZ":var q=
g*k,m=g*h,o=e*k,p=e*h;this.n11=q+p*d;this.n12=o*d-m;this.n13=j*e;this.n21=j*h;this.n22=j*k;this.n23=-d;this.n31=m*d-o;this.n32=p+q*d;this.n33=j*g;break;case "ZXY":q=g*k;m=g*h;o=e*k;p=e*h;this.n11=q-p*d;this.n12=-j*h;this.n13=o+m*d;this.n21=m+o*d;this.n22=j*k;this.n23=p-q*d;this.n31=-j*e;this.n32=d;this.n33=j*g;break;case "ZYX":q=j*k;m=j*h;o=d*k;p=d*h;this.n11=g*k;this.n12=o*e-m;this.n13=q*e+p;this.n21=g*h;this.n22=p*e+q;this.n23=m*e-o;this.n31=-e;this.n32=d*g;this.n33=j*g;break;case "YZX":q=j*g;m=
j*e;o=d*g;p=d*e;this.n11=g*k;this.n12=p-q*h;this.n13=o*h+m;this.n21=h;this.n22=j*k;this.n23=-d*k;this.n31=-e*k;this.n32=m*h+o;this.n33=q-p*h;break;case "XZY":q=j*g;m=j*e;o=d*g;p=d*e;this.n11=g*k;this.n12=-h;this.n13=e*k;this.n21=q*h+p;this.n22=j*k;this.n23=m*h-o;this.n31=o*h-m;this.n32=d*k;this.n33=p*h+q;break;default:q=j*k,m=j*h,o=d*k,p=d*h,this.n11=g*k,this.n12=-g*h,this.n13=e,this.n21=m+o*e,this.n22=q-p*e,this.n23=-d*g,this.n31=p-q*e,this.n32=o+m*e,this.n33=j*g}return this},setRotationFromQuaternion:function(b){var c=
b.x,d=b.y,e=b.z,h=b.w,j=c+c,g=d+d,k=e+e,b=c*j,q=c*g;c*=k;var m=d*g;d*=k;e*=k;j*=h;g*=h;h*=k;this.n11=1-(m+e);this.n12=q-h;this.n13=c+g;this.n21=q+h;this.n22=1-(b+e);this.n23=d-j;this.n31=c-g;this.n32=d+j;this.n33=1-(b+m);return this},scale:function(b){var c=b.x,d=b.y,b=b.z;this.n11*=c;this.n12*=d;this.n13*=b;this.n21*=c;this.n22*=d;this.n23*=b;this.n31*=c;this.n32*=d;this.n33*=b;this.n41*=c;this.n42*=d;this.n43*=b;return this},extractPosition:function(b){this.n14=b.n14;this.n24=b.n24;this.n34=b.n34},
extractRotation:function(b,c){var d=1/c.x,e=1/c.y,h=1/c.z;this.n11=b.n11*d;this.n21=b.n21*d;this.n31=b.n31*d;this.n12=b.n12*e;this.n22=b.n22*e;this.n32=b.n32*e;this.n13=b.n13*h;this.n23=b.n23*h;this.n33=b.n33*h}};
THREE.Matrix4.makeInvert=function(b,c){var d=b.n11,e=b.n12,h=b.n13,j=b.n14,g=b.n21,k=b.n22,q=b.n23,m=b.n24,o=b.n31,p=b.n32,r=b.n33,v=b.n34,C=b.n41,x=b.n42,E=b.n43,J=b.n44;c===void 0&&(c=new THREE.Matrix4);c.n11=q*v*x-m*r*x+m*p*E-k*v*E-q*p*J+k*r*J;c.n12=j*r*x-h*v*x-j*p*E+e*v*E+h*p*J-e*r*J;c.n13=h*m*x-j*q*x+j*k*E-e*m*E-h*k*J+e*q*J;c.n14=j*q*p-h*m*p-j*k*r+e*m*r+h*k*v-e*q*v;c.n21=m*r*C-q*v*C-m*o*E+g*v*E+q*o*J-g*r*J;c.n22=h*v*C-j*r*C+j*o*E-d*v*E-h*o*J+d*r*J;c.n23=j*q*C-h*m*C-j*g*E+d*m*E+h*g*J-d*q*J;c.n24=
h*m*o-j*q*o+j*g*r-d*m*r-h*g*v+d*q*v;c.n31=k*v*C-m*p*C+m*o*x-g*v*x-k*o*J+g*p*J;c.n32=j*p*C-e*v*C-j*o*x+d*v*x+e*o*J-d*p*J;c.n33=h*m*C-j*k*C+j*g*x-d*m*x-e*g*J+d*k*J;c.n34=j*k*o-e*m*o-j*g*p+d*m*p+e*g*v-d*k*v;c.n41=q*p*C-k*r*C-q*o*x+g*r*x+k*o*E-g*p*E;c.n42=e*r*C-h*p*C+h*o*x-d*r*x-e*o*E+d*p*E;c.n43=h*k*C-e*q*C-h*g*x+d*q*x+e*g*E-d*k*E;c.n44=e*q*o-h*k*o+h*g*p-d*q*p-e*g*r+d*k*r;c.multiplyScalar(1/b.determinant());return c};
THREE.Matrix4.makeInvert3x3=function(b){var c=b.m33,d=c.m,e=b.n33*b.n22-b.n32*b.n23,h=-b.n33*b.n21+b.n31*b.n23,j=b.n32*b.n21-b.n31*b.n22,g=-b.n33*b.n12+b.n32*b.n13,k=b.n33*b.n11-b.n31*b.n13,q=-b.n32*b.n11+b.n31*b.n12,m=b.n23*b.n12-b.n22*b.n13,o=-b.n23*b.n11+b.n21*b.n13,p=b.n22*b.n11-b.n21*b.n12,b=b.n11*e+b.n21*g+b.n31*m;b==0&&console.error("THREE.Matrix4.makeInvert3x3: Matrix not invertible.");b=1/b;d[0]=b*e;d[1]=b*h;d[2]=b*j;d[3]=b*g;d[4]=b*k;d[5]=b*q;d[6]=b*m;d[7]=b*o;d[8]=b*p;return c};
THREE.Matrix4.makeFrustum=function(b,c,d,e,h,j){var g;g=new THREE.Matrix4;g.n11=2*h/(c-b);g.n12=0;g.n13=(c+b)/(c-b);g.n14=0;g.n21=0;g.n22=2*h/(e-d);g.n23=(e+d)/(e-d);g.n24=0;g.n31=0;g.n32=0;g.n33=-(j+h)/(j-h);g.n34=-2*j*h/(j-h);g.n41=0;g.n42=0;g.n43=-1;g.n44=0;return g};THREE.Matrix4.makePerspective=function(b,c,d,e){var h,b=d*Math.tan(b*Math.PI/360);h=-b;return THREE.Matrix4.makeFrustum(h*c,b*c,h,b,d,e)};
THREE.Matrix4.makeOrtho=function(b,c,d,e,h,j){var g,k,q,m;g=new THREE.Matrix4;k=c-b;q=d-e;m=j-h;g.n11=2/k;g.n12=0;g.n13=0;g.n14=-((c+b)/k);g.n21=0;g.n22=2/q;g.n23=0;g.n24=-((d+e)/q);g.n31=0;g.n32=0;g.n33=-2/m;g.n34=-((j+h)/m);g.n41=0;g.n42=0;g.n43=0;g.n44=1;return g};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;
THREE.Object3D=function(){this.parent=void 0;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.eulerOrder="XYZ";this.scale=new THREE.Vector3(1,1,1);this.flipSided=this.doubleSided=this.dynamic=!1;this.renderDepth=null;this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixWorldNeedsUpdate=this.matrixAutoUpdate=!0;this.quaternion=new THREE.Quaternion;
this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=!0;this.receiveShadow=this.castShadow=!1;this._vector=new THREE.Vector3;this.name=""};
THREE.Object3D.prototype={constructor:THREE.Object3D,translate:function(b,c){this.matrix.rotateAxis(c);this.position.addSelf(c.multiplyScalar(b))},translateX:function(b){this.translate(b,this._vector.set(1,0,0))},translateY:function(b){this.translate(b,this._vector.set(0,1,0))},translateZ:function(b){this.translate(b,this._vector.set(0,0,1))},lookAt:function(b){this.matrix.lookAt(b,this.position,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)},addChild:function(b){if(this.children.indexOf(b)===
-1){b.parent!==void 0&&b.parent.removeChild(b);b.parent=this;this.children.push(b);for(var c=this;c.parent!==void 0;)c=c.parent;c!==void 0&&c instanceof THREE.Scene&&c.addChildRecurse(b)}},removeChild:function(b){var c=this.children.indexOf(b);if(c!==-1)b.parent=void 0,this.children.splice(c,1)},getChildByName:function(b,c){var d,e,h;d=0;for(e=this.children.length;d<e;d++){h=this.children[d];if(h.name===b)return h;if(c&&(h=h.getChildByName(b,c),h!==void 0))return h}},updateMatrix:function(){this.matrix.setPosition(this.position);
this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation,this.eulerOrder);if(this.scale.x!==1||this.scale.y!==1||this.scale.z!==1)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z));this.matrixWorldNeedsUpdate=!0},update:function(b,c,d){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||c)b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),
this.matrixRotationWorld.extractRotation(this.matrixWorld,this.scale),this.matrixWorldNeedsUpdate=!1,c=!0;for(var b=0,e=this.children.length;b<e;b++)this.children[b].update(this.matrixWorld,c,d)}};THREE.Quaternion=function(b,c,d,e){this.set(b||0,c||0,d||0,e!==void 0?e:1)};
THREE.Quaternion.prototype={constructor:THREE.Quaternion,set:function(b,c,d,e){this.x=b;this.y=c;this.z=d;this.w=e;return this},copy:function(b){this.x=b.x;this.y=b.y;this.z=b.z;this.w=b.w;return this},setFromEuler:function(b){var c=0.5*Math.PI/360,d=b.x*c,e=b.y*c,h=b.z*c,b=Math.cos(e),e=Math.sin(e),c=Math.cos(-h),h=Math.sin(-h),j=Math.cos(d),d=Math.sin(d),g=b*c,k=e*h;this.w=g*j-k*d;this.x=g*d+k*j;this.y=e*c*j+b*h*d;this.z=b*h*j-e*c*d;return this},setFromAxisAngle:function(b,c){var d=c/2,e=Math.sin(d);
this.x=b.x*e;this.y=b.y*e;this.z=b.z*e;this.w=Math.cos(d);return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var b=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);b==0?this.w=this.z=this.y=this.x=0:(b=1/b,this.x*=b,this.y*=b,this.z*=
b,this.w*=b);return this},multiplySelf:function(b){var c=this.x,d=this.y,e=this.z,h=this.w,j=b.x,g=b.y,k=b.z,b=b.w;this.x=c*b+h*j+d*k-e*g;this.y=d*b+h*g+e*j-c*k;this.z=e*b+h*k+c*g-d*j;this.w=h*b-c*j-d*g-e*k;return this},multiply:function(b,c){this.x=b.x*c.w+b.y*c.z-b.z*c.y+b.w*c.x;this.y=-b.x*c.z+b.y*c.w+b.z*c.x+b.w*c.y;this.z=b.x*c.y-b.y*c.x+b.z*c.w+b.w*c.z;this.w=-b.x*c.x-b.y*c.y-b.z*c.z+b.w*c.w;return this},multiplyVector3:function(b,c){c||(c=b);var d=b.x,e=b.y,h=b.z,j=this.x,g=this.y,k=this.z,
q=this.w,m=q*d+g*h-k*e,o=q*e+k*d-j*h,p=q*h+j*e-g*d,d=-j*d-g*e-k*h;c.x=m*q+d*-j+o*-k-p*-g;c.y=o*q+d*-g+p*-j-m*-k;c.z=p*q+d*-k+m*-g-o*-j;return c}};
THREE.Quaternion.slerp=function(b,c,d,e){var h=b.w*c.w+b.x*c.x+b.y*c.y+b.z*c.z;if(Math.abs(h)>=1)return d.w=b.w,d.x=b.x,d.y=b.y,d.z=b.z,d;var j=Math.acos(h),g=Math.sqrt(1-h*h);if(Math.abs(g)<0.001)return d.w=0.5*(b.w+c.w),d.x=0.5*(b.x+c.x),d.y=0.5*(b.y+c.y),d.z=0.5*(b.z+c.z),d;h=Math.sin((1-e)*j)/g;e=Math.sin(e*j)/g;d.w=b.w*h+c.w*e;d.x=b.x*h+c.x*e;d.y=b.y*h+c.y*e;d.z=b.z*h+c.z*e;return d};THREE.Vertex=function(b){this.position=b||new THREE.Vector3};
THREE.Face3=function(b,c,d,e,h,j){this.a=b;this.b=c;this.c=d;this.normal=e instanceof THREE.Vector3?e:new THREE.Vector3;this.vertexNormals=e instanceof Array?e:[];this.color=h instanceof THREE.Color?h:new THREE.Color;this.vertexColors=h instanceof Array?h:[];this.vertexTangents=[];this.materials=j instanceof Array?j:[j];this.centroid=new THREE.Vector3};
THREE.Face4=function(b,c,d,e,h,j,g){this.a=b;this.b=c;this.c=d;this.d=e;this.normal=h instanceof THREE.Vector3?h:new THREE.Vector3;this.vertexNormals=h instanceof Array?h:[];this.color=j instanceof THREE.Color?j:new THREE.Color;this.vertexColors=j instanceof Array?j:[];this.vertexTangents=[];this.materials=g instanceof Array?g:[g];this.centroid=new THREE.Vector3};THREE.UV=function(b,c){this.set(b||0,c||0)};
THREE.UV.prototype={constructor:THREE.UV,set:function(b,c){this.u=b;this.v=c;return this},copy:function(b){this.set(b.u,b.v);return this}};THREE.Geometry=function(){this.id="Geometry"+THREE.GeometryIdCounter++;this.vertices=[];this.colors=[];this.faces=[];this.edges=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.dynamic=this.hasTangents=!1};
THREE.Geometry.prototype={constructor:THREE.Geometry,computeCentroids:function(){var b,c,d;b=0;for(c=this.faces.length;b<c;b++)d=this.faces[b],d.centroid.set(0,0,0),d instanceof THREE.Face3?(d.centroid.addSelf(this.vertices[d.a].position),d.centroid.addSelf(this.vertices[d.b].position),d.centroid.addSelf(this.vertices[d.c].position),d.centroid.divideScalar(3)):d instanceof THREE.Face4&&(d.centroid.addSelf(this.vertices[d.a].position),d.centroid.addSelf(this.vertices[d.b].position),d.centroid.addSelf(this.vertices[d.c].position),
d.centroid.addSelf(this.vertices[d.d].position),d.centroid.divideScalar(4))},computeFaceNormals:function(b){var c,d,e,h,j,g,k=new THREE.Vector3,q=new THREE.Vector3;e=0;for(h=this.faces.length;e<h;e++){j=this.faces[e];if(b&&j.vertexNormals.length){k.set(0,0,0);c=0;for(d=j.vertexNormals.length;c<d;c++)k.addSelf(j.vertexNormals[c]);k.divideScalar(3)}else c=this.vertices[j.a],d=this.vertices[j.b],g=this.vertices[j.c],k.sub(g.position,d.position),q.sub(c.position,d.position),k.crossSelf(q);k.isZero()||
k.normalize();j.normal.copy(k)}},computeVertexNormals:function(){var b,c,d,e;if(this.__tmpVertices==void 0){e=this.__tmpVertices=Array(this.vertices.length);b=0;for(c=this.vertices.length;b<c;b++)e[b]=new THREE.Vector3;b=0;for(c=this.faces.length;b<c;b++)if(d=this.faces[b],d instanceof THREE.Face3)d.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(d instanceof THREE.Face4)d.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}else{e=
this.__tmpVertices;b=0;for(c=this.vertices.length;b<c;b++)e[b].set(0,0,0)}b=0;for(c=this.faces.length;b<c;b++)d=this.faces[b],d instanceof THREE.Face3?(e[d.a].addSelf(d.normal),e[d.b].addSelf(d.normal),e[d.c].addSelf(d.normal)):d instanceof THREE.Face4&&(e[d.a].addSelf(d.normal),e[d.b].addSelf(d.normal),e[d.c].addSelf(d.normal),e[d.d].addSelf(d.normal));b=0;for(c=this.vertices.length;b<c;b++)e[b].normalize();b=0;for(c=this.faces.length;b<c;b++)d=this.faces[b],d instanceof THREE.Face3?(d.vertexNormals[0].copy(e[d.a]),
d.vertexNormals[1].copy(e[d.b]),d.vertexNormals[2].copy(e[d.c])):d instanceof THREE.Face4&&(d.vertexNormals[0].copy(e[d.a]),d.vertexNormals[1].copy(e[d.b]),d.vertexNormals[2].copy(e[d.c]),d.vertexNormals[3].copy(e[d.d]))},computeTangents:function(){function b(b,f,c,d,e,h,j){k=b.vertices[f].position;q=b.vertices[c].position;m=b.vertices[d].position;o=g[e];p=g[h];r=g[j];v=q.x-k.x;C=m.x-k.x;x=q.y-k.y;E=m.y-k.y;J=q.z-k.z;ya=m.z-k.z;za=p.u-o.u;sa=r.u-o.u;V=p.v-o.v;u=r.v-o.v;Q=1/(za*u-sa*V);qa.set((u*v-
V*C)*Q,(u*x-V*E)*Q,(u*J-V*ya)*Q);N.set((za*C-sa*v)*Q,(za*E-sa*x)*Q,(za*ya-sa*J)*Q);T[f].addSelf(qa);T[c].addSelf(qa);T[d].addSelf(qa);U[f].addSelf(N);U[c].addSelf(N);U[d].addSelf(N)}var c,d,e,h,j,g,k,q,m,o,p,r,v,C,x,E,J,ya,za,sa,V,u,Q,O,T=[],U=[],qa=new THREE.Vector3,N=new THREE.Vector3,L=new THREE.Vector3,f=new THREE.Vector3,ua=new THREE.Vector3;c=0;for(d=this.vertices.length;c<d;c++)T[c]=new THREE.Vector3,U[c]=new THREE.Vector3;c=0;for(d=this.faces.length;c<d;c++)j=this.faces[c],g=this.faceVertexUvs[0][c],
j instanceof THREE.Face3?b(this,j.a,j.b,j.c,0,1,2):j instanceof THREE.Face4&&(b(this,j.a,j.b,j.c,0,1,2),b(this,j.a,j.b,j.d,0,1,3));var Aa=["a","b","c","d"];c=0;for(d=this.faces.length;c<d;c++){j=this.faces[c];for(e=0;e<j.vertexNormals.length;e++)ua.copy(j.vertexNormals[e]),h=j[Aa[e]],O=T[h],L.copy(O),L.subSelf(ua.multiplyScalar(ua.dot(O))).normalize(),f.cross(j.vertexNormals[e],O),h=f.dot(U[h]),h=h<0?-1:1,j.vertexTangents[e]=new THREE.Vector4(L.x,L.y,L.z,h)}this.hasTangents=!0},computeBoundingBox:function(){var b;
if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,this.vertices[0].position.y],z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var c=1,d=this.vertices.length;c<d;c++){b=this.vertices[c];if(b.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=b.position.x;else if(b.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=b.position.x;if(b.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=b.position.y;
else if(b.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=b.position.y;if(b.position.z<this.boundingBox.z[0])this.boundingBox.z[0]=b.position.z;else if(b.position.z>this.boundingBox.z[1])this.boundingBox.z[1]=b.position.z}}},computeBoundingSphere:function(){for(var b=0,c=0,d=this.vertices.length;c<d;c++)b=Math.max(b,this.vertices[c].position.length());this.boundingSphere={radius:b}},computeEdgeFaces:function(){function b(b,c){return Math.min(b,c)+"_"+Math.max(b,c)}function c(b,c,d){b[c]===
void 0?(b[c]={set:{},array:[]},b[c].set[d]=1,b[c].array.push(d)):b[c].set[d]===void 0&&(b[c].set[d]=1,b[c].array.push(d))}var d,e,h,j,g,k={};d=0;for(e=this.faces.length;d<e;d++)g=this.faces[d],g instanceof THREE.Face3?(h=b(g.a,g.b),c(k,h,d),h=b(g.b,g.c),c(k,h,d),h=b(g.a,g.c),c(k,h,d)):g instanceof THREE.Face4&&(h=b(g.b,g.d),c(k,h,d),h=b(g.a,g.b),c(k,h,d),h=b(g.a,g.d),c(k,h,d),h=b(g.b,g.c),c(k,h,d),h=b(g.c,g.d),c(k,h,d));d=0;for(e=this.edges.length;d<e;d++){g=this.edges[d];h=g.vertexIndices[0];j=g.vertexIndices[1];
g.faceIndices=k[b(h,j)].array;for(h=0;h<g.faceIndices.length;h++)j=g.faceIndices[h],g.faces.push(this.faces[j])}}};THREE.GeometryIdCounter=0;
THREE.Spline=function(b){function c(b,c,d,e,h,g,j){b=(d-b)*0.5;e=(e-c)*0.5;return(2*(c-d)+b+e)*j+(-3*(c-d)-2*b-e)*g+b*h+c}this.points=b;var d=[],e={x:0,y:0,z:0},h,j,g,k,q,m,o,p,r;this.initFromArray=function(b){this.points=[];for(var c=0;c<b.length;c++)this.points[c]={x:b[c][0],y:b[c][1],z:b[c][2]}};this.getPoint=function(b){h=(this.points.length-1)*b;j=Math.floor(h);g=h-j;d[0]=j==0?j:j-1;d[1]=j;d[2]=j>this.points.length-2?j:j+1;d[3]=j>this.points.length-3?j:j+2;m=this.points[d[0]];o=this.points[d[1]];
p=this.points[d[2]];r=this.points[d[3]];k=g*g;q=g*k;e.x=c(m.x,o.x,p.x,r.x,g,k,q);e.y=c(m.y,o.y,p.y,r.y,g,k,q);e.z=c(m.z,o.z,p.z,r.z,g,k,q);return e};this.getControlPointsArray=function(){var b,c,d=this.points.length,e=[];for(b=0;b<d;b++)c=this.points[b],e[b]=[c.x,c.y,c.z];return e};this.getLength=function(b){var c,d,e=c=c=0,h=new THREE.Vector3,g=new THREE.Vector3,j=[],k=0;j[0]=0;b||(b=100);d=this.points.length*b;h.copy(this.points[0]);for(b=1;b<d;b++)c=b/d,position=this.getPoint(c),g.copy(position),
k+=g.distanceTo(h),h.copy(position),c*=this.points.length-1,c=Math.floor(c),c!=e&&(j[c]=k,e=c);j[j.length]=k;return{chunks:j,total:k}};this.reparametrizeByArcLength=function(b){var c,d,e,h,g,j,k=[],m=new THREE.Vector3,q=this.getLength();k.push(m.copy(this.points[0]).clone());for(c=1;c<this.points.length;c++){d=q.chunks[c]-q.chunks[c-1];j=Math.ceil(b*d/q.total);h=(c-1)/(this.points.length-1);g=c/(this.points.length-1);for(d=1;d<j-1;d++)e=h+d*(1/j)*(g-h),position=this.getPoint(e),k.push(m.copy(position).clone());
k.push(m.copy(this.points[c]).clone())}this.points=k}};THREE.Edge=function(b,c,d,e){this.vertices=[b,c];this.vertexIndices=[d,e];this.faces=[];this.faceIndices=[]};THREE.Camera=function(b,c,d,e,h){THREE.Object3D.call(this);this.fov=b||50;this.aspect=c||1;this.near=d||0.1;this.far=e||2E3;this.target=h||new THREE.Object3D;this.useTarget=!0;this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=null;this.updateProjectionMatrix()};THREE.Camera.prototype=new THREE.Object3D;
THREE.Camera.prototype.constructor=THREE.Camera;THREE.Camera.prototype.supr=THREE.Object3D.prototype;THREE.Camera.prototype.translate=function(b,c){this.matrix.rotateAxis(c);c.multiplyScalar(b);this.position.addSelf(c);this.target.position.addSelf(c)};
THREE.Camera.prototype.updateProjectionMatrix=function(){if(this.fullWidth){var b=this.fullWidth/this.fullHeight,c=Math.tan(this.fov*Math.PI/360)*this.near,d=-c,e=b*d,b=Math.abs(b*c-e),d=Math.abs(c-d);this.projectionMatrix=THREE.Matrix4.makeFrustum(e+this.x*b/this.fullWidth,e+(this.x+this.width)*b/this.fullWidth,c-(this.y+this.height)*d/this.fullHeight,c-this.y*d/this.fullHeight,this.near,this.far)}else this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,this.far)};
THREE.Camera.prototype.setViewOffset=function(b,c,d,e,h,j){this.fullWidth=b;this.fullHeight=c;this.x=d;this.y=e;this.width=h;this.height=j;this.updateProjectionMatrix()};
THREE.Camera.prototype.update=function(b,c,d){if(this.useTarget)this.matrix.lookAt(this.position,this.target.position,this.up),this.matrix.setPosition(this.position),b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse),c=!0;else if(this.matrixAutoUpdate&&this.updateMatrix(),c||this.matrixWorldNeedsUpdate)b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=
!1,c=!0,THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse);for(b=0;b<this.children.length;b++)this.children[b].update(this.matrixWorld,c,d)};THREE.Light=function(b){THREE.Object3D.call(this);this.color=new THREE.Color(b)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(b){THREE.Light.call(this,b)};THREE.AmbientLight.prototype=new THREE.Light;
THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.DirectionalLight=function(b,c,d,e){THREE.Light.call(this,b);this.position=new THREE.Vector3(0,1,0);this.intensity=c||1;this.distance=d||0;this.castShadow=e!==void 0?e:!1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(b,c,d){THREE.Light.call(this,b);this.position=new THREE.Vector3;this.intensity=c||1;this.distance=d||0};
THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;THREE.SpotLight=function(b,c,d,e){THREE.Light.call(this,b);this.position=new THREE.Vector3(0,1,0);this.target=new THREE.Object3D;this.intensity=c||1;this.distance=d||0;this.castShadow=e!==void 0?e:!1};THREE.SpotLight.prototype=new THREE.Light;THREE.SpotLight.prototype.constructor=THREE.SpotLight;
THREE.Material=function(b){this.id=THREE.MaterialCount++;b=b||{};this.opacity=b.opacity!==void 0?b.opacity:1;this.transparent=b.transparent!==void 0?b.transparent:!1;this.blending=b.blending!==void 0?b.blending:THREE.NormalBlending;this.depthTest=b.depthTest!==void 0?b.depthTest:!0;this.polygonOffset=b.polygonOffset!==void 0?b.polygonOffset:!1;this.polygonOffsetFactor=b.polygonOffsetFactor!==void 0?b.polygonOffsetFactor:0;this.polygonOffsetUnits=b.polygonOffsetUnits!==void 0?b.polygonOffsetUnits:
0;this.alphaTest=b.alphaTest!==void 0?b.alphaTest:0};THREE.MaterialCount=0;THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.MultiplyBlending=3;THREE.AdditiveAlphaBlending=4;THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};THREE.LatitudeRefractionMapping=function(){};
THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};THREE.LineBasicMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.linewidth=b.linewidth!==void 0?b.linewidth:1;this.linecap=b.linecap!==void 0?b.linecap:"round";this.linejoin=b.linejoin!==void 0?b.linejoin:"round";this.vertexColors=b.vertexColors?b.vertexColors:!1};
THREE.LineBasicMaterial.prototype=new THREE.Material;THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.map=b.map!==void 0?b.map:null;this.lightMap=b.lightMap!==void 0?b.lightMap:null;this.envMap=b.envMap!==void 0?b.envMap:null;this.combine=b.combine!==void 0?b.combine:THREE.MultiplyOperation;this.reflectivity=b.reflectivity!==void 0?b.reflectivity:1;this.refractionRatio=b.refractionRatio!==void 0?b.refractionRatio:0.98;this.shading=b.shading!==
void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1;this.wireframeLinecap=b.wireframeLinecap!==void 0?b.wireframeLinecap:"round";this.wireframeLinejoin=b.wireframeLinejoin!==void 0?b.wireframeLinejoin:"round";this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1;this.skinning=b.skinning!==void 0?b.skinning:!1;this.morphTargets=b.morphTargets!==void 0?b.morphTargets:!1};
THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.map=b.map!==void 0?b.map:null;this.lightMap=b.lightMap!==void 0?b.lightMap:null;this.envMap=b.envMap!==void 0?b.envMap:null;this.combine=b.combine!==void 0?b.combine:THREE.MultiplyOperation;this.reflectivity=b.reflectivity!==void 0?b.reflectivity:1;this.refractionRatio=b.refractionRatio!==void 0?b.refractionRatio:0.98;this.shading=b.shading!==
void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1;this.wireframeLinecap=b.wireframeLinecap!==void 0?b.wireframeLinecap:"round";this.wireframeLinejoin=b.wireframeLinejoin!==void 0?b.wireframeLinejoin:"round";this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1;this.skinning=b.skinning!==void 0?b.skinning:!1;this.morphTargets=b.morphTargets!==void 0?b.morphTargets:!1};
THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.ambient=b.ambient!==void 0?new THREE.Color(b.ambient):new THREE.Color(328965);this.specular=b.specular!==void 0?new THREE.Color(b.specular):new THREE.Color(1118481);this.shininess=b.shininess!==void 0?b.shininess:30;this.map=b.map!==void 0?b.map:null;this.lightMap=b.lightMap!==void 0?b.lightMap:null;this.envMap=b.envMap!==void 0?b.envMap:null;
this.combine=b.combine!==void 0?b.combine:THREE.MultiplyOperation;this.reflectivity=b.reflectivity!==void 0?b.reflectivity:1;this.refractionRatio=b.refractionRatio!==void 0?b.refractionRatio:0.98;this.shading=b.shading!==void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1;this.wireframeLinecap=b.wireframeLinecap!==void 0?b.wireframeLinecap:"round";this.wireframeLinejoin=b.wireframeLinejoin!==
void 0?b.wireframeLinejoin:"round";this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1;this.skinning=b.skinning!==void 0?b.skinning:!1;this.morphTargets=b.morphTargets!==void 0?b.morphTargets:!1};THREE.MeshPhongMaterial.prototype=new THREE.Material;THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;
THREE.MeshDepthMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.shading=b.shading!==void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1};THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;
THREE.MeshNormalMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.shading=b.shading?b.shading:THREE.FlatShading;this.wireframe=b.wireframe?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth?b.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshFaceMaterial=function(){};
THREE.MeshShaderMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.fragmentShader=b.fragmentShader!==void 0?b.fragmentShader:"void main() {}";this.vertexShader=b.vertexShader!==void 0?b.vertexShader:"void main() {}";this.uniforms=b.uniforms!==void 0?b.uniforms:{};this.attributes=b.attributes;this.shading=b.shading!==void 0?b.shading:THREE.SmoothShading;this.wireframe=b.wireframe!==void 0?b.wireframe:!1;this.wireframeLinewidth=b.wireframeLinewidth!==void 0?b.wireframeLinewidth:1;this.fog=
b.fog!==void 0?b.fog:!1;this.lights=b.lights!==void 0?b.lights:!1;this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1;this.skinning=b.skinning!==void 0?b.skinning:!1;this.morphTargets=b.morphTargets!==void 0?b.morphTargets:!1};THREE.MeshShaderMaterial.prototype=new THREE.Material;THREE.MeshShaderMaterial.prototype.constructor=THREE.MeshShaderMaterial;
THREE.ParticleBasicMaterial=function(b){THREE.Material.call(this,b);b=b||{};this.color=b.color!==void 0?new THREE.Color(b.color):new THREE.Color(16777215);this.map=b.map!==void 0?b.map:null;this.size=b.size!==void 0?b.size:1;this.sizeAttenuation=b.sizeAttenuation!==void 0?b.sizeAttenuation:!0;this.vertexColors=b.vertexColors!==void 0?b.vertexColors:!1};THREE.ParticleBasicMaterial.prototype=new THREE.Material;THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.Texture=function(b,c,d,e,h,j){this.id=THREE.TextureCount++;this.image=b;this.mapping=c!==void 0?c:new THREE.UVMapping;this.wrapS=d!==void 0?d:THREE.ClampToEdgeWrapping;this.wrapT=e!==void 0?e:THREE.ClampToEdgeWrapping;this.magFilter=h!==void 0?h:THREE.LinearFilter;this.minFilter=j!==void 0?j:THREE.LinearMipMapLinearFilter;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.needsUpdate=!1};
THREE.Texture.prototype={constructor:THREE.Texture,clone:function(){var b=new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter);b.offset.copy(this.offset);b.repeat.copy(this.repeat);return b}};THREE.TextureCount=0;THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;
THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;THREE.ShortType=11;THREE.UnsignedShortType=12;THREE.IntType=13;THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;THREE.Particle=function(b){THREE.Object3D.call(this);this.materials=b instanceof Array?b:[b]};THREE.Particle.prototype=new THREE.Object3D;
THREE.Particle.prototype.constructor=THREE.Particle;THREE.ParticleSystem=function(b,c){THREE.Object3D.call(this);this.geometry=b;this.materials=c instanceof Array?c:[c];this.sortParticles=!1};THREE.ParticleSystem.prototype=new THREE.Object3D;THREE.ParticleSystem.prototype.constructor=THREE.ParticleSystem;THREE.Line=function(b,c,d){THREE.Object3D.call(this);this.geometry=b;this.materials=c instanceof Array?c:[c];this.type=d!=void 0?d:THREE.LineStrip};THREE.LineStrip=0;THREE.LinePieces=1;
THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(b,c){THREE.Object3D.call(this);this.geometry=b;this.materials=c&&c.length?c:[c];this.overdraw=!1;if(this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere(),this.boundRadius=b.boundingSphere.radius,this.geometry.morphTargets.length)){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var d=0;d<this.geometry.morphTargets.length;d++)this.morphTargetInfluences.push(0),this.morphTargetDictionary[this.geometry.morphTargets[d].name]=
d}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;THREE.Mesh.prototype.getMorphTargetIndexByName=function(b){if(this.morphTargetDictionary[b]!==void 0)return this.morphTargetDictionary[b];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+b+" does not exist. Returning 0.");return 0};
THREE.Bone=function(b){THREE.Object3D.call(this);this.skin=b;this.skinMatrix=new THREE.Matrix4;this.hasNoneBoneChildren=!1};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(b,c,d){this.matrixAutoUpdate&&(c|=this.updateMatrix());if(c||this.matrixWorldNeedsUpdate)b?this.skinMatrix.multiply(b,this.matrix):this.skinMatrix.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,c=!0;var e,h=this.children.length;if(this.hasNoneBoneChildren){this.matrixWorld.multiply(this.skin.matrixWorld,this.skinMatrix);for(e=0;e<h;e++)b=this.children[e],b instanceof THREE.Bone?b.update(this.skinMatrix,c,d):b.update(this.matrixWorld,!0,d)}else for(e=0;e<h;e++)this.children[e].update(this.skinMatrix,
c,d)};THREE.Bone.prototype.addChild=function(b){if(this.children.indexOf(b)===-1&&(b.parent!==void 0&&b.parent.removeChild(b),b.parent=this,this.children.push(b),!(b instanceof THREE.Bone)))this.hasNoneBoneChildren=!0};
THREE.SkinnedMesh=function(b,c){THREE.Mesh.call(this,b,c);this.identityMatrix=new THREE.Matrix4;this.bones=[];this.boneMatrices=[];var d,e,h,j,g,k;if(this.geometry.bones!==void 0){for(d=0;d<this.geometry.bones.length;d++)h=this.geometry.bones[d],j=h.pos,g=h.rotq,k=h.scl,e=this.addBone(),e.name=h.name,e.position.set(j[0],j[1],j[2]),e.quaternion.set(g[0],g[1],g[2],g[3]),e.useQuaternion=!0,k!==void 0?e.scale.set(k[0],k[1],k[2]):e.scale.set(1,1,1);for(d=0;d<this.bones.length;d++)h=this.geometry.bones[d],
e=this.bones[d],h.parent===-1?this.addChild(e):this.bones[h.parent].addChild(e);this.boneMatrices=new Float32Array(16*this.bones.length);this.pose()}};THREE.SkinnedMesh.prototype=new THREE.Mesh;THREE.SkinnedMesh.prototype.constructor=THREE.SkinnedMesh;
THREE.SkinnedMesh.prototype.update=function(b,c,d){if(this.visible){this.matrixAutoUpdate&&(c|=this.updateMatrix());if(c||this.matrixWorldNeedsUpdate)b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,c=!0;var e,h=this.children.length;for(e=0;e<h;e++)b=this.children[e],b instanceof THREE.Bone?b.update(this.identityMatrix,!1,d):b.update(this.matrixWorld,c,d);d=this.bones.length;ba=this.bones;bm=this.boneMatrices;for(c=0;c<d;c++)ba[c].skinMatrix.flattenToArrayOffset(bm,
c*16)}};THREE.SkinnedMesh.prototype.addBone=function(b){b===void 0&&(b=new THREE.Bone(this));this.bones.push(b);return b};
THREE.SkinnedMesh.prototype.pose=function(){this.update(void 0,!0);for(var b,c=[],d=0;d<this.bones.length;d++)b=this.bones[d],c.push(THREE.Matrix4.makeInvert(b.skinMatrix)),b.skinMatrix.flattenToArrayOffset(this.boneMatrices,d*16);if(this.geometry.skinVerticesA===void 0){this.geometry.skinVerticesA=[];this.geometry.skinVerticesB=[];var e;for(b=0;b<this.geometry.skinIndices.length;b++){var d=this.geometry.vertices[b].position,h=this.geometry.skinIndices[b].x,j=this.geometry.skinIndices[b].y;e=new THREE.Vector3(d.x,
d.y,d.z);this.geometry.skinVerticesA.push(c[h].multiplyVector3(e));e=new THREE.Vector3(d.x,d.y,d.z);this.geometry.skinVerticesB.push(c[j].multiplyVector3(e));this.geometry.skinWeights[b].x+this.geometry.skinWeights[b].y!==1&&(d=(1-(this.geometry.skinWeights[b].x+this.geometry.skinWeights[b].y))*0.5,this.geometry.skinWeights[b].x+=d,this.geometry.skinWeights[b].y+=d)}}};THREE.Ribbon=function(b,c){THREE.Object3D.call(this);this.geometry=b;this.materials=c instanceof Array?c:[c]};
THREE.Ribbon.prototype=new THREE.Object3D;THREE.Ribbon.prototype.constructor=THREE.Ribbon;THREE.LOD=function(){THREE.Object3D.call(this);this.LODs=[]};THREE.LOD.prototype=new THREE.Object3D;THREE.LOD.prototype.constructor=THREE.LOD;THREE.LOD.prototype.supr=THREE.Object3D.prototype;THREE.LOD.prototype.add=function(b,c){c===void 0&&(c=0);for(var c=Math.abs(c),d=0;d<this.LODs.length;d++)if(c<this.LODs[d].visibleAtDistance)break;this.LODs.splice(d,0,{visibleAtDistance:c,object3D:b});this.addChild(b)};
THREE.LOD.prototype.update=function(b,c,d){this.matrixAutoUpdate&&(c|=this.updateMatrix());if(c||this.matrixWorldNeedsUpdate)b?this.matrixWorld.multiply(b,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,c=!0;if(this.LODs.length>1){b=d.matrixWorldInverse;b=-(b.n31*this.position.x+b.n32*this.position.y+b.n33*this.position.z+b.n34);this.LODs[0].object3D.visible=!0;for(var e=1;e<this.LODs.length;e++)if(b>=this.LODs[e].visibleAtDistance)this.LODs[e-1].object3D.visible=!1,
this.LODs[e].object3D.visible=!0;else break;for(;e<this.LODs.length;e++)this.LODs[e].object3D.visible=!1}for(b=0;b<this.children.length;b++)this.children[b].update(this.matrixWorld,c,d)};
THREE.Sprite=function(b){THREE.Object3D.call(this);if(b.material!==void 0)this.material=b.material,this.map=void 0,this.blending=material.blending;else if(b.map!==void 0)this.map=b.map instanceof THREE.Texture?b.map:THREE.ImageUtils.loadTexture(b.map),this.material=void 0,this.blending=b.blending!==void 0?b.blending:THREE.NormalBlending;this.useScreenCoordinates=b.useScreenCoordinates!==void 0?b.useScreenCoordinates:!0;this.mergeWith3D=b.mergeWith3D!==void 0?b.mergeWith3D:!this.useScreenCoordinates;
this.affectedByDistance=b.affectedByDistance!==void 0?b.affectedByDistance:!this.useScreenCoordinates;this.scaleByViewport=b.scaleByViewport!==void 0?b.scaleByViewport:!this.affectedByDistance;this.alignment=b.alignment instanceof THREE.Vector2?b.alignment:THREE.SpriteAlignment.center;this.rotation3d=this.rotation;this.rotation=0;this.opacity=1;this.uvOffset=new THREE.Vector2(0,0);this.uvScale=new THREE.Vector2(1,1)};THREE.Sprite.prototype=new THREE.Object3D;THREE.Sprite.prototype.constructor=THREE.Sprite;
THREE.Sprite.prototype.supr=THREE.Object3D.prototype;THREE.Sprite.prototype.updateMatrix=function(){this.matrix.setPosition(this.position);this.rotation3d.set(0,0,this.rotation);this.matrix.setRotationFromEuler(this.rotation3d);if(this.scale.x!==1||this.scale.y!==1)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,this.scale.y);this.matrixWorldNeedsUpdate=!0};THREE.SpriteAlignment={};THREE.SpriteAlignment.topLeft=new THREE.Vector2(1,-1);
THREE.SpriteAlignment.topCenter=new THREE.Vector2(0,-1);THREE.SpriteAlignment.topRight=new THREE.Vector2(-1,-1);THREE.SpriteAlignment.centerLeft=new THREE.Vector2(1,0);THREE.SpriteAlignment.center=new THREE.Vector2(0,0);THREE.SpriteAlignment.centerRight=new THREE.Vector2(-1,0);THREE.SpriteAlignment.bottomLeft=new THREE.Vector2(1,1);THREE.SpriteAlignment.bottomCenter=new THREE.Vector2(0,1);THREE.SpriteAlignment.bottomRight=new THREE.Vector2(-1,1);
THREE.Scene=function(){THREE.Object3D.call(this);this.matrixAutoUpdate=!1;this.collisions=this.overrideMaterial=this.fog=null;this.objects=[];this.lights=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;THREE.Scene.prototype.supr=THREE.Object3D.prototype;THREE.Scene.prototype.addChild=function(b){this.supr.addChild.call(this,b);this.addChildRecurse(b)};
THREE.Scene.prototype.addChildRecurse=function(b){if(b instanceof THREE.Light)this.lights.indexOf(b)===-1&&this.lights.push(b);else if(!(b instanceof THREE.Camera||b instanceof THREE.Bone)&&this.objects.indexOf(b)===-1)this.objects.push(b),this.__objectsAdded.push(b);for(var c=0;c<b.children.length;c++)this.addChildRecurse(b.children[c])};THREE.Scene.prototype.removeChild=function(b){this.supr.removeChild.call(this,b);this.removeChildRecurse(b)};
THREE.Scene.prototype.removeChildRecurse=function(b){if(b instanceof THREE.Light){var c=this.lights.indexOf(b);c!==-1&&this.lights.splice(c,1)}else b instanceof THREE.Camera||(c=this.objects.indexOf(b),c!==-1&&(this.objects.splice(c,1),this.__objectsRemoved.push(b)));for(c=0;c<b.children.length;c++)this.removeChildRecurse(b.children[c])};THREE.Scene.prototype.addObject=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeObject=THREE.Scene.prototype.removeChild;
THREE.Scene.prototype.addLight=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeLight=THREE.Scene.prototype.removeChild;THREE.Fog=function(b,c,d){this.color=new THREE.Color(b);this.near=c||1;this.far=d||1E3};THREE.FogExp2=function(b,c){this.color=new THREE.Color(b);this.density=c!==void 0?c:2.5E-4};
THREE.Projector=function(){function b(){var b=q[k]=q[k]||new THREE.RenderableVertex;k++;return b}function c(b,c){return c.z-b.z}function d(b,c){var d=0,f=1,e=b.z+b.w,h=c.z+c.w,g=-b.z+b.w,j=-c.z+c.w;return e>=0&&h>=0&&g>=0&&j>=0?!0:e<0&&h<0||g<0&&j<0?!1:(e<0?d=Math.max(d,e/(e-h)):h<0&&(f=Math.min(f,e/(e-h))),g<0?d=Math.max(d,g/(g-j)):j<0&&(f=Math.min(f,g/(g-j))),f<d?!1:(b.lerpSelf(c,d),c.lerpSelf(b,1-f),!0))}var e,h,j=[],g,k,q=[],m,o,p=[],r,v=[],C,x,E=[],J,ya,za=[],sa=new THREE.Vector4,V=new THREE.Vector4,
u=new THREE.Matrix4,Q=new THREE.Matrix4,O=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],T=new THREE.Vector4,U=new THREE.Vector4;this.projectVector=function(b,c){u.multiply(c.projectionMatrix,c.matrixWorldInverse);u.multiplyVector3(b);return b};this.unprojectVector=function(b,c){u.multiply(c.matrixWorld,THREE.Matrix4.makeInvert(c.projectionMatrix));u.multiplyVector3(b);return b};this.projectObjects=function(b,d,g){var d=[],f,k,m;h=0;k=
b.objects;b=0;for(f=k.length;b<f;b++){m=k[b];var q;if(!(q=!m.visible))if(q=m instanceof THREE.Mesh){a:{q=void 0;for(var o=m.matrixWorld,p=-m.geometry.boundingSphere.radius*Math.max(m.scale.x,Math.max(m.scale.y,m.scale.z)),r=0;r<6;r++)if(q=O[r].x*o.n14+O[r].y*o.n24+O[r].z*o.n34+O[r].w,q<=p){q=!1;break a}q=!0}q=!q}if(!q)q=j[h]=j[h]||new THREE.RenderableObject,h++,e=q,sa.copy(m.position),u.multiplyVector3(sa),e.object=m,e.z=sa.z,d.push(e)}g&&d.sort(c);return d};this.projectScene=function(e,h,j){var f=
[],sa=h.near,Aa=h.far,ta,va,Y,pa,D,W,P,S,fa,K,Ba,Ea,wa,ha,Z,Fa,Da;ya=x=r=o=0;h.matrixAutoUpdate&&h.update(void 0,!0);e.update(void 0,!1,h);u.multiply(h.projectionMatrix,h.matrixWorldInverse);O[0].set(u.n41-u.n11,u.n42-u.n12,u.n43-u.n13,u.n44-u.n14);O[1].set(u.n41+u.n11,u.n42+u.n12,u.n43+u.n13,u.n44+u.n14);O[2].set(u.n41+u.n21,u.n42+u.n22,u.n43+u.n23,u.n44+u.n24);O[3].set(u.n41-u.n21,u.n42-u.n22,u.n43-u.n23,u.n44-u.n24);O[4].set(u.n41-u.n31,u.n42-u.n32,u.n43-u.n33,u.n44-u.n34);O[5].set(u.n41+u.n31,
u.n42+u.n32,u.n43+u.n33,u.n44+u.n34);for(ta=0;ta<6;ta++)fa=O[ta],fa.divideScalar(Math.sqrt(fa.x*fa.x+fa.y*fa.y+fa.z*fa.z));fa=this.projectObjects(e,h,!0);e=0;for(ta=fa.length;e<ta;e++)if(K=fa[e].object,K.visible)if(Ba=K.matrixWorld,Ea=K.matrixRotationWorld,wa=K.materials,ha=K.overdraw,k=0,K instanceof THREE.Mesh){Z=K.geometry;pa=Z.vertices;Fa=Z.faces;Z=Z.faceVertexUvs;va=0;for(Y=pa.length;va<Y;va++)g=b(),g.positionWorld.copy(pa[va].position),Ba.multiplyVector3(g.positionWorld),g.positionScreen.copy(g.positionWorld),
u.multiplyVector4(g.positionScreen),g.positionScreen.x/=g.positionScreen.w,g.positionScreen.y/=g.positionScreen.w,g.visible=g.positionScreen.z>sa&&g.positionScreen.z<Aa;pa=0;for(va=Fa.length;pa<va;pa++){Y=Fa[pa];if(Y instanceof THREE.Face3)if(D=q[Y.a],W=q[Y.b],P=q[Y.c],D.visible&&W.visible&&P.visible&&(K.doubleSided||K.flipSided!=(P.positionScreen.x-D.positionScreen.x)*(W.positionScreen.y-D.positionScreen.y)-(P.positionScreen.y-D.positionScreen.y)*(W.positionScreen.x-D.positionScreen.x)<0))S=p[o]=
p[o]||new THREE.RenderableFace3,o++,m=S,m.v1.copy(D),m.v2.copy(W),m.v3.copy(P);else continue;else if(Y instanceof THREE.Face4)if(D=q[Y.a],W=q[Y.b],P=q[Y.c],S=q[Y.d],D.visible&&W.visible&&P.visible&&S.visible&&(K.doubleSided||K.flipSided!=((S.positionScreen.x-D.positionScreen.x)*(W.positionScreen.y-D.positionScreen.y)-(S.positionScreen.y-D.positionScreen.y)*(W.positionScreen.x-D.positionScreen.x)<0||(W.positionScreen.x-P.positionScreen.x)*(S.positionScreen.y-P.positionScreen.y)-(W.positionScreen.y-
P.positionScreen.y)*(S.positionScreen.x-P.positionScreen.x)<0)))Da=v[r]=v[r]||new THREE.RenderableFace4,r++,m=Da,m.v1.copy(D),m.v2.copy(W),m.v3.copy(P),m.v4.copy(S);else continue;m.normalWorld.copy(Y.normal);Ea.multiplyVector3(m.normalWorld);m.centroidWorld.copy(Y.centroid);Ba.multiplyVector3(m.centroidWorld);m.centroidScreen.copy(m.centroidWorld);u.multiplyVector3(m.centroidScreen);P=Y.vertexNormals;D=0;for(W=P.length;D<W;D++)S=m.vertexNormalsWorld[D],S.copy(P[D]),Ea.multiplyVector3(S);D=0;for(W=
Z.length;D<W;D++)if(Da=Z[D][pa]){P=0;for(S=Da.length;P<S;P++)m.uvs[D][P]=Da[P]}m.meshMaterials=wa;m.faceMaterials=Y.materials;m.overdraw=ha;m.z=m.centroidScreen.z;f.push(m)}}else if(K instanceof THREE.Line){Q.multiply(u,Ba);pa=K.geometry.vertices;D=b();D.positionScreen.copy(pa[0].position);Q.multiplyVector4(D.positionScreen);va=1;for(Y=pa.length;va<Y;va++)if(D=b(),D.positionScreen.copy(pa[va].position),Q.multiplyVector4(D.positionScreen),W=q[k-2],T.copy(D.positionScreen),U.copy(W.positionScreen),
d(T,U))T.multiplyScalar(1/T.w),U.multiplyScalar(1/U.w),Ba=E[x]=E[x]||new THREE.RenderableLine,x++,C=Ba,C.v1.positionScreen.copy(T),C.v2.positionScreen.copy(U),C.z=Math.max(T.z,U.z),C.materials=K.materials,f.push(C)}else if(K instanceof THREE.Particle&&(V.set(K.matrixWorld.n14,K.matrixWorld.n24,K.matrixWorld.n34,1),u.multiplyVector4(V),V.z/=V.w,V.z>0&&V.z<1))Ba=za[ya]=za[ya]||new THREE.RenderableParticle,ya++,J=Ba,J.x=V.x/V.w,J.y=V.y/V.w,J.z=V.z,J.rotation=K.rotation.z,J.scale.x=K.scale.x*Math.abs(J.x-
(V.x+h.projectionMatrix.n11)/(V.w+h.projectionMatrix.n14)),J.scale.y=K.scale.y*Math.abs(J.y-(V.y+h.projectionMatrix.n22)/(V.w+h.projectionMatrix.n24)),J.materials=K.materials,f.push(J);j&&f.sort(c);return f}};
THREE.ShaderChunk={fog_pars_fragment:"#ifdef USE_FOG\nuniform vec3 fogColor;\n#ifdef FOG_EXP2\nuniform float fogDensity;\n#else\nuniform float fogNear;\nuniform float fogFar;\n#endif\n#endif",fog_fragment:"#ifdef USE_FOG\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\n#ifdef FOG_EXP2\nconst float LOG2 = 1.442695;\nfloat fogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );\nfogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );\n#else\nfloat fogFactor = smoothstep( fogNear, fogFar, depth );\n#endif\ngl_FragColor = mix( gl_FragColor, vec4( fogColor, gl_FragColor.w ), fogFactor );\n#endif",envmap_pars_fragment:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float reflectivity;\nuniform samplerCube envMap;\nuniform int combine;\n#endif",
envmap_fragment:"#ifdef USE_ENVMAP\nvec4 cubeColor = textureCube( envMap, vec3( -vReflect.x, vReflect.yz ) );\nif ( combine == 1 ) {\ngl_FragColor = vec4( mix( gl_FragColor.xyz, cubeColor.xyz, reflectivity ), opacity );\n} else {\ngl_FragColor = gl_FragColor * cubeColor;\n}\n#endif",envmap_pars_vertex:"#ifdef USE_ENVMAP\nvarying vec3 vReflect;\nuniform float refractionRatio;\nuniform bool useRefract;\n#endif",envmap_vertex:"#ifdef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\nvec3 nWorld = mat3( objectMatrix[ 0 ].xyz, objectMatrix[ 1 ].xyz, objectMatrix[ 2 ].xyz ) * normal;\nif ( useRefract ) {\nvReflect = refract( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ), refractionRatio );\n} else {\nvReflect = reflect( normalize( mPosition.xyz - cameraPosition ), normalize( nWorld.xyz ) );\n}\n#endif",
map_particle_pars_fragment:"#ifdef USE_MAP\nuniform sampler2D map;\n#endif",map_particle_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, gl_PointCoord );\n#endif",map_pars_vertex:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform vec4 offsetRepeat;\n#endif",map_pars_fragment:"#ifdef USE_MAP\nvarying vec2 vUv;\nuniform sampler2D map;\n#endif",map_vertex:"#ifdef USE_MAP\nvUv = uv * offsetRepeat.zw + offsetRepeat.xy;\n#endif",map_fragment:"#ifdef USE_MAP\ngl_FragColor = gl_FragColor * texture2D( map, vUv );\n#endif",
lightmap_pars_fragment:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\nuniform sampler2D lightMap;\n#endif",lightmap_pars_vertex:"#ifdef USE_LIGHTMAP\nvarying vec2 vUv2;\n#endif",lightmap_fragment:"#ifdef USE_LIGHTMAP\ngl_FragColor = gl_FragColor * texture2D( lightMap, vUv2 );\n#endif",lightmap_vertex:"#ifdef USE_LIGHTMAP\nvUv2 = uv2;\n#endif",lights_pars_vertex:"uniform bool enableLighting;\nuniform vec3 ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightColor[ MAX_DIR_LIGHTS ];\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nuniform vec3 pointLightColor[ MAX_POINT_LIGHTS ];\nuniform vec3 pointLightPosition[ MAX_POINT_LIGHTS ];\nuniform float pointLightDistance[ MAX_POINT_LIGHTS ];\n#ifdef PHONG\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\n#endif",
lights_vertex:"if ( !enableLighting ) {\nvLightWeighting = vec3( 1.0 );\n} else {\nvLightWeighting = ambientLightColor;\n#if MAX_DIR_LIGHTS > 0\nfor( int i = 0; i < MAX_DIR_LIGHTS; i ++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nfloat directionalLightWeighting = max( dot( transformedNormal, normalize( lDirection.xyz ) ), 0.0 );\nvLightWeighting += directionalLightColor[ i ] * directionalLightWeighting;\n}\n#endif\n#if MAX_POINT_LIGHTS > 0\nfor( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec4 lPosition = viewMatrix * vec4( pointLightPosition[ i ], 1.0 );\nvec3 lVector = lPosition.xyz - mvPosition.xyz;\nfloat lDistance = 1.0;\nif ( pointLightDistance[ i ] > 0.0 )\nlDistance = 1.0 - min( ( length( lVector ) / pointLightDistance[ i ] ), 1.0 );\nlVector = normalize( lVector );\nfloat pointLightWeighting = max( dot( transformedNormal, lVector ), 0.0 );\nvLightWeighting += pointLightColor[ i ] * pointLightWeighting * lDistance;\n#ifdef PHONG\nvPointLight[ i ] = vec4( lVector, lDistance );\n#endif\n}\n#endif\n}",
lights_pars_fragment:"#if MAX_DIR_LIGHTS > 0\nuniform vec3 directionalLightDirection[ MAX_DIR_LIGHTS ];\n#endif\n#if MAX_POINT_LIGHTS > 0\nvarying vec4 vPointLight[ MAX_POINT_LIGHTS ];\n#endif\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",lights_fragment:"vec3 normal = normalize( vNormal );\nvec3 viewPosition = normalize( vViewPosition );\nvec4 mColor = vec4( diffuse, opacity );\nvec4 mSpecular = vec4( specular, opacity );\n#if MAX_POINT_LIGHTS > 0\nvec4 pointDiffuse  = vec4( vec3( 0.0 ), 1.0 );\nvec4 pointSpecular = vec4( vec3( 0.0 ), 1.0 );\nfor ( int i = 0; i < MAX_POINT_LIGHTS; i ++ ) {\nvec3 pointVector = normalize( vPointLight[ i ].xyz );\nvec3 pointHalfVector = normalize( vPointLight[ i ].xyz + viewPosition );\nfloat pointDistance = vPointLight[ i ].w;\nfloat pointDotNormalHalf = dot( normal, pointHalfVector );\nfloat pointDiffuseWeight = max( dot( normal, pointVector ), 0.0 );\nfloat pointSpecularWeight = 0.0;\nif ( pointDotNormalHalf >= 0.0 )\npointSpecularWeight = pow( pointDotNormalHalf, shininess );\npointDiffuse  += mColor * pointDiffuseWeight * pointDistance;\npointSpecular += mSpecular * pointSpecularWeight * pointDistance;\n}\n#endif\n#if MAX_DIR_LIGHTS > 0\nvec4 dirDiffuse  = vec4( vec3( 0.0 ), 1.0 );\nvec4 dirSpecular = vec4( vec3( 0.0 ), 1.0 );\nfor( int i = 0; i < MAX_DIR_LIGHTS; i ++ ) {\nvec4 lDirection = viewMatrix * vec4( directionalLightDirection[ i ], 0.0 );\nvec3 dirVector = normalize( lDirection.xyz );\nvec3 dirHalfVector = normalize( lDirection.xyz + viewPosition );\nfloat dirDotNormalHalf = dot( normal, dirHalfVector );\nfloat dirDiffuseWeight = max( dot( normal, dirVector ), 0.0 );\nfloat dirSpecularWeight = 0.0;\nif ( dirDotNormalHalf >= 0.0 )\ndirSpecularWeight = pow( dirDotNormalHalf, shininess );\ndirDiffuse  += mColor * dirDiffuseWeight;\ndirSpecular += mSpecular * dirSpecularWeight;\n}\n#endif\nvec4 totalLight = vec4( ambient, opacity );\n#if MAX_DIR_LIGHTS > 0\ntotalLight += dirDiffuse + dirSpecular;\n#endif\n#if MAX_POINT_LIGHTS > 0\ntotalLight += pointDiffuse + pointSpecular;\n#endif\ngl_FragColor = gl_FragColor * totalLight;",
color_pars_fragment:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_fragment:"#ifdef USE_COLOR\ngl_FragColor = gl_FragColor * vec4( vColor, opacity );\n#endif",color_pars_vertex:"#ifdef USE_COLOR\nvarying vec3 vColor;\n#endif",color_vertex:"#ifdef USE_COLOR\nvColor = color;\n#endif",skinning_pars_vertex:"#ifdef USE_SKINNING\nuniform mat4 boneGlobalMatrices[ MAX_BONES ];\n#endif",skinning_vertex:"#ifdef USE_SKINNING\ngl_Position  = ( boneGlobalMatrices[ int( skinIndex.x ) ] * skinVertexA ) * skinWeight.x;\ngl_Position += ( boneGlobalMatrices[ int( skinIndex.y ) ] * skinVertexB ) * skinWeight.y;\ngl_Position  = projectionMatrix * viewMatrix * objectMatrix * gl_Position;\n#endif",
morphtarget_pars_vertex:"#ifdef USE_MORPHTARGETS\nuniform float morphTargetInfluences[ 8 ];\n#endif",morphtarget_vertex:"#ifdef USE_MORPHTARGETS\nvec3 morphed = vec3( 0.0, 0.0, 0.0 );\nmorphed += ( morphTarget0 - position ) * morphTargetInfluences[ 0 ];\nmorphed += ( morphTarget1 - position ) * morphTargetInfluences[ 1 ];\nmorphed += ( morphTarget2 - position ) * morphTargetInfluences[ 2 ];\nmorphed += ( morphTarget3 - position ) * morphTargetInfluences[ 3 ];\nmorphed += ( morphTarget4 - position ) * morphTargetInfluences[ 4 ];\nmorphed += ( morphTarget5 - position ) * morphTargetInfluences[ 5 ];\nmorphed += ( morphTarget6 - position ) * morphTargetInfluences[ 6 ];\nmorphed += ( morphTarget7 - position ) * morphTargetInfluences[ 7 ];\nmorphed += position;\ngl_Position = projectionMatrix * modelViewMatrix * vec4( morphed, 1.0 );\n#endif",
default_vertex:"#ifndef USE_MORPHTARGETS\n#ifndef USE_SKINNING\ngl_Position = projectionMatrix * mvPosition;\n#endif\n#endif",shadowmap_pars_fragment:"#ifdef USE_SHADOWMAP\nuniform sampler2D shadowMap[ MAX_SHADOWS ];\nuniform float shadowDarkness;\nuniform float shadowBias;\nvarying vec4 vShadowCoord[ MAX_SHADOWS ];\nfloat unpackDepth( const in vec4 rgba_depth ) {\nconst vec4 bit_shift = vec4( 1.0 / ( 256.0 * 256.0 * 256.0 ), 1.0 / ( 256.0 * 256.0 ), 1.0 / 256.0, 1.0 );\nfloat depth = dot( rgba_depth, bit_shift );\nreturn depth;\n}\n#endif",
shadowmap_fragment:"#ifdef USE_SHADOWMAP\n#ifdef SHADOWMAP_SOFT\nconst float xPixelOffset = 1.0 / SHADOWMAP_WIDTH;\nconst float yPixelOffset = 1.0 / SHADOWMAP_HEIGHT;\n#endif\nvec4 shadowColor = vec4( 1.0 );\nfor( int i = 0; i < MAX_SHADOWS; i ++ ) {\nvec3 shadowCoord = vShadowCoord[ i ].xyz / vShadowCoord[ i ].w;\nif ( shadowCoord.x >= 0.0 && shadowCoord.x <= 1.0 && shadowCoord.y >= 0.0 && shadowCoord.y <= 1.0 ) {\n#ifdef SHADOWMAP_SOFT\nfloat shadow = 0.0;\nfor ( float y = -1.25; y <= 1.25; y += 1.25 )\nfor ( float x = -1.25; x <= 1.25; x += 1.25 ) {\nvec4 rgbaDepth = texture2D( shadowMap[ i ], vec2( x * xPixelOffset, y * yPixelOffset ) + shadowCoord.xy );\nfloat fDepth = unpackDepth( rgbaDepth );\nif ( fDepth < ( shadowCoord.z + shadowBias ) )\nshadow += 1.0;\n}\nshadow /= 9.0;\nshadowColor = shadowColor * vec4( vec3( ( 1.0 - shadowDarkness * shadow ) ), 1.0 );\n#else\nvec4 rgbaDepth = texture2D( shadowMap[ i ], shadowCoord.xy );\nfloat fDepth = unpackDepth( rgbaDepth );\nif ( fDepth < ( shadowCoord.z + shadowBias ) )\nshadowColor = shadowColor * vec4( vec3( shadowDarkness ), 1.0 );\n#endif\n}\n}\ngl_FragColor = gl_FragColor * shadowColor;\n#endif",
shadowmap_pars_vertex:"#ifdef USE_SHADOWMAP\nvarying vec4 vShadowCoord[ MAX_SHADOWS ];\nuniform mat4 shadowMatrix[ MAX_SHADOWS ];\n#endif",shadowmap_vertex:"#ifdef USE_SHADOWMAP\nfor( int i = 0; i < MAX_SHADOWS; i ++ ) {\nvShadowCoord[ i ] = shadowMatrix[ i ] * objectMatrix * vec4( position, 1.0 );\n}\n#endif",alphatest_fragment:"#ifdef ALPHATEST\nif ( gl_FragColor.a < ALPHATEST ) discard;\n#endif"};
THREE.UniformsUtils={merge:function(b){var c,d,e,h={};for(c=0;c<b.length;c++)for(d in e=this.clone(b[c]),e)h[d]=e[d];return h},clone:function(b){var c,d,e,h={};for(c in b)for(d in h[c]={},b[c])e=b[c][d],h[c][d]=e instanceof THREE.Color||e instanceof THREE.Vector2||e instanceof THREE.Vector3||e instanceof THREE.Vector4||e instanceof THREE.Matrix4||e instanceof THREE.Texture?e.clone():e instanceof Array?e.slice():e;return h}};
THREE.UniformsLib={common:{diffuse:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},map:{type:"t",value:0,texture:null},offsetRepeat:{type:"v4",value:new THREE.Vector4(0,0,1,1)},lightMap:{type:"t",value:2,texture:null},envMap:{type:"t",value:1,texture:null},useRefract:{type:"i",value:0},reflectivity:{type:"f",value:1},refractionRatio:{type:"f",value:0.98},combine:{type:"i",value:0},morphTargetInfluences:{type:"f",value:0}},fog:{fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",
value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}},lights:{enableLighting:{type:"i",value:1},ambientLightColor:{type:"fv",value:[]},directionalLightDirection:{type:"fv",value:[]},directionalLightColor:{type:"fv",value:[]},pointLightColor:{type:"fv",value:[]},pointLightPosition:{type:"fv",value:[]},pointLightDistance:{type:"fv1",value:[]}},particle:{psColor:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"f",value:1},size:{type:"f",value:1},scale:{type:"f",
value:1},map:{type:"t",value:0,texture:null},fogDensity:{type:"f",value:2.5E-4},fogNear:{type:"f",value:1},fogFar:{type:"f",value:2E3},fogColor:{type:"c",value:new THREE.Color(16777215)}},shadowmap:{shadowMap:{type:"tv",value:3,texture:[]},shadowMatrix:{type:"m4v",value:[]},shadowBias:{type:"f",value:0.0039},shadowDarkness:{type:"f",value:0.2}}};
THREE.ShaderLib={lensFlareVertexTexture:{vertexShader:"uniform vec3 screenPosition;\nuniform vec2 scale;\nuniform float rotation;\nuniform int renderType;\nuniform sampler2D occlusionMap;\nattribute vec2 position;\nattribute vec2 UV;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nvUV = UV;\nvec2 pos = position;\nif( renderType == 2 ) {\nvec4 visibility = texture2D( occlusionMap, vec2( 0.1, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.1 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.5 ) ) +\ntexture2D( occlusionMap, vec2( 0.9, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.1, 0.9 ) ) +\ntexture2D( occlusionMap, vec2( 0.1, 0.5 ) ) +\ntexture2D( occlusionMap, vec2( 0.5, 0.5 ) );\nvVisibility = (       visibility.r / 9.0 ) *\n( 1.0 - visibility.g / 9.0 ) *\n(       visibility.b / 9.0 ) *\n( 1.0 - visibility.a / 9.0 );\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D map;\nuniform float opacity;\nuniform int renderType;\nvarying vec2 vUV;\nvarying float vVisibility;\nvoid main() {\nif( renderType == 0 ) {\ngl_FragColor = vec4( 1.0, 0.0, 1.0, 0.0 );\n} else if( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nvec4 color = texture2D( map, vUV );\ncolor.a *= opacity * vVisibility;\ngl_FragColor = color;\n}\n}"},
lensFlare:{vertexShader:"uniform vec3 screenPosition;\nuniform vec2 scale;\nuniform float rotation;\nuniform int renderType;\nattribute vec2 position;\nattribute vec2 UV;\nvarying vec2 vUV;\nvoid main() {\nvUV = UV;\nvec2 pos = position;\nif( renderType == 2 ) {\npos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;\npos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;\n}\ngl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );\n}",fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D map;\nuniform sampler2D occlusionMap;\nuniform float opacity;\nuniform int renderType;\nvarying vec2 vUV;\nvoid main() {\nif( renderType == 0 ) {\ngl_FragColor = vec4( texture2D( map, vUV ).rgb, 0.0 );\n} else if( renderType == 1 ) {\ngl_FragColor = texture2D( map, vUV );\n} else {\nfloat visibility = texture2D( occlusionMap, vec2( 0.5, 0.1 ) ).a +\ntexture2D( occlusionMap, vec2( 0.9, 0.5 ) ).a +\ntexture2D( occlusionMap, vec2( 0.5, 0.9 ) ).a +\ntexture2D( occlusionMap, vec2( 0.1, 0.5 ) ).a;\nvisibility = ( 1.0 - visibility / 4.0 );\nvec4 color = texture2D( map, vUV );\ncolor.a *= opacity * visibility;\ngl_FragColor = color;\n}\n}"},
sprite:{vertexShader:"uniform int useScreenCoordinates;\nuniform int affectedByDistance;\nuniform vec3 screenPosition;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform float rotation;\nuniform vec2 scale;\nuniform vec2 alignment;\nuniform vec2 uvOffset;\nuniform vec2 uvScale;\nattribute vec2 position;\nattribute vec2 uv;\nvarying vec2 vUV;\nvoid main() {\nvUV = uvOffset + uv * uvScale;\nvec2 alignedPosition = position + alignment;\nvec2 rotatedPosition;\nrotatedPosition.x = ( cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y ) * scale.x;\nrotatedPosition.y = ( sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y ) * scale.y;\nvec4 finalPosition;\nif( useScreenCoordinates != 0 ) {\nfinalPosition = vec4( screenPosition.xy + rotatedPosition, screenPosition.z, 1.0 );\n} else {\nfinalPosition = projectionMatrix * modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );\nfinalPosition.xy += rotatedPosition * ( affectedByDistance == 1 ? 1.0 : finalPosition.z );\n}\ngl_Position = finalPosition;\n}",
fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D map;\nuniform float opacity;\nvarying vec2 vUV;\nvoid main() {\nvec4 color = texture2D( map, vUV );\ncolor.a *= opacity;\ngl_FragColor = color;\n}"},shadowPost:{vertexShader:"uniform \tmat4 \tprojectionMatrix;\nattribute \tvec3 \tposition;\nvoid main() {\ngl_Position = projectionMatrix * vec4( position, 1.0 );\n}",fragmentShader:"#ifdef GL_ES\nprecision highp float;\n#endif\nuniform \tfloat \tdarkness;\nvoid main() {\ngl_FragColor = vec4( 0, 0, 0, darkness );\n}"},
shadowVolumeDynamic:{uniforms:{directionalLightDirection:{type:"fv",value:[]}},vertexShader:"uniform \tvec3 \tdirectionalLightDirection;\nvoid main() {\nvec4 pos      = objectMatrix * vec4( position, 1.0 );\nvec3 norm     = mat3( objectMatrix[ 0 ].xyz, objectMatrix[ 1 ].xyz, objectMatrix[ 2 ].xyz ) * normal;\nvec4 extruded = vec4( directionalLightDirection * 5000.0 * step( 0.0, dot( directionalLightDirection, norm ) ), 0.0 );\ngl_Position   = projectionMatrix * viewMatrix * ( pos + extruded );\n}",
fragmentShader:"void main() {\ngl_FragColor = vec4( 1.0 );\n}"},depth:{uniforms:{mNear:{type:"f",value:1},mFar:{type:"f",value:2E3},opacity:{type:"f",value:1}},fragmentShader:"uniform float mNear;\nuniform float mFar;\nuniform float opacity;\nvoid main() {\nfloat depth = gl_FragCoord.z / gl_FragCoord.w;\nfloat color = 1.0 - smoothstep( mNear, mFar, depth );\ngl_FragColor = vec4( vec3( color ), opacity );\n}",vertexShader:"void main() {\ngl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}"},
normal:{uniforms:{opacity:{type:"f",value:1}},fragmentShader:"uniform float opacity;\nvarying vec3 vNormal;\nvoid main() {\ngl_FragColor = vec4( 0.5 * normalize( vNormal ) + 0.5, opacity );\n}",vertexShader:"varying vec3 vNormal;\nvoid main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\nvNormal = normalize( normalMatrix * normal );\ngl_Position = projectionMatrix * mvPosition;\n}"},basic:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,THREE.UniformsLib.shadowmap]),
fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.alphatest_fragment,THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,
THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:[THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,
THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n")},lambert:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,THREE.UniformsLib.lights,THREE.UniformsLib.shadowmap]),fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nvarying vec3 vLightWeighting;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,
THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,"void main() {\ngl_FragColor = vec4( diffuse, opacity );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.alphatest_fragment,"gl_FragColor = gl_FragColor * vec4( vLightWeighting, 1.0 );",THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.fog_fragment,
"}"].join("\n"),vertexShader:["varying vec3 vLightWeighting;",THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,
THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,"vec3 transformedNormal = normalize( normalMatrix * normal );",THREE.ShaderChunk.lights_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n")},phong:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,THREE.UniformsLib.lights,THREE.UniformsLib.shadowmap,{ambient:{type:"c",value:new THREE.Color(328965)},
specular:{type:"c",value:new THREE.Color(1118481)},shininess:{type:"f",value:30}}]),fragmentShader:["uniform vec3 diffuse;\nuniform float opacity;\nuniform vec3 ambient;\nuniform vec3 specular;\nuniform float shininess;\nvarying vec3 vLightWeighting;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_pars_fragment,THREE.ShaderChunk.lightmap_pars_fragment,THREE.ShaderChunk.envmap_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.lights_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,
"void main() {\ngl_FragColor = vec4( vLightWeighting, 1.0 );",THREE.ShaderChunk.map_fragment,THREE.ShaderChunk.alphatest_fragment,THREE.ShaderChunk.lights_fragment,THREE.ShaderChunk.lightmap_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.envmap_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["#define PHONG\nvarying vec3 vLightWeighting;\nvarying vec3 vViewPosition;\nvarying vec3 vNormal;",THREE.ShaderChunk.map_pars_vertex,THREE.ShaderChunk.lightmap_pars_vertex,
THREE.ShaderChunk.envmap_pars_vertex,THREE.ShaderChunk.lights_pars_vertex,THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.skinning_pars_vertex,THREE.ShaderChunk.morphtarget_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.map_vertex,THREE.ShaderChunk.lightmap_vertex,THREE.ShaderChunk.envmap_vertex,THREE.ShaderChunk.color_vertex,"#ifndef USE_ENVMAP\nvec4 mPosition = objectMatrix * vec4( position, 1.0 );\n#endif\nvViewPosition = cameraPosition - mPosition.xyz;\nvec3 transformedNormal = normalize( normalMatrix * normal );\nvNormal = transformedNormal;",
THREE.ShaderChunk.lights_vertex,THREE.ShaderChunk.skinning_vertex,THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n")},particle_basic:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.particle,THREE.UniformsLib.shadowmap]),fragmentShader:["uniform vec3 psColor;\nuniform float opacity;",THREE.ShaderChunk.color_pars_fragment,THREE.ShaderChunk.map_particle_pars_fragment,THREE.ShaderChunk.fog_pars_fragment,THREE.ShaderChunk.shadowmap_pars_fragment,
"void main() {\ngl_FragColor = vec4( psColor, opacity );",THREE.ShaderChunk.map_particle_fragment,THREE.ShaderChunk.alphatest_fragment,THREE.ShaderChunk.color_fragment,THREE.ShaderChunk.shadowmap_fragment,THREE.ShaderChunk.fog_fragment,"}"].join("\n"),vertexShader:["uniform float size;\nuniform float scale;",THREE.ShaderChunk.color_pars_vertex,THREE.ShaderChunk.shadowmap_pars_vertex,"void main() {",THREE.ShaderChunk.color_vertex,"vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\n#ifdef USE_SIZEATTENUATION\ngl_PointSize = size * ( scale / length( mvPosition.xyz ) );\n#else\ngl_PointSize = size;\n#endif\ngl_Position = projectionMatrix * mvPosition;",
THREE.ShaderChunk.shadowmap_vertex,"}"].join("\n")},depthRGBA:{uniforms:{},fragmentShader:"vec4 pack_depth( const in float depth ) {\nconst vec4 bit_shift = vec4( 256.0 * 256.0 * 256.0, 256.0 * 256.0, 256.0, 1.0 );\nconst vec4 bit_mask  = vec4( 0.0, 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0 );\nvec4 res = fract( depth * bit_shift );\nres -= res.xxyz * bit_mask;\nreturn res;\n}\nvoid main() {\ngl_FragData[ 0 ] = pack_depth( gl_FragCoord.z );\n}",vertexShader:[THREE.ShaderChunk.morphtarget_pars_vertex,
"void main() {\nvec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );",THREE.ShaderChunk.morphtarget_vertex,THREE.ShaderChunk.default_vertex,"}"].join("\n")}};
THREE.WebGLRenderer=function(b){function c(b,c,d){var e,h,g,j=b.vertices,A=j.length,k=b.colors,R=k.length,B=b.__vertexArray,F=b.__colorArray,m=b.__sortArray,q=b.__dirtyVertices,o=b.__dirtyColors,p=b.__webglCustomAttributes,r,u;if(p)for(r in p)p[r].offset=0;if(d.sortParticles){Z.multiplySelf(d.matrixWorld);for(e=0;e<A;e++)h=j[e].position,Ha.copy(h),Z.multiplyVector3(Ha),m[e]=[Ha.z,e];m.sort(function(b,c){return c[0]-b[0]});for(e=0;e<A;e++)h=j[m[e][1]].position,g=e*3,B[g]=h.x,B[g+1]=h.y,B[g+2]=h.z;
for(e=0;e<R;e++)g=e*3,color=k[m[e][1]],F[g]=color.r,F[g+1]=color.g,F[g+2]=color.b;if(p)for(r in p){e=p[r];k=e.value.length;for(g=0;g<k;g++){index=m[g][1];R=e.offset;if(e.size===1){if(e.boundTo===void 0||e.boundTo==="vertices")e.array[R]=e.value[index]}else{if(e.boundTo===void 0||e.boundTo==="vertices")u=e.value[index];e.size===2?(e.array[R]=u.x,e.array[R+1]=u.y):e.size===3?e.type==="c"?(e.array[R]=u.r,e.array[R+1]=u.g,e.array[R+2]=u.b):(e.array[R]=u.x,e.array[R+1]=u.y,e.array[R+2]=u.z):(e.array[R]=
u.x,e.array[R+1]=u.y,e.array[R+2]=u.z,e.array[R+3]=u.w)}e.offset+=e.size}}}else{if(q)for(e=0;e<A;e++)h=j[e].position,g=e*3,B[g]=h.x,B[g+1]=h.y,B[g+2]=h.z;if(o)for(e=0;e<R;e++)color=k[e],g=e*3,F[g]=color.r,F[g+1]=color.g,F[g+2]=color.b;if(p)for(r in p)if(e=p[r],e.__original.needsUpdate){k=e.value.length;for(g=0;g<k;g++){R=e.offset;if(e.size===1){if(e.boundTo===void 0||e.boundTo==="vertices")e.array[R]=e.value[g]}else{if(e.boundTo===void 0||e.boundTo==="vertices")u=e.value[g];e.size===2?(e.array[R]=
u.x,e.array[R+1]=u.y):e.size===3?e.type==="c"?(e.array[R]=u.r,e.array[R+1]=u.g,e.array[R+2]=u.b):(e.array[R]=u.x,e.array[R+1]=u.y,e.array[R+2]=u.z):(e.array[R]=u.x,e.array[R+1]=u.y,e.array[R+2]=u.z,e.array[R+3]=u.w)}e.offset+=e.size}}}if(q||d.sortParticles)f.bindBuffer(f.ARRAY_BUFFER,b.__webglVertexBuffer),f.bufferData(f.ARRAY_BUFFER,B,c);if(o||d.sortParticles)f.bindBuffer(f.ARRAY_BUFFER,b.__webglColorBuffer),f.bufferData(f.ARRAY_BUFFER,F,c);if(p)for(r in p)if(e=p[r],e.__original.needsUpdate||d.sortParticles)f.bindBuffer(f.ARRAY_BUFFER,
e.buffer),f.bufferData(f.ARRAY_BUFFER,e.array,c)}function d(b,c,d,e,h){e.program||L.initMaterial(e,c,d,h);if(e.morphTargets&&!h.__webglMorphTargetInfluences){h.__webglMorphTargetInfluences=new Float32Array(L.maxMorphTargets);for(var g=0,j=L.maxMorphTargets;g<j;g++)h.__webglMorphTargetInfluences[g]=0}var g=e.program,j=g.uniforms,A=e.uniforms;g!=Aa&&(f.useProgram(g),Aa=g);f.uniformMatrix4fv(j.projectionMatrix,!1,Fa);if(d&&(e instanceof THREE.MeshBasicMaterial||e instanceof THREE.MeshLambertMaterial||
e instanceof THREE.MeshPhongMaterial||e instanceof THREE.LineBasicMaterial||e instanceof THREE.ParticleBasicMaterial||e.fog))if(A.fogColor.value=d.color,d instanceof THREE.Fog)A.fogNear.value=d.near,A.fogFar.value=d.far;else if(d instanceof THREE.FogExp2)A.fogDensity.value=d.density;if(e instanceof THREE.MeshPhongMaterial||e instanceof THREE.MeshLambertMaterial||e.lights){var k,m,B,F=0,q=0,o=0,p,u,r,t=Ta,v=t.directional.colors,H=t.directional.positions,C=t.point.colors,z=t.point.positions,x=t.point.distances,
J=0,E=0,d=m=r=0;for(k=c.length;d<k;d++)if(m=c[d],B=m.color,p=m.position,u=m.intensity,r=m.distance,m instanceof THREE.AmbientLight)F+=B.r,q+=B.g,o+=B.b;else if(m instanceof THREE.DirectionalLight)r=J*3,v[r]=B.r*u,v[r+1]=B.g*u,v[r+2]=B.b*u,H[r]=p.x,H[r+1]=p.y,H[r+2]=p.z,J+=1;else if(m instanceof THREE.SpotLight)r=J*3,v[r]=B.r*u,v[r+1]=B.g*u,v[r+2]=B.b*u,B=1/p.length(),H[r]=p.x*B,H[r+1]=p.y*B,H[r+2]=p.z*B,J+=1;else if(m instanceof THREE.PointLight)m=E*3,C[m]=B.r*u,C[m+1]=B.g*u,C[m+2]=B.b*u,z[m]=p.x,
z[m+1]=p.y,z[m+2]=p.z,x[E]=r,E+=1;for(d=J*3;d<v.length;d++)v[d]=0;for(d=E*3;d<C.length;d++)C[d]=0;t.point.length=E;t.directional.length=J;t.ambient[0]=F;t.ambient[1]=q;t.ambient[2]=o;c=Ta;A.enableLighting.value=c.directional.length+c.point.length;A.ambientLightColor.value=c.ambient;A.directionalLightColor.value=c.directional.colors;A.directionalLightDirection.value=c.directional.positions;A.pointLightColor.value=c.point.colors;A.pointLightPosition.value=c.point.positions;A.pointLightDistance.value=
c.point.distances}if(e instanceof THREE.MeshBasicMaterial||e instanceof THREE.MeshLambertMaterial||e instanceof THREE.MeshPhongMaterial)A.diffuse.value=e.color,A.opacity.value=e.opacity,(A.map.texture=e.map)&&A.offsetRepeat.value.set(e.map.offset.x,e.map.offset.y,e.map.repeat.x,e.map.repeat.y),A.lightMap.texture=e.lightMap,A.envMap.texture=e.envMap,A.reflectivity.value=e.reflectivity,A.refractionRatio.value=e.refractionRatio,A.combine.value=e.combine,A.useRefract.value=e.envMap&&e.envMap.mapping instanceof
THREE.CubeRefractionMapping;if(e instanceof THREE.LineBasicMaterial)A.diffuse.value=e.color,A.opacity.value=e.opacity;else if(e instanceof THREE.ParticleBasicMaterial)A.psColor.value=e.color,A.opacity.value=e.opacity,A.size.value=e.size,A.scale.value=Ia.height/2,A.map.texture=e.map;else if(e instanceof THREE.MeshPhongMaterial)A.ambient.value=e.ambient,A.specular.value=e.specular,A.shininess.value=e.shininess;else if(e instanceof THREE.MeshDepthMaterial)A.mNear.value=b.near,A.mFar.value=b.far,A.opacity.value=
e.opacity;else if(e instanceof THREE.MeshNormalMaterial)A.opacity.value=e.opacity;if(h.receiveShadow&&!e._shadowPass&&A.shadowMatrix){for(c=0;c<Qa.length;c++)A.shadowMatrix.value[c]=Qa[c],A.shadowMap.texture[c]=L.shadowMap[c];A.shadowDarkness.value=L.shadowMapDarkness;A.shadowBias.value=L.shadowMapBias}for(var M in A)if(k=g.uniforms[M])if(d=A[M],F=d.type,c=d.value,F=="i")f.uniform1i(k,c);else if(F=="f")f.uniform1f(k,c);else if(F=="fv1")f.uniform1fv(k,c);else if(F=="fv")f.uniform3fv(k,c);else if(F==
"v2")f.uniform2f(k,c.x,c.y);else if(F=="v3")f.uniform3f(k,c.x,c.y,c.z);else if(F=="v4")f.uniform4f(k,c.x,c.y,c.z,c.w);else if(F=="m4"){if(!d._array)d._array=new Float32Array(16);c.flattenToArray(d._array);f.uniformMatrix4fv(k,!1,d._array)}else if(F=="m4v"){if(!d._array)d._array=new Float32Array(16*c.length);F=0;for(q=c.length;F<q;F++)c[F].flattenToArrayOffset(d._array,F*16);f.uniformMatrix4fv(k,!1,d._array)}else if(F=="c")f.uniform3f(k,c.r,c.g,c.b);else if(F=="t"){if(f.uniform1i(k,c),k=d.texture)if(k.image instanceof
Array&&k.image.length==6){if(d=k,d.image.length==6){if(d.needsUpdate){if(d.__webglInit){f.bindTexture(f.TEXTURE_CUBE_MAP,d.image.__webglTextureCube);for(k=0;k<6;++k)f.texSubImage2D(f.TEXTURE_CUBE_MAP_POSITIVE_X+k,0,0,0,f.RGBA,f.UNSIGNED_BYTE,d.image[k])}else{d.image.__webglTextureCube=f.createTexture();f.bindTexture(f.TEXTURE_CUBE_MAP,d.image.__webglTextureCube);for(k=0;k<6;++k)f.texImage2D(f.TEXTURE_CUBE_MAP_POSITIVE_X+k,0,f.RGBA,f.RGBA,f.UNSIGNED_BYTE,d.image[k]);d.__webglInit=!0}Q(f.TEXTURE_CUBE_MAP,
d,d.image[0]);f.bindTexture(f.TEXTURE_CUBE_MAP,null);d.needsUpdate=!1}f.activeTexture(f.TEXTURE0+c);f.bindTexture(f.TEXTURE_CUBE_MAP,d.image.__webglTextureCube)}}else O(k,c)}else if(F=="tv"){if(!d._array){d._array=[];F=0;for(q=d.texture.length;F<q;F++)d._array[F]=c+F}f.uniform1iv(k,d._array);F=0;for(q=d.texture.length;F<q;F++)(k=d.texture[F])&&O(k,d._array[F])}f.uniformMatrix4fv(j.modelViewMatrix,!1,h._modelViewMatrixArray);f.uniformMatrix3fv(j.normalMatrix,!1,h._normalMatrixArray);(e instanceof THREE.MeshShaderMaterial||
e instanceof THREE.MeshPhongMaterial||e.envMap)&&j.cameraPosition!==null&&f.uniform3f(j.cameraPosition,b.position.x,b.position.y,b.position.z);(e instanceof THREE.MeshShaderMaterial||e.envMap||e.skinning||h.receiveShadow)&&j.objectMatrix!==null&&f.uniformMatrix4fv(j.objectMatrix,!1,h._objectMatrixArray);(e instanceof THREE.MeshPhongMaterial||e instanceof THREE.MeshLambertMaterial||e instanceof THREE.MeshShaderMaterial||e.skinning)&&j.viewMatrix!==null&&f.uniformMatrix4fv(j.viewMatrix,!1,Da);e.skinning&&
(f.uniformMatrix4fv(j.cameraInverseMatrix,!1,Da),f.uniformMatrix4fv(j.boneGlobalMatrices,!1,h.boneMatrices));return g}function e(b,c,e,h,g,j){if(h.opacity!=0){var k,b=d(b,c,e,h,j).attributes;if(!h.morphTargets&&b.position>=0)f.bindBuffer(f.ARRAY_BUFFER,g.__webglVertexBuffer),f.vertexAttribPointer(b.position,3,f.FLOAT,!1,0,0);else if(j.morphTargetBase){c=h.program.attributes;j.morphTargetBase!==-1?(f.bindBuffer(f.ARRAY_BUFFER,g.__webglMorphTargetsBuffers[j.morphTargetBase]),f.vertexAttribPointer(c.position,
3,f.FLOAT,!1,0,0)):c.position>=0&&(f.bindBuffer(f.ARRAY_BUFFER,g.__webglVertexBuffer),f.vertexAttribPointer(c.position,3,f.FLOAT,!1,0,0));if(j.morphTargetForcedOrder.length)for(var e=0,A=j.morphTargetForcedOrder,m=j.morphTargetInfluences;e<h.numSupportedMorphTargets&&e<A.length;)f.bindBuffer(f.ARRAY_BUFFER,g.__webglMorphTargetsBuffers[A[e]]),f.vertexAttribPointer(c["morphTarget"+e],3,f.FLOAT,!1,0,0),j.__webglMorphTargetInfluences[e]=m[A[e]],e++;else{var A=[],q=-1,B=0,m=j.morphTargetInfluences,F,p=
m.length,e=0;for(j.morphTargetBase!==-1&&(A[j.morphTargetBase]=!0);e<h.numSupportedMorphTargets;){for(F=0;F<p;F++)!A[F]&&m[F]>q&&(B=F,q=m[B]);f.bindBuffer(f.ARRAY_BUFFER,g.__webglMorphTargetsBuffers[B]);f.vertexAttribPointer(c["morphTarget"+e],3,f.FLOAT,!1,0,0);j.__webglMorphTargetInfluences[e]=q;A[B]=1;q=-1;e++}}h.program.uniforms.morphTargetInfluences!==null&&f.uniform1fv(h.program.uniforms.morphTargetInfluences,j.__webglMorphTargetInfluences)}if(g.__webglCustomAttributes)for(k in g.__webglCustomAttributes)b[k]>=
0&&(c=g.__webglCustomAttributes[k],f.bindBuffer(f.ARRAY_BUFFER,c.buffer),f.vertexAttribPointer(b[k],c.size,f.FLOAT,!1,0,0));b.color>=0&&(f.bindBuffer(f.ARRAY_BUFFER,g.__webglColorBuffer),f.vertexAttribPointer(b.color,3,f.FLOAT,!1,0,0));b.normal>=0&&(f.bindBuffer(f.ARRAY_BUFFER,g.__webglNormalBuffer),f.vertexAttribPointer(b.normal,3,f.FLOAT,!1,0,0));b.tangent>=0&&(f.bindBuffer(f.ARRAY_BUFFER,g.__webglTangentBuffer),f.vertexAttribPointer(b.tangent,4,f.FLOAT,!1,0,0));b.uv>=0&&(g.__webglUVBuffer?(f.bindBuffer(f.ARRAY_BUFFER,
g.__webglUVBuffer),f.vertexAttribPointer(b.uv,2,f.FLOAT,!1,0,0),f.enableVertexAttribArray(b.uv)):f.disableVertexAttribArray(b.uv));b.uv2>=0&&(g.__webglUV2Buffer?(f.bindBuffer(f.ARRAY_BUFFER,g.__webglUV2Buffer),f.vertexAttribPointer(b.uv2,2,f.FLOAT,!1,0,0),f.enableVertexAttribArray(b.uv2)):f.disableVertexAttribArray(b.uv2));h.skinning&&b.skinVertexA>=0&&b.skinVertexB>=0&&b.skinIndex>=0&&b.skinWeight>=0&&(f.bindBuffer(f.ARRAY_BUFFER,g.__webglSkinVertexABuffer),f.vertexAttribPointer(b.skinVertexA,4,
f.FLOAT,!1,0,0),f.bindBuffer(f.ARRAY_BUFFER,g.__webglSkinVertexBBuffer),f.vertexAttribPointer(b.skinVertexB,4,f.FLOAT,!1,0,0),f.bindBuffer(f.ARRAY_BUFFER,g.__webglSkinIndicesBuffer),f.vertexAttribPointer(b.skinIndex,4,f.FLOAT,!1,0,0),f.bindBuffer(f.ARRAY_BUFFER,g.__webglSkinWeightsBuffer),f.vertexAttribPointer(b.skinWeight,4,f.FLOAT,!1,0,0));j instanceof THREE.Mesh?(h.wireframe?(f.lineWidth(h.wireframeLinewidth),f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,g.__webglLineBuffer),f.drawElements(f.LINES,g.__webglLineCount,
f.UNSIGNED_SHORT,0)):(f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,g.__webglFaceBuffer),f.drawElements(f.TRIANGLES,g.__webglFaceCount,f.UNSIGNED_SHORT,0)),L.data.vertices+=g.__webglFaceCount,L.data.faces+=g.__webglFaceCount/3,L.data.drawCalls++):j instanceof THREE.Line?(j=j.type==THREE.LineStrip?f.LINE_STRIP:f.LINES,f.lineWidth(h.linewidth),f.drawArrays(j,0,g.__webglLineCount),L.data.drawCalls++):j instanceof THREE.ParticleSystem?(f.drawArrays(f.POINTS,0,g.__webglParticleCount),L.data.drawCalls++):j instanceof
THREE.Ribbon&&(f.drawArrays(f.TRIANGLE_STRIP,0,g.__webglVertexCount),L.data.drawCalls++)}}function h(b,c,d){if(!b.__webglVertexBuffer)b.__webglVertexBuffer=f.createBuffer();if(!b.__webglNormalBuffer)b.__webglNormalBuffer=f.createBuffer();b.hasPos&&(f.bindBuffer(f.ARRAY_BUFFER,b.__webglVertexBuffer),f.bufferData(f.ARRAY_BUFFER,b.positionArray,f.DYNAMIC_DRAW),f.enableVertexAttribArray(c.attributes.position),f.vertexAttribPointer(c.attributes.position,3,f.FLOAT,!1,0,0));if(b.hasNormal){f.bindBuffer(f.ARRAY_BUFFER,
b.__webglNormalBuffer);if(d==THREE.FlatShading){var e,g,h,j,k,m,q,B,F,p,r=b.count*3;for(p=0;p<r;p+=9)d=b.normalArray,e=d[p],g=d[p+1],h=d[p+2],j=d[p+3],m=d[p+4],B=d[p+5],k=d[p+6],q=d[p+7],F=d[p+8],e=(e+j+k)/3,g=(g+m+q)/3,h=(h+B+F)/3,d[p]=e,d[p+1]=g,d[p+2]=h,d[p+3]=e,d[p+4]=g,d[p+5]=h,d[p+6]=e,d[p+7]=g,d[p+8]=h}f.bufferData(f.ARRAY_BUFFER,b.normalArray,f.DYNAMIC_DRAW);f.enableVertexAttribArray(c.attributes.normal);f.vertexAttribPointer(c.attributes.normal,3,f.FLOAT,!1,0,0)}f.drawArrays(f.TRIANGLES,
0,b.count);b.count=0}function j(b){if(Y!=b.doubleSided)b.doubleSided?f.disable(f.CULL_FACE):f.enable(f.CULL_FACE),Y=b.doubleSided;if(pa!=b.flipSided)b.flipSided?f.frontFace(f.CW):f.frontFace(f.CCW),pa=b.flipSided}function g(b){W!=b&&(b?f.enable(f.DEPTH_TEST):f.disable(f.DEPTH_TEST),W=b)}function k(b,c,d){P!=b&&(b?f.enable(f.POLYGON_OFFSET_FILL):f.disable(f.POLYGON_OFFSET_FILL),P=b);if(b&&(S!=c||fa!=d))f.polygonOffset(c,d),S=c,fa=d}function q(b){ha[0].set(b.n41-b.n11,b.n42-b.n12,b.n43-b.n13,b.n44-
b.n14);ha[1].set(b.n41+b.n11,b.n42+b.n12,b.n43+b.n13,b.n44+b.n14);ha[2].set(b.n41+b.n21,b.n42+b.n22,b.n43+b.n23,b.n44+b.n24);ha[3].set(b.n41-b.n21,b.n42-b.n22,b.n43-b.n23,b.n44-b.n24);ha[4].set(b.n41-b.n31,b.n42-b.n32,b.n43-b.n33,b.n44-b.n34);ha[5].set(b.n41+b.n31,b.n42+b.n32,b.n43+b.n33,b.n44+b.n34);for(var c,b=0;b<6;b++)c=ha[b],c.divideScalar(Math.sqrt(c.x*c.x+c.y*c.y+c.z*c.z))}function m(b){for(var c=b.matrixWorld,f=-b.geometry.boundingSphere.radius*Math.max(b.scale.x,Math.max(b.scale.y,b.scale.z)),
d=0;d<6;d++)if(b=ha[d].x*c.n14+ha[d].y*c.n24+ha[d].z*c.n34+ha[d].w,b<=f)return!1;return!0}function o(b,c){b.list[b.count]=c;b.count+=1}function p(b){var c,d,f=b.object,e=b.opaque,g=b.transparent;g.count=0;b=e.count=0;for(c=f.materials.length;b<c;b++)d=f.materials[b],d.transparent?o(g,d):o(e,d)}function r(b){var c,d,f,e,g=b.object,h=b.buffer,j=b.opaque,k=b.transparent;k.count=0;b=j.count=0;for(f=g.materials.length;b<f;b++)if(c=g.materials[b],c instanceof THREE.MeshFaceMaterial){c=0;for(d=h.materials.length;c<
d;c++)(e=h.materials[c])&&(e.transparent?o(k,e):o(j,e))}else(e=c)&&(e.transparent?o(k,e):o(j,e))}function v(b,c){return c.z-b.z}function C(b,c){var k,Sa,G,p=0,ga,A,r,o,B=b.lights;ma||(ma=new THREE.Camera(L.shadowCameraFov,c.aspect,L.shadowCameraNear,L.shadowCameraFar));k=0;for(Sa=B.length;k<Sa;k++)if(G=B[k],G instanceof THREE.SpotLight&&G.castShadow){L.shadowMap[p]||(L.shadowMap[p]=new THREE.WebGLRenderTarget(L.shadowMapWidth,L.shadowMapHeight,{minFilter:THREE.LinearFilter,magFilter:THREE.LinearFilter,
format:THREE.RGBAFormat}));Qa[p]||(Qa[p]=new THREE.Matrix4);ga=L.shadowMap[p];A=Qa[p];ma.position.copy(G.position);ma.target.position.copy(G.target.position);ma.update(void 0,!0);b.update(void 0,!1,ma);A.set(0.5,0,0,0.5,0,0.5,0,0.5,0,0,0.5,0.5,0,0,0,1);A.multiplySelf(ma.projectionMatrix);A.multiplySelf(ma.matrixWorldInverse);ma.matrixWorldInverse.flattenToArray(Da);ma.projectionMatrix.flattenToArray(Fa);Z.multiply(ma.projectionMatrix,ma.matrixWorldInverse);q(Z);L.initWebGLObjects(b);T(ga);f.clearColor(1,
1,1,1);L.clear();f.clearColor(xa.r,xa.g,xa.b,Ja);A=b.__webglObjects.length;G=b.__webglObjectsImmediate.length;for(ga=0;ga<A;ga++)r=b.__webglObjects[ga],o=r.object,o.visible&&o.castShadow?!(o instanceof THREE.Mesh)||m(o)?(o.matrixWorld.flattenToArray(o._objectMatrixArray),E(o,ma,!1),r.render=!0):r.render=!1:r.render=!1;g(!0);u(THREE.NormalBlending);for(ga=0;ga<A;ga++)if(r=b.__webglObjects[ga],r.render)o=r.object,buffer=r.buffer,j(o),r=o.customDepthMaterial?o.customDepthMaterial:o.geometry.morphTargets.length?
Ua:Ra,e(ma,B,null,r,buffer,o);for(ga=0;ga<G;ga++)r=b.__webglObjectsImmediate[ga],o=r.object,o.visible&&o.castShadow&&(o.matrixAutoUpdate&&o.matrixWorld.flattenToArray(o._objectMatrixArray),E(o,ma,!1),j(o),program=d(ma,B,null,Ra,o),o.render(function(b){h(b,program,Ra.shading)}));p++}}function x(b,c){var d,e,g;d=t.attributes;var h=t.uniforms,j=wa/Ea,k,m=[],p=Ea*0.5,q=wa*0.5,F=!0;f.useProgram(t.program);Aa=t.program;W=D=-1;Va||(f.enableVertexAttribArray(t.attributes.position),f.enableVertexAttribArray(t.attributes.uv),
Va=!0);f.disable(f.CULL_FACE);f.enable(f.BLEND);f.depthMask(!0);f.bindBuffer(f.ARRAY_BUFFER,t.vertexBuffer);f.vertexAttribPointer(d.position,2,f.FLOAT,!1,16,0);f.vertexAttribPointer(d.uv,2,f.FLOAT,!1,16,8);f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,t.elementBuffer);f.uniformMatrix4fv(h.projectionMatrix,!1,Fa);f.activeTexture(f.TEXTURE0);f.uniform1i(h.map,0);d=0;for(e=b.__webglSprites.length;d<e;d++)g=b.__webglSprites[d],g.useScreenCoordinates?g.z=-g.position.z:(g._modelViewMatrix.multiplyToArray(c.matrixWorldInverse,
g.matrixWorld,g._modelViewMatrixArray),g.z=-g._modelViewMatrix.n34);b.__webglSprites.sort(v);d=0;for(e=b.__webglSprites.length;d<e;d++)g=b.__webglSprites[d],g.material===void 0&&g.map&&g.map.image&&g.map.image.width&&(g.useScreenCoordinates?(f.uniform1i(h.useScreenCoordinates,1),f.uniform3f(h.screenPosition,(g.position.x-p)/p,(q-g.position.y)/q,Math.max(0,Math.min(1,g.position.z)))):(f.uniform1i(h.useScreenCoordinates,0),f.uniform1i(h.affectedByDistance,g.affectedByDistance?1:0),f.uniformMatrix4fv(h.modelViewMatrix,
!1,g._modelViewMatrixArray)),k=g.map.image.width/(g.scaleByViewport?wa:1),m[0]=k*j*g.scale.x,m[1]=k*g.scale.y,f.uniform2f(h.uvScale,g.uvScale.x,g.uvScale.y),f.uniform2f(h.uvOffset,g.uvOffset.x,g.uvOffset.y),f.uniform2f(h.alignment,g.alignment.x,g.alignment.y),f.uniform1f(h.opacity,g.opacity),f.uniform1f(h.rotation,g.rotation),f.uniform2fv(h.scale,m),g.mergeWith3D&&!F?(f.enable(f.DEPTH_TEST),F=!0):!g.mergeWith3D&&F&&(f.disable(f.DEPTH_TEST),F=!1),u(g.blending),O(g.map,0),f.drawElements(f.TRIANGLES,
6,f.UNSIGNED_SHORT,0));f.enable(f.CULL_FACE);f.enable(f.DEPTH_TEST);f.depthMask(va)}function E(b,c,d){b._modelViewMatrix.multiplyToArray(c.matrixWorldInverse,b.matrixWorld,b._modelViewMatrixArray);d&&THREE.Matrix4.makeInvert3x3(b._modelViewMatrix).transposeIntoArray(b._normalMatrixArray)}function J(b){var c,d,f,e;e=b.__materials;b=0;for(d=e.length;b<d;b++)if(f=e[b],f.attributes)for(c in f.attributes)if(f.attributes[c].needsUpdate)return!0;return!1}function ya(b){var c,d,f,e;e=b.__materials;b=0;for(d=
e.length;b<d;b++)if(f=e[b],f.attributes)for(c in f.attributes)f.attributes[c].needsUpdate=!1}function za(b,c){var d;for(d=b.length-1;d>=0;d--)b[d].object==c&&b.splice(d,1)}function sa(b){function c(b){var e=[];d=0;for(f=b.length;d<f;d++)b[d]==void 0?e.push("undefined"):e.push(b[d].id);return e.join("_")}var d,f,e,g,h,j,k,m,p={},q=b.morphTargets!==void 0?b.morphTargets.length:0;b.geometryGroups={};e=0;for(g=b.faces.length;e<g;e++)h=b.faces[e],j=h.materials,k=c(j),p[k]==void 0&&(p[k]={hash:k,counter:0}),
m=p[k].hash+"_"+p[k].counter,b.geometryGroups[m]==void 0&&(b.geometryGroups[m]={faces:[],materials:j,vertices:0,numMorphTargets:q}),h=h instanceof THREE.Face3?3:4,b.geometryGroups[m].vertices+h>65535&&(p[k].counter+=1,m=p[k].hash+"_"+p[k].counter,b.geometryGroups[m]==void 0&&(b.geometryGroups[m]={faces:[],materials:j,vertices:0,numMorphTargets:q})),b.geometryGroups[m].faces.push(e),b.geometryGroups[m].vertices+=h}function V(b,c,d){b.push({buffer:c,object:d,opaque:{list:[],count:0},transparent:{list:[],
count:0}})}function u(b){if(b!=D){switch(b){case THREE.AdditiveBlending:f.blendEquation(f.FUNC_ADD);f.blendFunc(f.SRC_ALPHA,f.ONE);break;case THREE.SubtractiveBlending:f.blendEquation(f.FUNC_ADD);f.blendFunc(f.ZERO,f.ONE_MINUS_SRC_COLOR);break;case THREE.MultiplyBlending:f.blendEquation(f.FUNC_ADD);f.blendFunc(f.ZERO,f.SRC_COLOR);break;default:f.blendEquationSeparate(f.FUNC_ADD,f.FUNC_ADD),f.blendFuncSeparate(f.SRC_ALPHA,f.ONE_MINUS_SRC_ALPHA,f.ONE,f.ONE_MINUS_SRC_ALPHA)}D=b}}function Q(b,c,d){(d.width&
d.width-1)==0&&(d.height&d.height-1)==0?(f.texParameteri(b,f.TEXTURE_WRAP_S,N(c.wrapS)),f.texParameteri(b,f.TEXTURE_WRAP_T,N(c.wrapT)),f.texParameteri(b,f.TEXTURE_MAG_FILTER,N(c.magFilter)),f.texParameteri(b,f.TEXTURE_MIN_FILTER,N(c.minFilter)),f.generateMipmap(b)):(f.texParameteri(b,f.TEXTURE_WRAP_S,f.CLAMP_TO_EDGE),f.texParameteri(b,f.TEXTURE_WRAP_T,f.CLAMP_TO_EDGE),f.texParameteri(b,f.TEXTURE_MAG_FILTER,qa(c.magFilter)),f.texParameteri(b,f.TEXTURE_MIN_FILTER,qa(c.minFilter)))}function O(b,c){if(b.needsUpdate){if(!b.__webglInit)b.__webglTexture=
f.createTexture(),b.__webglInit=!0;f.bindTexture(f.TEXTURE_2D,b.__webglTexture);b.image.data?f.texImage2D(f.TEXTURE_2D,0,N(b.format),b.image.width,b.image.height,0,N(b.format),f.UNSIGNED_BYTE,b.image.data):f.texImage2D(f.TEXTURE_2D,0,f.RGBA,f.RGBA,f.UNSIGNED_BYTE,b.image);Q(f.TEXTURE_2D,b,b.image);f.bindTexture(f.TEXTURE_2D,null);b.needsUpdate=!1}f.activeTexture(f.TEXTURE0+c);f.bindTexture(f.TEXTURE_2D,b.__webglTexture)}function T(b){if(b&&!b.__webglFramebuffer){if(b.depthBuffer===void 0)b.depthBuffer=
!0;if(b.stencilBuffer===void 0)b.stencilBuffer=!0;b.__webglFramebuffer=f.createFramebuffer();b.__webglRenderbuffer=f.createRenderbuffer();b.__webglTexture=f.createTexture();f.bindTexture(f.TEXTURE_2D,b.__webglTexture);f.texParameteri(f.TEXTURE_2D,f.TEXTURE_WRAP_S,N(b.wrapS));f.texParameteri(f.TEXTURE_2D,f.TEXTURE_WRAP_T,N(b.wrapT));f.texParameteri(f.TEXTURE_2D,f.TEXTURE_MAG_FILTER,N(b.magFilter));f.texParameteri(f.TEXTURE_2D,f.TEXTURE_MIN_FILTER,N(b.minFilter));f.texImage2D(f.TEXTURE_2D,0,N(b.format),
b.width,b.height,0,N(b.format),N(b.type),null);f.bindRenderbuffer(f.RENDERBUFFER,b.__webglRenderbuffer);f.bindFramebuffer(f.FRAMEBUFFER,b.__webglFramebuffer);f.framebufferTexture2D(f.FRAMEBUFFER,f.COLOR_ATTACHMENT0,f.TEXTURE_2D,b.__webglTexture,0);b.depthBuffer&&!b.stencilBuffer?(f.renderbufferStorage(f.RENDERBUFFER,f.DEPTH_COMPONENT16,b.width,b.height),f.framebufferRenderbuffer(f.FRAMEBUFFER,f.DEPTH_ATTACHMENT,f.RENDERBUFFER,b.__webglRenderbuffer)):b.depthBuffer&&b.stencilBuffer?(f.renderbufferStorage(f.RENDERBUFFER,
f.DEPTH_STENCIL,b.width,b.height),f.framebufferRenderbuffer(f.FRAMEBUFFER,f.DEPTH_STENCIL_ATTACHMENT,f.RENDERBUFFER,b.__webglRenderbuffer)):f.renderbufferStorage(f.RENDERBUFFER,f.RGBA4,b.width,b.height);f.bindTexture(f.TEXTURE_2D,null);f.bindRenderbuffer(f.RENDERBUFFER,null);f.bindFramebuffer(f.FRAMEBUFFER,null)}var c,d;b?(c=b.__webglFramebuffer,d=b.width,b=b.height):(c=null,d=Ea,b=wa);c!=ta&&(f.bindFramebuffer(f.FRAMEBUFFER,c),f.viewport(K,Ba,d,b),ta=c)}function U(b,c){var d;b=="fragment"?d=f.createShader(f.FRAGMENT_SHADER):
b=="vertex"&&(d=f.createShader(f.VERTEX_SHADER));f.shaderSource(d,c);f.compileShader(d);if(!f.getShaderParameter(d,f.COMPILE_STATUS))return console.error(f.getShaderInfoLog(d)),console.error(c),null;return d}function qa(b){switch(b){case THREE.NearestFilter:case THREE.NearestMipMapNearestFilter:case THREE.NearestMipMapLinearFilter:return f.NEAREST;default:return f.LINEAR}}function N(b){switch(b){case THREE.RepeatWrapping:return f.REPEAT;case THREE.ClampToEdgeWrapping:return f.CLAMP_TO_EDGE;case THREE.MirroredRepeatWrapping:return f.MIRRORED_REPEAT;
case THREE.NearestFilter:return f.NEAREST;case THREE.NearestMipMapNearestFilter:return f.NEAREST_MIPMAP_NEAREST;case THREE.NearestMipMapLinearFilter:return f.NEAREST_MIPMAP_LINEAR;case THREE.LinearFilter:return f.LINEAR;case THREE.LinearMipMapNearestFilter:return f.LINEAR_MIPMAP_NEAREST;case THREE.LinearMipMapLinearFilter:return f.LINEAR_MIPMAP_LINEAR;case THREE.ByteType:return f.BYTE;case THREE.UnsignedByteType:return f.UNSIGNED_BYTE;case THREE.ShortType:return f.SHORT;case THREE.UnsignedShortType:return f.UNSIGNED_SHORT;
case THREE.IntType:return f.INT;case THREE.UnsignedShortType:return f.UNSIGNED_INT;case THREE.FloatType:return f.FLOAT;case THREE.AlphaFormat:return f.ALPHA;case THREE.RGBFormat:return f.RGB;case THREE.RGBAFormat:return f.RGBA;case THREE.LuminanceFormat:return f.LUMINANCE;case THREE.LuminanceAlphaFormat:return f.LUMINANCE_ALPHA}return 0}var L=this,f,ua=[],Aa=null,ta=null,va=!0,Y=null,pa=null,D=null,W=null,P=null,S=null,fa=null,K=0,Ba=0,Ea=0,wa=0,ha=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,
new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],Z=new THREE.Matrix4,Fa=new Float32Array(16),Da=new Float32Array(16),Ha=new THREE.Vector4,Ta={ambient:[0,0,0],directional:{length:0,colors:[],positions:[]},point:{length:0,colors:[],positions:[],distances:[]}},b=b||{},Ia=b.canvas!==void 0?b.canvas:document.createElement("canvas"),Ya=b.stencil!==void 0?b.stencil:!0,Za=b.preserveDrawingBuffer!==void 0?b.preserveDrawingBuffer:!1,$a=b.antialias!==void 0?b.antialias:!1,xa=b.clearColor!==void 0?new THREE.Color(b.clearColor):
new THREE.Color(0),Ja=b.clearAlpha!==void 0?b.clearAlpha:0;this.data={vertices:0,faces:0,drawCalls:0};this.maxMorphTargets=8;this.domElement=Ia;this.sortObjects=this.autoClear=!0;this.shadowMapBias=0.0039;this.shadowMapDarkness=0.5;this.shadowMapHeight=this.shadowMapWidth=512;this.shadowCameraNear=1;this.shadowCameraFar=5E3;this.shadowCameraFov=50;this.shadowMap=[];this.shadowMapEnabled=!1;this.shadowMapSoft=!0;var ma,Qa=[],b=THREE.ShaderLib.depthRGBA,Wa=THREE.UniformsUtils.clone(b.uniforms),Ra=new THREE.MeshShaderMaterial({fragmentShader:b.fragmentShader,
vertexShader:b.vertexShader,uniforms:Wa}),Ua=new THREE.MeshShaderMaterial({fragmentShader:b.fragmentShader,vertexShader:b.vertexShader,uniforms:Wa,morphTargets:!0});Ra._shadowPass=!0;Ua._shadowPass=!0;try{if(!(f=Ia.getContext("experimental-webgl",{antialias:$a,stencil:Ya,preserveDrawingBuffer:Za})))throw"Error creating WebGL context.";console.log(navigator.userAgent+" | "+f.getParameter(f.VERSION)+" | "+f.getParameter(f.VENDOR)+" | "+f.getParameter(f.RENDERER)+" | "+f.getParameter(f.SHADING_LANGUAGE_VERSION))}catch(ab){console.error(ab)}f.clearColor(0,
0,0,1);f.clearDepth(1);f.enable(f.DEPTH_TEST);f.depthFunc(f.LEQUAL);f.frontFace(f.CCW);f.cullFace(f.BACK);f.enable(f.CULL_FACE);f.enable(f.BLEND);f.blendEquation(f.FUNC_ADD);f.blendFunc(f.SRC_ALPHA,f.ONE_MINUS_SRC_ALPHA);f.clearColor(xa.r,xa.g,xa.b,Ja);this.context=f;var Xa=f.getParameter(f.MAX_VERTEX_TEXTURE_IMAGE_UNITS)>0,t={};t.vertices=new Float32Array(16);t.faces=new Uint16Array(6);i=0;t.vertices[i++]=-1;t.vertices[i++]=-1;t.vertices[i++]=0;t.vertices[i++]=1;t.vertices[i++]=1;t.vertices[i++]=
-1;t.vertices[i++]=1;t.vertices[i++]=1;t.vertices[i++]=1;t.vertices[i++]=1;t.vertices[i++]=1;t.vertices[i++]=0;t.vertices[i++]=-1;t.vertices[i++]=1;t.vertices[i++]=0;i=t.vertices[i++]=0;t.faces[i++]=0;t.faces[i++]=1;t.faces[i++]=2;t.faces[i++]=0;t.faces[i++]=2;t.faces[i++]=3;t.vertexBuffer=f.createBuffer();t.elementBuffer=f.createBuffer();f.bindBuffer(f.ARRAY_BUFFER,t.vertexBuffer);f.bufferData(f.ARRAY_BUFFER,t.vertices,f.STATIC_DRAW);f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,t.elementBuffer);f.bufferData(f.ELEMENT_ARRAY_BUFFER,
t.faces,f.STATIC_DRAW);t.program=f.createProgram();f.attachShader(t.program,U("fragment",THREE.ShaderLib.sprite.fragmentShader));f.attachShader(t.program,U("vertex",THREE.ShaderLib.sprite.vertexShader));f.linkProgram(t.program);t.attributes={};t.uniforms={};t.attributes.position=f.getAttribLocation(t.program,"position");t.attributes.uv=f.getAttribLocation(t.program,"uv");t.uniforms.uvOffset=f.getUniformLocation(t.program,"uvOffset");t.uniforms.uvScale=f.getUniformLocation(t.program,"uvScale");t.uniforms.rotation=
f.getUniformLocation(t.program,"rotation");t.uniforms.scale=f.getUniformLocation(t.program,"scale");t.uniforms.alignment=f.getUniformLocation(t.program,"alignment");t.uniforms.map=f.getUniformLocation(t.program,"map");t.uniforms.opacity=f.getUniformLocation(t.program,"opacity");t.uniforms.useScreenCoordinates=f.getUniformLocation(t.program,"useScreenCoordinates");t.uniforms.affectedByDistance=f.getUniformLocation(t.program,"affectedByDistance");t.uniforms.screenPosition=f.getUniformLocation(t.program,
"screenPosition");t.uniforms.modelViewMatrix=f.getUniformLocation(t.program,"modelViewMatrix");t.uniforms.projectionMatrix=f.getUniformLocation(t.program,"projectionMatrix");var Va=!1;this.setSize=function(b,c){Ia.width=b;Ia.height=c;this.setViewport(0,0,Ia.width,Ia.height)};this.setViewport=function(b,c,d,e){K=b;Ba=c;Ea=d;wa=e;f.viewport(K,Ba,Ea,wa)};this.setScissor=function(b,c,d,e){f.scissor(b,c,d,e)};this.enableScissorTest=function(b){b?f.enable(f.SCISSOR_TEST):f.disable(f.SCISSOR_TEST)};this.enableDepthBufferWrite=
function(b){va=b;f.depthMask(b)};this.setClearColorHex=function(b,c){xa.setHex(b);Ja=c;f.clearColor(xa.r,xa.g,xa.b,Ja)};this.setClearColor=function(b,c){xa.copy(b);Ja=c;f.clearColor(xa.r,xa.g,xa.b,Ja)};this.clear=function(){f.clear(f.COLOR_BUFFER_BIT|f.DEPTH_BUFFER_BIT|f.STENCIL_BUFFER_BIT)};this.getContext=function(){return f};this.initMaterial=function(b,c,d,e){var g,h,j;b instanceof THREE.MeshDepthMaterial?j="depth":b instanceof THREE.MeshNormalMaterial?j="normal":b instanceof THREE.MeshBasicMaterial?
j="basic":b instanceof THREE.MeshLambertMaterial?j="lambert":b instanceof THREE.MeshPhongMaterial?j="phong":b instanceof THREE.LineBasicMaterial?j="basic":b instanceof THREE.ParticleBasicMaterial&&(j="particle_basic");if(j){var k=THREE.ShaderLib[j];b.uniforms=THREE.UniformsUtils.clone(k.uniforms);b.vertexShader=k.vertexShader;b.fragmentShader=k.fragmentShader}var m,p,q;m=q=k=0;for(p=c.length;m<p;m++)h=c[m],h instanceof THREE.SpotLight&&q++,h instanceof THREE.DirectionalLight&&q++,h instanceof THREE.PointLight&&
k++;k+q<=4?m=q:(m=Math.ceil(4*q/(k+q)),k=4-m);h={directional:m,point:k};k=q=0;for(m=c.length;k<m;k++)p=c[k],p instanceof THREE.SpotLight&&p.castShadow&&q++;var o=50;if(e!==void 0&&e instanceof THREE.SkinnedMesh)o=e.bones.length;var r;a:{m=b.fragmentShader;p=b.vertexShader;var k=b.uniforms,c=b.attributes,d={map:!!b.map,envMap:!!b.envMap,lightMap:!!b.lightMap,vertexColors:b.vertexColors,fog:d,sizeAttenuation:b.sizeAttenuation,skinning:b.skinning,morphTargets:b.morphTargets,maxMorphTargets:this.maxMorphTargets,
maxDirLights:h.directional,maxPointLights:h.point,maxBones:o,shadowMapEnabled:this.shadowMapEnabled&&e.receiveShadow,shadowMapSoft:this.shadowMapSoft,shadowMapWidth:this.shadowMapWidth,shadowMapHeight:this.shadowMapHeight,maxShadows:q,alphaTest:b.alphaTest},u,e=[];j?e.push(j):(e.push(m),e.push(p));for(u in d)e.push(u),e.push(d[u]);j=e.join();u=0;for(e=ua.length;u<e;u++)if(ua[u].code==j){r=ua[u].program;break a}u=f.createProgram();e=[Xa?"#define VERTEX_TEXTURES":"","#define MAX_DIR_LIGHTS "+d.maxDirLights,
"#define MAX_POINT_LIGHTS "+d.maxPointLights,"#define MAX_SHADOWS "+d.maxShadows,"#define MAX_BONES "+d.maxBones,d.map?"#define USE_MAP":"",d.envMap?"#define USE_ENVMAP":"",d.lightMap?"#define USE_LIGHTMAP":"",d.vertexColors?"#define USE_COLOR":"",d.skinning?"#define USE_SKINNING":"",d.morphTargets?"#define USE_MORPHTARGETS":"",d.shadowMapEnabled?"#define USE_SHADOWMAP":"",d.shadowMapSoft?"#define SHADOWMAP_SOFT":"",d.sizeAttenuation?"#define USE_SIZEATTENUATION":"","uniform mat4 objectMatrix;\nuniform mat4 modelViewMatrix;\nuniform mat4 projectionMatrix;\nuniform mat4 viewMatrix;\nuniform mat3 normalMatrix;\nuniform vec3 cameraPosition;\nuniform mat4 cameraInverseMatrix;\nattribute vec3 position;\nattribute vec3 normal;\nattribute vec2 uv;\nattribute vec2 uv2;\n#ifdef USE_COLOR\nattribute vec3 color;\n#endif\n#ifdef USE_MORPHTARGETS\nattribute vec3 morphTarget0;\nattribute vec3 morphTarget1;\nattribute vec3 morphTarget2;\nattribute vec3 morphTarget3;\nattribute vec3 morphTarget4;\nattribute vec3 morphTarget5;\nattribute vec3 morphTarget6;\nattribute vec3 morphTarget7;\n#endif\n#ifdef USE_SKINNING\nattribute vec4 skinVertexA;\nattribute vec4 skinVertexB;\nattribute vec4 skinIndex;\nattribute vec4 skinWeight;\n#endif\n"].join("\n");
h=["#ifdef GL_ES\nprecision highp float;\n#endif","#define MAX_DIR_LIGHTS "+d.maxDirLights,"#define MAX_POINT_LIGHTS "+d.maxPointLights,"#define MAX_SHADOWS "+d.maxShadows,d.alphaTest?"#define ALPHATEST "+d.alphaTest:"",d.fog?"#define USE_FOG":"",d.fog instanceof THREE.FogExp2?"#define FOG_EXP2":"",d.map?"#define USE_MAP":"",d.envMap?"#define USE_ENVMAP":"",d.lightMap?"#define USE_LIGHTMAP":"",d.vertexColors?"#define USE_COLOR":"",d.shadowMapEnabled?"#define USE_SHADOWMAP":"",d.shadowMapSoft?"#define SHADOWMAP_SOFT":
"",d.shadowMapSoft?"#define SHADOWMAP_WIDTH "+d.shadowMapWidth.toFixed(1):"",d.shadowMapSoft?"#define SHADOWMAP_HEIGHT "+d.shadowMapHeight.toFixed(1):"","uniform mat4 viewMatrix;\nuniform vec3 cameraPosition;\n"].join("\n");f.attachShader(u,U("fragment",h+m));f.attachShader(u,U("vertex",e+p));f.linkProgram(u);f.getProgramParameter(u,f.LINK_STATUS)||console.error("Could not initialise shader\nVALIDATE_STATUS: "+f.getProgramParameter(u,f.VALIDATE_STATUS)+", gl error ["+f.getError()+"]");u.uniforms=
{};u.attributes={};var t,e=["viewMatrix","modelViewMatrix","projectionMatrix","normalMatrix","objectMatrix","cameraPosition","cameraInverseMatrix","boneGlobalMatrices","morphTargetInfluences"];for(t in k)e.push(t);t=e;e=0;for(k=t.length;e<k;e++)m=t[e],u.uniforms[m]=f.getUniformLocation(u,m);e=["position","normal","uv","uv2","tangent","color","skinVertexA","skinVertexB","skinIndex","skinWeight"];for(t=0;t<d.maxMorphTargets;t++)e.push("morphTarget"+t);for(r in c)e.push(r);r=e;t=0;for(c=r.length;t<c;t++)d=
r[t],u.attributes[d]=f.getAttribLocation(u,d);ua.push({program:u,code:j});r=u}b.program=r;r=b.program.attributes;r.position>=0&&f.enableVertexAttribArray(r.position);r.color>=0&&f.enableVertexAttribArray(r.color);r.normal>=0&&f.enableVertexAttribArray(r.normal);r.tangent>=0&&f.enableVertexAttribArray(r.tangent);b.skinning&&r.skinVertexA>=0&&r.skinVertexB>=0&&r.skinIndex>=0&&r.skinWeight>=0&&(f.enableVertexAttribArray(r.skinVertexA),f.enableVertexAttribArray(r.skinVertexB),f.enableVertexAttribArray(r.skinIndex),
f.enableVertexAttribArray(r.skinWeight));if(b.attributes)for(g in b.attributes)r[g]!==void 0&&r[g]>=0&&f.enableVertexAttribArray(r[g]);if(b.morphTargets)for(g=b.numSupportedMorphTargets=0;g<this.maxMorphTargets;g++)t="morphTarget"+g,r[t]>=0&&(f.enableVertexAttribArray(r[t]),b.numSupportedMorphTargets++)};this.render=function(b,c,o,t){var G,J,ga,A,Pa,R,B,F,D=b.lights,Oa=b.fog;this.shadowMapEnabled&&C(b,c);L.data.vertices=0;L.data.faces=0;L.data.drawCalls=0;c.matrixAutoUpdate&&c.update(void 0,!0);b.update(void 0,
!1,c);c.matrixWorldInverse.flattenToArray(Da);c.projectionMatrix.flattenToArray(Fa);Z.multiply(c.projectionMatrix,c.matrixWorldInverse);q(Z);this.initWebGLObjects(b);T(o);(this.autoClear||t)&&this.clear();Pa=b.__webglObjects.length;for(t=0;t<Pa;t++)if(G=b.__webglObjects[t],B=G.object,B.visible)if(!(B instanceof THREE.Mesh)||m(B)){if(B.matrixWorld.flattenToArray(B._objectMatrixArray),E(B,c,!0),r(G),G.render=!0,this.sortObjects)G.object.renderDepth?G.z=G.object.renderDepth:(Ha.copy(B.position),Z.multiplyVector3(Ha),
G.z=Ha.z)}else G.render=!1;else G.render=!1;this.sortObjects&&b.__webglObjects.sort(v);R=b.__webglObjectsImmediate.length;for(t=0;t<R;t++)G=b.__webglObjectsImmediate[t],B=G.object,B.visible&&(B.matrixAutoUpdate&&B.matrixWorld.flattenToArray(B._objectMatrixArray),E(B,c,!0),p(G));if(b.overrideMaterial){g(b.overrideMaterial.depthTest);u(b.overrideMaterial.blending);for(t=0;t<Pa;t++)if(G=b.__webglObjects[t],G.render)B=G.object,F=G.buffer,j(B),e(c,D,Oa,b.overrideMaterial,F,B);for(t=0;t<R;t++)G=b.__webglObjectsImmediate[t],
B=G.object,B.visible&&(j(B),J=d(c,D,Oa,b.overrideMaterial,B),B.render(function(c){h(c,J,b.overrideMaterial.shading)}))}else{u(THREE.NormalBlending);for(t=Pa-1;t>=0;t--)if(G=b.__webglObjects[t],G.render){B=G.object;F=G.buffer;ga=G.opaque;j(B);for(G=0;G<ga.count;G++)A=ga.list[G],g(A.depthTest),k(A.polygonOffset,A.polygonOffsetFactor,A.polygonOffsetUnits),e(c,D,Oa,A,F,B)}for(t=0;t<R;t++)if(G=b.__webglObjectsImmediate[t],B=G.object,B.visible){ga=G.opaque;j(B);for(G=0;G<ga.count;G++)A=ga.list[G],g(A.depthTest),
k(A.polygonOffset,A.polygonOffsetFactor,A.polygonOffsetUnits),J=d(c,D,Oa,A,B),B.render(function(b){h(b,J,A.shading)})}for(t=0;t<Pa;t++)if(G=b.__webglObjects[t],G.render){B=G.object;F=G.buffer;ga=G.transparent;j(B);for(G=0;G<ga.count;G++)A=ga.list[G],u(A.blending),g(A.depthTest),k(A.polygonOffset,A.polygonOffsetFactor,A.polygonOffsetUnits),e(c,D,Oa,A,F,B)}for(t=0;t<R;t++)if(G=b.__webglObjectsImmediate[t],B=G.object,B.visible){ga=G.transparent;j(B);for(G=0;G<ga.count;G++)A=ga.list[G],u(A.blending),
g(A.depthTest),k(A.polygonOffset,A.polygonOffsetFactor,A.polygonOffsetUnits),J=d(c,D,Oa,A,B),B.render(function(b){h(b,J,A.shading)})}}b.__webglSprites.length&&x(b,c);o&&o.minFilter!==THREE.NearestFilter&&o.minFilter!==THREE.LinearFilter&&(f.bindTexture(f.TEXTURE_2D,o.__webglTexture),f.generateMipmap(f.TEXTURE_2D),f.bindTexture(f.TEXTURE_2D,null))};this.initWebGLObjects=function(b){if(!b.__webglObjects)b.__webglObjects=[],b.__webglObjectsImmediate=[],b.__webglSprites=[];for(;b.__objectsAdded.length;){var d=
b.__objectsAdded[0],e=b,g=void 0,h=void 0,j=void 0;if(d._modelViewMatrix==void 0)d._modelViewMatrix=new THREE.Matrix4,d._normalMatrixArray=new Float32Array(9),d._modelViewMatrixArray=new Float32Array(16),d._objectMatrixArray=new Float32Array(16),d.matrixWorld.flattenToArray(d._objectMatrixArray);if(d instanceof THREE.Mesh)for(g in h=d.geometry,h.geometryGroups==void 0&&sa(h),h.geometryGroups){j=h.geometryGroups[g];if(!j.__webglVertexBuffer){var k=j;k.__webglVertexBuffer=f.createBuffer();k.__webglNormalBuffer=
f.createBuffer();k.__webglTangentBuffer=f.createBuffer();k.__webglColorBuffer=f.createBuffer();k.__webglUVBuffer=f.createBuffer();k.__webglUV2Buffer=f.createBuffer();k.__webglSkinVertexABuffer=f.createBuffer();k.__webglSkinVertexBBuffer=f.createBuffer();k.__webglSkinIndicesBuffer=f.createBuffer();k.__webglSkinWeightsBuffer=f.createBuffer();k.__webglFaceBuffer=f.createBuffer();k.__webglLineBuffer=f.createBuffer();if(k.numMorphTargets){var m=void 0,p=void 0;k.__webglMorphTargetsBuffers=[];m=0;for(p=
k.numMorphTargets;m<p;m++)k.__webglMorphTargetsBuffers.push(f.createBuffer())}for(var k=j,m=d,r=void 0,q=void 0,o=void 0,u=o=void 0,t=void 0,v=void 0,C=v=p=0,x=o=q=void 0,E=x=q=r=void 0,o=void 0,u=m.geometry,t=u.faces,x=k.faces,r=0,q=x.length;r<q;r++)o=x[r],o=t[o],o instanceof THREE.Face3?(p+=3,v+=1,C+=3):o instanceof THREE.Face4&&(p+=4,v+=2,C+=4);for(var r=k,q=m,I=x=t=void 0,H=void 0,I=void 0,o=[],t=0,x=q.materials.length;t<x;t++)if(I=q.materials[t],I instanceof THREE.MeshFaceMaterial){I=0;for(l=
r.materials.length;I<l;I++)(H=r.materials[I])&&o.push(H)}else(H=I)&&o.push(H);r=o;k.__materials=r;a:{t=q=void 0;x=r.length;for(q=0;q<x;q++)if(t=r[q],t.map||t.lightMap||t instanceof THREE.MeshShaderMaterial){q=!0;break a}q=!1}a:{x=t=void 0;o=r.length;for(t=0;t<o;t++)if(x=r[t],!(x instanceof THREE.MeshBasicMaterial&&!x.envMap||x instanceof THREE.MeshDepthMaterial)){x=x&&x.shading!=void 0&&x.shading==THREE.SmoothShading?THREE.SmoothShading:THREE.FlatShading;break a}x=!1}a:{o=t=void 0;I=r.length;for(t=
0;t<I;t++)if(o=r[t],o.vertexColors){o=o.vertexColors;break a}o=!1}k.__vertexArray=new Float32Array(p*3);if(x)k.__normalArray=new Float32Array(p*3);if(u.hasTangents)k.__tangentArray=new Float32Array(p*4);if(o)k.__colorArray=new Float32Array(p*3);if(q){if(u.faceUvs.length>0||u.faceVertexUvs.length>0)k.__uvArray=new Float32Array(p*2);if(u.faceUvs.length>1||u.faceVertexUvs.length>1)k.__uv2Array=new Float32Array(p*2)}if(m.geometry.skinWeights.length&&m.geometry.skinIndices.length)k.__skinVertexAArray=
new Float32Array(p*4),k.__skinVertexBArray=new Float32Array(p*4),k.__skinIndexArray=new Float32Array(p*4),k.__skinWeightArray=new Float32Array(p*4);k.__faceArray=new Uint16Array(v*3+(m.geometry.edgeFaces?m.geometry.edgeFaces.length*6:0));k.__lineArray=new Uint16Array(C*2);if(k.numMorphTargets){k.__morphTargetsArrays=[];u=0;for(t=k.numMorphTargets;u<t;u++)k.__morphTargetsArrays.push(new Float32Array(p*3))}k.__needsSmoothNormals=x==THREE.SmoothShading;k.__uvType=q;k.__vertexColorType=o;k.__normalType=
x;k.__webglFaceCount=v*3+(m.geometry.edgeFaces?m.geometry.edgeFaces.length*6:0);k.__webglLineCount=C*2;u=0;for(t=r.length;u<t;u++)if(q=r[u],q.attributes){if(k.__webglCustomAttributes===void 0)k.__webglCustomAttributes={};for(a in q.attributes){o=q.attributes[a];x={};for(E in o)x[E]=o[E];if(!x.__webglInitialized||x.createUniqueBuffers)x.__webglInitialized=!0,v=1,x.type==="v2"?v=2:x.type==="v3"?v=3:x.type==="v4"?v=4:x.type==="c"&&(v=3),x.size=v,x.array=new Float32Array(p*v),x.buffer=f.createBuffer(),
x.buffer.belongsToAttribute=a,o.needsUpdate=!0,x.__original=o;k.__webglCustomAttributes[a]=x}}k.__inittedArrays=!0;h.__dirtyVertices=!0;h.__dirtyMorphTargets=!0;h.__dirtyElements=!0;h.__dirtyUvs=!0;h.__dirtyNormals=!0;h.__dirtyTangents=!0;h.__dirtyColors=!0}V(e.__webglObjects,j,d)}else if(d instanceof THREE.Ribbon){h=d.geometry;if(!h.__webglVertexBuffer)g=h,g.__webglVertexBuffer=f.createBuffer(),g.__webglColorBuffer=f.createBuffer(),g=h,j=g.vertices.length,g.__vertexArray=new Float32Array(j*3),g.__colorArray=
new Float32Array(j*3),g.__webglVertexCount=j,h.__dirtyVertices=!0,h.__dirtyColors=!0;V(e.__webglObjects,h,d)}else if(d instanceof THREE.Line){h=d.geometry;if(!h.__webglVertexBuffer)g=h,g.__webglVertexBuffer=f.createBuffer(),g.__webglColorBuffer=f.createBuffer(),g=h,j=g.vertices.length,g.__vertexArray=new Float32Array(j*3),g.__colorArray=new Float32Array(j*3),g.__webglLineCount=j,h.__dirtyVertices=!0,h.__dirtyColors=!0;V(e.__webglObjects,h,d)}else if(d instanceof THREE.ParticleSystem){h=d.geometry;
if(!h.__webglVertexBuffer){g=h;g.__webglVertexBuffer=f.createBuffer();g.__webglColorBuffer=f.createBuffer();g=h;j=d;k=g.vertices.length;g.__vertexArray=new Float32Array(k*3);g.__colorArray=new Float32Array(k*3);g.__sortArray=[];g.__webglParticleCount=k;g.__materials=j.materials;E=p=m=void 0;m=0;for(p=j.materials.length;m<p;m++)if(E=j.materials[m],E.attributes){if(g.__webglCustomAttributes===void 0)g.__webglCustomAttributes={};for(a in E.attributes){originalAttribute=E.attributes[a];attribute={};for(property in originalAttribute)attribute[property]=
originalAttribute[property];if(!attribute.__webglInitialized||attribute.createUniqueBuffers)attribute.__webglInitialized=!0,size=1,attribute.type==="v2"?size=2:attribute.type==="v3"?size=3:attribute.type==="v4"?size=4:attribute.type==="c"&&(size=3),attribute.size=size,attribute.array=new Float32Array(k*size),attribute.buffer=f.createBuffer(),attribute.buffer.belongsToAttribute=a,originalAttribute.needsUpdate=!0,attribute.__original=originalAttribute;g.__webglCustomAttributes[a]=attribute}}h.__dirtyVertices=
!0;h.__dirtyColors=!0}V(e.__webglObjects,h,d)}else THREE.MarchingCubes!==void 0&&d instanceof THREE.MarchingCubes?e.__webglObjectsImmediate.push({object:d,opaque:{list:[],count:0},transparent:{list:[],count:0}}):d instanceof THREE.Sprite&&e.__webglSprites.push(d);b.__objectsAdded.splice(0,1)}for(;b.__objectsRemoved.length;){e=b.__objectsRemoved[0];d=b;if(e instanceof THREE.Mesh||e instanceof THREE.ParticleSystem||e instanceof THREE.Ribbon||e instanceof THREE.Line)za(d.__webglObjects,e);else if(e instanceof
THREE.Sprite){d=d.__webglSprites;h=void 0;for(h=d.length-1;h>=0;h--)d[h]==e&&d.splice(h,1)}else e instanceof THREE.MarchingCubes&&za(d.__webglObjectsImmediate,e);b.__objectsRemoved.splice(0,1)}d=0;for(e=b.__webglObjects.length;d<e;d++)if(g=b.__webglObjects[d].object,m=k=h=j=void 0,g instanceof THREE.Mesh){h=g.geometry;for(j in h.geometryGroups)if(k=h.geometryGroups[j],m=J(k),h.__dirtyVertices||h.__dirtyMorphTargets||h.__dirtyElements||h.__dirtyUvs||h.__dirtyNormals||h.__dirtyColors||h.__dirtyTangents||
m)if(m=k,p=f.DYNAMIC_DRAW,E=!h.dynamic,m.__inittedArrays){var D=C=v=void 0,z=void 0,L=D=void 0,K=void 0,O=void 0,M=void 0,N=H=I=o=x=t=q=r=u=void 0,s=z=M=z=O=K=void 0,n=void 0,y=n=s=K=void 0,P=void 0,U=y=n=s=D=D=L=M=z=y=n=s=P=y=n=s=P=y=n=s=void 0,ia=0,ka=0,W=0,Y=0,T=0,Q=0,X=0,S=0,ja=0,w=0,la=0,y=s=0,y=void 0,na=m.__vertexArray,ma=m.__uvArray,pa=m.__uv2Array,Z=m.__normalArray,$=m.__tangentArray,oa=m.__colorArray,aa=m.__skinVertexAArray,ca=m.__skinVertexBArray,da=m.__skinIndexArray,ea=m.__skinWeightArray,
ta=m.__morphTargetsArrays,fa=m.__webglCustomAttributes,n=void 0,ha=m.__faceArray,Ca=m.__lineArray,xa=m.__needsSmoothNormals,r=m.__vertexColorType,u=m.__uvType,q=m.__normalType,ra=g.geometry,ua=ra.__dirtyVertices,va=ra.__dirtyElements,qa=ra.__dirtyUvs,Aa=ra.__dirtyNormals,Ba=ra.__dirtyTangents,Da=ra.__dirtyColors,Ea=ra.__dirtyMorphTargets,wa=ra.vertices,Fa=m.faces,Ia=ra.faces,Ha=ra.faceVertexUvs[0],Ja=ra.faceVertexUvs[1],La=ra.skinVerticesA,Ma=ra.skinVerticesB,Na=ra.skinIndices,Ka=ra.skinWeights,Ga=
ra.morphTargets;if(fa)for(U in fa)fa[U].offset=0,fa[U].offsetSrc=0;v=0;for(C=Fa.length;v<C;v++)if(D=Fa[v],z=Ia[D],Ha&&(t=Ha[D]),Ja&&(x=Ja[D]),D=z.vertexNormals,L=z.normal,K=z.vertexColors,O=z.color,M=z.vertexTangents,z instanceof THREE.Face3){if(ua)o=wa[z.a].position,I=wa[z.b].position,H=wa[z.c].position,na[ka]=o.x,na[ka+1]=o.y,na[ka+2]=o.z,na[ka+3]=I.x,na[ka+4]=I.y,na[ka+5]=I.z,na[ka+6]=H.x,na[ka+7]=H.y,na[ka+8]=H.z,ka+=9;if(fa)for(U in fa)if(n=fa[U],n.__original.needsUpdate)s=n.offset,y=n.offsetSrc,
n.size===1?(n.boundTo===void 0||n.boundTo==="vertices"?(n.array[s]=n.value[z.a],n.array[s+1]=n.value[z.b],n.array[s+2]=n.value[z.c]):n.boundTo==="faces"?(y=n.value[y],n.array[s]=y,n.array[s+1]=y,n.array[s+2]=y,n.offsetSrc++):n.boundTo==="faceVertices"&&(n.array[s]=n.value[y],n.array[s+1]=n.value[y+1],n.array[s+2]=n.value[y+2],n.offsetSrc+=3),n.offset+=3):(n.boundTo===void 0||n.boundTo==="vertices"?(o=n.value[z.a],I=n.value[z.b],H=n.value[z.c]):n.boundTo==="faces"?(H=I=o=y=n.value[y],n.offsetSrc++):
n.boundTo==="faceVertices"&&(o=n.value[y],I=n.value[y+1],H=n.value[y+2],n.offsetSrc+=3),n.size===2?(n.array[s]=o.x,n.array[s+1]=o.y,n.array[s+2]=I.x,n.array[s+3]=I.y,n.array[s+4]=H.x,n.array[s+5]=H.y,n.offset+=6):n.size===3?(n.type==="c"?(n.array[s]=o.r,n.array[s+1]=o.g,n.array[s+2]=o.b,n.array[s+3]=I.r,n.array[s+4]=I.g,n.array[s+5]=I.b,n.array[s+6]=H.r,n.array[s+7]=H.g,n.array[s+8]=H.b):(n.array[s]=o.x,n.array[s+1]=o.y,n.array[s+2]=o.z,n.array[s+3]=I.x,n.array[s+4]=I.y,n.array[s+5]=I.z,n.array[s+
6]=H.x,n.array[s+7]=H.y,n.array[s+8]=H.z),n.offset+=9):(n.array[s]=o.x,n.array[s+1]=o.y,n.array[s+2]=o.z,n.array[s+3]=o.w,n.array[s+4]=I.x,n.array[s+5]=I.y,n.array[s+6]=I.z,n.array[s+7]=I.w,n.array[s+8]=H.x,n.array[s+9]=H.y,n.array[s+10]=H.z,n.array[s+11]=H.w,n.offset+=12));if(Ea){s=0;for(n=Ga.length;s<n;s++)o=Ga[s].vertices[z.a].position,I=Ga[s].vertices[z.b].position,H=Ga[s].vertices[z.c].position,y=ta[s],y[la]=o.x,y[la+1]=o.y,y[la+2]=o.z,y[la+3]=I.x,y[la+4]=I.y,y[la+5]=I.z,y[la+6]=H.x,y[la+7]=
H.y,y[la+8]=H.z;la+=9}if(Ka.length)s=Ka[z.a],n=Ka[z.b],y=Ka[z.c],ea[w]=s.x,ea[w+1]=s.y,ea[w+2]=s.z,ea[w+3]=s.w,ea[w+4]=n.x,ea[w+5]=n.y,ea[w+6]=n.z,ea[w+7]=n.w,ea[w+8]=y.x,ea[w+9]=y.y,ea[w+10]=y.z,ea[w+11]=y.w,s=Na[z.a],n=Na[z.b],y=Na[z.c],da[w]=s.x,da[w+1]=s.y,da[w+2]=s.z,da[w+3]=s.w,da[w+4]=n.x,da[w+5]=n.y,da[w+6]=n.z,da[w+7]=n.w,da[w+8]=y.x,da[w+9]=y.y,da[w+10]=y.z,da[w+11]=y.w,s=La[z.a],n=La[z.b],y=La[z.c],aa[w]=s.x,aa[w+1]=s.y,aa[w+2]=s.z,aa[w+3]=1,aa[w+4]=n.x,aa[w+5]=n.y,aa[w+6]=n.z,aa[w+7]=
1,aa[w+8]=y.x,aa[w+9]=y.y,aa[w+10]=y.z,aa[w+11]=1,s=Ma[z.a],n=Ma[z.b],y=Ma[z.c],ca[w]=s.x,ca[w+1]=s.y,ca[w+2]=s.z,ca[w+3]=1,ca[w+4]=n.x,ca[w+5]=n.y,ca[w+6]=n.z,ca[w+7]=1,ca[w+8]=y.x,ca[w+9]=y.y,ca[w+10]=y.z,ca[w+11]=1,w+=12;if(Da&&r)K.length==3&&r==THREE.VertexColors?(z=K[0],s=K[1],n=K[2]):n=s=z=O,oa[ja]=z.r,oa[ja+1]=z.g,oa[ja+2]=z.b,oa[ja+3]=s.r,oa[ja+4]=s.g,oa[ja+5]=s.b,oa[ja+6]=n.r,oa[ja+7]=n.g,oa[ja+8]=n.b,ja+=9;if(Ba&&ra.hasTangents)K=M[0],O=M[1],z=M[2],$[X]=K.x,$[X+1]=K.y,$[X+2]=K.z,$[X+3]=
K.w,$[X+4]=O.x,$[X+5]=O.y,$[X+6]=O.z,$[X+7]=O.w,$[X+8]=z.x,$[X+9]=z.y,$[X+10]=z.z,$[X+11]=z.w,X+=12;if(Aa&&q)if(D.length==3&&xa)for(M=0;M<3;M++)L=D[M],Z[Q]=L.x,Z[Q+1]=L.y,Z[Q+2]=L.z,Q+=3;else for(M=0;M<3;M++)Z[Q]=L.x,Z[Q+1]=L.y,Z[Q+2]=L.z,Q+=3;if(qa&&t!==void 0&&u)for(M=0;M<3;M++)D=t[M],ma[W]=D.u,ma[W+1]=D.v,W+=2;if(qa&&x!==void 0&&u)for(M=0;M<3;M++)D=x[M],pa[Y]=D.u,pa[Y+1]=D.v,Y+=2;va&&(ha[T]=ia,ha[T+1]=ia+1,ha[T+2]=ia+2,T+=3,Ca[S]=ia,Ca[S+1]=ia+1,Ca[S+2]=ia,Ca[S+3]=ia+2,Ca[S+4]=ia+1,Ca[S+5]=ia+
2,S+=6,ia+=3)}else if(z instanceof THREE.Face4){if(ua)o=wa[z.a].position,I=wa[z.b].position,H=wa[z.c].position,N=wa[z.d].position,na[ka]=o.x,na[ka+1]=o.y,na[ka+2]=o.z,na[ka+3]=I.x,na[ka+4]=I.y,na[ka+5]=I.z,na[ka+6]=H.x,na[ka+7]=H.y,na[ka+8]=H.z,na[ka+9]=N.x,na[ka+10]=N.y,na[ka+11]=N.z,ka+=12;if(fa)for(U in fa)if(n=fa[U],n.__original.needsUpdate)s=n.offset,y=n.offsetSrc,n.size===1?(n.boundTo===void 0||n.boundTo==="vertices"?(n.array[s]=n.value[z.a],n.array[s+1]=n.value[z.b],n.array[s+2]=n.value[z.c],
n.array[s+3]=n.value[z.d]):n.boundTo==="faces"?(y=n.value[y],n.array[s]=y,n.array[s+1]=y,n.array[s+2]=y,n.array[s+3]=y,n.offsetSrc++):n.boundTo==="faceVertices"&&(n.array[s]=n.value[y],n.array[s+1]=n.value[y+1],n.array[s+2]=n.value[y+2],n.array[s+3]=n.value[y+3],n.offsetSrc+=4),n.offset+=4):(n.boundTo===void 0||n.boundTo==="vertices"?(o=n.value[z.a],I=n.value[z.b],H=n.value[z.c],N=n.value[z.d]):n.boundTo==="faces"?(N=H=I=o=y=n.value[y],n.offsetSrc++):n.boundTo==="faceVertices"&&(o=n.value[y],I=n.value[y+
1],H=n.value[y+2],N=n.value[y+3],n.offsetSrc+=4),n.size===2?(n.array[s]=o.x,n.array[s+1]=o.y,n.array[s+2]=I.x,n.array[s+3]=I.y,n.array[s+4]=H.x,n.array[s+5]=H.y,n.array[s+6]=N.x,n.array[s+7]=N.y,n.offset+=8):n.size===3?(n.type==="c"?(n.array[s]=o.r,n.array[s+1]=o.g,n.array[s+2]=o.b,n.array[s+3]=I.r,n.array[s+4]=I.g,n.array[s+5]=I.b,n.array[s+6]=H.r,n.array[s+7]=H.g,n.array[s+8]=H.b,n.array[s+9]=N.r,n.array[s+10]=N.g,n.array[s+11]=N.b):(n.array[s]=o.x,n.array[s+1]=o.y,n.array[s+2]=o.z,n.array[s+3]=
I.x,n.array[s+4]=I.y,n.array[s+5]=I.z,n.array[s+6]=H.x,n.array[s+7]=H.y,n.array[s+8]=H.z,n.array[s+9]=N.x,n.array[s+10]=N.y,n.array[s+11]=N.z),n.offset+=12):(n.array[s]=o.x,n.array[s+1]=o.y,n.array[s+2]=o.z,n.array[s+3]=o.w,n.array[s+4]=I.x,n.array[s+5]=I.y,n.array[s+6]=I.z,n.array[s+7]=I.w,n.array[s+8]=H.x,n.array[s+9]=H.y,n.array[s+10]=H.z,n.array[s+11]=H.w,n.array[s+12]=N.x,n.array[s+13]=N.y,n.array[s+14]=N.z,n.array[s+15]=N.w,n.offset+=16));if(Ea){s=0;for(n=Ga.length;s<n;s++)o=Ga[s].vertices[z.a].position,
I=Ga[s].vertices[z.b].position,H=Ga[s].vertices[z.c].position,N=Ga[s].vertices[z.d].position,y=ta[s],y[la]=o.x,y[la+1]=o.y,y[la+2]=o.z,y[la+3]=I.x,y[la+4]=I.y,y[la+5]=I.z,y[la+6]=H.x,y[la+7]=H.y,y[la+8]=H.z,y[la+9]=N.x,y[la+10]=N.y,y[la+11]=N.z;la+=12}if(Ka.length)s=Ka[z.a],n=Ka[z.b],y=Ka[z.c],P=Ka[z.d],ea[w]=s.x,ea[w+1]=s.y,ea[w+2]=s.z,ea[w+3]=s.w,ea[w+4]=n.x,ea[w+5]=n.y,ea[w+6]=n.z,ea[w+7]=n.w,ea[w+8]=y.x,ea[w+9]=y.y,ea[w+10]=y.z,ea[w+11]=y.w,ea[w+12]=P.x,ea[w+13]=P.y,ea[w+14]=P.z,ea[w+15]=P.w,
s=Na[z.a],n=Na[z.b],y=Na[z.c],P=Na[z.d],da[w]=s.x,da[w+1]=s.y,da[w+2]=s.z,da[w+3]=s.w,da[w+4]=n.x,da[w+5]=n.y,da[w+6]=n.z,da[w+7]=n.w,da[w+8]=y.x,da[w+9]=y.y,da[w+10]=y.z,da[w+11]=y.w,da[w+12]=P.x,da[w+13]=P.y,da[w+14]=P.z,da[w+15]=P.w,s=La[z.a],n=La[z.b],y=La[z.c],P=La[z.d],aa[w]=s.x,aa[w+1]=s.y,aa[w+2]=s.z,aa[w+3]=1,aa[w+4]=n.x,aa[w+5]=n.y,aa[w+6]=n.z,aa[w+7]=1,aa[w+8]=y.x,aa[w+9]=y.y,aa[w+10]=y.z,aa[w+11]=1,aa[w+12]=P.x,aa[w+13]=P.y,aa[w+14]=P.z,aa[w+15]=1,s=Ma[z.a],n=Ma[z.b],y=Ma[z.c],z=Ma[z.d],
ca[w]=s.x,ca[w+1]=s.y,ca[w+2]=s.z,ca[w+3]=1,ca[w+4]=n.x,ca[w+5]=n.y,ca[w+6]=n.z,ca[w+7]=1,ca[w+8]=y.x,ca[w+9]=y.y,ca[w+10]=y.z,ca[w+11]=1,ca[w+12]=z.x,ca[w+13]=z.y,ca[w+14]=z.z,ca[w+15]=1,w+=16;if(Da&&r)K.length==4&&r==THREE.VertexColors?(z=K[0],s=K[1],n=K[2],K=K[3]):K=n=s=z=O,oa[ja]=z.r,oa[ja+1]=z.g,oa[ja+2]=z.b,oa[ja+3]=s.r,oa[ja+4]=s.g,oa[ja+5]=s.b,oa[ja+6]=n.r,oa[ja+7]=n.g,oa[ja+8]=n.b,oa[ja+9]=K.r,oa[ja+10]=K.g,oa[ja+11]=K.b,ja+=12;if(Ba&&ra.hasTangents)K=M[0],O=M[1],z=M[2],M=M[3],$[X]=K.x,$[X+
1]=K.y,$[X+2]=K.z,$[X+3]=K.w,$[X+4]=O.x,$[X+5]=O.y,$[X+6]=O.z,$[X+7]=O.w,$[X+8]=z.x,$[X+9]=z.y,$[X+10]=z.z,$[X+11]=z.w,$[X+12]=M.x,$[X+13]=M.y,$[X+14]=M.z,$[X+15]=M.w,X+=16;if(Aa&&q)if(D.length==4&&xa)for(M=0;M<4;M++)L=D[M],Z[Q]=L.x,Z[Q+1]=L.y,Z[Q+2]=L.z,Q+=3;else for(M=0;M<4;M++)Z[Q]=L.x,Z[Q+1]=L.y,Z[Q+2]=L.z,Q+=3;if(qa&&t!==void 0&&u)for(M=0;M<4;M++)D=t[M],ma[W]=D.u,ma[W+1]=D.v,W+=2;if(qa&&x!==void 0&&u)for(M=0;M<4;M++)D=x[M],pa[Y]=D.u,pa[Y+1]=D.v,Y+=2;va&&(ha[T]=ia,ha[T+1]=ia+1,ha[T+2]=ia+3,ha[T+
3]=ia+1,ha[T+4]=ia+2,ha[T+5]=ia+3,T+=6,Ca[S]=ia,Ca[S+1]=ia+1,Ca[S+2]=ia,Ca[S+3]=ia+3,Ca[S+4]=ia+1,Ca[S+5]=ia+2,Ca[S+6]=ia+2,Ca[S+7]=ia+3,S+=8,ia+=4)}ua&&(f.bindBuffer(f.ARRAY_BUFFER,m.__webglVertexBuffer),f.bufferData(f.ARRAY_BUFFER,na,p));if(fa)for(U in fa)n=fa[U],n.__original.needsUpdate&&(f.bindBuffer(f.ARRAY_BUFFER,n.buffer),f.bufferData(f.ARRAY_BUFFER,n.array,p));if(Ea){s=0;for(n=Ga.length;s<n;s++)f.bindBuffer(f.ARRAY_BUFFER,m.__webglMorphTargetsBuffers[s]),f.bufferData(f.ARRAY_BUFFER,ta[s],
p)}Da&&ja>0&&(f.bindBuffer(f.ARRAY_BUFFER,m.__webglColorBuffer),f.bufferData(f.ARRAY_BUFFER,oa,p));Aa&&(f.bindBuffer(f.ARRAY_BUFFER,m.__webglNormalBuffer),f.bufferData(f.ARRAY_BUFFER,Z,p));Ba&&ra.hasTangents&&(f.bindBuffer(f.ARRAY_BUFFER,m.__webglTangentBuffer),f.bufferData(f.ARRAY_BUFFER,$,p));qa&&W>0&&(f.bindBuffer(f.ARRAY_BUFFER,m.__webglUVBuffer),f.bufferData(f.ARRAY_BUFFER,ma,p));qa&&Y>0&&(f.bindBuffer(f.ARRAY_BUFFER,m.__webglUV2Buffer),f.bufferData(f.ARRAY_BUFFER,pa,p));va&&(f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,
m.__webglFaceBuffer),f.bufferData(f.ELEMENT_ARRAY_BUFFER,ha,p),f.bindBuffer(f.ELEMENT_ARRAY_BUFFER,m.__webglLineBuffer),f.bufferData(f.ELEMENT_ARRAY_BUFFER,Ca,p));w>0&&(f.bindBuffer(f.ARRAY_BUFFER,m.__webglSkinVertexABuffer),f.bufferData(f.ARRAY_BUFFER,aa,p),f.bindBuffer(f.ARRAY_BUFFER,m.__webglSkinVertexBBuffer),f.bufferData(f.ARRAY_BUFFER,ca,p),f.bindBuffer(f.ARRAY_BUFFER,m.__webglSkinIndicesBuffer),f.bufferData(f.ARRAY_BUFFER,da,p),f.bindBuffer(f.ARRAY_BUFFER,m.__webglSkinWeightsBuffer),f.bufferData(f.ARRAY_BUFFER,
ea,p));E&&(delete m.__inittedArrays,delete m.__colorArray,delete m.__normalArray,delete m.__tangentArray,delete m.__uvArray,delete m.__uv2Array,delete m.__faceArray,delete m.__vertexArray,delete m.__lineArray,delete m.__skinVertexAArray,delete m.__skinVertexBArray,delete m.__skinIndexArray,delete m.__skinWeightArray)}h.__dirtyVertices=!1;h.__dirtyMorphTargets=!1;h.__dirtyElements=!1;h.__dirtyUvs=!1;h.__dirtyNormals=!1;h.__dirtyTangents=!1;h.__dirtyColors=!1;ya(k)}else if(g instanceof THREE.Ribbon){h=
g.geometry;if(h.__dirtyVertices||h.__dirtyColors){g=h;j=f.DYNAMIC_DRAW;k=C=v=v=void 0;u=g.vertices;m=g.colors;r=u.length;p=m.length;q=g.__vertexArray;E=g.__colorArray;t=g.__dirtyColors;if(g.__dirtyVertices){for(v=0;v<r;v++)C=u[v].position,k=v*3,q[k]=C.x,q[k+1]=C.y,q[k+2]=C.z;f.bindBuffer(f.ARRAY_BUFFER,g.__webglVertexBuffer);f.bufferData(f.ARRAY_BUFFER,q,j)}if(t){for(v=0;v<p;v++)color=m[v],k=v*3,E[k]=color.r,E[k+1]=color.g,E[k+2]=color.b;f.bindBuffer(f.ARRAY_BUFFER,g.__webglColorBuffer);f.bufferData(f.ARRAY_BUFFER,
E,j)}}h.__dirtyVertices=!1;h.__dirtyColors=!1}else if(g instanceof THREE.Line){h=g.geometry;if(h.__dirtyVertices||h.__dirtyColors){g=h;j=f.DYNAMIC_DRAW;k=C=v=v=void 0;u=g.vertices;m=g.colors;r=u.length;p=m.length;q=g.__vertexArray;E=g.__colorArray;t=g.__dirtyColors;if(g.__dirtyVertices){for(v=0;v<r;v++)C=u[v].position,k=v*3,q[k]=C.x,q[k+1]=C.y,q[k+2]=C.z;f.bindBuffer(f.ARRAY_BUFFER,g.__webglVertexBuffer);f.bufferData(f.ARRAY_BUFFER,q,j)}if(t){for(v=0;v<p;v++)color=m[v],k=v*3,E[k]=color.r,E[k+1]=color.g,
E[k+2]=color.b;f.bindBuffer(f.ARRAY_BUFFER,g.__webglColorBuffer);f.bufferData(f.ARRAY_BUFFER,E,j)}}h.__dirtyVertices=!1;h.__dirtyColors=!1}else if(g instanceof THREE.ParticleSystem)h=g.geometry,m=J(h),(h.__dirtyVertices||h.__dirtyColors||g.sortParticles||m)&&c(h,f.DYNAMIC_DRAW,g),h.__dirtyVertices=!1,h.__dirtyColors=!1,ya(h)};this.setFaceCulling=function(b,c){b?(!c||c=="ccw"?f.frontFace(f.CCW):f.frontFace(f.CW),b=="back"?f.cullFace(f.BACK):b=="front"?f.cullFace(f.FRONT):f.cullFace(f.FRONT_AND_BACK),
f.enable(f.CULL_FACE)):f.disable(f.CULL_FACE)};this.supportsVertexTextures=function(){return Xa}};
THREE.WebGLRenderTarget=function(b,c,d){this.width=b;this.height=c;d=d||{};this.wrapS=d.wrapS!==void 0?d.wrapS:THREE.ClampToEdgeWrapping;this.wrapT=d.wrapT!==void 0?d.wrapT:THREE.ClampToEdgeWrapping;this.magFilter=d.magFilter!==void 0?d.magFilter:THREE.LinearFilter;this.minFilter=d.minFilter!==void 0?d.minFilter:THREE.LinearMipMapLinearFilter;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.format=d.format!==void 0?d.format:THREE.RGBAFormat;this.type=d.type!==void 0?d.type:
THREE.UnsignedByteType;this.depthBuffer=d.depthBuffer!==void 0?d.depthBuffer:!0;this.stencilBuffer=d.stencilBuffer!==void 0?d.stencilBuffer:!0};
