// ThreeCanvas.js r43 - http://github.com/mrdoob/three.js
var THREE=THREE||{};if(!window.Int32Array)window.Int32Array=Array,window.Float32Array=Array;THREE.Color=function(a){a!==void 0&&this.setHex(a);return this};
THREE.Color.prototype={constructor:THREE.Color,r:1,g:1,b:1,copy:function(a){this.r=a.r;this.g=a.g;this.b=a.b;return this},setRGB:function(a,b,c){this.r=a;this.g=b;this.b=c;return this},setHSV:function(a,b,c){var d,f,g;if(c==0)this.r=this.g=this.b=0;else switch(d=Math.floor(a*6),f=a*6-d,a=c*(1-b),g=c*(1-b*f),b=c*(1-b*(1-f)),d){case 1:this.r=g;this.g=c;this.b=a;break;case 2:this.r=a;this.g=c;this.b=b;break;case 3:this.r=a;this.g=g;this.b=c;break;case 4:this.r=b;this.g=a;this.b=c;break;case 5:this.r=
c;this.g=a;this.b=g;break;case 6:case 0:this.r=c,this.g=b,this.b=a}return this},setHex:function(a){a=Math.floor(a);this.r=(a>>16&255)/255;this.g=(a>>8&255)/255;this.b=(a&255)/255;return this},getHex:function(){return~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},getContextStyle:function(){return"rgb("+Math.floor(this.r*255)+","+Math.floor(this.g*255)+","+Math.floor(this.b*255)+")"},clone:function(){return(new THREE.Color).setRGB(this.r,this.g,this.b)}};
THREE.Vector2=function(a,b){this.set(a||0,b||0)};
THREE.Vector2.prototype={constructor:THREE.Vector2,set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.x=a.x;this.y=a.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;return this},
divideScalar:function(a){a?(this.x/=a,this.y/=a):this.set(0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x,a=this.y-a.y;return b*b+a*a},setLength:function(a){return this.normalize().multiplyScalar(a)},
unit:function(){return this.normalize()},equals:function(a){return a.x==this.x&&a.y==this.y}};THREE.Vector3=function(a,b,c){this.set(a||0,b||0,c||0)};
THREE.Vector3.prototype={constructor:THREE.Vector3,set:function(a,b,c){this.x=a;this.y=b;this.z=c;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;return this},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;return this},addScalar:function(a){this.x+=a;this.y+=a;this.z+=a;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=
a.z-b.z;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;return this},multiply:function(a,b){this.x=a.x*b.x;this.y=a.y*b.y;this.z=a.z*b.z;return this},multiplySelf:function(a){this.x*=a.x;this.y*=a.y;this.z*=a.z;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;return this},divideSelf:function(a){return this.divide(this,a)},divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a):this.set(0,0,0);return this},negate:function(){return this.multiplyScalar(-1)},
dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.lengthSq())},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},cross:function(a,b){this.x=a.y*b.z-a.z*b.y;this.y=a.z*b.x-a.x*b.z;this.z=a.x*b.y-a.y*b.x;return this},crossSelf:function(a){return this.set(this.y*
a.z-this.z*a.y,this.z*a.x-this.x*a.z,this.x*a.y-this.y*a.x)},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){return(new THREE.Vector3).sub(this,a).lengthSq()},setPositionFromMatrix:function(a){this.x=a.n14;this.y=a.n24;this.z=a.n34},setRotationFromMatrix:function(a){var b=Math.cos(this.y);this.y=Math.asin(a.n13);Math.abs(b)>1.0E-5?(this.x=Math.atan2(-a.n23/b,a.n33/b),this.z=Math.atan2(-a.n12/b,a.n11/b)):(this.x=0,this.z=Math.atan2(a.n21,a.n22))},isZero:function(){return this.lengthSq()<
1.0E-4}};THREE.Vector4=function(a,b,c,d){this.set(a||0,b||0,c||0,d||1)};
THREE.Vector4.prototype={constructor:THREE.Vector4,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){return this.set(a.x,a.y,a.z,a.w||1)},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;this.w=a.w+b.w;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;this.w+=a.w;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;this.w=a.w-b.w;return this},
subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;this.w-=a.w;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;this.w*=a;return this},divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a,this.w/=a):this.set(0,0,0,1);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z+this.w*a.w},lengthSq:function(){return this.dot(this)},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},
setLength:function(a){return this.normalize().multiplyScalar(a)},lerpSelf:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;this.z+=(a.z-this.z)*b;this.w+=(a.w-this.w)*b;return this}};THREE.Ray=function(a,b){this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3};
THREE.Ray.prototype={constructor:THREE.Ray,intersectScene:function(a){return this.intersectObjects(a.objects)},intersectObjects:function(a){var b,c,d=[];b=0;for(c=a.length;b<c;b++)d=d.concat(this.intersectObject(a[b]));d.sort(function(a,b){return a.distance-b.distance});return d},intersectObject:function(a){function b(a,b,c){var d,c=c.matrixWorld.getPosition();d=c.clone().subSelf(a).dot(b);a=a.clone().addSelf(b.clone().multiplyScalar(d));return c.distanceTo(a)}function c(a,b,c,d){var d=d.clone().subSelf(b),
c=c.clone().subSelf(b),f=a.clone().subSelf(b),a=d.dot(d),b=d.dot(c),d=d.dot(f),e=c.dot(c),c=c.dot(f),f=1/(a*e-b*b),e=(e*d-b*c)*f,a=(a*c-b*d)*f;return e>0&&a>0&&e+a<1}if(a instanceof THREE.Particle){var d=b(this.origin,this.direction,a);if(!d||d>a.scale.x)return[];return[{distance:d,point:a.position,face:null,object:a}]}else if(a instanceof THREE.Mesh){d=b(this.origin,this.direction,a);if(!d||d>a.geometry.boundingSphere.radius*Math.max(a.scale.x,Math.max(a.scale.y,a.scale.z)))return[];var f,g,e,h,
j,l,m,i,n,k,p=a.geometry,q=p.vertices,v=[],d=0;for(f=p.faces.length;d<f;d++)if(g=p.faces[d],n=this.origin.clone(),k=this.direction.clone(),l=a.matrixWorld,e=l.multiplyVector3(q[g.a].position.clone()),h=l.multiplyVector3(q[g.b].position.clone()),j=l.multiplyVector3(q[g.c].position.clone()),l=g instanceof THREE.Face4?l.multiplyVector3(q[g.d].position.clone()):null,m=a.matrixRotationWorld.multiplyVector3(g.normal.clone()),i=k.dot(m),a.doubleSided||(a.flipSided?i>0:i<0))if(m=m.dot((new THREE.Vector3).sub(e,
n))/i,n=n.addSelf(k.multiplyScalar(m)),g instanceof THREE.Face3)c(n,e,h,j)&&(g={distance:this.origin.distanceTo(n),point:n,face:g,object:a},v.push(g));else if(g instanceof THREE.Face4&&(c(n,e,h,l)||c(n,h,j,l)))g={distance:this.origin.distanceTo(n),point:n,face:g,object:a},v.push(g);return v}else return[]}};
THREE.Rectangle=function(){function a(){g=d-b;e=f-c}var b,c,d,f,g,e,h=!0;this.getX=function(){return b};this.getY=function(){return c};this.getWidth=function(){return g};this.getHeight=function(){return e};this.getLeft=function(){return b};this.getTop=function(){return c};this.getRight=function(){return d};this.getBottom=function(){return f};this.set=function(e,g,m,i){h=!1;b=e;c=g;d=m;f=i;a()};this.addPoint=function(e,g){h?(h=!1,b=e,c=g,d=e,f=g):(b=b<e?b:e,c=c<g?c:g,d=d>e?d:e,f=f>g?f:g);a()};this.add3Points=
function(e,g,m,i,n,k){h?(h=!1,b=e<m?e<n?e:n:m<n?m:n,c=g<i?g<k?g:k:i<k?i:k,d=e>m?e>n?e:n:m>n?m:n,f=g>i?g>k?g:k:i>k?i:k):(b=e<m?e<n?e<b?e:b:n<b?n:b:m<n?m<b?m:b:n<b?n:b,c=g<i?g<k?g<c?g:c:k<c?k:c:i<k?i<c?i:c:k<c?k:c,d=e>m?e>n?e>d?e:d:n>d?n:d:m>n?m>d?m:d:n>d?n:d,f=g>i?g>k?g>f?g:f:k>f?k:f:i>k?i>f?i:f:k>f?k:f);a()};this.addRectangle=function(e){h?(h=!1,b=e.getLeft(),c=e.getTop(),d=e.getRight(),f=e.getBottom()):(b=b<e.getLeft()?b:e.getLeft(),c=c<e.getTop()?c:e.getTop(),d=d>e.getRight()?d:e.getRight(),f=f>
e.getBottom()?f:e.getBottom());a()};this.inflate=function(e){b-=e;c-=e;d+=e;f+=e;a()};this.minSelf=function(e){b=b>e.getLeft()?b:e.getLeft();c=c>e.getTop()?c:e.getTop();d=d<e.getRight()?d:e.getRight();f=f<e.getBottom()?f:e.getBottom();a()};this.instersects=function(a){return Math.min(d,a.getRight())-Math.max(b,a.getLeft())>=0&&Math.min(f,a.getBottom())-Math.max(c,a.getTop())>=0};this.empty=function(){h=!0;f=d=c=b=0;a()};this.isEmpty=function(){return h}};THREE.Matrix3=function(){this.m=[]};
THREE.Matrix3.prototype={constructor:THREE.Matrix3,transpose:function(){var a,b=this.m;a=b[1];b[1]=b[3];b[3]=a;a=b[2];b[2]=b[6];b[6]=a;a=b[5];b[5]=b[7];b[7]=a;return this},transposeIntoArray:function(a){var b=this.m;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this}};THREE.Matrix4=function(a,b,c,d,f,g,e,h,j,l,m,i,n,k,p,q){this.set(a||1,b||0,c||0,d||0,f||0,g||1,e||0,h||0,j||0,l||0,m||1,i||0,n||0,k||0,p||0,q||1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={constructor:THREE.Matrix4,set:function(a,b,c,d,f,g,e,h,j,l,m,i,n,k,p,q){this.n11=a;this.n12=b;this.n13=c;this.n14=d;this.n21=f;this.n22=g;this.n23=e;this.n24=h;this.n31=j;this.n32=l;this.n33=m;this.n34=i;this.n41=n;this.n42=k;this.n43=p;this.n44=q;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){this.set(a.n11,a.n12,a.n13,a.n14,a.n21,a.n22,a.n23,a.n24,a.n31,a.n32,a.n33,a.n34,a.n41,a.n42,a.n43,a.n44);return this},lookAt:function(a,
b,c){var d=THREE.Matrix4.__v1,f=THREE.Matrix4.__v2,g=THREE.Matrix4.__v3;g.sub(a,b).normalize();if(g.length()===0)g.z=1;d.cross(c,g).normalize();d.length()===0&&(g.x+=1.0E-4,d.cross(c,g).normalize());f.cross(g,d).normalize();this.n11=d.x;this.n12=f.x;this.n13=g.x;this.n21=d.y;this.n22=f.y;this.n23=g.y;this.n31=d.z;this.n32=f.z;this.n33=g.z;return this},multiplyVector3:function(a){var b=a.x,c=a.y,d=a.z,f=1/(this.n41*b+this.n42*c+this.n43*d+this.n44);a.x=(this.n11*b+this.n12*c+this.n13*d+this.n14)*f;
a.y=(this.n21*b+this.n22*c+this.n23*d+this.n24)*f;a.z=(this.n31*b+this.n32*c+this.n33*d+this.n34)*f;return a},multiplyVector4:function(a){var b=a.x,c=a.y,d=a.z,f=a.w;a.x=this.n11*b+this.n12*c+this.n13*d+this.n14*f;a.y=this.n21*b+this.n22*c+this.n23*d+this.n24*f;a.z=this.n31*b+this.n32*c+this.n33*d+this.n34*f;a.w=this.n41*b+this.n42*c+this.n43*d+this.n44*f;return a},rotateAxis:function(a){var b=a.x,c=a.y,d=a.z;a.x=b*this.n11+c*this.n12+d*this.n13;a.y=b*this.n21+c*this.n22+d*this.n23;a.z=b*this.n31+
c*this.n32+d*this.n33;a.normalize();return a},crossVector:function(a){var b=new THREE.Vector4;b.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;b.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;b.z=this.n31*a.x+this.n32*a.y+this.n33*a.z+this.n34*a.w;b.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return b},multiply:function(a,b){var c=a.n11,d=a.n12,f=a.n13,g=a.n14,e=a.n21,h=a.n22,j=a.n23,l=a.n24,m=a.n31,i=a.n32,n=a.n33,k=a.n34,p=a.n41,q=a.n42,v=a.n43,s=a.n44,O=b.n11,P=b.n12,
y=b.n13,B=b.n14,o=b.n21,t=b.n22,r=b.n23,x=b.n24,E=b.n31,Z=b.n32,$=b.n33,I=b.n34,D=b.n41,J=b.n42,M=b.n43,F=b.n44;this.n11=c*O+d*o+f*E+g*D;this.n12=c*P+d*t+f*Z+g*J;this.n13=c*y+d*r+f*$+g*M;this.n14=c*B+d*x+f*I+g*F;this.n21=e*O+h*o+j*E+l*D;this.n22=e*P+h*t+j*Z+l*J;this.n23=e*y+h*r+j*$+l*M;this.n24=e*B+h*x+j*I+l*F;this.n31=m*O+i*o+n*E+k*D;this.n32=m*P+i*t+n*Z+k*J;this.n33=m*y+i*r+n*$+k*M;this.n34=m*B+i*x+n*I+k*F;this.n41=p*O+q*o+v*E+s*D;this.n42=p*P+q*t+v*Z+s*J;this.n43=p*y+q*r+v*$+s*M;this.n44=p*B+q*
x+v*I+s*F;return this},multiplyToArray:function(a,b,c){this.multiply(a,b);c[0]=this.n11;c[1]=this.n21;c[2]=this.n31;c[3]=this.n41;c[4]=this.n12;c[5]=this.n22;c[6]=this.n32;c[7]=this.n42;c[8]=this.n13;c[9]=this.n23;c[10]=this.n33;c[11]=this.n43;c[12]=this.n14;c[13]=this.n24;c[14]=this.n34;c[15]=this.n44;return this},multiplySelf:function(a){this.multiply(this,a);return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=a;this.n24*=a;this.n31*=
a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=a;this.n42*=a;this.n43*=a;this.n44*=a;return this},determinant:function(){var a=this.n11,b=this.n12,c=this.n13,d=this.n14,f=this.n21,g=this.n22,e=this.n23,h=this.n24,j=this.n31,l=this.n32,m=this.n33,i=this.n34,n=this.n41,k=this.n42,p=this.n43,q=this.n44;return d*e*l*n-c*h*l*n-d*g*m*n+b*h*m*n+c*g*i*n-b*e*i*n-d*e*j*k+c*h*j*k+d*f*m*k-a*h*m*k-c*f*i*k+a*e*i*k+d*g*j*p-b*h*j*p-d*f*l*p+a*h*l*p+b*f*i*p-a*g*i*p-c*g*j*q+b*e*j*q+c*f*l*q-a*e*l*q-b*f*m*q+a*g*m*q},
transpose:function(){var a;a=this.n21;this.n21=this.n12;this.n12=a;a=this.n31;this.n31=this.n13;this.n13=a;a=this.n32;this.n32=this.n23;this.n23=a;a=this.n41;this.n41=this.n14;this.n14=a;a=this.n42;this.n42=this.n24;this.n24=a;a=this.n43;this.n43=this.n34;this.n43=a;return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;
a.n41=this.n41;a.n42=this.n42;a.n43=this.n43;a.n44=this.n44;return a},flatten:function(){this.flat[0]=this.n11;this.flat[1]=this.n21;this.flat[2]=this.n31;this.flat[3]=this.n41;this.flat[4]=this.n12;this.flat[5]=this.n22;this.flat[6]=this.n32;this.flat[7]=this.n42;this.flat[8]=this.n13;this.flat[9]=this.n23;this.flat[10]=this.n33;this.flat[11]=this.n43;this.flat[12]=this.n14;this.flat[13]=this.n24;this.flat[14]=this.n34;this.flat[15]=this.n44;return this.flat},flattenToArray:function(a){a[0]=this.n11;
a[1]=this.n21;a[2]=this.n31;a[3]=this.n41;a[4]=this.n12;a[5]=this.n22;a[6]=this.n32;a[7]=this.n42;a[8]=this.n13;a[9]=this.n23;a[10]=this.n33;a[11]=this.n43;a[12]=this.n14;a[13]=this.n24;a[14]=this.n34;a[15]=this.n44;return a},flattenToArrayOffset:function(a,b){a[b]=this.n11;a[b+1]=this.n21;a[b+2]=this.n31;a[b+3]=this.n41;a[b+4]=this.n12;a[b+5]=this.n22;a[b+6]=this.n32;a[b+7]=this.n42;a[b+8]=this.n13;a[b+9]=this.n23;a[b+10]=this.n33;a[b+11]=this.n43;a[b+12]=this.n14;a[b+13]=this.n24;a[b+14]=this.n34;
a[b+15]=this.n44;return a},setTranslation:function(a,b,c){this.set(1,0,0,a,0,1,0,b,0,0,1,c,0,0,0,1);return this},setScale:function(a,b,c){this.set(a,0,0,0,0,b,0,0,0,0,c,0,0,0,0,1);return this},setRotationX:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(1,0,0,0,0,b,-a,0,0,a,b,0,0,0,0,1);return this},setRotationY:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},setRotationZ:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,-a,0,0,a,b,0,0,
0,0,1,0,0,0,0,1);return this},setRotationAxis:function(a,b){var c=Math.cos(b),d=Math.sin(b),f=1-c,g=a.x,e=a.y,h=a.z,j=f*g,l=f*e;this.set(j*g+c,j*e-d*h,j*h+d*e,0,j*e+d*h,l*e+c,l*h-d*g,0,j*h-d*e,l*h+d*g,f*h*h+c,0,0,0,0,1);return this},setPosition:function(a){this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},getPosition:function(){if(!this.position)this.position=new THREE.Vector3;this.position.set(this.n14,this.n24,this.n34);return this.position},getColumnX:function(){if(!this.columnX)this.columnX=
new THREE.Vector3;this.columnX.set(this.n11,this.n21,this.n31);return this.columnX},getColumnY:function(){if(!this.columnY)this.columnY=new THREE.Vector3;this.columnY.set(this.n12,this.n22,this.n32);return this.columnY},getColumnZ:function(){if(!this.columnZ)this.columnZ=new THREE.Vector3;this.columnZ.set(this.n13,this.n23,this.n33);return this.columnZ},setRotationFromEuler:function(a,b){var c=a.x,d=a.y,f=a.z,g=Math.cos(c),c=Math.sin(c),e=Math.cos(d),d=Math.sin(d),h=Math.cos(f),f=Math.sin(f);switch(b){case "YXZ":var j=
e*h,l=e*f,m=d*h,i=d*f;this.n11=j+i*c;this.n12=m*c-l;this.n13=g*d;this.n21=g*f;this.n22=g*h;this.n23=-c;this.n31=l*c-m;this.n32=i+j*c;this.n33=g*e;break;case "ZXY":j=e*h;l=e*f;m=d*h;i=d*f;this.n11=j-i*c;this.n12=-g*f;this.n13=m+l*c;this.n21=l+m*c;this.n22=g*h;this.n23=i-j*c;this.n31=-g*d;this.n32=c;this.n33=g*e;break;case "ZYX":j=g*h;l=g*f;m=c*h;i=c*f;this.n11=e*h;this.n12=m*d-l;this.n13=j*d+i;this.n21=e*f;this.n22=i*d+j;this.n23=l*d-m;this.n31=-d;this.n32=c*e;this.n33=g*e;break;case "YZX":j=g*e;l=
g*d;m=c*e;i=c*d;this.n11=e*h;this.n12=i-j*f;this.n13=m*f+l;this.n21=f;this.n22=g*h;this.n23=-c*h;this.n31=-d*h;this.n32=l*f+m;this.n33=j-i*f;break;case "XZY":j=g*e;l=g*d;m=c*e;i=c*d;this.n11=e*h;this.n12=-f;this.n13=d*h;this.n21=j*f+i;this.n22=g*h;this.n23=l*f-m;this.n31=m*f-l;this.n32=c*h;this.n33=i*f+j;break;default:j=g*h,l=g*f,m=c*h,i=c*f,this.n11=e*h,this.n12=-e*f,this.n13=d,this.n21=l+m*d,this.n22=j-i*d,this.n23=-c*e,this.n31=i-j*d,this.n32=m+l*d,this.n33=g*e}return this},setRotationFromQuaternion:function(a){var b=
a.x,c=a.y,d=a.z,f=a.w,g=b+b,e=c+c,h=d+d,a=b*g,j=b*e;b*=h;var l=c*e;c*=h;d*=h;g*=f;e*=f;f*=h;this.n11=1-(l+d);this.n12=j-f;this.n13=b+e;this.n21=j+f;this.n22=1-(a+d);this.n23=c-g;this.n31=b-e;this.n32=c+g;this.n33=1-(a+l);return this},scale:function(a){var b=a.x,c=a.y,a=a.z;this.n11*=b;this.n12*=c;this.n13*=a;this.n21*=b;this.n22*=c;this.n23*=a;this.n31*=b;this.n32*=c;this.n33*=a;this.n41*=b;this.n42*=c;this.n43*=a;return this},extractPosition:function(a){this.n14=a.n14;this.n24=a.n24;this.n34=a.n34},
extractRotation:function(a,b){var c=1/b.x,d=1/b.y,f=1/b.z;this.n11=a.n11*c;this.n21=a.n21*c;this.n31=a.n31*c;this.n12=a.n12*d;this.n22=a.n22*d;this.n32=a.n32*d;this.n13=a.n13*f;this.n23=a.n23*f;this.n33=a.n33*f}};
THREE.Matrix4.makeInvert=function(a,b){var c=a.n11,d=a.n12,f=a.n13,g=a.n14,e=a.n21,h=a.n22,j=a.n23,l=a.n24,m=a.n31,i=a.n32,n=a.n33,k=a.n34,p=a.n41,q=a.n42,v=a.n43,s=a.n44;b===void 0&&(b=new THREE.Matrix4);b.n11=j*k*q-l*n*q+l*i*v-h*k*v-j*i*s+h*n*s;b.n12=g*n*q-f*k*q-g*i*v+d*k*v+f*i*s-d*n*s;b.n13=f*l*q-g*j*q+g*h*v-d*l*v-f*h*s+d*j*s;b.n14=g*j*i-f*l*i-g*h*n+d*l*n+f*h*k-d*j*k;b.n21=l*n*p-j*k*p-l*m*v+e*k*v+j*m*s-e*n*s;b.n22=f*k*p-g*n*p+g*m*v-c*k*v-f*m*s+c*n*s;b.n23=g*j*p-f*l*p-g*e*v+c*l*v+f*e*s-c*j*s;b.n24=
f*l*m-g*j*m+g*e*n-c*l*n-f*e*k+c*j*k;b.n31=h*k*p-l*i*p+l*m*q-e*k*q-h*m*s+e*i*s;b.n32=g*i*p-d*k*p-g*m*q+c*k*q+d*m*s-c*i*s;b.n33=f*l*p-g*h*p+g*e*q-c*l*q-d*e*s+c*h*s;b.n34=g*h*m-d*l*m-g*e*i+c*l*i+d*e*k-c*h*k;b.n41=j*i*p-h*n*p-j*m*q+e*n*q+h*m*v-e*i*v;b.n42=d*n*p-f*i*p+f*m*q-c*n*q-d*m*v+c*i*v;b.n43=f*h*p-d*j*p-f*e*q+c*j*q+d*e*v-c*h*v;b.n44=d*j*m-f*h*m+f*e*i-c*j*i-d*e*n+c*h*n;b.multiplyScalar(1/a.determinant());return b};
THREE.Matrix4.makeInvert3x3=function(a){var b=a.m33,c=b.m,d=a.n33*a.n22-a.n32*a.n23,f=-a.n33*a.n21+a.n31*a.n23,g=a.n32*a.n21-a.n31*a.n22,e=-a.n33*a.n12+a.n32*a.n13,h=a.n33*a.n11-a.n31*a.n13,j=-a.n32*a.n11+a.n31*a.n12,l=a.n23*a.n12-a.n22*a.n13,m=-a.n23*a.n11+a.n21*a.n13,i=a.n22*a.n11-a.n21*a.n12,a=a.n11*d+a.n21*e+a.n31*l;a==0&&console.error("THREE.Matrix4.makeInvert3x3: Matrix not invertible.");a=1/a;c[0]=a*d;c[1]=a*f;c[2]=a*g;c[3]=a*e;c[4]=a*h;c[5]=a*j;c[6]=a*l;c[7]=a*m;c[8]=a*i;return b};
THREE.Matrix4.makeFrustum=function(a,b,c,d,f,g){var e;e=new THREE.Matrix4;e.n11=2*f/(b-a);e.n12=0;e.n13=(b+a)/(b-a);e.n14=0;e.n21=0;e.n22=2*f/(d-c);e.n23=(d+c)/(d-c);e.n24=0;e.n31=0;e.n32=0;e.n33=-(g+f)/(g-f);e.n34=-2*g*f/(g-f);e.n41=0;e.n42=0;e.n43=-1;e.n44=0;return e};THREE.Matrix4.makePerspective=function(a,b,c,d){var f,a=c*Math.tan(a*Math.PI/360);f=-a;return THREE.Matrix4.makeFrustum(f*b,a*b,f,a,c,d)};
THREE.Matrix4.makeOrtho=function(a,b,c,d,f,g){var e,h,j,l;e=new THREE.Matrix4;h=b-a;j=c-d;l=g-f;e.n11=2/h;e.n12=0;e.n13=0;e.n14=-((b+a)/h);e.n21=0;e.n22=2/j;e.n23=0;e.n24=-((c+d)/j);e.n31=0;e.n32=0;e.n33=-2/l;e.n34=-((g+f)/l);e.n41=0;e.n42=0;e.n43=0;e.n44=1;return e};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;
THREE.Object3D=function(){this.parent=void 0;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.eulerOrder="XYZ";this.scale=new THREE.Vector3(1,1,1);this.flipSided=this.doubleSided=this.dynamic=!1;this.renderDepth=null;this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixWorldNeedsUpdate=this.matrixAutoUpdate=!0;this.quaternion=new THREE.Quaternion;
this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=!0;this.receiveShadow=this.castShadow=!1;this._vector=new THREE.Vector3;this.name=""};
THREE.Object3D.prototype={constructor:THREE.Object3D,translate:function(a,b){this.matrix.rotateAxis(b);this.position.addSelf(b.multiplyScalar(a))},translateX:function(a){this.translate(a,this._vector.set(1,0,0))},translateY:function(a){this.translate(a,this._vector.set(0,1,0))},translateZ:function(a){this.translate(a,this._vector.set(0,0,1))},lookAt:function(a){this.matrix.lookAt(a,this.position,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)},addChild:function(a){if(this.children.indexOf(a)===
-1){a.parent!==void 0&&a.parent.removeChild(a);a.parent=this;this.children.push(a);for(var b=this;b.parent!==void 0;)b=b.parent;b!==void 0&&b instanceof THREE.Scene&&b.addChildRecurse(a)}},removeChild:function(a){var b=this.children.indexOf(a);if(b!==-1)a.parent=void 0,this.children.splice(b,1)},getChildByName:function(a,b){var c,d,f;c=0;for(d=this.children.length;c<d;c++){f=this.children[c];if(f.name===a)return f;if(b&&(f=f.getChildByName(a,b),f!==void 0))return f}},updateMatrix:function(){this.matrix.setPosition(this.position);
this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation,this.eulerOrder);if(this.scale.x!==1||this.scale.y!==1||this.scale.z!==1)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z));this.matrixWorldNeedsUpdate=!0},update:function(a,b,c){this.matrixAutoUpdate&&this.updateMatrix();if(this.matrixWorldNeedsUpdate||b)a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),
this.matrixRotationWorld.extractRotation(this.matrixWorld,this.scale),this.matrixWorldNeedsUpdate=!1,b=!0;for(var a=0,d=this.children.length;a<d;a++)this.children[a].update(this.matrixWorld,b,c)}};THREE.Quaternion=function(a,b,c,d){this.set(a||0,b||0,c||0,d!==void 0?d:1)};
THREE.Quaternion.prototype={constructor:THREE.Quaternion,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w;return this},setFromEuler:function(a){var b=0.5*Math.PI/360,c=a.x*b,d=a.y*b,f=a.z*b,a=Math.cos(d),d=Math.sin(d),b=Math.cos(-f),f=Math.sin(-f),g=Math.cos(c),c=Math.sin(c),e=a*b,h=d*f;this.w=e*g-h*c;this.x=e*c+h*g;this.y=d*b*g+a*f*c;this.z=a*f*g-d*b*c;return this},setFromAxisAngle:function(a,b){var c=b/2,d=Math.sin(c);
this.x=a.x*d;this.y=a.y*d;this.z=a.z*d;this.w=Math.cos(c);return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);a==0?this.w=this.z=this.y=this.x=0:(a=1/a,this.x*=a,this.y*=a,this.z*=
a,this.w*=a);return this},multiplySelf:function(a){var b=this.x,c=this.y,d=this.z,f=this.w,g=a.x,e=a.y,h=a.z,a=a.w;this.x=b*a+f*g+c*h-d*e;this.y=c*a+f*e+d*g-b*h;this.z=d*a+f*h+b*e-c*g;this.w=f*a-b*g-c*e-d*h;return this},multiply:function(a,b){this.x=a.x*b.w+a.y*b.z-a.z*b.y+a.w*b.x;this.y=-a.x*b.z+a.y*b.w+a.z*b.x+a.w*b.y;this.z=a.x*b.y-a.y*b.x+a.z*b.w+a.w*b.z;this.w=-a.x*b.x-a.y*b.y-a.z*b.z+a.w*b.w;return this},multiplyVector3:function(a,b){b||(b=a);var c=a.x,d=a.y,f=a.z,g=this.x,e=this.y,h=this.z,
j=this.w,l=j*c+e*f-h*d,m=j*d+h*c-g*f,i=j*f+g*d-e*c,c=-g*c-e*d-h*f;b.x=l*j+c*-g+m*-h-i*-e;b.y=m*j+c*-e+i*-g-l*-h;b.z=i*j+c*-h+l*-e-m*-g;return b}};
THREE.Quaternion.slerp=function(a,b,c,d){var f=a.w*b.w+a.x*b.x+a.y*b.y+a.z*b.z;if(Math.abs(f)>=1)return c.w=a.w,c.x=a.x,c.y=a.y,c.z=a.z,c;var g=Math.acos(f),e=Math.sqrt(1-f*f);if(Math.abs(e)<0.001)return c.w=0.5*(a.w+b.w),c.x=0.5*(a.x+b.x),c.y=0.5*(a.y+b.y),c.z=0.5*(a.z+b.z),c;f=Math.sin((1-d)*g)/e;d=Math.sin(d*g)/e;c.w=a.w*f+b.w*d;c.x=a.x*f+b.x*d;c.y=a.y*f+b.y*d;c.z=a.z*f+b.z*d;return c};THREE.Vertex=function(a){this.position=a||new THREE.Vector3};
THREE.Face3=function(a,b,c,d,f,g){this.a=a;this.b=b;this.c=c;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=d instanceof Array?d:[];this.color=f instanceof THREE.Color?f:new THREE.Color;this.vertexColors=f instanceof Array?f:[];this.vertexTangents=[];this.materials=g instanceof Array?g:[g];this.centroid=new THREE.Vector3};
THREE.Face4=function(a,b,c,d,f,g,e){this.a=a;this.b=b;this.c=c;this.d=d;this.normal=f instanceof THREE.Vector3?f:new THREE.Vector3;this.vertexNormals=f instanceof Array?f:[];this.color=g instanceof THREE.Color?g:new THREE.Color;this.vertexColors=g instanceof Array?g:[];this.vertexTangents=[];this.materials=e instanceof Array?e:[e];this.centroid=new THREE.Vector3};THREE.UV=function(a,b){this.set(a||0,b||0)};
THREE.UV.prototype={constructor:THREE.UV,set:function(a,b){this.u=a;this.v=b;return this},copy:function(a){this.set(a.u,a.v);return this}};THREE.Geometry=function(){this.id="Geometry"+THREE.GeometryIdCounter++;this.vertices=[];this.colors=[];this.faces=[];this.edges=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.dynamic=this.hasTangents=!1};
THREE.Geometry.prototype={constructor:THREE.Geometry,computeCentroids:function(){var a,b,c;a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],c.centroid.set(0,0,0),c instanceof THREE.Face3?(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),c.centroid.divideScalar(3)):c instanceof THREE.Face4&&(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),
c.centroid.addSelf(this.vertices[c.d].position),c.centroid.divideScalar(4))},computeFaceNormals:function(a){var b,c,d,f,g,e,h=new THREE.Vector3,j=new THREE.Vector3;d=0;for(f=this.faces.length;d<f;d++){g=this.faces[d];if(a&&g.vertexNormals.length){h.set(0,0,0);b=0;for(c=g.vertexNormals.length;b<c;b++)h.addSelf(g.vertexNormals[b]);h.divideScalar(3)}else b=this.vertices[g.a],c=this.vertices[g.b],e=this.vertices[g.c],h.sub(e.position,c.position),j.sub(b.position,c.position),h.crossSelf(j);h.isZero()||
h.normalize();g.normal.copy(h)}},computeVertexNormals:function(){var a,b,c,d;if(this.__tmpVertices==void 0){d=this.__tmpVertices=Array(this.vertices.length);a=0;for(b=this.vertices.length;a<b;a++)d[a]=new THREE.Vector3;a=0;for(b=this.faces.length;a<b;a++)if(c=this.faces[a],c instanceof THREE.Face3)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(c instanceof THREE.Face4)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}else{d=
this.__tmpVertices;a=0;for(b=this.vertices.length;a<b;a++)d[a].set(0,0,0)}a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(d[c.a].addSelf(c.normal),d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal)):c instanceof THREE.Face4&&(d[c.a].addSelf(c.normal),d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal),d[c.d].addSelf(c.normal));a=0;for(b=this.vertices.length;a<b;a++)d[a].normalize();a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(c.vertexNormals[0].copy(d[c.a]),
c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c])):c instanceof THREE.Face4&&(c.vertexNormals[0].copy(d[c.a]),c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c]),c.vertexNormals[3].copy(d[c.d]))},computeTangents:function(){function a(a,b,c,d,f,g,r){h=a.vertices[b].position;j=a.vertices[c].position;l=a.vertices[d].position;m=e[f];i=e[g];n=e[r];k=j.x-h.x;p=l.x-h.x;q=j.y-h.y;v=l.y-h.y;s=j.z-h.z;O=l.z-h.z;P=i.u-m.u;y=n.u-m.u;B=i.v-m.v;o=n.v-m.v;t=1/(P*o-y*B);Z.set((o*k-B*p)*
t,(o*q-B*v)*t,(o*s-B*O)*t);$.set((P*p-y*k)*t,(P*v-y*q)*t,(P*O-y*s)*t);x[b].addSelf(Z);x[c].addSelf(Z);x[d].addSelf(Z);E[b].addSelf($);E[c].addSelf($);E[d].addSelf($)}var b,c,d,f,g,e,h,j,l,m,i,n,k,p,q,v,s,O,P,y,B,o,t,r,x=[],E=[],Z=new THREE.Vector3,$=new THREE.Vector3,I=new THREE.Vector3,D=new THREE.Vector3,J=new THREE.Vector3;b=0;for(c=this.vertices.length;b<c;b++)x[b]=new THREE.Vector3,E[b]=new THREE.Vector3;b=0;for(c=this.faces.length;b<c;b++)g=this.faces[b],e=this.faceVertexUvs[0][b],g instanceof
THREE.Face3?a(this,g.a,g.b,g.c,0,1,2):g instanceof THREE.Face4&&(a(this,g.a,g.b,g.c,0,1,2),a(this,g.a,g.b,g.d,0,1,3));var M=["a","b","c","d"];b=0;for(c=this.faces.length;b<c;b++){g=this.faces[b];for(d=0;d<g.vertexNormals.length;d++)J.copy(g.vertexNormals[d]),f=g[M[d]],r=x[f],I.copy(r),I.subSelf(J.multiplyScalar(J.dot(r))).normalize(),D.cross(g.vertexNormals[d],r),f=D.dot(E[f]),f=f<0?-1:1,g.vertexTangents[d]=new THREE.Vector4(I.x,I.y,I.z,f)}this.hasTangents=!0},computeBoundingBox:function(){var a;
if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,this.vertices[0].position.y],z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var b=1,c=this.vertices.length;b<c;b++){a=this.vertices[b];if(a.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=a.position.x;else if(a.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=a.position.x;if(a.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=a.position.y;
else if(a.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=a.position.y;if(a.position.z<this.boundingBox.z[0])this.boundingBox.z[0]=a.position.z;else if(a.position.z>this.boundingBox.z[1])this.boundingBox.z[1]=a.position.z}}},computeBoundingSphere:function(){for(var a=0,b=0,c=this.vertices.length;b<c;b++)a=Math.max(a,this.vertices[b].position.length());this.boundingSphere={radius:a}},computeEdgeFaces:function(){function a(a,b){return Math.min(a,b)+"_"+Math.max(a,b)}function b(a,b,c){a[b]===
void 0?(a[b]={set:{},array:[]},a[b].set[c]=1,a[b].array.push(c)):a[b].set[c]===void 0&&(a[b].set[c]=1,a[b].array.push(c))}var c,d,f,g,e,h={};c=0;for(d=this.faces.length;c<d;c++)e=this.faces[c],e instanceof THREE.Face3?(f=a(e.a,e.b),b(h,f,c),f=a(e.b,e.c),b(h,f,c),f=a(e.a,e.c),b(h,f,c)):e instanceof THREE.Face4&&(f=a(e.b,e.d),b(h,f,c),f=a(e.a,e.b),b(h,f,c),f=a(e.a,e.d),b(h,f,c),f=a(e.b,e.c),b(h,f,c),f=a(e.c,e.d),b(h,f,c));c=0;for(d=this.edges.length;c<d;c++){e=this.edges[c];f=e.vertexIndices[0];g=e.vertexIndices[1];
e.faceIndices=h[a(f,g)].array;for(f=0;f<e.faceIndices.length;f++)g=e.faceIndices[f],e.faces.push(this.faces[g])}}};THREE.GeometryIdCounter=0;THREE.Camera=function(a,b,c,d,f){THREE.Object3D.call(this);this.fov=a||50;this.aspect=b||1;this.near=c||0.1;this.far=d||2E3;this.target=f||new THREE.Object3D;this.useTarget=!0;this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=null;this.updateProjectionMatrix()};THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;
THREE.Camera.prototype.supr=THREE.Object3D.prototype;THREE.Camera.prototype.translate=function(a,b){this.matrix.rotateAxis(b);b.multiplyScalar(a);this.position.addSelf(b);this.target.position.addSelf(b)};
THREE.Camera.prototype.updateProjectionMatrix=function(){if(this.fullWidth){var a=this.fullWidth/this.fullHeight,b=Math.tan(this.fov*Math.PI/360)*this.near,c=-b,d=a*c,a=Math.abs(a*b-d),c=Math.abs(b-c);this.projectionMatrix=THREE.Matrix4.makeFrustum(d+this.x*a/this.fullWidth,d+(this.x+this.width)*a/this.fullWidth,b-(this.y+this.height)*c/this.fullHeight,b-this.y*c/this.fullHeight,this.near,this.far)}else this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,this.far)};
THREE.Camera.prototype.setViewOffset=function(a,b,c,d,f,g){this.fullWidth=a;this.fullHeight=b;this.x=c;this.y=d;this.width=f;this.height=g;this.updateProjectionMatrix()};
THREE.Camera.prototype.update=function(a,b,c){if(this.useTarget)this.matrix.lookAt(this.position,this.target.position,this.up),this.matrix.setPosition(this.position),a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse),b=!0;else if(this.matrixAutoUpdate&&this.updateMatrix(),b||this.matrixWorldNeedsUpdate)a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=
!1,b=!0,THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse);for(a=0;a<this.children.length;a++)this.children[a].update(this.matrixWorld,b,c)};THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;
THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.DirectionalLight=function(a,b,c,d){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.intensity=b||1;this.distance=c||0;this.castShadow=d!==void 0?d:!1};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3;this.intensity=b||1;this.distance=c||0};
THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;
THREE.Material=function(a){this.id=THREE.MaterialCount++;a=a||{};this.opacity=a.opacity!==void 0?a.opacity:1;this.transparent=a.transparent!==void 0?a.transparent:!1;this.blending=a.blending!==void 0?a.blending:THREE.NormalBlending;this.depthTest=a.depthTest!==void 0?a.depthTest:!0;this.polygonOffset=a.polygonOffset!==void 0?a.polygonOffset:!1;this.polygonOffsetFactor=a.polygonOffsetFactor!==void 0?a.polygonOffsetFactor:0;this.polygonOffsetUnits=a.polygonOffsetUnits!==void 0?a.polygonOffsetUnits:
0;this.alphaTest=a.alphaTest!==void 0?a.alphaTest:0};THREE.MaterialCount=0;THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.MultiplyBlending=3;THREE.AdditiveAlphaBlending=4;THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};THREE.LatitudeRefractionMapping=function(){};
THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};THREE.LineBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.linewidth=a.linewidth!==void 0?a.linewidth:1;this.linecap=a.linecap!==void 0?a.linecap:"round";this.linejoin=a.linejoin!==void 0?a.linejoin:"round";this.vertexColors=a.vertexColors?a.vertexColors:!1};
THREE.LineBasicMaterial.prototype=new THREE.Material;THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.shading=a.shading!==
void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:!1};
THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.shading=a.shading!==
void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:!1};
THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=a.ambient!==void 0?new THREE.Color(a.ambient):new THREE.Color(328965);this.specular=a.specular!==void 0?new THREE.Color(a.specular):new THREE.Color(1118481);this.shininess=a.shininess!==void 0?a.shininess:30;this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;
this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==
void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:!1};THREE.MeshPhongMaterial.prototype=new THREE.Material;THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;
THREE.MeshDepthMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1};THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;
THREE.MeshNormalMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading?a.shading:THREE.FlatShading;this.wireframe=a.wireframe?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth?a.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshFaceMaterial=function(){};
THREE.ParticleBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.size=a.size!==void 0?a.size:1;this.sizeAttenuation=a.sizeAttenuation!==void 0?a.sizeAttenuation:!0;this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1};THREE.ParticleBasicMaterial.prototype=new THREE.Material;THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.ParticleCanvasMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.program=a.program!==void 0?a.program:function(){}};THREE.ParticleCanvasMaterial.prototype=new THREE.Material;THREE.ParticleCanvasMaterial.prototype.constructor=THREE.ParticleCanvasMaterial;
THREE.Texture=function(a,b,c,d,f,g){this.id=THREE.TextureCount++;this.image=a;this.mapping=b!==void 0?b:new THREE.UVMapping;this.wrapS=c!==void 0?c:THREE.ClampToEdgeWrapping;this.wrapT=d!==void 0?d:THREE.ClampToEdgeWrapping;this.magFilter=f!==void 0?f:THREE.LinearFilter;this.minFilter=g!==void 0?g:THREE.LinearMipMapLinearFilter;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.needsUpdate=!1};
THREE.Texture.prototype={constructor:THREE.Texture,clone:function(){var a=new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter);a.offset.copy(this.offset);a.repeat.copy(this.repeat);return a}};THREE.TextureCount=0;THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;
THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;THREE.ShortType=11;THREE.UnsignedShortType=12;THREE.IntType=13;THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;THREE.Particle=function(a){THREE.Object3D.call(this);this.materials=a instanceof Array?a:[a]};THREE.Particle.prototype=new THREE.Object3D;
THREE.Particle.prototype.constructor=THREE.Particle;THREE.Line=function(a,b,c){THREE.Object3D.call(this);this.geometry=a;this.materials=b instanceof Array?b:[b];this.type=c!=void 0?c:THREE.LineStrip};THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.materials=b&&b.length?b:[b];this.overdraw=!1;if(this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere(),this.boundRadius=a.boundingSphere.radius,this.geometry.morphTargets.length)){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var c=0;c<this.geometry.morphTargets.length;c++)this.morphTargetInfluences.push(0),this.morphTargetDictionary[this.geometry.morphTargets[c].name]=
c}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;THREE.Mesh.prototype.getMorphTargetIndexByName=function(a){if(this.morphTargetDictionary[a]!==void 0)return this.morphTargetDictionary[a];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+a+" does not exist. Returning 0.");return 0};
THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4;this.hasNoneBoneChildren=!1};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,b,c){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixWorldNeedsUpdate)a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,b=!0;var d,f=this.children.length;if(this.hasNoneBoneChildren){this.matrixWorld.multiply(this.skin.matrixWorld,this.skinMatrix);for(d=0;d<f;d++)a=this.children[d],a instanceof THREE.Bone?a.update(this.skinMatrix,b,c):a.update(this.matrixWorld,!0,c)}else for(d=0;d<f;d++)this.children[d].update(this.skinMatrix,
b,c)};THREE.Bone.prototype.addChild=function(a){if(this.children.indexOf(a)===-1&&(a.parent!==void 0&&a.parent.removeChild(a),a.parent=this,this.children.push(a),!(a instanceof THREE.Bone)))this.hasNoneBoneChildren=!0};THREE.Scene=function(){THREE.Object3D.call(this);this.matrixAutoUpdate=!1;this.collisions=this.overrideMaterial=this.fog=null;this.objects=[];this.lights=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;
THREE.Scene.prototype.supr=THREE.Object3D.prototype;THREE.Scene.prototype.addChild=function(a){this.supr.addChild.call(this,a);this.addChildRecurse(a)};THREE.Scene.prototype.addChildRecurse=function(a){if(a instanceof THREE.Light)this.lights.indexOf(a)===-1&&this.lights.push(a);else if(!(a instanceof THREE.Camera||a instanceof THREE.Bone)&&this.objects.indexOf(a)===-1)this.objects.push(a),this.__objectsAdded.push(a);for(var b=0;b<a.children.length;b++)this.addChildRecurse(a.children[b])};
THREE.Scene.prototype.removeChild=function(a){this.supr.removeChild.call(this,a);this.removeChildRecurse(a)};THREE.Scene.prototype.removeChildRecurse=function(a){if(a instanceof THREE.Light){var b=this.lights.indexOf(a);b!==-1&&this.lights.splice(b,1)}else a instanceof THREE.Camera||(b=this.objects.indexOf(a),b!==-1&&(this.objects.splice(b,1),this.__objectsRemoved.push(a)));for(b=0;b<a.children.length;b++)this.removeChildRecurse(a.children[b])};THREE.Scene.prototype.addObject=THREE.Scene.prototype.addChild;
THREE.Scene.prototype.removeObject=THREE.Scene.prototype.removeChild;THREE.Scene.prototype.addLight=THREE.Scene.prototype.addChild;THREE.Scene.prototype.removeLight=THREE.Scene.prototype.removeChild;
THREE.Projector=function(){function a(){var a=j[h]=j[h]||new THREE.RenderableVertex;h++;return a}function b(a,b){return b.z-a.z}function c(a,b){var c=0,d=1,e=a.z+a.w,f=b.z+b.w,g=-a.z+a.w,h=-b.z+b.w;return e>=0&&f>=0&&g>=0&&h>=0?!0:e<0&&f<0||g<0&&h<0?!1:(e<0?c=Math.max(c,e/(e-f)):f<0&&(d=Math.min(d,e/(e-f))),g<0?c=Math.max(c,g/(g-h)):h<0&&(d=Math.min(d,g/(g-h))),d<c?!1:(a.lerpSelf(b,c),b.lerpSelf(a,1-d),!0))}var d,f,g=[],e,h,j=[],l,m,i=[],n,k=[],p,q,v=[],s,O,P=[],y=new THREE.Vector4,B=new THREE.Vector4,
o=new THREE.Matrix4,t=new THREE.Matrix4,r=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],x=new THREE.Vector4,E=new THREE.Vector4;this.projectVector=function(a,b){o.multiply(b.projectionMatrix,b.matrixWorldInverse);o.multiplyVector3(a);return a};this.unprojectVector=function(a,b){o.multiply(b.matrixWorld,THREE.Matrix4.makeInvert(b.projectionMatrix));o.multiplyVector3(a);return a};this.projectObjects=function(a,c,e){var c=[],h,k,l;f=0;k=
a.objects;a=0;for(h=k.length;a<h;a++){l=k[a];var i;if(!(i=!l.visible))if(i=l instanceof THREE.Mesh){a:{i=void 0;for(var j=l.matrixWorld,n=-l.geometry.boundingSphere.radius*Math.max(l.scale.x,Math.max(l.scale.y,l.scale.z)),m=0;m<6;m++)if(i=r[m].x*j.n14+r[m].y*j.n24+r[m].z*j.n34+r[m].w,i<=n){i=!1;break a}i=!0}i=!i}if(!i)i=g[f]=g[f]||new THREE.RenderableObject,f++,d=i,y.copy(l.position),o.multiplyVector3(y),d.object=l,d.z=y.z,c.push(d)}e&&c.sort(b);return c};this.projectScene=function(d,f,g){var D=[],
J=f.near,M=f.far,F,K,G,Q,w,N,L,y,C,u,A,H,S,la,V,ca,W;O=q=n=m=0;f.matrixAutoUpdate&&f.update(void 0,!0);d.update(void 0,!1,f);o.multiply(f.projectionMatrix,f.matrixWorldInverse);r[0].set(o.n41-o.n11,o.n42-o.n12,o.n43-o.n13,o.n44-o.n14);r[1].set(o.n41+o.n11,o.n42+o.n12,o.n43+o.n13,o.n44+o.n14);r[2].set(o.n41+o.n21,o.n42+o.n22,o.n43+o.n23,o.n44+o.n24);r[3].set(o.n41-o.n21,o.n42-o.n22,o.n43-o.n23,o.n44-o.n24);r[4].set(o.n41-o.n31,o.n42-o.n32,o.n43-o.n33,o.n44-o.n34);r[5].set(o.n41+o.n31,o.n42+o.n32,o.n43+
o.n33,o.n44+o.n34);for(F=0;F<6;F++)C=r[F],C.divideScalar(Math.sqrt(C.x*C.x+C.y*C.y+C.z*C.z));C=this.projectObjects(d,f,!0);d=0;for(F=C.length;d<F;d++)if(u=C[d].object,u.visible)if(A=u.matrixWorld,H=u.matrixRotationWorld,S=u.materials,la=u.overdraw,h=0,u instanceof THREE.Mesh){V=u.geometry;Q=V.vertices;ca=V.faces;V=V.faceVertexUvs;K=0;for(G=Q.length;K<G;K++)e=a(),e.positionWorld.copy(Q[K].position),A.multiplyVector3(e.positionWorld),e.positionScreen.copy(e.positionWorld),o.multiplyVector4(e.positionScreen),
e.positionScreen.x/=e.positionScreen.w,e.positionScreen.y/=e.positionScreen.w,e.visible=e.positionScreen.z>J&&e.positionScreen.z<M;Q=0;for(K=ca.length;Q<K;Q++){G=ca[Q];if(G instanceof THREE.Face3)if(w=j[G.a],N=j[G.b],L=j[G.c],w.visible&&N.visible&&L.visible&&(u.doubleSided||u.flipSided!=(L.positionScreen.x-w.positionScreen.x)*(N.positionScreen.y-w.positionScreen.y)-(L.positionScreen.y-w.positionScreen.y)*(N.positionScreen.x-w.positionScreen.x)<0))y=i[m]=i[m]||new THREE.RenderableFace3,m++,l=y,l.v1.copy(w),
l.v2.copy(N),l.v3.copy(L);else continue;else if(G instanceof THREE.Face4)if(w=j[G.a],N=j[G.b],L=j[G.c],y=j[G.d],w.visible&&N.visible&&L.visible&&y.visible&&(u.doubleSided||u.flipSided!=((y.positionScreen.x-w.positionScreen.x)*(N.positionScreen.y-w.positionScreen.y)-(y.positionScreen.y-w.positionScreen.y)*(N.positionScreen.x-w.positionScreen.x)<0||(N.positionScreen.x-L.positionScreen.x)*(y.positionScreen.y-L.positionScreen.y)-(N.positionScreen.y-L.positionScreen.y)*(y.positionScreen.x-L.positionScreen.x)<
0)))W=k[n]=k[n]||new THREE.RenderableFace4,n++,l=W,l.v1.copy(w),l.v2.copy(N),l.v3.copy(L),l.v4.copy(y);else continue;l.normalWorld.copy(G.normal);H.multiplyVector3(l.normalWorld);l.centroidWorld.copy(G.centroid);A.multiplyVector3(l.centroidWorld);l.centroidScreen.copy(l.centroidWorld);o.multiplyVector3(l.centroidScreen);L=G.vertexNormals;w=0;for(N=L.length;w<N;w++)y=l.vertexNormalsWorld[w],y.copy(L[w]),H.multiplyVector3(y);w=0;for(N=V.length;w<N;w++)if(W=V[w][Q]){L=0;for(y=W.length;L<y;L++)l.uvs[w][L]=
W[L]}l.meshMaterials=S;l.faceMaterials=G.materials;l.overdraw=la;l.z=l.centroidScreen.z;D.push(l)}}else if(u instanceof THREE.Line){t.multiply(o,A);Q=u.geometry.vertices;w=a();w.positionScreen.copy(Q[0].position);t.multiplyVector4(w.positionScreen);K=1;for(G=Q.length;K<G;K++)if(w=a(),w.positionScreen.copy(Q[K].position),t.multiplyVector4(w.positionScreen),N=j[h-2],x.copy(w.positionScreen),E.copy(N.positionScreen),c(x,E))x.multiplyScalar(1/x.w),E.multiplyScalar(1/E.w),A=v[q]=v[q]||new THREE.RenderableLine,
q++,p=A,p.v1.positionScreen.copy(x),p.v2.positionScreen.copy(E),p.z=Math.max(x.z,E.z),p.materials=u.materials,D.push(p)}else if(u instanceof THREE.Particle&&(B.set(u.matrixWorld.n14,u.matrixWorld.n24,u.matrixWorld.n34,1),o.multiplyVector4(B),B.z/=B.w,B.z>0&&B.z<1))A=P[O]=P[O]||new THREE.RenderableParticle,O++,s=A,s.x=B.x/B.w,s.y=B.y/B.w,s.z=B.z,s.rotation=u.rotation.z,s.scale.x=u.scale.x*Math.abs(s.x-(B.x+f.projectionMatrix.n11)/(B.w+f.projectionMatrix.n14)),s.scale.y=u.scale.y*Math.abs(s.y-(B.y+
f.projectionMatrix.n22)/(B.w+f.projectionMatrix.n24)),s.materials=u.materials,D.push(s);g&&D.sort(b);return D}};
THREE.CanvasRenderer=function(a){function b(a){if(v!=a)k.globalAlpha=v=a}function c(a){if(s!=a){switch(a){case THREE.NormalBlending:k.globalCompositeOperation="source-over";break;case THREE.AdditiveBlending:k.globalCompositeOperation="lighter";break;case THREE.SubtractiveBlending:k.globalCompositeOperation="darker"}s=a}}function d(a){if(O!=a)k.strokeStyle=O=a}function f(a){if(P!=a)k.fillStyle=P=a}var g=this,e=null,h=new THREE.Projector,a=a||{},j=a.canvas!==void 0?a.canvas:document.createElement("canvas"),
l,m,i,n,k=j.getContext("2d"),p=new THREE.Color(0),q=0,v=1,s=0,O=null,P=null,y=null,B=null,o=null,t,r,x,E,Z=new THREE.RenderableVertex,$=new THREE.RenderableVertex,I,D,J,M,F,K,G,Q,w,N,L,pa,C=new THREE.Color(0),u=new THREE.Color(0),A=new THREE.Color(0),H=new THREE.Color(0),S=new THREE.Color(0),la=[],V,ca,W,aa,Da,Ea,Fa,Ga,Ha,Ia,ja=new THREE.Rectangle,X=new THREE.Rectangle,U=new THREE.Rectangle,za=!1,ba=new THREE.Color,Y=new THREE.Color,ta=new THREE.Color,ua=new THREE.Color,R=new THREE.Vector3,qa,ra,
Aa,da,sa,va,a=16;qa=document.createElement("canvas");qa.width=qa.height=2;ra=qa.getContext("2d");ra.fillStyle="rgba(0,0,0,1)";ra.fillRect(0,0,2,2);Aa=ra.getImageData(0,0,2,2);da=Aa.data;sa=document.createElement("canvas");sa.width=sa.height=a;va=sa.getContext("2d");va.translate(-a/2,-a/2);va.scale(a,a);a--;this.domElement=j;this.sortElements=this.sortObjects=this.autoClear=!0;this.data={vertices:0,faces:0};this.setSize=function(a,b){l=a;m=b;i=Math.floor(l/2);n=Math.floor(m/2);j.width=l;j.height=m;
ja.set(-i,-n,i,n);X.set(-i,-n,i,n);v=1;s=0;o=B=y=P=O=null};this.setClearColor=function(a,b){p.copy(a);q=b;X.set(-i,-n,i,n)};this.setClearColorHex=function(a,b){p.setHex(a);q=b;X.set(-i,-n,i,n)};this.clear=function(){k.setTransform(1,0,0,-1,i,n);X.isEmpty()||(X.minSelf(ja),X.inflate(2),q<1&&k.clearRect(Math.floor(X.getX()),Math.floor(X.getY()),Math.floor(X.getWidth()),Math.floor(X.getHeight())),q>0&&(c(THREE.NormalBlending),b(1),f("rgba("+Math.floor(p.r*255)+","+Math.floor(p.g*255)+","+Math.floor(p.b*
255)+","+q+")"),k.fillRect(Math.floor(X.getX()),Math.floor(X.getY()),Math.floor(X.getWidth()),Math.floor(X.getHeight()))),X.empty())};this.render=function(a,l){function j(a){var b,c,d,f=a.lights;Y.setRGB(0,0,0);ta.setRGB(0,0,0);ua.setRGB(0,0,0);a=0;for(b=f.length;a<b;a++)c=f[a],d=c.color,c instanceof THREE.AmbientLight?(Y.r+=d.r,Y.g+=d.g,Y.b+=d.b):c instanceof THREE.DirectionalLight?(ta.r+=d.r,ta.g+=d.g,ta.b+=d.b):c instanceof THREE.PointLight&&(ua.r+=d.r,ua.g+=d.g,ua.b+=d.b)}function m(a,b,c,d){var f,
e,g,h,l=a.lights,a=0;for(f=l.length;a<f;a++)e=l[a],g=e.color,e instanceof THREE.DirectionalLight?(h=c.dot(e.position),h<=0||(h*=e.intensity,d.r+=g.r*h,d.g+=g.g*h,d.b+=g.b*h)):e instanceof THREE.PointLight&&(h=c.dot(R.sub(e.position,b).normalize()),h<=0||(h*=e.distance==0?1:1-Math.min(b.distanceTo(e.position)/e.distance,1),h!=0&&(h*=e.intensity,d.r+=g.r*h,d.g+=g.g*h,d.b+=g.b*h)))}function p(a,e,g){b(g.opacity);c(g.blending);var h,l,m,j,Ba,o;if(g instanceof THREE.ParticleBasicMaterial){if(g.map)j=g.map.image,
Ba=j.width>>1,o=j.height>>1,g=e.scale.x*i,m=e.scale.y*n,h=g*Ba,l=m*o,U.set(a.x-h,a.y-l,a.x+h,a.y+l),ja.instersects(U)&&(k.save(),k.translate(a.x,a.y),k.rotate(-e.rotation),k.scale(g,-m),k.translate(-Ba,-o),k.drawImage(j,0,0),k.restore())}else g instanceof THREE.ParticleCanvasMaterial&&(h=e.scale.x*i,l=e.scale.y*n,U.set(a.x-h,a.y-l,a.x+h,a.y+l),ja.instersects(U)&&(d(g.color.getContextStyle()),f(g.color.getContextStyle()),k.save(),k.translate(a.x,a.y),k.rotate(-e.rotation),k.scale(h,l),g.program(k),
k.restore()))}function q(a,e,f,g){b(g.opacity);c(g.blending);k.beginPath();k.moveTo(a.positionScreen.x,a.positionScreen.y);k.lineTo(e.positionScreen.x,e.positionScreen.y);k.closePath();if(g instanceof THREE.LineBasicMaterial){a=g.linewidth;if(y!=a)k.lineWidth=y=a;a=g.linecap;if(B!=a)k.lineCap=B=a;a=g.linejoin;if(o!=a)k.lineJoin=o=a;d(g.color.getContextStyle());k.stroke();U.inflate(g.linewidth*2)}}function s(a,d,e,f,h,k,i,j,n){g.data.vertices+=3;g.data.faces++;b(j.opacity);c(j.blending);I=a.positionScreen.x;
D=a.positionScreen.y;J=d.positionScreen.x;M=d.positionScreen.y;F=e.positionScreen.x;K=e.positionScreen.y;O(I,D,J,M,F,K);if(j instanceof THREE.MeshBasicMaterial)if(j.map)j.map.mapping instanceof THREE.UVMapping&&(aa=i.uvs[0],Ca(I,D,J,M,F,K,aa[f].u,aa[f].v,aa[h].u,aa[h].v,aa[k].u,aa[k].v,j.map));else if(j.envMap){if(j.envMap.mapping instanceof THREE.SphericalReflectionMapping)a=l.matrixWorldInverse,R.copy(i.vertexNormalsWorld[0]),Da=(R.x*a.n11+R.y*a.n12+R.z*a.n13)*0.5+0.5,Ea=-(R.x*a.n21+R.y*a.n22+R.z*
a.n23)*0.5+0.5,R.copy(i.vertexNormalsWorld[1]),Fa=(R.x*a.n11+R.y*a.n12+R.z*a.n13)*0.5+0.5,Ga=-(R.x*a.n21+R.y*a.n22+R.z*a.n23)*0.5+0.5,R.copy(i.vertexNormalsWorld[2]),Ha=(R.x*a.n11+R.y*a.n12+R.z*a.n13)*0.5+0.5,Ia=-(R.x*a.n21+R.y*a.n22+R.z*a.n23)*0.5+0.5,Ca(I,D,J,M,F,K,Da,Ea,Fa,Ga,Ha,Ia,j.envMap)}else j.wireframe?fa(j.color,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ga(j.color);else if(j instanceof THREE.MeshLambertMaterial)j.map&&!j.wireframe&&(j.map.mapping instanceof THREE.UVMapping&&
(aa=i.uvs[0],Ca(I,D,J,M,F,K,aa[f].u,aa[f].v,aa[h].u,aa[h].v,aa[k].u,aa[k].v,j.map)),c(THREE.SubtractiveBlending)),za?!j.wireframe&&j.shading==THREE.SmoothShading&&i.vertexNormalsWorld.length==3?(u.r=A.r=H.r=Y.r,u.g=A.g=H.g=Y.g,u.b=A.b=H.b=Y.b,m(n,i.v1.positionWorld,i.vertexNormalsWorld[0],u),m(n,i.v2.positionWorld,i.vertexNormalsWorld[1],A),m(n,i.v3.positionWorld,i.vertexNormalsWorld[2],H),S.r=(A.r+H.r)*0.5,S.g=(A.g+H.g)*0.5,S.b=(A.b+H.b)*0.5,W=wa(u,A,H,S),ma(I,D,J,M,F,K,0,0,1,0,0,1,W)):(ba.r=Y.r,
ba.g=Y.g,ba.b=Y.b,m(n,i.centroidWorld,i.normalWorld,ba),C.r=Math.max(0,Math.min(j.color.r*ba.r,1)),C.g=Math.max(0,Math.min(j.color.g*ba.g,1)),C.b=Math.max(0,Math.min(j.color.b*ba.b,1)),j.wireframe?fa(C,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ga(C)):j.wireframe?fa(j.color,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ga(j.color);else if(j instanceof THREE.MeshDepthMaterial)V=l.near,ca=l.far,u.r=u.g=u.b=1-ka(a.positionScreen.z,V,ca),A.r=A.g=A.b=1-ka(d.positionScreen.z,
V,ca),H.r=H.g=H.b=1-ka(e.positionScreen.z,V,ca),S.r=(A.r+H.r)*0.5,S.g=(A.g+H.g)*0.5,S.b=(A.b+H.b)*0.5,W=wa(u,A,H,S),ma(I,D,J,M,F,K,0,0,1,0,0,1,W);else if(j instanceof THREE.MeshNormalMaterial)C.r=na(i.normalWorld.x),C.g=na(i.normalWorld.y),C.b=na(i.normalWorld.z),j.wireframe?fa(C,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ga(C)}function v(a,d,e,f,h,j,i,k,n){g.data.vertices+=4;g.data.faces++;b(k.opacity);c(k.blending);if(k.map||k.envMap)s(a,d,f,0,1,3,i,k,n),s(h,e,j,1,2,3,i,k,n);else if(I=
a.positionScreen.x,D=a.positionScreen.y,J=d.positionScreen.x,M=d.positionScreen.y,F=e.positionScreen.x,K=e.positionScreen.y,G=f.positionScreen.x,Q=f.positionScreen.y,w=h.positionScreen.x,N=h.positionScreen.y,L=j.positionScreen.x,pa=j.positionScreen.y,k instanceof THREE.MeshBasicMaterial)P(I,D,J,M,F,K,G,Q),k.wireframe?fa(k.color,k.wireframeLinewidth,k.wireframeLinecap,k.wireframeLinejoin):ga(k.color);else if(k instanceof THREE.MeshLambertMaterial)za?!k.wireframe&&k.shading==THREE.SmoothShading&&i.vertexNormalsWorld.length==
4?(u.r=A.r=H.r=S.r=Y.r,u.g=A.g=H.g=S.g=Y.g,u.b=A.b=H.b=S.b=Y.b,m(n,i.v1.positionWorld,i.vertexNormalsWorld[0],u),m(n,i.v2.positionWorld,i.vertexNormalsWorld[1],A),m(n,i.v4.positionWorld,i.vertexNormalsWorld[3],H),m(n,i.v3.positionWorld,i.vertexNormalsWorld[2],S),W=wa(u,A,H,S),O(I,D,J,M,G,Q),ma(I,D,J,M,G,Q,0,0,1,0,0,1,W),O(w,N,F,K,L,pa),ma(w,N,F,K,L,pa,1,0,1,1,0,1,W)):(ba.r=Y.r,ba.g=Y.g,ba.b=Y.b,m(n,i.centroidWorld,i.normalWorld,ba),C.r=Math.max(0,Math.min(k.color.r*ba.r,1)),C.g=Math.max(0,Math.min(k.color.g*
ba.g,1)),C.b=Math.max(0,Math.min(k.color.b*ba.b,1)),P(I,D,J,M,F,K,G,Q),k.wireframe?fa(C,k.wireframeLinewidth,k.wireframeLinecap,k.wireframeLinejoin):ga(C)):(P(I,D,J,M,F,K,G,Q),k.wireframe?fa(k.color,k.wireframeLinewidth,k.wireframeLinecap,k.wireframeLinejoin):ga(k.color));else if(k instanceof THREE.MeshNormalMaterial)C.r=na(i.normalWorld.x),C.g=na(i.normalWorld.y),C.b=na(i.normalWorld.z),P(I,D,J,M,F,K,G,Q),k.wireframe?fa(C,k.wireframeLinewidth,k.wireframeLinecap,k.wireframeLinejoin):ga(C);else if(k instanceof
THREE.MeshDepthMaterial)V=l.near,ca=l.far,u.r=u.g=u.b=1-ka(a.positionScreen.z,V,ca),A.r=A.g=A.b=1-ka(d.positionScreen.z,V,ca),H.r=H.g=H.b=1-ka(f.positionScreen.z,V,ca),S.r=S.g=S.b=1-ka(e.positionScreen.z,V,ca),W=wa(u,A,H,S),O(I,D,J,M,G,Q),ma(I,D,J,M,G,Q,0,0,1,0,0,1,W),O(w,N,F,K,L,pa),ma(w,N,F,K,L,pa,1,0,1,1,0,1,W)}function O(a,b,c,d,e,f){k.beginPath();k.moveTo(a,b);k.lineTo(c,d);k.lineTo(e,f);k.lineTo(a,b);k.closePath()}function P(a,b,c,d,e,f,g,h){k.beginPath();k.moveTo(a,b);k.lineTo(c,d);k.lineTo(e,
f);k.lineTo(g,h);k.lineTo(a,b);k.closePath()}function fa(a,b,c,e){if(y!=b)k.lineWidth=y=b;if(B!=c)k.lineCap=B=c;if(o!=e)k.lineJoin=o=e;d(a.getContextStyle());k.stroke();U.inflate(b*2)}function ga(a){f(a.getContextStyle());k.fill()}function Ca(a,b,c,d,e,g,h,j,i,l,m,n,o){if(o.image.width!=0){if(o.needsUpdate==!0||la[o.id]==void 0){var p=o.wrapS==THREE.RepeatWrapping,q=o.wrapT==THREE.RepeatWrapping;la[o.id]=k.createPattern(o.image,p&&q?"repeat":p&&!q?"repeat-x":!p&&q?"repeat-y":"no-repeat");o.needsUpdate=
!1}f(la[o.id]);var p=o.offset.x/o.repeat.x,q=o.offset.y/o.repeat.y,r=(o.image.width-1)*o.repeat.x,o=(o.image.height-1)*o.repeat.y,h=(h+p)*r,j=(j+q)*o,i=(i+p)*r,l=(l+q)*o,m=(m+p)*r,n=(n+q)*o;c-=a;d-=b;e-=a;g-=b;i-=h;l-=j;m-=h;n-=j;p=1/(i*n-m*l);o=(n*c-l*e)*p;l=(n*d-l*g)*p;c=(i*e-m*c)*p;d=(i*g-m*d)*p;a=a-o*h-c*j;b=b-l*h-d*j;k.save();k.transform(o,l,c,d,a,b);k.fill();k.restore()}}function ma(a,b,c,d,e,f,g,h,j,i,l,m,n){var o,p;o=n.width-1;p=n.height-1;g*=o;h*=p;j*=o;i*=p;l*=o;m*=p;c-=a;d-=b;e-=a;f-=b;
j-=g;i-=h;l-=g;m-=h;p=1/(j*m-l*i);o=(m*c-i*e)*p;i=(m*d-i*f)*p;c=(j*e-l*c)*p;d=(j*f-l*d)*p;a=a-o*g-c*h;b=b-i*g-d*h;k.save();k.transform(o,i,c,d,a,b);k.clip();k.drawImage(n,0,0);k.restore()}function wa(a,b,c,d){var e=~~(a.r*255),f=~~(a.g*255),a=~~(a.b*255),g=~~(b.r*255),h=~~(b.g*255),b=~~(b.b*255),i=~~(c.r*255),j=~~(c.g*255),c=~~(c.b*255),k=~~(d.r*255),l=~~(d.g*255),d=~~(d.b*255);da[0]=e<0?0:e>255?255:e;da[1]=f<0?0:f>255?255:f;da[2]=a<0?0:a>255?255:a;da[4]=g<0?0:g>255?255:g;da[5]=h<0?0:h>255?255:h;
da[6]=b<0?0:b>255?255:b;da[8]=i<0?0:i>255?255:i;da[9]=j<0?0:j>255?255:j;da[10]=c<0?0:c>255?255:c;da[12]=k<0?0:k>255?255:k;da[13]=l<0?0:l>255?255:l;da[14]=d<0?0:d>255?255:d;ra.putImageData(Aa,0,0);va.drawImage(qa,0,0);return sa}function ka(a,b,c){a=(a-b)/(c-b);return a*a*(3-2*a)}function na(a){a=(a+1)*0.5;return a<0?0:a>1?1:a}function ha(a,b){var c=b.x-a.x,d=b.y-a.y,e=c*c+d*d;e!=0&&(e=1/Math.sqrt(e),c*=e,d*=e,b.x+=c,b.y+=d,a.x-=c,a.y-=d)}var xa,Ja,z,ea,ia,oa,ya,T;this.autoClear?this.clear():k.setTransform(1,
0,0,-1,i,n);g.data.vertices=0;g.data.faces=0;e=h.projectScene(a,l,this.sortElements);(za=a.lights.length>0)&&j(a);xa=0;for(Ja=e.length;xa<Ja;xa++){z=e[xa];U.empty();if(z instanceof THREE.RenderableParticle){t=z;t.x*=i;t.y*=n;ea=0;for(ia=z.materials.length;ea<ia;)T=z.materials[ea++],T.opacity!=0&&p(t,z,T,a)}else if(z instanceof THREE.RenderableLine){if(t=z.v1,r=z.v2,t.positionScreen.x*=i,t.positionScreen.y*=n,r.positionScreen.x*=i,r.positionScreen.y*=n,U.addPoint(t.positionScreen.x,t.positionScreen.y),
U.addPoint(r.positionScreen.x,r.positionScreen.y),ja.instersects(U)){ea=0;for(ia=z.materials.length;ea<ia;)T=z.materials[ea++],T.opacity!=0&&q(t,r,z,T,a)}}else if(z instanceof THREE.RenderableFace3){if(t=z.v1,r=z.v2,x=z.v3,t.positionScreen.x*=i,t.positionScreen.y*=n,r.positionScreen.x*=i,r.positionScreen.y*=n,x.positionScreen.x*=i,x.positionScreen.y*=n,z.overdraw&&(ha(t.positionScreen,r.positionScreen),ha(r.positionScreen,x.positionScreen),ha(x.positionScreen,t.positionScreen)),U.add3Points(t.positionScreen.x,
t.positionScreen.y,r.positionScreen.x,r.positionScreen.y,x.positionScreen.x,x.positionScreen.y),ja.instersects(U)){ea=0;for(ia=z.meshMaterials.length;ea<ia;)if(T=z.meshMaterials[ea++],T instanceof THREE.MeshFaceMaterial){oa=0;for(ya=z.faceMaterials.length;oa<ya;)(T=z.faceMaterials[oa++])&&T.opacity!=0&&s(t,r,x,0,1,2,z,T,a)}else T.opacity!=0&&s(t,r,x,0,1,2,z,T,a)}}else if(z instanceof THREE.RenderableFace4&&(t=z.v1,r=z.v2,x=z.v3,E=z.v4,t.positionScreen.x*=i,t.positionScreen.y*=n,r.positionScreen.x*=
i,r.positionScreen.y*=n,x.positionScreen.x*=i,x.positionScreen.y*=n,E.positionScreen.x*=i,E.positionScreen.y*=n,Z.positionScreen.copy(r.positionScreen),$.positionScreen.copy(E.positionScreen),z.overdraw&&(ha(t.positionScreen,r.positionScreen),ha(r.positionScreen,E.positionScreen),ha(E.positionScreen,t.positionScreen),ha(x.positionScreen,Z.positionScreen),ha(x.positionScreen,$.positionScreen)),U.addPoint(t.positionScreen.x,t.positionScreen.y),U.addPoint(r.positionScreen.x,r.positionScreen.y),U.addPoint(x.positionScreen.x,
x.positionScreen.y),U.addPoint(E.positionScreen.x,E.positionScreen.y),ja.instersects(U))){ea=0;for(ia=z.meshMaterials.length;ea<ia;)if(T=z.meshMaterials[ea++],T instanceof THREE.MeshFaceMaterial){oa=0;for(ya=z.faceMaterials.length;oa<ya;)(T=z.faceMaterials[oa++])&&T.opacity!=0&&v(t,r,x,E,Z,$,z,T,a)}else T.opacity!=0&&v(t,r,x,E,Z,$,z,T,a)}X.addRectangle(U)}k.setTransform(1,0,0,1,0,0)}};
THREE.RenderableVertex=function(){this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.visible=!0};THREE.RenderableVertex.prototype.copy=function(a){this.positionWorld.copy(a.positionWorld);this.positionScreen.copy(a.positionScreen)};
THREE.RenderableFace3=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableFace4=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.v4=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableObject=function(){this.z=this.object=null};THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.materials=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.materials=null};
